/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.hc.core5.reactor.ssl;

import connectjar.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import connectjar.org.apache.hc.core5.util.Args;
import java.nio.ByteBuffer;

abstract class SSLManagedBuffer {
    SSLManagedBuffer() {
    }

    abstract ByteBuffer acquire();

    abstract void release();

    abstract boolean isAcquired();

    abstract boolean hasData();

    abstract void ensureWriteable(int var1);

    ByteBuffer ensureWriteable(ByteBuffer src, int size) {
        if (src == null) {
            return null;
        }
        if (src.remaining() < size) {
            int additionalCapacityNeeded = size - src.remaining();
            ByteBuffer expanded = ByteBuffer.allocate(src.capacity() + additionalCapacityNeeded);
            ByteBuffer tmp = src.duplicate();
            tmp.flip();
            expanded.put(tmp);
            return expanded;
        }
        return src;
    }

    static SSLManagedBuffer create(SSLBufferMode mode, int size) {
        return mode == SSLBufferMode.DYNAMIC ? new DynamicBuffer(size) : new StaticBuffer(size);
    }

    static final class DynamicBuffer
    extends SSLManagedBuffer {
        private ByteBuffer wrapped;
        private final int length;

        public DynamicBuffer(int size) {
            Args.positive(size, "size");
            this.length = size;
        }

        @Override
        public ByteBuffer acquire() {
            if (this.wrapped != null) {
                return this.wrapped;
            }
            this.wrapped = ByteBuffer.allocate(this.length);
            return this.wrapped;
        }

        @Override
        public void release() {
            this.wrapped = null;
        }

        @Override
        public boolean isAcquired() {
            return this.wrapped != null;
        }

        @Override
        public boolean hasData() {
            return this.wrapped != null && this.wrapped.position() > 0;
        }

        @Override
        void ensureWriteable(int size) {
            this.wrapped = this.ensureWriteable(this.wrapped, size);
        }
    }

    static final class StaticBuffer
    extends SSLManagedBuffer {
        private ByteBuffer buffer;

        public StaticBuffer(int size) {
            Args.positive(size, "size");
            this.buffer = ByteBuffer.allocate(size);
        }

        @Override
        public ByteBuffer acquire() {
            return this.buffer;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isAcquired() {
            return true;
        }

        @Override
        public boolean hasData() {
            return this.buffer.position() > 0;
        }

        @Override
        void ensureWriteable(int size) {
            this.buffer = this.ensureWriteable(this.buffer, size);
        }
    }
}

