/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.httpclient.impl;

import connectjar.org.apache.hc.client5.http.config.RequestConfig;
import connectjar.org.apache.hc.core5.http.HttpHost;
import connectjar.org.apache.hc.core5.util.Timeout;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.function.BiConsumer;

public enum RequestConfigOption {
    AUTHENTICATION_ENABLED("authentication-enabled", (builder, value) -> builder.setAuthenticationEnabled((Boolean)value)),
    CIRCULAR_REDIRECTS_ALLOWED("circular-redirects-allowed", (builder, value) -> builder.setCircularRedirectsAllowed((Boolean)value)),
    CONNECTION_TIMEOUT("connection-timeout", (builder, value) -> builder.setConnectTimeout(RequestConfigOption.toTimeout(value))),
    CONNECTION_KEEP_ALIVE("connection-keep-alive", (builder, value) -> builder.setConnectionKeepAlive(RequestConfigOption.toTimeout(value))),
    CONNECTION_REQUEST_TIMEOUT("connection-request-timeout", (builder, value) -> builder.setConnectionRequestTimeout(RequestConfigOption.toTimeout(value))),
    CONTENT_COMPRESSION_ENABLED("content-compression-enabled", (builder, value) -> builder.setContentCompressionEnabled((Boolean)value)),
    COOKIE_SPEC("cookie-spec", (builder, value) -> builder.setCookieSpec((String)value)),
    EXPECT_CONTINUE_ENABLED("expect-continue-enabled", (builder, value) -> builder.setExpectContinueEnabled((Boolean)value)),
    HARD_CANCELLATION_ENABLED("hard-cancellation-enabled", (builder, value) -> builder.setHardCancellationEnabled((Boolean)value)),
    MAX_REDIRECTS("max-redirects", (builder, value) -> builder.setMaxRedirects((Integer)value)),
    PROXY("proxy", (builder, value) -> builder.setProxy(RequestConfigOption.toHttpHost(value))),
    PROXY_PREFERRED_AUTH_SCHEMES("proxy-preferred-auth-scheme", (builder, value) -> builder.setProxyPreferredAuthSchemes((Collection)value)),
    REDIRECTS_ENABLED("redirects-enabled", (builder, value) -> builder.setRedirectsEnabled((Boolean)value)),
    RESPONSE_TIMEOUT("response-timeout", (builder, value) -> builder.setResponseTimeout(RequestConfigOption.toTimeout(value))),
    TARGET_PREFERRED_AUTH_SCHEMES("target-preferred-auth-schemes", (builder, value) -> builder.setTargetPreferredAuthSchemes((Collection)value));

    private final String name;
    private final BiConsumer<RequestConfig.Builder, Object> consumer;

    private RequestConfigOption(String name, BiConsumer<RequestConfig.Builder, Object> consumer) {
        this.name = name;
        this.consumer = consumer;
    }

    public String getName() {
        return this.name;
    }

    public void apply(RequestConfig.Builder configBuilder, Object value) {
        this.consumer.accept(configBuilder, value);
    }

    private static Timeout toTimeout(Object value) {
        if (value instanceof Timeout) {
            Timeout timeout = (Timeout)value;
            return timeout;
        }
        if (value instanceof Integer) {
            Integer millis = (Integer)value;
            if (millis > 0) {
                return Timeout.ofMilliseconds(millis.intValue());
            }
            return Timeout.DISABLED;
        }
        if (value instanceof String) {
            String str = (String)value;
            return RequestConfigOption.toTimeout(Integer.parseInt(str));
        }
        throw new IllegalArgumentException("Expected Timeout or Integer, got " + value.getClass().getSimpleName());
    }

    private static HttpHost toHttpHost(Object value) {
        if (value instanceof HttpHost) {
            HttpHost host = (HttpHost)value;
            return host;
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return HttpHost.create(str);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(str, e);
            }
        }
        if (value instanceof URI) {
            URI uri = (URI)value;
            return HttpHost.create(uri);
        }
        throw new IllegalArgumentException("Expected HttpHost or String, got " + value.getClass().getSimpleName());
    }
}

