/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.jupiter.api.ClassOrderer;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDirFactory;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.EnumConfigurationParameterConverter;
import org.junit.jupiter.engine.config.InstantiatingConfigurationParameterConverter;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.util.ClassNamePatternFilterUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.OutputDirectoryCreator;

@API(status=API.Status.INTERNAL, since="5.4")
public class DefaultJupiterConfiguration
implements JupiterConfiguration {
    private static final EnumConfigurationParameterConverter<ExecutionMode> executionModeConverter = new EnumConfigurationParameterConverter<ExecutionMode>(ExecutionMode.class, "parallel execution mode");
    private static final EnumConfigurationParameterConverter<TestInstance.Lifecycle> lifecycleConverter = new EnumConfigurationParameterConverter<TestInstance.Lifecycle>(TestInstance.Lifecycle.class, "test instance lifecycle mode");
    private static final InstantiatingConfigurationParameterConverter<DisplayNameGenerator> displayNameGeneratorConverter = new InstantiatingConfigurationParameterConverter<DisplayNameGenerator>(DisplayNameGenerator.class, "display name generator");
    private static final InstantiatingConfigurationParameterConverter<MethodOrderer> methodOrdererConverter = new InstantiatingConfigurationParameterConverter<MethodOrderer>(MethodOrderer.class, "method orderer");
    private static final InstantiatingConfigurationParameterConverter<ClassOrderer> classOrdererConverter = new InstantiatingConfigurationParameterConverter<ClassOrderer>(ClassOrderer.class, "class orderer");
    private static final EnumConfigurationParameterConverter<CleanupMode> cleanupModeConverter = new EnumConfigurationParameterConverter<CleanupMode>(CleanupMode.class, "cleanup mode");
    private static final InstantiatingConfigurationParameterConverter<TempDirFactory> tempDirFactoryConverter = new InstantiatingConfigurationParameterConverter<TempDirFactory>(TempDirFactory.class, "temp dir factory");
    private static final EnumConfigurationParameterConverter<TestInstantiationAwareExtension.ExtensionContextScope> extensionContextScopeConverter = new EnumConfigurationParameterConverter<TestInstantiationAwareExtension.ExtensionContextScope>(TestInstantiationAwareExtension.ExtensionContextScope.class, "extension context scope");
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryCreator outputDirectoryCreator;

    public DefaultJupiterConfiguration(ConfigurationParameters configurationParameters, OutputDirectoryCreator outputDirectoryCreator) {
        this.configurationParameters = Preconditions.notNull(configurationParameters, "ConfigurationParameters must not be null");
        this.outputDirectoryCreator = outputDirectoryCreator;
    }

    @Override
    public Predicate<Class<? extends Extension>> getFilterForAutoDetectedExtensions() {
        String includePattern = this.getExtensionAutoDetectionIncludePattern();
        String excludePattern = this.getExtensionAutoDetectionExcludePattern();
        Predicate<String> predicate = ClassNamePatternFilterUtils.includeMatchingClassNames(includePattern).and(ClassNamePatternFilterUtils.excludeMatchingClassNames(excludePattern));
        return clazz -> predicate.test(clazz.getName());
    }

    private String getExtensionAutoDetectionIncludePattern() {
        return this.configurationParameters.get("junit.jupiter.extensions.autodetection.include").orElse("*");
    }

    private String getExtensionAutoDetectionExcludePattern() {
        return this.configurationParameters.get("junit.jupiter.extensions.autodetection.exclude").orElse("");
    }

    @Override
    public Optional<String> getRawConfigurationParameter(String key) {
        return this.configurationParameters.get(key);
    }

    @Override
    public <T> Optional<T> getRawConfigurationParameter(String key, Function<String, T> transformer) {
        return this.configurationParameters.get(key, transformer);
    }

    @Override
    public boolean isParallelExecutionEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.execution.parallel.enabled").orElse(false);
    }

    @Override
    public boolean isClosingStoredAutoCloseablesEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.extensions.store.close.autocloseable.enabled").orElse(true);
    }

    @Override
    public boolean isExtensionAutoDetectionEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.extensions.autodetection.enabled").orElse(false);
    }

    @Override
    public boolean isThreadDumpOnTimeoutEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.execution.timeout.threaddump.enabled").orElse(false);
    }

    @Override
    public ExecutionMode getDefaultExecutionMode() {
        return executionModeConverter.get(this.configurationParameters, "junit.jupiter.execution.parallel.mode.default", ExecutionMode.SAME_THREAD);
    }

    @Override
    public ExecutionMode getDefaultClassesExecutionMode() {
        return executionModeConverter.get(this.configurationParameters, "junit.jupiter.execution.parallel.mode.classes.default", this.getDefaultExecutionMode());
    }

    @Override
    public TestInstance.Lifecycle getDefaultTestInstanceLifecycle() {
        return lifecycleConverter.get(this.configurationParameters, "junit.jupiter.testinstance.lifecycle.default", TestInstance.Lifecycle.PER_METHOD);
    }

    @Override
    public Predicate<ExecutionCondition> getExecutionConditionFilter() {
        return ClassNamePatternFilterUtils.excludeMatchingClasses(this.configurationParameters.get("junit.jupiter.conditions.deactivate").orElse(null));
    }

    @Override
    public DisplayNameGenerator getDefaultDisplayNameGenerator() {
        return displayNameGeneratorConverter.get(this.configurationParameters, "junit.jupiter.displayname.generator.default").orElseGet(() -> DisplayNameGenerator.getDisplayNameGenerator(DisplayNameGenerator.Standard.class));
    }

    @Override
    public Optional<MethodOrderer> getDefaultTestMethodOrderer() {
        return methodOrdererConverter.get(this.configurationParameters, "junit.jupiter.testmethod.order.default");
    }

    @Override
    public Optional<ClassOrderer> getDefaultTestClassOrderer() {
        return classOrdererConverter.get(this.configurationParameters, "junit.jupiter.testclass.order.default");
    }

    @Override
    public CleanupMode getDefaultTempDirCleanupMode() {
        return cleanupModeConverter.get(this.configurationParameters, "junit.jupiter.tempdir.cleanup.mode.default", CleanupMode.ALWAYS);
    }

    @Override
    public Supplier<TempDirFactory> getDefaultTempDirFactorySupplier() {
        Supplier<Optional<TempDirFactory>> supplier = tempDirFactoryConverter.supply(this.configurationParameters, "junit.jupiter.tempdir.factory.default");
        return () -> ((Optional)supplier.get()).orElse(TempDirFactory.Standard.INSTANCE);
    }

    @Override
    public TestInstantiationAwareExtension.ExtensionContextScope getDefaultTestInstantiationExtensionContextScope() {
        return extensionContextScopeConverter.get(this.configurationParameters, "junit.jupiter.extensions.testinstantiation.extensioncontextscope.default", TestInstantiationAwareExtension.ExtensionContextScope.DEFAULT);
    }

    @Override
    public OutputDirectoryCreator getOutputDirectoryCreator() {
        return this.outputDirectoryCreator;
    }
}

