/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.params.AfterParameterizedClassInvocation;
import org.junit.jupiter.params.ArgumentCountValidationMode;
import org.junit.jupiter.params.ArgumentSetLifecycleMethod;
import org.junit.jupiter.params.BeforeParameterizedClassInvocation;
import org.junit.jupiter.params.Parameter;
import org.junit.jupiter.params.ParameterizedClass;
import org.junit.jupiter.params.ParameterizedClassInvocationContext;
import org.junit.jupiter.params.ParameterizedDeclarationContext;
import org.junit.jupiter.params.ParameterizedInvocationNameFormatter;
import org.junit.jupiter.params.ResolverFacade;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class ParameterizedClassContext
implements ParameterizedDeclarationContext<ClassTemplateInvocationContext> {
    private final Class<?> testClass;
    private final ParameterizedClass annotation;
    private final TestInstance.Lifecycle testInstanceLifecycle;
    private final ResolverFacade resolverFacade;
    private final InjectionType injectionType;
    private final List<ArgumentSetLifecycleMethod> beforeMethods;
    private final List<ArgumentSetLifecycleMethod> afterMethods;

    ParameterizedClassContext(Class<?> testClass, ParameterizedClass annotation, TestInstance.Lifecycle testInstanceLifecycle) {
        this.testClass = testClass;
        this.annotation = annotation;
        this.testInstanceLifecycle = testInstanceLifecycle;
        List<Field> fields = ParameterizedClassContext.findParameterAnnotatedFields(testClass);
        if (fields.isEmpty()) {
            this.resolverFacade = ResolverFacade.create(ReflectionUtils.getDeclaredConstructor(testClass), annotation);
            this.injectionType = InjectionType.CONSTRUCTOR;
        } else {
            this.resolverFacade = ResolverFacade.create(testClass, fields);
            this.injectionType = InjectionType.FIELDS;
        }
        this.beforeMethods = ParameterizedClassContext.findLifecycleMethodsAndAssertStaticAndNonPrivate(testClass, testInstanceLifecycle, HierarchyTraversalMode.TOP_DOWN, BeforeParameterizedClassInvocation.class, BeforeParameterizedClassInvocation::injectArguments, this.resolverFacade);
        this.afterMethods = new ArrayList<ArgumentSetLifecycleMethod>(ParameterizedClassContext.findLifecycleMethodsAndAssertStaticAndNonPrivate(testClass, testInstanceLifecycle, HierarchyTraversalMode.BOTTOM_UP, AfterParameterizedClassInvocation.class, AfterParameterizedClassInvocation::injectArguments, this.resolverFacade));
        Collections.reverse(this.afterMethods);
    }

    private static List<Field> findParameterAnnotatedFields(Class<?> clazz) {
        if (ReflectionUtils.isRecordClass(clazz)) {
            return Collections.emptyList();
        }
        return ReflectionSupport.findFields(clazz, it -> AnnotationSupport.isAnnotated(it, Parameter.class), HierarchyTraversalMode.BOTTOM_UP);
    }

    @Override
    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public ParameterizedClass getAnnotation() {
        return this.annotation;
    }

    @Override
    public Class<?> getAnnotatedElement() {
        return this.testClass;
    }

    @Override
    public String getDisplayNamePattern() {
        return this.annotation.name();
    }

    @Override
    public boolean isAutoClosingArguments() {
        return this.annotation.autoCloseArguments();
    }

    @Override
    public boolean isAllowingZeroInvocations() {
        return this.annotation.allowZeroInvocations();
    }

    @Override
    public ArgumentCountValidationMode getArgumentCountValidationMode() {
        return this.annotation.argumentCountValidation();
    }

    @Override
    public ResolverFacade getResolverFacade() {
        return this.resolverFacade;
    }

    @Override
    public ClassTemplateInvocationContext createInvocationContext(ParameterizedInvocationNameFormatter formatter, Arguments arguments, int invocationIndex) {
        return new ParameterizedClassInvocationContext(this, formatter, arguments, invocationIndex);
    }

    TestInstance.Lifecycle getTestInstanceLifecycle() {
        return this.testInstanceLifecycle;
    }

    InjectionType getInjectionType() {
        return this.injectionType;
    }

    List<ArgumentSetLifecycleMethod> getBeforeMethods() {
        return this.beforeMethods;
    }

    List<ArgumentSetLifecycleMethod> getAfterMethods() {
        return this.afterMethods;
    }

    private static <A extends Annotation> List<ArgumentSetLifecycleMethod> findLifecycleMethodsAndAssertStaticAndNonPrivate(Class<?> testClass, TestInstance.Lifecycle testInstanceLifecycle, HierarchyTraversalMode traversalMode, Class<A> annotationType, Predicate<A> injectArgumentsPredicate, ResolverFacade resolverFacade) {
        List<Method> methods = AnnotationSupport.findAnnotatedMethods(testClass, annotationType, traversalMode);
        return methods.stream().filter(ModifierSupport::isNotPrivate).filter(testInstanceLifecycle == TestInstance.Lifecycle.PER_METHOD ? ModifierSupport::isStatic : __ -> true).filter(ReflectionUtils::returnsPrimitiveVoid).map(method -> {
            Object annotation = ParameterizedClassContext.getAnnotation(method, annotationType);
            if (injectArgumentsPredicate.test(annotation)) {
                return new ArgumentSetLifecycleMethod((Method)method, resolverFacade.createLifecycleMethodParameterResolver((Method)method, (Annotation)annotation));
            }
            return new ArgumentSetLifecycleMethod((Method)method);
        }).collect(CollectionUtils.toUnmodifiableList());
    }

    private static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        return (A)((Annotation)AnnotationSupport.findAnnotation(method, annotationType).orElseThrow(() -> new JUnitException("Method not annotated with @" + annotationType.getSimpleName())));
    }

    static enum InjectionType {
        CONSTRUCTOR,
        FIELDS;

    }
}

