/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.io.Resource;
import org.junit.platform.commons.io.ResourceFilter;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.1")
public class ModuleUtils {
    private static final Logger logger = LoggerFactory.getLogger(ModuleUtils.class);

    public static Set<String> findAllNonSystemBootModuleNames() {
        Set systemModules = ModuleFinder.ofSystem().findAll().stream().map(reference -> reference.descriptor().name()).collect(Collectors.toSet());
        return ModuleUtils.streamResolvedModules((T name) -> !systemModules.contains(name)).map(ResolvedModule::name).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean isJavaPlatformModuleSystemAvailable() {
        return true;
    }

    public static Optional<String> getModuleName(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        return Optional.ofNullable(type.getModule().getName());
    }

    public static Optional<String> getModuleVersion(Class<?> type) {
        Preconditions.notNull(type, "Class type must not be null");
        Module module = type.getModule();
        return module.isNamed() ? module.getDescriptor().rawVersion() : Optional.empty();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Class filter must not be null");
        logger.debug(() -> "Looking for classes in module: " + moduleName);
        Set moduleReferences = ModuleUtils.streamResolvedModules(Predicate.isEqual(moduleName)).map(ResolvedModule::reference).collect(Collectors.toSet());
        return ModuleUtils.scan(moduleReferences, (ClassFilter)filter, (ClassLoader)ModuleUtils.class.getClassLoader());
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static List<Resource> findAllResourcesInModule(String moduleName, ResourceFilter filter) {
        Preconditions.notBlank(moduleName, "Module name must not be null or empty");
        Preconditions.notNull(filter, "Resource filter must not be null");
        logger.debug(() -> "Looking for classes in module: " + moduleName);
        Set moduleReferences = ModuleUtils.streamResolvedModules(Predicate.isEqual(moduleName)).map(ResolvedModule::reference).collect(Collectors.toSet());
        return ModuleUtils.scan(moduleReferences, (ResourceFilter)filter, (ClassLoader)ModuleUtils.class.getClassLoader());
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate) {
        Module module = ModuleUtils.class.getModule();
        ModuleLayer layer = module.getLayer();
        if (layer == null) {
            logger.config(() -> String.valueOf(ModuleUtils.class) + " is a member of " + String.valueOf(module) + " - using boot layer returned by ModuleLayer.boot() as fall-back.");
            layer = ModuleLayer.boot();
        }
        return ModuleUtils.streamResolvedModules(moduleNamePredicate, (ModuleLayer)layer);
    }

    private static Stream<ResolvedModule> streamResolvedModules(Predicate<String> moduleNamePredicate, ModuleLayer layer) {
        logger.debug(() -> "Streaming modules for layer @" + System.identityHashCode(layer) + ": " + String.valueOf(layer));
        Configuration configuration = layer.configuration();
        logger.debug(() -> "Module layer configuration: " + String.valueOf(configuration));
        Stream stream = configuration.modules().stream();
        return stream.filter(module -> moduleNamePredicate.test(module.name()));
    }

    private static List<Class<?>> scan(Set<ModuleReference> references, ClassFilter filter, ClassLoader loader) {
        logger.debug(() -> "Scanning " + references.size() + " module references: " + String.valueOf(references));
        ModuleReferenceClassScanner scanner = new ModuleReferenceClassScanner(filter, loader);
        ArrayList classes = new ArrayList();
        for (ModuleReference reference : references) {
            classes.addAll(scanner.scan(reference));
        }
        logger.debug(() -> "Found " + classes.size() + " classes: " + String.valueOf(classes));
        return Collections.unmodifiableList(classes);
    }

    private static List<Resource> scan(Set<ModuleReference> references, ResourceFilter filter, ClassLoader loader) {
        logger.debug(() -> "Scanning " + references.size() + " module references: " + String.valueOf(references));
        ModuleReferenceResourceScanner scanner = new ModuleReferenceResourceScanner(filter, loader);
        ArrayList classes = new ArrayList();
        for (ModuleReference reference : references) {
            classes.addAll(scanner.scan(reference));
        }
        logger.debug(() -> "Found " + classes.size() + " classes: " + String.valueOf(classes));
        return Collections.unmodifiableList(classes);
    }
}

