/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.variable.impl.type;

import io.openbpm.bpm.engine.variable.Variables;
import io.openbpm.bpm.engine.variable.impl.type.AbstractValueTypeImpl;
import io.openbpm.bpm.engine.variable.impl.value.PrimitiveTypeValueImpl;
import io.openbpm.bpm.engine.variable.type.PrimitiveValueType;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.BooleanValue;
import io.openbpm.bpm.engine.variable.value.BytesValue;
import io.openbpm.bpm.engine.variable.value.DateValue;
import io.openbpm.bpm.engine.variable.value.DoubleValue;
import io.openbpm.bpm.engine.variable.value.IntegerValue;
import io.openbpm.bpm.engine.variable.value.LongValue;
import io.openbpm.bpm.engine.variable.value.NumberValue;
import io.openbpm.bpm.engine.variable.value.ShortValue;
import io.openbpm.bpm.engine.variable.value.StringValue;
import io.openbpm.bpm.engine.variable.value.TypedValue;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.NullType;

public abstract class PrimitiveValueTypeImpl
extends AbstractValueTypeImpl
implements PrimitiveValueType {
    private static final long serialVersionUID = 1L;
    protected Class<?> javaType;

    protected PrimitiveValueTypeImpl(Class<?> javaType) {
        this(javaType.getSimpleName().toLowerCase(), javaType);
    }

    protected PrimitiveValueTypeImpl(String name, Class<?> javaType) {
        super(name);
        this.javaType = javaType;
    }

    @Override
    public Class<?> getJavaType() {
        return this.javaType;
    }

    @Override
    public boolean isPrimitiveValueType() {
        return true;
    }

    @Override
    public String toString() {
        return "PrimitiveValueType[" + this.getName() + "]";
    }

    @Override
    public Map<String, Object> getValueInfo(TypedValue typedValue) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (typedValue.isTransient()) {
            result.put("transient", typedValue.isTransient());
        }
        return result;
    }

    public static class NumberTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public NumberTypeImpl() {
            super(Number.class);
        }

        @Override
        public NumberValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.numberValue((Number)value, this.isTransient(valueInfo));
        }

        @Override
        public boolean isAbstract() {
            return true;
        }
    }

    public static class StringTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public StringTypeImpl() {
            super(String.class);
        }

        @Override
        public StringValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.stringValue((String)value, this.isTransient(valueInfo));
        }
    }

    public static class ShortTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public ShortTypeImpl() {
            super(Short.class);
        }

        @Override
        public ShortValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.shortValue((Short)value, this.isTransient(valueInfo));
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public ShortValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            PrimitiveTypeValueImpl.ShortValueImpl shortValue = null;
            NumberValue numberValue = (NumberValue)typedValue;
            shortValue = numberValue.getValue() != null ? (PrimitiveTypeValueImpl.ShortValueImpl)Variables.shortValue(((Number)numberValue.getValue()).shortValue()) : (PrimitiveTypeValueImpl.ShortValueImpl)Variables.shortValue(null);
            shortValue.setTransient(numberValue.isTransient());
            return shortValue;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).shortValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class NullTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public NullTypeImpl() {
            super("null", NullType.class);
        }

        @Override
        public TypedValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.untypedNullValue(this.isTransient(valueInfo));
        }
    }

    public static class LongTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public LongTypeImpl() {
            super(Long.class);
        }

        @Override
        public LongValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.longValue((Long)value, this.isTransient(valueInfo));
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).longValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public LongValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            PrimitiveTypeValueImpl.LongValueImpl longvalue = null;
            NumberValue numberValue = (NumberValue)typedValue;
            longvalue = numberValue.getValue() != null ? (PrimitiveTypeValueImpl.LongValueImpl)Variables.longValue(((Number)numberValue.getValue()).longValue()) : (PrimitiveTypeValueImpl.LongValueImpl)Variables.longValue(null);
            longvalue.setTransient(numberValue.isTransient());
            return longvalue;
        }
    }

    public static class IntegerTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public IntegerTypeImpl() {
            super(Integer.class);
        }

        @Override
        public IntegerValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.integerValue((Integer)value, this.isTransient(valueInfo));
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                return false;
            }
            if (typedValue.getValue() != null) {
                NumberValue numberValue = (NumberValue)typedValue;
                double doubleValue = ((Number)numberValue.getValue()).doubleValue();
                if ((double)((Number)numberValue.getValue()).intValue() != doubleValue) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public IntegerValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            PrimitiveTypeValueImpl.IntegerValueImpl integerValue = null;
            NumberValue numberValue = (NumberValue)typedValue;
            integerValue = numberValue.getValue() != null ? (PrimitiveTypeValueImpl.IntegerValueImpl)Variables.integerValue(((Number)numberValue.getValue()).intValue()) : (PrimitiveTypeValueImpl.IntegerValueImpl)Variables.integerValue(null);
            integerValue.setTransient(numberValue.isTransient());
            return integerValue;
        }
    }

    public static class DoubleTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public DoubleTypeImpl() {
            super(Double.class);
        }

        @Override
        public DoubleValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.doubleValue((Double)value, this.isTransient(valueInfo));
        }

        @Override
        public ValueType getParent() {
            return ValueType.NUMBER;
        }

        @Override
        public boolean canConvertFromTypedValue(TypedValue typedValue) {
            return typedValue.getType() == ValueType.NUMBER;
        }

        @Override
        public DoubleValue convertFromTypedValue(TypedValue typedValue) {
            if (typedValue.getType() != ValueType.NUMBER) {
                throw this.unsupportedConversion(typedValue.getType());
            }
            PrimitiveTypeValueImpl.DoubleValueImpl doubleValue = null;
            NumberValue numberValue = (NumberValue)typedValue;
            doubleValue = numberValue.getValue() != null ? (PrimitiveTypeValueImpl.DoubleValueImpl)Variables.doubleValue(((Number)numberValue.getValue()).doubleValue()) : (PrimitiveTypeValueImpl.DoubleValueImpl)Variables.doubleValue(null);
            doubleValue.setTransient(numberValue.isTransient());
            return doubleValue;
        }
    }

    public static class DateTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public DateTypeImpl() {
            super(Date.class);
        }

        @Override
        public DateValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.dateValue((Date)value, this.isTransient(valueInfo));
        }
    }

    public static class BytesTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public BytesTypeImpl() {
            super("bytes", byte[].class);
        }

        @Override
        public BytesValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.byteArrayValue((byte[])value, this.isTransient(valueInfo));
        }
    }

    public static class BooleanTypeImpl
    extends PrimitiveValueTypeImpl {
        private static final long serialVersionUID = 1L;

        public BooleanTypeImpl() {
            super(Boolean.class);
        }

        @Override
        public BooleanValue createValue(Object value, Map<String, Object> valueInfo) {
            return Variables.booleanValue((Boolean)value, this.isTransient(valueInfo));
        }
    }
}

