/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.variable.impl.value;

import io.openbpm.bpm.engine.variable.type.FileValueType;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.FileValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;

public class FileValueImpl
implements FileValue {
    private static final long serialVersionUID = 1L;
    protected String mimeType;
    protected String filename;
    protected byte[] value;
    protected FileValueType type;
    protected String encoding;
    protected boolean isTransient;

    public FileValueImpl(byte[] value, FileValueType type, String filename, String mimeType, String encoding) {
        this.value = value;
        this.type = type;
        this.filename = filename;
        this.mimeType = mimeType;
        this.encoding = encoding;
    }

    public FileValueImpl(FileValueType type, String filename) {
        this(null, type, filename, null, null);
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setValue(byte[] bytes) {
        this.value = bytes;
    }

    @Override
    public InputStream getValue() {
        if (this.value == null) {
            return null;
        }
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public ValueType getType() {
        return this.type;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding.name();
    }

    @Override
    public Charset getEncodingAsCharset() {
        if (this.encoding == null) {
            return null;
        }
        return Charset.forName(this.encoding);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getByteArray() {
        return this.value;
    }

    public String toString() {
        return "FileValueImpl [mimeType=" + this.mimeType + ", filename=" + this.filename + ", type=" + String.valueOf(this.type) + ", isTransient=" + this.isTransient + "]";
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }
}

