/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.bpm.engine.variable.impl.value.builder;

import io.openbpm.bpm.engine.variable.impl.value.FileValueImpl;
import io.openbpm.bpm.engine.variable.type.ValueType;
import io.openbpm.bpm.engine.variable.value.FileValue;
import io.openbpm.bpm.engine.variable.value.builder.FileValueBuilder;
import io.openbpm.commons.utils.EnsureUtil;
import io.openbpm.commons.utils.IoUtil;
import io.openbpm.commons.utils.IoUtilException;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;

public class FileValueBuilderImpl
implements FileValueBuilder {
    protected FileValueImpl fileValue;

    public FileValueBuilderImpl(String filename) {
        EnsureUtil.ensureNotNull((String)"filename", (Object)filename);
        this.fileValue = new FileValueImpl(ValueType.FILE, filename);
    }

    @Override
    public FileValue create() {
        return this.fileValue;
    }

    @Override
    public FileValueBuilder mimeType(String mimeType) {
        this.fileValue.setMimeType(mimeType);
        return this;
    }

    @Override
    public FileValueBuilder file(File file) {
        try {
            return this.file(IoUtil.fileAsByteArray((File)file));
        }
        catch (IoUtilException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileValueBuilder file(InputStream stream) {
        try {
            return this.file(IoUtil.inputStreamAsByteArray((InputStream)stream));
        }
        catch (IoUtilException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public FileValueBuilder file(byte[] bytes) {
        this.fileValue.setValue(bytes);
        return this;
    }

    @Override
    public FileValueBuilder encoding(Charset encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }

    @Override
    public FileValueBuilder encoding(String encoding) {
        this.fileValue.setEncoding(encoding);
        return this;
    }

    public FileValueBuilder setTransient(boolean isTransient) {
        this.fileValue.setTransient(isTransient);
        return this;
    }
}

