/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.connect.plugin.impl;

import io.openbpm.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import io.openbpm.bpm.engine.impl.core.variable.mapping.IoMapping;
import io.openbpm.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import io.openbpm.bpm.engine.impl.pvm.delegate.ActivityExecution;
import io.openbpm.connect.ConnectorException;
import io.openbpm.connect.Connectors;
import io.openbpm.connect.plugin.impl.ConnectorVariableScope;
import io.openbpm.connect.spi.Connector;
import io.openbpm.connect.spi.ConnectorRequest;
import io.openbpm.connect.spi.ConnectorResponse;

public class ServiceTaskConnectorActivityBehavior
extends TaskActivityBehavior {
    protected String connectorId;
    protected Connector<?> connectorInstance;
    protected IoMapping ioMapping;

    public ServiceTaskConnectorActivityBehavior(String connectorId, IoMapping ioMapping) {
        this.connectorId = connectorId;
        this.ioMapping = ioMapping;
    }

    public void execute(ActivityExecution execution) throws Exception {
        this.ensureConnectorInitialized();
        this.executeWithErrorPropagation(execution, () -> {
            ConnectorRequest request = this.connectorInstance.createRequest();
            this.applyInputParameters(execution, request);
            ConnectorResponse response = request.execute();
            this.applyOutputParameters(execution, response);
            this.leave(execution);
            return null;
        });
    }

    protected void applyInputParameters(ActivityExecution execution, ConnectorRequest<?> request) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorInputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            this.ioMapping.executeInputParameters((AbstractVariableScope)connectorInputVariableScope);
            connectorInputVariableScope.writeToRequest(request);
        }
    }

    protected void applyOutputParameters(ActivityExecution execution, ConnectorResponse response) {
        if (this.ioMapping != null) {
            ConnectorVariableScope connectorOutputVariableScope = new ConnectorVariableScope((AbstractVariableScope)execution);
            connectorOutputVariableScope.readFromResponse(response);
            this.ioMapping.executeOutputParameters((AbstractVariableScope)connectorOutputVariableScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureConnectorInitialized() {
        if (this.connectorInstance == null) {
            ServiceTaskConnectorActivityBehavior serviceTaskConnectorActivityBehavior = this;
            synchronized (serviceTaskConnectorActivityBehavior) {
                if (this.connectorInstance == null) {
                    this.connectorInstance = Connectors.getConnector((String)this.connectorId);
                    if (this.connectorInstance == null) {
                        throw new ConnectorException("No connector found for connector id '" + this.connectorId + "'");
                    }
                }
            }
        }
    }
}

