/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.xml.dom;

import io.openbpm.commons.utils.EnsureUtil;
import io.openbpm.spin.impl.xml.dom.DomXmlNodeIterator;
import io.openbpm.spin.impl.xml.dom.format.DomXmlDataFormat;
import io.openbpm.spin.xml.SpinXmlElement;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomXmlElementIterable
implements Iterable<SpinXmlElement> {
    protected final NodeList nodeList;
    protected final DomXmlDataFormat dataFormat;
    protected final String namespace;
    protected final String name;
    protected boolean validating;

    public DomXmlElementIterable(Element domElement, DomXmlDataFormat dataFormat) {
        this(domElement.getChildNodes(), dataFormat);
    }

    public DomXmlElementIterable(NodeList nodeList, DomXmlDataFormat dataFormat) {
        this.nodeList = nodeList;
        this.dataFormat = dataFormat;
        this.namespace = null;
        this.name = null;
        this.validating = false;
    }

    public DomXmlElementIterable(Element domElement, DomXmlDataFormat dataFormat, String namespace, String name) {
        this(domElement.getChildNodes(), dataFormat, namespace, name);
    }

    public DomXmlElementIterable(NodeList nodeList, DomXmlDataFormat dataFormat, String namespace, String name) {
        EnsureUtil.ensureNotNull((String)"name", (Object)name);
        this.nodeList = nodeList;
        this.dataFormat = dataFormat;
        this.namespace = namespace;
        this.name = name;
        this.validating = true;
    }

    @Override
    public Iterator<SpinXmlElement> iterator() {
        return new DomXmlNodeIterator<SpinXmlElement>(){
            private NodeList childs;
            {
                this.childs = DomXmlElementIterable.this.nodeList;
            }

            @Override
            protected int getLength() {
                return this.childs.getLength();
            }

            @Override
            protected SpinXmlElement getCurrent() {
                Node item;
                if (this.childs != null && (item = this.childs.item(this.index)) instanceof Element) {
                    Element element = (Element)item;
                    SpinXmlElement current = DomXmlElementIterable.this.dataFormat.createElementWrapper(element);
                    if (!DomXmlElementIterable.this.validating || current.hasNamespace(DomXmlElementIterable.this.namespace) && DomXmlElementIterable.this.name.equals(current.name())) {
                        return current;
                    }
                }
                return null;
            }
        };
    }
}

