/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.xml.dom.format;

import io.openbpm.spin.impl.xml.dom.DomXmlLogger;
import io.openbpm.spin.impl.xml.dom.format.DomXmlDataFormat;
import io.openbpm.spin.spi.TextBasedDataFormatReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomXmlDataFormatReader
extends TextBasedDataFormatReader {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    private static final Pattern INPUT_MATCHING_PATTERN = Pattern.compile("\\A(\\s)*<");
    protected DomXmlDataFormat dataFormat;

    public DomXmlDataFormatReader(DomXmlDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Element readInput(Reader input) {
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            LOG.parsingInput();
            return documentBuilder.parse(new InputSource(input)).getDocumentElement();
        }
        catch (IOException | SAXException e) {
            throw LOG.unableToParseInput(e);
        }
    }

    protected DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder docBuilder = this.dataFormat.getDocumentBuilderFactory().newDocumentBuilder();
            LOG.createdDocumentBuilder();
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw LOG.unableToCreateParser(e);
        }
    }

    protected Pattern getInputDetectionPattern() {
        return INPUT_MATCHING_PATTERN;
    }
}

