/*
 * Decompiled with CFR 0.152.
 */
package io.openbpm.spin.impl.xml.dom.format.spi;

import io.openbpm.spin.impl.xml.dom.DomXmlLogger;
import io.openbpm.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import spinjar.jakarta.xml.bind.JAXBContext;
import spinjar.jakarta.xml.bind.JAXBContextFactory;
import spinjar.jakarta.xml.bind.JAXBException;
import spinjar.jakarta.xml.bind.Marshaller;
import spinjar.jakarta.xml.bind.Unmarshaller;

public class DefaultJaxBContextProvider
implements JaxBContextProvider {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;

    public JAXBContext getContext(Class<?> ... types) {
        StringBuilder additionalInfo = new StringBuilder();
        try {
            ServiceLoader<JAXBContextFactory> serviceLoader = ServiceLoader.load(JAXBContextFactory.class);
            switch ((int)serviceLoader.stream().count()) {
                case 0: {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    this.logClassLoader(cl, additionalInfo);
                    throw new JAXBException("No JAXBContextFactory implementation found");
                }
                case 1: {
                    return serviceLoader.iterator().next().createContext(types, Collections.emptyMap());
                }
            }
            throw new JAXBException("Multiple JAXBContextFactory implementations found: " + String.valueOf(serviceLoader.stream().map(sl -> ((JAXBContextFactory)sl.get()).getClass())));
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateContext(e, additionalInfo.toString());
        }
    }

    private void logClassLoader(ClassLoader cl, StringBuilder sb) {
        if (cl instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)cl;
            String urls = Stream.of(urlClassLoader.getURLs()).map(URL::toString).collect(Collectors.joining(","));
            sb.append("java.net.URLClassLoader: ").append(urls);
        } else {
            sb.append(cl.getClass().getName());
        }
        if (cl.getParent() != null) {
            sb.append("\n -> ");
            this.logClassLoader(cl.getParent(), sb);
        }
    }

    @Override
    public Marshaller createMarshaller(Class<?> ... types) {
        try {
            return this.getContext(types).createMarshaller();
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateMarshaller(e);
        }
    }

    @Override
    public Unmarshaller createUnmarshaller(Class<?> ... types) {
        try {
            return this.getContext(types).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw LOG.unableToCreateUnmarshaller(e);
        }
    }
}

