/*
 * Decompiled with CFR 0.152.
 */
package spinjar.jakarta.activation;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import spinjar.jakarta.activation.ServiceLoaderUtil;

class FactoryFinder {
    private static final Logger logger = Logger.getLogger("spinjar.jakarta.activation");
    private static final ServiceLoaderUtil.ExceptionHandler<RuntimeException> EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<RuntimeException>(){

        @Override
        public RuntimeException createException(Throwable throwable, String message) {
            return new RuntimeException(message, throwable);
        }
    };
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "spinjar.org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String defaultClassName, boolean tryFallback) throws RuntimeException {
        T result;
        T result2;
        ClassLoader tccl = ServiceLoaderUtil.contextClassLoader(EXCEPTION_HANDLER);
        String factoryId = factoryClass.getName();
        String className = FactoryFinder.fromSystemProperty(factoryId);
        if (className != null && (result2 = FactoryFinder.newInstance(className, defaultClassName, tccl)) != null) {
            return result2;
        }
        T factory = ServiceLoaderUtil.firstByServiceLoader(factoryClass, logger, EXCEPTION_HANDLER);
        if (factory != null) {
            return factory;
        }
        if (FactoryFinder.isOsgi() && (result = FactoryFinder.lookupUsingOSGiServiceLoader(factoryId)) != null) {
            return result;
        }
        if (!tryFallback) {
            throw new RuntimeException("Provider for " + factoryId + " cannot be found", null);
        }
        if (defaultClassName == null) {
            throw new RuntimeException("Provider for " + factoryId + " cannot be found", null);
        }
        return FactoryFinder.newInstance(defaultClassName, defaultClassName, tccl);
    }

    private static <T> T newInstance(String className, String defaultClassName, ClassLoader tccl) throws RuntimeException {
        return (T)ServiceLoaderUtil.newInstance(className, defaultClassName, tccl, EXCEPTION_HANDLER);
    }

    private static String fromSystemProperty(String factoryId) {
        String systemProp = FactoryFinder.getSystemProperty(factoryId);
        return systemProp;
    }

    private static String getSystemProperty(final String property) {
        logger.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(property);
            }
        });
        FactoryFinder.logFound(value);
        return value;
    }

    private static void logFound(String value) {
        if (value != null) {
            logger.log(Level.FINE, "  found {0}", value);
        } else {
            logger.log(Level.FINE, "  not found");
        }
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static <T> T lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? (T)iter.next() : null;
        }
        catch (Exception ignored) {
            return null;
        }
    }
}

