/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.OutputUtil;
import net.sf.practicalxml.builder.AttributeNode;
import net.sf.practicalxml.builder.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public final class ElementNode
extends Node {
    private static final long serialVersionUID = 2L;
    private String _nsUri;
    private String _qname;
    private String _lclName;
    private List<AttributeNode> _attribs = new ArrayList<AttributeNode>();
    private List<Node> _children = new ArrayList<Node>();

    ElementNode(String nsUri, String qname, Node ... children) {
        this._nsUri = nsUri;
        this._qname = qname;
        this._lclName = ElementNode.getLocalName(qname);
        for (Node child : children) {
            this.addChild(child);
        }
    }

    public ElementNode addChild(Node child) {
        if (child instanceof AttributeNode) {
            this._attribs.add((AttributeNode)child);
        } else if (child != null) {
            this._children.add(child);
        }
        return this;
    }

    public Document toDOM() {
        Element root = DomUtil.newDocument(this._nsUri, this._qname);
        this.appendChildren(root);
        return root.getOwnerDocument();
    }

    protected void toSAX(ContentHandler handler) throws SAXException {
        handler.startElement(this._nsUri, this._lclName, this._qname, this.getAttributes());
        for (Node child : this._children) {
            child.toSAX(handler);
        }
        handler.endElement(this._nsUri, this._lclName, this._qname);
    }

    public String toString() {
        return OutputUtil.compactString(new SerializationHelper());
    }

    public String toString(int indentSize) {
        return OutputUtil.indentedString(new SerializationHelper(), indentSize);
    }

    public void toStream(OutputStream out) {
        OutputUtil.compactStream(new SerializationHelper(), out);
    }

    public void toStream(OutputStream out, String encoding) {
        OutputUtil.compactStream(this.toDOM(), out, encoding);
    }

    protected void appendToElement(Element parent) {
        this.appendChildren(DomUtil.appendChild(parent, this._nsUri, this._qname));
    }

    private void appendChildren(Element elem) {
        for (AttributeNode attributeNode : this._attribs) {
            ((Node)attributeNode).appendToElement(elem);
        }
        for (Node node : this._children) {
            node.appendToElement(elem);
        }
    }

    private Attributes getAttributes() {
        AttributesImpl result = new AttributesImpl();
        for (AttributeNode attr : this._attribs) {
            attr.appendToAttributes(result);
        }
        return result;
    }

    private class SerializationHelper
    extends XMLFilterImpl {
        private SerializationHelper() {
        }

        public void parse(InputSource input) throws SAXException, IOException {
            this.startDocument();
            ElementNode.this.toSAX(this.getContentHandler());
            this.endDocument();
        }
    }
}

