/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.internal;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.practicalxml.XmlUtil;
import net.sf.practicalxml.converter.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaStringConversions {
    private boolean _useXsdFormat;
    private static Map<Class<?>, ConversionHandler<?>> _handlers = new HashMap();

    public JavaStringConversions(boolean useXsdFormat) {
        this._useXsdFormat = useXsdFormat;
    }

    public boolean isConvertableToString(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.isConvertableToString(obj.getClass());
    }

    public boolean isConvertableToString(Class<?> klass) {
        return JavaStringConversions.getHandler(klass) != null;
    }

    public String stringify(Object value) {
        if (value == null) {
            return null;
        }
        try {
            return JavaStringConversions.getHandler(value.getClass()).stringify(value, this._useXsdFormat);
        }
        catch (Exception ee) {
            if (ee instanceof ConversionException) {
                throw (ConversionException)ee;
            }
            throw new ConversionException("unable to convert: " + value, ee);
        }
    }

    public Object parse(String value, Class<?> klass) {
        if (value == null) {
            return null;
        }
        try {
            return JavaStringConversions.getHandler(klass).parse(value, this._useXsdFormat);
        }
        catch (Exception ee) {
            if (ee instanceof ConversionException) {
                throw (ConversionException)ee;
            }
            throw new ConversionException("unable to parse: " + value, ee);
        }
    }

    private static ConversionHandler<Object> getHandler(Class<?> klass) {
        ConversionHandler<Object> handler = _handlers.get(klass);
        if (handler != null) {
            return handler;
        }
        if (TimeZone.class.isAssignableFrom(klass)) {
            return _handlers.get(TimeZone.class);
        }
        return null;
    }

    static {
        _handlers.put(String.class, new StringConversionHandler());
        _handlers.put(Character.class, new CharacterConversionHandler());
        _handlers.put(Boolean.class, new BooleanConversionHandler());
        _handlers.put(Byte.class, new ByteConversionHandler());
        _handlers.put(Short.class, new ShortConversionHandler());
        _handlers.put(Integer.class, new IntegerConversionHandler());
        _handlers.put(Long.class, new LongConversionHandler());
        _handlers.put(Float.class, new FloatConversionHandler());
        _handlers.put(Double.class, new DoubleConversionHandler());
        _handlers.put(BigInteger.class, new BigIntegerConversionHandler());
        _handlers.put(BigDecimal.class, new BigDecimalConversionHandler());
        _handlers.put(Boolean.TYPE, new BooleanConversionHandler());
        _handlers.put(Byte.TYPE, new ByteConversionHandler());
        _handlers.put(Short.TYPE, new ShortConversionHandler());
        _handlers.put(Integer.TYPE, new IntegerConversionHandler());
        _handlers.put(Long.TYPE, new LongConversionHandler());
        _handlers.put(Float.TYPE, new FloatConversionHandler());
        _handlers.put(Double.TYPE, new DoubleConversionHandler());
        _handlers.put(Date.class, new DateConversionHandler());
        _handlers.put(Class.class, new ClassConversionHandler());
        _handlers.put(File.class, new FileConversionHandler());
        _handlers.put(Locale.class, new LocaleConversionHandler());
        _handlers.put(TimeZone.class, new TimeZoneConversionHandler());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleConversionHandler
    implements ConversionHandler<Locale> {
        private LocaleConversionHandler() {
        }

        @Override
        public String stringify(Locale obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public Locale parse(String str, boolean useXsdFormat) {
            try {
                String[] cmp = str.split("_");
                switch (cmp.length) {
                    case 1: {
                        return new Locale(cmp[0]);
                    }
                    case 2: {
                        return new Locale(cmp[0], cmp[1]);
                    }
                    case 3: {
                        return new Locale(cmp[0], cmp[1], cmp[2]);
                    }
                }
                throw new IllegalArgumentException();
            }
            catch (Exception ex) {
                throw new ConversionException("invalid locale string: " + str, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeZoneConversionHandler
    implements ConversionHandler<TimeZone> {
        private TimeZoneConversionHandler() {
        }

        @Override
        public String stringify(TimeZone obj, boolean useXsdFormat) {
            return obj.getID();
        }

        @Override
        public TimeZone parse(String str, boolean useXsdFormat) {
            try {
                return TimeZone.getTimeZone(str);
            }
            catch (Exception ex) {
                throw new ConversionException("invalid timezone ID: " + str, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileConversionHandler
    implements ConversionHandler<File> {
        private FileConversionHandler() {
        }

        @Override
        public String stringify(File obj, boolean useXsdFormat) {
            try {
                return obj.getCanonicalPath();
            }
            catch (IOException ex) {
                throw new RuntimeException("unable to convert file to string", ex);
            }
        }

        @Override
        public File parse(String str, boolean useXsdFormat) {
            try {
                return new File(str);
            }
            catch (Exception ex) {
                throw new ConversionException("invalid filename: " + str, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassConversionHandler
    implements ConversionHandler<Class> {
        private ClassConversionHandler() {
        }

        @Override
        public String stringify(Class obj, boolean useXsdFormat) {
            return obj.getName();
        }

        @Override
        public Class parse(String str, boolean useXsdFormat) {
            try {
                return Class.forName(str);
            }
            catch (Exception ex) {
                throw new ConversionException("invalid classname: " + str, ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DateConversionHandler
    implements ConversionHandler<Date> {
        private DateFormat _defaultFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");

        private DateConversionHandler() {
        }

        @Override
        public String stringify(Date obj, boolean useXsdFormat) {
            return useXsdFormat ? XmlUtil.formatXsdDatetime(obj) : obj.toString();
        }

        @Override
        public Date parse(String str, boolean useXsdFormat) {
            if (useXsdFormat) {
                return XmlUtil.parseXsdDatetime(str);
            }
            return this.parseDefault(str);
        }

        private synchronized Date parseDefault(String str) {
            try {
                return this._defaultFormat.parse(str);
            }
            catch (ParseException ee) {
                throw new ConversionException("unable to parse: " + str, ee);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigDecimalConversionHandler
    implements ConversionHandler<BigDecimal> {
        private BigDecimalConversionHandler() {
        }

        @Override
        public String stringify(BigDecimal obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public BigDecimal parse(String str, boolean useXsdFormat) {
            return new BigDecimal(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BigIntegerConversionHandler
    implements ConversionHandler<BigInteger> {
        private BigIntegerConversionHandler() {
        }

        @Override
        public String stringify(BigInteger obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public BigInteger parse(String str, boolean useXsdFormat) {
            return new BigInteger(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleConversionHandler
    implements ConversionHandler<Double> {
        private DoubleConversionHandler() {
        }

        @Override
        public String stringify(Double obj, boolean useXsdFormat) {
            return useXsdFormat ? XmlUtil.formatXsdDecimal(obj) : obj.toString();
        }

        @Override
        public Double parse(String str, boolean useXsdFormat) {
            return Double.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FloatConversionHandler
    implements ConversionHandler<Float> {
        private FloatConversionHandler() {
        }

        @Override
        public String stringify(Float obj, boolean useXsdFormat) {
            return useXsdFormat ? XmlUtil.formatXsdDecimal(obj) : obj.toString();
        }

        @Override
        public Float parse(String str, boolean useXsdFormat) {
            return Float.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongConversionHandler
    implements ConversionHandler<Long> {
        private LongConversionHandler() {
        }

        @Override
        public String stringify(Long obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public Long parse(String str, boolean useXsdFormat) {
            return Long.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntegerConversionHandler
    implements ConversionHandler<Integer> {
        private IntegerConversionHandler() {
        }

        @Override
        public String stringify(Integer obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public Integer parse(String str, boolean useXsdFormat) {
            return Integer.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortConversionHandler
    implements ConversionHandler<Short> {
        private ShortConversionHandler() {
        }

        @Override
        public String stringify(Short obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public Short parse(String str, boolean useXsdFormat) {
            return Short.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ByteConversionHandler
    implements ConversionHandler<Byte> {
        private ByteConversionHandler() {
        }

        @Override
        public String stringify(Byte obj, boolean useXsdFormat) {
            return obj.toString();
        }

        @Override
        public Byte parse(String str, boolean useXsdFormat) {
            return Byte.valueOf(str.trim());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanConversionHandler
    implements ConversionHandler<Boolean> {
        private BooleanConversionHandler() {
        }

        @Override
        public String stringify(Boolean obj, boolean useXsdFormat) {
            return useXsdFormat ? XmlUtil.formatXsdBoolean(obj) : obj.toString();
        }

        @Override
        public Boolean parse(String str, boolean useXsdFormat) {
            return useXsdFormat ? XmlUtil.parseXsdBoolean(str) : Boolean.parseBoolean(str);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharacterConversionHandler
    implements ConversionHandler<Character> {
        private final Character NUL = Character.valueOf('\u0000');

        private CharacterConversionHandler() {
        }

        @Override
        public String stringify(Character obj, boolean useXsdFormat) {
            if (obj.equals(this.NUL)) {
                return "";
            }
            return obj.toString();
        }

        @Override
        public Character parse(String str, boolean useXsdFormat) {
            if (str.length() == 0) {
                return this.NUL;
            }
            if (str.length() > 1) {
                throw new ConversionException("attempted to convert multi-character string: \"" + str + "\"");
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringConversionHandler
    implements ConversionHandler<String> {
        private StringConversionHandler() {
        }

        @Override
        public String stringify(String obj, boolean useXsdFormat) {
            return String.valueOf(obj);
        }

        @Override
        public String parse(String str, boolean useXsdFormat) {
            return str;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ConversionHandler<T> {
        public String stringify(T var1, boolean var2);

        public T parse(String var1, boolean var2);
    }
}

