/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFunction<T>
implements XPathFunction,
Comparable<AbstractFunction<?>> {
    private final QName _qname;
    private final int _minArgCount;
    private final int _maxArgCount;

    protected AbstractFunction(String nsUri, String localName) {
        this(nsUri, localName, 0, Integer.MAX_VALUE);
    }

    protected AbstractFunction(String nsUri, String localName, int numArgs) {
        this(nsUri, localName, numArgs, numArgs);
    }

    protected AbstractFunction(String nsUri, String localName, int minArgs, int maxArgs) {
        this(new QName(nsUri, localName), minArgs, maxArgs);
    }

    protected AbstractFunction(QName qname, int minArgs, int maxArgs) {
        this._qname = qname;
        this._minArgCount = minArgs;
        this._maxArgCount = maxArgs;
    }

    public QName getQName() {
        return this._qname;
    }

    public String getNamespaceUri() {
        return this._qname.getNamespaceURI();
    }

    public String getName() {
        return this._qname.getLocalPart();
    }

    public int getMinArgCount() {
        return this._minArgCount;
    }

    public int getMaxArgCount() {
        return this._maxArgCount;
    }

    public boolean isMatch(QName qname, int arity) {
        return this._qname.equals(qname) && arity >= this._minArgCount && arity <= this._maxArgCount;
    }

    public boolean isArityMatch(int arity) {
        return arity >= this._minArgCount && arity <= this._maxArgCount;
    }

    @Override
    public int compareTo(AbstractFunction<?> that) {
        int result = this._qname.getNamespaceURI().compareTo(that._qname.getNamespaceURI());
        if (result != 0) {
            return result < 0 ? -1 : 1;
        }
        result = this._qname.getLocalPart().compareTo(that._qname.getLocalPart());
        if (result != 0) {
            return result < 0 ? -1 : 1;
        }
        result = this._maxArgCount - this._minArgCount - (that._maxArgCount - that._minArgCount);
        if (result != 0) {
            return result < 0 ? -1 : 1;
        }
        result = this._minArgCount - that._minArgCount;
        if (result != 0) {
            return result < 0 ? -1 : 1;
        }
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractFunction) {
            AbstractFunction that = (AbstractFunction)obj;
            return this._qname.equals(that._qname) && this._minArgCount == that._minArgCount && this._maxArgCount == that._maxArgCount;
        }
        return false;
    }

    public final int hashCode() {
        return this._qname.hashCode();
    }

    public Object evaluate(List args) throws XPathFunctionException {
        if (args == null) {
            args = Collections.EMPTY_LIST;
        }
        if (args.size() < this._minArgCount || args.size() > this._maxArgCount) {
            throw new XPathFunctionException("illegal argument count: " + args.size());
        }
        try {
            T helper = this.init();
            int idx = 0;
            for (Object arg : args) {
                helper = arg instanceof String ? this.processArg(idx, (String)arg, helper) : (arg instanceof Number ? this.processArg(idx, (Number)arg, helper) : (arg instanceof NodeList ? this.processArg(idx, (NodeList)arg, helper) : (arg instanceof Node ? this.processArg(idx, (Node)arg, helper) : (arg == null ? this.processNullArg(idx, helper) : this.processUnexpectedArg(idx, arg, helper)))));
                ++idx;
            }
            return this.getResult(helper);
        }
        catch (Exception e) {
            throw new XPathFunctionException(e);
        }
    }

    protected T init() throws Exception {
        return null;
    }

    protected T processArg(int index, String value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Number value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Boolean value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, Node value, T helper) throws Exception {
        return helper;
    }

    protected T processArg(int index, NodeList value, T helper) throws Exception {
        return this.processArg(index, value.item(0), helper);
    }

    protected T processNullArg(int index, T helper) throws Exception {
        throw new IllegalArgumentException("null argument: " + index);
    }

    protected T processUnexpectedArg(int index, Object value, T helper) throws Exception {
        throw new IllegalArgumentException("unexpected argument: " + index + " (" + value.getClass().getName() + ")");
    }

    protected Object getResult(T helper) throws Exception {
        return helper;
    }
}

