/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.message.PropertyValidationMessage;

public class PropertyValidationSupport {
    private ValidationResult defaultResult;
    private final Severity defaultSeverity;
    private final Object target;
    private final String role;

    public PropertyValidationSupport(Object target, String role) {
        this(Severity.WARNING, target, role);
    }

    public PropertyValidationSupport(Severity defaultSeverity, Object target, String role) {
        this(new ValidationResult(), defaultSeverity, target, role);
    }

    public PropertyValidationSupport(ValidationResult defaultResult, Severity defaultSeverity, Object target, String role) {
        Preconditions.checkArgument((defaultSeverity != Severity.OK ? 1 : 0) != 0, (String)"Validation messages must have a severity other than OK.");
        this.defaultResult = defaultResult;
        this.defaultSeverity = defaultSeverity;
        this.target = target;
        this.role = role;
    }

    public final void clearResult() {
        this.defaultResult = new ValidationResult();
    }

    public final ValidationResult getResult() {
        return this.defaultResult;
    }

    public final PropertyValidationMessage createError(String property, String text) {
        return this.create(Severity.ERROR, property, text);
    }

    public final PropertyValidationMessage createWarning(String property, String text) {
        return this.create(Severity.WARNING, property, text);
    }

    public final PropertyValidationMessage create(String property, String text) {
        return this.create(this.defaultSeverity, property, text);
    }

    public PropertyValidationMessage create(Severity severity, String property, String text) {
        return new PropertyValidationMessage(severity, text, this.target, this.role, property);
    }

    public final void addError(String property, String text) {
        this.addError(this.defaultResult, property, text);
    }

    public final void addWarning(String property, String text) {
        this.addWarning(this.defaultResult, property, text);
    }

    public final void add(String property, String text) {
        this.add(this.defaultResult, property, text);
    }

    public final void add(Severity severity, String property, String text) {
        this.add(this.defaultResult, severity, property, text);
    }

    public final void addError(ValidationResult result, String property, String text) {
        result.add(this.createError(property, text));
    }

    public final void addWarning(ValidationResult result, String property, String text) {
        result.add(this.createWarning(property, text));
    }

    public final void add(ValidationResult result, String property, String text) {
        result.add(this.create(property, text));
    }

    public final void add(ValidationResult result, Severity severity, String property, String text) {
        result.add(this.create(severity, property, text));
    }
}

