/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.config.provider;

import io.sentry.config.ResourceLoader;
import io.sentry.config.provider.ConfigurationProvider;
import io.sentry.util.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoaderConfigurationProvider
implements ConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceLoaderConfigurationProvider.class);
    @Nullable
    private final Properties properties;

    public ResourceLoaderConfigurationProvider(ResourceLoader rl, @Nullable String filePath, Charset charset) throws IOException {
        this.properties = ResourceLoaderConfigurationProvider.loadProperties(rl, filePath, charset);
    }

    @Nullable
    private static Properties loadProperties(ResourceLoader rl, @Nullable String filePath, Charset charset) throws IOException {
        if (filePath == null) {
            return null;
        }
        InputStream is = rl.getInputStream(filePath);
        if (is == null) {
            return null;
        }
        try (InputStreamReader rdr = new InputStreamReader(is, charset);){
            Properties props = new Properties();
            props.load(rdr);
            Properties properties = props;
            return properties;
        }
    }

    @Override
    public String getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        String ret = this.properties.getProperty(key);
        if (ret != null) {
            logger.debug("Found {}={} in properties file.", (Object)key, (Object)ret);
        }
        return ret;
    }
}

