/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event.helper;

import io.sentry.SentryClient;
import io.sentry.context.Context;
import io.sentry.event.Breadcrumb;
import io.sentry.event.EventBuilder;
import io.sentry.event.User;
import io.sentry.event.helper.EventBuilderHelper;
import io.sentry.event.interfaces.UserInterface;
import java.util.List;
import java.util.Map;

public class ContextBuilderHelper
implements EventBuilderHelper {
    private SentryClient sentryClient;

    public ContextBuilderHelper(SentryClient sentryClient) {
        this.sentryClient = sentryClient;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        Map<String, Object> extra;
        Map<String, String> tags;
        Context context = this.sentryClient.getContext();
        List<Breadcrumb> breadcrumbs = context.getBreadcrumbs();
        if (!breadcrumbs.isEmpty()) {
            eventBuilder.withBreadcrumbs(breadcrumbs);
        }
        if (context.getHttp() != null) {
            eventBuilder.withSentryInterface(context.getHttp());
        }
        if (context.getUser() != null) {
            eventBuilder.withSentryInterface(this.fromUser(context.getUser()));
        }
        if (!(tags = context.getTags()).isEmpty()) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                eventBuilder.withTag(entry.getKey(), entry.getValue());
            }
        }
        if (!(extra = context.getExtra()).isEmpty()) {
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                eventBuilder.withExtra(entry.getKey(), entry.getValue());
            }
        }
    }

    private UserInterface fromUser(User user) {
        return new UserInterface(user.getId(), user.getUsername(), user.getIpAddress(), user.getEmail(), user.getData());
    }
}

