/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.event.interfaces;

import io.sentry.jvmti.Frame;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class SentryStackTraceElement
implements Serializable {
    private final String module;
    private final String function;
    private final String fileName;
    private final int lineno;
    private final Integer colno;
    private final String absPath;
    private final String platform;
    private final Map<String, Object> locals;

    public SentryStackTraceElement(String module, String function, String fileName, int lineno, Integer colno, String absPath, String platform) {
        this(module, function, fileName, lineno, colno, absPath, platform, null);
    }

    public SentryStackTraceElement(String module, String function, String fileName, int lineno, Integer colno, String absPath, String platform, Map<String, Object> locals) {
        this.module = module;
        this.function = function;
        this.fileName = fileName;
        this.lineno = lineno;
        this.colno = colno;
        this.absPath = absPath;
        this.platform = platform;
        this.locals = locals;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineno() {
        return this.lineno;
    }

    public Integer getColno() {
        return this.colno;
    }

    public String getAbsPath() {
        return this.absPath;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Map<String, Object> getLocals() {
        return this.locals;
    }

    public static SentryStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElements) {
        return SentryStackTraceElement.fromStackTraceElements(stackTraceElements, null);
    }

    public static SentryStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElements, Frame[] cachedFrames) {
        SentryStackTraceElement[] sentryStackTraceElements = new SentryStackTraceElement[stackTraceElements.length];
        int i = 0;
        int j = 0;
        while (i < stackTraceElements.length) {
            StackTraceElement stackTraceElement = stackTraceElements[i];
            Map<String, Object> locals = null;
            if (cachedFrames != null) {
                while (j < cachedFrames.length && !stackTraceElement.getMethodName().equals(cachedFrames[j].getMethod().getName())) {
                    ++j;
                }
                if (j < cachedFrames.length) {
                    locals = cachedFrames[j].getLocals();
                }
            }
            sentryStackTraceElements[i] = SentryStackTraceElement.fromStackTraceElement(stackTraceElement, locals);
            ++i;
            ++j;
        }
        return sentryStackTraceElements;
    }

    public static SentryStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement) {
        return SentryStackTraceElement.fromStackTraceElement(stackTraceElement, null);
    }

    private static SentryStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement, Map<String, Object> locals) {
        return new SentryStackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), null, null, null, locals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentryStackTraceElement that = (SentryStackTraceElement)o;
        return this.lineno == that.lineno && Objects.equals(this.module, that.module) && Objects.equals(this.function, that.function) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.colno, that.colno) && Objects.equals(this.absPath, that.absPath) && Objects.equals(this.platform, that.platform) && Objects.equals(this.locals, that.locals);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.function, this.fileName, this.lineno, this.colno, this.absPath, this.platform, this.locals);
    }

    public String toString() {
        return "SentryStackTraceElement{module='" + this.module + '\'' + ", function='" + this.function + '\'' + ", fileName='" + this.fileName + '\'' + ", lineno=" + this.lineno + ", colno=" + this.colno + ", absPath='" + this.absPath + '\'' + ", platform='" + this.platform + '\'' + ", locals='" + this.locals + '\'' + '}';
    }
}

