/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.converter.ConversionException;
import net.sf.practicalxml.converter.bean.Bean2XmlAppenders;
import net.sf.practicalxml.converter.bean.Bean2XmlOptions;
import net.sf.practicalxml.converter.bean.Introspection;
import net.sf.practicalxml.converter.bean.IntrospectionCache;
import net.sf.practicalxml.converter.internal.ConversionUtils;
import net.sf.practicalxml.converter.internal.JavaStringConversions;
import net.sf.practicalxml.internal.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean2XmlConverter {
    private EnumSet<Bean2XmlOptions> _options = EnumSet.noneOf(Bean2XmlOptions.class);
    private IntrospectionCache _introspections;
    private JavaStringConversions _converter;

    public Bean2XmlConverter(Bean2XmlOptions ... options) {
        for (Bean2XmlOptions option : options) {
            this._options.add(option);
        }
        this._introspections = new IntrospectionCache(this._options.contains((Object)Bean2XmlOptions.CACHE_INTROSPECTIONS));
        this._converter = new JavaStringConversions(this.shouldUseXsdFormatting());
    }

    public Element convert(Object obj, String rootName) {
        return this.convert(obj, null, rootName);
    }

    public Element convert(Object obj, String nsUri, String rootName) {
        Element root = DomUtil.newDocument(nsUri, rootName);
        this.doNamespaceHack(root);
        this.convert(obj, rootName, new Bean2XmlAppenders.DirectAppender(root, this._options));
        return root;
    }

    private void convert(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        try {
            if (obj == null) {
                this.convertAsNull(null, name, appender);
            } else if (this._converter.isConvertableToString(obj)) {
                this.convertSimple(obj, name, appender);
            } else if (obj instanceof Enum) {
                this.convertAsEnum(obj, name, appender);
            } else if (obj.getClass().isArray()) {
                this.convertAsArray(obj, name, appender);
            } else if (obj instanceof Map) {
                this.convertAsMap(obj, name, appender);
            } else if (obj instanceof Collection) {
                this.convertAsCollection(obj, name, appender);
            } else if (obj instanceof Calendar) {
                this.convertAsCalendar(obj, name, appender);
            } else {
                this.convertAsBean(obj, name, appender);
            }
        }
        catch (Exception ex) {
            if (ex instanceof ConversionException) {
                throw new ConversionException((ConversionException)ex, name);
            }
            throw new ConversionException("unable to convert", name, (Throwable)ex);
        }
    }

    private boolean shouldUseXsdFormatting() {
        return this._options.contains((Object)Bean2XmlOptions.XSD_FORMAT) || this._options.contains((Object)Bean2XmlOptions.USE_TYPE_ATTR);
    }

    private void doNamespaceHack(Element root) {
        if (this._options.contains((Object)Bean2XmlOptions.NULL_AS_XSI_NIL)) {
            ConversionUtils.setXsiNil(root, false);
        }
        boolean addCnvNS = this._options.contains((Object)Bean2XmlOptions.USE_INDEX_ATTR);
        addCnvNS |= !this._options.contains((Object)Bean2XmlOptions.MAP_KEYS_AS_ELEMENT_NAME);
        if (addCnvNS &= this._options.contains((Object)Bean2XmlOptions.USE_TYPE_ATTR)) {
            ConversionUtils.setAttribute(root, "ix", "");
        }
    }

    private void convertAsNull(Class<?> klass, String name, Bean2XmlAppenders.Appender appender) {
        appender.appendValue(name, klass, null);
    }

    private void convertSimple(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        appender.appendValue(name, obj.getClass(), this._converter.stringify(obj));
    }

    private void convertAsEnum(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        appender.appendValue(name, obj.getClass(), ((Enum)obj).name());
    }

    private void convertAsArray(Object array, String name, Bean2XmlAppenders.Appender appender) {
        String childName = this.determineChildNameForSequence(name);
        Bean2XmlAppenders.Appender childAppender = appender;
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            Element parent = appender.appendContainer(name, array.getClass());
            childAppender = new Bean2XmlAppenders.IndexedAppender(parent, this._options);
        }
        int length = Array.getLength(array);
        for (int idx = 0; idx < length; ++idx) {
            Object value = Array.get(array, idx);
            this.convert(value, childName, childAppender);
        }
    }

    private void convertAsMap(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, obj.getClass());
        Bean2XmlAppenders.MapAppender childAppender = new Bean2XmlAppenders.MapAppender(parent, this._options);
        for (Map.Entry entry : ((Map)obj).entrySet()) {
            this.convert(entry.getValue(), String.valueOf(entry.getKey()), childAppender);
        }
    }

    private void convertAsCollection(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        String childName = this.determineChildNameForSequence(name);
        Bean2XmlAppenders.Appender childAppender = appender;
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            Element parent = appender.appendContainer(name, obj.getClass());
            childAppender = new Bean2XmlAppenders.IndexedAppender(parent, this._options);
        }
        for (Object value : (Collection)obj) {
            this.convert(value, childName, childAppender);
        }
    }

    private void convertAsCalendar(Object obj, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, obj.getClass());
        Bean2XmlAppenders.BasicAppender childAppender = new Bean2XmlAppenders.BasicAppender(parent, this._options);
        Calendar cal = (Calendar)obj;
        this.convert((Object)cal.getTime(), "date", childAppender);
        this.convert((Object)cal.getTimeZone(), "timezone", childAppender);
        this.convert((Object)cal.getFirstDayOfWeek(), "firstDayOfWeek", childAppender);
        this.convert((Object)cal.getMinimalDaysInFirstWeek(), "minimumDaysInFirstWeek", childAppender);
    }

    private void convertAsBean(Object bean, String name, Bean2XmlAppenders.Appender appender) {
        Element parent = appender.appendContainer(name, bean.getClass());
        Bean2XmlAppenders.BasicAppender childAppender = new Bean2XmlAppenders.BasicAppender(parent, this._options);
        Introspection ispec = this._introspections.lookup(bean.getClass());
        for (String propName : ispec.propertyNames()) {
            this.convertBeanProperty(bean, ispec, propName, childAppender);
        }
    }

    private void convertBeanProperty(Object bean, Introspection ispec, String propName, Bean2XmlAppenders.Appender appender) {
        Object value;
        try {
            Method getter = ispec.getter(propName);
            value = getter != null ? getter.invoke(bean, new Object[0]) : null;
        }
        catch (Exception ee) {
            throw new ConversionException("unable to retrieve bean property", propName, (Throwable)ee);
        }
        if (value == null) {
            this.convertAsNull(ispec.type(propName), propName, appender);
        } else {
            this.convert(value, propName, appender);
        }
    }

    private String determineChildNameForSequence(String parentName) {
        if (StringUtils.isEmpty(parentName)) {
            return "data";
        }
        if (this._options.contains((Object)Bean2XmlOptions.SEQUENCE_AS_REPEATED_ELEMENTS)) {
            return parentName;
        }
        if (!this._options.contains((Object)Bean2XmlOptions.SEQUENCE_NAMED_BY_PARENT)) {
            return "data";
        }
        if (parentName.endsWith("s") || parentName.endsWith("S")) {
            return parentName.substring(0, parentName.length() - 1);
        }
        return parentName;
    }
}

