/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.practicalxml.converter.ConversionException;
import net.sf.practicalxml.converter.internal.ConversionUtils;
import net.sf.practicalxml.internal.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static Map<String, Class<?>> _xsiType2Java = new HashMap();
    private static Map<Class<?>, String> _java2XsiType;
    public static final String XSD_TYPE_PREFIX = "xsd:";
    public static final String JAVA_TYPE_PREFIX = "java:";

    public static String class2type(Class<?> klass) {
        String type = _java2XsiType.get(klass);
        return type != null ? XSD_TYPE_PREFIX + type : JAVA_TYPE_PREFIX + klass.getName();
    }

    public static void setType(Element elem, Class<?> klass) {
        if (klass == null) {
            return;
        }
        ConversionUtils.setAttribute(elem, "type", TypeUtils.class2type(klass));
    }

    public static String getTypeValue(Element elem) {
        String type = ConversionUtils.getAttribute(elem, "type");
        return StringUtils.isEmpty(type) ? null : type;
    }

    public static Class<?> getType(Element elem, boolean throwIfFail) {
        String type = TypeUtils.getTypeValue(elem);
        if (type == null) {
            if (throwIfFail) {
                throw new ConversionException("missing type", elem);
            }
            return null;
        }
        Class<?> klass = null;
        if (type.startsWith(XSD_TYPE_PREFIX)) {
            klass = TypeUtils.lookupXsdType(type);
        } else if (type.startsWith(JAVA_TYPE_PREFIX)) {
            klass = TypeUtils.resolveJavaType(type);
        }
        if (klass == null) {
            throw new ConversionException("unable to resolve type: " + type, elem);
        }
        return klass;
    }

    public static void validateType(Element elem, Class<?> klass) {
        Class<?> elemKlass = TypeUtils.getType(elem, true);
        if (klass.isAssignableFrom(elemKlass)) {
            return;
        }
        if (TypeUtils.class2type(klass).equals(TypeUtils.class2type(elemKlass))) {
            return;
        }
        throw new ConversionException("invalid type: \"" + TypeUtils.getTypeValue(elem) + "\" for " + klass.getName(), elem);
    }

    private static Class<?> lookupXsdType(String value) {
        value = value.substring(XSD_TYPE_PREFIX.length());
        return _xsiType2Java.get(value);
    }

    private static Class<?> resolveJavaType(String value) {
        value = value.substring(JAVA_TYPE_PREFIX.length());
        try {
            return Class.forName(value);
        }
        catch (ClassNotFoundException ee) {
            return null;
        }
    }

    static {
        _xsiType2Java.put("string", String.class);
        _xsiType2Java.put("boolean", Boolean.class);
        _xsiType2Java.put("byte", Byte.class);
        _xsiType2Java.put("short", Short.class);
        _xsiType2Java.put("int", Integer.class);
        _xsiType2Java.put("long", Long.class);
        _xsiType2Java.put("decimal", BigDecimal.class);
        _xsiType2Java.put("dateTime", Date.class);
        _java2XsiType = new HashMap();
        _java2XsiType.put(String.class, "string");
        _java2XsiType.put(Character.class, "string");
        _java2XsiType.put(Boolean.class, "boolean");
        _java2XsiType.put(Byte.class, "byte");
        _java2XsiType.put(Short.class, "short");
        _java2XsiType.put(Integer.class, "int");
        _java2XsiType.put(Long.class, "long");
        _java2XsiType.put(Float.class, "decimal");
        _java2XsiType.put(Double.class, "decimal");
        _java2XsiType.put(BigInteger.class, "decimal");
        _java2XsiType.put(BigDecimal.class, "decimal");
        _java2XsiType.put(Date.class, "dateTime");
        _java2XsiType.put(Character.TYPE, "string");
        _java2XsiType.put(Boolean.TYPE, "boolean");
        _java2XsiType.put(Byte.TYPE, "byte");
        _java2XsiType.put(Short.TYPE, "short");
        _java2XsiType.put(Integer.TYPE, "int");
        _java2XsiType.put(Long.TYPE, "long");
        _java2XsiType.put(Float.TYPE, "decimal");
        _java2XsiType.put(Double.TYPE, "decimal");
    }
}

