/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.internal;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import net.sf.practicalxml.XmlException;

public class TransformerFactoryHelper {
    private TransformerFactory _factory;
    private boolean _usePrologue;
    private String _encoding;
    private boolean _indent;
    private int _indentLevel;

    public TransformerFactoryHelper setPrologue() {
        this._factory = null;
        this._usePrologue = true;
        return this;
    }

    public TransformerFactoryHelper setPrologue(String encoding) {
        this._factory = null;
        this._usePrologue = true;
        this._encoding = encoding;
        return this;
    }

    public TransformerFactoryHelper setIndent(int indentLevel) {
        this._factory = null;
        this._indent = true;
        this._indentLevel = indentLevel;
        return this;
    }

    public Transformer newTransformer() {
        try {
            if (this._factory == null) {
                this._factory = TransformerFactory.newInstance();
                this.configIndent(this._factory);
            }
            Transformer xform = this._factory.newTransformer();
            this.configIndent(xform);
            this.configPrologue(xform);
            return xform;
        }
        catch (Exception e) {
            throw new XmlException("unable to configure transformer", e);
        }
    }

    private void configPrologue(Transformer xform) {
        xform.setOutputProperty("omit-xml-declaration", this._usePrologue ? "no" : "yes");
        if (this._encoding != null) {
            xform.setOutputProperty("encoding", this._encoding);
        }
    }

    private void configIndent(TransformerFactory fact) {
        if (!this._indent) {
            return;
        }
        fact.setAttribute("indent-number", this._indentLevel);
    }

    private void configIndent(Transformer xform) {
        xform.setOutputProperty("indent", this._indent ? "yes" : "no");
    }
}

