/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.xpath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceResolver
implements NamespaceContext {
    private static final SortedSet<String> DEFAULT_PREFIXES = new TreeSet<String>();
    private static final SortedSet<String> XML_NS_URI_PREFIXES = new TreeSet<String>();
    private static final SortedSet<String> XML_NS_ATTR_PREFIXES = new TreeSet<String>();
    private TreeMap<String, String> _prefix2ns = new TreeMap();
    private Map<String, SortedSet<String>> _ns2prefix = new HashMap<String, SortedSet<String>>();
    private String _defaultNS = "";

    public NamespaceResolver addNamespace(String prefix, String nsURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix may not be null");
        }
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI may not be null");
        }
        this._prefix2ns.put(prefix, nsURI);
        this.getPrefixSet(nsURI).add(prefix);
        return this;
    }

    public NamespaceResolver setDefaultNamespace(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI may not be null");
        }
        this._defaultNS = nsURI;
        return this;
    }

    public String getDefaultNamespace() {
        return this._defaultNS;
    }

    public List<String> getAllPrefixes() {
        return new ArrayList<String>(this._prefix2ns.keySet());
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix may not be null");
        }
        if ("".equals(prefix)) {
            return this._defaultNS;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return this._prefix2ns.get(prefix);
    }

    @Override
    public String getPrefix(String nsURI) {
        Iterator<String> itx = this.getPrefixes(nsURI);
        return itx.hasNext() ? itx.next() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String nsURI) {
        if (nsURI == null) {
            throw new IllegalArgumentException("nsURI may not be null");
        }
        if (this._defaultNS.equals(nsURI)) {
            return DEFAULT_PREFIXES.iterator();
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(nsURI)) {
            return XML_NS_URI_PREFIXES.iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(nsURI)) {
            return XML_NS_ATTR_PREFIXES.iterator();
        }
        return this.getPrefixSet(nsURI).iterator();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NamespaceResolver) {
            NamespaceResolver that = (NamespaceResolver)obj;
            return this._prefix2ns.equals(that._prefix2ns) && this._defaultNS.equals(that._defaultNS);
        }
        return false;
    }

    public int hashCode() {
        return this._prefix2ns.hashCode() ^ this._defaultNS.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50 * this._prefix2ns.size());
        if (!"".equals(this._defaultNS)) {
            buf.append("xmlns=\"").append(this._defaultNS).append("\"");
        }
        for (String prefix : this.getAllPrefixes()) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append("xmlns:").append(prefix).append("=\"").append(this._prefix2ns.get(prefix)).append("\"");
        }
        return buf.toString();
    }

    protected NamespaceResolver clone() {
        NamespaceResolver that = new NamespaceResolver().setDefaultNamespace(this.getDefaultNamespace());
        for (String prefix : this.getAllPrefixes()) {
            that.addNamespace(prefix, this.getNamespaceURI(prefix));
        }
        return that;
    }

    private SortedSet<String> getPrefixSet(String nsURI) {
        SortedSet<String> prefixes = this._ns2prefix.get(nsURI);
        if (prefixes == null) {
            prefixes = new TreeSet<String>();
            this._ns2prefix.put(nsURI, prefixes);
        }
        return prefixes;
    }

    static {
        DEFAULT_PREFIXES.add("");
        XML_NS_URI_PREFIXES.add("xml");
        XML_NS_ATTR_PREFIXES.add("xmlns");
    }
}

