/*
 * Decompiled with CFR 0.152.
 */
package liquibase.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.changelog.ChangeSet;
import liquibase.util.CollectionUtil;
import liquibase.util.NetUtil;
import liquibase.util.StringUtil;

public class UpdateReportParameters {
    private String changelogArgValue;
    private String jdbcUrl;
    private String commandTitle = "Update";
    private final DatabaseInfo databaseInfo = new DatabaseInfo();
    private final RuntimeInfo runtimeInfo = new RuntimeInfo();
    private final OperationInfo operationInfo = new OperationInfo();
    private final CustomData customData = new CustomData();
    private final ChangesetInfo changesetInfo = new ChangesetInfo();
    private final Date date = new Date();

    private static List<String> buildAttributesString(ChangeSet changeSet) {
        ArrayList<String> attributes = new ArrayList<String>();
        if (changeSet.getFailOnError() != null && !changeSet.getFailOnError().booleanValue()) {
            attributes.add("failOnError = false");
        }
        if (changeSet.isAlwaysRun()) {
            attributes.add("alwaysRun");
        }
        if (changeSet.isRunOnChange()) {
            attributes.add("runOnChange");
        }
        if (!changeSet.isRunInTransaction()) {
            attributes.add("runInTransaction = false");
        }
        if (StringUtil.isNotEmpty(changeSet.getRunOrder())) {
            attributes.add("runOrder = " + changeSet.getRunOrder());
        }
        if (StringUtil.isNotEmpty(changeSet.getRunWith())) {
            attributes.add("runWith = " + changeSet.getRunWith());
        }
        if (StringUtil.isNotEmpty(changeSet.getRunWithSpoolFile())) {
            attributes.add("runWithSpoolFile = " + changeSet.getRunWithSpoolFile());
        }
        if (!CollectionUtil.createIfNull(changeSet.getDbmsSet()).isEmpty()) {
            attributes.add("dbms = " + StringUtil.join(changeSet.getDbmsSet(), ", "));
        }
        return attributes;
    }

    public String getChangelogArgValue() {
        return this.changelogArgValue;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getCommandTitle() {
        return this.commandTitle;
    }

    public DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public OperationInfo getOperationInfo() {
        return this.operationInfo;
    }

    public CustomData getCustomData() {
        return this.customData;
    }

    public ChangesetInfo getChangesetInfo() {
        return this.changesetInfo;
    }

    public Date getDate() {
        return this.date;
    }

    public void setChangelogArgValue(String changelogArgValue) {
        this.changelogArgValue = changelogArgValue;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setCommandTitle(String commandTitle) {
        this.commandTitle = commandTitle;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateReportParameters)) {
            return false;
        }
        UpdateReportParameters other = (UpdateReportParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$changelogArgValue = this.getChangelogArgValue();
        String other$changelogArgValue = other.getChangelogArgValue();
        if (this$changelogArgValue == null ? other$changelogArgValue != null : !this$changelogArgValue.equals(other$changelogArgValue)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$commandTitle = this.getCommandTitle();
        String other$commandTitle = other.getCommandTitle();
        if (this$commandTitle == null ? other$commandTitle != null : !this$commandTitle.equals(other$commandTitle)) {
            return false;
        }
        DatabaseInfo this$databaseInfo = this.getDatabaseInfo();
        DatabaseInfo other$databaseInfo = other.getDatabaseInfo();
        if (this$databaseInfo == null ? other$databaseInfo != null : !((Object)this$databaseInfo).equals(other$databaseInfo)) {
            return false;
        }
        RuntimeInfo this$runtimeInfo = this.getRuntimeInfo();
        RuntimeInfo other$runtimeInfo = other.getRuntimeInfo();
        if (this$runtimeInfo == null ? other$runtimeInfo != null : !((Object)this$runtimeInfo).equals(other$runtimeInfo)) {
            return false;
        }
        OperationInfo this$operationInfo = this.getOperationInfo();
        OperationInfo other$operationInfo = other.getOperationInfo();
        if (this$operationInfo == null ? other$operationInfo != null : !((Object)this$operationInfo).equals(other$operationInfo)) {
            return false;
        }
        CustomData this$customData = this.getCustomData();
        CustomData other$customData = other.getCustomData();
        if (this$customData == null ? other$customData != null : !((Object)this$customData).equals(other$customData)) {
            return false;
        }
        ChangesetInfo this$changesetInfo = this.getChangesetInfo();
        ChangesetInfo other$changesetInfo = other.getChangesetInfo();
        if (this$changesetInfo == null ? other$changesetInfo != null : !((Object)this$changesetInfo).equals(other$changesetInfo)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        return !(this$date == null ? other$date != null : !((Object)this$date).equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateReportParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $changelogArgValue = this.getChangelogArgValue();
        result = result * 59 + ($changelogArgValue == null ? 43 : $changelogArgValue.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $commandTitle = this.getCommandTitle();
        result = result * 59 + ($commandTitle == null ? 43 : $commandTitle.hashCode());
        DatabaseInfo $databaseInfo = this.getDatabaseInfo();
        result = result * 59 + ($databaseInfo == null ? 43 : ((Object)$databaseInfo).hashCode());
        RuntimeInfo $runtimeInfo = this.getRuntimeInfo();
        result = result * 59 + ($runtimeInfo == null ? 43 : ((Object)$runtimeInfo).hashCode());
        OperationInfo $operationInfo = this.getOperationInfo();
        result = result * 59 + ($operationInfo == null ? 43 : ((Object)$operationInfo).hashCode());
        CustomData $customData = this.getCustomData();
        result = result * 59 + ($customData == null ? 43 : ((Object)$customData).hashCode());
        ChangesetInfo $changesetInfo = this.getChangesetInfo();
        result = result * 59 + ($changesetInfo == null ? 43 : ((Object)$changesetInfo).hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateReportParameters(changelogArgValue=" + this.getChangelogArgValue() + ", jdbcUrl=" + this.getJdbcUrl() + ", commandTitle=" + this.getCommandTitle() + ", databaseInfo=" + this.getDatabaseInfo() + ", runtimeInfo=" + this.getRuntimeInfo() + ", operationInfo=" + this.getOperationInfo() + ", customData=" + this.getCustomData() + ", changesetInfo=" + this.getChangesetInfo() + ", date=" + this.getDate() + ")";
    }

    public static class IndividualChangesetInfo {
        private int index;
        private String changesetAuthor;
        private String changesetId;
        private String changelogFile;
        private String comment;
        private String changesetOutcome;
        private String errorMsg;
        private String labels;
        private String contexts;
        private List<String> attributes;
        private List<String> generatedSql;

        public boolean hasAttributes() {
            return !CollectionUtil.createIfNull(this.attributes).isEmpty();
        }

        public int getIndex() {
            return this.index;
        }

        public String getChangesetAuthor() {
            return this.changesetAuthor;
        }

        public String getChangesetId() {
            return this.changesetId;
        }

        public String getChangelogFile() {
            return this.changelogFile;
        }

        public String getComment() {
            return this.comment;
        }

        public String getChangesetOutcome() {
            return this.changesetOutcome;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public String getLabels() {
            return this.labels;
        }

        public String getContexts() {
            return this.contexts;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public List<String> getGeneratedSql() {
            return this.generatedSql;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setChangesetAuthor(String changesetAuthor) {
            this.changesetAuthor = changesetAuthor;
        }

        public void setChangesetId(String changesetId) {
            this.changesetId = changesetId;
        }

        public void setChangelogFile(String changelogFile) {
            this.changelogFile = changelogFile;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public void setChangesetOutcome(String changesetOutcome) {
            this.changesetOutcome = changesetOutcome;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setLabels(String labels) {
            this.labels = labels;
        }

        public void setContexts(String contexts) {
            this.contexts = contexts;
        }

        public void setAttributes(List<String> attributes) {
            this.attributes = attributes;
        }

        public void setGeneratedSql(List<String> generatedSql) {
            this.generatedSql = generatedSql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndividualChangesetInfo)) {
                return false;
            }
            IndividualChangesetInfo other = (IndividualChangesetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$changesetAuthor = this.getChangesetAuthor();
            String other$changesetAuthor = other.getChangesetAuthor();
            if (this$changesetAuthor == null ? other$changesetAuthor != null : !this$changesetAuthor.equals(other$changesetAuthor)) {
                return false;
            }
            String this$changesetId = this.getChangesetId();
            String other$changesetId = other.getChangesetId();
            if (this$changesetId == null ? other$changesetId != null : !this$changesetId.equals(other$changesetId)) {
                return false;
            }
            String this$changelogFile = this.getChangelogFile();
            String other$changelogFile = other.getChangelogFile();
            if (this$changelogFile == null ? other$changelogFile != null : !this$changelogFile.equals(other$changelogFile)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            String this$changesetOutcome = this.getChangesetOutcome();
            String other$changesetOutcome = other.getChangesetOutcome();
            if (this$changesetOutcome == null ? other$changesetOutcome != null : !this$changesetOutcome.equals(other$changesetOutcome)) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            String this$labels = this.getLabels();
            String other$labels = other.getLabels();
            if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) {
                return false;
            }
            String this$contexts = this.getContexts();
            String other$contexts = other.getContexts();
            if (this$contexts == null ? other$contexts != null : !this$contexts.equals(other$contexts)) {
                return false;
            }
            List<String> this$attributes = this.getAttributes();
            List<String> other$attributes = other.getAttributes();
            if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
                return false;
            }
            List<String> this$generatedSql = this.getGeneratedSql();
            List<String> other$generatedSql = other.getGeneratedSql();
            return !(this$generatedSql == null ? other$generatedSql != null : !((Object)this$generatedSql).equals(other$generatedSql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndividualChangesetInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            String $changesetAuthor = this.getChangesetAuthor();
            result = result * 59 + ($changesetAuthor == null ? 43 : $changesetAuthor.hashCode());
            String $changesetId = this.getChangesetId();
            result = result * 59 + ($changesetId == null ? 43 : $changesetId.hashCode());
            String $changelogFile = this.getChangelogFile();
            result = result * 59 + ($changelogFile == null ? 43 : $changelogFile.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            String $changesetOutcome = this.getChangesetOutcome();
            result = result * 59 + ($changesetOutcome == null ? 43 : $changesetOutcome.hashCode());
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            String $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
            String $contexts = this.getContexts();
            result = result * 59 + ($contexts == null ? 43 : $contexts.hashCode());
            List<String> $attributes = this.getAttributes();
            result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
            List<String> $generatedSql = this.getGeneratedSql();
            result = result * 59 + ($generatedSql == null ? 43 : ((Object)$generatedSql).hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.IndividualChangesetInfo(index=" + this.getIndex() + ", changesetAuthor=" + this.getChangesetAuthor() + ", changesetId=" + this.getChangesetId() + ", changelogFile=" + this.getChangelogFile() + ", comment=" + this.getComment() + ", changesetOutcome=" + this.getChangesetOutcome() + ", errorMsg=" + this.getErrorMsg() + ", labels=" + this.getLabels() + ", contexts=" + this.getContexts() + ", attributes=" + this.getAttributes() + ", generatedSql=" + this.getGeneratedSql() + ")";
        }

        public IndividualChangesetInfo(int index, String changesetAuthor, String changesetId, String changelogFile, String comment, String changesetOutcome, String errorMsg, String labels, String contexts, List<String> attributes, List<String> generatedSql) {
            this.index = index;
            this.changesetAuthor = changesetAuthor;
            this.changesetId = changesetId;
            this.changelogFile = changelogFile;
            this.comment = comment;
            this.changesetOutcome = changesetOutcome;
            this.errorMsg = errorMsg;
            this.labels = labels;
            this.contexts = contexts;
            this.attributes = attributes;
            this.generatedSql = generatedSql;
        }
    }

    public static class ChangesetInfo {
        private int changesetCount;
        private final List<IndividualChangesetInfo> changesetInfoList = new ArrayList<IndividualChangesetInfo>();

        public void addAllToChangesetInfoList(List<ChangeSet> changeSets) {
            if (changeSets != null) {
                for (ChangeSet deployedChangeSet : changeSets) {
                    String changesetOutcome = deployedChangeSet.getExecType() == null ? "" : deployedChangeSet.getExecType().toString();
                    String errorMsg = deployedChangeSet.getErrorMsg();
                    if (StringUtil.isNotEmpty(errorMsg)) {
                        changesetOutcome = ChangeSet.ExecType.FAILED.value;
                    }
                    this.changesetInfoList.add(new IndividualChangesetInfo(this.changesetInfoList.size() + 1, deployedChangeSet.getAuthor(), deployedChangeSet.getId(), deployedChangeSet.getFilePath(), deployedChangeSet.getComments(), changesetOutcome, errorMsg, deployedChangeSet.getLabels() == null ? null : deployedChangeSet.getLabels().toString(), deployedChangeSet.getContextFilter() == null ? null : deployedChangeSet.getContextFilter().getOriginalString(), UpdateReportParameters.buildAttributesString(deployedChangeSet), deployedChangeSet.getGeneratedSql()));
                }
            }
        }

        public int getChangesetCount() {
            return this.changesetCount;
        }

        public List<IndividualChangesetInfo> getChangesetInfoList() {
            return this.changesetInfoList;
        }

        public void setChangesetCount(int changesetCount) {
            this.changesetCount = changesetCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangesetInfo)) {
                return false;
            }
            ChangesetInfo other = (ChangesetInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getChangesetCount() != other.getChangesetCount()) {
                return false;
            }
            List<IndividualChangesetInfo> this$changesetInfoList = this.getChangesetInfoList();
            List<IndividualChangesetInfo> other$changesetInfoList = other.getChangesetInfoList();
            return !(this$changesetInfoList == null ? other$changesetInfoList != null : !((Object)this$changesetInfoList).equals(other$changesetInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChangesetInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getChangesetCount();
            List<IndividualChangesetInfo> $changesetInfoList = this.getChangesetInfoList();
            result = result * 59 + ($changesetInfoList == null ? 43 : ((Object)$changesetInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.ChangesetInfo(changesetCount=" + this.getChangesetCount() + ", changesetInfoList=" + this.getChangesetInfoList() + ")";
        }
    }

    public static class CustomData {
        private String customDataFile;
        private Map<String, Object> fileContents;

        public String getCustomDataFile() {
            return this.customDataFile;
        }

        public Map<String, Object> getFileContents() {
            return this.fileContents;
        }

        public void setCustomDataFile(String customDataFile) {
            this.customDataFile = customDataFile;
        }

        public void setFileContents(Map<String, Object> fileContents) {
            this.fileContents = fileContents;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomData)) {
                return false;
            }
            CustomData other = (CustomData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$customDataFile = this.getCustomDataFile();
            String other$customDataFile = other.getCustomDataFile();
            if (this$customDataFile == null ? other$customDataFile != null : !this$customDataFile.equals(other$customDataFile)) {
                return false;
            }
            Map<String, Object> this$fileContents = this.getFileContents();
            Map<String, Object> other$fileContents = other.getFileContents();
            return !(this$fileContents == null ? other$fileContents != null : !((Object)this$fileContents).equals(other$fileContents));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $customDataFile = this.getCustomDataFile();
            result = result * 59 + ($customDataFile == null ? 43 : $customDataFile.hashCode());
            Map<String, Object> $fileContents = this.getFileContents();
            result = result * 59 + ($fileContents == null ? 43 : ((Object)$fileContents).hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.CustomData(customDataFile=" + this.getCustomDataFile() + ", fileContents=" + this.getFileContents() + ")";
        }
    }

    public static class OperationInfo {
        private String command;
        private String operationOutcome;
        private String operationOutcomeErrorMsg;

        public String getCommand() {
            return this.command;
        }

        public String getOperationOutcome() {
            return this.operationOutcome;
        }

        public String getOperationOutcomeErrorMsg() {
            return this.operationOutcomeErrorMsg;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public void setOperationOutcome(String operationOutcome) {
            this.operationOutcome = operationOutcome;
        }

        public void setOperationOutcomeErrorMsg(String operationOutcomeErrorMsg) {
            this.operationOutcomeErrorMsg = operationOutcomeErrorMsg;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationInfo)) {
                return false;
            }
            OperationInfo other = (OperationInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$command = this.getCommand();
            String other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            String this$operationOutcome = this.getOperationOutcome();
            String other$operationOutcome = other.getOperationOutcome();
            if (this$operationOutcome == null ? other$operationOutcome != null : !this$operationOutcome.equals(other$operationOutcome)) {
                return false;
            }
            String this$operationOutcomeErrorMsg = this.getOperationOutcomeErrorMsg();
            String other$operationOutcomeErrorMsg = other.getOperationOutcomeErrorMsg();
            return !(this$operationOutcomeErrorMsg == null ? other$operationOutcomeErrorMsg != null : !this$operationOutcomeErrorMsg.equals(other$operationOutcomeErrorMsg));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OperationInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            String $operationOutcome = this.getOperationOutcome();
            result = result * 59 + ($operationOutcome == null ? 43 : $operationOutcome.hashCode());
            String $operationOutcomeErrorMsg = this.getOperationOutcomeErrorMsg();
            result = result * 59 + ($operationOutcomeErrorMsg == null ? 43 : $operationOutcomeErrorMsg.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.OperationInfo(command=" + this.getCommand() + ", operationOutcome=" + this.getOperationOutcome() + ", operationOutcomeErrorMsg=" + this.getOperationOutcomeErrorMsg() + ")";
        }
    }

    public static class RuntimeInfo {
        private final String systemUsername = System.getProperty("user.name");
        private final String hostname = NetUtil.getLocalHostName();
        private final String os = System.getProperty("os.name");
        private String interfaceType;
        private String startTime;

        public String getSystemUsername() {
            return this.systemUsername;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getOs() {
            return this.os;
        }

        public String getInterfaceType() {
            return this.interfaceType;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuntimeInfo)) {
                return false;
            }
            RuntimeInfo other = (RuntimeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$systemUsername = this.getSystemUsername();
            String other$systemUsername = other.getSystemUsername();
            if (this$systemUsername == null ? other$systemUsername != null : !this$systemUsername.equals(other$systemUsername)) {
                return false;
            }
            String this$hostname = this.getHostname();
            String other$hostname = other.getHostname();
            if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
                return false;
            }
            String this$os = this.getOs();
            String other$os = other.getOs();
            if (this$os == null ? other$os != null : !this$os.equals(other$os)) {
                return false;
            }
            String this$interfaceType = this.getInterfaceType();
            String other$interfaceType = other.getInterfaceType();
            if (this$interfaceType == null ? other$interfaceType != null : !this$interfaceType.equals(other$interfaceType)) {
                return false;
            }
            String this$startTime = this.getStartTime();
            String other$startTime = other.getStartTime();
            return !(this$startTime == null ? other$startTime != null : !this$startTime.equals(other$startTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RuntimeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $systemUsername = this.getSystemUsername();
            result = result * 59 + ($systemUsername == null ? 43 : $systemUsername.hashCode());
            String $hostname = this.getHostname();
            result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
            String $os = this.getOs();
            result = result * 59 + ($os == null ? 43 : $os.hashCode());
            String $interfaceType = this.getInterfaceType();
            result = result * 59 + ($interfaceType == null ? 43 : $interfaceType.hashCode());
            String $startTime = this.getStartTime();
            result = result * 59 + ($startTime == null ? 43 : $startTime.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.RuntimeInfo(systemUsername=" + this.getSystemUsername() + ", hostname=" + this.getHostname() + ", os=" + this.getOs() + ", interfaceType=" + this.getInterfaceType() + ", startTime=" + this.getStartTime() + ")";
        }
    }

    public static class DatabaseInfo {
        private String databaseType;
        private String version;

        public String getDatabaseType() {
            return this.databaseType;
        }

        public String getVersion() {
            return this.version;
        }

        public void setDatabaseType(String databaseType) {
            this.databaseType = databaseType;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatabaseInfo)) {
                return false;
            }
            DatabaseInfo other = (DatabaseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$databaseType = this.getDatabaseType();
            String other$databaseType = other.getDatabaseType();
            if (this$databaseType == null ? other$databaseType != null : !this$databaseType.equals(other$databaseType)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DatabaseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $databaseType = this.getDatabaseType();
            result = result * 59 + ($databaseType == null ? 43 : $databaseType.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        public String toString() {
            return "UpdateReportParameters.DatabaseInfo(databaseType=" + this.getDatabaseType() + ", version=" + this.getVersion() + ")";
        }
    }
}

