/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReflectorAtmosphereHandler
implements AtmosphereHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReflectorAtmosphereHandler.class);
    private Boolean twoStepsWrite = null;

    @Override
    public void onStateChange(AtmosphereResourceEvent event) throws IOException {
        Object message = event.getMessage();
        AtmosphereResource resource = event.getResource();
        AtmosphereResponse r = resource.getResponse();
        AtmosphereRequest request = resource.getRequest();
        boolean writeAsBytes = IOUtils.isBodyBinary(request);
        if (message == null) {
            logger.trace("Message was null for AtmosphereEvent {}", (Object)event);
            return;
        }
        if (resource.getSerializer() != null) {
            try {
                if (message instanceof List) {
                    for (Object s : (List)message) {
                        resource.getSerializer().write((OutputStream)resource.getResponse().getOutputStream(), s);
                    }
                }
                resource.getSerializer().write((OutputStream)resource.getResponse().getOutputStream(), message);
            }
            catch (Throwable ex) {
                logger.warn("Serializer exception: message: {}", message, (Object)ex);
                throw new IOException(ex);
            }
        } else {
            boolean isUsingStream = true;
            Object o = resource.getRequest().getAttribute("org.atmosphere.useStream");
            if (o != null) {
                isUsingStream = (Boolean)o;
            }
            if (!isUsingStream) {
                try {
                    r.getWriter();
                }
                catch (IllegalStateException e) {
                    isUsingStream = true;
                }
                if (writeAsBytes) {
                    throw new IllegalStateException("Cannot write bytes using PrintWriter");
                }
            }
            if (message instanceof List) {
                Iterator i = ((List)message).iterator();
                try {
                    while (i.hasNext()) {
                        Object s = i.next();
                        if (String.class.isAssignableFrom(s.getClass())) {
                            if (isUsingStream) {
                                r.getOutputStream().write(s.toString().getBytes(r.getCharacterEncoding()));
                            } else {
                                r.getWriter().write(s.toString());
                            }
                        } else if (byte[].class.isAssignableFrom(s.getClass())) {
                            if (isUsingStream) {
                                r.getOutputStream().write((byte[])s);
                            } else {
                                r.getWriter().write(s.toString());
                            }
                        } else if (isUsingStream) {
                            r.getOutputStream().write(s.toString().getBytes(r.getCharacterEncoding()));
                        } else {
                            r.getWriter().write(s.toString());
                        }
                        i.remove();
                    }
                }
                catch (IOException ex) {
                    event.setMessage(new ArrayList().addAll((List)message));
                    throw ex;
                }
                if (isUsingStream) {
                    r.getOutputStream().flush();
                } else {
                    r.getWriter().flush();
                }
            } else if (isUsingStream) {
                r.getOutputStream().write(writeAsBytes ? (byte[])message : message.toString().getBytes(r.getCharacterEncoding()));
                r.getOutputStream().flush();
            } else {
                r.getWriter().write(message.toString());
                r.getWriter().flush();
            }
        }
        this.postStateChange(event);
    }

    protected void write(AtmosphereResourceEvent event, ServletOutputStream o, byte[] data) throws IOException {
        if (this.useTwoStepWrite(event) && data.length > 1) {
            this.twoStepWrite(o, data);
        } else {
            o.write(data);
            o.flush();
        }
    }

    private void twoStepWrite(ServletOutputStream o, byte[] data) throws IOException {
        o.write(data, 0, 1);
        o.flush();
        o.write(data, 1, data.length - 1);
        o.flush();
    }

    protected boolean useTwoStepWrite(AtmosphereResourceEvent event) {
        return this.isTwoStepsWriteEnabled(event) && event.getResource().transport() == AtmosphereResource.TRANSPORT.LONG_POLLING;
    }

    protected final void postStateChange(AtmosphereResourceEvent event) {
        Object o;
        if (event.isCancelled() || event.isResuming()) {
            return;
        }
        AtmosphereResourceImpl r = (AtmosphereResourceImpl)AtmosphereResourceImpl.class.cast(event.getResource());
        if (r == null) {
            logger.trace("Event {} returned a null AtmosphereResource", (Object)event);
            return;
        }
        Boolean resumeOnBroadcast = r.resumeOnBroadcast();
        if (!resumeOnBroadcast.booleanValue() && (o = r.getRequest(false).getAttribute("org.atmosphere.resumeOnBroadcast")) != null && Boolean.class.isAssignableFrom(o.getClass())) {
            resumeOnBroadcast = (Boolean)Boolean.class.cast(o);
        }
        if (resumeOnBroadcast != null && resumeOnBroadcast.booleanValue()) {
            r.resume();
        }
    }

    @Override
    public void destroy() {
    }

    private boolean isTwoStepsWriteEnabled(AtmosphereResourceEvent event) {
        if (this.twoStepsWrite == null) {
            AtmosphereConfig config = event.getResource().getAtmosphereConfig();
            this.twoStepsWrite = config.getInitParameter("org.atmosphere.cpr.AbstractReflectorAtmosphereHandler.twoStepsWrite", false);
        }
        return this.twoStepsWrite;
    }

    public static final class Default
    extends AbstractReflectorAtmosphereHandler {
        @Override
        public void onRequest(AtmosphereResource resource) throws IOException {
        }
    }
}

