/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.internal.StringUtils;
import net.sf.practicalxml.util.NodeListIterator;
import net.sf.practicalxml.xpath.NamespaceResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtil {
    private static volatile DocumentBuilder _docBuilder;

    public static Document newDocument() {
        return DomUtil.getDocumentBuilder().newDocument();
    }

    public static Element newDocument(String nsUri, String qname) {
        Document doc = DomUtil.getDocumentBuilder().newDocument();
        Element root = doc.createElementNS(nsUri, qname);
        doc.appendChild(root);
        return root;
    }

    public static Element newDocument(String name) {
        return DomUtil.newDocument(null, name);
    }

    public static Element newDocument(QName qname) {
        String prefix;
        String nsUri = qname.getNamespaceURI();
        if ("".equals(nsUri) || "".equals(nsUri)) {
            nsUri = null;
        }
        if ("".equals(prefix = qname.getPrefix()) || "".equals(prefix)) {
            prefix = null;
        }
        String name = qname.getLocalPart();
        if (prefix != null) {
            name = prefix + ":" + name;
        }
        return DomUtil.newDocument(nsUri, name);
    }

    public static Element appendChild(Element parent, String lclName) {
        return DomUtil.appendChild(parent, null, lclName);
    }

    public static Element appendChild(Element parent, String nsUri, String qname) {
        Element child = parent.getOwnerDocument().createElementNS(nsUri, qname);
        parent.appendChild(child);
        return child;
    }

    public static Element appendChildInheritNamespace(Element parent, String qname) {
        String nsUri = parent.getNamespaceURI();
        String parentPrefix = parent.getPrefix();
        if (nsUri != null && parentPrefix != null && qname.indexOf(58) < 0) {
            qname = parentPrefix + ":" + qname;
        }
        return DomUtil.appendChild(parent, nsUri, qname);
    }

    public static List<Element> getSiblings(Element elem) {
        if (elem.getParentNode() instanceof Element) {
            return DomUtil.getChildren((Element)elem.getParentNode());
        }
        ArrayList<Element> ret = new ArrayList<Element>();
        ret.add(elem);
        return ret;
    }

    public static List<Element> getSiblings(Element elem, String lclName) {
        if (elem.getParentNode() instanceof Element) {
            return DomUtil.getChildren((Element)elem.getParentNode(), lclName);
        }
        return new ArrayList<Element>();
    }

    public static List<Element> getSiblings(Element elem, String nsUri, String lclName) {
        if (elem.getParentNode() instanceof Element) {
            return DomUtil.getChildren((Element)elem.getParentNode(), nsUri, lclName);
        }
        return new ArrayList<Element>();
    }

    public static boolean hasChildren(Element elem) {
        return elem.getFirstChild() != null;
    }

    public static boolean hasElementChildren(Element elem) {
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasTextChildren(Element elem) {
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Text) && !(child instanceof CDATASection)) continue;
            return true;
        }
        return false;
    }

    public static List<Element> getChildren(Node parent) {
        return DomUtil.filter(parent.getChildNodes(), Element.class);
    }

    public static List<Element> getChildren(Node parent, String lclName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeListIterator itx = new NodeListIterator(parent.getChildNodes(), Element.class);
        while (itx.hasNext()) {
            Element child = (Element)itx.next();
            if (!lclName.equals(DomUtil.getLocalName(child))) continue;
            ret.add(child);
        }
        return ret;
    }

    public static List<Element> getChildren(Node parent, String nsUri, String lclName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        NodeListIterator itx = new NodeListIterator(parent.getChildNodes(), Element.class);
        while (itx.hasNext()) {
            Element child = (Element)itx.next();
            if (!DomUtil.isNamed(child, nsUri, lclName)) continue;
            ret.add(child);
        }
        return ret;
    }

    public static Element getChild(Node parent, String lclName) {
        List<Element> children = DomUtil.getChildren(parent, lclName);
        return children.size() > 0 ? children.get(0) : null;
    }

    public static Element getChild(Node parent, String nsUri, String lclName) {
        List<Element> children = DomUtil.getChildren(parent, nsUri, lclName);
        return children.size() > 0 ? children.get(0) : null;
    }

    public static List<Attr> getAttributes(Element elem) {
        ArrayList<Attr> result = new ArrayList<Attr>();
        NamedNodeMap attrs = elem.getAttributes();
        for (int ii = 0; ii < attrs.getLength(); ++ii) {
            result.add((Attr)attrs.item(ii));
        }
        return result;
    }

    public static String getText(Element elem) {
        StringBuilder sb = new StringBuilder();
        boolean hasText = false;
        NodeList children = elem.getChildNodes();
        block3: for (int ii = 0; ii < children.getLength(); ++ii) {
            Node child = children.item(ii);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    sb.append(child.getTextContent());
                    hasText = true;
                    continue block3;
                }
            }
        }
        return hasText ? sb.toString() : null;
    }

    public static Text appendText(Element elem, String text) {
        Text child = elem.getOwnerDocument().createTextNode(text);
        elem.appendChild(child);
        return child;
    }

    public static void setText(Element elem, String text) {
        NodeList children = elem.getChildNodes();
        block3: for (int ii = children.getLength() - 1; ii >= 0; --ii) {
            Node child = children.item(ii);
            switch (child.getNodeType()) {
                case 3: 
                case 4: {
                    elem.removeChild(child);
                    continue block3;
                }
            }
        }
        DomUtil.appendText(elem, text);
    }

    public static void trimTextRecursive(Node node) {
        NodeListIterator itx = new NodeListIterator(node.getChildNodes());
        while (itx.hasNext()) {
            Node child = (Node)itx.next();
            switch (child.getNodeType()) {
                case 1: {
                    DomUtil.trimTextRecursive((Element)child);
                    break;
                }
                case 3: 
                case 4: {
                    String value = StringUtils.trimToEmpty(((Text)child).getData());
                    if (StringUtils.isEmpty(value)) {
                        itx.remove();
                        break;
                    }
                    ((Text)child).setData(value);
                    break;
                }
            }
        }
    }

    public static void removeEmptyTextRecursive(Node node) {
        NodeListIterator itx = new NodeListIterator(node.getChildNodes());
        while (itx.hasNext()) {
            Node child = (Node)itx.next();
            switch (child.getNodeType()) {
                case 1: {
                    DomUtil.removeEmptyTextRecursive((Element)child);
                    break;
                }
                case 3: 
                case 4: {
                    if (!StringUtils.isBlank(child.getNodeValue())) break;
                    itx.remove();
                    break;
                }
            }
        }
    }

    public static String getLocalName(Element elem) {
        return elem.getNamespaceURI() == null ? elem.getTagName() : elem.getLocalName();
    }

    public static String getLocalName(Attr attr) {
        return attr.getNamespaceURI() == null ? attr.getName() : attr.getLocalName();
    }

    public static boolean isNamed(Element elem, String nsUri, String localName) {
        if (localName == null) {
            throw new IllegalArgumentException("localName must have a value");
        }
        if (nsUri == null) {
            return elem.getNamespaceURI() == null ? localName.equals(elem.getTagName()) : false;
        }
        return nsUri.equals(elem.getNamespaceURI()) && localName.equals(elem.getLocalName());
    }

    public static <T> List<T> asList(NodeList nodelist, Class<T> ofClass) {
        int size = nodelist.getLength();
        ArrayList<T> result = new ArrayList<T>(size);
        for (int ii = 0; ii < size; ++ii) {
            result.add(ofClass.cast(nodelist.item(ii)));
        }
        return result;
    }

    public static <T> List<T> filter(NodeList list, Class<T> klass) {
        ArrayList<T> result = new ArrayList<T>(list.getLength());
        NodeListIterator itx = new NodeListIterator(list);
        while (itx.hasNext()) {
            Node node = (Node)itx.next();
            if (!klass.isInstance(node)) continue;
            result.add(klass.cast(node));
        }
        return result;
    }

    public static String getPath(Element elem, String ... attrNames) {
        StringBuilder sb = new StringBuilder();
        DomUtil.buildPath(elem, sb, attrNames);
        return sb.toString();
    }

    public static String getAbsolutePath(Element elem) {
        StringBuilder sb = new StringBuilder();
        DomUtil.buildAbsolutePath(elem, sb, null, null, null);
        return sb.toString();
    }

    public static String getAbsolutePath(Element elem, NamespaceContext nsLookup) {
        StringBuilder sb = new StringBuilder();
        DomUtil.buildAbsolutePath(elem, sb, nsLookup, new NamespaceResolver(), new int[]{0});
        return sb.toString();
    }

    public static String getAbsolutePath(Element elem, NamespaceResolver nsLookup) {
        StringBuilder sb = new StringBuilder();
        DomUtil.buildAbsolutePath(elem, sb, nsLookup, nsLookup, new int[]{0});
        return sb.toString();
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            if (_docBuilder == null) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                _docBuilder = dbf.newDocumentBuilder();
            }
            return _docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("unable to configure DocumentBuilder", e);
        }
    }

    private static void buildPath(Element elem, StringBuilder sb, String[] attrNames) {
        Node parent = elem.getParentNode();
        if (parent instanceof Element) {
            DomUtil.buildPath((Element)parent, sb, attrNames);
        }
        sb.append("/").append(elem.getNodeName());
        for (String name : attrNames) {
            String value = elem.getAttribute(name);
            if (StringUtils.isEmpty(value)) continue;
            sb.append("[").append(name).append("='").append(value).append("']");
        }
    }

    private static void buildAbsolutePath(Element elem, StringBuilder sb, NamespaceContext nsLookup, NamespaceResolver genLookup, int[] nsCounter) {
        Node parent = elem.getParentNode();
        if (parent instanceof Element) {
            DomUtil.buildAbsolutePath((Element)parent, sb, nsLookup, genLookup, nsCounter);
        }
        String prefix = DomUtil.getPrefix(elem, nsLookup, genLookup, nsCounter);
        String localName = DomUtil.getLocalName(elem);
        List<Element> siblings = nsLookup == null ? DomUtil.getSiblings(elem, DomUtil.getLocalName(elem)) : DomUtil.getSiblings(elem, elem.getNamespaceURI(), DomUtil.getLocalName(elem));
        sb.append("/");
        if (prefix != null) {
            sb.append(prefix).append(":");
        }
        sb.append(localName);
        if (siblings.size() > 1) {
            sb.append("[").append(DomUtil.getIndex(elem, siblings)).append("]");
        }
    }

    private static String getPrefix(Element elem, NamespaceContext nsLookup, NamespaceResolver genLookup, int[] nsCounter) {
        if (nsLookup == null) {
            return null;
        }
        String nsUri = elem.getNamespaceURI();
        if (nsUri == null) {
            return null;
        }
        String prefix = nsLookup.getPrefix(nsUri);
        if (prefix != null) {
            return prefix;
        }
        prefix = genLookup.getPrefix(nsUri);
        if (prefix != null) {
            return prefix;
        }
        while (prefix == null) {
            int n = nsCounter[0];
            nsCounter[0] = n + 1;
            prefix = "NS" + n;
            if (nsLookup.getNamespaceURI(prefix) == null && genLookup.getNamespaceURI(prefix) == null) continue;
            prefix = null;
        }
        genLookup.addNamespace(prefix, nsUri);
        return prefix;
    }

    private static int getIndex(Element elem, List<Element> siblings) {
        int elemPos = 0;
        for (Element sibling : siblings) {
            ++elemPos;
            if (sibling != elem) continue;
            return elemPos;
        }
        throw new IllegalArgumentException("element not amongst its siblings");
    }
}

