/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.json;

import java.util.EnumSet;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.converter.ConversionException;
import net.sf.practicalxml.converter.internal.JsonUtils;
import net.sf.practicalxml.converter.json.Json2XmlOptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Json2XmlConverter {
    private EnumSet<Json2XmlOptions> _options = EnumSet.noneOf(Json2XmlOptions.class);
    private String _src;
    private int _curPos;
    private int _nextPos;

    public Json2XmlConverter(String src, Json2XmlOptions ... options) {
        this._src = src;
        for (Json2XmlOptions option : options) {
            this._options.add(option);
        }
    }

    public Element convert() {
        return this.convert("data");
    }

    public Element convert(String localName) {
        return this.convert(null, localName);
    }

    public Element convert(String nsUri, String qname) {
        Element root = DomUtil.newDocument(nsUri, qname);
        this.convert(root);
        return root;
    }

    public void convert(Element parent) {
        this.parse(parent);
    }

    private void parse(Element parent) {
        String first = this.nextToken();
        if (first.equals("{")) {
            this.parseObject(parent);
        } else if (first.equals("[")) {
            this.parseArray(parent);
        } else {
            throw new ConversionException(this.commonExceptionText("unexpected content start of line"));
        }
        if (this.nextToken().length() > 0) {
            throw new ConversionException(this.commonExceptionText("unexpected content at end of line"));
        }
    }

    private String valueDispatch(String next, Element parent) {
        if (next.equals("{")) {
            this.parseObject(parent);
        } else if (next.equals("[")) {
            this.parseArray(parent);
        } else if (next.equals("\"")) {
            DomUtil.setText(parent, this.parseString());
        } else {
            DomUtil.setText(parent, next);
        }
        return this.nextToken();
    }

    private void parseObject(Element parent) {
        String next = this.nextToken();
        if (this.atEndOfSequence(next, "}", false)) {
            return;
        }
        while (true) {
            if (next.equals("\"")) {
                next = this.parseString();
            }
            Element child = this.appendChild(parent, next);
            this.expect(":");
            next = this.valueDispatch(this.nextToken(), child);
            if (this.atEndOfSequence(next, "}", true)) {
                return;
            }
            next = this.nextToken();
        }
    }

    private void parseArray(Element parent) {
        String next;
        String childName = "data";
        if (this._options.contains((Object)Json2XmlOptions.ARRAYS_AS_REPEATED_ELEMENTS)) {
            Node realParent = parent.getParentNode();
            if (!(realParent instanceof Element)) {
                throw new ConversionException(this.commonExceptionText("cannot convert top-level array as repeated elements"));
            }
            childName = DomUtil.getLocalName(parent);
            realParent.removeChild(parent);
            parent = (Element)realParent;
        }
        if (this.atEndOfSequence(next = this.nextToken(), "]", false)) {
            return;
        }
        Element child;
        while (!this.atEndOfSequence(next = this.valueDispatch(next, child = this.appendChild(parent, childName)), "]", true)) {
            next = this.nextToken();
        }
        return;
    }

    private String parseString() {
        try {
            this._curPos = this._nextPos;
            while (this._nextPos < this._src.length()) {
                char c = this._src.charAt(this._nextPos);
                if (c == '\"') {
                    return JsonUtils.unescape(this._src.substring(this._curPos, this._nextPos++));
                }
                if (c == '\\') {
                    ++this._nextPos;
                }
                ++this._nextPos;
            }
            throw new ConversionException(this.commonExceptionText("unterminated string"));
        }
        catch (IllegalArgumentException ee) {
            throw new ConversionException(this.commonExceptionText("invalid string"), ee);
        }
    }

    private String expect(String expected) {
        String next = this.nextToken();
        if (next.equals(expected)) {
            return next;
        }
        throw new ConversionException(this.commonExceptionText("unexpected token"));
    }

    private boolean atEndOfSequence(String next, String expectedEnd, boolean throwIfSomethingElse) {
        if (next.equals(expectedEnd)) {
            return true;
        }
        if (next.equals(",")) {
            return false;
        }
        if (next.equals("")) {
            throw new ConversionException(this.commonExceptionText("unexpected end of input"));
        }
        if (throwIfSomethingElse) {
            throw new ConversionException(this.commonExceptionText("unexpected token"));
        }
        return false;
    }

    private String nextToken() {
        int len = this._src.length();
        this._curPos = this._nextPos;
        while (this._curPos < len && Character.isWhitespace(this._src.charAt(this._curPos))) {
            ++this._curPos;
        }
        if (this._curPos == len) {
            return "";
        }
        this._nextPos = this._curPos + 1;
        if (!this.isDelimiter(this._src.charAt(this._curPos))) {
            while (this._nextPos < len && !Character.isWhitespace(this._src.charAt(this._nextPos)) && !this.isDelimiter(this._src.charAt(this._nextPos))) {
                ++this._nextPos;
            }
        }
        return this._src.substring(this._curPos, this._nextPos);
    }

    private boolean isDelimiter(char c) {
        switch (c) {
            case '\"': 
            case ',': 
            case ':': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private String commonExceptionText(String preamble) {
        String excerpt = this._curPos + 20 > this._src.length() ? this._src.substring(this._curPos) : this._src.substring(this._curPos, this._curPos + 20) + "[...]";
        return preamble + " at position " + this._curPos + ": \"" + excerpt + "\"";
    }

    private Element appendChild(Element parent, String name) {
        if (name.equals("")) {
            throw new ConversionException(this.commonExceptionText("unexpected end of input"));
        }
        if (this.isDelimiter(name.charAt(0))) {
            throw new ConversionException(this.commonExceptionText("invalid token"));
        }
        try {
            return DomUtil.appendChildInheritNamespace(parent, name);
        }
        catch (Exception e) {
            throw new ConversionException(this.commonExceptionText("invalid element name"), e);
        }
    }
}

