/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.buffer.Buffer;
import io.sentry.buffer.DiskBuffer;
import io.sentry.config.Lookup;
import io.sentry.connection.AsyncConnection;
import io.sentry.connection.BufferedConnection;
import io.sentry.connection.Connection;
import io.sentry.connection.HttpConnection;
import io.sentry.connection.NoopConnection;
import io.sentry.connection.OutputStreamConnection;
import io.sentry.connection.ProxyAuthenticator;
import io.sentry.connection.RandomEventSampler;
import io.sentry.context.ContextManager;
import io.sentry.context.ThreadLocalContextManager;
import io.sentry.dsn.Dsn;
import io.sentry.event.helper.ContextBuilderHelper;
import io.sentry.event.helper.HttpEventBuilderHelper;
import io.sentry.event.interfaces.DebugMetaInterface;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.HttpInterface;
import io.sentry.event.interfaces.MessageInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import io.sentry.event.interfaces.UserInterface;
import io.sentry.jvmti.FrameCache;
import io.sentry.marshaller.Marshaller;
import io.sentry.marshaller.json.DebugMetaInterfaceBinding;
import io.sentry.marshaller.json.ExceptionInterfaceBinding;
import io.sentry.marshaller.json.HttpInterfaceBinding;
import io.sentry.marshaller.json.JsonMarshaller;
import io.sentry.marshaller.json.MessageInterfaceBinding;
import io.sentry.marshaller.json.StackTraceInterfaceBinding;
import io.sentry.marshaller.json.UserInterfaceBinding;
import io.sentry.util.Util;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSentryClientFactory
extends SentryClientFactory {
    public static final String NAIVE_PROTOCOL = "naive";
    public static final String COMPRESSION_OPTION = "compression";
    public static final String MAX_MESSAGE_LENGTH_OPTION = "maxmessagelength";
    public static final String CONNECTION_TIMEOUT_OPTION = "timeout";
    public static final int CONNECTION_TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(1L);
    public static final String READ_TIMEOUT_OPTION = "readtimeout";
    public static final int READ_TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(5L);
    public static final String BUFFER_ENABLED_OPTION = "buffer.enabled";
    public static final boolean BUFFER_ENABLED_DEFAULT = true;
    public static final String BUFFER_DIR_OPTION = "buffer.dir";
    public static final String BUFFER_SIZE_OPTION = "buffer.size";
    public static final int BUFFER_SIZE_DEFAULT = 10;
    public static final String BUFFER_FLUSHTIME_OPTION = "buffer.flushtime";
    public static final long BUFFER_FLUSHTIME_DEFAULT = 60000L;
    public static final String BUFFER_GRACEFUL_SHUTDOWN_OPTION = "buffer.gracefulshutdown";
    public static final String BUFFER_SHUTDOWN_TIMEOUT_OPTION = "buffer.shutdowntimeout";
    public static final long BUFFER_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String ASYNC_OPTION = "async";
    public static final String ASYNC_GRACEFUL_SHUTDOWN_OPTION = "async.gracefulshutdown";
    public static final String ASYNC_THREADS_OPTION = "async.threads";
    public static final String ASYNC_PRIORITY_OPTION = "async.priority";
    public static final String ASYNC_QUEUE_SIZE_OPTION = "async.queuesize";
    public static final String ASYNC_QUEUE_OVERFLOW_OPTION = "async.queue.overflow";
    public static final String ASYNC_QUEUE_DISCARDOLD = "discardold";
    public static final String ASYNC_QUEUE_DISCARDNEW = "discardnew";
    public static final String ASYNC_QUEUE_SYNC = "sync";
    public static final String ASYNC_QUEUE_OVERFLOW_DEFAULT = "discardold";
    public static final String ASYNC_SHUTDOWN_TIMEOUT_OPTION = "async.shutdowntimeout";
    public static final long ASYNC_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String IN_APP_FRAMES_OPTION = "stacktrace.app.packages";
    public static final String HIDE_COMMON_FRAMES_OPTION = "stacktrace.hidecommon";
    public static final String SAMPLE_RATE_OPTION = "sample.rate";
    public static final String HTTP_PROXY_HOST_OPTION = "http.proxy.host";
    public static final String HTTP_PROXY_PORT_OPTION = "http.proxy.port";
    public static final String HTTP_PROXY_USER_OPTION = "http.proxy.user";
    public static final String HTTP_PROXY_PASS_OPTION = "http.proxy.password";
    public static final int QUEUE_SIZE_DEFAULT = 50;
    public static final int HTTP_PROXY_PORT_DEFAULT = 80;
    public static final String RELEASE_OPTION = "release";
    public static final String DIST_OPTION = "dist";
    public static final String ENVIRONMENT_OPTION = "environment";
    public static final String SERVERNAME_OPTION = "servername";
    public static final String TAGS_OPTION = "tags";
    @Deprecated
    public static final String EXTRATAGS_OPTION = "extratags";
    public static final String MDCTAGS_OPTION = "mdctags";
    public static final String EXTRA_OPTION = "extra";
    public static final String UNCAUGHT_HANDLER_ENABLED_OPTION = "uncaught.handler.enabled";
    private static final Logger logger = LoggerFactory.getLogger(DefaultSentryClientFactory.class);
    private static final String FALSE = Boolean.FALSE.toString();
    private static final Map<String, RejectedExecutionHandler> REJECT_EXECUTION_HANDLERS = new HashMap<String, RejectedExecutionHandler>();

    public DefaultSentryClientFactory() {
        this(Lookup.getDefault());
    }

    public DefaultSentryClientFactory(Lookup lookup) {
        super(lookup);
    }

    @Override
    public SentryClient createSentryClient(Dsn dsn) {
        try {
            SentryClient sentryClient = new SentryClient(this.createConnection(dsn), this.getContextManager(dsn));
            try {
                Class.forName("javax.servlet.ServletRequestListener", false, this.getClass().getClassLoader());
                sentryClient.addBuilderHelper(new HttpEventBuilderHelper());
            }
            catch (ClassNotFoundException e) {
                logger.debug("The current environment doesn't provide access to servlets, or provides an unsupported version.");
            }
            sentryClient.addBuilderHelper(new ContextBuilderHelper(sentryClient));
            return this.configureSentryClient(sentryClient, dsn);
        }
        catch (RuntimeException e) {
            logger.error("Failed to initialize sentry, falling back to no-op client", (Throwable)e);
            return new SentryClient(new NoopConnection(), new ThreadLocalContextManager());
        }
    }

    protected SentryClient configureSentryClient(SentryClient sentryClient, Dsn dsn) {
        Map<String, String> map;
        Set<String> mdcTags;
        Map<String, String> tags;
        String serverName;
        String environment;
        String dist;
        String release = this.getRelease(dsn);
        if (release != null) {
            sentryClient.setRelease(release);
        }
        if ((dist = this.getDist(dsn)) != null) {
            sentryClient.setDist(dist);
        }
        if ((environment = this.getEnvironment(dsn)) != null) {
            sentryClient.setEnvironment(environment);
        }
        if ((serverName = this.getServerName(dsn)) != null) {
            sentryClient.setServerName(serverName);
        }
        if (!(tags = this.getTags(dsn)).isEmpty()) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                sentryClient.addTag(entry.getKey(), entry.getValue());
            }
        }
        if (!(mdcTags = this.getMdcTags(dsn)).isEmpty()) {
            for (String mdcTag : mdcTags) {
                sentryClient.addMdcTag(mdcTag);
            }
        }
        if (!(map = this.getExtra(dsn)).isEmpty()) {
            for (Map.Entry<String, String> extraEntry : map.entrySet()) {
                sentryClient.addExtra(extraEntry.getKey(), extraEntry.getValue());
            }
        }
        if (this.getUncaughtHandlerEnabled(dsn)) {
            sentryClient.setupUncaughtExceptionHandler();
        }
        for (String inAppPackage : this.getInAppFrames(dsn)) {
            FrameCache.addAppPackage(inAppPackage);
        }
        return sentryClient;
    }

    protected Connection createConnection(Dsn dsn) {
        Buffer eventBuffer;
        Connection connection;
        String protocol = dsn.getProtocol();
        if (protocol.equalsIgnoreCase("http") || protocol.equalsIgnoreCase("https")) {
            logger.debug("Using an {} connection to Sentry.", (Object)protocol.toUpperCase());
            connection = this.createHttpConnection(dsn);
        } else if (protocol.equalsIgnoreCase("out")) {
            logger.debug("Using StdOut to send events.");
            connection = this.createStdOutConnection(dsn);
        } else if (protocol.equalsIgnoreCase("noop")) {
            logger.debug("Using noop to send events.");
            connection = new NoopConnection();
        } else {
            throw new IllegalStateException("Couldn't create a connection for the protocol '" + protocol + "'");
        }
        BufferedConnection bufferedConnection = null;
        if (this.getBufferEnabled(dsn) && (eventBuffer = this.getBuffer(dsn)) != null) {
            long flushtime = this.getBufferFlushtime(dsn);
            boolean gracefulShutdown = this.getBufferedConnectionGracefulShutdownEnabled(dsn);
            Long shutdownTimeout = this.getBufferedConnectionShutdownTimeout(dsn);
            bufferedConnection = new BufferedConnection(connection, eventBuffer, flushtime, gracefulShutdown, shutdownTimeout);
            connection = bufferedConnection;
        }
        if (this.getAsyncEnabled(dsn)) {
            connection = this.createAsyncConnection(dsn, connection);
        }
        if (bufferedConnection != null) {
            connection = bufferedConnection.wrapConnectionWithBufferWriter(connection);
        }
        return connection;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        int maxThreads = this.getAsyncThreads(dsn);
        int priority = this.getAsyncPriority(dsn);
        int queueSize = this.getAsyncQueueSize(dsn);
        LinkedBlockingDeque<Runnable> queue = queueSize == -1 ? new LinkedBlockingDeque<Runnable>() : new LinkedBlockingDeque(queueSize);
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(maxThreads, maxThreads, 0L, TimeUnit.MILLISECONDS, queue, new DaemonThreadFactory(priority), this.getRejectedExecutionHandler(dsn));
        boolean gracefulShutdown = this.getAsyncGracefulShutdownEnabled(dsn);
        long shutdownTimeout = this.getAsyncShutdownTimeout(dsn);
        return new AsyncConnection(connection, executorService, gracefulShutdown, shutdownTimeout);
    }

    protected Connection createHttpConnection(Dsn dsn) {
        URL sentryApiUrl = HttpConnection.getSentryApiUrl(dsn.getUri(), dsn.getProjectId());
        String proxyHost = this.getProxyHost(dsn);
        String proxyUser = this.getProxyUser(dsn);
        String proxyPass = this.getProxyPass(dsn);
        int proxyPort = this.getProxyPort(dsn);
        Proxy proxy = null;
        if (proxyHost != null) {
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost, proxyPort);
            proxy = new Proxy(Proxy.Type.HTTP, proxyAddr);
            if (proxyUser != null && proxyPass != null) {
                Authenticator.setDefault(new ProxyAuthenticator(proxyUser, proxyPass));
            }
        }
        Double sampleRate = this.getSampleRate(dsn);
        RandomEventSampler eventSampler = null;
        if (sampleRate != null) {
            eventSampler = new RandomEventSampler(sampleRate);
        }
        HttpConnection httpConnection = new HttpConnection(sentryApiUrl, dsn.getPublicKey(), dsn.getSecretKey(), proxy, eventSampler);
        Marshaller marshaller = this.createMarshaller(dsn);
        httpConnection.setMarshaller(marshaller);
        int timeout = this.getTimeout(dsn);
        httpConnection.setConnectionTimeout(timeout);
        int readTimeout = this.getReadTimeout(dsn);
        httpConnection.setReadTimeout(readTimeout);
        boolean bypassSecurityEnabled = this.getBypassSecurityEnabled(dsn);
        httpConnection.setBypassSecurity(bypassSecurityEnabled);
        return httpConnection;
    }

    protected Connection createStdOutConnection(Dsn dsn) {
        OutputStreamConnection stdOutConnection = new OutputStreamConnection(System.out);
        stdOutConnection.setMarshaller(this.createMarshaller(dsn));
        return stdOutConnection;
    }

    protected Marshaller createMarshaller(Dsn dsn) {
        int maxMessageLength = this.getMaxMessageLength(dsn);
        JsonMarshaller marshaller = this.createJsonMarshaller(maxMessageLength);
        StackTraceInterfaceBinding stackTraceBinding = new StackTraceInterfaceBinding();
        stackTraceBinding.setRemoveCommonFramesWithEnclosing(this.getHideCommonFramesEnabled(dsn));
        stackTraceBinding.setInAppFrames(this.getInAppFrames(dsn));
        marshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceBinding);
        marshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceBinding));
        marshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding(maxMessageLength));
        marshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        marshaller.addInterfaceBinding(DebugMetaInterface.class, new DebugMetaInterfaceBinding());
        HttpInterfaceBinding httpBinding = new HttpInterfaceBinding();
        marshaller.addInterfaceBinding(HttpInterface.class, httpBinding);
        marshaller.setCompression(this.getCompressionEnabled(dsn));
        return marshaller;
    }

    protected JsonMarshaller createJsonMarshaller(int maxMessageLength) {
        return new JsonMarshaller(maxMessageLength);
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new ThreadLocalContextManager();
    }

    protected Collection<String> getInAppFrames(Dsn dsn) {
        String inAppFramesOption = this.lookup.get(IN_APP_FRAMES_OPTION, dsn);
        if (Util.isNullOrEmpty(inAppFramesOption)) {
            if (inAppFramesOption == null) {
                logger.warn("No 'stacktrace.app.packages' was configured, this option is highly recommended as it affects stacktrace grouping and display on Sentry. See documentation: https://docs.sentry.io/clients/java/config/#in-application-stack-frames");
            }
            return Collections.emptyList();
        }
        ArrayList<String> inAppPackages = new ArrayList<String>();
        for (String inAppPackage : inAppFramesOption.split(",")) {
            if (inAppPackage.trim().equals("")) continue;
            inAppPackages.add(inAppPackage);
        }
        return inAppPackages;
    }

    protected boolean getAsyncEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(ASYNC_OPTION, dsn));
    }

    protected RejectedExecutionHandler getRejectedExecutionHandler(Dsn dsn) {
        RejectedExecutionHandler handler;
        String overflowName = "discardold";
        String asyncQueueOverflowOption = this.lookup.get(ASYNC_QUEUE_OVERFLOW_OPTION, dsn);
        if (!Util.isNullOrEmpty(asyncQueueOverflowOption)) {
            overflowName = asyncQueueOverflowOption.toLowerCase();
        }
        if ((handler = REJECT_EXECUTION_HANDLERS.get(overflowName)) == null) {
            String options = Arrays.toString(REJECT_EXECUTION_HANDLERS.keySet().toArray());
            throw new RuntimeException("RejectedExecutionHandler not found: '" + overflowName + "', valid choices are: " + options);
        }
        return handler;
    }

    protected long getBufferedConnectionShutdownTimeout(Dsn dsn) {
        return Util.parseLong(this.lookup.get(BUFFER_SHUTDOWN_TIMEOUT_OPTION, dsn), BUFFER_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getBufferedConnectionGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(BUFFER_GRACEFUL_SHUTDOWN_OPTION, dsn));
    }

    protected long getBufferFlushtime(Dsn dsn) {
        return Util.parseLong(this.lookup.get(BUFFER_FLUSHTIME_OPTION, dsn), 60000L);
    }

    protected long getAsyncShutdownTimeout(Dsn dsn) {
        return Util.parseLong(this.lookup.get(ASYNC_SHUTDOWN_TIMEOUT_OPTION, dsn), ASYNC_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getAsyncGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(ASYNC_GRACEFUL_SHUTDOWN_OPTION, dsn));
    }

    protected int getAsyncQueueSize(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(ASYNC_QUEUE_SIZE_OPTION, dsn), 50);
    }

    protected int getAsyncPriority(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(ASYNC_PRIORITY_OPTION, dsn), 1);
    }

    protected int getAsyncThreads(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(ASYNC_THREADS_OPTION, dsn), Runtime.getRuntime().availableProcessors());
    }

    protected boolean getBypassSecurityEnabled(Dsn dsn) {
        return dsn.getProtocolSettings().contains(NAIVE_PROTOCOL);
    }

    protected Double getSampleRate(Dsn dsn) {
        return Util.parseDouble(this.lookup.get(SAMPLE_RATE_OPTION, dsn), null);
    }

    protected int getProxyPort(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(HTTP_PROXY_PORT_OPTION, dsn), 80);
    }

    protected String getProxyHost(Dsn dsn) {
        return this.lookup.get(HTTP_PROXY_HOST_OPTION, dsn);
    }

    protected String getProxyUser(Dsn dsn) {
        return this.lookup.get(HTTP_PROXY_USER_OPTION, dsn);
    }

    protected String getProxyPass(Dsn dsn) {
        return this.lookup.get(HTTP_PROXY_PASS_OPTION, dsn);
    }

    protected String getRelease(Dsn dsn) {
        return this.lookup.get(RELEASE_OPTION, dsn);
    }

    protected String getDist(Dsn dsn) {
        return this.lookup.get(DIST_OPTION, dsn);
    }

    protected String getEnvironment(Dsn dsn) {
        return this.lookup.get(ENVIRONMENT_OPTION, dsn);
    }

    protected String getServerName(Dsn dsn) {
        return this.lookup.get(SERVERNAME_OPTION, dsn);
    }

    protected Map<String, String> getTags(Dsn dsn) {
        return Util.parseTags(this.lookup.get(TAGS_OPTION, dsn));
    }

    @Deprecated
    protected Set<String> getExtraTags(Dsn dsn) {
        return this.getMdcTags(dsn);
    }

    protected Set<String> getMdcTags(Dsn dsn) {
        String val = this.lookup.get(MDCTAGS_OPTION, dsn);
        if (Util.isNullOrEmpty(val) && !Util.isNullOrEmpty(val = this.lookup.get(EXTRATAGS_OPTION, dsn))) {
            logger.warn("The 'extratags' option is deprecated, please use the 'mdctags' option instead.");
        }
        return Util.parseMdcTags(val);
    }

    protected Map<String, String> getExtra(Dsn dsn) {
        return Util.parseExtra(this.lookup.get(EXTRA_OPTION, dsn));
    }

    protected boolean getCompressionEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(COMPRESSION_OPTION, dsn));
    }

    protected boolean getHideCommonFramesEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(HIDE_COMMON_FRAMES_OPTION, dsn));
    }

    protected int getMaxMessageLength(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(MAX_MESSAGE_LENGTH_OPTION, dsn), 1000);
    }

    protected int getTimeout(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(CONNECTION_TIMEOUT_OPTION, dsn), CONNECTION_TIMEOUT_DEFAULT);
    }

    protected int getReadTimeout(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(READ_TIMEOUT_OPTION, dsn), READ_TIMEOUT_DEFAULT);
    }

    protected boolean getBufferEnabled(Dsn dsn) {
        String bufferEnabled = this.lookup.get(BUFFER_ENABLED_OPTION, dsn);
        if (bufferEnabled != null) {
            return Boolean.parseBoolean(bufferEnabled);
        }
        return true;
    }

    protected Buffer getBuffer(Dsn dsn) {
        String bufferDir = this.lookup.get(BUFFER_DIR_OPTION, dsn);
        if (bufferDir != null) {
            return new DiskBuffer(new File(bufferDir), this.getBufferSize(dsn));
        }
        return null;
    }

    protected int getBufferSize(Dsn dsn) {
        return Util.parseInteger(this.lookup.get(BUFFER_SIZE_OPTION, dsn), 10);
    }

    protected boolean getUncaughtHandlerEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(this.lookup.get(UNCAUGHT_HANDLER_ENABLED_OPTION, dsn));
    }

    static {
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_SYNC, new ThreadPoolExecutor.CallerRunsPolicy());
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_DISCARDNEW, new ThreadPoolExecutor.DiscardPolicy());
        REJECT_EXECUTION_HANDLERS.put("discardold", new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    protected static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        private DaemonThreadFactory(int priority) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "sentry-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }
    }
}

