/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DefaultSentryClientFactory;
import io.sentry.SentryClient;
import io.sentry.config.Lookup;
import io.sentry.dsn.Dsn;
import io.sentry.util.Nullable;
import io.sentry.util.Objects;
import io.sentry.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SentryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SentryClientFactory.class);
    protected final Lookup lookup;

    protected SentryClientFactory(Lookup lookup) {
        this.lookup = Objects.requireNonNull(lookup);
    }

    protected SentryClientFactory() {
        this(Lookup.getDefault());
    }

    @Nullable
    public static SentryClient sentryClient() {
        return SentryClientFactory.sentryClient(null, null);
    }

    @Nullable
    public static SentryClient sentryClient(@Nullable String dsn) {
        return SentryClientFactory.sentryClient(dsn, null);
    }

    @Nullable
    public static SentryClient sentryClient(@Nullable String dsn, @Nullable SentryClientFactory sentryClientFactory) {
        Lookup lookup = Lookup.getDefault();
        String realDsn = SentryClientFactory.dsnOrLookedUp(dsn, lookup);
        SentryClientFactory factory = sentryClientFactory == null ? SentryClientFactory.instantiateFrom(lookup, realDsn) : sentryClientFactory;
        return factory == null ? null : factory.createClient(realDsn);
    }

    @Nullable
    public static SentryClientFactory instantiateFrom(Lookup lookup, @Nullable String dsn) {
        SentryClientFactory sentryClientFactory;
        Dsn realDsn = new Dsn(SentryClientFactory.dsnOrLookedUp(dsn, lookup));
        String sentryClientFactoryName = lookup.get("factory", realDsn);
        if (Util.isNullOrEmpty(sentryClientFactoryName)) {
            sentryClientFactory = new DefaultSentryClientFactory(lookup);
        } else {
            try {
                Class<?> factoryClass = Class.forName(sentryClientFactoryName);
                Constructor<?> ctor = null;
                try {
                    ctor = factoryClass.getConstructor(Lookup.class);
                    sentryClientFactory = (SentryClientFactory)ctor.newInstance(lookup);
                }
                catch (NoSuchMethodException e) {
                    sentryClientFactory = (SentryClientFactory)factoryClass.newInstance();
                }
                catch (InvocationTargetException e) {
                    logger.warn("Failed to instantiate SentryClientFactory using " + ctor + ". Falling back to using the default constructor, if any.");
                    sentryClientFactory = (SentryClientFactory)factoryClass.newInstance();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error("Error creating SentryClient using factory class: '" + sentryClientFactoryName + "'.", (Throwable)e);
                return null;
            }
        }
        return sentryClientFactory;
    }

    private static String dsnOrLookedUp(@Nullable String dsn, Lookup lookup) {
        if (dsn == null) {
            dsn = Dsn.dsnFrom(lookup);
        }
        return dsn;
    }

    public abstract SentryClient createSentryClient(Dsn var1);

    public SentryClient createClient(@Nullable String dsn) {
        Dsn realDsn = new Dsn(dsn == null ? Dsn.dsnFrom(this.lookup) : dsn);
        return this.createSentryClient(realDsn);
    }

    public String toString() {
        return "SentryClientFactory{name='" + this.getClass().getName() + '\'' + '}';
    }
}

