/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.zinternaltools;

import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.optionalusertools.TimeVetoPolicy;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.DataInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class InternalUtilities {
    public static boolean areObjectsEqual(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean doesParsedDateMatchText(LocalDate parsedDate, String text, Locale formatLocale) {
        if (parsedDate == null || text == null) {
            return false;
        }
        text = text.toLowerCase();
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> unsignedNumbersFound = new ArrayList<String>();
        while (matcher.find()) {
            String foundString = matcher.group();
            foundString = InternalUtilities.forceNumberStringToTwoDigits(foundString);
            unsignedNumbersFound.add(foundString);
        }
        String parsedDayOfMonth = "" + parsedDate.getDayOfMonth();
        parsedDayOfMonth = InternalUtilities.forceNumberStringToTwoDigits(parsedDayOfMonth);
        boolean dayOfMonthFound = unsignedNumbersFound.remove(parsedDayOfMonth);
        DateTimeFormatter formatBC = DateTimeFormatter.ofPattern("G", formatLocale);
        String eraBCString = LocalDate.of(-100, 1, 1).format(formatBC).toLowerCase();
        if (parsedDate.getYear() < 1 && text.contains(eraBCString)) {
            String parsedYearForBC = "" + (parsedDate.getYear() - 1);
            parsedYearForBC = parsedYearForBC.replace("-", "");
            boolean yearFoundForBC = unsignedNumbersFound.remove(parsedYearForBC = InternalUtilities.forceNumberStringToTwoDigits(parsedYearForBC));
            return yearFoundForBC && dayOfMonthFound;
        }
        String parsedYear = "" + parsedDate.getYear();
        parsedYear = parsedYear.replace("-", "");
        boolean yearFound = unsignedNumbersFound.remove(parsedYear = InternalUtilities.forceNumberStringToTwoDigits(parsedYear));
        return yearFound && dayOfMonthFound;
    }

    public static double getJavaRunningVersionAsDouble() {
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        pos = version.indexOf(46, pos + 1);
        return Double.parseDouble(version.substring(0, pos));
    }

    public static String getJavaRunningVersionAsString() {
        String version = System.getProperty("java.version");
        return version;
    }

    public static String getJavaTargetVersionFromPom() {
        try {
            Properties properties = new Properties();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            properties.load(classLoader.getResourceAsStream("project.properties"));
            return "" + properties.getProperty("targetJavaVersion");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static <T> T getMostCommonElementInList(List<T> sourceList) {
        if (sourceList == null || sourceList.isEmpty()) {
            return null;
        }
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        for (Object element : sourceList) {
            Integer n = (Integer)hashMap.get(element);
            int newCount = n == null ? 1 : n + 1;
            hashMap.put(element, newCount);
        }
        Map.Entry largestEntry = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            if (largestEntry != null && (Integer)entry.getValue() <= (Integer)largestEntry.getValue()) continue;
            largestEntry = entry;
        }
        T result = largestEntry == null ? null : (T)largestEntry.getKey();
        return result;
    }

    public static String getProjectVersionString() {
        try {
            Properties properties = new Properties();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            properties.load(classLoader.getResourceAsStream("project.properties"));
            return "v" + properties.getProperty("projectVersion");
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static Insets getScreenInsets(Window windowOrNull) {
        Insets insets = windowOrNull == null ? Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration()) : windowOrNull.getToolkit().getScreenInsets(windowOrNull.getGraphicsConfiguration());
        return insets;
    }

    public static Rectangle getScreenTotalArea(Window windowOrNull) {
        Rectangle bounds;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            bounds = gc.getBounds();
        }
        return bounds;
    }

    public static Rectangle getScreenWorkingArea(Window windowOrNull) {
        Rectangle bounds;
        Insets insets;
        if (windowOrNull == null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            insets = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
            bounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        } else {
            GraphicsConfiguration gc = windowOrNull.getGraphicsConfiguration();
            insets = windowOrNull.getToolkit().getScreenInsets(gc);
            bounds = gc.getBounds();
        }
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    private static String forceNumberStringToTwoDigits(String text) {
        while (text.length() < 2) {
            text = "0" + text;
        }
        if (text.length() > 2) {
            text = text.substring(text.length() - 2, text.length());
        }
        return text;
    }

    public static DateTimeFormatter generateDefaultFormatterCE(Locale pickerLocale) {
        DateTimeFormatter formatCE = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendLocalized(FormatStyle.LONG, null).toFormatter(pickerLocale);
        String language = pickerLocale.getLanguage();
        if ("tr".equals(language)) {
            formatCE = PickerUtilities.createFormatterFromPatternString("dd MMMM yyyy", pickerLocale);
        }
        return formatCE;
    }

    public static DateTimeFormatter generateDefaultFormatterBCE(Locale pickerLocale) {
        String displayFormatterBCPattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.LONG, null, IsoChronology.INSTANCE, pickerLocale);
        displayFormatterBCPattern = displayFormatterBCPattern.replace("y", "u");
        DateTimeFormatter displayFormatterBC = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendPattern(displayFormatterBCPattern).toFormatter(pickerLocale);
        String language = pickerLocale.getLanguage();
        if ("tr".equals(language)) {
            displayFormatterBC = PickerUtilities.createFormatterFromPatternString("dd MMMM uuuu", pickerLocale);
        }
        return displayFormatterBC;
    }

    public static LocalDate getParsedDateOrNull(String text, DateTimeFormatter displayFormatterAD, DateTimeFormatter displayFormatterBC, ArrayList<DateTimeFormatter> parsingFormatters, Locale formatLocale) {
        if (text == null || text.trim().isEmpty()) {
            return null;
        }
        text = text.trim().toLowerCase();
        LocalDate parsedDate = null;
        if (parsedDate == null) {
            try {
                parsedDate = LocalDate.parse(text, displayFormatterAD);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parsedDate == null) {
            try {
                parsedDate = LocalDate.parse(text, displayFormatterBC);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; parsedDate == null && i < parsingFormatters.size(); ++i) {
            try {
                parsedDate = LocalDate.parse(text, parsingFormatters.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parsedDate != null && !InternalUtilities.doesParsedDateMatchText(parsedDate, text, formatLocale)) {
            return null;
        }
        return parsedDate;
    }

    public static LocalTime getParsedTimeOrNull(String timeText, DateTimeFormatter formatForDisplayTime, DateTimeFormatter formatForMenuTimes, ArrayList<DateTimeFormatter> formatsForParsing, Locale timePickerLocale) {
        if (timeText == null || timeText.trim().isEmpty()) {
            return null;
        }
        timeText = timeText.trim().toLowerCase();
        LocalTime parsedTime = null;
        if (parsedTime == null) {
            try {
                parsedTime = LocalTime.parse(timeText, formatForDisplayTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (parsedTime == null) {
            try {
                parsedTime = LocalTime.parse(timeText, formatForMenuTimes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; parsedTime == null && i < formatsForParsing.size(); ++i) {
            try {
                parsedTime = LocalTime.parse(timeText, formatsForParsing.get(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsedTime;
    }

    static String capitalizeFirstLetterOfString(String text, Locale locale) {
        if (text == null || text.length() < 1) {
            return text;
        }
        String textCapitalized = text.substring(0, 1).toUpperCase(locale) + text.substring(1);
        return textCapitalized;
    }

    public static GridBagConstraints getConstraints(int gridx, int gridy) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 1;
        gc.gridx = gridx;
        gc.gridy = gridy;
        return gc;
    }

    public static boolean isDateVetoed(DateVetoPolicy policy, LocalDate date) {
        if (policy == null || date == null) {
            return false;
        }
        return !policy.isDateAllowed(date);
    }

    public static boolean isMouseWithinComponent(Component component) {
        Point mousePos = MouseInfo.getPointerInfo().getLocation();
        Rectangle bounds = component.getBounds();
        bounds.setLocation(component.getLocationOnScreen());
        return bounds.contains(mousePos);
    }

    public static boolean isTimeVetoed(TimeVetoPolicy policy, LocalTime time) {
        if (policy == null) {
            return false;
        }
        return !policy.isTimeAllowed(time);
    }

    public static String safeSubstring(String text, int beginIndex, int endIndexExclusive) {
        if (text == null) {
            return null;
        }
        int textLength = text.length();
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndexExclusive < 0) {
            endIndexExclusive = 0;
        }
        if (endIndexExclusive > textLength) {
            endIndexExclusive = textLength;
        }
        if (beginIndex > endIndexExclusive) {
            beginIndex = endIndexExclusive;
        }
        if (beginIndex == endIndexExclusive) {
            return "";
        }
        return text.substring(beginIndex, endIndexExclusive);
    }

    public static int getCompiledJavaVersionFromJavaClassFile(InputStream classByteStream, boolean majorVersionRequested) throws Exception {
        DataInputStream dataInputStream = new DataInputStream(classByteStream);
        dataInputStream.readInt();
        int minorVersion = dataInputStream.readUnsignedShort();
        int majorVersion = dataInputStream.readUnsignedShort();
        return majorVersionRequested ? majorVersion : minorVersion;
    }

    public static String getCompiledJavaMajorVersionFromJavaClassFileAsString(InputStream classByteStream) throws Exception {
        int majorVersion = InternalUtilities.getCompiledJavaVersionFromJavaClassFile(classByteStream, true);
        switch (majorVersion) {
            case 50: {
                return "Java 6";
            }
            case 51: {
                return "Java 7";
            }
            case 52: {
                return "Java 8";
            }
        }
        return "Could not find version string for major version: " + majorVersion;
    }

    public static void setDefaultTableEditorsClicks(JTable table, int clickCountToStart) {
        TableCellEditor editor = table.getDefaultEditor(Object.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(clickCountToStart);
        }
        if ((editor = table.getDefaultEditor(Number.class)) instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(clickCountToStart);
        }
        if ((editor = table.getDefaultEditor(Boolean.class)) instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(clickCountToStart);
        }
    }
}

