(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.FormEditor = {}));
})(this, (function (exports) { 'use strict';

  function createCommonjsModule(fn, module) {
  	return module = { exports: {} }, fn(module, module.exports), module.exports;
  }

  var hat_1 = createCommonjsModule(function (module) {
  var hat = module.exports = function (bits, base) {
      if (!base) base = 16;
      if (bits === undefined) bits = 128;
      if (bits <= 0) return '0';
      
      var digits = Math.log(Math.pow(2, bits)) / Math.log(base);
      for (var i = 2; digits === Infinity; i *= 2) {
          digits = Math.log(Math.pow(2, bits / i)) / Math.log(base) * i;
      }
      
      var rem = digits - Math.floor(digits);
      
      var res = '';
      
      for (var i = 0; i < Math.floor(digits); i++) {
          var x = Math.floor(Math.random() * base).toString(base);
          res = x + res;
      }
      
      if (rem) {
          var b = Math.pow(base, rem);
          var x = Math.floor(Math.random() * b).toString(base);
          res = x + res;
      }
      
      var parsed = parseInt(res, base);
      if (parsed !== Infinity && parsed >= Math.pow(2, bits)) {
          return hat(bits, base)
      }
      else return res;
  };

  hat.rack = function (bits, base, expandBy) {
      var fn = function (data) {
          var iters = 0;
          do {
              if (iters ++ > 10) {
                  if (expandBy) bits += expandBy;
                  else throw new Error('too many ID collisions, use more bits')
              }
              
              var id = hat(bits, base);
          } while (Object.hasOwnProperty.call(hats, id));
          
          hats[id] = data;
          return id;
      };
      var hats = fn.hats = {};
      
      fn.get = function (id) {
          return fn.hats[id];
      };
      
      fn.set = function (id, value) {
          fn.hats[id] = value;
          return fn;
      };
      
      fn.bits = bits || 128;
      fn.base = base || 16;
      return fn;
  };
  });

  /**
   * Create a new id generator / cache instance.
   *
   * You may optionally provide a seed that is used internally.
   *
   * @param {Seed} seed
   */
  function Ids(seed) {
    if (!(this instanceof Ids)) {
      return new Ids(seed);
    }
    seed = seed || [128, 36, 1];
    this._seed = seed.length ? hat_1.rack(seed[0], seed[1], seed[2]) : seed;
  }

  /**
   * Generate a next id.
   *
   * @param {Object} [element] element to bind the id to
   *
   * @return {String} id
   */
  Ids.prototype.next = function (element) {
    return this._seed(element || true);
  };

  /**
   * Generate a next id with a given prefix.
   *
   * @param {Object} [element] element to bind the id to
   *
   * @return {String} id
   */
  Ids.prototype.nextPrefixed = function (prefix, element) {
    var id;
    do {
      id = prefix + this.next(true);
    } while (this.assigned(id));

    // claim {prefix}{random}
    this.claim(id, element);

    // return
    return id;
  };

  /**
   * Manually claim an existing id.
   *
   * @param {String} id
   * @param {String} [element] element the id is claimed by
   */
  Ids.prototype.claim = function (id, element) {
    this._seed.set(id, element || true);
  };

  /**
   * Returns true if the given id has already been assigned.
   *
   * @param  {String} id
   * @return {Boolean}
   */
  Ids.prototype.assigned = function (id) {
    return this._seed.get(id) || false;
  };

  /**
   * Unclaim an id.
   *
   * @param  {String} id the id to unclaim
   */
  Ids.prototype.unclaim = function (id) {
    delete this._seed.hats[id];
  };

  /**
   * Clear all claimed ids.
   */
  Ids.prototype.clear = function () {
    var hats = this._seed.hats,
      id;
    for (id in hats) {
      this.unclaim(id);
    }
  };

  /**
   * Flatten array, one level deep.
   *
   * @template T
   *
   * @param {T[][] | T[] | null} [arr]
   *
   * @return {T[]}
   */

  const nativeToString = Object.prototype.toString;
  const nativeHasOwnProperty = Object.prototype.hasOwnProperty;

  function isUndefined$1(obj) {
    return obj === undefined;
  }

  function isDefined(obj) {
    return obj !== undefined;
  }

  function isNil(obj) {
    return obj == null;
  }

  function isArray$2(obj) {
    return nativeToString.call(obj) === '[object Array]';
  }

  function isObject(obj) {
    return nativeToString.call(obj) === '[object Object]';
  }

  function isNumber$2(obj) {
    return nativeToString.call(obj) === '[object Number]';
  }

  /**
   * @param {any} obj
   *
   * @return {boolean}
   */
  function isFunction(obj) {
    const tag = nativeToString.call(obj);

    return (
      tag === '[object Function]' ||
      tag === '[object AsyncFunction]' ||
      tag === '[object GeneratorFunction]' ||
      tag === '[object AsyncGeneratorFunction]' ||
      tag === '[object Proxy]'
    );
  }

  function isString$2(obj) {
    return nativeToString.call(obj) === '[object String]';
  }


  /**
   * Ensure collection is an array.
   *
   * @param {Object} obj
   */
  function ensureArray(obj) {

    if (isArray$2(obj)) {
      return;
    }

    throw new Error('must supply array');
  }

  /**
   * Return true, if target owns a property with the given key.
   *
   * @param {Object} target
   * @param {String} key
   *
   * @return {Boolean}
   */
  function has(target, key) {
    return !isNil(target) && nativeHasOwnProperty.call(target, key);
  }

  /**
   * @template T
   * @typedef { (
   *   ((e: T) => boolean) |
   *   ((e: T, idx: number) => boolean) |
   *   ((e: T, key: string) => boolean) |
   *   string |
   *   number
   * ) } Matcher
   */

  /**
   * @template T
   * @template U
   *
   * @typedef { (
   *   ((e: T) => U) | string | number
   * ) } Extractor
   */


  /**
   * @template T
   * @typedef { (val: T, key: any) => boolean } MatchFn
   */

  /**
   * @template T
   * @typedef { T[] } ArrayCollection
   */

  /**
   * @template T
   * @typedef { { [key: string]: T } } StringKeyValueCollection
   */

  /**
   * @template T
   * @typedef { { [key: number]: T } } NumberKeyValueCollection
   */

  /**
   * @template T
   * @typedef { StringKeyValueCollection<T> | NumberKeyValueCollection<T> } KeyValueCollection
   */

  /**
   * @template T
   * @typedef { KeyValueCollection<T> | ArrayCollection<T> } Collection
   */

  /**
   * Find element in collection.
   *
   * @template T
   * @param {Collection<T>} collection
   * @param {Matcher<T>} matcher
   *
   * @return {Object}
   */
  function find$1(collection, matcher) {

    const matchFn = toMatcher(matcher);

    let match;

    forEach(collection, function(val, key) {
      if (matchFn(val, key)) {
        match = val;

        return false;
      }
    });

    return match;

  }


  /**
   * Find element index in collection.
   *
   * @template T
   * @param {Collection<T>} collection
   * @param {Matcher<T>} matcher
   *
   * @return {number | string | undefined}
   */
  function findIndex$1(collection, matcher) {

    const matchFn = toMatcher(matcher);

    let idx = isArray$2(collection) ? -1 : undefined;

    forEach(collection, function(val, key) {
      if (matchFn(val, key)) {
        idx = key;

        return false;
      }
    });

    return idx;
  }


  /**
   * Iterate over collection; returning something
   * (non-undefined) will stop iteration.
   *
   * @template T
   * @param {Collection<T>} collection
   * @param { ((item: T, idx: number) => (boolean|void)) | ((item: T, key: string) => (boolean|void)) } iterator
   *
   * @return {T} return result that stopped the iteration
   */
  function forEach(collection, iterator) {

    let val,
        result;

    if (isUndefined$1(collection)) {
      return;
    }

    const convertKey = isArray$2(collection) ? toNum : identity;

    for (let key in collection) {

      if (has(collection, key)) {
        val = collection[key];

        result = iterator(val, convertKey(key));

        if (result === false) {
          return val;
        }
      }
    }
  }

  /**
   * Return collection without element.
   *
   * @template T
   * @param {ArrayCollection<T>} arr
   * @param {Matcher<T>} matcher
   *
   * @return {T[]}
   */
  function without(arr, matcher) {

    if (isUndefined$1(arr)) {
      return [];
    }

    ensureArray(arr);

    const matchFn = toMatcher(matcher);

    return arr.filter(function(el, idx) {
      return !matchFn(el, idx);
    });

  }


  /**
   * Reduce collection, returning a single result.
   *
   * @template T
   * @template V
   *
   * @param {Collection<T>} collection
   * @param {(result: V, entry: T, index: any) => V} iterator
   * @param {V} result
   *
   * @return {V} result returned from last iterator
   */
  function reduce(collection, iterator, result) {

    forEach(collection, function(value, idx) {
      result = iterator(result, value, idx);
    });

    return result;
  }


  /**
   * Return true if some elements in the collection
   * match the criteria.
   *
   * @param  {Object|Array} collection
   * @param  {Function} matcher
   *
   * @return {Boolean}
   */
  function some(collection, matcher) {

    return !!find$1(collection, matcher);
  }


  /**
   * Transform a collection into another collection
   * by piping each member through the given fn.
   *
   * @param  {Object|Array}   collection
   * @param  {Function} fn
   *
   * @return {Array} transformed collection
   */
  function map$1(collection, fn) {

    let result = [];

    forEach(collection, function(val, key) {
      result.push(fn(val, key));
    });

    return result;
  }


  /**
   * Get the values in the collection.
   *
   * @param  {Object|Array} collection
   *
   * @return {Array}
   */
  function values(collection) {
    return map$1(collection, (val) => val);
  }


  /**
   * Group collection members by attribute.
   *
   * @param {Object|Array} collection
   * @param {Extractor} extractor
   *
   * @return {Object} map with { attrValue => [ a, b, c ] }
   */
  function groupBy(collection, extractor, grouped = {}) {

    extractor = toExtractor(extractor);

    forEach(collection, function(val) {
      let discriminator = extractor(val) || '_';

      let group = grouped[discriminator];

      if (!group) {
        group = grouped[discriminator] = [];
      }

      group.push(val);
    });

    return grouped;
  }


  function uniqueBy(extractor, ...collections) {

    extractor = toExtractor(extractor);

    let grouped = {};

    forEach(collections, (c) => groupBy(c, extractor, grouped));

    let result = map$1(grouped, function(val, key) {
      return val[0];
    });

    return result;
  }


  /**
   * @param {string | ((e: any) => any) } extractor
   *
   * @return { (e: any) => any }
   */
  function toExtractor(extractor) {

    /**
     * @satisfies { (e: any) => any }
     */
    return isFunction(extractor) ? extractor : (e) => {

      // @ts-ignore: just works
      return e[extractor];
    };
  }


  /**
   * @template T
   * @param {Matcher<T>} matcher
   *
   * @return {MatchFn<T>}
   */
  function toMatcher(matcher) {
    return isFunction(matcher) ? matcher : (e) => {
      return e === matcher;
    };
  }


  function identity(arg) {
    return arg;
  }

  function toNum(arg) {
    return Number(arg);
  }

  /* global setTimeout clearTimeout */

  /**
   * @typedef { {
   *   (...args: any[]): any;
   *   flush: () => void;
   *   cancel: () => void;
   * } } DebouncedFunction
   */

  /**
   * Debounce fn, calling it only once if the given time
   * elapsed between calls.
   *
   * Lodash-style the function exposes methods to `#clear`
   * and `#flush` to control internal behavior.
   *
   * @param  {Function} fn
   * @param  {Number} timeout
   *
   * @return {DebouncedFunction} debounced function
   */
  function debounce$1(fn, timeout) {

    let timer;

    let lastArgs;
    let lastThis;

    let lastNow;

    function fire(force) {

      let now = Date.now();

      let scheduledDiff = force ? 0 : (lastNow + timeout) - now;

      if (scheduledDiff > 0) {
        return schedule(scheduledDiff);
      }

      fn.apply(lastThis, lastArgs);

      clear();
    }

    function schedule(timeout) {
      timer = setTimeout(fire, timeout);
    }

    function clear() {
      if (timer) {
        clearTimeout(timer);
      }

      timer = lastNow = lastArgs = lastThis = undefined;
    }

    function flush() {
      if (timer) {
        fire(true);
      }

      clear();
    }

    /**
     * @type { DebouncedFunction }
     */
    function callback(...args) {
      lastNow = Date.now();

      lastArgs = args;
      lastThis = this;

      // ensure an execution is scheduled
      if (!timer) {
        schedule(timeout);
      }
    }

    callback.flush = flush;
    callback.cancel = clear;

    return callback;
  }

  /**
   * Bind function against target <this>.
   *
   * @param  {Function} fn
   * @param  {Object}   target
   *
   * @return {Function} bound function
   */
  function bind(fn, target) {
    return fn.bind(target);
  }

  /**
   * Convenience wrapper for `Object.assign`.
   *
   * @param {Object} target
   * @param {...Object} others
   *
   * @return {Object} the target
   */
  function assign(target, ...others) {
    return Object.assign(target, ...others);
  }

  /**
   * Sets a nested property of a given object to the specified value.
   *
   * This mutates the object and returns it.
   *
   * @template T
   *
   * @param {T} target The target of the set operation.
   * @param {(string|number)[]} path The path to the nested value.
   * @param {any} value The value to set.
   *
   * @return {T}
   */
  function set$1(target, path, value) {

    let currentTarget = target;

    forEach(path, function(key, idx) {

      if (typeof key !== 'number' && typeof key !== 'string') {
        throw new Error('illegal key type: ' + typeof key + '. Key should be of type number or string.');
      }

      if (key === 'constructor') {
        throw new Error('illegal key: constructor');
      }

      if (key === '__proto__') {
        throw new Error('illegal key: __proto__');
      }

      let nextKey = path[idx + 1];
      let nextTarget = currentTarget[key];

      if (isDefined(nextKey) && isNil(nextTarget)) {
        nextTarget = currentTarget[key] = isNaN(+nextKey) ? {} : [];
      }

      if (isUndefined$1(nextKey)) {
        if (isUndefined$1(value)) {
          delete currentTarget[key];
        } else {
          currentTarget[key] = value;
        }
      } else {
        currentTarget = nextTarget;
      }
    });

    return target;
  }


  /**
   * Gets a nested property of a given object.
   *
   * @param {Object} target The target of the get operation.
   * @param {(string|number)[]} path The path to the nested value.
   * @param {any} [defaultValue] The value to return if no value exists.
   *
   * @return {any}
   */
  function get$1(target, path, defaultValue) {

    let currentTarget = target;

    forEach(path, function(key) {

      // accessing nil property yields <undefined>
      if (isNil(currentTarget)) {
        currentTarget = undefined;

        return false;
      }

      currentTarget = currentTarget[key];
    });

    return isUndefined$1(currentTarget) ? defaultValue : currentTarget;
  }

  /*
   *  big.js v6.2.2
   *  A small, fast, easy-to-use library for arbitrary-precision decimal arithmetic.
   *  Copyright (c) 2024 Michael Mclaughlin
   *  https://github.com/MikeMcl/big.js/LICENCE.md
   */


  /************************************** EDITABLE DEFAULTS *****************************************/


    // The default values below must be integers within the stated ranges.

    /*
     * The maximum number of decimal places (DP) of the results of operations involving division:
     * div and sqrt, and pow with negative exponents.
     */
  var DP$1 = 20,          // 0 to MAX_DP

    /*
     * The rounding mode (RM) used when rounding to the above decimal places.
     *
     *  0  Towards zero (i.e. truncate, no rounding).       (ROUND_DOWN)
     *  1  To nearest neighbour. If equidistant, round up.  (ROUND_HALF_UP)
     *  2  To nearest neighbour. If equidistant, to even.   (ROUND_HALF_EVEN)
     *  3  Away from zero.                                  (ROUND_UP)
     */
    RM$1 = 1,             // 0, 1, 2 or 3

    // The maximum value of DP and Big.DP.
    MAX_DP$1 = 1E6,       // 0 to 1000000

    // The maximum magnitude of the exponent argument to the pow method.
    MAX_POWER$1 = 1E6,    // 1 to 1000000

    /*
     * The negative exponent (NE) at and beneath which toString returns exponential notation.
     * (JavaScript numbers: -7)
     * -1000000 is the minimum recommended exponent value of a Big.
     */
    NE$1 = -7,            // 0 to -1000000

    /*
     * The positive exponent (PE) at and above which toString returns exponential notation.
     * (JavaScript numbers: 21)
     * 1000000 is the maximum recommended exponent value of a Big, but this limit is not enforced.
     */
    PE$1 = 21,            // 0 to 1000000

    /*
     * When true, an error will be thrown if a primitive number is passed to the Big constructor,
     * or if valueOf is called, or if toNumber is called on a Big which cannot be converted to a
     * primitive number without a loss of precision.
     */
    STRICT$1 = false,     // true or false


  /**************************************************************************************************/


    // Error messages.
    NAME$1 = '[big.js] ',
    INVALID$4 = NAME$1 + 'Invalid ',
    INVALID_DP$1 = INVALID$4 + 'decimal places',
    INVALID_RM$1 = INVALID$4 + 'rounding mode',
    DIV_BY_ZERO$1 = NAME$1 + 'Division by zero',

    // The shared prototype object.
    P$3 = {},
    UNDEFINED$1 = void 0,
    NUMERIC$1 = /^-?(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i;


  /*
   * Create and return a Big constructor.
   */
  function _Big_$1() {

    /*
     * The Big constructor and exported function.
     * Create and return a new instance of a Big number object.
     *
     * n {number|string|Big} A numeric value.
     */
    function Big(n) {
      var x = this;

      // Enable constructor usage without new.
      if (!(x instanceof Big)) return n === UNDEFINED$1 ? _Big_$1() : new Big(n);

      // Duplicate.
      if (n instanceof Big) {
        x.s = n.s;
        x.e = n.e;
        x.c = n.c.slice();
      } else {
        if (typeof n !== 'string') {
          if (Big.strict === true && typeof n !== 'bigint') {
            throw TypeError(INVALID$4 + 'value');
          }

          // Minus zero?
          n = n === 0 && 1 / n < 0 ? '-0' : String(n);
        }

        parse$3(x, n);
      }

      // Retain a reference to this Big constructor.
      // Shadow Big.prototype.constructor which points to Object.
      x.constructor = Big;
    }

    Big.prototype = P$3;
    Big.DP = DP$1;
    Big.RM = RM$1;
    Big.NE = NE$1;
    Big.PE = PE$1;
    Big.strict = STRICT$1;
    Big.roundDown = 0;
    Big.roundHalfUp = 1;
    Big.roundHalfEven = 2;
    Big.roundUp = 3;

    return Big;
  }


  /*
   * Parse the number or string value passed to a Big constructor.
   *
   * x {Big} A Big number instance.
   * n {number|string} A numeric value.
   */
  function parse$3(x, n) {
    var e, i, nl;

    if (!NUMERIC$1.test(n)) {
      throw Error(INVALID$4 + 'number');
    }

    // Determine sign.
    x.s = n.charAt(0) == '-' ? (n = n.slice(1), -1) : 1;

    // Decimal point?
    if ((e = n.indexOf('.')) > -1) n = n.replace('.', '');

    // Exponential form?
    if ((i = n.search(/e/i)) > 0) {

      // Determine exponent.
      if (e < 0) e = i;
      e += +n.slice(i + 1);
      n = n.substring(0, i);
    } else if (e < 0) {

      // Integer.
      e = n.length;
    }

    nl = n.length;

    // Determine leading zeros.
    for (i = 0; i < nl && n.charAt(i) == '0';) ++i;

    if (i == nl) {

      // Zero.
      x.c = [x.e = 0];
    } else {

      // Determine trailing zeros.
      for (; nl > 0 && n.charAt(--nl) == '0';);
      x.e = e - i - 1;
      x.c = [];

      // Convert string to array of digits without leading/trailing zeros.
      for (e = 0; i <= nl;) x.c[e++] = +n.charAt(i++);
    }

    return x;
  }


  /*
   * Round Big x to a maximum of sd significant digits using rounding mode rm.
   *
   * x {Big} The Big to round.
   * sd {number} Significant digits: integer, 0 to MAX_DP inclusive.
   * rm {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   * [more] {boolean} Whether the result of division was truncated.
   */
  function round$1(x, sd, rm, more) {
    var xc = x.c;

    if (rm === UNDEFINED$1) rm = x.constructor.RM;
    if (rm !== 0 && rm !== 1 && rm !== 2 && rm !== 3) {
      throw Error(INVALID_RM$1);
    }

    if (sd < 1) {
      more =
        rm === 3 && (more || !!xc[0]) || sd === 0 && (
        rm === 1 && xc[0] >= 5 ||
        rm === 2 && (xc[0] > 5 || xc[0] === 5 && (more || xc[1] !== UNDEFINED$1))
      );

      xc.length = 1;

      if (more) {

        // 1, 0.1, 0.01, 0.001, 0.0001 etc.
        x.e = x.e - sd + 1;
        xc[0] = 1;
      } else {

        // Zero.
        xc[0] = x.e = 0;
      }
    } else if (sd < xc.length) {

      // xc[sd] is the digit after the digit that may be rounded up.
      more =
        rm === 1 && xc[sd] >= 5 ||
        rm === 2 && (xc[sd] > 5 || xc[sd] === 5 &&
          (more || xc[sd + 1] !== UNDEFINED$1 || xc[sd - 1] & 1)) ||
        rm === 3 && (more || !!xc[0]);

      // Remove any digits after the required precision.
      xc.length = sd;

      // Round up?
      if (more) {

        // Rounding up may mean the previous digit has to be rounded up.
        for (; ++xc[--sd] > 9;) {
          xc[sd] = 0;
          if (sd === 0) {
            ++x.e;
            xc.unshift(1);
            break;
          }
        }
      }

      // Remove trailing zeros.
      for (sd = xc.length; !xc[--sd];) xc.pop();
    }

    return x;
  }


  /*
   * Return a string representing the value of Big x in normal or exponential notation.
   * Handles P.toExponential, P.toFixed, P.toJSON, P.toPrecision, P.toString and P.valueOf.
   */
  function stringify$1(x, doExponential, isNonzero) {
    var e = x.e,
      s = x.c.join(''),
      n = s.length;

    // Exponential notation?
    if (doExponential) {
      s = s.charAt(0) + (n > 1 ? '.' + s.slice(1) : '') + (e < 0 ? 'e' : 'e+') + e;

    // Normal notation.
    } else if (e < 0) {
      for (; ++e;) s = '0' + s;
      s = '0.' + s;
    } else if (e > 0) {
      if (++e > n) {
        for (e -= n; e--;) s += '0';
      } else if (e < n) {
        s = s.slice(0, e) + '.' + s.slice(e);
      }
    } else if (n > 1) {
      s = s.charAt(0) + '.' + s.slice(1);
    }

    return x.s < 0 && isNonzero ? '-' + s : s;
  }


  // Prototype/instance methods


  /*
   * Return a new Big whose value is the absolute value of this Big.
   */
  P$3.abs = function () {
    var x = new this.constructor(this);
    x.s = 1;
    return x;
  };


  /*
   * Return 1 if the value of this Big is greater than the value of Big y,
   *       -1 if the value of this Big is less than the value of Big y, or
   *        0 if they have the same value.
   */
  P$3.cmp = function (y) {
    var isneg,
      x = this,
      xc = x.c,
      yc = (y = new x.constructor(y)).c,
      i = x.s,
      j = y.s,
      k = x.e,
      l = y.e;

    // Either zero?
    if (!xc[0] || !yc[0]) return !xc[0] ? !yc[0] ? 0 : -j : i;

    // Signs differ?
    if (i != j) return i;

    isneg = i < 0;

    // Compare exponents.
    if (k != l) return k > l ^ isneg ? 1 : -1;

    j = (k = xc.length) < (l = yc.length) ? k : l;

    // Compare digit by digit.
    for (i = -1; ++i < j;) {
      if (xc[i] != yc[i]) return xc[i] > yc[i] ^ isneg ? 1 : -1;
    }

    // Compare lengths.
    return k == l ? 0 : k > l ^ isneg ? 1 : -1;
  };


  /*
   * Return a new Big whose value is the value of this Big divided by the value of Big y, rounded,
   * if necessary, to a maximum of Big.DP decimal places using rounding mode Big.RM.
   */
  P$3.div = function (y) {
    var x = this,
      Big = x.constructor,
      a = x.c,                  // dividend
      b = (y = new Big(y)).c,   // divisor
      k = x.s == y.s ? 1 : -1,
      dp = Big.DP;

    if (dp !== ~~dp || dp < 0 || dp > MAX_DP$1) {
      throw Error(INVALID_DP$1);
    }

    // Divisor is zero?
    if (!b[0]) {
      throw Error(DIV_BY_ZERO$1);
    }

    // Dividend is 0? Return +-0.
    if (!a[0]) {
      y.s = k;
      y.c = [y.e = 0];
      return y;
    }

    var bl, bt, n, cmp, ri,
      bz = b.slice(),
      ai = bl = b.length,
      al = a.length,
      r = a.slice(0, bl),   // remainder
      rl = r.length,
      q = y,                // quotient
      qc = q.c = [],
      qi = 0,
      p = dp + (q.e = x.e - y.e) + 1;    // precision of the result

    q.s = k;
    k = p < 0 ? 0 : p;

    // Create version of divisor with leading zero.
    bz.unshift(0);

    // Add zeros to make remainder as long as divisor.
    for (; rl++ < bl;) r.push(0);

    do {

      // n is how many times the divisor goes into current remainder.
      for (n = 0; n < 10; n++) {

        // Compare divisor and remainder.
        if (bl != (rl = r.length)) {
          cmp = bl > rl ? 1 : -1;
        } else {
          for (ri = -1, cmp = 0; ++ri < bl;) {
            if (b[ri] != r[ri]) {
              cmp = b[ri] > r[ri] ? 1 : -1;
              break;
            }
          }
        }

        // If divisor < remainder, subtract divisor from remainder.
        if (cmp < 0) {

          // Remainder can't be more than 1 digit longer than divisor.
          // Equalise lengths using divisor with extra leading zero?
          for (bt = rl == bl ? b : bz; rl;) {
            if (r[--rl] < bt[rl]) {
              ri = rl;
              for (; ri && !r[--ri];) r[ri] = 9;
              --r[ri];
              r[rl] += 10;
            }
            r[rl] -= bt[rl];
          }

          for (; !r[0];) r.shift();
        } else {
          break;
        }
      }

      // Add the digit n to the result array.
      qc[qi++] = cmp ? n : ++n;

      // Update the remainder.
      if (r[0] && cmp) r[rl] = a[ai] || 0;
      else r = [a[ai]];

    } while ((ai++ < al || r[0] !== UNDEFINED$1) && k--);

    // Leading zero? Do not remove if result is simply zero (qi == 1).
    if (!qc[0] && qi != 1) {

      // There can't be more than one zero.
      qc.shift();
      q.e--;
      p--;
    }

    // Round?
    if (qi > p) round$1(q, p, Big.RM, r[0] !== UNDEFINED$1);

    return q;
  };


  /*
   * Return true if the value of this Big is equal to the value of Big y, otherwise return false.
   */
  P$3.eq = function (y) {
    return this.cmp(y) === 0;
  };


  /*
   * Return true if the value of this Big is greater than the value of Big y, otherwise return
   * false.
   */
  P$3.gt = function (y) {
    return this.cmp(y) > 0;
  };


  /*
   * Return true if the value of this Big is greater than or equal to the value of Big y, otherwise
   * return false.
   */
  P$3.gte = function (y) {
    return this.cmp(y) > -1;
  };


  /*
   * Return true if the value of this Big is less than the value of Big y, otherwise return false.
   */
  P$3.lt = function (y) {
    return this.cmp(y) < 0;
  };


  /*
   * Return true if the value of this Big is less than or equal to the value of Big y, otherwise
   * return false.
   */
  P$3.lte = function (y) {
    return this.cmp(y) < 1;
  };


  /*
   * Return a new Big whose value is the value of this Big minus the value of Big y.
   */
  P$3.minus = P$3.sub = function (y) {
    var i, j, t, xlty,
      x = this,
      Big = x.constructor,
      a = x.s,
      b = (y = new Big(y)).s;

    // Signs differ?
    if (a != b) {
      y.s = -b;
      return x.plus(y);
    }

    var xc = x.c.slice(),
      xe = x.e,
      yc = y.c,
      ye = y.e;

    // Either zero?
    if (!xc[0] || !yc[0]) {
      if (yc[0]) {
        y.s = -b;
      } else if (xc[0]) {
        y = new Big(x);
      } else {
        y.s = 1;
      }
      return y;
    }

    // Determine which is the bigger number. Prepend zeros to equalise exponents.
    if (a = xe - ye) {

      if (xlty = a < 0) {
        a = -a;
        t = xc;
      } else {
        ye = xe;
        t = yc;
      }

      t.reverse();
      for (b = a; b--;) t.push(0);
      t.reverse();
    } else {

      // Exponents equal. Check digit by digit.
      j = ((xlty = xc.length < yc.length) ? xc : yc).length;

      for (a = b = 0; b < j; b++) {
        if (xc[b] != yc[b]) {
          xlty = xc[b] < yc[b];
          break;
        }
      }
    }

    // x < y? Point xc to the array of the bigger number.
    if (xlty) {
      t = xc;
      xc = yc;
      yc = t;
      y.s = -y.s;
    }

    /*
     * Append zeros to xc if shorter. No need to add zeros to yc if shorter as subtraction only
     * needs to start at yc.length.
     */
    if ((b = (j = yc.length) - (i = xc.length)) > 0) for (; b--;) xc[i++] = 0;

    // Subtract yc from xc.
    for (b = i; j > a;) {
      if (xc[--j] < yc[j]) {
        for (i = j; i && !xc[--i];) xc[i] = 9;
        --xc[i];
        xc[j] += 10;
      }

      xc[j] -= yc[j];
    }

    // Remove trailing zeros.
    for (; xc[--b] === 0;) xc.pop();

    // Remove leading zeros and adjust exponent accordingly.
    for (; xc[0] === 0;) {
      xc.shift();
      --ye;
    }

    if (!xc[0]) {

      // n - n = +0
      y.s = 1;

      // Result must be zero.
      xc = [ye = 0];
    }

    y.c = xc;
    y.e = ye;

    return y;
  };


  /*
   * Return a new Big whose value is the value of this Big modulo the value of Big y.
   */
  P$3.mod = function (y) {
    var ygtx,
      x = this,
      Big = x.constructor,
      a = x.s,
      b = (y = new Big(y)).s;

    if (!y.c[0]) {
      throw Error(DIV_BY_ZERO$1);
    }

    x.s = y.s = 1;
    ygtx = y.cmp(x) == 1;
    x.s = a;
    y.s = b;

    if (ygtx) return new Big(x);

    a = Big.DP;
    b = Big.RM;
    Big.DP = Big.RM = 0;
    x = x.div(y);
    Big.DP = a;
    Big.RM = b;

    return this.minus(x.times(y));
  };


  /*
   * Return a new Big whose value is the value of this Big negated.
   */
  P$3.neg = function () {
    var x = new this.constructor(this);
    x.s = -x.s;
    return x;
  };


  /*
   * Return a new Big whose value is the value of this Big plus the value of Big y.
   */
  P$3.plus = P$3.add = function (y) {
    var e, k, t,
      x = this,
      Big = x.constructor;

    y = new Big(y);

    // Signs differ?
    if (x.s != y.s) {
      y.s = -y.s;
      return x.minus(y);
    }

    var xe = x.e,
      xc = x.c,
      ye = y.e,
      yc = y.c;

    // Either zero?
    if (!xc[0] || !yc[0]) {
      if (!yc[0]) {
        if (xc[0]) {
          y = new Big(x);
        } else {
          y.s = x.s;
        }
      }
      return y;
    }

    xc = xc.slice();

    // Prepend zeros to equalise exponents.
    // Note: reverse faster than unshifts.
    if (e = xe - ye) {
      if (e > 0) {
        ye = xe;
        t = yc;
      } else {
        e = -e;
        t = xc;
      }

      t.reverse();
      for (; e--;) t.push(0);
      t.reverse();
    }

    // Point xc to the longer array.
    if (xc.length - yc.length < 0) {
      t = yc;
      yc = xc;
      xc = t;
    }

    e = yc.length;

    // Only start adding at yc.length - 1 as the further digits of xc can be left as they are.
    for (k = 0; e; xc[e] %= 10) k = (xc[--e] = xc[e] + yc[e] + k) / 10 | 0;

    // No need to check for zero, as +x + +y != 0 && -x + -y != 0

    if (k) {
      xc.unshift(k);
      ++ye;
    }

    // Remove trailing zeros.
    for (e = xc.length; xc[--e] === 0;) xc.pop();

    y.c = xc;
    y.e = ye;

    return y;
  };


  /*
   * Return a Big whose value is the value of this Big raised to the power n.
   * If n is negative, round to a maximum of Big.DP decimal places using rounding
   * mode Big.RM.
   *
   * n {number} Integer, -MAX_POWER to MAX_POWER inclusive.
   */
  P$3.pow = function (n) {
    var x = this,
      one = new x.constructor('1'),
      y = one,
      isneg = n < 0;

    if (n !== ~~n || n < -MAX_POWER$1 || n > MAX_POWER$1) {
      throw Error(INVALID$4 + 'exponent');
    }

    if (isneg) n = -n;

    for (;;) {
      if (n & 1) y = y.times(x);
      n >>= 1;
      if (!n) break;
      x = x.times(x);
    }

    return isneg ? one.div(y) : y;
  };


  /*
   * Return a new Big whose value is the value of this Big rounded to a maximum precision of sd
   * significant digits using rounding mode rm, or Big.RM if rm is not specified.
   *
   * sd {number} Significant digits: integer, 1 to MAX_DP inclusive.
   * rm? {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   */
  P$3.prec = function (sd, rm) {
    if (sd !== ~~sd || sd < 1 || sd > MAX_DP$1) {
      throw Error(INVALID$4 + 'precision');
    }
    return round$1(new this.constructor(this), sd, rm);
  };


  /*
   * Return a new Big whose value is the value of this Big rounded to a maximum of dp decimal places
   * using rounding mode rm, or Big.RM if rm is not specified.
   * If dp is negative, round to an integer which is a multiple of 10**-dp.
   * If dp is not specified, round to 0 decimal places.
   *
   * dp? {number} Integer, -MAX_DP to MAX_DP inclusive.
   * rm? {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   */
  P$3.round = function (dp, rm) {
    if (dp === UNDEFINED$1) dp = 0;
    else if (dp !== ~~dp || dp < -MAX_DP$1 || dp > MAX_DP$1) {
      throw Error(INVALID_DP$1);
    }
    return round$1(new this.constructor(this), dp + this.e + 1, rm);
  };


  /*
   * Return a new Big whose value is the square root of the value of this Big, rounded, if
   * necessary, to a maximum of Big.DP decimal places using rounding mode Big.RM.
   */
  P$3.sqrt = function () {
    var r, c, t,
      x = this,
      Big = x.constructor,
      s = x.s,
      e = x.e,
      half = new Big('0.5');

    // Zero?
    if (!x.c[0]) return new Big(x);

    // Negative?
    if (s < 0) {
      throw Error(NAME$1 + 'No square root');
    }

    // Estimate.
    s = Math.sqrt(+stringify$1(x, true, true));

    // Math.sqrt underflow/overflow?
    // Re-estimate: pass x coefficient to Math.sqrt as integer, then adjust the result exponent.
    if (s === 0 || s === 1 / 0) {
      c = x.c.join('');
      if (!(c.length + e & 1)) c += '0';
      s = Math.sqrt(c);
      e = ((e + 1) / 2 | 0) - (e < 0 || e & 1);
      r = new Big((s == 1 / 0 ? '5e' : (s = s.toExponential()).slice(0, s.indexOf('e') + 1)) + e);
    } else {
      r = new Big(s + '');
    }

    e = r.e + (Big.DP += 4);

    // Newton-Raphson iteration.
    do {
      t = r;
      r = half.times(t.plus(x.div(t)));
    } while (t.c.slice(0, e).join('') !== r.c.slice(0, e).join(''));

    return round$1(r, (Big.DP -= 4) + r.e + 1, Big.RM);
  };


  /*
   * Return a new Big whose value is the value of this Big times the value of Big y.
   */
  P$3.times = P$3.mul = function (y) {
    var c,
      x = this,
      Big = x.constructor,
      xc = x.c,
      yc = (y = new Big(y)).c,
      a = xc.length,
      b = yc.length,
      i = x.e,
      j = y.e;

    // Determine sign of result.
    y.s = x.s == y.s ? 1 : -1;

    // Return signed 0 if either 0.
    if (!xc[0] || !yc[0]) {
      y.c = [y.e = 0];
      return y;
    }

    // Initialise exponent of result as x.e + y.e.
    y.e = i + j;

    // If array xc has fewer digits than yc, swap xc and yc, and lengths.
    if (a < b) {
      c = xc;
      xc = yc;
      yc = c;
      j = a;
      a = b;
      b = j;
    }

    // Initialise coefficient array of result with zeros.
    for (c = new Array(j = a + b); j--;) c[j] = 0;

    // Multiply.

    // i is initially xc.length.
    for (i = b; i--;) {
      b = 0;

      // a is yc.length.
      for (j = a + i; j > i;) {

        // Current sum of products at this digit position, plus carry.
        b = c[j] + yc[i] * xc[j - i - 1] + b;
        c[j--] = b % 10;

        // carry
        b = b / 10 | 0;
      }

      c[j] = b;
    }

    // Increment result exponent if there is a final carry, otherwise remove leading zero.
    if (b) ++y.e;
    else c.shift();

    // Remove trailing zeros.
    for (i = c.length; !c[--i];) c.pop();
    y.c = c;

    return y;
  };


  /*
   * Return a string representing the value of this Big in exponential notation rounded to dp fixed
   * decimal places using rounding mode rm, or Big.RM if rm is not specified.
   *
   * dp? {number} Decimal places: integer, 0 to MAX_DP inclusive.
   * rm? {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   */
  P$3.toExponential = function (dp, rm) {
    var x = this,
      n = x.c[0];

    if (dp !== UNDEFINED$1) {
      if (dp !== ~~dp || dp < 0 || dp > MAX_DP$1) {
        throw Error(INVALID_DP$1);
      }
      x = round$1(new x.constructor(x), ++dp, rm);
      for (; x.c.length < dp;) x.c.push(0);
    }

    return stringify$1(x, true, !!n);
  };


  /*
   * Return a string representing the value of this Big in normal notation rounded to dp fixed
   * decimal places using rounding mode rm, or Big.RM if rm is not specified.
   *
   * dp? {number} Decimal places: integer, 0 to MAX_DP inclusive.
   * rm? {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   *
   * (-0).toFixed(0) is '0', but (-0.1).toFixed(0) is '-0'.
   * (-0).toFixed(1) is '0.0', but (-0.01).toFixed(1) is '-0.0'.
   */
  P$3.toFixed = function (dp, rm) {
    var x = this,
      n = x.c[0];

    if (dp !== UNDEFINED$1) {
      if (dp !== ~~dp || dp < 0 || dp > MAX_DP$1) {
        throw Error(INVALID_DP$1);
      }
      x = round$1(new x.constructor(x), dp + x.e + 1, rm);

      // x.e may have changed if the value is rounded up.
      for (dp = dp + x.e + 1; x.c.length < dp;) x.c.push(0);
    }

    return stringify$1(x, false, !!n);
  };


  /*
   * Return a string representing the value of this Big.
   * Return exponential notation if this Big has a positive exponent equal to or greater than
   * Big.PE, or a negative exponent equal to or less than Big.NE.
   * Omit the sign for negative zero.
   */
  P$3[Symbol.for('nodejs.util.inspect.custom')] = P$3.toJSON = P$3.toString = function () {
    var x = this,
      Big = x.constructor;
    return stringify$1(x, x.e <= Big.NE || x.e >= Big.PE, !!x.c[0]);
  };


  /*
   * Return the value of this Big as a primitve number.
   */
  P$3.toNumber = function () {
    var n = +stringify$1(this, true, true);
    if (this.constructor.strict === true && !this.eq(n.toString())) {
      throw Error(NAME$1 + 'Imprecise conversion');
    }
    return n;
  };


  /*
   * Return a string representing the value of this Big rounded to sd significant digits using
   * rounding mode rm, or Big.RM if rm is not specified.
   * Use exponential notation if sd is less than the number of digits necessary to represent
   * the integer part of the value in normal notation.
   *
   * sd {number} Significant digits: integer, 1 to MAX_DP inclusive.
   * rm? {number} Rounding mode: 0 (down), 1 (half-up), 2 (half-even) or 3 (up).
   */
  P$3.toPrecision = function (sd, rm) {
    var x = this,
      Big = x.constructor,
      n = x.c[0];

    if (sd !== UNDEFINED$1) {
      if (sd !== ~~sd || sd < 1 || sd > MAX_DP$1) {
        throw Error(INVALID$4 + 'precision');
      }
      x = round$1(new Big(x), sd, rm);
      for (; x.c.length < sd;) x.c.push(0);
    }

    return stringify$1(x, sd <= x.e || x.e <= Big.NE || x.e >= Big.PE, !!n);
  };


  /*
   * Return a string representing the value of this Big.
   * Return exponential notation if this Big has a positive exponent equal to or greater than
   * Big.PE, or a negative exponent equal to or less than Big.NE.
   * Include the sign for negative zero.
   */
  P$3.valueOf = function () {
    var x = this,
      Big = x.constructor;
    if (Big.strict === true) {
      throw Error(NAME$1 + 'valueOf disallowed');
    }
    return stringify$1(x, x.e <= Big.NE || x.e >= Big.PE, true);
  };


  // Export


  var Big$1 = _Big_$1();

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  var classnames$1 = {exports: {}};

  /*!
  	Copyright (c) 2018 Jed Watson.
  	Licensed under the MIT License (MIT), see
  	http://jedwatson.github.io/classnames
  */

  var hasRequiredClassnames;

  function requireClassnames () {
  	if (hasRequiredClassnames) return classnames$1.exports;
  	hasRequiredClassnames = 1;
  	(function (module) {
  		/* global define */

  		(function () {

  			var hasOwn = {}.hasOwnProperty;

  			function classNames () {
  				var classes = '';

  				for (var i = 0; i < arguments.length; i++) {
  					var arg = arguments[i];
  					if (arg) {
  						classes = appendClass(classes, parseValue(arg));
  					}
  				}

  				return classes;
  			}

  			function parseValue (arg) {
  				if (typeof arg === 'string' || typeof arg === 'number') {
  					return arg;
  				}

  				if (typeof arg !== 'object') {
  					return '';
  				}

  				if (Array.isArray(arg)) {
  					return classNames.apply(null, arg);
  				}

  				if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
  					return arg.toString();
  				}

  				var classes = '';

  				for (var key in arg) {
  					if (hasOwn.call(arg, key) && arg[key]) {
  						classes = appendClass(classes, key);
  					}
  				}

  				return classes;
  			}

  			function appendClass (value, newClass) {
  				if (!newClass) {
  					return value;
  				}
  			
  				if (value) {
  					return value + ' ' + newClass;
  				}
  			
  				return value + newClass;
  			}

  			if (module.exports) {
  				classNames.default = classNames;
  				module.exports = classNames;
  			} else {
  				window.classNames = classNames;
  			}
  		}()); 
  	} (classnames$1));
  	return classnames$1.exports;
  }

  var classnamesExports = requireClassnames();
  var classnames = /*@__PURE__*/getDefaultExportFromCjs(classnamesExports);

  var n$1,l$2,u$1,t$2,o$2,r$1,f$1,e$1,c$1={},s$2=[],a$1=/acit|ex(?:s|g|n|p|$)|rph|grid|ows|mnc|ntw|ine[ch]|zoo|^ord|itera/i,v$2=Array.isArray;function h$1(n,l){for(var u in l)n[u]=l[u];return n}function p$1(n){var l=n.parentNode;l&&l.removeChild(n);}function y$1(l,u,i){var t,o,r,f={};for(r in u)"key"==r?t=u[r]:"ref"==r?o=u[r]:f[r]=u[r];if(arguments.length>2&&(f.children=arguments.length>3?n$1.call(arguments,2):i),"function"==typeof l&&null!=l.defaultProps)for(r in l.defaultProps)void 0===f[r]&&(f[r]=l.defaultProps[r]);return d$1(l,f,t,o,null)}function d$1(n,i,t,o,r){var f={type:n,props:i,key:t,ref:o,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,__h:null,constructor:void 0,__v:null==r?++u$1:r};return null==r&&null!=l$2.vnode&&l$2.vnode(f),f}function k$2(n){return n.children}function b$1(n,l){this.props=n,this.context=l;}function g$2(n,l){if(null==l)return n.__?g$2(n.__,n.__.__k.indexOf(n)+1):null;for(var u;l<n.__k.length;l++)if(null!=(u=n.__k[l])&&null!=u.__e)return u.__e;return "function"==typeof n.type?g$2(n):null}function m$1(n){var l,u;if(null!=(n=n.__)&&null!=n.__c){for(n.__e=n.__c.base=null,l=0;l<n.__k.length;l++)if(null!=(u=n.__k[l])&&null!=u.__e){n.__e=n.__c.base=u.__e;break}return m$1(n)}}function w$2(n){(!n.__d&&(n.__d=!0)&&t$2.push(n)&&!x.__r++||o$2!==l$2.debounceRendering)&&((o$2=l$2.debounceRendering)||r$1)(x);}function x(){var n,l,u,i,o,r,e,c;for(t$2.sort(f$1);n=t$2.shift();)n.__d&&(l=t$2.length,i=void 0,o=void 0,e=(r=(u=n).__v).__e,(c=u.__P)&&(i=[],(o=h$1({},r)).__v=r.__v+1,L$2(c,r,o,u.__n,void 0!==c.ownerSVGElement,null!=r.__h?[e]:null,i,null==e?g$2(r):e,r.__h),M$1(i,r),r.__e!=e&&m$1(r)),t$2.length>l&&t$2.sort(f$1));x.__r=0;}function P$2(n,l,u,i,t,o,r,f,e,a){var h,p,y,_,b,m,w,x=i&&i.__k||s$2,P=x.length;for(u.__k=[],h=0;h<l.length;h++)if(null!=(_=u.__k[h]=null==(_=l[h])||"boolean"==typeof _||"function"==typeof _?null:"string"==typeof _||"number"==typeof _||"bigint"==typeof _?d$1(null,_,null,null,_):v$2(_)?d$1(k$2,{children:_},null,null,null):_.__b>0?d$1(_.type,_.props,_.key,_.ref?_.ref:null,_.__v):_)){if(_.__=u,_.__b=u.__b+1,null===(y=x[h])||y&&_.key==y.key&&_.type===y.type)x[h]=void 0;else for(p=0;p<P;p++){if((y=x[p])&&_.key==y.key&&_.type===y.type){x[p]=void 0;break}y=null;}L$2(n,_,y=y||c$1,t,o,r,f,e,a),b=_.__e,(p=_.ref)&&y.ref!=p&&(w||(w=[]),y.ref&&w.push(y.ref,null,_),w.push(p,_.__c||b,_)),null!=b?(null==m&&(m=b),"function"==typeof _.type&&_.__k===y.__k?_.__d=e=C$2(_,e,n):e=$$1(n,_,y,x,b,e),"function"==typeof u.type&&(u.__d=e)):e&&y.__e==e&&e.parentNode!=n&&(e=g$2(y));}for(u.__e=m,h=P;h--;)null!=x[h]&&("function"==typeof u.type&&null!=x[h].__e&&x[h].__e==u.__d&&(u.__d=A(i).nextSibling),q$2(x[h],x[h]));if(w)for(h=0;h<w.length;h++)O(w[h],w[++h],w[++h]);}function C$2(n,l,u){for(var i,t=n.__k,o=0;t&&o<t.length;o++)(i=t[o])&&(i.__=n,l="function"==typeof i.type?C$2(i,l,u):$$1(u,i,i,t,i.__e,l));return l}function S(n,l){return l=l||[],null==n||"boolean"==typeof n||(v$2(n)?n.some(function(n){S(n,l);}):l.push(n)),l}function $$1(n,l,u,i,t,o){var r,f,e;if(void 0!==l.__d)r=l.__d,l.__d=void 0;else if(null==u||t!=o||null==t.parentNode)n:if(null==o||o.parentNode!==n)n.appendChild(t),r=null;else {for(f=o,e=0;(f=f.nextSibling)&&e<i.length;e+=1)if(f==t)break n;n.insertBefore(t,o),r=o;}return void 0!==r?r:t.nextSibling}function A(n){var l,u,i;if(null==n.type||"string"==typeof n.type)return n.__e;if(n.__k)for(l=n.__k.length-1;l>=0;l--)if((u=n.__k[l])&&(i=A(u)))return i;return null}function H$1(n,l,u,i,t){var o;for(o in u)"children"===o||"key"===o||o in l||T$3(n,o,null,u[o],i);for(o in l)t&&"function"!=typeof l[o]||"children"===o||"key"===o||"value"===o||"checked"===o||u[o]===l[o]||T$3(n,o,l[o],u[o],i);}function I$1(n,l,u){"-"===l[0]?n.setProperty(l,null==u?"":u):n[l]=null==u?"":"number"!=typeof u||a$1.test(l)?u:u+"px";}function T$3(n,l,u,i,t){var o;n:if("style"===l)if("string"==typeof u)n.style.cssText=u;else {if("string"==typeof i&&(n.style.cssText=i=""),i)for(l in i)u&&l in u||I$1(n.style,l,"");if(u)for(l in u)i&&u[l]===i[l]||I$1(n.style,l,u[l]);}else if("o"===l[0]&&"n"===l[1])o=l!==(l=l.replace(/Capture$/,"")),l=l.toLowerCase()in n?l.toLowerCase().slice(2):l.slice(2),n.l||(n.l={}),n.l[l+o]=u,u?i||n.addEventListener(l,o?z$3:j$2,o):n.removeEventListener(l,o?z$3:j$2,o);else if("dangerouslySetInnerHTML"!==l){if(t)l=l.replace(/xlink(H|:h)/,"h").replace(/sName$/,"s");else if("width"!==l&&"height"!==l&&"href"!==l&&"list"!==l&&"form"!==l&&"tabIndex"!==l&&"download"!==l&&"rowSpan"!==l&&"colSpan"!==l&&l in n)try{n[l]=null==u?"":u;break n}catch(n){}"function"==typeof u||(null==u||!1===u&&"-"!==l[4]?n.removeAttribute(l):n.setAttribute(l,u));}}function j$2(n){return this.l[n.type+!1](l$2.event?l$2.event(n):n)}function z$3(n){return this.l[n.type+!0](l$2.event?l$2.event(n):n)}function L$2(n,u,i,t,o,r,f,e,c){var s,a,p,y,d,_,g,m,w,x,C,S,$,A,H,I=u.type;if(void 0!==u.constructor)return null;null!=i.__h&&(c=i.__h,e=u.__e=i.__e,u.__h=null,r=[e]),(s=l$2.__b)&&s(u);try{n:if("function"==typeof I){if(m=u.props,w=(s=I.contextType)&&t[s.__c],x=s?w?w.props.value:s.__:t,i.__c?g=(a=u.__c=i.__c).__=a.__E:("prototype"in I&&I.prototype.render?u.__c=a=new I(m,x):(u.__c=a=new b$1(m,x),a.constructor=I,a.render=B$2),w&&w.sub(a),a.props=m,a.state||(a.state={}),a.context=x,a.__n=t,p=a.__d=!0,a.__h=[],a._sb=[]),null==a.__s&&(a.__s=a.state),null!=I.getDerivedStateFromProps&&(a.__s==a.state&&(a.__s=h$1({},a.__s)),h$1(a.__s,I.getDerivedStateFromProps(m,a.__s))),y=a.props,d=a.state,a.__v=u,p)null==I.getDerivedStateFromProps&&null!=a.componentWillMount&&a.componentWillMount(),null!=a.componentDidMount&&a.__h.push(a.componentDidMount);else {if(null==I.getDerivedStateFromProps&&m!==y&&null!=a.componentWillReceiveProps&&a.componentWillReceiveProps(m,x),!a.__e&&null!=a.shouldComponentUpdate&&!1===a.shouldComponentUpdate(m,a.__s,x)||u.__v===i.__v){for(u.__v!==i.__v&&(a.props=m,a.state=a.__s,a.__d=!1),a.__e=!1,u.__e=i.__e,u.__k=i.__k,u.__k.forEach(function(n){n&&(n.__=u);}),C=0;C<a._sb.length;C++)a.__h.push(a._sb[C]);a._sb=[],a.__h.length&&f.push(a);break n}null!=a.componentWillUpdate&&a.componentWillUpdate(m,a.__s,x),null!=a.componentDidUpdate&&a.__h.push(function(){a.componentDidUpdate(y,d,_);});}if(a.context=x,a.props=m,a.__P=n,S=l$2.__r,$=0,"prototype"in I&&I.prototype.render){for(a.state=a.__s,a.__d=!1,S&&S(u),s=a.render(a.props,a.state,a.context),A=0;A<a._sb.length;A++)a.__h.push(a._sb[A]);a._sb=[];}else do{a.__d=!1,S&&S(u),s=a.render(a.props,a.state,a.context),a.state=a.__s;}while(a.__d&&++$<25);a.state=a.__s,null!=a.getChildContext&&(t=h$1(h$1({},t),a.getChildContext())),p||null==a.getSnapshotBeforeUpdate||(_=a.getSnapshotBeforeUpdate(y,d)),P$2(n,v$2(H=null!=s&&s.type===k$2&&null==s.key?s.props.children:s)?H:[H],u,i,t,o,r,f,e,c),a.base=u.__e,u.__h=null,a.__h.length&&f.push(a),g&&(a.__E=a.__=null),a.__e=!1;}else null==r&&u.__v===i.__v?(u.__k=i.__k,u.__e=i.__e):u.__e=N$1(i.__e,u,i,t,o,r,f,c);(s=l$2.diffed)&&s(u);}catch(n){u.__v=null,(c||null!=r)&&(u.__e=e,u.__h=!!c,r[r.indexOf(e)]=null),l$2.__e(n,u,i);}}function M$1(n,u){l$2.__c&&l$2.__c(u,n),n.some(function(u){try{n=u.__h,u.__h=[],n.some(function(n){n.call(u);});}catch(n){l$2.__e(n,u.__v);}});}function N$1(l,u,i,t,o,r,f,e){var s,a,h,y=i.props,d=u.props,_=u.type,k=0;if("svg"===_&&(o=!0),null!=r)for(;k<r.length;k++)if((s=r[k])&&"setAttribute"in s==!!_&&(_?s.localName===_:3===s.nodeType)){l=s,r[k]=null;break}if(null==l){if(null===_)return document.createTextNode(d);l=o?document.createElementNS("http://www.w3.org/2000/svg",_):document.createElement(_,d.is&&d),r=null,e=!1;}if(null===_)y===d||e&&l.data===d||(l.data=d);else {if(r=r&&n$1.call(l.childNodes),a=(y=i.props||c$1).dangerouslySetInnerHTML,h=d.dangerouslySetInnerHTML,!e){if(null!=r)for(y={},k=0;k<l.attributes.length;k++)y[l.attributes[k].name]=l.attributes[k].value;(h||a)&&(h&&(a&&h.__html==a.__html||h.__html===l.innerHTML)||(l.innerHTML=h&&h.__html||""));}if(H$1(l,d,y,o,e),h)u.__k=[];else if(P$2(l,v$2(k=u.props.children)?k:[k],u,i,t,o&&"foreignObject"!==_,r,f,r?r[0]:i.__k&&g$2(i,0),e),null!=r)for(k=r.length;k--;)null!=r[k]&&p$1(r[k]);e||("value"in d&&void 0!==(k=d.value)&&(k!==l.value||"progress"===_&&!k||"option"===_&&k!==y.value)&&T$3(l,"value",k,y.value,!1),"checked"in d&&void 0!==(k=d.checked)&&k!==l.checked&&T$3(l,"checked",k,y.checked,!1));}return l}function O(n,u,i){try{"function"==typeof n?n(u):n.current=u;}catch(n){l$2.__e(n,i);}}function q$2(n,u,i){var t,o;if(l$2.unmount&&l$2.unmount(n),(t=n.ref)&&(t.current&&t.current!==n.__e||O(t,null,u)),null!=(t=n.__c)){if(t.componentWillUnmount)try{t.componentWillUnmount();}catch(n){l$2.__e(n,u);}t.base=t.__P=null,n.__c=void 0;}if(t=n.__k)for(o=0;o<t.length;o++)t[o]&&q$2(t[o],u,i||"function"!=typeof n.type);i||null==n.__e||p$1(n.__e),n.__=n.__e=n.__d=void 0;}function B$2(n,l,u){return this.constructor(n,u)}function D$1(u,i,t){var o,r,f;l$2.__&&l$2.__(u,i),r=(o="function"==typeof t)?null:i.__k,f=[],L$2(i,u=(!o&&t||i).__k=y$1(k$2,null,[u]),r||c$1,c$1,void 0!==i.ownerSVGElement,!o&&t?[t]:r?null:i.firstChild?n$1.call(i.childNodes):null,f,!o&&t?t:r?r.__e:i.firstChild,o),M$1(f,u);}function G(n,l){var u={__c:l="__cC"+e$1++,__:n,Consumer:function(n,l){return n.children(l)},Provider:function(n){var u,i;return this.getChildContext||(u=[],(i={})[l]=this,this.getChildContext=function(){return i},this.shouldComponentUpdate=function(n){this.props.value!==n.value&&u.some(function(n){n.__e=!0,w$2(n);});},this.sub=function(n){u.push(n);var l=n.componentWillUnmount;n.componentWillUnmount=function(){u.splice(u.indexOf(n),1),l&&l.call(n);};}),n.children}};return u.Provider.__=u.Consumer.contextType=u}n$1=s$2.slice,l$2={__e:function(n,l,u,i){for(var t,o,r;l=l.__;)if((t=l.__c)&&!t.__)try{if((o=t.constructor)&&null!=o.getDerivedStateFromError&&(t.setState(o.getDerivedStateFromError(n)),r=t.__d),null!=t.componentDidCatch&&(t.componentDidCatch(n,i||{}),r=t.__d),r)return t.__E=t}catch(l){n=l;}throw n}},u$1=0,b$1.prototype.setState=function(n,l){var u;u=null!=this.__s&&this.__s!==this.state?this.__s:this.__s=h$1({},this.state),"function"==typeof n&&(n=n(h$1({},u),this.props)),n&&h$1(u,n),null!=n&&this.__v&&(l&&this._sb.push(l),w$2(this));},b$1.prototype.forceUpdate=function(n){this.__v&&(this.__e=!0,n&&this.__h.push(n),w$2(this));},b$1.prototype.render=k$2,t$2=[],r$1="function"==typeof Promise?Promise.prototype.then.bind(Promise.resolve()):setTimeout,f$1=function(n,l){return n.__v.__b-l.__v.__b},x.__r=0,e$1=0;

  var _$1=0;function o$1(o,e,n,t,f,l){var s,u,a={};for(u in e)"ref"==u?s=e[u]:a[u]=e[u];var i={type:o,props:a,key:n,ref:s,__k:null,__:null,__b:0,__e:null,__d:void 0,__c:null,__h:null,constructor:void 0,__v:--_$1,__source:f,__self:l};if("function"==typeof o&&(s=o.defaultProps))for(u in s)void 0===a[u]&&(a[u]=s[u]);return l$2.vnode&&l$2.vnode(i),i}

  var t$1,r,u,i$1,o=0,f=[],c=[],e=l$2.__b,a=l$2.__r,v$1=l$2.diffed,l$1=l$2.__c,m=l$2.unmount;function d(t,u){l$2.__h&&l$2.__h(r,t,o||u),o=0;var i=r.__H||(r.__H={__:[],__h:[]});return t>=i.__.length&&i.__.push({__V:c}),i.__[t]}function h(n){return o=1,s$1(B$1,n)}function s$1(n,u,i){var o=d(t$1++,2);if(o.t=n,!o.__c&&(o.__=[i?i(u):B$1(void 0,u),function(n){var t=o.__N?o.__N[0]:o.__[0],r=o.t(t,n);t!==r&&(o.__N=[r,o.__[1]],o.__c.setState({}));}],o.__c=r,!r.u)){var f=function(n,t,r){if(!o.__c.__H)return !0;var u=o.__c.__H.__.filter(function(n){return n.__c});if(u.every(function(n){return !n.__N}))return !c||c.call(this,n,t,r);var i=!1;return u.forEach(function(n){if(n.__N){var t=n.__[0];n.__=n.__N,n.__N=void 0,t!==n.__[0]&&(i=!0);}}),!(!i&&o.__c.props===n)&&(!c||c.call(this,n,t,r))};r.u=!0;var c=r.shouldComponentUpdate,e=r.componentWillUpdate;r.componentWillUpdate=function(n,t,r){if(this.__e){var u=c;c=void 0,f(n,t,r),c=u;}e&&e.call(this,n,t,r);},r.shouldComponentUpdate=f;}return o.__N||o.__}function p(u,i){var o=d(t$1++,3);!l$2.__s&&z$2(o.__H,i)&&(o.__=u,o.i=i,r.__H.__h.push(o));}function y(u,i){var o=d(t$1++,4);!l$2.__s&&z$2(o.__H,i)&&(o.__=u,o.i=i,r.__h.push(o));}function _(n){return o=5,F$1(function(){return {current:n}},[])}function F$1(n,r){var u=d(t$1++,7);return z$2(u.__H,r)?(u.__V=n(),u.i=r,u.__h=n,u.__V):u.__}function T$2(n,t){return o=8,F$1(function(){return n},t)}function q$1(n){var u=r.context[n.__c],i=d(t$1++,9);return i.c=n,u?(null==i.__&&(i.__=!0,u.sub(r)),u.props.value):n.__}function b(){for(var t;t=f.shift();)if(t.__P&&t.__H)try{t.__H.__h.forEach(k$1),t.__H.__h.forEach(w$1),t.__H.__h=[];}catch(r){t.__H.__h=[],l$2.__e(r,t.__v);}}l$2.__b=function(n){r=null,e&&e(n);},l$2.__r=function(n){a&&a(n),t$1=0;var i=(r=n.__c).__H;i&&(u===r?(i.__h=[],r.__h=[],i.__.forEach(function(n){n.__N&&(n.__=n.__N),n.__V=c,n.__N=n.i=void 0;})):(i.__h.forEach(k$1),i.__h.forEach(w$1),i.__h=[],t$1=0)),u=r;},l$2.diffed=function(t){v$1&&v$1(t);var o=t.__c;o&&o.__H&&(o.__H.__h.length&&(1!==f.push(o)&&i$1===l$2.requestAnimationFrame||((i$1=l$2.requestAnimationFrame)||j$1)(b)),o.__H.__.forEach(function(n){n.i&&(n.__H=n.i),n.__V!==c&&(n.__=n.__V),n.i=void 0,n.__V=c;})),u=r=null;},l$2.__c=function(t,r){r.some(function(t){try{t.__h.forEach(k$1),t.__h=t.__h.filter(function(n){return !n.__||w$1(n)});}catch(u){r.some(function(n){n.__h&&(n.__h=[]);}),r=[],l$2.__e(u,t.__v);}}),l$1&&l$1(t,r);},l$2.unmount=function(t){m&&m(t);var r,u=t.__c;u&&u.__H&&(u.__H.__.forEach(function(n){try{k$1(n);}catch(n){r=n;}}),u.__H=void 0,r&&l$2.__e(r,u.__v));};var g$1="function"==typeof requestAnimationFrame;function j$1(n){var t,r=function(){clearTimeout(u),g$1&&cancelAnimationFrame(t),setTimeout(n);},u=setTimeout(r,100);g$1&&(t=requestAnimationFrame(r));}function k$1(n){var t=r,u=n.__c;"function"==typeof u&&(n.__c=void 0,u()),r=t;}function w$1(n){var t=r;n.__c=n.__(),r=t;}function z$2(n,t){return !n||n.length!==t.length||t.some(function(t,r){return t!==n[r]})}function B$1(n,t){return "function"==typeof t?t(n):t}

  /**
   * Removes all key-value entries from the list cache.
   *
   * @private
   * @name clear
   * @memberOf ListCache
   */

  var _listCacheClear;
  var hasRequired_listCacheClear;

  function require_listCacheClear () {
  	if (hasRequired_listCacheClear) return _listCacheClear;
  	hasRequired_listCacheClear = 1;
  	function listCacheClear() {
  	  this.__data__ = [];
  	  this.size = 0;
  	}

  	_listCacheClear = listCacheClear;
  	return _listCacheClear;
  }

  /**
   * Performs a
   * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * comparison between two values to determine if they are equivalent.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to compare.
   * @param {*} other The other value to compare.
   * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
   * @example
   *
   * var object = { 'a': 1 };
   * var other = { 'a': 1 };
   *
   * _.eq(object, object);
   * // => true
   *
   * _.eq(object, other);
   * // => false
   *
   * _.eq('a', 'a');
   * // => true
   *
   * _.eq('a', Object('a'));
   * // => false
   *
   * _.eq(NaN, NaN);
   * // => true
   */

  var eq_1;
  var hasRequiredEq;

  function requireEq () {
  	if (hasRequiredEq) return eq_1;
  	hasRequiredEq = 1;
  	function eq(value, other) {
  	  return value === other || (value !== value && other !== other);
  	}

  	eq_1 = eq;
  	return eq_1;
  }

  var _assocIndexOf;
  var hasRequired_assocIndexOf;

  function require_assocIndexOf () {
  	if (hasRequired_assocIndexOf) return _assocIndexOf;
  	hasRequired_assocIndexOf = 1;
  	var eq = requireEq();

  	/**
  	 * Gets the index at which the `key` is found in `array` of key-value pairs.
  	 *
  	 * @private
  	 * @param {Array} array The array to inspect.
  	 * @param {*} key The key to search for.
  	 * @returns {number} Returns the index of the matched value, else `-1`.
  	 */
  	function assocIndexOf(array, key) {
  	  var length = array.length;
  	  while (length--) {
  	    if (eq(array[length][0], key)) {
  	      return length;
  	    }
  	  }
  	  return -1;
  	}

  	_assocIndexOf = assocIndexOf;
  	return _assocIndexOf;
  }

  var _listCacheDelete;
  var hasRequired_listCacheDelete;

  function require_listCacheDelete () {
  	if (hasRequired_listCacheDelete) return _listCacheDelete;
  	hasRequired_listCacheDelete = 1;
  	var assocIndexOf = require_assocIndexOf();

  	/** Used for built-in method references. */
  	var arrayProto = Array.prototype;

  	/** Built-in value references. */
  	var splice = arrayProto.splice;

  	/**
  	 * Removes `key` and its value from the list cache.
  	 *
  	 * @private
  	 * @name delete
  	 * @memberOf ListCache
  	 * @param {string} key The key of the value to remove.
  	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  	 */
  	function listCacheDelete(key) {
  	  var data = this.__data__,
  	      index = assocIndexOf(data, key);

  	  if (index < 0) {
  	    return false;
  	  }
  	  var lastIndex = data.length - 1;
  	  if (index == lastIndex) {
  	    data.pop();
  	  } else {
  	    splice.call(data, index, 1);
  	  }
  	  --this.size;
  	  return true;
  	}

  	_listCacheDelete = listCacheDelete;
  	return _listCacheDelete;
  }

  var _listCacheGet;
  var hasRequired_listCacheGet;

  function require_listCacheGet () {
  	if (hasRequired_listCacheGet) return _listCacheGet;
  	hasRequired_listCacheGet = 1;
  	var assocIndexOf = require_assocIndexOf();

  	/**
  	 * Gets the list cache value for `key`.
  	 *
  	 * @private
  	 * @name get
  	 * @memberOf ListCache
  	 * @param {string} key The key of the value to get.
  	 * @returns {*} Returns the entry value.
  	 */
  	function listCacheGet(key) {
  	  var data = this.__data__,
  	      index = assocIndexOf(data, key);

  	  return index < 0 ? undefined : data[index][1];
  	}

  	_listCacheGet = listCacheGet;
  	return _listCacheGet;
  }

  var _listCacheHas;
  var hasRequired_listCacheHas;

  function require_listCacheHas () {
  	if (hasRequired_listCacheHas) return _listCacheHas;
  	hasRequired_listCacheHas = 1;
  	var assocIndexOf = require_assocIndexOf();

  	/**
  	 * Checks if a list cache value for `key` exists.
  	 *
  	 * @private
  	 * @name has
  	 * @memberOf ListCache
  	 * @param {string} key The key of the entry to check.
  	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  	 */
  	function listCacheHas(key) {
  	  return assocIndexOf(this.__data__, key) > -1;
  	}

  	_listCacheHas = listCacheHas;
  	return _listCacheHas;
  }

  var _listCacheSet;
  var hasRequired_listCacheSet;

  function require_listCacheSet () {
  	if (hasRequired_listCacheSet) return _listCacheSet;
  	hasRequired_listCacheSet = 1;
  	var assocIndexOf = require_assocIndexOf();

  	/**
  	 * Sets the list cache `key` to `value`.
  	 *
  	 * @private
  	 * @name set
  	 * @memberOf ListCache
  	 * @param {string} key The key of the value to set.
  	 * @param {*} value The value to set.
  	 * @returns {Object} Returns the list cache instance.
  	 */
  	function listCacheSet(key, value) {
  	  var data = this.__data__,
  	      index = assocIndexOf(data, key);

  	  if (index < 0) {
  	    ++this.size;
  	    data.push([key, value]);
  	  } else {
  	    data[index][1] = value;
  	  }
  	  return this;
  	}

  	_listCacheSet = listCacheSet;
  	return _listCacheSet;
  }

  var _ListCache;
  var hasRequired_ListCache;

  function require_ListCache () {
  	if (hasRequired_ListCache) return _ListCache;
  	hasRequired_ListCache = 1;
  	var listCacheClear = require_listCacheClear(),
  	    listCacheDelete = require_listCacheDelete(),
  	    listCacheGet = require_listCacheGet(),
  	    listCacheHas = require_listCacheHas(),
  	    listCacheSet = require_listCacheSet();

  	/**
  	 * Creates an list cache object.
  	 *
  	 * @private
  	 * @constructor
  	 * @param {Array} [entries] The key-value pairs to cache.
  	 */
  	function ListCache(entries) {
  	  var index = -1,
  	      length = entries == null ? 0 : entries.length;

  	  this.clear();
  	  while (++index < length) {
  	    var entry = entries[index];
  	    this.set(entry[0], entry[1]);
  	  }
  	}

  	// Add methods to `ListCache`.
  	ListCache.prototype.clear = listCacheClear;
  	ListCache.prototype['delete'] = listCacheDelete;
  	ListCache.prototype.get = listCacheGet;
  	ListCache.prototype.has = listCacheHas;
  	ListCache.prototype.set = listCacheSet;

  	_ListCache = ListCache;
  	return _ListCache;
  }

  var _stackClear;
  var hasRequired_stackClear;

  function require_stackClear () {
  	if (hasRequired_stackClear) return _stackClear;
  	hasRequired_stackClear = 1;
  	var ListCache = require_ListCache();

  	/**
  	 * Removes all key-value entries from the stack.
  	 *
  	 * @private
  	 * @name clear
  	 * @memberOf Stack
  	 */
  	function stackClear() {
  	  this.__data__ = new ListCache;
  	  this.size = 0;
  	}

  	_stackClear = stackClear;
  	return _stackClear;
  }

  /**
   * Removes `key` and its value from the stack.
   *
   * @private
   * @name delete
   * @memberOf Stack
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */

  var _stackDelete;
  var hasRequired_stackDelete;

  function require_stackDelete () {
  	if (hasRequired_stackDelete) return _stackDelete;
  	hasRequired_stackDelete = 1;
  	function stackDelete(key) {
  	  var data = this.__data__,
  	      result = data['delete'](key);

  	  this.size = data.size;
  	  return result;
  	}

  	_stackDelete = stackDelete;
  	return _stackDelete;
  }

  /**
   * Gets the stack value for `key`.
   *
   * @private
   * @name get
   * @memberOf Stack
   * @param {string} key The key of the value to get.
   * @returns {*} Returns the entry value.
   */

  var _stackGet;
  var hasRequired_stackGet;

  function require_stackGet () {
  	if (hasRequired_stackGet) return _stackGet;
  	hasRequired_stackGet = 1;
  	function stackGet(key) {
  	  return this.__data__.get(key);
  	}

  	_stackGet = stackGet;
  	return _stackGet;
  }

  /**
   * Checks if a stack value for `key` exists.
   *
   * @private
   * @name has
   * @memberOf Stack
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */

  var _stackHas;
  var hasRequired_stackHas;

  function require_stackHas () {
  	if (hasRequired_stackHas) return _stackHas;
  	hasRequired_stackHas = 1;
  	function stackHas(key) {
  	  return this.__data__.has(key);
  	}

  	_stackHas = stackHas;
  	return _stackHas;
  }

  /** Detect free variable `global` from Node.js. */

  var _freeGlobal;
  var hasRequired_freeGlobal;

  function require_freeGlobal () {
  	if (hasRequired_freeGlobal) return _freeGlobal;
  	hasRequired_freeGlobal = 1;
  	var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

  	_freeGlobal = freeGlobal;
  	return _freeGlobal;
  }

  var _root;
  var hasRequired_root;

  function require_root () {
  	if (hasRequired_root) return _root;
  	hasRequired_root = 1;
  	var freeGlobal = require_freeGlobal();

  	/** Detect free variable `self`. */
  	var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  	/** Used as a reference to the global object. */
  	var root = freeGlobal || freeSelf || Function('return this')();

  	_root = root;
  	return _root;
  }

  var _Symbol;
  var hasRequired_Symbol;

  function require_Symbol () {
  	if (hasRequired_Symbol) return _Symbol;
  	hasRequired_Symbol = 1;
  	var root = require_root();

  	/** Built-in value references. */
  	var Symbol = root.Symbol;

  	_Symbol = Symbol;
  	return _Symbol;
  }

  var _getRawTag;
  var hasRequired_getRawTag;

  function require_getRawTag () {
  	if (hasRequired_getRawTag) return _getRawTag;
  	hasRequired_getRawTag = 1;
  	var Symbol = require_Symbol();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * Used to resolve the
  	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
  	 * of values.
  	 */
  	var nativeObjectToString = objectProto.toString;

  	/** Built-in value references. */
  	var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

  	/**
  	 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
  	 *
  	 * @private
  	 * @param {*} value The value to query.
  	 * @returns {string} Returns the raw `toStringTag`.
  	 */
  	function getRawTag(value) {
  	  var isOwn = hasOwnProperty.call(value, symToStringTag),
  	      tag = value[symToStringTag];

  	  try {
  	    value[symToStringTag] = undefined;
  	    var unmasked = true;
  	  } catch (e) {}

  	  var result = nativeObjectToString.call(value);
  	  if (unmasked) {
  	    if (isOwn) {
  	      value[symToStringTag] = tag;
  	    } else {
  	      delete value[symToStringTag];
  	    }
  	  }
  	  return result;
  	}

  	_getRawTag = getRawTag;
  	return _getRawTag;
  }

  /** Used for built-in method references. */

  var _objectToString;
  var hasRequired_objectToString;

  function require_objectToString () {
  	if (hasRequired_objectToString) return _objectToString;
  	hasRequired_objectToString = 1;
  	var objectProto = Object.prototype;

  	/**
  	 * Used to resolve the
  	 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
  	 * of values.
  	 */
  	var nativeObjectToString = objectProto.toString;

  	/**
  	 * Converts `value` to a string using `Object.prototype.toString`.
  	 *
  	 * @private
  	 * @param {*} value The value to convert.
  	 * @returns {string} Returns the converted string.
  	 */
  	function objectToString(value) {
  	  return nativeObjectToString.call(value);
  	}

  	_objectToString = objectToString;
  	return _objectToString;
  }

  var _baseGetTag;
  var hasRequired_baseGetTag;

  function require_baseGetTag () {
  	if (hasRequired_baseGetTag) return _baseGetTag;
  	hasRequired_baseGetTag = 1;
  	var Symbol = require_Symbol(),
  	    getRawTag = require_getRawTag(),
  	    objectToString = require_objectToString();

  	/** `Object#toString` result references. */
  	var nullTag = '[object Null]',
  	    undefinedTag = '[object Undefined]';

  	/** Built-in value references. */
  	var symToStringTag = Symbol ? Symbol.toStringTag : undefined;

  	/**
  	 * The base implementation of `getTag` without fallbacks for buggy environments.
  	 *
  	 * @private
  	 * @param {*} value The value to query.
  	 * @returns {string} Returns the `toStringTag`.
  	 */
  	function baseGetTag(value) {
  	  if (value == null) {
  	    return value === undefined ? undefinedTag : nullTag;
  	  }
  	  return (symToStringTag && symToStringTag in Object(value))
  	    ? getRawTag(value)
  	    : objectToString(value);
  	}

  	_baseGetTag = baseGetTag;
  	return _baseGetTag;
  }

  /**
   * Checks if `value` is the
   * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
   * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an object, else `false`.
   * @example
   *
   * _.isObject({});
   * // => true
   *
   * _.isObject([1, 2, 3]);
   * // => true
   *
   * _.isObject(_.noop);
   * // => true
   *
   * _.isObject(null);
   * // => false
   */

  var isObject_1;
  var hasRequiredIsObject;

  function requireIsObject () {
  	if (hasRequiredIsObject) return isObject_1;
  	hasRequiredIsObject = 1;
  	function isObject(value) {
  	  var type = typeof value;
  	  return value != null && (type == 'object' || type == 'function');
  	}

  	isObject_1 = isObject;
  	return isObject_1;
  }

  var isFunction_1;
  var hasRequiredIsFunction;

  function requireIsFunction () {
  	if (hasRequiredIsFunction) return isFunction_1;
  	hasRequiredIsFunction = 1;
  	var baseGetTag = require_baseGetTag(),
  	    isObject = requireIsObject();

  	/** `Object#toString` result references. */
  	var asyncTag = '[object AsyncFunction]',
  	    funcTag = '[object Function]',
  	    genTag = '[object GeneratorFunction]',
  	    proxyTag = '[object Proxy]';

  	/**
  	 * Checks if `value` is classified as a `Function` object.
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 0.1.0
  	 * @category Lang
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
  	 * @example
  	 *
  	 * _.isFunction(_);
  	 * // => true
  	 *
  	 * _.isFunction(/abc/);
  	 * // => false
  	 */
  	function isFunction(value) {
  	  if (!isObject(value)) {
  	    return false;
  	  }
  	  // The use of `Object#toString` avoids issues with the `typeof` operator
  	  // in Safari 9 which returns 'object' for typed arrays and other constructors.
  	  var tag = baseGetTag(value);
  	  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
  	}

  	isFunction_1 = isFunction;
  	return isFunction_1;
  }

  var _coreJsData;
  var hasRequired_coreJsData;

  function require_coreJsData () {
  	if (hasRequired_coreJsData) return _coreJsData;
  	hasRequired_coreJsData = 1;
  	var root = require_root();

  	/** Used to detect overreaching core-js shims. */
  	var coreJsData = root['__core-js_shared__'];

  	_coreJsData = coreJsData;
  	return _coreJsData;
  }

  var _isMasked;
  var hasRequired_isMasked;

  function require_isMasked () {
  	if (hasRequired_isMasked) return _isMasked;
  	hasRequired_isMasked = 1;
  	var coreJsData = require_coreJsData();

  	/** Used to detect methods masquerading as native. */
  	var maskSrcKey = (function() {
  	  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  	  return uid ? ('Symbol(src)_1.' + uid) : '';
  	}());

  	/**
  	 * Checks if `func` has its source masked.
  	 *
  	 * @private
  	 * @param {Function} func The function to check.
  	 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
  	 */
  	function isMasked(func) {
  	  return !!maskSrcKey && (maskSrcKey in func);
  	}

  	_isMasked = isMasked;
  	return _isMasked;
  }

  /** Used for built-in method references. */

  var _toSource;
  var hasRequired_toSource;

  function require_toSource () {
  	if (hasRequired_toSource) return _toSource;
  	hasRequired_toSource = 1;
  	var funcProto = Function.prototype;

  	/** Used to resolve the decompiled source of functions. */
  	var funcToString = funcProto.toString;

  	/**
  	 * Converts `func` to its source code.
  	 *
  	 * @private
  	 * @param {Function} func The function to convert.
  	 * @returns {string} Returns the source code.
  	 */
  	function toSource(func) {
  	  if (func != null) {
  	    try {
  	      return funcToString.call(func);
  	    } catch (e) {}
  	    try {
  	      return (func + '');
  	    } catch (e) {}
  	  }
  	  return '';
  	}

  	_toSource = toSource;
  	return _toSource;
  }

  var _baseIsNative;
  var hasRequired_baseIsNative;

  function require_baseIsNative () {
  	if (hasRequired_baseIsNative) return _baseIsNative;
  	hasRequired_baseIsNative = 1;
  	var isFunction = requireIsFunction(),
  	    isMasked = require_isMasked(),
  	    isObject = requireIsObject(),
  	    toSource = require_toSource();

  	/**
  	 * Used to match `RegExp`
  	 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
  	 */
  	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

  	/** Used to detect host constructors (Safari). */
  	var reIsHostCtor = /^\[object .+?Constructor\]$/;

  	/** Used for built-in method references. */
  	var funcProto = Function.prototype,
  	    objectProto = Object.prototype;

  	/** Used to resolve the decompiled source of functions. */
  	var funcToString = funcProto.toString;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/** Used to detect if a method is native. */
  	var reIsNative = RegExp('^' +
  	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
  	);

  	/**
  	 * The base implementation of `_.isNative` without bad shim checks.
  	 *
  	 * @private
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a native function,
  	 *  else `false`.
  	 */
  	function baseIsNative(value) {
  	  if (!isObject(value) || isMasked(value)) {
  	    return false;
  	  }
  	  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  	  return pattern.test(toSource(value));
  	}

  	_baseIsNative = baseIsNative;
  	return _baseIsNative;
  }

  /**
   * Gets the value at `key` of `object`.
   *
   * @private
   * @param {Object} [object] The object to query.
   * @param {string} key The key of the property to get.
   * @returns {*} Returns the property value.
   */

  var _getValue;
  var hasRequired_getValue;

  function require_getValue () {
  	if (hasRequired_getValue) return _getValue;
  	hasRequired_getValue = 1;
  	function getValue(object, key) {
  	  return object == null ? undefined : object[key];
  	}

  	_getValue = getValue;
  	return _getValue;
  }

  var _getNative;
  var hasRequired_getNative;

  function require_getNative () {
  	if (hasRequired_getNative) return _getNative;
  	hasRequired_getNative = 1;
  	var baseIsNative = require_baseIsNative(),
  	    getValue = require_getValue();

  	/**
  	 * Gets the native function at `key` of `object`.
  	 *
  	 * @private
  	 * @param {Object} object The object to query.
  	 * @param {string} key The key of the method to get.
  	 * @returns {*} Returns the function if it's native, else `undefined`.
  	 */
  	function getNative(object, key) {
  	  var value = getValue(object, key);
  	  return baseIsNative(value) ? value : undefined;
  	}

  	_getNative = getNative;
  	return _getNative;
  }

  var _Map;
  var hasRequired_Map;

  function require_Map () {
  	if (hasRequired_Map) return _Map;
  	hasRequired_Map = 1;
  	var getNative = require_getNative(),
  	    root = require_root();

  	/* Built-in method references that are verified to be native. */
  	var Map = getNative(root, 'Map');

  	_Map = Map;
  	return _Map;
  }

  var _nativeCreate;
  var hasRequired_nativeCreate;

  function require_nativeCreate () {
  	if (hasRequired_nativeCreate) return _nativeCreate;
  	hasRequired_nativeCreate = 1;
  	var getNative = require_getNative();

  	/* Built-in method references that are verified to be native. */
  	var nativeCreate = getNative(Object, 'create');

  	_nativeCreate = nativeCreate;
  	return _nativeCreate;
  }

  var _hashClear;
  var hasRequired_hashClear;

  function require_hashClear () {
  	if (hasRequired_hashClear) return _hashClear;
  	hasRequired_hashClear = 1;
  	var nativeCreate = require_nativeCreate();

  	/**
  	 * Removes all key-value entries from the hash.
  	 *
  	 * @private
  	 * @name clear
  	 * @memberOf Hash
  	 */
  	function hashClear() {
  	  this.__data__ = nativeCreate ? nativeCreate(null) : {};
  	  this.size = 0;
  	}

  	_hashClear = hashClear;
  	return _hashClear;
  }

  /**
   * Removes `key` and its value from the hash.
   *
   * @private
   * @name delete
   * @memberOf Hash
   * @param {Object} hash The hash to modify.
   * @param {string} key The key of the value to remove.
   * @returns {boolean} Returns `true` if the entry was removed, else `false`.
   */

  var _hashDelete;
  var hasRequired_hashDelete;

  function require_hashDelete () {
  	if (hasRequired_hashDelete) return _hashDelete;
  	hasRequired_hashDelete = 1;
  	function hashDelete(key) {
  	  var result = this.has(key) && delete this.__data__[key];
  	  this.size -= result ? 1 : 0;
  	  return result;
  	}

  	_hashDelete = hashDelete;
  	return _hashDelete;
  }

  var _hashGet;
  var hasRequired_hashGet;

  function require_hashGet () {
  	if (hasRequired_hashGet) return _hashGet;
  	hasRequired_hashGet = 1;
  	var nativeCreate = require_nativeCreate();

  	/** Used to stand-in for `undefined` hash values. */
  	var HASH_UNDEFINED = '__lodash_hash_undefined__';

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * Gets the hash value for `key`.
  	 *
  	 * @private
  	 * @name get
  	 * @memberOf Hash
  	 * @param {string} key The key of the value to get.
  	 * @returns {*} Returns the entry value.
  	 */
  	function hashGet(key) {
  	  var data = this.__data__;
  	  if (nativeCreate) {
  	    var result = data[key];
  	    return result === HASH_UNDEFINED ? undefined : result;
  	  }
  	  return hasOwnProperty.call(data, key) ? data[key] : undefined;
  	}

  	_hashGet = hashGet;
  	return _hashGet;
  }

  var _hashHas;
  var hasRequired_hashHas;

  function require_hashHas () {
  	if (hasRequired_hashHas) return _hashHas;
  	hasRequired_hashHas = 1;
  	var nativeCreate = require_nativeCreate();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * Checks if a hash value for `key` exists.
  	 *
  	 * @private
  	 * @name has
  	 * @memberOf Hash
  	 * @param {string} key The key of the entry to check.
  	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  	 */
  	function hashHas(key) {
  	  var data = this.__data__;
  	  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
  	}

  	_hashHas = hashHas;
  	return _hashHas;
  }

  var _hashSet;
  var hasRequired_hashSet;

  function require_hashSet () {
  	if (hasRequired_hashSet) return _hashSet;
  	hasRequired_hashSet = 1;
  	var nativeCreate = require_nativeCreate();

  	/** Used to stand-in for `undefined` hash values. */
  	var HASH_UNDEFINED = '__lodash_hash_undefined__';

  	/**
  	 * Sets the hash `key` to `value`.
  	 *
  	 * @private
  	 * @name set
  	 * @memberOf Hash
  	 * @param {string} key The key of the value to set.
  	 * @param {*} value The value to set.
  	 * @returns {Object} Returns the hash instance.
  	 */
  	function hashSet(key, value) {
  	  var data = this.__data__;
  	  this.size += this.has(key) ? 0 : 1;
  	  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
  	  return this;
  	}

  	_hashSet = hashSet;
  	return _hashSet;
  }

  var _Hash;
  var hasRequired_Hash;

  function require_Hash () {
  	if (hasRequired_Hash) return _Hash;
  	hasRequired_Hash = 1;
  	var hashClear = require_hashClear(),
  	    hashDelete = require_hashDelete(),
  	    hashGet = require_hashGet(),
  	    hashHas = require_hashHas(),
  	    hashSet = require_hashSet();

  	/**
  	 * Creates a hash object.
  	 *
  	 * @private
  	 * @constructor
  	 * @param {Array} [entries] The key-value pairs to cache.
  	 */
  	function Hash(entries) {
  	  var index = -1,
  	      length = entries == null ? 0 : entries.length;

  	  this.clear();
  	  while (++index < length) {
  	    var entry = entries[index];
  	    this.set(entry[0], entry[1]);
  	  }
  	}

  	// Add methods to `Hash`.
  	Hash.prototype.clear = hashClear;
  	Hash.prototype['delete'] = hashDelete;
  	Hash.prototype.get = hashGet;
  	Hash.prototype.has = hashHas;
  	Hash.prototype.set = hashSet;

  	_Hash = Hash;
  	return _Hash;
  }

  var _mapCacheClear;
  var hasRequired_mapCacheClear;

  function require_mapCacheClear () {
  	if (hasRequired_mapCacheClear) return _mapCacheClear;
  	hasRequired_mapCacheClear = 1;
  	var Hash = require_Hash(),
  	    ListCache = require_ListCache(),
  	    Map = require_Map();

  	/**
  	 * Removes all key-value entries from the map.
  	 *
  	 * @private
  	 * @name clear
  	 * @memberOf MapCache
  	 */
  	function mapCacheClear() {
  	  this.size = 0;
  	  this.__data__ = {
  	    'hash': new Hash,
  	    'map': new (Map || ListCache),
  	    'string': new Hash
  	  };
  	}

  	_mapCacheClear = mapCacheClear;
  	return _mapCacheClear;
  }

  /**
   * Checks if `value` is suitable for use as unique object key.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
   */

  var _isKeyable;
  var hasRequired_isKeyable;

  function require_isKeyable () {
  	if (hasRequired_isKeyable) return _isKeyable;
  	hasRequired_isKeyable = 1;
  	function isKeyable(value) {
  	  var type = typeof value;
  	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
  	    ? (value !== '__proto__')
  	    : (value === null);
  	}

  	_isKeyable = isKeyable;
  	return _isKeyable;
  }

  var _getMapData;
  var hasRequired_getMapData;

  function require_getMapData () {
  	if (hasRequired_getMapData) return _getMapData;
  	hasRequired_getMapData = 1;
  	var isKeyable = require_isKeyable();

  	/**
  	 * Gets the data for `map`.
  	 *
  	 * @private
  	 * @param {Object} map The map to query.
  	 * @param {string} key The reference key.
  	 * @returns {*} Returns the map data.
  	 */
  	function getMapData(map, key) {
  	  var data = map.__data__;
  	  return isKeyable(key)
  	    ? data[typeof key == 'string' ? 'string' : 'hash']
  	    : data.map;
  	}

  	_getMapData = getMapData;
  	return _getMapData;
  }

  var _mapCacheDelete;
  var hasRequired_mapCacheDelete;

  function require_mapCacheDelete () {
  	if (hasRequired_mapCacheDelete) return _mapCacheDelete;
  	hasRequired_mapCacheDelete = 1;
  	var getMapData = require_getMapData();

  	/**
  	 * Removes `key` and its value from the map.
  	 *
  	 * @private
  	 * @name delete
  	 * @memberOf MapCache
  	 * @param {string} key The key of the value to remove.
  	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  	 */
  	function mapCacheDelete(key) {
  	  var result = getMapData(this, key)['delete'](key);
  	  this.size -= result ? 1 : 0;
  	  return result;
  	}

  	_mapCacheDelete = mapCacheDelete;
  	return _mapCacheDelete;
  }

  var _mapCacheGet;
  var hasRequired_mapCacheGet;

  function require_mapCacheGet () {
  	if (hasRequired_mapCacheGet) return _mapCacheGet;
  	hasRequired_mapCacheGet = 1;
  	var getMapData = require_getMapData();

  	/**
  	 * Gets the map value for `key`.
  	 *
  	 * @private
  	 * @name get
  	 * @memberOf MapCache
  	 * @param {string} key The key of the value to get.
  	 * @returns {*} Returns the entry value.
  	 */
  	function mapCacheGet(key) {
  	  return getMapData(this, key).get(key);
  	}

  	_mapCacheGet = mapCacheGet;
  	return _mapCacheGet;
  }

  var _mapCacheHas;
  var hasRequired_mapCacheHas;

  function require_mapCacheHas () {
  	if (hasRequired_mapCacheHas) return _mapCacheHas;
  	hasRequired_mapCacheHas = 1;
  	var getMapData = require_getMapData();

  	/**
  	 * Checks if a map value for `key` exists.
  	 *
  	 * @private
  	 * @name has
  	 * @memberOf MapCache
  	 * @param {string} key The key of the entry to check.
  	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  	 */
  	function mapCacheHas(key) {
  	  return getMapData(this, key).has(key);
  	}

  	_mapCacheHas = mapCacheHas;
  	return _mapCacheHas;
  }

  var _mapCacheSet;
  var hasRequired_mapCacheSet;

  function require_mapCacheSet () {
  	if (hasRequired_mapCacheSet) return _mapCacheSet;
  	hasRequired_mapCacheSet = 1;
  	var getMapData = require_getMapData();

  	/**
  	 * Sets the map `key` to `value`.
  	 *
  	 * @private
  	 * @name set
  	 * @memberOf MapCache
  	 * @param {string} key The key of the value to set.
  	 * @param {*} value The value to set.
  	 * @returns {Object} Returns the map cache instance.
  	 */
  	function mapCacheSet(key, value) {
  	  var data = getMapData(this, key),
  	      size = data.size;

  	  data.set(key, value);
  	  this.size += data.size == size ? 0 : 1;
  	  return this;
  	}

  	_mapCacheSet = mapCacheSet;
  	return _mapCacheSet;
  }

  var _MapCache;
  var hasRequired_MapCache;

  function require_MapCache () {
  	if (hasRequired_MapCache) return _MapCache;
  	hasRequired_MapCache = 1;
  	var mapCacheClear = require_mapCacheClear(),
  	    mapCacheDelete = require_mapCacheDelete(),
  	    mapCacheGet = require_mapCacheGet(),
  	    mapCacheHas = require_mapCacheHas(),
  	    mapCacheSet = require_mapCacheSet();

  	/**
  	 * Creates a map cache object to store key-value pairs.
  	 *
  	 * @private
  	 * @constructor
  	 * @param {Array} [entries] The key-value pairs to cache.
  	 */
  	function MapCache(entries) {
  	  var index = -1,
  	      length = entries == null ? 0 : entries.length;

  	  this.clear();
  	  while (++index < length) {
  	    var entry = entries[index];
  	    this.set(entry[0], entry[1]);
  	  }
  	}

  	// Add methods to `MapCache`.
  	MapCache.prototype.clear = mapCacheClear;
  	MapCache.prototype['delete'] = mapCacheDelete;
  	MapCache.prototype.get = mapCacheGet;
  	MapCache.prototype.has = mapCacheHas;
  	MapCache.prototype.set = mapCacheSet;

  	_MapCache = MapCache;
  	return _MapCache;
  }

  var _stackSet;
  var hasRequired_stackSet;

  function require_stackSet () {
  	if (hasRequired_stackSet) return _stackSet;
  	hasRequired_stackSet = 1;
  	var ListCache = require_ListCache(),
  	    Map = require_Map(),
  	    MapCache = require_MapCache();

  	/** Used as the size to enable large array optimizations. */
  	var LARGE_ARRAY_SIZE = 200;

  	/**
  	 * Sets the stack `key` to `value`.
  	 *
  	 * @private
  	 * @name set
  	 * @memberOf Stack
  	 * @param {string} key The key of the value to set.
  	 * @param {*} value The value to set.
  	 * @returns {Object} Returns the stack cache instance.
  	 */
  	function stackSet(key, value) {
  	  var data = this.__data__;
  	  if (data instanceof ListCache) {
  	    var pairs = data.__data__;
  	    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
  	      pairs.push([key, value]);
  	      this.size = ++data.size;
  	      return this;
  	    }
  	    data = this.__data__ = new MapCache(pairs);
  	  }
  	  data.set(key, value);
  	  this.size = data.size;
  	  return this;
  	}

  	_stackSet = stackSet;
  	return _stackSet;
  }

  var _Stack;
  var hasRequired_Stack;

  function require_Stack () {
  	if (hasRequired_Stack) return _Stack;
  	hasRequired_Stack = 1;
  	var ListCache = require_ListCache(),
  	    stackClear = require_stackClear(),
  	    stackDelete = require_stackDelete(),
  	    stackGet = require_stackGet(),
  	    stackHas = require_stackHas(),
  	    stackSet = require_stackSet();

  	/**
  	 * Creates a stack cache object to store key-value pairs.
  	 *
  	 * @private
  	 * @constructor
  	 * @param {Array} [entries] The key-value pairs to cache.
  	 */
  	function Stack(entries) {
  	  var data = this.__data__ = new ListCache(entries);
  	  this.size = data.size;
  	}

  	// Add methods to `Stack`.
  	Stack.prototype.clear = stackClear;
  	Stack.prototype['delete'] = stackDelete;
  	Stack.prototype.get = stackGet;
  	Stack.prototype.has = stackHas;
  	Stack.prototype.set = stackSet;

  	_Stack = Stack;
  	return _Stack;
  }

  /** Used to stand-in for `undefined` hash values. */

  var _setCacheAdd;
  var hasRequired_setCacheAdd;

  function require_setCacheAdd () {
  	if (hasRequired_setCacheAdd) return _setCacheAdd;
  	hasRequired_setCacheAdd = 1;
  	var HASH_UNDEFINED = '__lodash_hash_undefined__';

  	/**
  	 * Adds `value` to the array cache.
  	 *
  	 * @private
  	 * @name add
  	 * @memberOf SetCache
  	 * @alias push
  	 * @param {*} value The value to cache.
  	 * @returns {Object} Returns the cache instance.
  	 */
  	function setCacheAdd(value) {
  	  this.__data__.set(value, HASH_UNDEFINED);
  	  return this;
  	}

  	_setCacheAdd = setCacheAdd;
  	return _setCacheAdd;
  }

  /**
   * Checks if `value` is in the array cache.
   *
   * @private
   * @name has
   * @memberOf SetCache
   * @param {*} value The value to search for.
   * @returns {number} Returns `true` if `value` is found, else `false`.
   */

  var _setCacheHas;
  var hasRequired_setCacheHas;

  function require_setCacheHas () {
  	if (hasRequired_setCacheHas) return _setCacheHas;
  	hasRequired_setCacheHas = 1;
  	function setCacheHas(value) {
  	  return this.__data__.has(value);
  	}

  	_setCacheHas = setCacheHas;
  	return _setCacheHas;
  }

  var _SetCache;
  var hasRequired_SetCache;

  function require_SetCache () {
  	if (hasRequired_SetCache) return _SetCache;
  	hasRequired_SetCache = 1;
  	var MapCache = require_MapCache(),
  	    setCacheAdd = require_setCacheAdd(),
  	    setCacheHas = require_setCacheHas();

  	/**
  	 *
  	 * Creates an array cache object to store unique values.
  	 *
  	 * @private
  	 * @constructor
  	 * @param {Array} [values] The values to cache.
  	 */
  	function SetCache(values) {
  	  var index = -1,
  	      length = values == null ? 0 : values.length;

  	  this.__data__ = new MapCache;
  	  while (++index < length) {
  	    this.add(values[index]);
  	  }
  	}

  	// Add methods to `SetCache`.
  	SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  	SetCache.prototype.has = setCacheHas;

  	_SetCache = SetCache;
  	return _SetCache;
  }

  /**
   * A specialized version of `_.some` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {boolean} Returns `true` if any element passes the predicate check,
   *  else `false`.
   */

  var _arraySome;
  var hasRequired_arraySome;

  function require_arraySome () {
  	if (hasRequired_arraySome) return _arraySome;
  	hasRequired_arraySome = 1;
  	function arraySome(array, predicate) {
  	  var index = -1,
  	      length = array == null ? 0 : array.length;

  	  while (++index < length) {
  	    if (predicate(array[index], index, array)) {
  	      return true;
  	    }
  	  }
  	  return false;
  	}

  	_arraySome = arraySome;
  	return _arraySome;
  }

  /**
   * Checks if a `cache` value for `key` exists.
   *
   * @private
   * @param {Object} cache The cache to query.
   * @param {string} key The key of the entry to check.
   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
   */

  var _cacheHas;
  var hasRequired_cacheHas;

  function require_cacheHas () {
  	if (hasRequired_cacheHas) return _cacheHas;
  	hasRequired_cacheHas = 1;
  	function cacheHas(cache, key) {
  	  return cache.has(key);
  	}

  	_cacheHas = cacheHas;
  	return _cacheHas;
  }

  var _equalArrays;
  var hasRequired_equalArrays;

  function require_equalArrays () {
  	if (hasRequired_equalArrays) return _equalArrays;
  	hasRequired_equalArrays = 1;
  	var SetCache = require_SetCache(),
  	    arraySome = require_arraySome(),
  	    cacheHas = require_cacheHas();

  	/** Used to compose bitmasks for value comparisons. */
  	var COMPARE_PARTIAL_FLAG = 1,
  	    COMPARE_UNORDERED_FLAG = 2;

  	/**
  	 * A specialized version of `baseIsEqualDeep` for arrays with support for
  	 * partial deep comparisons.
  	 *
  	 * @private
  	 * @param {Array} array The array to compare.
  	 * @param {Array} other The other array to compare.
  	 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  	 * @param {Function} customizer The function to customize comparisons.
  	 * @param {Function} equalFunc The function to determine equivalents of values.
  	 * @param {Object} stack Tracks traversed `array` and `other` objects.
  	 * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
  	 */
  	function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  	  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
  	      arrLength = array.length,
  	      othLength = other.length;

  	  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
  	    return false;
  	  }
  	  // Check that cyclic values are equal.
  	  var arrStacked = stack.get(array);
  	  var othStacked = stack.get(other);
  	  if (arrStacked && othStacked) {
  	    return arrStacked == other && othStacked == array;
  	  }
  	  var index = -1,
  	      result = true,
  	      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;

  	  stack.set(array, other);
  	  stack.set(other, array);

  	  // Ignore non-index properties.
  	  while (++index < arrLength) {
  	    var arrValue = array[index],
  	        othValue = other[index];

  	    if (customizer) {
  	      var compared = isPartial
  	        ? customizer(othValue, arrValue, index, other, array, stack)
  	        : customizer(arrValue, othValue, index, array, other, stack);
  	    }
  	    if (compared !== undefined) {
  	      if (compared) {
  	        continue;
  	      }
  	      result = false;
  	      break;
  	    }
  	    // Recursively compare arrays (susceptible to call stack limits).
  	    if (seen) {
  	      if (!arraySome(other, function(othValue, othIndex) {
  	            if (!cacheHas(seen, othIndex) &&
  	                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
  	              return seen.push(othIndex);
  	            }
  	          })) {
  	        result = false;
  	        break;
  	      }
  	    } else if (!(
  	          arrValue === othValue ||
  	            equalFunc(arrValue, othValue, bitmask, customizer, stack)
  	        )) {
  	      result = false;
  	      break;
  	    }
  	  }
  	  stack['delete'](array);
  	  stack['delete'](other);
  	  return result;
  	}

  	_equalArrays = equalArrays;
  	return _equalArrays;
  }

  var _Uint8Array;
  var hasRequired_Uint8Array;

  function require_Uint8Array () {
  	if (hasRequired_Uint8Array) return _Uint8Array;
  	hasRequired_Uint8Array = 1;
  	var root = require_root();

  	/** Built-in value references. */
  	var Uint8Array = root.Uint8Array;

  	_Uint8Array = Uint8Array;
  	return _Uint8Array;
  }

  /**
   * Converts `map` to its key-value pairs.
   *
   * @private
   * @param {Object} map The map to convert.
   * @returns {Array} Returns the key-value pairs.
   */

  var _mapToArray;
  var hasRequired_mapToArray;

  function require_mapToArray () {
  	if (hasRequired_mapToArray) return _mapToArray;
  	hasRequired_mapToArray = 1;
  	function mapToArray(map) {
  	  var index = -1,
  	      result = Array(map.size);

  	  map.forEach(function(value, key) {
  	    result[++index] = [key, value];
  	  });
  	  return result;
  	}

  	_mapToArray = mapToArray;
  	return _mapToArray;
  }

  /**
   * Converts `set` to an array of its values.
   *
   * @private
   * @param {Object} set The set to convert.
   * @returns {Array} Returns the values.
   */

  var _setToArray;
  var hasRequired_setToArray;

  function require_setToArray () {
  	if (hasRequired_setToArray) return _setToArray;
  	hasRequired_setToArray = 1;
  	function setToArray(set) {
  	  var index = -1,
  	      result = Array(set.size);

  	  set.forEach(function(value) {
  	    result[++index] = value;
  	  });
  	  return result;
  	}

  	_setToArray = setToArray;
  	return _setToArray;
  }

  var _equalByTag;
  var hasRequired_equalByTag;

  function require_equalByTag () {
  	if (hasRequired_equalByTag) return _equalByTag;
  	hasRequired_equalByTag = 1;
  	var Symbol = require_Symbol(),
  	    Uint8Array = require_Uint8Array(),
  	    eq = requireEq(),
  	    equalArrays = require_equalArrays(),
  	    mapToArray = require_mapToArray(),
  	    setToArray = require_setToArray();

  	/** Used to compose bitmasks for value comparisons. */
  	var COMPARE_PARTIAL_FLAG = 1,
  	    COMPARE_UNORDERED_FLAG = 2;

  	/** `Object#toString` result references. */
  	var boolTag = '[object Boolean]',
  	    dateTag = '[object Date]',
  	    errorTag = '[object Error]',
  	    mapTag = '[object Map]',
  	    numberTag = '[object Number]',
  	    regexpTag = '[object RegExp]',
  	    setTag = '[object Set]',
  	    stringTag = '[object String]',
  	    symbolTag = '[object Symbol]';

  	var arrayBufferTag = '[object ArrayBuffer]',
  	    dataViewTag = '[object DataView]';

  	/** Used to convert symbols to primitives and strings. */
  	var symbolProto = Symbol ? Symbol.prototype : undefined,
  	    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

  	/**
  	 * A specialized version of `baseIsEqualDeep` for comparing objects of
  	 * the same `toStringTag`.
  	 *
  	 * **Note:** This function only supports comparing values with tags of
  	 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
  	 *
  	 * @private
  	 * @param {Object} object The object to compare.
  	 * @param {Object} other The other object to compare.
  	 * @param {string} tag The `toStringTag` of the objects to compare.
  	 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  	 * @param {Function} customizer The function to customize comparisons.
  	 * @param {Function} equalFunc The function to determine equivalents of values.
  	 * @param {Object} stack Tracks traversed `object` and `other` objects.
  	 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  	 */
  	function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  	  switch (tag) {
  	    case dataViewTag:
  	      if ((object.byteLength != other.byteLength) ||
  	          (object.byteOffset != other.byteOffset)) {
  	        return false;
  	      }
  	      object = object.buffer;
  	      other = other.buffer;

  	    case arrayBufferTag:
  	      if ((object.byteLength != other.byteLength) ||
  	          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
  	        return false;
  	      }
  	      return true;

  	    case boolTag:
  	    case dateTag:
  	    case numberTag:
  	      // Coerce booleans to `1` or `0` and dates to milliseconds.
  	      // Invalid dates are coerced to `NaN`.
  	      return eq(+object, +other);

  	    case errorTag:
  	      return object.name == other.name && object.message == other.message;

  	    case regexpTag:
  	    case stringTag:
  	      // Coerce regexes to strings and treat strings, primitives and objects,
  	      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
  	      // for more details.
  	      return object == (other + '');

  	    case mapTag:
  	      var convert = mapToArray;

  	    case setTag:
  	      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
  	      convert || (convert = setToArray);

  	      if (object.size != other.size && !isPartial) {
  	        return false;
  	      }
  	      // Assume cyclic values are equal.
  	      var stacked = stack.get(object);
  	      if (stacked) {
  	        return stacked == other;
  	      }
  	      bitmask |= COMPARE_UNORDERED_FLAG;

  	      // Recursively compare objects (susceptible to call stack limits).
  	      stack.set(object, other);
  	      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
  	      stack['delete'](object);
  	      return result;

  	    case symbolTag:
  	      if (symbolValueOf) {
  	        return symbolValueOf.call(object) == symbolValueOf.call(other);
  	      }
  	  }
  	  return false;
  	}

  	_equalByTag = equalByTag;
  	return _equalByTag;
  }

  /**
   * Appends the elements of `values` to `array`.
   *
   * @private
   * @param {Array} array The array to modify.
   * @param {Array} values The values to append.
   * @returns {Array} Returns `array`.
   */

  var _arrayPush;
  var hasRequired_arrayPush;

  function require_arrayPush () {
  	if (hasRequired_arrayPush) return _arrayPush;
  	hasRequired_arrayPush = 1;
  	function arrayPush(array, values) {
  	  var index = -1,
  	      length = values.length,
  	      offset = array.length;

  	  while (++index < length) {
  	    array[offset + index] = values[index];
  	  }
  	  return array;
  	}

  	_arrayPush = arrayPush;
  	return _arrayPush;
  }

  /**
   * Checks if `value` is classified as an `Array` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array, else `false`.
   * @example
   *
   * _.isArray([1, 2, 3]);
   * // => true
   *
   * _.isArray(document.body.children);
   * // => false
   *
   * _.isArray('abc');
   * // => false
   *
   * _.isArray(_.noop);
   * // => false
   */

  var isArray_1;
  var hasRequiredIsArray;

  function requireIsArray () {
  	if (hasRequiredIsArray) return isArray_1;
  	hasRequiredIsArray = 1;
  	var isArray = Array.isArray;

  	isArray_1 = isArray;
  	return isArray_1;
  }

  var _baseGetAllKeys;
  var hasRequired_baseGetAllKeys;

  function require_baseGetAllKeys () {
  	if (hasRequired_baseGetAllKeys) return _baseGetAllKeys;
  	hasRequired_baseGetAllKeys = 1;
  	var arrayPush = require_arrayPush(),
  	    isArray = requireIsArray();

  	/**
  	 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
  	 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
  	 * symbols of `object`.
  	 *
  	 * @private
  	 * @param {Object} object The object to query.
  	 * @param {Function} keysFunc The function to get the keys of `object`.
  	 * @param {Function} symbolsFunc The function to get the symbols of `object`.
  	 * @returns {Array} Returns the array of property names and symbols.
  	 */
  	function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  	  var result = keysFunc(object);
  	  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
  	}

  	_baseGetAllKeys = baseGetAllKeys;
  	return _baseGetAllKeys;
  }

  /**
   * A specialized version of `_.filter` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} predicate The function invoked per iteration.
   * @returns {Array} Returns the new filtered array.
   */

  var _arrayFilter;
  var hasRequired_arrayFilter;

  function require_arrayFilter () {
  	if (hasRequired_arrayFilter) return _arrayFilter;
  	hasRequired_arrayFilter = 1;
  	function arrayFilter(array, predicate) {
  	  var index = -1,
  	      length = array == null ? 0 : array.length,
  	      resIndex = 0,
  	      result = [];

  	  while (++index < length) {
  	    var value = array[index];
  	    if (predicate(value, index, array)) {
  	      result[resIndex++] = value;
  	    }
  	  }
  	  return result;
  	}

  	_arrayFilter = arrayFilter;
  	return _arrayFilter;
  }

  /**
   * This method returns a new empty array.
   *
   * @static
   * @memberOf _
   * @since 4.13.0
   * @category Util
   * @returns {Array} Returns the new empty array.
   * @example
   *
   * var arrays = _.times(2, _.stubArray);
   *
   * console.log(arrays);
   * // => [[], []]
   *
   * console.log(arrays[0] === arrays[1]);
   * // => false
   */

  var stubArray_1;
  var hasRequiredStubArray;

  function requireStubArray () {
  	if (hasRequiredStubArray) return stubArray_1;
  	hasRequiredStubArray = 1;
  	function stubArray() {
  	  return [];
  	}

  	stubArray_1 = stubArray;
  	return stubArray_1;
  }

  var _getSymbols;
  var hasRequired_getSymbols;

  function require_getSymbols () {
  	if (hasRequired_getSymbols) return _getSymbols;
  	hasRequired_getSymbols = 1;
  	var arrayFilter = require_arrayFilter(),
  	    stubArray = requireStubArray();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Built-in value references. */
  	var propertyIsEnumerable = objectProto.propertyIsEnumerable;

  	/* Built-in method references for those with the same name as other `lodash` methods. */
  	var nativeGetSymbols = Object.getOwnPropertySymbols;

  	/**
  	 * Creates an array of the own enumerable symbols of `object`.
  	 *
  	 * @private
  	 * @param {Object} object The object to query.
  	 * @returns {Array} Returns the array of symbols.
  	 */
  	var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  	  if (object == null) {
  	    return [];
  	  }
  	  object = Object(object);
  	  return arrayFilter(nativeGetSymbols(object), function(symbol) {
  	    return propertyIsEnumerable.call(object, symbol);
  	  });
  	};

  	_getSymbols = getSymbols;
  	return _getSymbols;
  }

  /**
   * The base implementation of `_.times` without support for iteratee shorthands
   * or max array length checks.
   *
   * @private
   * @param {number} n The number of times to invoke `iteratee`.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the array of results.
   */

  var _baseTimes;
  var hasRequired_baseTimes;

  function require_baseTimes () {
  	if (hasRequired_baseTimes) return _baseTimes;
  	hasRequired_baseTimes = 1;
  	function baseTimes(n, iteratee) {
  	  var index = -1,
  	      result = Array(n);

  	  while (++index < n) {
  	    result[index] = iteratee(index);
  	  }
  	  return result;
  	}

  	_baseTimes = baseTimes;
  	return _baseTimes;
  }

  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */

  var isObjectLike_1;
  var hasRequiredIsObjectLike;

  function requireIsObjectLike () {
  	if (hasRequiredIsObjectLike) return isObjectLike_1;
  	hasRequiredIsObjectLike = 1;
  	function isObjectLike(value) {
  	  return value != null && typeof value == 'object';
  	}

  	isObjectLike_1 = isObjectLike;
  	return isObjectLike_1;
  }

  var _baseIsArguments;
  var hasRequired_baseIsArguments;

  function require_baseIsArguments () {
  	if (hasRequired_baseIsArguments) return _baseIsArguments;
  	hasRequired_baseIsArguments = 1;
  	var baseGetTag = require_baseGetTag(),
  	    isObjectLike = requireIsObjectLike();

  	/** `Object#toString` result references. */
  	var argsTag = '[object Arguments]';

  	/**
  	 * The base implementation of `_.isArguments`.
  	 *
  	 * @private
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
  	 */
  	function baseIsArguments(value) {
  	  return isObjectLike(value) && baseGetTag(value) == argsTag;
  	}

  	_baseIsArguments = baseIsArguments;
  	return _baseIsArguments;
  }

  var isArguments_1;
  var hasRequiredIsArguments;

  function requireIsArguments () {
  	if (hasRequiredIsArguments) return isArguments_1;
  	hasRequiredIsArguments = 1;
  	var baseIsArguments = require_baseIsArguments(),
  	    isObjectLike = requireIsObjectLike();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/** Built-in value references. */
  	var propertyIsEnumerable = objectProto.propertyIsEnumerable;

  	/**
  	 * Checks if `value` is likely an `arguments` object.
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 0.1.0
  	 * @category Lang
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
  	 *  else `false`.
  	 * @example
  	 *
  	 * _.isArguments(function() { return arguments; }());
  	 * // => true
  	 *
  	 * _.isArguments([1, 2, 3]);
  	 * // => false
  	 */
  	var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
  	  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
  	    !propertyIsEnumerable.call(value, 'callee');
  	};

  	isArguments_1 = isArguments;
  	return isArguments_1;
  }

  var isBuffer = {exports: {}};

  /**
   * This method returns `false`.
   *
   * @static
   * @memberOf _
   * @since 4.13.0
   * @category Util
   * @returns {boolean} Returns `false`.
   * @example
   *
   * _.times(2, _.stubFalse);
   * // => [false, false]
   */

  var stubFalse_1;
  var hasRequiredStubFalse;

  function requireStubFalse () {
  	if (hasRequiredStubFalse) return stubFalse_1;
  	hasRequiredStubFalse = 1;
  	function stubFalse() {
  	  return false;
  	}

  	stubFalse_1 = stubFalse;
  	return stubFalse_1;
  }

  isBuffer.exports;

  var hasRequiredIsBuffer;

  function requireIsBuffer () {
  	if (hasRequiredIsBuffer) return isBuffer.exports;
  	hasRequiredIsBuffer = 1;
  	(function (module, exports) {
  		var root = require_root(),
  		    stubFalse = requireStubFalse();

  		/** Detect free variable `exports`. */
  		var freeExports = exports && !exports.nodeType && exports;

  		/** Detect free variable `module`. */
  		var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

  		/** Detect the popular CommonJS extension `module.exports`. */
  		var moduleExports = freeModule && freeModule.exports === freeExports;

  		/** Built-in value references. */
  		var Buffer = moduleExports ? root.Buffer : undefined;

  		/* Built-in method references for those with the same name as other `lodash` methods. */
  		var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;

  		/**
  		 * Checks if `value` is a buffer.
  		 *
  		 * @static
  		 * @memberOf _
  		 * @since 4.3.0
  		 * @category Lang
  		 * @param {*} value The value to check.
  		 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
  		 * @example
  		 *
  		 * _.isBuffer(new Buffer(2));
  		 * // => true
  		 *
  		 * _.isBuffer(new Uint8Array(2));
  		 * // => false
  		 */
  		var isBuffer = nativeIsBuffer || stubFalse;

  		module.exports = isBuffer; 
  	} (isBuffer, isBuffer.exports));
  	return isBuffer.exports;
  }

  /** Used as references for various `Number` constants. */

  var _isIndex;
  var hasRequired_isIndex;

  function require_isIndex () {
  	if (hasRequired_isIndex) return _isIndex;
  	hasRequired_isIndex = 1;
  	var MAX_SAFE_INTEGER = 9007199254740991;

  	/** Used to detect unsigned integer values. */
  	var reIsUint = /^(?:0|[1-9]\d*)$/;

  	/**
  	 * Checks if `value` is a valid array-like index.
  	 *
  	 * @private
  	 * @param {*} value The value to check.
  	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
  	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
  	 */
  	function isIndex(value, length) {
  	  var type = typeof value;
  	  length = length == null ? MAX_SAFE_INTEGER : length;

  	  return !!length &&
  	    (type == 'number' ||
  	      (type != 'symbol' && reIsUint.test(value))) &&
  	        (value > -1 && value % 1 == 0 && value < length);
  	}

  	_isIndex = isIndex;
  	return _isIndex;
  }

  /** Used as references for various `Number` constants. */

  var isLength_1;
  var hasRequiredIsLength;

  function requireIsLength () {
  	if (hasRequiredIsLength) return isLength_1;
  	hasRequiredIsLength = 1;
  	var MAX_SAFE_INTEGER = 9007199254740991;

  	/**
  	 * Checks if `value` is a valid array-like length.
  	 *
  	 * **Note:** This method is loosely based on
  	 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 4.0.0
  	 * @category Lang
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
  	 * @example
  	 *
  	 * _.isLength(3);
  	 * // => true
  	 *
  	 * _.isLength(Number.MIN_VALUE);
  	 * // => false
  	 *
  	 * _.isLength(Infinity);
  	 * // => false
  	 *
  	 * _.isLength('3');
  	 * // => false
  	 */
  	function isLength(value) {
  	  return typeof value == 'number' &&
  	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  	}

  	isLength_1 = isLength;
  	return isLength_1;
  }

  var _baseIsTypedArray;
  var hasRequired_baseIsTypedArray;

  function require_baseIsTypedArray () {
  	if (hasRequired_baseIsTypedArray) return _baseIsTypedArray;
  	hasRequired_baseIsTypedArray = 1;
  	var baseGetTag = require_baseGetTag(),
  	    isLength = requireIsLength(),
  	    isObjectLike = requireIsObjectLike();

  	/** `Object#toString` result references. */
  	var argsTag = '[object Arguments]',
  	    arrayTag = '[object Array]',
  	    boolTag = '[object Boolean]',
  	    dateTag = '[object Date]',
  	    errorTag = '[object Error]',
  	    funcTag = '[object Function]',
  	    mapTag = '[object Map]',
  	    numberTag = '[object Number]',
  	    objectTag = '[object Object]',
  	    regexpTag = '[object RegExp]',
  	    setTag = '[object Set]',
  	    stringTag = '[object String]',
  	    weakMapTag = '[object WeakMap]';

  	var arrayBufferTag = '[object ArrayBuffer]',
  	    dataViewTag = '[object DataView]',
  	    float32Tag = '[object Float32Array]',
  	    float64Tag = '[object Float64Array]',
  	    int8Tag = '[object Int8Array]',
  	    int16Tag = '[object Int16Array]',
  	    int32Tag = '[object Int32Array]',
  	    uint8Tag = '[object Uint8Array]',
  	    uint8ClampedTag = '[object Uint8ClampedArray]',
  	    uint16Tag = '[object Uint16Array]',
  	    uint32Tag = '[object Uint32Array]';

  	/** Used to identify `toStringTag` values of typed arrays. */
  	var typedArrayTags = {};
  	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
  	typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
  	typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
  	typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
  	typedArrayTags[uint32Tag] = true;
  	typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
  	typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
  	typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
  	typedArrayTags[errorTag] = typedArrayTags[funcTag] =
  	typedArrayTags[mapTag] = typedArrayTags[numberTag] =
  	typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
  	typedArrayTags[setTag] = typedArrayTags[stringTag] =
  	typedArrayTags[weakMapTag] = false;

  	/**
  	 * The base implementation of `_.isTypedArray` without Node.js optimizations.
  	 *
  	 * @private
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
  	 */
  	function baseIsTypedArray(value) {
  	  return isObjectLike(value) &&
  	    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
  	}

  	_baseIsTypedArray = baseIsTypedArray;
  	return _baseIsTypedArray;
  }

  /**
   * The base implementation of `_.unary` without support for storing metadata.
   *
   * @private
   * @param {Function} func The function to cap arguments for.
   * @returns {Function} Returns the new capped function.
   */

  var _baseUnary;
  var hasRequired_baseUnary;

  function require_baseUnary () {
  	if (hasRequired_baseUnary) return _baseUnary;
  	hasRequired_baseUnary = 1;
  	function baseUnary(func) {
  	  return function(value) {
  	    return func(value);
  	  };
  	}

  	_baseUnary = baseUnary;
  	return _baseUnary;
  }

  var _nodeUtil = {exports: {}};

  _nodeUtil.exports;

  var hasRequired_nodeUtil;

  function require_nodeUtil () {
  	if (hasRequired_nodeUtil) return _nodeUtil.exports;
  	hasRequired_nodeUtil = 1;
  	(function (module, exports) {
  		var freeGlobal = require_freeGlobal();

  		/** Detect free variable `exports`. */
  		var freeExports = exports && !exports.nodeType && exports;

  		/** Detect free variable `module`. */
  		var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

  		/** Detect the popular CommonJS extension `module.exports`. */
  		var moduleExports = freeModule && freeModule.exports === freeExports;

  		/** Detect free variable `process` from Node.js. */
  		var freeProcess = moduleExports && freeGlobal.process;

  		/** Used to access faster Node.js helpers. */
  		var nodeUtil = (function() {
  		  try {
  		    // Use `util.types` for Node.js 10+.
  		    var types = freeModule && freeModule.require && freeModule.require('util').types;

  		    if (types) {
  		      return types;
  		    }

  		    // Legacy `process.binding('util')` for Node.js < 10.
  		    return freeProcess && freeProcess.binding && freeProcess.binding('util');
  		  } catch (e) {}
  		}());

  		module.exports = nodeUtil; 
  	} (_nodeUtil, _nodeUtil.exports));
  	return _nodeUtil.exports;
  }

  var isTypedArray_1;
  var hasRequiredIsTypedArray;

  function requireIsTypedArray () {
  	if (hasRequiredIsTypedArray) return isTypedArray_1;
  	hasRequiredIsTypedArray = 1;
  	var baseIsTypedArray = require_baseIsTypedArray(),
  	    baseUnary = require_baseUnary(),
  	    nodeUtil = require_nodeUtil();

  	/* Node.js helper references. */
  	var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

  	/**
  	 * Checks if `value` is classified as a typed array.
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 3.0.0
  	 * @category Lang
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
  	 * @example
  	 *
  	 * _.isTypedArray(new Uint8Array);
  	 * // => true
  	 *
  	 * _.isTypedArray([]);
  	 * // => false
  	 */
  	var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

  	isTypedArray_1 = isTypedArray;
  	return isTypedArray_1;
  }

  var _arrayLikeKeys;
  var hasRequired_arrayLikeKeys;

  function require_arrayLikeKeys () {
  	if (hasRequired_arrayLikeKeys) return _arrayLikeKeys;
  	hasRequired_arrayLikeKeys = 1;
  	var baseTimes = require_baseTimes(),
  	    isArguments = requireIsArguments(),
  	    isArray = requireIsArray(),
  	    isBuffer = requireIsBuffer(),
  	    isIndex = require_isIndex(),
  	    isTypedArray = requireIsTypedArray();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * Creates an array of the enumerable property names of the array-like `value`.
  	 *
  	 * @private
  	 * @param {*} value The value to query.
  	 * @param {boolean} inherited Specify returning inherited property names.
  	 * @returns {Array} Returns the array of property names.
  	 */
  	function arrayLikeKeys(value, inherited) {
  	  var isArr = isArray(value),
  	      isArg = !isArr && isArguments(value),
  	      isBuff = !isArr && !isArg && isBuffer(value),
  	      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
  	      skipIndexes = isArr || isArg || isBuff || isType,
  	      result = skipIndexes ? baseTimes(value.length, String) : [],
  	      length = result.length;

  	  for (var key in value) {
  	    if ((inherited || hasOwnProperty.call(value, key)) &&
  	        !(skipIndexes && (
  	           // Safari 9 has enumerable `arguments.length` in strict mode.
  	           key == 'length' ||
  	           // Node.js 0.10 has enumerable non-index properties on buffers.
  	           (isBuff && (key == 'offset' || key == 'parent')) ||
  	           // PhantomJS 2 has enumerable non-index properties on typed arrays.
  	           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
  	           // Skip index properties.
  	           isIndex(key, length)
  	        ))) {
  	      result.push(key);
  	    }
  	  }
  	  return result;
  	}

  	_arrayLikeKeys = arrayLikeKeys;
  	return _arrayLikeKeys;
  }

  /** Used for built-in method references. */

  var _isPrototype;
  var hasRequired_isPrototype;

  function require_isPrototype () {
  	if (hasRequired_isPrototype) return _isPrototype;
  	hasRequired_isPrototype = 1;
  	var objectProto = Object.prototype;

  	/**
  	 * Checks if `value` is likely a prototype object.
  	 *
  	 * @private
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
  	 */
  	function isPrototype(value) {
  	  var Ctor = value && value.constructor,
  	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  	  return value === proto;
  	}

  	_isPrototype = isPrototype;
  	return _isPrototype;
  }

  /**
   * Creates a unary function that invokes `func` with its argument transformed.
   *
   * @private
   * @param {Function} func The function to wrap.
   * @param {Function} transform The argument transform.
   * @returns {Function} Returns the new function.
   */

  var _overArg;
  var hasRequired_overArg;

  function require_overArg () {
  	if (hasRequired_overArg) return _overArg;
  	hasRequired_overArg = 1;
  	function overArg(func, transform) {
  	  return function(arg) {
  	    return func(transform(arg));
  	  };
  	}

  	_overArg = overArg;
  	return _overArg;
  }

  var _nativeKeys;
  var hasRequired_nativeKeys;

  function require_nativeKeys () {
  	if (hasRequired_nativeKeys) return _nativeKeys;
  	hasRequired_nativeKeys = 1;
  	var overArg = require_overArg();

  	/* Built-in method references for those with the same name as other `lodash` methods. */
  	var nativeKeys = overArg(Object.keys, Object);

  	_nativeKeys = nativeKeys;
  	return _nativeKeys;
  }

  var _baseKeys;
  var hasRequired_baseKeys;

  function require_baseKeys () {
  	if (hasRequired_baseKeys) return _baseKeys;
  	hasRequired_baseKeys = 1;
  	var isPrototype = require_isPrototype(),
  	    nativeKeys = require_nativeKeys();

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
  	 *
  	 * @private
  	 * @param {Object} object The object to query.
  	 * @returns {Array} Returns the array of property names.
  	 */
  	function baseKeys(object) {
  	  if (!isPrototype(object)) {
  	    return nativeKeys(object);
  	  }
  	  var result = [];
  	  for (var key in Object(object)) {
  	    if (hasOwnProperty.call(object, key) && key != 'constructor') {
  	      result.push(key);
  	    }
  	  }
  	  return result;
  	}

  	_baseKeys = baseKeys;
  	return _baseKeys;
  }

  var isArrayLike_1;
  var hasRequiredIsArrayLike;

  function requireIsArrayLike () {
  	if (hasRequiredIsArrayLike) return isArrayLike_1;
  	hasRequiredIsArrayLike = 1;
  	var isFunction = requireIsFunction(),
  	    isLength = requireIsLength();

  	/**
  	 * Checks if `value` is array-like. A value is considered array-like if it's
  	 * not a function and has a `value.length` that's an integer greater than or
  	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 4.0.0
  	 * @category Lang
  	 * @param {*} value The value to check.
  	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
  	 * @example
  	 *
  	 * _.isArrayLike([1, 2, 3]);
  	 * // => true
  	 *
  	 * _.isArrayLike(document.body.children);
  	 * // => true
  	 *
  	 * _.isArrayLike('abc');
  	 * // => true
  	 *
  	 * _.isArrayLike(_.noop);
  	 * // => false
  	 */
  	function isArrayLike(value) {
  	  return value != null && isLength(value.length) && !isFunction(value);
  	}

  	isArrayLike_1 = isArrayLike;
  	return isArrayLike_1;
  }

  var keys_1;
  var hasRequiredKeys;

  function requireKeys () {
  	if (hasRequiredKeys) return keys_1;
  	hasRequiredKeys = 1;
  	var arrayLikeKeys = require_arrayLikeKeys(),
  	    baseKeys = require_baseKeys(),
  	    isArrayLike = requireIsArrayLike();

  	/**
  	 * Creates an array of the own enumerable property names of `object`.
  	 *
  	 * **Note:** Non-object values are coerced to objects. See the
  	 * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
  	 * for more details.
  	 *
  	 * @static
  	 * @since 0.1.0
  	 * @memberOf _
  	 * @category Object
  	 * @param {Object} object The object to query.
  	 * @returns {Array} Returns the array of property names.
  	 * @example
  	 *
  	 * function Foo() {
  	 *   this.a = 1;
  	 *   this.b = 2;
  	 * }
  	 *
  	 * Foo.prototype.c = 3;
  	 *
  	 * _.keys(new Foo);
  	 * // => ['a', 'b'] (iteration order is not guaranteed)
  	 *
  	 * _.keys('hi');
  	 * // => ['0', '1']
  	 */
  	function keys(object) {
  	  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
  	}

  	keys_1 = keys;
  	return keys_1;
  }

  var _getAllKeys;
  var hasRequired_getAllKeys;

  function require_getAllKeys () {
  	if (hasRequired_getAllKeys) return _getAllKeys;
  	hasRequired_getAllKeys = 1;
  	var baseGetAllKeys = require_baseGetAllKeys(),
  	    getSymbols = require_getSymbols(),
  	    keys = requireKeys();

  	/**
  	 * Creates an array of own enumerable property names and symbols of `object`.
  	 *
  	 * @private
  	 * @param {Object} object The object to query.
  	 * @returns {Array} Returns the array of property names and symbols.
  	 */
  	function getAllKeys(object) {
  	  return baseGetAllKeys(object, keys, getSymbols);
  	}

  	_getAllKeys = getAllKeys;
  	return _getAllKeys;
  }

  var _equalObjects;
  var hasRequired_equalObjects;

  function require_equalObjects () {
  	if (hasRequired_equalObjects) return _equalObjects;
  	hasRequired_equalObjects = 1;
  	var getAllKeys = require_getAllKeys();

  	/** Used to compose bitmasks for value comparisons. */
  	var COMPARE_PARTIAL_FLAG = 1;

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * A specialized version of `baseIsEqualDeep` for objects with support for
  	 * partial deep comparisons.
  	 *
  	 * @private
  	 * @param {Object} object The object to compare.
  	 * @param {Object} other The other object to compare.
  	 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  	 * @param {Function} customizer The function to customize comparisons.
  	 * @param {Function} equalFunc The function to determine equivalents of values.
  	 * @param {Object} stack Tracks traversed `object` and `other` objects.
  	 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  	 */
  	function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  	  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
  	      objProps = getAllKeys(object),
  	      objLength = objProps.length,
  	      othProps = getAllKeys(other),
  	      othLength = othProps.length;

  	  if (objLength != othLength && !isPartial) {
  	    return false;
  	  }
  	  var index = objLength;
  	  while (index--) {
  	    var key = objProps[index];
  	    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
  	      return false;
  	    }
  	  }
  	  // Check that cyclic values are equal.
  	  var objStacked = stack.get(object);
  	  var othStacked = stack.get(other);
  	  if (objStacked && othStacked) {
  	    return objStacked == other && othStacked == object;
  	  }
  	  var result = true;
  	  stack.set(object, other);
  	  stack.set(other, object);

  	  var skipCtor = isPartial;
  	  while (++index < objLength) {
  	    key = objProps[index];
  	    var objValue = object[key],
  	        othValue = other[key];

  	    if (customizer) {
  	      var compared = isPartial
  	        ? customizer(othValue, objValue, key, other, object, stack)
  	        : customizer(objValue, othValue, key, object, other, stack);
  	    }
  	    // Recursively compare objects (susceptible to call stack limits).
  	    if (!(compared === undefined
  	          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
  	          : compared
  	        )) {
  	      result = false;
  	      break;
  	    }
  	    skipCtor || (skipCtor = key == 'constructor');
  	  }
  	  if (result && !skipCtor) {
  	    var objCtor = object.constructor,
  	        othCtor = other.constructor;

  	    // Non `Object` object instances with different constructors are not equal.
  	    if (objCtor != othCtor &&
  	        ('constructor' in object && 'constructor' in other) &&
  	        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
  	          typeof othCtor == 'function' && othCtor instanceof othCtor)) {
  	      result = false;
  	    }
  	  }
  	  stack['delete'](object);
  	  stack['delete'](other);
  	  return result;
  	}

  	_equalObjects = equalObjects;
  	return _equalObjects;
  }

  var _DataView;
  var hasRequired_DataView;

  function require_DataView () {
  	if (hasRequired_DataView) return _DataView;
  	hasRequired_DataView = 1;
  	var getNative = require_getNative(),
  	    root = require_root();

  	/* Built-in method references that are verified to be native. */
  	var DataView = getNative(root, 'DataView');

  	_DataView = DataView;
  	return _DataView;
  }

  var _Promise;
  var hasRequired_Promise;

  function require_Promise () {
  	if (hasRequired_Promise) return _Promise;
  	hasRequired_Promise = 1;
  	var getNative = require_getNative(),
  	    root = require_root();

  	/* Built-in method references that are verified to be native. */
  	var Promise = getNative(root, 'Promise');

  	_Promise = Promise;
  	return _Promise;
  }

  var _Set;
  var hasRequired_Set;

  function require_Set () {
  	if (hasRequired_Set) return _Set;
  	hasRequired_Set = 1;
  	var getNative = require_getNative(),
  	    root = require_root();

  	/* Built-in method references that are verified to be native. */
  	var Set = getNative(root, 'Set');

  	_Set = Set;
  	return _Set;
  }

  var _WeakMap;
  var hasRequired_WeakMap;

  function require_WeakMap () {
  	if (hasRequired_WeakMap) return _WeakMap;
  	hasRequired_WeakMap = 1;
  	var getNative = require_getNative(),
  	    root = require_root();

  	/* Built-in method references that are verified to be native. */
  	var WeakMap = getNative(root, 'WeakMap');

  	_WeakMap = WeakMap;
  	return _WeakMap;
  }

  var _getTag;
  var hasRequired_getTag;

  function require_getTag () {
  	if (hasRequired_getTag) return _getTag;
  	hasRequired_getTag = 1;
  	var DataView = require_DataView(),
  	    Map = require_Map(),
  	    Promise = require_Promise(),
  	    Set = require_Set(),
  	    WeakMap = require_WeakMap(),
  	    baseGetTag = require_baseGetTag(),
  	    toSource = require_toSource();

  	/** `Object#toString` result references. */
  	var mapTag = '[object Map]',
  	    objectTag = '[object Object]',
  	    promiseTag = '[object Promise]',
  	    setTag = '[object Set]',
  	    weakMapTag = '[object WeakMap]';

  	var dataViewTag = '[object DataView]';

  	/** Used to detect maps, sets, and weakmaps. */
  	var dataViewCtorString = toSource(DataView),
  	    mapCtorString = toSource(Map),
  	    promiseCtorString = toSource(Promise),
  	    setCtorString = toSource(Set),
  	    weakMapCtorString = toSource(WeakMap);

  	/**
  	 * Gets the `toStringTag` of `value`.
  	 *
  	 * @private
  	 * @param {*} value The value to query.
  	 * @returns {string} Returns the `toStringTag`.
  	 */
  	var getTag = baseGetTag;

  	// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
  	if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
  	    (Map && getTag(new Map) != mapTag) ||
  	    (Promise && getTag(Promise.resolve()) != promiseTag) ||
  	    (Set && getTag(new Set) != setTag) ||
  	    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  	  getTag = function(value) {
  	    var result = baseGetTag(value),
  	        Ctor = result == objectTag ? value.constructor : undefined,
  	        ctorString = Ctor ? toSource(Ctor) : '';

  	    if (ctorString) {
  	      switch (ctorString) {
  	        case dataViewCtorString: return dataViewTag;
  	        case mapCtorString: return mapTag;
  	        case promiseCtorString: return promiseTag;
  	        case setCtorString: return setTag;
  	        case weakMapCtorString: return weakMapTag;
  	      }
  	    }
  	    return result;
  	  };
  	}

  	_getTag = getTag;
  	return _getTag;
  }

  var _baseIsEqualDeep;
  var hasRequired_baseIsEqualDeep;

  function require_baseIsEqualDeep () {
  	if (hasRequired_baseIsEqualDeep) return _baseIsEqualDeep;
  	hasRequired_baseIsEqualDeep = 1;
  	var Stack = require_Stack(),
  	    equalArrays = require_equalArrays(),
  	    equalByTag = require_equalByTag(),
  	    equalObjects = require_equalObjects(),
  	    getTag = require_getTag(),
  	    isArray = requireIsArray(),
  	    isBuffer = requireIsBuffer(),
  	    isTypedArray = requireIsTypedArray();

  	/** Used to compose bitmasks for value comparisons. */
  	var COMPARE_PARTIAL_FLAG = 1;

  	/** `Object#toString` result references. */
  	var argsTag = '[object Arguments]',
  	    arrayTag = '[object Array]',
  	    objectTag = '[object Object]';

  	/** Used for built-in method references. */
  	var objectProto = Object.prototype;

  	/** Used to check objects for own properties. */
  	var hasOwnProperty = objectProto.hasOwnProperty;

  	/**
  	 * A specialized version of `baseIsEqual` for arrays and objects which performs
  	 * deep comparisons and tracks traversed objects enabling objects with circular
  	 * references to be compared.
  	 *
  	 * @private
  	 * @param {Object} object The object to compare.
  	 * @param {Object} other The other object to compare.
  	 * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  	 * @param {Function} customizer The function to customize comparisons.
  	 * @param {Function} equalFunc The function to determine equivalents of values.
  	 * @param {Object} [stack] Tracks traversed `object` and `other` objects.
  	 * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  	 */
  	function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  	  var objIsArr = isArray(object),
  	      othIsArr = isArray(other),
  	      objTag = objIsArr ? arrayTag : getTag(object),
  	      othTag = othIsArr ? arrayTag : getTag(other);

  	  objTag = objTag == argsTag ? objectTag : objTag;
  	  othTag = othTag == argsTag ? objectTag : othTag;

  	  var objIsObj = objTag == objectTag,
  	      othIsObj = othTag == objectTag,
  	      isSameTag = objTag == othTag;

  	  if (isSameTag && isBuffer(object)) {
  	    if (!isBuffer(other)) {
  	      return false;
  	    }
  	    objIsArr = true;
  	    objIsObj = false;
  	  }
  	  if (isSameTag && !objIsObj) {
  	    stack || (stack = new Stack);
  	    return (objIsArr || isTypedArray(object))
  	      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
  	      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  	  }
  	  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
  	    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
  	        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

  	    if (objIsWrapped || othIsWrapped) {
  	      var objUnwrapped = objIsWrapped ? object.value() : object,
  	          othUnwrapped = othIsWrapped ? other.value() : other;

  	      stack || (stack = new Stack);
  	      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
  	    }
  	  }
  	  if (!isSameTag) {
  	    return false;
  	  }
  	  stack || (stack = new Stack);
  	  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
  	}

  	_baseIsEqualDeep = baseIsEqualDeep;
  	return _baseIsEqualDeep;
  }

  var _baseIsEqual;
  var hasRequired_baseIsEqual;

  function require_baseIsEqual () {
  	if (hasRequired_baseIsEqual) return _baseIsEqual;
  	hasRequired_baseIsEqual = 1;
  	var baseIsEqualDeep = require_baseIsEqualDeep(),
  	    isObjectLike = requireIsObjectLike();

  	/**
  	 * The base implementation of `_.isEqual` which supports partial comparisons
  	 * and tracks traversed objects.
  	 *
  	 * @private
  	 * @param {*} value The value to compare.
  	 * @param {*} other The other value to compare.
  	 * @param {boolean} bitmask The bitmask flags.
  	 *  1 - Unordered comparison
  	 *  2 - Partial comparison
  	 * @param {Function} [customizer] The function to customize comparisons.
  	 * @param {Object} [stack] Tracks traversed `value` and `other` objects.
  	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
  	 */
  	function baseIsEqual(value, other, bitmask, customizer, stack) {
  	  if (value === other) {
  	    return true;
  	  }
  	  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
  	    return value !== value && other !== other;
  	  }
  	  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
  	}

  	_baseIsEqual = baseIsEqual;
  	return _baseIsEqual;
  }

  var isEqual_1;
  var hasRequiredIsEqual;

  function requireIsEqual () {
  	if (hasRequiredIsEqual) return isEqual_1;
  	hasRequiredIsEqual = 1;
  	var baseIsEqual = require_baseIsEqual();

  	/**
  	 * Performs a deep comparison between two values to determine if they are
  	 * equivalent.
  	 *
  	 * **Note:** This method supports comparing arrays, array buffers, booleans,
  	 * date objects, error objects, maps, numbers, `Object` objects, regexes,
  	 * sets, strings, symbols, and typed arrays. `Object` objects are compared
  	 * by their own, not inherited, enumerable properties. Functions and DOM
  	 * nodes are compared by strict equality, i.e. `===`.
  	 *
  	 * @static
  	 * @memberOf _
  	 * @since 0.1.0
  	 * @category Lang
  	 * @param {*} value The value to compare.
  	 * @param {*} other The other value to compare.
  	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
  	 * @example
  	 *
  	 * var object = { 'a': 1 };
  	 * var other = { 'a': 1 };
  	 *
  	 * _.isEqual(object, other);
  	 * // => true
  	 *
  	 * object === other;
  	 * // => false
  	 */
  	function isEqual(value, other) {
  	  return baseIsEqual(value, other);
  	}

  	isEqual_1 = isEqual;
  	return isEqual_1;
  }

  var isEqualExports = requireIsEqual();
  var isEqual = /*@__PURE__*/getDefaultExportFromCjs(isEqualExports);

  // these aren't really private, but nor are they really useful to document

  /**
   * @private
   */
  class LuxonError extends Error {}

  /**
   * @private
   */
  class InvalidDateTimeError extends LuxonError {
    constructor(reason) {
      super(`Invalid DateTime: ${reason.toMessage()}`);
    }
  }

  /**
   * @private
   */
  class InvalidIntervalError extends LuxonError {
    constructor(reason) {
      super(`Invalid Interval: ${reason.toMessage()}`);
    }
  }

  /**
   * @private
   */
  class InvalidDurationError extends LuxonError {
    constructor(reason) {
      super(`Invalid Duration: ${reason.toMessage()}`);
    }
  }

  /**
   * @private
   */
  class ConflictingSpecificationError extends LuxonError {}

  /**
   * @private
   */
  class InvalidUnitError extends LuxonError {
    constructor(unit) {
      super(`Invalid unit ${unit}`);
    }
  }

  /**
   * @private
   */
  class InvalidArgumentError extends LuxonError {}

  /**
   * @private
   */
  class ZoneIsAbstractError extends LuxonError {
    constructor() {
      super("Zone is an abstract class");
    }
  }

  /**
   * @private
   */

  const n = "numeric",
    s = "short",
    l = "long";

  const DATE_SHORT = {
    year: n,
    month: n,
    day: n,
  };

  const DATE_MED = {
    year: n,
    month: s,
    day: n,
  };

  const DATE_MED_WITH_WEEKDAY = {
    year: n,
    month: s,
    day: n,
    weekday: s,
  };

  const DATE_FULL = {
    year: n,
    month: l,
    day: n,
  };

  const DATE_HUGE = {
    year: n,
    month: l,
    day: n,
    weekday: l,
  };

  const TIME_SIMPLE = {
    hour: n,
    minute: n,
  };

  const TIME_WITH_SECONDS = {
    hour: n,
    minute: n,
    second: n,
  };

  const TIME_WITH_SHORT_OFFSET = {
    hour: n,
    minute: n,
    second: n,
    timeZoneName: s,
  };

  const TIME_WITH_LONG_OFFSET = {
    hour: n,
    minute: n,
    second: n,
    timeZoneName: l,
  };

  const TIME_24_SIMPLE = {
    hour: n,
    minute: n,
    hourCycle: "h23",
  };

  const TIME_24_WITH_SECONDS = {
    hour: n,
    minute: n,
    second: n,
    hourCycle: "h23",
  };

  const TIME_24_WITH_SHORT_OFFSET = {
    hour: n,
    minute: n,
    second: n,
    hourCycle: "h23",
    timeZoneName: s,
  };

  const TIME_24_WITH_LONG_OFFSET = {
    hour: n,
    minute: n,
    second: n,
    hourCycle: "h23",
    timeZoneName: l,
  };

  const DATETIME_SHORT = {
    year: n,
    month: n,
    day: n,
    hour: n,
    minute: n,
  };

  const DATETIME_SHORT_WITH_SECONDS = {
    year: n,
    month: n,
    day: n,
    hour: n,
    minute: n,
    second: n,
  };

  const DATETIME_MED = {
    year: n,
    month: s,
    day: n,
    hour: n,
    minute: n,
  };

  const DATETIME_MED_WITH_SECONDS = {
    year: n,
    month: s,
    day: n,
    hour: n,
    minute: n,
    second: n,
  };

  const DATETIME_MED_WITH_WEEKDAY = {
    year: n,
    month: s,
    day: n,
    weekday: s,
    hour: n,
    minute: n,
  };

  const DATETIME_FULL = {
    year: n,
    month: l,
    day: n,
    hour: n,
    minute: n,
    timeZoneName: s,
  };

  const DATETIME_FULL_WITH_SECONDS = {
    year: n,
    month: l,
    day: n,
    hour: n,
    minute: n,
    second: n,
    timeZoneName: s,
  };

  const DATETIME_HUGE = {
    year: n,
    month: l,
    day: n,
    weekday: l,
    hour: n,
    minute: n,
    timeZoneName: l,
  };

  const DATETIME_HUGE_WITH_SECONDS = {
    year: n,
    month: l,
    day: n,
    weekday: l,
    hour: n,
    minute: n,
    second: n,
    timeZoneName: l,
  };

  /**
   * @interface
   */
  class Zone {
    /**
     * The type of zone
     * @abstract
     * @type {string}
     */
    get type() {
      throw new ZoneIsAbstractError();
    }

    /**
     * The name of this zone.
     * @abstract
     * @type {string}
     */
    get name() {
      throw new ZoneIsAbstractError();
    }

    /**
     * The IANA name of this zone.
     * Defaults to `name` if not overwritten by a subclass.
     * @abstract
     * @type {string}
     */
    get ianaName() {
      return this.name;
    }

    /**
     * Returns whether the offset is known to be fixed for the whole year.
     * @abstract
     * @type {boolean}
     */
    get isUniversal() {
      throw new ZoneIsAbstractError();
    }

    /**
     * Returns the offset's common name (such as EST) at the specified timestamp
     * @abstract
     * @param {number} ts - Epoch milliseconds for which to get the name
     * @param {Object} opts - Options to affect the format
     * @param {string} opts.format - What style of offset to return. Accepts 'long' or 'short'.
     * @param {string} opts.locale - What locale to return the offset name in.
     * @return {string}
     */
    offsetName(ts, opts) {
      throw new ZoneIsAbstractError();
    }

    /**
     * Returns the offset's value as a string
     * @abstract
     * @param {number} ts - Epoch milliseconds for which to get the offset
     * @param {string} format - What style of offset to return.
     *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
     * @return {string}
     */
    formatOffset(ts, format) {
      throw new ZoneIsAbstractError();
    }

    /**
     * Return the offset in minutes for this zone at the specified timestamp.
     * @abstract
     * @param {number} ts - Epoch milliseconds for which to compute the offset
     * @return {number}
     */
    offset(ts) {
      throw new ZoneIsAbstractError();
    }

    /**
     * Return whether this Zone is equal to another zone
     * @abstract
     * @param {Zone} otherZone - the zone to compare
     * @return {boolean}
     */
    equals(otherZone) {
      throw new ZoneIsAbstractError();
    }

    /**
     * Return whether this Zone is valid.
     * @abstract
     * @type {boolean}
     */
    get isValid() {
      throw new ZoneIsAbstractError();
    }
  }

  let singleton$1 = null;

  /**
   * Represents the local zone for this JavaScript environment.
   * @implements {Zone}
   */
  class SystemZone extends Zone {
    /**
     * Get a singleton instance of the local zone
     * @return {SystemZone}
     */
    static get instance() {
      if (singleton$1 === null) {
        singleton$1 = new SystemZone();
      }
      return singleton$1;
    }

    /** @override **/
    get type() {
      return "system";
    }

    /** @override **/
    get name() {
      return new Intl.DateTimeFormat().resolvedOptions().timeZone;
    }

    /** @override **/
    get isUniversal() {
      return false;
    }

    /** @override **/
    offsetName(ts, { format, locale }) {
      return parseZoneInfo(ts, format, locale);
    }

    /** @override **/
    formatOffset(ts, format) {
      return formatOffset(this.offset(ts), format);
    }

    /** @override **/
    offset(ts) {
      return -new Date(ts).getTimezoneOffset();
    }

    /** @override **/
    equals(otherZone) {
      return otherZone.type === "system";
    }

    /** @override **/
    get isValid() {
      return true;
    }
  }

  let dtfCache = {};
  function makeDTF(zone) {
    if (!dtfCache[zone]) {
      dtfCache[zone] = new Intl.DateTimeFormat("en-US", {
        hour12: false,
        timeZone: zone,
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit",
        second: "2-digit",
        era: "short",
      });
    }
    return dtfCache[zone];
  }

  const typeToPos = {
    year: 0,
    month: 1,
    day: 2,
    era: 3,
    hour: 4,
    minute: 5,
    second: 6,
  };

  function hackyOffset(dtf, date) {
    const formatted = dtf.format(date).replace(/\u200E/g, ""),
      parsed = /(\d+)\/(\d+)\/(\d+) (AD|BC),? (\d+):(\d+):(\d+)/.exec(formatted),
      [, fMonth, fDay, fYear, fadOrBc, fHour, fMinute, fSecond] = parsed;
    return [fYear, fMonth, fDay, fadOrBc, fHour, fMinute, fSecond];
  }

  function partsOffset(dtf, date) {
    const formatted = dtf.formatToParts(date);
    const filled = [];
    for (let i = 0; i < formatted.length; i++) {
      const { type, value } = formatted[i];
      const pos = typeToPos[type];

      if (type === "era") {
        filled[pos] = value;
      } else if (!isUndefined(pos)) {
        filled[pos] = parseInt(value, 10);
      }
    }
    return filled;
  }

  let ianaZoneCache = {};
  /**
   * A zone identified by an IANA identifier, like America/New_York
   * @implements {Zone}
   */
  class IANAZone extends Zone {
    /**
     * @param {string} name - Zone name
     * @return {IANAZone}
     */
    static create(name) {
      if (!ianaZoneCache[name]) {
        ianaZoneCache[name] = new IANAZone(name);
      }
      return ianaZoneCache[name];
    }

    /**
     * Reset local caches. Should only be necessary in testing scenarios.
     * @return {void}
     */
    static resetCache() {
      ianaZoneCache = {};
      dtfCache = {};
    }

    /**
     * Returns whether the provided string is a valid specifier. This only checks the string's format, not that the specifier identifies a known zone; see isValidZone for that.
     * @param {string} s - The string to check validity on
     * @example IANAZone.isValidSpecifier("America/New_York") //=> true
     * @example IANAZone.isValidSpecifier("Sport~~blorp") //=> false
     * @deprecated For backward compatibility, this forwards to isValidZone, better use `isValidZone()` directly instead.
     * @return {boolean}
     */
    static isValidSpecifier(s) {
      return this.isValidZone(s);
    }

    /**
     * Returns whether the provided string identifies a real zone
     * @param {string} zone - The string to check
     * @example IANAZone.isValidZone("America/New_York") //=> true
     * @example IANAZone.isValidZone("Fantasia/Castle") //=> false
     * @example IANAZone.isValidZone("Sport~~blorp") //=> false
     * @return {boolean}
     */
    static isValidZone(zone) {
      if (!zone) {
        return false;
      }
      try {
        new Intl.DateTimeFormat("en-US", { timeZone: zone }).format();
        return true;
      } catch (e) {
        return false;
      }
    }

    constructor(name) {
      super();
      /** @private **/
      this.zoneName = name;
      /** @private **/
      this.valid = IANAZone.isValidZone(name);
    }

    /**
     * The type of zone. `iana` for all instances of `IANAZone`.
     * @override
     * @type {string}
     */
    get type() {
      return "iana";
    }

    /**
     * The name of this zone (i.e. the IANA zone name).
     * @override
     * @type {string}
     */
    get name() {
      return this.zoneName;
    }

    /**
     * Returns whether the offset is known to be fixed for the whole year:
     * Always returns false for all IANA zones.
     * @override
     * @type {boolean}
     */
    get isUniversal() {
      return false;
    }

    /**
     * Returns the offset's common name (such as EST) at the specified timestamp
     * @override
     * @param {number} ts - Epoch milliseconds for which to get the name
     * @param {Object} opts - Options to affect the format
     * @param {string} opts.format - What style of offset to return. Accepts 'long' or 'short'.
     * @param {string} opts.locale - What locale to return the offset name in.
     * @return {string}
     */
    offsetName(ts, { format, locale }) {
      return parseZoneInfo(ts, format, locale, this.name);
    }

    /**
     * Returns the offset's value as a string
     * @override
     * @param {number} ts - Epoch milliseconds for which to get the offset
     * @param {string} format - What style of offset to return.
     *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
     * @return {string}
     */
    formatOffset(ts, format) {
      return formatOffset(this.offset(ts), format);
    }

    /**
     * Return the offset in minutes for this zone at the specified timestamp.
     * @override
     * @param {number} ts - Epoch milliseconds for which to compute the offset
     * @return {number}
     */
    offset(ts) {
      const date = new Date(ts);

      if (isNaN(date)) return NaN;

      const dtf = makeDTF(this.name);
      let [year, month, day, adOrBc, hour, minute, second] = dtf.formatToParts
        ? partsOffset(dtf, date)
        : hackyOffset(dtf, date);

      if (adOrBc === "BC") {
        year = -Math.abs(year) + 1;
      }

      // because we're using hour12 and https://bugs.chromium.org/p/chromium/issues/detail?id=1025564&can=2&q=%2224%3A00%22%20datetimeformat
      const adjustedHour = hour === 24 ? 0 : hour;

      const asUTC = objToLocalTS({
        year,
        month,
        day,
        hour: adjustedHour,
        minute,
        second,
        millisecond: 0,
      });

      let asTS = +date;
      const over = asTS % 1000;
      asTS -= over >= 0 ? over : 1000 + over;
      return (asUTC - asTS) / (60 * 1000);
    }

    /**
     * Return whether this Zone is equal to another zone
     * @override
     * @param {Zone} otherZone - the zone to compare
     * @return {boolean}
     */
    equals(otherZone) {
      return otherZone.type === "iana" && otherZone.name === this.name;
    }

    /**
     * Return whether this Zone is valid.
     * @override
     * @type {boolean}
     */
    get isValid() {
      return this.valid;
    }
  }

  // todo - remap caching

  let intlLFCache = {};
  function getCachedLF(locString, opts = {}) {
    const key = JSON.stringify([locString, opts]);
    let dtf = intlLFCache[key];
    if (!dtf) {
      dtf = new Intl.ListFormat(locString, opts);
      intlLFCache[key] = dtf;
    }
    return dtf;
  }

  let intlDTCache = {};
  function getCachedDTF(locString, opts = {}) {
    const key = JSON.stringify([locString, opts]);
    let dtf = intlDTCache[key];
    if (!dtf) {
      dtf = new Intl.DateTimeFormat(locString, opts);
      intlDTCache[key] = dtf;
    }
    return dtf;
  }

  let intlNumCache = {};
  function getCachedINF(locString, opts = {}) {
    const key = JSON.stringify([locString, opts]);
    let inf = intlNumCache[key];
    if (!inf) {
      inf = new Intl.NumberFormat(locString, opts);
      intlNumCache[key] = inf;
    }
    return inf;
  }

  let intlRelCache = {};
  function getCachedRTF(locString, opts = {}) {
    const { base, ...cacheKeyOpts } = opts; // exclude `base` from the options
    const key = JSON.stringify([locString, cacheKeyOpts]);
    let inf = intlRelCache[key];
    if (!inf) {
      inf = new Intl.RelativeTimeFormat(locString, opts);
      intlRelCache[key] = inf;
    }
    return inf;
  }

  let sysLocaleCache = null;
  function systemLocale() {
    if (sysLocaleCache) {
      return sysLocaleCache;
    } else {
      sysLocaleCache = new Intl.DateTimeFormat().resolvedOptions().locale;
      return sysLocaleCache;
    }
  }

  let weekInfoCache = {};
  function getCachedWeekInfo(locString) {
    let data = weekInfoCache[locString];
    if (!data) {
      const locale = new Intl.Locale(locString);
      // browsers currently implement this as a property, but spec says it should be a getter function
      data = "getWeekInfo" in locale ? locale.getWeekInfo() : locale.weekInfo;
      weekInfoCache[locString] = data;
    }
    return data;
  }

  function parseLocaleString(localeStr) {
    // I really want to avoid writing a BCP 47 parser
    // see, e.g. https://github.com/wooorm/bcp-47
    // Instead, we'll do this:

    // a) if the string has no -u extensions, just leave it alone
    // b) if it does, use Intl to resolve everything
    // c) if Intl fails, try again without the -u

    // private subtags and unicode subtags have ordering requirements,
    // and we're not properly parsing this, so just strip out the
    // private ones if they exist.
    const xIndex = localeStr.indexOf("-x-");
    if (xIndex !== -1) {
      localeStr = localeStr.substring(0, xIndex);
    }

    const uIndex = localeStr.indexOf("-u-");
    if (uIndex === -1) {
      return [localeStr];
    } else {
      let options;
      let selectedStr;
      try {
        options = getCachedDTF(localeStr).resolvedOptions();
        selectedStr = localeStr;
      } catch (e) {
        const smaller = localeStr.substring(0, uIndex);
        options = getCachedDTF(smaller).resolvedOptions();
        selectedStr = smaller;
      }

      const { numberingSystem, calendar } = options;
      return [selectedStr, numberingSystem, calendar];
    }
  }

  function intlConfigString(localeStr, numberingSystem, outputCalendar) {
    if (outputCalendar || numberingSystem) {
      if (!localeStr.includes("-u-")) {
        localeStr += "-u";
      }

      if (outputCalendar) {
        localeStr += `-ca-${outputCalendar}`;
      }

      if (numberingSystem) {
        localeStr += `-nu-${numberingSystem}`;
      }
      return localeStr;
    } else {
      return localeStr;
    }
  }

  function mapMonths(f) {
    const ms = [];
    for (let i = 1; i <= 12; i++) {
      const dt = DateTime.utc(2009, i, 1);
      ms.push(f(dt));
    }
    return ms;
  }

  function mapWeekdays(f) {
    const ms = [];
    for (let i = 1; i <= 7; i++) {
      const dt = DateTime.utc(2016, 11, 13 + i);
      ms.push(f(dt));
    }
    return ms;
  }

  function listStuff(loc, length, englishFn, intlFn) {
    const mode = loc.listingMode();

    if (mode === "error") {
      return null;
    } else if (mode === "en") {
      return englishFn(length);
    } else {
      return intlFn(length);
    }
  }

  function supportsFastNumbers(loc) {
    if (loc.numberingSystem && loc.numberingSystem !== "latn") {
      return false;
    } else {
      return (
        loc.numberingSystem === "latn" ||
        !loc.locale ||
        loc.locale.startsWith("en") ||
        new Intl.DateTimeFormat(loc.intl).resolvedOptions().numberingSystem === "latn"
      );
    }
  }

  /**
   * @private
   */

  class PolyNumberFormatter {
    constructor(intl, forceSimple, opts) {
      this.padTo = opts.padTo || 0;
      this.floor = opts.floor || false;

      const { padTo, floor, ...otherOpts } = opts;

      if (!forceSimple || Object.keys(otherOpts).length > 0) {
        const intlOpts = { useGrouping: false, ...opts };
        if (opts.padTo > 0) intlOpts.minimumIntegerDigits = opts.padTo;
        this.inf = getCachedINF(intl, intlOpts);
      }
    }

    format(i) {
      if (this.inf) {
        const fixed = this.floor ? Math.floor(i) : i;
        return this.inf.format(fixed);
      } else {
        // to match the browser's numberformatter defaults
        const fixed = this.floor ? Math.floor(i) : roundTo(i, 3);
        return padStart(fixed, this.padTo);
      }
    }
  }

  /**
   * @private
   */

  class PolyDateFormatter {
    constructor(dt, intl, opts) {
      this.opts = opts;
      this.originalZone = undefined;

      let z = undefined;
      if (this.opts.timeZone) {
        // Don't apply any workarounds if a timeZone is explicitly provided in opts
        this.dt = dt;
      } else if (dt.zone.type === "fixed") {
        // UTC-8 or Etc/UTC-8 are not part of tzdata, only Etc/GMT+8 and the like.
        // That is why fixed-offset TZ is set to that unless it is:
        // 1. Representing offset 0 when UTC is used to maintain previous behavior and does not become GMT.
        // 2. Unsupported by the browser:
        //    - some do not support Etc/
        //    - < Etc/GMT-14, > Etc/GMT+12, and 30-minute or 45-minute offsets are not part of tzdata
        const gmtOffset = -1 * (dt.offset / 60);
        const offsetZ = gmtOffset >= 0 ? `Etc/GMT+${gmtOffset}` : `Etc/GMT${gmtOffset}`;
        if (dt.offset !== 0 && IANAZone.create(offsetZ).valid) {
          z = offsetZ;
          this.dt = dt;
        } else {
          // Not all fixed-offset zones like Etc/+4:30 are present in tzdata so
          // we manually apply the offset and substitute the zone as needed.
          z = "UTC";
          this.dt = dt.offset === 0 ? dt : dt.setZone("UTC").plus({ minutes: dt.offset });
          this.originalZone = dt.zone;
        }
      } else if (dt.zone.type === "system") {
        this.dt = dt;
      } else if (dt.zone.type === "iana") {
        this.dt = dt;
        z = dt.zone.name;
      } else {
        // Custom zones can have any offset / offsetName so we just manually
        // apply the offset and substitute the zone as needed.
        z = "UTC";
        this.dt = dt.setZone("UTC").plus({ minutes: dt.offset });
        this.originalZone = dt.zone;
      }

      const intlOpts = { ...this.opts };
      intlOpts.timeZone = intlOpts.timeZone || z;
      this.dtf = getCachedDTF(intl, intlOpts);
    }

    format() {
      if (this.originalZone) {
        // If we have to substitute in the actual zone name, we have to use
        // formatToParts so that the timezone can be replaced.
        return this.formatToParts()
          .map(({ value }) => value)
          .join("");
      }
      return this.dtf.format(this.dt.toJSDate());
    }

    formatToParts() {
      const parts = this.dtf.formatToParts(this.dt.toJSDate());
      if (this.originalZone) {
        return parts.map((part) => {
          if (part.type === "timeZoneName") {
            const offsetName = this.originalZone.offsetName(this.dt.ts, {
              locale: this.dt.locale,
              format: this.opts.timeZoneName,
            });
            return {
              ...part,
              value: offsetName,
            };
          } else {
            return part;
          }
        });
      }
      return parts;
    }

    resolvedOptions() {
      return this.dtf.resolvedOptions();
    }
  }

  /**
   * @private
   */
  class PolyRelFormatter {
    constructor(intl, isEnglish, opts) {
      this.opts = { style: "long", ...opts };
      if (!isEnglish && hasRelative()) {
        this.rtf = getCachedRTF(intl, opts);
      }
    }

    format(count, unit) {
      if (this.rtf) {
        return this.rtf.format(count, unit);
      } else {
        return formatRelativeTime(unit, count, this.opts.numeric, this.opts.style !== "long");
      }
    }

    formatToParts(count, unit) {
      if (this.rtf) {
        return this.rtf.formatToParts(count, unit);
      } else {
        return [];
      }
    }
  }

  const fallbackWeekSettings = {
    firstDay: 1,
    minimalDays: 4,
    weekend: [6, 7],
  };

  /**
   * @private
   */

  class Locale {
    static fromOpts(opts) {
      return Locale.create(
        opts.locale,
        opts.numberingSystem,
        opts.outputCalendar,
        opts.weekSettings,
        opts.defaultToEN
      );
    }

    static create(locale, numberingSystem, outputCalendar, weekSettings, defaultToEN = false) {
      const specifiedLocale = locale || Settings.defaultLocale;
      // the system locale is useful for human-readable strings but annoying for parsing/formatting known formats
      const localeR = specifiedLocale || (defaultToEN ? "en-US" : systemLocale());
      const numberingSystemR = numberingSystem || Settings.defaultNumberingSystem;
      const outputCalendarR = outputCalendar || Settings.defaultOutputCalendar;
      const weekSettingsR = validateWeekSettings(weekSettings) || Settings.defaultWeekSettings;
      return new Locale(localeR, numberingSystemR, outputCalendarR, weekSettingsR, specifiedLocale);
    }

    static resetCache() {
      sysLocaleCache = null;
      intlDTCache = {};
      intlNumCache = {};
      intlRelCache = {};
    }

    static fromObject({ locale, numberingSystem, outputCalendar, weekSettings } = {}) {
      return Locale.create(locale, numberingSystem, outputCalendar, weekSettings);
    }

    constructor(locale, numbering, outputCalendar, weekSettings, specifiedLocale) {
      const [parsedLocale, parsedNumberingSystem, parsedOutputCalendar] = parseLocaleString(locale);

      this.locale = parsedLocale;
      this.numberingSystem = numbering || parsedNumberingSystem || null;
      this.outputCalendar = outputCalendar || parsedOutputCalendar || null;
      this.weekSettings = weekSettings;
      this.intl = intlConfigString(this.locale, this.numberingSystem, this.outputCalendar);

      this.weekdaysCache = { format: {}, standalone: {} };
      this.monthsCache = { format: {}, standalone: {} };
      this.meridiemCache = null;
      this.eraCache = {};

      this.specifiedLocale = specifiedLocale;
      this.fastNumbersCached = null;
    }

    get fastNumbers() {
      if (this.fastNumbersCached == null) {
        this.fastNumbersCached = supportsFastNumbers(this);
      }

      return this.fastNumbersCached;
    }

    listingMode() {
      const isActuallyEn = this.isEnglish();
      const hasNoWeirdness =
        (this.numberingSystem === null || this.numberingSystem === "latn") &&
        (this.outputCalendar === null || this.outputCalendar === "gregory");
      return isActuallyEn && hasNoWeirdness ? "en" : "intl";
    }

    clone(alts) {
      if (!alts || Object.getOwnPropertyNames(alts).length === 0) {
        return this;
      } else {
        return Locale.create(
          alts.locale || this.specifiedLocale,
          alts.numberingSystem || this.numberingSystem,
          alts.outputCalendar || this.outputCalendar,
          validateWeekSettings(alts.weekSettings) || this.weekSettings,
          alts.defaultToEN || false
        );
      }
    }

    redefaultToEN(alts = {}) {
      return this.clone({ ...alts, defaultToEN: true });
    }

    redefaultToSystem(alts = {}) {
      return this.clone({ ...alts, defaultToEN: false });
    }

    months(length, format = false) {
      return listStuff(this, length, months, () => {
        const intl = format ? { month: length, day: "numeric" } : { month: length },
          formatStr = format ? "format" : "standalone";
        if (!this.monthsCache[formatStr][length]) {
          this.monthsCache[formatStr][length] = mapMonths((dt) => this.extract(dt, intl, "month"));
        }
        return this.monthsCache[formatStr][length];
      });
    }

    weekdays(length, format = false) {
      return listStuff(this, length, weekdays, () => {
        const intl = format
            ? { weekday: length, year: "numeric", month: "long", day: "numeric" }
            : { weekday: length },
          formatStr = format ? "format" : "standalone";
        if (!this.weekdaysCache[formatStr][length]) {
          this.weekdaysCache[formatStr][length] = mapWeekdays((dt) =>
            this.extract(dt, intl, "weekday")
          );
        }
        return this.weekdaysCache[formatStr][length];
      });
    }

    meridiems() {
      return listStuff(
        this,
        undefined,
        () => meridiems,
        () => {
          // In theory there could be aribitrary day periods. We're gonna assume there are exactly two
          // for AM and PM. This is probably wrong, but it's makes parsing way easier.
          if (!this.meridiemCache) {
            const intl = { hour: "numeric", hourCycle: "h12" };
            this.meridiemCache = [DateTime.utc(2016, 11, 13, 9), DateTime.utc(2016, 11, 13, 19)].map(
              (dt) => this.extract(dt, intl, "dayperiod")
            );
          }

          return this.meridiemCache;
        }
      );
    }

    eras(length) {
      return listStuff(this, length, eras, () => {
        const intl = { era: length };

        // This is problematic. Different calendars are going to define eras totally differently. What I need is the minimum set of dates
        // to definitely enumerate them.
        if (!this.eraCache[length]) {
          this.eraCache[length] = [DateTime.utc(-40, 1, 1), DateTime.utc(2017, 1, 1)].map((dt) =>
            this.extract(dt, intl, "era")
          );
        }

        return this.eraCache[length];
      });
    }

    extract(dt, intlOpts, field) {
      const df = this.dtFormatter(dt, intlOpts),
        results = df.formatToParts(),
        matching = results.find((m) => m.type.toLowerCase() === field);
      return matching ? matching.value : null;
    }

    numberFormatter(opts = {}) {
      // this forcesimple option is never used (the only caller short-circuits on it, but it seems safer to leave)
      // (in contrast, the rest of the condition is used heavily)
      return new PolyNumberFormatter(this.intl, opts.forceSimple || this.fastNumbers, opts);
    }

    dtFormatter(dt, intlOpts = {}) {
      return new PolyDateFormatter(dt, this.intl, intlOpts);
    }

    relFormatter(opts = {}) {
      return new PolyRelFormatter(this.intl, this.isEnglish(), opts);
    }

    listFormatter(opts = {}) {
      return getCachedLF(this.intl, opts);
    }

    isEnglish() {
      return (
        this.locale === "en" ||
        this.locale.toLowerCase() === "en-us" ||
        new Intl.DateTimeFormat(this.intl).resolvedOptions().locale.startsWith("en-us")
      );
    }

    getWeekSettings() {
      if (this.weekSettings) {
        return this.weekSettings;
      } else if (!hasLocaleWeekInfo()) {
        return fallbackWeekSettings;
      } else {
        return getCachedWeekInfo(this.locale);
      }
    }

    getStartOfWeek() {
      return this.getWeekSettings().firstDay;
    }

    getMinDaysInFirstWeek() {
      return this.getWeekSettings().minimalDays;
    }

    getWeekendDays() {
      return this.getWeekSettings().weekend;
    }

    equals(other) {
      return (
        this.locale === other.locale &&
        this.numberingSystem === other.numberingSystem &&
        this.outputCalendar === other.outputCalendar
      );
    }

    toString() {
      return `Locale(${this.locale}, ${this.numberingSystem}, ${this.outputCalendar})`;
    }
  }

  let singleton = null;

  /**
   * A zone with a fixed offset (meaning no DST)
   * @implements {Zone}
   */
  class FixedOffsetZone extends Zone {
    /**
     * Get a singleton instance of UTC
     * @return {FixedOffsetZone}
     */
    static get utcInstance() {
      if (singleton === null) {
        singleton = new FixedOffsetZone(0);
      }
      return singleton;
    }

    /**
     * Get an instance with a specified offset
     * @param {number} offset - The offset in minutes
     * @return {FixedOffsetZone}
     */
    static instance(offset) {
      return offset === 0 ? FixedOffsetZone.utcInstance : new FixedOffsetZone(offset);
    }

    /**
     * Get an instance of FixedOffsetZone from a UTC offset string, like "UTC+6"
     * @param {string} s - The offset string to parse
     * @example FixedOffsetZone.parseSpecifier("UTC+6")
     * @example FixedOffsetZone.parseSpecifier("UTC+06")
     * @example FixedOffsetZone.parseSpecifier("UTC-6:00")
     * @return {FixedOffsetZone}
     */
    static parseSpecifier(s) {
      if (s) {
        const r = s.match(/^utc(?:([+-]\d{1,2})(?::(\d{2}))?)?$/i);
        if (r) {
          return new FixedOffsetZone(signedOffset(r[1], r[2]));
        }
      }
      return null;
    }

    constructor(offset) {
      super();
      /** @private **/
      this.fixed = offset;
    }

    /**
     * The type of zone. `fixed` for all instances of `FixedOffsetZone`.
     * @override
     * @type {string}
     */
    get type() {
      return "fixed";
    }

    /**
     * The name of this zone.
     * All fixed zones' names always start with "UTC" (plus optional offset)
     * @override
     * @type {string}
     */
    get name() {
      return this.fixed === 0 ? "UTC" : `UTC${formatOffset(this.fixed, "narrow")}`;
    }

    /**
     * The IANA name of this zone, i.e. `Etc/UTC` or `Etc/GMT+/-nn`
     *
     * @override
     * @type {string}
     */
    get ianaName() {
      if (this.fixed === 0) {
        return "Etc/UTC";
      } else {
        return `Etc/GMT${formatOffset(-this.fixed, "narrow")}`;
      }
    }

    /**
     * Returns the offset's common name at the specified timestamp.
     *
     * For fixed offset zones this equals to the zone name.
     * @override
     */
    offsetName() {
      return this.name;
    }

    /**
     * Returns the offset's value as a string
     * @override
     * @param {number} ts - Epoch milliseconds for which to get the offset
     * @param {string} format - What style of offset to return.
     *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
     * @return {string}
     */
    formatOffset(ts, format) {
      return formatOffset(this.fixed, format);
    }

    /**
     * Returns whether the offset is known to be fixed for the whole year:
     * Always returns true for all fixed offset zones.
     * @override
     * @type {boolean}
     */
    get isUniversal() {
      return true;
    }

    /**
     * Return the offset in minutes for this zone at the specified timestamp.
     *
     * For fixed offset zones, this is constant and does not depend on a timestamp.
     * @override
     * @return {number}
     */
    offset() {
      return this.fixed;
    }

    /**
     * Return whether this Zone is equal to another zone (i.e. also fixed and same offset)
     * @override
     * @param {Zone} otherZone - the zone to compare
     * @return {boolean}
     */
    equals(otherZone) {
      return otherZone.type === "fixed" && otherZone.fixed === this.fixed;
    }

    /**
     * Return whether this Zone is valid:
     * All fixed offset zones are valid.
     * @override
     * @type {boolean}
     */
    get isValid() {
      return true;
    }
  }

  /**
   * A zone that failed to parse. You should never need to instantiate this.
   * @implements {Zone}
   */
  class InvalidZone extends Zone {
    constructor(zoneName) {
      super();
      /**  @private */
      this.zoneName = zoneName;
    }

    /** @override **/
    get type() {
      return "invalid";
    }

    /** @override **/
    get name() {
      return this.zoneName;
    }

    /** @override **/
    get isUniversal() {
      return false;
    }

    /** @override **/
    offsetName() {
      return null;
    }

    /** @override **/
    formatOffset() {
      return "";
    }

    /** @override **/
    offset() {
      return NaN;
    }

    /** @override **/
    equals() {
      return false;
    }

    /** @override **/
    get isValid() {
      return false;
    }
  }

  /**
   * @private
   */


  function normalizeZone(input, defaultZone) {
    if (isUndefined(input) || input === null) {
      return defaultZone;
    } else if (input instanceof Zone) {
      return input;
    } else if (isString$1(input)) {
      const lowered = input.toLowerCase();
      if (lowered === "default") return defaultZone;
      else if (lowered === "local" || lowered === "system") return SystemZone.instance;
      else if (lowered === "utc" || lowered === "gmt") return FixedOffsetZone.utcInstance;
      else return FixedOffsetZone.parseSpecifier(lowered) || IANAZone.create(input);
    } else if (isNumber$1(input)) {
      return FixedOffsetZone.instance(input);
    } else if (typeof input === "object" && "offset" in input && typeof input.offset === "function") {
      // This is dumb, but the instanceof check above doesn't seem to really work
      // so we're duck checking it
      return input;
    } else {
      return new InvalidZone(input);
    }
  }

  const numberingSystems = {
    arab: "[\u0660-\u0669]",
    arabext: "[\u06F0-\u06F9]",
    bali: "[\u1B50-\u1B59]",
    beng: "[\u09E6-\u09EF]",
    deva: "[\u0966-\u096F]",
    fullwide: "[\uFF10-\uFF19]",
    gujr: "[\u0AE6-\u0AEF]",
    hanidec: "[〇|一|二|三|四|五|六|七|八|九]",
    khmr: "[\u17E0-\u17E9]",
    knda: "[\u0CE6-\u0CEF]",
    laoo: "[\u0ED0-\u0ED9]",
    limb: "[\u1946-\u194F]",
    mlym: "[\u0D66-\u0D6F]",
    mong: "[\u1810-\u1819]",
    mymr: "[\u1040-\u1049]",
    orya: "[\u0B66-\u0B6F]",
    tamldec: "[\u0BE6-\u0BEF]",
    telu: "[\u0C66-\u0C6F]",
    thai: "[\u0E50-\u0E59]",
    tibt: "[\u0F20-\u0F29]",
    latn: "\\d",
  };

  const numberingSystemsUTF16 = {
    arab: [1632, 1641],
    arabext: [1776, 1785],
    bali: [6992, 7001],
    beng: [2534, 2543],
    deva: [2406, 2415],
    fullwide: [65296, 65303],
    gujr: [2790, 2799],
    khmr: [6112, 6121],
    knda: [3302, 3311],
    laoo: [3792, 3801],
    limb: [6470, 6479],
    mlym: [3430, 3439],
    mong: [6160, 6169],
    mymr: [4160, 4169],
    orya: [2918, 2927],
    tamldec: [3046, 3055],
    telu: [3174, 3183],
    thai: [3664, 3673],
    tibt: [3872, 3881],
  };

  const hanidecChars = numberingSystems.hanidec.replace(/[\[|\]]/g, "").split("");

  function parseDigits(str) {
    let value = parseInt(str, 10);
    if (isNaN(value)) {
      value = "";
      for (let i = 0; i < str.length; i++) {
        const code = str.charCodeAt(i);

        if (str[i].search(numberingSystems.hanidec) !== -1) {
          value += hanidecChars.indexOf(str[i]);
        } else {
          for (const key in numberingSystemsUTF16) {
            const [min, max] = numberingSystemsUTF16[key];
            if (code >= min && code <= max) {
              value += code - min;
            }
          }
        }
      }
      return parseInt(value, 10);
    } else {
      return value;
    }
  }

  // cache of {numberingSystem: {append: regex}}
  let digitRegexCache = {};
  function resetDigitRegexCache() {
    digitRegexCache = {};
  }

  function digitRegex({ numberingSystem }, append = "") {
    const ns = numberingSystem || "latn";

    if (!digitRegexCache[ns]) {
      digitRegexCache[ns] = {};
    }
    if (!digitRegexCache[ns][append]) {
      digitRegexCache[ns][append] = new RegExp(`${numberingSystems[ns]}${append}`);
    }

    return digitRegexCache[ns][append];
  }

  let now = () => Date.now(),
    defaultZone = "system",
    defaultLocale = null,
    defaultNumberingSystem = null,
    defaultOutputCalendar = null,
    twoDigitCutoffYear = 60,
    throwOnInvalid,
    defaultWeekSettings = null;

  /**
   * Settings contains static getters and setters that control Luxon's overall behavior. Luxon is a simple library with few options, but the ones it does have live here.
   */
  class Settings {
    /**
     * Get the callback for returning the current timestamp.
     * @type {function}
     */
    static get now() {
      return now;
    }

    /**
     * Set the callback for returning the current timestamp.
     * The function should return a number, which will be interpreted as an Epoch millisecond count
     * @type {function}
     * @example Settings.now = () => Date.now() + 3000 // pretend it is 3 seconds in the future
     * @example Settings.now = () => 0 // always pretend it's Jan 1, 1970 at midnight in UTC time
     */
    static set now(n) {
      now = n;
    }

    /**
     * Set the default time zone to create DateTimes in. Does not affect existing instances.
     * Use the value "system" to reset this value to the system's time zone.
     * @type {string}
     */
    static set defaultZone(zone) {
      defaultZone = zone;
    }

    /**
     * Get the default time zone object currently used to create DateTimes. Does not affect existing instances.
     * The default value is the system's time zone (the one set on the machine that runs this code).
     * @type {Zone}
     */
    static get defaultZone() {
      return normalizeZone(defaultZone, SystemZone.instance);
    }

    /**
     * Get the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static get defaultLocale() {
      return defaultLocale;
    }

    /**
     * Set the default locale to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static set defaultLocale(locale) {
      defaultLocale = locale;
    }

    /**
     * Get the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static get defaultNumberingSystem() {
      return defaultNumberingSystem;
    }

    /**
     * Set the default numbering system to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static set defaultNumberingSystem(numberingSystem) {
      defaultNumberingSystem = numberingSystem;
    }

    /**
     * Get the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static get defaultOutputCalendar() {
      return defaultOutputCalendar;
    }

    /**
     * Set the default output calendar to create DateTimes with. Does not affect existing instances.
     * @type {string}
     */
    static set defaultOutputCalendar(outputCalendar) {
      defaultOutputCalendar = outputCalendar;
    }

    /**
     * @typedef {Object} WeekSettings
     * @property {number} firstDay
     * @property {number} minimalDays
     * @property {number[]} weekend
     */

    /**
     * @return {WeekSettings|null}
     */
    static get defaultWeekSettings() {
      return defaultWeekSettings;
    }

    /**
     * Allows overriding the default locale week settings, i.e. the start of the week, the weekend and
     * how many days are required in the first week of a year.
     * Does not affect existing instances.
     *
     * @param {WeekSettings|null} weekSettings
     */
    static set defaultWeekSettings(weekSettings) {
      defaultWeekSettings = validateWeekSettings(weekSettings);
    }

    /**
     * Get the cutoff year for whether a 2-digit year string is interpreted in the current or previous century. Numbers higher than the cutoff will be considered to mean 19xx and numbers lower or equal to the cutoff will be considered 20xx.
     * @type {number}
     */
    static get twoDigitCutoffYear() {
      return twoDigitCutoffYear;
    }

    /**
     * Set the cutoff year for whether a 2-digit year string is interpreted in the current or previous century. Numbers higher than the cutoff will be considered to mean 19xx and numbers lower or equal to the cutoff will be considered 20xx.
     * @type {number}
     * @example Settings.twoDigitCutoffYear = 0 // all 'yy' are interpreted as 20th century
     * @example Settings.twoDigitCutoffYear = 99 // all 'yy' are interpreted as 21st century
     * @example Settings.twoDigitCutoffYear = 50 // '49' -> 2049; '50' -> 1950
     * @example Settings.twoDigitCutoffYear = 1950 // interpreted as 50
     * @example Settings.twoDigitCutoffYear = 2050 // ALSO interpreted as 50
     */
    static set twoDigitCutoffYear(cutoffYear) {
      twoDigitCutoffYear = cutoffYear % 100;
    }

    /**
     * Get whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */
    static get throwOnInvalid() {
      return throwOnInvalid;
    }

    /**
     * Set whether Luxon will throw when it encounters invalid DateTimes, Durations, or Intervals
     * @type {boolean}
     */
    static set throwOnInvalid(t) {
      throwOnInvalid = t;
    }

    /**
     * Reset Luxon's global caches. Should only be necessary in testing scenarios.
     * @return {void}
     */
    static resetCaches() {
      Locale.resetCache();
      IANAZone.resetCache();
      DateTime.resetCache();
      resetDigitRegexCache();
    }
  }

  class Invalid {
    constructor(reason, explanation) {
      this.reason = reason;
      this.explanation = explanation;
    }

    toMessage() {
      if (this.explanation) {
        return `${this.reason}: ${this.explanation}`;
      } else {
        return this.reason;
      }
    }
  }

  const nonLeapLadder = [0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334],
    leapLadder = [0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335];

  function unitOutOfRange(unit, value) {
    return new Invalid(
      "unit out of range",
      `you specified ${value} (of type ${typeof value}) as a ${unit}, which is invalid`
    );
  }

  function dayOfWeek(year, month, day) {
    const d = new Date(Date.UTC(year, month - 1, day));

    if (year < 100 && year >= 0) {
      d.setUTCFullYear(d.getUTCFullYear() - 1900);
    }

    const js = d.getUTCDay();

    return js === 0 ? 7 : js;
  }

  function computeOrdinal(year, month, day) {
    return day + (isLeapYear(year) ? leapLadder : nonLeapLadder)[month - 1];
  }

  function uncomputeOrdinal(year, ordinal) {
    const table = isLeapYear(year) ? leapLadder : nonLeapLadder,
      month0 = table.findIndex((i) => i < ordinal),
      day = ordinal - table[month0];
    return { month: month0 + 1, day };
  }

  function isoWeekdayToLocal(isoWeekday, startOfWeek) {
    return ((isoWeekday - startOfWeek + 7) % 7) + 1;
  }

  /**
   * @private
   */

  function gregorianToWeek(gregObj, minDaysInFirstWeek = 4, startOfWeek = 1) {
    const { year, month, day } = gregObj,
      ordinal = computeOrdinal(year, month, day),
      weekday = isoWeekdayToLocal(dayOfWeek(year, month, day), startOfWeek);

    let weekNumber = Math.floor((ordinal - weekday + 14 - minDaysInFirstWeek) / 7),
      weekYear;

    if (weekNumber < 1) {
      weekYear = year - 1;
      weekNumber = weeksInWeekYear(weekYear, minDaysInFirstWeek, startOfWeek);
    } else if (weekNumber > weeksInWeekYear(year, minDaysInFirstWeek, startOfWeek)) {
      weekYear = year + 1;
      weekNumber = 1;
    } else {
      weekYear = year;
    }

    return { weekYear, weekNumber, weekday, ...timeObject(gregObj) };
  }

  function weekToGregorian(weekData, minDaysInFirstWeek = 4, startOfWeek = 1) {
    const { weekYear, weekNumber, weekday } = weekData,
      weekdayOfJan4 = isoWeekdayToLocal(dayOfWeek(weekYear, 1, minDaysInFirstWeek), startOfWeek),
      yearInDays = daysInYear(weekYear);

    let ordinal = weekNumber * 7 + weekday - weekdayOfJan4 - 7 + minDaysInFirstWeek,
      year;

    if (ordinal < 1) {
      year = weekYear - 1;
      ordinal += daysInYear(year);
    } else if (ordinal > yearInDays) {
      year = weekYear + 1;
      ordinal -= daysInYear(weekYear);
    } else {
      year = weekYear;
    }

    const { month, day } = uncomputeOrdinal(year, ordinal);
    return { year, month, day, ...timeObject(weekData) };
  }

  function gregorianToOrdinal(gregData) {
    const { year, month, day } = gregData;
    const ordinal = computeOrdinal(year, month, day);
    return { year, ordinal, ...timeObject(gregData) };
  }

  function ordinalToGregorian(ordinalData) {
    const { year, ordinal } = ordinalData;
    const { month, day } = uncomputeOrdinal(year, ordinal);
    return { year, month, day, ...timeObject(ordinalData) };
  }

  /**
   * Check if local week units like localWeekday are used in obj.
   * If so, validates that they are not mixed with ISO week units and then copies them to the normal week unit properties.
   * Modifies obj in-place!
   * @param obj the object values
   */
  function usesLocalWeekValues(obj, loc) {
    const hasLocaleWeekData =
      !isUndefined(obj.localWeekday) ||
      !isUndefined(obj.localWeekNumber) ||
      !isUndefined(obj.localWeekYear);
    if (hasLocaleWeekData) {
      const hasIsoWeekData =
        !isUndefined(obj.weekday) || !isUndefined(obj.weekNumber) || !isUndefined(obj.weekYear);

      if (hasIsoWeekData) {
        throw new ConflictingSpecificationError(
          "Cannot mix locale-based week fields with ISO-based week fields"
        );
      }
      if (!isUndefined(obj.localWeekday)) obj.weekday = obj.localWeekday;
      if (!isUndefined(obj.localWeekNumber)) obj.weekNumber = obj.localWeekNumber;
      if (!isUndefined(obj.localWeekYear)) obj.weekYear = obj.localWeekYear;
      delete obj.localWeekday;
      delete obj.localWeekNumber;
      delete obj.localWeekYear;
      return {
        minDaysInFirstWeek: loc.getMinDaysInFirstWeek(),
        startOfWeek: loc.getStartOfWeek(),
      };
    } else {
      return { minDaysInFirstWeek: 4, startOfWeek: 1 };
    }
  }

  function hasInvalidWeekData(obj, minDaysInFirstWeek = 4, startOfWeek = 1) {
    const validYear = isInteger(obj.weekYear),
      validWeek = integerBetween(
        obj.weekNumber,
        1,
        weeksInWeekYear(obj.weekYear, minDaysInFirstWeek, startOfWeek)
      ),
      validWeekday = integerBetween(obj.weekday, 1, 7);

    if (!validYear) {
      return unitOutOfRange("weekYear", obj.weekYear);
    } else if (!validWeek) {
      return unitOutOfRange("week", obj.weekNumber);
    } else if (!validWeekday) {
      return unitOutOfRange("weekday", obj.weekday);
    } else return false;
  }

  function hasInvalidOrdinalData(obj) {
    const validYear = isInteger(obj.year),
      validOrdinal = integerBetween(obj.ordinal, 1, daysInYear(obj.year));

    if (!validYear) {
      return unitOutOfRange("year", obj.year);
    } else if (!validOrdinal) {
      return unitOutOfRange("ordinal", obj.ordinal);
    } else return false;
  }

  function hasInvalidGregorianData(obj) {
    const validYear = isInteger(obj.year),
      validMonth = integerBetween(obj.month, 1, 12),
      validDay = integerBetween(obj.day, 1, daysInMonth(obj.year, obj.month));

    if (!validYear) {
      return unitOutOfRange("year", obj.year);
    } else if (!validMonth) {
      return unitOutOfRange("month", obj.month);
    } else if (!validDay) {
      return unitOutOfRange("day", obj.day);
    } else return false;
  }

  function hasInvalidTimeData(obj) {
    const { hour, minute, second, millisecond } = obj;
    const validHour =
        integerBetween(hour, 0, 23) ||
        (hour === 24 && minute === 0 && second === 0 && millisecond === 0),
      validMinute = integerBetween(minute, 0, 59),
      validSecond = integerBetween(second, 0, 59),
      validMillisecond = integerBetween(millisecond, 0, 999);

    if (!validHour) {
      return unitOutOfRange("hour", hour);
    } else if (!validMinute) {
      return unitOutOfRange("minute", minute);
    } else if (!validSecond) {
      return unitOutOfRange("second", second);
    } else if (!validMillisecond) {
      return unitOutOfRange("millisecond", millisecond);
    } else return false;
  }

  /*
    This is just a junk drawer, containing anything used across multiple classes.
    Because Luxon is small(ish), this should stay small and we won't worry about splitting
    it up into, say, parsingUtil.js and basicUtil.js and so on. But they are divided up by feature area.
  */


  /**
   * @private
   */

  // TYPES

  function isUndefined(o) {
    return typeof o === "undefined";
  }

  function isNumber$1(o) {
    return typeof o === "number";
  }

  function isInteger(o) {
    return typeof o === "number" && o % 1 === 0;
  }

  function isString$1(o) {
    return typeof o === "string";
  }

  function isDate(o) {
    return Object.prototype.toString.call(o) === "[object Date]";
  }

  // CAPABILITIES

  function hasRelative() {
    try {
      return typeof Intl !== "undefined" && !!Intl.RelativeTimeFormat;
    } catch (e) {
      return false;
    }
  }

  function hasLocaleWeekInfo() {
    try {
      return (
        typeof Intl !== "undefined" &&
        !!Intl.Locale &&
        ("weekInfo" in Intl.Locale.prototype || "getWeekInfo" in Intl.Locale.prototype)
      );
    } catch (e) {
      return false;
    }
  }

  // OBJECTS AND ARRAYS

  function maybeArray(thing) {
    return Array.isArray(thing) ? thing : [thing];
  }

  function bestBy(arr, by, compare) {
    if (arr.length === 0) {
      return undefined;
    }
    return arr.reduce((best, next) => {
      const pair = [by(next), next];
      if (!best) {
        return pair;
      } else if (compare(best[0], pair[0]) === best[0]) {
        return best;
      } else {
        return pair;
      }
    }, null)[1];
  }

  function pick(obj, keys) {
    return keys.reduce((a, k) => {
      a[k] = obj[k];
      return a;
    }, {});
  }

  function hasOwnProperty(obj, prop) {
    return Object.prototype.hasOwnProperty.call(obj, prop);
  }

  function validateWeekSettings(settings) {
    if (settings == null) {
      return null;
    } else if (typeof settings !== "object") {
      throw new InvalidArgumentError("Week settings must be an object");
    } else {
      if (
        !integerBetween(settings.firstDay, 1, 7) ||
        !integerBetween(settings.minimalDays, 1, 7) ||
        !Array.isArray(settings.weekend) ||
        settings.weekend.some((v) => !integerBetween(v, 1, 7))
      ) {
        throw new InvalidArgumentError("Invalid week settings");
      }
      return {
        firstDay: settings.firstDay,
        minimalDays: settings.minimalDays,
        weekend: Array.from(settings.weekend),
      };
    }
  }

  // NUMBERS AND STRINGS

  function integerBetween(thing, bottom, top) {
    return isInteger(thing) && thing >= bottom && thing <= top;
  }

  // x % n but takes the sign of n instead of x
  function floorMod(x, n) {
    return x - n * Math.floor(x / n);
  }

  function padStart(input, n = 2) {
    const isNeg = input < 0;
    let padded;
    if (isNeg) {
      padded = "-" + ("" + -input).padStart(n, "0");
    } else {
      padded = ("" + input).padStart(n, "0");
    }
    return padded;
  }

  function parseInteger(string) {
    if (isUndefined(string) || string === null || string === "") {
      return undefined;
    } else {
      return parseInt(string, 10);
    }
  }

  function parseFloating(string) {
    if (isUndefined(string) || string === null || string === "") {
      return undefined;
    } else {
      return parseFloat(string);
    }
  }

  function parseMillis(fraction) {
    // Return undefined (instead of 0) in these cases, where fraction is not set
    if (isUndefined(fraction) || fraction === null || fraction === "") {
      return undefined;
    } else {
      const f = parseFloat("0." + fraction) * 1000;
      return Math.floor(f);
    }
  }

  function roundTo(number, digits, towardZero = false) {
    const factor = 10 ** digits,
      rounder = towardZero ? Math.trunc : Math.round;
    return rounder(number * factor) / factor;
  }

  // DATE BASICS

  function isLeapYear(year) {
    return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
  }

  function daysInYear(year) {
    return isLeapYear(year) ? 366 : 365;
  }

  function daysInMonth(year, month) {
    const modMonth = floorMod(month - 1, 12) + 1,
      modYear = year + (month - modMonth) / 12;

    if (modMonth === 2) {
      return isLeapYear(modYear) ? 29 : 28;
    } else {
      return [31, null, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31][modMonth - 1];
    }
  }

  // convert a calendar object to a local timestamp (epoch, but with the offset baked in)
  function objToLocalTS(obj) {
    let d = Date.UTC(
      obj.year,
      obj.month - 1,
      obj.day,
      obj.hour,
      obj.minute,
      obj.second,
      obj.millisecond
    );

    // for legacy reasons, years between 0 and 99 are interpreted as 19XX; revert that
    if (obj.year < 100 && obj.year >= 0) {
      d = new Date(d);
      // set the month and day again, this is necessary because year 2000 is a leap year, but year 100 is not
      // so if obj.year is in 99, but obj.day makes it roll over into year 100,
      // the calculations done by Date.UTC are using year 2000 - which is incorrect
      d.setUTCFullYear(obj.year, obj.month - 1, obj.day);
    }
    return +d;
  }

  // adapted from moment.js: https://github.com/moment/moment/blob/000ac1800e620f770f4eb31b5ae908f6167b0ab2/src/lib/units/week-calendar-utils.js
  function firstWeekOffset(year, minDaysInFirstWeek, startOfWeek) {
    const fwdlw = isoWeekdayToLocal(dayOfWeek(year, 1, minDaysInFirstWeek), startOfWeek);
    return -fwdlw + minDaysInFirstWeek - 1;
  }

  function weeksInWeekYear(weekYear, minDaysInFirstWeek = 4, startOfWeek = 1) {
    const weekOffset = firstWeekOffset(weekYear, minDaysInFirstWeek, startOfWeek);
    const weekOffsetNext = firstWeekOffset(weekYear + 1, minDaysInFirstWeek, startOfWeek);
    return (daysInYear(weekYear) - weekOffset + weekOffsetNext) / 7;
  }

  function untruncateYear(year) {
    if (year > 99) {
      return year;
    } else return year > Settings.twoDigitCutoffYear ? 1900 + year : 2000 + year;
  }

  // PARSING

  function parseZoneInfo(ts, offsetFormat, locale, timeZone = null) {
    const date = new Date(ts),
      intlOpts = {
        hourCycle: "h23",
        year: "numeric",
        month: "2-digit",
        day: "2-digit",
        hour: "2-digit",
        minute: "2-digit",
      };

    if (timeZone) {
      intlOpts.timeZone = timeZone;
    }

    const modified = { timeZoneName: offsetFormat, ...intlOpts };

    const parsed = new Intl.DateTimeFormat(locale, modified)
      .formatToParts(date)
      .find((m) => m.type.toLowerCase() === "timezonename");
    return parsed ? parsed.value : null;
  }

  // signedOffset('-5', '30') -> -330
  function signedOffset(offHourStr, offMinuteStr) {
    let offHour = parseInt(offHourStr, 10);

    // don't || this because we want to preserve -0
    if (Number.isNaN(offHour)) {
      offHour = 0;
    }

    const offMin = parseInt(offMinuteStr, 10) || 0,
      offMinSigned = offHour < 0 || Object.is(offHour, -0) ? -offMin : offMin;
    return offHour * 60 + offMinSigned;
  }

  // COERCION

  function asNumber(value) {
    const numericValue = Number(value);
    if (typeof value === "boolean" || value === "" || Number.isNaN(numericValue))
      throw new InvalidArgumentError(`Invalid unit value ${value}`);
    return numericValue;
  }

  function normalizeObject(obj, normalizer) {
    const normalized = {};
    for (const u in obj) {
      if (hasOwnProperty(obj, u)) {
        const v = obj[u];
        if (v === undefined || v === null) continue;
        normalized[normalizer(u)] = asNumber(v);
      }
    }
    return normalized;
  }

  /**
   * Returns the offset's value as a string
   * @param {number} ts - Epoch milliseconds for which to get the offset
   * @param {string} format - What style of offset to return.
   *                          Accepts 'narrow', 'short', or 'techie'. Returning '+6', '+06:00', or '+0600' respectively
   * @return {string}
   */
  function formatOffset(offset, format) {
    const hours = Math.trunc(Math.abs(offset / 60)),
      minutes = Math.trunc(Math.abs(offset % 60)),
      sign = offset >= 0 ? "+" : "-";

    switch (format) {
      case "short":
        return `${sign}${padStart(hours, 2)}:${padStart(minutes, 2)}`;
      case "narrow":
        return `${sign}${hours}${minutes > 0 ? `:${minutes}` : ""}`;
      case "techie":
        return `${sign}${padStart(hours, 2)}${padStart(minutes, 2)}`;
      default:
        throw new RangeError(`Value format ${format} is out of range for property format`);
    }
  }

  function timeObject(obj) {
    return pick(obj, ["hour", "minute", "second", "millisecond"]);
  }

  /**
   * @private
   */

  const monthsLong = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December",
  ];

  const monthsShort = [
    "Jan",
    "Feb",
    "Mar",
    "Apr",
    "May",
    "Jun",
    "Jul",
    "Aug",
    "Sep",
    "Oct",
    "Nov",
    "Dec",
  ];

  const monthsNarrow = ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"];

  function months(length) {
    switch (length) {
      case "narrow":
        return [...monthsNarrow];
      case "short":
        return [...monthsShort];
      case "long":
        return [...monthsLong];
      case "numeric":
        return ["1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"];
      case "2-digit":
        return ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];
      default:
        return null;
    }
  }

  const weekdaysLong = [
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    "Sunday",
  ];

  const weekdaysShort = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];

  const weekdaysNarrow = ["M", "T", "W", "T", "F", "S", "S"];

  function weekdays(length) {
    switch (length) {
      case "narrow":
        return [...weekdaysNarrow];
      case "short":
        return [...weekdaysShort];
      case "long":
        return [...weekdaysLong];
      case "numeric":
        return ["1", "2", "3", "4", "5", "6", "7"];
      default:
        return null;
    }
  }

  const meridiems = ["AM", "PM"];

  const erasLong = ["Before Christ", "Anno Domini"];

  const erasShort = ["BC", "AD"];

  const erasNarrow = ["B", "A"];

  function eras(length) {
    switch (length) {
      case "narrow":
        return [...erasNarrow];
      case "short":
        return [...erasShort];
      case "long":
        return [...erasLong];
      default:
        return null;
    }
  }

  function meridiemForDateTime(dt) {
    return meridiems[dt.hour < 12 ? 0 : 1];
  }

  function weekdayForDateTime(dt, length) {
    return weekdays(length)[dt.weekday - 1];
  }

  function monthForDateTime(dt, length) {
    return months(length)[dt.month - 1];
  }

  function eraForDateTime(dt, length) {
    return eras(length)[dt.year < 0 ? 0 : 1];
  }

  function formatRelativeTime(unit, count, numeric = "always", narrow = false) {
    const units = {
      years: ["year", "yr."],
      quarters: ["quarter", "qtr."],
      months: ["month", "mo."],
      weeks: ["week", "wk."],
      days: ["day", "day", "days"],
      hours: ["hour", "hr."],
      minutes: ["minute", "min."],
      seconds: ["second", "sec."],
    };

    const lastable = ["hours", "minutes", "seconds"].indexOf(unit) === -1;

    if (numeric === "auto" && lastable) {
      const isDay = unit === "days";
      switch (count) {
        case 1:
          return isDay ? "tomorrow" : `next ${units[unit][0]}`;
        case -1:
          return isDay ? "yesterday" : `last ${units[unit][0]}`;
        case 0:
          return isDay ? "today" : `this ${units[unit][0]}`;
      }
    }

    const isInPast = Object.is(count, -0) || count < 0,
      fmtValue = Math.abs(count),
      singular = fmtValue === 1,
      lilUnits = units[unit],
      fmtUnit = narrow
        ? singular
          ? lilUnits[1]
          : lilUnits[2] || lilUnits[1]
        : singular
        ? units[unit][0]
        : unit;
    return isInPast ? `${fmtValue} ${fmtUnit} ago` : `in ${fmtValue} ${fmtUnit}`;
  }

  function stringifyTokens(splits, tokenToString) {
    let s = "";
    for (const token of splits) {
      if (token.literal) {
        s += token.val;
      } else {
        s += tokenToString(token.val);
      }
    }
    return s;
  }

  const macroTokenToFormatOpts = {
    D: DATE_SHORT,
    DD: DATE_MED,
    DDD: DATE_FULL,
    DDDD: DATE_HUGE,
    t: TIME_SIMPLE,
    tt: TIME_WITH_SECONDS,
    ttt: TIME_WITH_SHORT_OFFSET,
    tttt: TIME_WITH_LONG_OFFSET,
    T: TIME_24_SIMPLE,
    TT: TIME_24_WITH_SECONDS,
    TTT: TIME_24_WITH_SHORT_OFFSET,
    TTTT: TIME_24_WITH_LONG_OFFSET,
    f: DATETIME_SHORT,
    ff: DATETIME_MED,
    fff: DATETIME_FULL,
    ffff: DATETIME_HUGE,
    F: DATETIME_SHORT_WITH_SECONDS,
    FF: DATETIME_MED_WITH_SECONDS,
    FFF: DATETIME_FULL_WITH_SECONDS,
    FFFF: DATETIME_HUGE_WITH_SECONDS,
  };

  /**
   * @private
   */

  class Formatter {
    static create(locale, opts = {}) {
      return new Formatter(locale, opts);
    }

    static parseFormat(fmt) {
      // white-space is always considered a literal in user-provided formats
      // the " " token has a special meaning (see unitForToken)

      let current = null,
        currentFull = "",
        bracketed = false;
      const splits = [];
      for (let i = 0; i < fmt.length; i++) {
        const c = fmt.charAt(i);
        if (c === "'") {
          if (currentFull.length > 0) {
            splits.push({ literal: bracketed || /^\s+$/.test(currentFull), val: currentFull });
          }
          current = null;
          currentFull = "";
          bracketed = !bracketed;
        } else if (bracketed) {
          currentFull += c;
        } else if (c === current) {
          currentFull += c;
        } else {
          if (currentFull.length > 0) {
            splits.push({ literal: /^\s+$/.test(currentFull), val: currentFull });
          }
          currentFull = c;
          current = c;
        }
      }

      if (currentFull.length > 0) {
        splits.push({ literal: bracketed || /^\s+$/.test(currentFull), val: currentFull });
      }

      return splits;
    }

    static macroTokenToFormatOpts(token) {
      return macroTokenToFormatOpts[token];
    }

    constructor(locale, formatOpts) {
      this.opts = formatOpts;
      this.loc = locale;
      this.systemLoc = null;
    }

    formatWithSystemDefault(dt, opts) {
      if (this.systemLoc === null) {
        this.systemLoc = this.loc.redefaultToSystem();
      }
      const df = this.systemLoc.dtFormatter(dt, { ...this.opts, ...opts });
      return df.format();
    }

    dtFormatter(dt, opts = {}) {
      return this.loc.dtFormatter(dt, { ...this.opts, ...opts });
    }

    formatDateTime(dt, opts) {
      return this.dtFormatter(dt, opts).format();
    }

    formatDateTimeParts(dt, opts) {
      return this.dtFormatter(dt, opts).formatToParts();
    }

    formatInterval(interval, opts) {
      const df = this.dtFormatter(interval.start, opts);
      return df.dtf.formatRange(interval.start.toJSDate(), interval.end.toJSDate());
    }

    resolvedOptions(dt, opts) {
      return this.dtFormatter(dt, opts).resolvedOptions();
    }

    num(n, p = 0) {
      // we get some perf out of doing this here, annoyingly
      if (this.opts.forceSimple) {
        return padStart(n, p);
      }

      const opts = { ...this.opts };

      if (p > 0) {
        opts.padTo = p;
      }

      return this.loc.numberFormatter(opts).format(n);
    }

    formatDateTimeFromString(dt, fmt) {
      const knownEnglish = this.loc.listingMode() === "en",
        useDateTimeFormatter = this.loc.outputCalendar && this.loc.outputCalendar !== "gregory",
        string = (opts, extract) => this.loc.extract(dt, opts, extract),
        formatOffset = (opts) => {
          if (dt.isOffsetFixed && dt.offset === 0 && opts.allowZ) {
            return "Z";
          }

          return dt.isValid ? dt.zone.formatOffset(dt.ts, opts.format) : "";
        },
        meridiem = () =>
          knownEnglish
            ? meridiemForDateTime(dt)
            : string({ hour: "numeric", hourCycle: "h12" }, "dayperiod"),
        month = (length, standalone) =>
          knownEnglish
            ? monthForDateTime(dt, length)
            : string(standalone ? { month: length } : { month: length, day: "numeric" }, "month"),
        weekday = (length, standalone) =>
          knownEnglish
            ? weekdayForDateTime(dt, length)
            : string(
                standalone ? { weekday: length } : { weekday: length, month: "long", day: "numeric" },
                "weekday"
              ),
        maybeMacro = (token) => {
          const formatOpts = Formatter.macroTokenToFormatOpts(token);
          if (formatOpts) {
            return this.formatWithSystemDefault(dt, formatOpts);
          } else {
            return token;
          }
        },
        era = (length) =>
          knownEnglish ? eraForDateTime(dt, length) : string({ era: length }, "era"),
        tokenToString = (token) => {
          // Where possible: https://cldr.unicode.org/translation/date-time/date-time-symbols
          switch (token) {
            // ms
            case "S":
              return this.num(dt.millisecond);
            case "u":
            // falls through
            case "SSS":
              return this.num(dt.millisecond, 3);
            // seconds
            case "s":
              return this.num(dt.second);
            case "ss":
              return this.num(dt.second, 2);
            // fractional seconds
            case "uu":
              return this.num(Math.floor(dt.millisecond / 10), 2);
            case "uuu":
              return this.num(Math.floor(dt.millisecond / 100));
            // minutes
            case "m":
              return this.num(dt.minute);
            case "mm":
              return this.num(dt.minute, 2);
            // hours
            case "h":
              return this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12);
            case "hh":
              return this.num(dt.hour % 12 === 0 ? 12 : dt.hour % 12, 2);
            case "H":
              return this.num(dt.hour);
            case "HH":
              return this.num(dt.hour, 2);
            // offset
            case "Z":
              // like +6
              return formatOffset({ format: "narrow", allowZ: this.opts.allowZ });
            case "ZZ":
              // like +06:00
              return formatOffset({ format: "short", allowZ: this.opts.allowZ });
            case "ZZZ":
              // like +0600
              return formatOffset({ format: "techie", allowZ: this.opts.allowZ });
            case "ZZZZ":
              // like EST
              return dt.zone.offsetName(dt.ts, { format: "short", locale: this.loc.locale });
            case "ZZZZZ":
              // like Eastern Standard Time
              return dt.zone.offsetName(dt.ts, { format: "long", locale: this.loc.locale });
            // zone
            case "z":
              // like America/New_York
              return dt.zoneName;
            // meridiems
            case "a":
              return meridiem();
            // dates
            case "d":
              return useDateTimeFormatter ? string({ day: "numeric" }, "day") : this.num(dt.day);
            case "dd":
              return useDateTimeFormatter ? string({ day: "2-digit" }, "day") : this.num(dt.day, 2);
            // weekdays - standalone
            case "c":
              // like 1
              return this.num(dt.weekday);
            case "ccc":
              // like 'Tues'
              return weekday("short", true);
            case "cccc":
              // like 'Tuesday'
              return weekday("long", true);
            case "ccccc":
              // like 'T'
              return weekday("narrow", true);
            // weekdays - format
            case "E":
              // like 1
              return this.num(dt.weekday);
            case "EEE":
              // like 'Tues'
              return weekday("short", false);
            case "EEEE":
              // like 'Tuesday'
              return weekday("long", false);
            case "EEEEE":
              // like 'T'
              return weekday("narrow", false);
            // months - standalone
            case "L":
              // like 1
              return useDateTimeFormatter
                ? string({ month: "numeric", day: "numeric" }, "month")
                : this.num(dt.month);
            case "LL":
              // like 01, doesn't seem to work
              return useDateTimeFormatter
                ? string({ month: "2-digit", day: "numeric" }, "month")
                : this.num(dt.month, 2);
            case "LLL":
              // like Jan
              return month("short", true);
            case "LLLL":
              // like January
              return month("long", true);
            case "LLLLL":
              // like J
              return month("narrow", true);
            // months - format
            case "M":
              // like 1
              return useDateTimeFormatter
                ? string({ month: "numeric" }, "month")
                : this.num(dt.month);
            case "MM":
              // like 01
              return useDateTimeFormatter
                ? string({ month: "2-digit" }, "month")
                : this.num(dt.month, 2);
            case "MMM":
              // like Jan
              return month("short", false);
            case "MMMM":
              // like January
              return month("long", false);
            case "MMMMM":
              // like J
              return month("narrow", false);
            // years
            case "y":
              // like 2014
              return useDateTimeFormatter ? string({ year: "numeric" }, "year") : this.num(dt.year);
            case "yy":
              // like 14
              return useDateTimeFormatter
                ? string({ year: "2-digit" }, "year")
                : this.num(dt.year.toString().slice(-2), 2);
            case "yyyy":
              // like 0012
              return useDateTimeFormatter
                ? string({ year: "numeric" }, "year")
                : this.num(dt.year, 4);
            case "yyyyyy":
              // like 000012
              return useDateTimeFormatter
                ? string({ year: "numeric" }, "year")
                : this.num(dt.year, 6);
            // eras
            case "G":
              // like AD
              return era("short");
            case "GG":
              // like Anno Domini
              return era("long");
            case "GGGGG":
              return era("narrow");
            case "kk":
              return this.num(dt.weekYear.toString().slice(-2), 2);
            case "kkkk":
              return this.num(dt.weekYear, 4);
            case "W":
              return this.num(dt.weekNumber);
            case "WW":
              return this.num(dt.weekNumber, 2);
            case "n":
              return this.num(dt.localWeekNumber);
            case "nn":
              return this.num(dt.localWeekNumber, 2);
            case "ii":
              return this.num(dt.localWeekYear.toString().slice(-2), 2);
            case "iiii":
              return this.num(dt.localWeekYear, 4);
            case "o":
              return this.num(dt.ordinal);
            case "ooo":
              return this.num(dt.ordinal, 3);
            case "q":
              // like 1
              return this.num(dt.quarter);
            case "qq":
              // like 01
              return this.num(dt.quarter, 2);
            case "X":
              return this.num(Math.floor(dt.ts / 1000));
            case "x":
              return this.num(dt.ts);
            default:
              return maybeMacro(token);
          }
        };

      return stringifyTokens(Formatter.parseFormat(fmt), tokenToString);
    }

    formatDurationFromString(dur, fmt) {
      const tokenToField = (token) => {
          switch (token[0]) {
            case "S":
              return "millisecond";
            case "s":
              return "second";
            case "m":
              return "minute";
            case "h":
              return "hour";
            case "d":
              return "day";
            case "w":
              return "week";
            case "M":
              return "month";
            case "y":
              return "year";
            default:
              return null;
          }
        },
        tokenToString = (lildur) => (token) => {
          const mapped = tokenToField(token);
          if (mapped) {
            return this.num(lildur.get(mapped), token.length);
          } else {
            return token;
          }
        },
        tokens = Formatter.parseFormat(fmt),
        realTokens = tokens.reduce(
          (found, { literal, val }) => (literal ? found : found.concat(val)),
          []
        ),
        collapsed = dur.shiftTo(...realTokens.map(tokenToField).filter((t) => t));
      return stringifyTokens(tokens, tokenToString(collapsed));
    }
  }

  /*
   * This file handles parsing for well-specified formats. Here's how it works:
   * Two things go into parsing: a regex to match with and an extractor to take apart the groups in the match.
   * An extractor is just a function that takes a regex match array and returns a { year: ..., month: ... } object
   * parse() does the work of executing the regex and applying the extractor. It takes multiple regex/extractor pairs to try in sequence.
   * Extractors can take a "cursor" representing the offset in the match to look at. This makes it easy to combine extractors.
   * combineExtractors() does the work of combining them, keeping track of the cursor through multiple extractions.
   * Some extractions are super dumb and simpleParse and fromStrings help DRY them.
   */

  const ianaRegex = /[A-Za-z_+-]{1,256}(?::?\/[A-Za-z0-9_+-]{1,256}(?:\/[A-Za-z0-9_+-]{1,256})?)?/;

  function combineRegexes(...regexes) {
    const full = regexes.reduce((f, r) => f + r.source, "");
    return RegExp(`^${full}$`);
  }

  function combineExtractors(...extractors) {
    return (m) =>
      extractors
        .reduce(
          ([mergedVals, mergedZone, cursor], ex) => {
            const [val, zone, next] = ex(m, cursor);
            return [{ ...mergedVals, ...val }, zone || mergedZone, next];
          },
          [{}, null, 1]
        )
        .slice(0, 2);
  }

  function parse$2(s, ...patterns) {
    if (s == null) {
      return [null, null];
    }

    for (const [regex, extractor] of patterns) {
      const m = regex.exec(s);
      if (m) {
        return extractor(m);
      }
    }
    return [null, null];
  }

  function simpleParse(...keys) {
    return (match, cursor) => {
      const ret = {};
      let i;

      for (i = 0; i < keys.length; i++) {
        ret[keys[i]] = parseInteger(match[cursor + i]);
      }
      return [ret, null, cursor + i];
    };
  }

  // ISO and SQL parsing
  const offsetRegex = /(?:(Z)|([+-]\d\d)(?::?(\d\d))?)/;
  const isoExtendedZone = `(?:${offsetRegex.source}?(?:\\[(${ianaRegex.source})\\])?)?`;
  const isoTimeBaseRegex = /(\d\d)(?::?(\d\d)(?::?(\d\d)(?:[.,](\d{1,30}))?)?)?/;
  const isoTimeRegex = RegExp(`${isoTimeBaseRegex.source}${isoExtendedZone}`);
  const isoTimeExtensionRegex = RegExp(`(?:T${isoTimeRegex.source})?`);
  const isoYmdRegex = /([+-]\d{6}|\d{4})(?:-?(\d\d)(?:-?(\d\d))?)?/;
  const isoWeekRegex = /(\d{4})-?W(\d\d)(?:-?(\d))?/;
  const isoOrdinalRegex = /(\d{4})-?(\d{3})/;
  const extractISOWeekData = simpleParse("weekYear", "weekNumber", "weekDay");
  const extractISOOrdinalData = simpleParse("year", "ordinal");
  const sqlYmdRegex = /(\d{4})-(\d\d)-(\d\d)/; // dumbed-down version of the ISO one
  const sqlTimeRegex = RegExp(
    `${isoTimeBaseRegex.source} ?(?:${offsetRegex.source}|(${ianaRegex.source}))?`
  );
  const sqlTimeExtensionRegex = RegExp(`(?: ${sqlTimeRegex.source})?`);

  function int$1(match, pos, fallback) {
    const m = match[pos];
    return isUndefined(m) ? fallback : parseInteger(m);
  }

  function extractISOYmd(match, cursor) {
    const item = {
      year: int$1(match, cursor),
      month: int$1(match, cursor + 1, 1),
      day: int$1(match, cursor + 2, 1),
    };

    return [item, null, cursor + 3];
  }

  function extractISOTime(match, cursor) {
    const item = {
      hours: int$1(match, cursor, 0),
      minutes: int$1(match, cursor + 1, 0),
      seconds: int$1(match, cursor + 2, 0),
      milliseconds: parseMillis(match[cursor + 3]),
    };

    return [item, null, cursor + 4];
  }

  function extractISOOffset(match, cursor) {
    const local = !match[cursor] && !match[cursor + 1],
      fullOffset = signedOffset(match[cursor + 1], match[cursor + 2]),
      zone = local ? null : FixedOffsetZone.instance(fullOffset);
    return [{}, zone, cursor + 3];
  }

  function extractIANAZone(match, cursor) {
    const zone = match[cursor] ? IANAZone.create(match[cursor]) : null;
    return [{}, zone, cursor + 1];
  }

  // ISO time parsing

  const isoTimeOnly = RegExp(`^T?${isoTimeBaseRegex.source}$`);

  // ISO duration parsing

  const isoDuration =
    /^-?P(?:(?:(-?\d{1,20}(?:\.\d{1,20})?)Y)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20}(?:\.\d{1,20})?)W)?(?:(-?\d{1,20}(?:\.\d{1,20})?)D)?(?:T(?:(-?\d{1,20}(?:\.\d{1,20})?)H)?(?:(-?\d{1,20}(?:\.\d{1,20})?)M)?(?:(-?\d{1,20})(?:[.,](-?\d{1,20}))?S)?)?)$/;

  function extractISODuration(match) {
    const [s, yearStr, monthStr, weekStr, dayStr, hourStr, minuteStr, secondStr, millisecondsStr] =
      match;

    const hasNegativePrefix = s[0] === "-";
    const negativeSeconds = secondStr && secondStr[0] === "-";

    const maybeNegate = (num, force = false) =>
      num !== undefined && (force || (num && hasNegativePrefix)) ? -num : num;

    return [
      {
        years: maybeNegate(parseFloating(yearStr)),
        months: maybeNegate(parseFloating(monthStr)),
        weeks: maybeNegate(parseFloating(weekStr)),
        days: maybeNegate(parseFloating(dayStr)),
        hours: maybeNegate(parseFloating(hourStr)),
        minutes: maybeNegate(parseFloating(minuteStr)),
        seconds: maybeNegate(parseFloating(secondStr), secondStr === "-0"),
        milliseconds: maybeNegate(parseMillis(millisecondsStr), negativeSeconds),
      },
    ];
  }

  // These are a little braindead. EDT *should* tell us that we're in, say, America/New_York
  // and not just that we're in -240 *right now*. But since I don't think these are used that often
  // I'm just going to ignore that
  const obsOffsets = {
    GMT: 0,
    EDT: -4 * 60,
    EST: -5 * 60,
    CDT: -5 * 60,
    CST: -6 * 60,
    MDT: -6 * 60,
    MST: -7 * 60,
    PDT: -7 * 60,
    PST: -8 * 60,
  };

  function fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr) {
    const result = {
      year: yearStr.length === 2 ? untruncateYear(parseInteger(yearStr)) : parseInteger(yearStr),
      month: monthsShort.indexOf(monthStr) + 1,
      day: parseInteger(dayStr),
      hour: parseInteger(hourStr),
      minute: parseInteger(minuteStr),
    };

    if (secondStr) result.second = parseInteger(secondStr);
    if (weekdayStr) {
      result.weekday =
        weekdayStr.length > 3
          ? weekdaysLong.indexOf(weekdayStr) + 1
          : weekdaysShort.indexOf(weekdayStr) + 1;
    }

    return result;
  }

  // RFC 2822/5322
  const rfc2822 =
    /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|(?:([+-]\d\d)(\d\d)))$/;

  function extractRFC2822(match) {
    const [
        ,
        weekdayStr,
        dayStr,
        monthStr,
        yearStr,
        hourStr,
        minuteStr,
        secondStr,
        obsOffset,
        milOffset,
        offHourStr,
        offMinuteStr,
      ] = match,
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);

    let offset;
    if (obsOffset) {
      offset = obsOffsets[obsOffset];
    } else if (milOffset) {
      offset = 0;
    } else {
      offset = signedOffset(offHourStr, offMinuteStr);
    }

    return [result, new FixedOffsetZone(offset)];
  }

  function preprocessRFC2822(s) {
    // Remove comments and folding whitespace and replace multiple-spaces with a single space
    return s
      .replace(/\([^()]*\)|[\n\t]/g, " ")
      .replace(/(\s\s+)/g, " ")
      .trim();
  }

  // http date

  const rfc1123 =
      /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun), (\d\d) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d{4}) (\d\d):(\d\d):(\d\d) GMT$/,
    rfc850 =
      /^(Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday), (\d\d)-(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)-(\d\d) (\d\d):(\d\d):(\d\d) GMT$/,
    ascii =
      /^(Mon|Tue|Wed|Thu|Fri|Sat|Sun) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) ( \d|\d\d) (\d\d):(\d\d):(\d\d) (\d{4})$/;

  function extractRFC1123Or850(match) {
    const [, weekdayStr, dayStr, monthStr, yearStr, hourStr, minuteStr, secondStr] = match,
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
    return [result, FixedOffsetZone.utcInstance];
  }

  function extractASCII(match) {
    const [, weekdayStr, monthStr, dayStr, hourStr, minuteStr, secondStr, yearStr] = match,
      result = fromStrings(weekdayStr, yearStr, monthStr, dayStr, hourStr, minuteStr, secondStr);
    return [result, FixedOffsetZone.utcInstance];
  }

  const isoYmdWithTimeExtensionRegex = combineRegexes(isoYmdRegex, isoTimeExtensionRegex);
  const isoWeekWithTimeExtensionRegex = combineRegexes(isoWeekRegex, isoTimeExtensionRegex);
  const isoOrdinalWithTimeExtensionRegex = combineRegexes(isoOrdinalRegex, isoTimeExtensionRegex);
  const isoTimeCombinedRegex = combineRegexes(isoTimeRegex);

  const extractISOYmdTimeAndOffset = combineExtractors(
    extractISOYmd,
    extractISOTime,
    extractISOOffset,
    extractIANAZone
  );
  const extractISOWeekTimeAndOffset = combineExtractors(
    extractISOWeekData,
    extractISOTime,
    extractISOOffset,
    extractIANAZone
  );
  const extractISOOrdinalDateAndTime = combineExtractors(
    extractISOOrdinalData,
    extractISOTime,
    extractISOOffset,
    extractIANAZone
  );
  const extractISOTimeAndOffset = combineExtractors(
    extractISOTime,
    extractISOOffset,
    extractIANAZone
  );

  /*
   * @private
   */

  function parseISODate(s) {
    return parse$2(
      s,
      [isoYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset],
      [isoWeekWithTimeExtensionRegex, extractISOWeekTimeAndOffset],
      [isoOrdinalWithTimeExtensionRegex, extractISOOrdinalDateAndTime],
      [isoTimeCombinedRegex, extractISOTimeAndOffset]
    );
  }

  function parseRFC2822Date(s) {
    return parse$2(preprocessRFC2822(s), [rfc2822, extractRFC2822]);
  }

  function parseHTTPDate(s) {
    return parse$2(
      s,
      [rfc1123, extractRFC1123Or850],
      [rfc850, extractRFC1123Or850],
      [ascii, extractASCII]
    );
  }

  function parseISODuration(s) {
    return parse$2(s, [isoDuration, extractISODuration]);
  }

  const extractISOTimeOnly = combineExtractors(extractISOTime);

  function parseISOTimeOnly(s) {
    return parse$2(s, [isoTimeOnly, extractISOTimeOnly]);
  }

  const sqlYmdWithTimeExtensionRegex = combineRegexes(sqlYmdRegex, sqlTimeExtensionRegex);
  const sqlTimeCombinedRegex = combineRegexes(sqlTimeRegex);

  const extractISOTimeOffsetAndIANAZone = combineExtractors(
    extractISOTime,
    extractISOOffset,
    extractIANAZone
  );

  function parseSQL(s) {
    return parse$2(
      s,
      [sqlYmdWithTimeExtensionRegex, extractISOYmdTimeAndOffset],
      [sqlTimeCombinedRegex, extractISOTimeOffsetAndIANAZone]
    );
  }

  const INVALID$3 = "Invalid Duration";

  // unit conversion constants
  const lowOrderMatrix = {
      weeks: {
        days: 7,
        hours: 7 * 24,
        minutes: 7 * 24 * 60,
        seconds: 7 * 24 * 60 * 60,
        milliseconds: 7 * 24 * 60 * 60 * 1000,
      },
      days: {
        hours: 24,
        minutes: 24 * 60,
        seconds: 24 * 60 * 60,
        milliseconds: 24 * 60 * 60 * 1000,
      },
      hours: { minutes: 60, seconds: 60 * 60, milliseconds: 60 * 60 * 1000 },
      minutes: { seconds: 60, milliseconds: 60 * 1000 },
      seconds: { milliseconds: 1000 },
    },
    casualMatrix = {
      years: {
        quarters: 4,
        months: 12,
        weeks: 52,
        days: 365,
        hours: 365 * 24,
        minutes: 365 * 24 * 60,
        seconds: 365 * 24 * 60 * 60,
        milliseconds: 365 * 24 * 60 * 60 * 1000,
      },
      quarters: {
        months: 3,
        weeks: 13,
        days: 91,
        hours: 91 * 24,
        minutes: 91 * 24 * 60,
        seconds: 91 * 24 * 60 * 60,
        milliseconds: 91 * 24 * 60 * 60 * 1000,
      },
      months: {
        weeks: 4,
        days: 30,
        hours: 30 * 24,
        minutes: 30 * 24 * 60,
        seconds: 30 * 24 * 60 * 60,
        milliseconds: 30 * 24 * 60 * 60 * 1000,
      },

      ...lowOrderMatrix,
    },
    daysInYearAccurate = 146097.0 / 400,
    daysInMonthAccurate = 146097.0 / 4800,
    accurateMatrix = {
      years: {
        quarters: 4,
        months: 12,
        weeks: daysInYearAccurate / 7,
        days: daysInYearAccurate,
        hours: daysInYearAccurate * 24,
        minutes: daysInYearAccurate * 24 * 60,
        seconds: daysInYearAccurate * 24 * 60 * 60,
        milliseconds: daysInYearAccurate * 24 * 60 * 60 * 1000,
      },
      quarters: {
        months: 3,
        weeks: daysInYearAccurate / 28,
        days: daysInYearAccurate / 4,
        hours: (daysInYearAccurate * 24) / 4,
        minutes: (daysInYearAccurate * 24 * 60) / 4,
        seconds: (daysInYearAccurate * 24 * 60 * 60) / 4,
        milliseconds: (daysInYearAccurate * 24 * 60 * 60 * 1000) / 4,
      },
      months: {
        weeks: daysInMonthAccurate / 7,
        days: daysInMonthAccurate,
        hours: daysInMonthAccurate * 24,
        minutes: daysInMonthAccurate * 24 * 60,
        seconds: daysInMonthAccurate * 24 * 60 * 60,
        milliseconds: daysInMonthAccurate * 24 * 60 * 60 * 1000,
      },
      ...lowOrderMatrix,
    };

  // units ordered by size
  const orderedUnits$1 = [
    "years",
    "quarters",
    "months",
    "weeks",
    "days",
    "hours",
    "minutes",
    "seconds",
    "milliseconds",
  ];

  const reverseUnits = orderedUnits$1.slice(0).reverse();

  // clone really means "create another instance just like this one, but with these changes"
  function clone$3(dur, alts, clear = false) {
    // deep merge for vals
    const conf = {
      values: clear ? alts.values : { ...dur.values, ...(alts.values || {}) },
      loc: dur.loc.clone(alts.loc),
      conversionAccuracy: alts.conversionAccuracy || dur.conversionAccuracy,
      matrix: alts.matrix || dur.matrix,
    };
    return new Duration(conf);
  }

  function durationToMillis(matrix, vals) {
    let sum = vals.milliseconds ?? 0;
    for (const unit of reverseUnits.slice(1)) {
      if (vals[unit]) {
        sum += vals[unit] * matrix[unit]["milliseconds"];
      }
    }
    return sum;
  }

  // NB: mutates parameters
  function normalizeValues(matrix, vals) {
    // the logic below assumes the overall value of the duration is positive
    // if this is not the case, factor is used to make it so
    const factor = durationToMillis(matrix, vals) < 0 ? -1 : 1;

    orderedUnits$1.reduceRight((previous, current) => {
      if (!isUndefined(vals[current])) {
        if (previous) {
          const previousVal = vals[previous] * factor;
          const conv = matrix[current][previous];

          // if (previousVal < 0):
          // lower order unit is negative (e.g. { years: 2, days: -2 })
          // normalize this by reducing the higher order unit by the appropriate amount
          // and increasing the lower order unit
          // this can never make the higher order unit negative, because this function only operates
          // on positive durations, so the amount of time represented by the lower order unit cannot
          // be larger than the higher order unit
          // else:
          // lower order unit is positive (e.g. { years: 2, days: 450 } or { years: -2, days: 450 })
          // in this case we attempt to convert as much as possible from the lower order unit into
          // the higher order one
          //
          // Math.floor takes care of both of these cases, rounding away from 0
          // if previousVal < 0 it makes the absolute value larger
          // if previousVal >= it makes the absolute value smaller
          const rollUp = Math.floor(previousVal / conv);
          vals[current] += rollUp * factor;
          vals[previous] -= rollUp * conv * factor;
        }
        return current;
      } else {
        return previous;
      }
    }, null);

    // try to convert any decimals into smaller units if possible
    // for example for { years: 2.5, days: 0, seconds: 0 } we want to get { years: 2, days: 182, hours: 12 }
    orderedUnits$1.reduce((previous, current) => {
      if (!isUndefined(vals[current])) {
        if (previous) {
          const fraction = vals[previous] % 1;
          vals[previous] -= fraction;
          vals[current] += fraction * matrix[previous][current];
        }
        return current;
      } else {
        return previous;
      }
    }, null);
  }

  // Remove all properties with a value of 0 from an object
  function removeZeroes(vals) {
    const newVals = {};
    for (const [key, value] of Object.entries(vals)) {
      if (value !== 0) {
        newVals[key] = value;
      }
    }
    return newVals;
  }

  /**
   * A Duration object represents a period of time, like "2 months" or "1 day, 1 hour". Conceptually, it's just a map of units to their quantities, accompanied by some additional configuration and methods for creating, parsing, interrogating, transforming, and formatting them. They can be used on their own or in conjunction with other Luxon types; for example, you can use {@link DateTime#plus} to add a Duration object to a DateTime, producing another DateTime.
   *
   * Here is a brief overview of commonly used methods and getters in Duration:
   *
   * * **Creation** To create a Duration, use {@link Duration.fromMillis}, {@link Duration.fromObject}, or {@link Duration.fromISO}.
   * * **Unit values** See the {@link Duration#years}, {@link Duration#months}, {@link Duration#weeks}, {@link Duration#days}, {@link Duration#hours}, {@link Duration#minutes}, {@link Duration#seconds}, {@link Duration#milliseconds} accessors.
   * * **Configuration** See  {@link Duration#locale} and {@link Duration#numberingSystem} accessors.
   * * **Transformation** To create new Durations out of old ones use {@link Duration#plus}, {@link Duration#minus}, {@link Duration#normalize}, {@link Duration#set}, {@link Duration#reconfigure}, {@link Duration#shiftTo}, and {@link Duration#negate}.
   * * **Output** To convert the Duration into other representations, see {@link Duration#as}, {@link Duration#toISO}, {@link Duration#toFormat}, and {@link Duration#toJSON}
   *
   * There's are more methods documented below. In addition, for more information on subtler topics like internationalization and validity, see the external documentation.
   */
  class Duration {
    /**
     * @private
     */
    constructor(config) {
      const accurate = config.conversionAccuracy === "longterm" || false;
      let matrix = accurate ? accurateMatrix : casualMatrix;

      if (config.matrix) {
        matrix = config.matrix;
      }

      /**
       * @access private
       */
      this.values = config.values;
      /**
       * @access private
       */
      this.loc = config.loc || Locale.create();
      /**
       * @access private
       */
      this.conversionAccuracy = accurate ? "longterm" : "casual";
      /**
       * @access private
       */
      this.invalid = config.invalid || null;
      /**
       * @access private
       */
      this.matrix = matrix;
      /**
       * @access private
       */
      this.isLuxonDuration = true;
    }

    /**
     * Create Duration from a number of milliseconds.
     * @param {number} count of milliseconds
     * @param {Object} opts - options for parsing
     * @param {string} [opts.locale='en-US'] - the locale to use
     * @param {string} opts.numberingSystem - the numbering system to use
     * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
     * @return {Duration}
     */
    static fromMillis(count, opts) {
      return Duration.fromObject({ milliseconds: count }, opts);
    }

    /**
     * Create a Duration from a JavaScript object with keys like 'years' and 'hours'.
     * If this object is empty then a zero milliseconds duration is returned.
     * @param {Object} obj - the object to create the DateTime from
     * @param {number} obj.years
     * @param {number} obj.quarters
     * @param {number} obj.months
     * @param {number} obj.weeks
     * @param {number} obj.days
     * @param {number} obj.hours
     * @param {number} obj.minutes
     * @param {number} obj.seconds
     * @param {number} obj.milliseconds
     * @param {Object} [opts=[]] - options for creating this Duration
     * @param {string} [opts.locale='en-US'] - the locale to use
     * @param {string} opts.numberingSystem - the numbering system to use
     * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
     * @param {string} [opts.matrix=Object] - the custom conversion system to use
     * @return {Duration}
     */
    static fromObject(obj, opts = {}) {
      if (obj == null || typeof obj !== "object") {
        throw new InvalidArgumentError(
          `Duration.fromObject: argument expected to be an object, got ${
          obj === null ? "null" : typeof obj
        }`
        );
      }

      return new Duration({
        values: normalizeObject(obj, Duration.normalizeUnit),
        loc: Locale.fromObject(opts),
        conversionAccuracy: opts.conversionAccuracy,
        matrix: opts.matrix,
      });
    }

    /**
     * Create a Duration from DurationLike.
     *
     * @param {Object | number | Duration} durationLike
     * One of:
     * - object with keys like 'years' and 'hours'.
     * - number representing milliseconds
     * - Duration instance
     * @return {Duration}
     */
    static fromDurationLike(durationLike) {
      if (isNumber$1(durationLike)) {
        return Duration.fromMillis(durationLike);
      } else if (Duration.isDuration(durationLike)) {
        return durationLike;
      } else if (typeof durationLike === "object") {
        return Duration.fromObject(durationLike);
      } else {
        throw new InvalidArgumentError(
          `Unknown duration argument ${durationLike} of type ${typeof durationLike}`
        );
      }
    }

    /**
     * Create a Duration from an ISO 8601 duration string.
     * @param {string} text - text to parse
     * @param {Object} opts - options for parsing
     * @param {string} [opts.locale='en-US'] - the locale to use
     * @param {string} opts.numberingSystem - the numbering system to use
     * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
     * @param {string} [opts.matrix=Object] - the preset conversion system to use
     * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
     * @example Duration.fromISO('P3Y6M1W4DT12H30M5S').toObject() //=> { years: 3, months: 6, weeks: 1, days: 4, hours: 12, minutes: 30, seconds: 5 }
     * @example Duration.fromISO('PT23H').toObject() //=> { hours: 23 }
     * @example Duration.fromISO('P5Y3M').toObject() //=> { years: 5, months: 3 }
     * @return {Duration}
     */
    static fromISO(text, opts) {
      const [parsed] = parseISODuration(text);
      if (parsed) {
        return Duration.fromObject(parsed, opts);
      } else {
        return Duration.invalid("unparsable", `the input "${text}" can't be parsed as ISO 8601`);
      }
    }

    /**
     * Create a Duration from an ISO 8601 time string.
     * @param {string} text - text to parse
     * @param {Object} opts - options for parsing
     * @param {string} [opts.locale='en-US'] - the locale to use
     * @param {string} opts.numberingSystem - the numbering system to use
     * @param {string} [opts.conversionAccuracy='casual'] - the preset conversion system to use
     * @param {string} [opts.matrix=Object] - the conversion system to use
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     * @example Duration.fromISOTime('11:22:33.444').toObject() //=> { hours: 11, minutes: 22, seconds: 33, milliseconds: 444 }
     * @example Duration.fromISOTime('11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
     * @example Duration.fromISOTime('T11:00').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
     * @example Duration.fromISOTime('1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
     * @example Duration.fromISOTime('T1100').toObject() //=> { hours: 11, minutes: 0, seconds: 0 }
     * @return {Duration}
     */
    static fromISOTime(text, opts) {
      const [parsed] = parseISOTimeOnly(text);
      if (parsed) {
        return Duration.fromObject(parsed, opts);
      } else {
        return Duration.invalid("unparsable", `the input "${text}" can't be parsed as ISO 8601`);
      }
    }

    /**
     * Create an invalid Duration.
     * @param {string} reason - simple string of why this datetime is invalid. Should not contain parameters or anything else data-dependent
     * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
     * @return {Duration}
     */
    static invalid(reason, explanation = null) {
      if (!reason) {
        throw new InvalidArgumentError("need to specify a reason the Duration is invalid");
      }

      const invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

      if (Settings.throwOnInvalid) {
        throw new InvalidDurationError(invalid);
      } else {
        return new Duration({ invalid });
      }
    }

    /**
     * @private
     */
    static normalizeUnit(unit) {
      const normalized = {
        year: "years",
        years: "years",
        quarter: "quarters",
        quarters: "quarters",
        month: "months",
        months: "months",
        week: "weeks",
        weeks: "weeks",
        day: "days",
        days: "days",
        hour: "hours",
        hours: "hours",
        minute: "minutes",
        minutes: "minutes",
        second: "seconds",
        seconds: "seconds",
        millisecond: "milliseconds",
        milliseconds: "milliseconds",
      }[unit ? unit.toLowerCase() : unit];

      if (!normalized) throw new InvalidUnitError(unit);

      return normalized;
    }

    /**
     * Check if an object is a Duration. Works across context boundaries
     * @param {object} o
     * @return {boolean}
     */
    static isDuration(o) {
      return (o && o.isLuxonDuration) || false;
    }

    /**
     * Get  the locale of a Duration, such 'en-GB'
     * @type {string}
     */
    get locale() {
      return this.isValid ? this.loc.locale : null;
    }

    /**
     * Get the numbering system of a Duration, such 'beng'. The numbering system is used when formatting the Duration
     *
     * @type {string}
     */
    get numberingSystem() {
      return this.isValid ? this.loc.numberingSystem : null;
    }

    /**
     * Returns a string representation of this Duration formatted according to the specified format string. You may use these tokens:
     * * `S` for milliseconds
     * * `s` for seconds
     * * `m` for minutes
     * * `h` for hours
     * * `d` for days
     * * `w` for weeks
     * * `M` for months
     * * `y` for years
     * Notes:
     * * Add padding by repeating the token, e.g. "yy" pads the years to two digits, "hhhh" pads the hours out to four digits
     * * Tokens can be escaped by wrapping with single quotes.
     * * The duration will be converted to the set of units in the format string using {@link Duration#shiftTo} and the Durations's conversion accuracy setting.
     * @param {string} fmt - the format string
     * @param {Object} opts - options
     * @param {boolean} [opts.floor=true] - floor numerical values
     * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("y d s") //=> "1 6 2"
     * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("yy dd sss") //=> "01 06 002"
     * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toFormat("M S") //=> "12 518402000"
     * @return {string}
     */
    toFormat(fmt, opts = {}) {
      // reverse-compat since 1.2; we always round down now, never up, and we do it by default
      const fmtOpts = {
        ...opts,
        floor: opts.round !== false && opts.floor !== false,
      };
      return this.isValid
        ? Formatter.create(this.loc, fmtOpts).formatDurationFromString(this, fmt)
        : INVALID$3;
    }

    /**
     * Returns a string representation of a Duration with all units included.
     * To modify its behavior, use `listStyle` and any Intl.NumberFormat option, though `unitDisplay` is especially relevant.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/NumberFormat/NumberFormat#options
     * @param {Object} opts - Formatting options. Accepts the same keys as the options parameter of the native `Intl.NumberFormat` constructor, as well as `listStyle`.
     * @param {string} [opts.listStyle='narrow'] - How to format the merged list. Corresponds to the `style` property of the options parameter of the native `Intl.ListFormat` constructor.
     * @example
     * ```js
     * var dur = Duration.fromObject({ days: 1, hours: 5, minutes: 6 })
     * dur.toHuman() //=> '1 day, 5 hours, 6 minutes'
     * dur.toHuman({ listStyle: "long" }) //=> '1 day, 5 hours, and 6 minutes'
     * dur.toHuman({ unitDisplay: "short" }) //=> '1 day, 5 hr, 6 min'
     * ```
     */
    toHuman(opts = {}) {
      if (!this.isValid) return INVALID$3;

      const l = orderedUnits$1
        .map((unit) => {
          const val = this.values[unit];
          if (isUndefined(val)) {
            return null;
          }
          return this.loc
            .numberFormatter({ style: "unit", unitDisplay: "long", ...opts, unit: unit.slice(0, -1) })
            .format(val);
        })
        .filter((n) => n);

      return this.loc
        .listFormatter({ type: "conjunction", style: opts.listStyle || "narrow", ...opts })
        .format(l);
    }

    /**
     * Returns a JavaScript object with this Duration's values.
     * @example Duration.fromObject({ years: 1, days: 6, seconds: 2 }).toObject() //=> { years: 1, days: 6, seconds: 2 }
     * @return {Object}
     */
    toObject() {
      if (!this.isValid) return {};
      return { ...this.values };
    }

    /**
     * Returns an ISO 8601-compliant string representation of this Duration.
     * @see https://en.wikipedia.org/wiki/ISO_8601#Durations
     * @example Duration.fromObject({ years: 3, seconds: 45 }).toISO() //=> 'P3YT45S'
     * @example Duration.fromObject({ months: 4, seconds: 45 }).toISO() //=> 'P4MT45S'
     * @example Duration.fromObject({ months: 5 }).toISO() //=> 'P5M'
     * @example Duration.fromObject({ minutes: 5 }).toISO() //=> 'PT5M'
     * @example Duration.fromObject({ milliseconds: 6 }).toISO() //=> 'PT0.006S'
     * @return {string}
     */
    toISO() {
      // we could use the formatter, but this is an easier way to get the minimum string
      if (!this.isValid) return null;

      let s = "P";
      if (this.years !== 0) s += this.years + "Y";
      if (this.months !== 0 || this.quarters !== 0) s += this.months + this.quarters * 3 + "M";
      if (this.weeks !== 0) s += this.weeks + "W";
      if (this.days !== 0) s += this.days + "D";
      if (this.hours !== 0 || this.minutes !== 0 || this.seconds !== 0 || this.milliseconds !== 0)
        s += "T";
      if (this.hours !== 0) s += this.hours + "H";
      if (this.minutes !== 0) s += this.minutes + "M";
      if (this.seconds !== 0 || this.milliseconds !== 0)
        // this will handle "floating point madness" by removing extra decimal places
        // https://stackoverflow.com/questions/588004/is-floating-point-math-broken
        s += roundTo(this.seconds + this.milliseconds / 1000, 3) + "S";
      if (s === "P") s += "T0S";
      return s;
    }

    /**
     * Returns an ISO 8601-compliant string representation of this Duration, formatted as a time of day.
     * Note that this will return null if the duration is invalid, negative, or equal to or greater than 24 hours.
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     * @param {Object} opts - options
     * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
     * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
     * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
     * @param {string} [opts.format='extended'] - choose between the basic and extended format
     * @example Duration.fromObject({ hours: 11 }).toISOTime() //=> '11:00:00.000'
     * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressMilliseconds: true }) //=> '11:00:00'
     * @example Duration.fromObject({ hours: 11 }).toISOTime({ suppressSeconds: true }) //=> '11:00'
     * @example Duration.fromObject({ hours: 11 }).toISOTime({ includePrefix: true }) //=> 'T11:00:00.000'
     * @example Duration.fromObject({ hours: 11 }).toISOTime({ format: 'basic' }) //=> '110000.000'
     * @return {string}
     */
    toISOTime(opts = {}) {
      if (!this.isValid) return null;

      const millis = this.toMillis();
      if (millis < 0 || millis >= 86400000) return null;

      opts = {
        suppressMilliseconds: false,
        suppressSeconds: false,
        includePrefix: false,
        format: "extended",
        ...opts,
        includeOffset: false,
      };

      const dateTime = DateTime.fromMillis(millis, { zone: "UTC" });
      return dateTime.toISOTime(opts);
    }

    /**
     * Returns an ISO 8601 representation of this Duration appropriate for use in JSON.
     * @return {string}
     */
    toJSON() {
      return this.toISO();
    }

    /**
     * Returns an ISO 8601 representation of this Duration appropriate for use in debugging.
     * @return {string}
     */
    toString() {
      return this.toISO();
    }

    /**
     * Returns a string representation of this Duration appropriate for the REPL.
     * @return {string}
     */
    [Symbol.for("nodejs.util.inspect.custom")]() {
      if (this.isValid) {
        return `Duration { values: ${JSON.stringify(this.values)} }`;
      } else {
        return `Duration { Invalid, reason: ${this.invalidReason} }`;
      }
    }

    /**
     * Returns an milliseconds value of this Duration.
     * @return {number}
     */
    toMillis() {
      if (!this.isValid) return NaN;

      return durationToMillis(this.matrix, this.values);
    }

    /**
     * Returns an milliseconds value of this Duration. Alias of {@link toMillis}
     * @return {number}
     */
    valueOf() {
      return this.toMillis();
    }

    /**
     * Make this Duration longer by the specified amount. Return a newly-constructed Duration.
     * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
     * @return {Duration}
     */
    plus(duration) {
      if (!this.isValid) return this;

      const dur = Duration.fromDurationLike(duration),
        result = {};

      for (const k of orderedUnits$1) {
        if (hasOwnProperty(dur.values, k) || hasOwnProperty(this.values, k)) {
          result[k] = dur.get(k) + this.get(k);
        }
      }

      return clone$3(this, { values: result }, true);
    }

    /**
     * Make this Duration shorter by the specified amount. Return a newly-constructed Duration.
     * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
     * @return {Duration}
     */
    minus(duration) {
      if (!this.isValid) return this;

      const dur = Duration.fromDurationLike(duration);
      return this.plus(dur.negate());
    }

    /**
     * Scale this Duration by the specified amount. Return a newly-constructed Duration.
     * @param {function} fn - The function to apply to each unit. Arity is 1 or 2: the value of the unit and, optionally, the unit name. Must return a number.
     * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits(x => x * 2) //=> { hours: 2, minutes: 60 }
     * @example Duration.fromObject({ hours: 1, minutes: 30 }).mapUnits((x, u) => u === "hours" ? x * 2 : x) //=> { hours: 2, minutes: 30 }
     * @return {Duration}
     */
    mapUnits(fn) {
      if (!this.isValid) return this;
      const result = {};
      for (const k of Object.keys(this.values)) {
        result[k] = asNumber(fn(this.values[k], k));
      }
      return clone$3(this, { values: result }, true);
    }

    /**
     * Get the value of unit.
     * @param {string} unit - a unit such as 'minute' or 'day'
     * @example Duration.fromObject({years: 2, days: 3}).get('years') //=> 2
     * @example Duration.fromObject({years: 2, days: 3}).get('months') //=> 0
     * @example Duration.fromObject({years: 2, days: 3}).get('days') //=> 3
     * @return {number}
     */
    get(unit) {
      return this[Duration.normalizeUnit(unit)];
    }

    /**
     * "Set" the values of specified units. Return a newly-constructed Duration.
     * @param {Object} values - a mapping of units to numbers
     * @example dur.set({ years: 2017 })
     * @example dur.set({ hours: 8, minutes: 30 })
     * @return {Duration}
     */
    set(values) {
      if (!this.isValid) return this;

      const mixed = { ...this.values, ...normalizeObject(values, Duration.normalizeUnit) };
      return clone$3(this, { values: mixed });
    }

    /**
     * "Set" the locale and/or numberingSystem.  Returns a newly-constructed Duration.
     * @example dur.reconfigure({ locale: 'en-GB' })
     * @return {Duration}
     */
    reconfigure({ locale, numberingSystem, conversionAccuracy, matrix } = {}) {
      const loc = this.loc.clone({ locale, numberingSystem });
      const opts = { loc, matrix, conversionAccuracy };
      return clone$3(this, opts);
    }

    /**
     * Return the length of the duration in the specified unit.
     * @param {string} unit - a unit such as 'minutes' or 'days'
     * @example Duration.fromObject({years: 1}).as('days') //=> 365
     * @example Duration.fromObject({years: 1}).as('months') //=> 12
     * @example Duration.fromObject({hours: 60}).as('days') //=> 2.5
     * @return {number}
     */
    as(unit) {
      return this.isValid ? this.shiftTo(unit).get(unit) : NaN;
    }

    /**
     * Reduce this Duration to its canonical representation in its current units.
     * Assuming the overall value of the Duration is positive, this means:
     * - excessive values for lower-order units are converted to higher-order units (if possible, see first and second example)
     * - negative lower-order units are converted to higher order units (there must be such a higher order unit, otherwise
     *   the overall value would be negative, see third example)
     * - fractional values for higher-order units are converted to lower-order units (if possible, see fourth example)
     *
     * If the overall value is negative, the result of this method is equivalent to `this.negate().normalize().negate()`.
     * @example Duration.fromObject({ years: 2, days: 5000 }).normalize().toObject() //=> { years: 15, days: 255 }
     * @example Duration.fromObject({ days: 5000 }).normalize().toObject() //=> { days: 5000 }
     * @example Duration.fromObject({ hours: 12, minutes: -45 }).normalize().toObject() //=> { hours: 11, minutes: 15 }
     * @example Duration.fromObject({ years: 2.5, days: 0, hours: 0 }).normalize().toObject() //=> { years: 2, days: 182, hours: 12 }
     * @return {Duration}
     */
    normalize() {
      if (!this.isValid) return this;
      const vals = this.toObject();
      normalizeValues(this.matrix, vals);
      return clone$3(this, { values: vals }, true);
    }

    /**
     * Rescale units to its largest representation
     * @example Duration.fromObject({ milliseconds: 90000 }).rescale().toObject() //=> { minutes: 1, seconds: 30 }
     * @return {Duration}
     */
    rescale() {
      if (!this.isValid) return this;
      const vals = removeZeroes(this.normalize().shiftToAll().toObject());
      return clone$3(this, { values: vals }, true);
    }

    /**
     * Convert this Duration into its representation in a different set of units.
     * @example Duration.fromObject({ hours: 1, seconds: 30 }).shiftTo('minutes', 'milliseconds').toObject() //=> { minutes: 60, milliseconds: 30000 }
     * @return {Duration}
     */
    shiftTo(...units) {
      if (!this.isValid) return this;

      if (units.length === 0) {
        return this;
      }

      units = units.map((u) => Duration.normalizeUnit(u));

      const built = {},
        accumulated = {},
        vals = this.toObject();
      let lastUnit;

      for (const k of orderedUnits$1) {
        if (units.indexOf(k) >= 0) {
          lastUnit = k;

          let own = 0;

          // anything we haven't boiled down yet should get boiled to this unit
          for (const ak in accumulated) {
            own += this.matrix[ak][k] * accumulated[ak];
            accumulated[ak] = 0;
          }

          // plus anything that's already in this unit
          if (isNumber$1(vals[k])) {
            own += vals[k];
          }

          // only keep the integer part for now in the hopes of putting any decimal part
          // into a smaller unit later
          const i = Math.trunc(own);
          built[k] = i;
          accumulated[k] = (own * 1000 - i * 1000) / 1000;

          // otherwise, keep it in the wings to boil it later
        } else if (isNumber$1(vals[k])) {
          accumulated[k] = vals[k];
        }
      }

      // anything leftover becomes the decimal for the last unit
      // lastUnit must be defined since units is not empty
      for (const key in accumulated) {
        if (accumulated[key] !== 0) {
          built[lastUnit] +=
            key === lastUnit ? accumulated[key] : accumulated[key] / this.matrix[lastUnit][key];
        }
      }

      normalizeValues(this.matrix, built);
      return clone$3(this, { values: built }, true);
    }

    /**
     * Shift this Duration to all available units.
     * Same as shiftTo("years", "months", "weeks", "days", "hours", "minutes", "seconds", "milliseconds")
     * @return {Duration}
     */
    shiftToAll() {
      if (!this.isValid) return this;
      return this.shiftTo(
        "years",
        "months",
        "weeks",
        "days",
        "hours",
        "minutes",
        "seconds",
        "milliseconds"
      );
    }

    /**
     * Return the negative of this Duration.
     * @example Duration.fromObject({ hours: 1, seconds: 30 }).negate().toObject() //=> { hours: -1, seconds: -30 }
     * @return {Duration}
     */
    negate() {
      if (!this.isValid) return this;
      const negated = {};
      for (const k of Object.keys(this.values)) {
        negated[k] = this.values[k] === 0 ? 0 : -this.values[k];
      }
      return clone$3(this, { values: negated }, true);
    }

    /**
     * Get the years.
     * @type {number}
     */
    get years() {
      return this.isValid ? this.values.years || 0 : NaN;
    }

    /**
     * Get the quarters.
     * @type {number}
     */
    get quarters() {
      return this.isValid ? this.values.quarters || 0 : NaN;
    }

    /**
     * Get the months.
     * @type {number}
     */
    get months() {
      return this.isValid ? this.values.months || 0 : NaN;
    }

    /**
     * Get the weeks
     * @type {number}
     */
    get weeks() {
      return this.isValid ? this.values.weeks || 0 : NaN;
    }

    /**
     * Get the days.
     * @type {number}
     */
    get days() {
      return this.isValid ? this.values.days || 0 : NaN;
    }

    /**
     * Get the hours.
     * @type {number}
     */
    get hours() {
      return this.isValid ? this.values.hours || 0 : NaN;
    }

    /**
     * Get the minutes.
     * @type {number}
     */
    get minutes() {
      return this.isValid ? this.values.minutes || 0 : NaN;
    }

    /**
     * Get the seconds.
     * @return {number}
     */
    get seconds() {
      return this.isValid ? this.values.seconds || 0 : NaN;
    }

    /**
     * Get the milliseconds.
     * @return {number}
     */
    get milliseconds() {
      return this.isValid ? this.values.milliseconds || 0 : NaN;
    }

    /**
     * Returns whether the Duration is invalid. Invalid durations are returned by diff operations
     * on invalid DateTimes or Intervals.
     * @return {boolean}
     */
    get isValid() {
      return this.invalid === null;
    }

    /**
     * Returns an error code if this Duration became invalid, or null if the Duration is valid
     * @return {string}
     */
    get invalidReason() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this Duration became invalid, or null if the Duration is valid
     * @type {string}
     */
    get invalidExplanation() {
      return this.invalid ? this.invalid.explanation : null;
    }

    /**
     * Equality check
     * Two Durations are equal iff they have the same units and the same values for each unit.
     * @param {Duration} other
     * @return {boolean}
     */
    equals(other) {
      if (!this.isValid || !other.isValid) {
        return false;
      }

      if (!this.loc.equals(other.loc)) {
        return false;
      }

      function eq(v1, v2) {
        // Consider 0 and undefined as equal
        if (v1 === undefined || v1 === 0) return v2 === undefined || v2 === 0;
        return v1 === v2;
      }

      for (const u of orderedUnits$1) {
        if (!eq(this.values[u], other.values[u])) {
          return false;
        }
      }
      return true;
    }
  }

  const INVALID$2 = "Invalid Interval";

  // checks if the start is equal to or before the end
  function validateStartEnd(start, end) {
    if (!start || !start.isValid) {
      return Interval.invalid("missing or invalid start");
    } else if (!end || !end.isValid) {
      return Interval.invalid("missing or invalid end");
    } else if (end < start) {
      return Interval.invalid(
        "end before start",
        `The end of an interval must be after its start, but you had start=${start.toISO()} and end=${end.toISO()}`
      );
    } else {
      return null;
    }
  }

  /**
   * An Interval object represents a half-open interval of time, where each endpoint is a {@link DateTime}. Conceptually, it's a container for those two endpoints, accompanied by methods for creating, parsing, interrogating, comparing, transforming, and formatting them.
   *
   * Here is a brief overview of the most commonly used methods and getters in Interval:
   *
   * * **Creation** To create an Interval, use {@link Interval.fromDateTimes}, {@link Interval.after}, {@link Interval.before}, or {@link Interval.fromISO}.
   * * **Accessors** Use {@link Interval#start} and {@link Interval#end} to get the start and end.
   * * **Interrogation** To analyze the Interval, use {@link Interval#count}, {@link Interval#length}, {@link Interval#hasSame}, {@link Interval#contains}, {@link Interval#isAfter}, or {@link Interval#isBefore}.
   * * **Transformation** To create other Intervals out of this one, use {@link Interval#set}, {@link Interval#splitAt}, {@link Interval#splitBy}, {@link Interval#divideEqually}, {@link Interval.merge}, {@link Interval.xor}, {@link Interval#union}, {@link Interval#intersection}, or {@link Interval#difference}.
   * * **Comparison** To compare this Interval to another one, use {@link Interval#equals}, {@link Interval#overlaps}, {@link Interval#abutsStart}, {@link Interval#abutsEnd}, {@link Interval#engulfs}
   * * **Output** To convert the Interval into other representations, see {@link Interval#toString}, {@link Interval#toLocaleString}, {@link Interval#toISO}, {@link Interval#toISODate}, {@link Interval#toISOTime}, {@link Interval#toFormat}, and {@link Interval#toDuration}.
   */
  class Interval {
    /**
     * @private
     */
    constructor(config) {
      /**
       * @access private
       */
      this.s = config.start;
      /**
       * @access private
       */
      this.e = config.end;
      /**
       * @access private
       */
      this.invalid = config.invalid || null;
      /**
       * @access private
       */
      this.isLuxonInterval = true;
    }

    /**
     * Create an invalid Interval.
     * @param {string} reason - simple string of why this Interval is invalid. Should not contain parameters or anything else data-dependent
     * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
     * @return {Interval}
     */
    static invalid(reason, explanation = null) {
      if (!reason) {
        throw new InvalidArgumentError("need to specify a reason the Interval is invalid");
      }

      const invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

      if (Settings.throwOnInvalid) {
        throw new InvalidIntervalError(invalid);
      } else {
        return new Interval({ invalid });
      }
    }

    /**
     * Create an Interval from a start DateTime and an end DateTime. Inclusive of the start but not the end.
     * @param {DateTime|Date|Object} start
     * @param {DateTime|Date|Object} end
     * @return {Interval}
     */
    static fromDateTimes(start, end) {
      const builtStart = friendlyDateTime(start),
        builtEnd = friendlyDateTime(end);

      const validateError = validateStartEnd(builtStart, builtEnd);

      if (validateError == null) {
        return new Interval({
          start: builtStart,
          end: builtEnd,
        });
      } else {
        return validateError;
      }
    }

    /**
     * Create an Interval from a start DateTime and a Duration to extend to.
     * @param {DateTime|Date|Object} start
     * @param {Duration|Object|number} duration - the length of the Interval.
     * @return {Interval}
     */
    static after(start, duration) {
      const dur = Duration.fromDurationLike(duration),
        dt = friendlyDateTime(start);
      return Interval.fromDateTimes(dt, dt.plus(dur));
    }

    /**
     * Create an Interval from an end DateTime and a Duration to extend backwards to.
     * @param {DateTime|Date|Object} end
     * @param {Duration|Object|number} duration - the length of the Interval.
     * @return {Interval}
     */
    static before(end, duration) {
      const dur = Duration.fromDurationLike(duration),
        dt = friendlyDateTime(end);
      return Interval.fromDateTimes(dt.minus(dur), dt);
    }

    /**
     * Create an Interval from an ISO 8601 string.
     * Accepts `<start>/<end>`, `<start>/<duration>`, and `<duration>/<end>` formats.
     * @param {string} text - the ISO string to parse
     * @param {Object} [opts] - options to pass {@link DateTime#fromISO} and optionally {@link Duration#fromISO}
     * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
     * @return {Interval}
     */
    static fromISO(text, opts) {
      const [s, e] = (text || "").split("/", 2);
      if (s && e) {
        let start, startIsValid;
        try {
          start = DateTime.fromISO(s, opts);
          startIsValid = start.isValid;
        } catch (e) {
          startIsValid = false;
        }

        let end, endIsValid;
        try {
          end = DateTime.fromISO(e, opts);
          endIsValid = end.isValid;
        } catch (e) {
          endIsValid = false;
        }

        if (startIsValid && endIsValid) {
          return Interval.fromDateTimes(start, end);
        }

        if (startIsValid) {
          const dur = Duration.fromISO(e, opts);
          if (dur.isValid) {
            return Interval.after(start, dur);
          }
        } else if (endIsValid) {
          const dur = Duration.fromISO(s, opts);
          if (dur.isValid) {
            return Interval.before(end, dur);
          }
        }
      }
      return Interval.invalid("unparsable", `the input "${text}" can't be parsed as ISO 8601`);
    }

    /**
     * Check if an object is an Interval. Works across context boundaries
     * @param {object} o
     * @return {boolean}
     */
    static isInterval(o) {
      return (o && o.isLuxonInterval) || false;
    }

    /**
     * Returns the start of the Interval
     * @type {DateTime}
     */
    get start() {
      return this.isValid ? this.s : null;
    }

    /**
     * Returns the end of the Interval
     * @type {DateTime}
     */
    get end() {
      return this.isValid ? this.e : null;
    }

    /**
     * Returns whether this Interval's end is at least its start, meaning that the Interval isn't 'backwards'.
     * @type {boolean}
     */
    get isValid() {
      return this.invalidReason === null;
    }

    /**
     * Returns an error code if this Interval is invalid, or null if the Interval is valid
     * @type {string}
     */
    get invalidReason() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this Interval became invalid, or null if the Interval is valid
     * @type {string}
     */
    get invalidExplanation() {
      return this.invalid ? this.invalid.explanation : null;
    }

    /**
     * Returns the length of the Interval in the specified unit.
     * @param {string} unit - the unit (such as 'hours' or 'days') to return the length in.
     * @return {number}
     */
    length(unit = "milliseconds") {
      return this.isValid ? this.toDuration(...[unit]).get(unit) : NaN;
    }

    /**
     * Returns the count of minutes, hours, days, months, or years included in the Interval, even in part.
     * Unlike {@link Interval#length} this counts sections of the calendar, not periods of time, e.g. specifying 'day'
     * asks 'what dates are included in this interval?', not 'how many days long is this interval?'
     * @param {string} [unit='milliseconds'] - the unit of time to count.
     * @param {Object} opts - options
     * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week; this operation will always use the locale of the start DateTime
     * @return {number}
     */
    count(unit = "milliseconds", opts) {
      if (!this.isValid) return NaN;
      const start = this.start.startOf(unit, opts);
      let end;
      if (opts?.useLocaleWeeks) {
        end = this.end.reconfigure({ locale: start.locale });
      } else {
        end = this.end;
      }
      end = end.startOf(unit, opts);
      return Math.floor(end.diff(start, unit).get(unit)) + (end.valueOf() !== this.end.valueOf());
    }

    /**
     * Returns whether this Interval's start and end are both in the same unit of time
     * @param {string} unit - the unit of time to check sameness on
     * @return {boolean}
     */
    hasSame(unit) {
      return this.isValid ? this.isEmpty() || this.e.minus(1).hasSame(this.s, unit) : false;
    }

    /**
     * Return whether this Interval has the same start and end DateTimes.
     * @return {boolean}
     */
    isEmpty() {
      return this.s.valueOf() === this.e.valueOf();
    }

    /**
     * Return whether this Interval's start is after the specified DateTime.
     * @param {DateTime} dateTime
     * @return {boolean}
     */
    isAfter(dateTime) {
      if (!this.isValid) return false;
      return this.s > dateTime;
    }

    /**
     * Return whether this Interval's end is before the specified DateTime.
     * @param {DateTime} dateTime
     * @return {boolean}
     */
    isBefore(dateTime) {
      if (!this.isValid) return false;
      return this.e <= dateTime;
    }

    /**
     * Return whether this Interval contains the specified DateTime.
     * @param {DateTime} dateTime
     * @return {boolean}
     */
    contains(dateTime) {
      if (!this.isValid) return false;
      return this.s <= dateTime && this.e > dateTime;
    }

    /**
     * "Sets" the start and/or end dates. Returns a newly-constructed Interval.
     * @param {Object} values - the values to set
     * @param {DateTime} values.start - the starting DateTime
     * @param {DateTime} values.end - the ending DateTime
     * @return {Interval}
     */
    set({ start, end } = {}) {
      if (!this.isValid) return this;
      return Interval.fromDateTimes(start || this.s, end || this.e);
    }

    /**
     * Split this Interval at each of the specified DateTimes
     * @param {...DateTime} dateTimes - the unit of time to count.
     * @return {Array}
     */
    splitAt(...dateTimes) {
      if (!this.isValid) return [];
      const sorted = dateTimes
          .map(friendlyDateTime)
          .filter((d) => this.contains(d))
          .sort((a, b) => a.toMillis() - b.toMillis()),
        results = [];
      let { s } = this,
        i = 0;

      while (s < this.e) {
        const added = sorted[i] || this.e,
          next = +added > +this.e ? this.e : added;
        results.push(Interval.fromDateTimes(s, next));
        s = next;
        i += 1;
      }

      return results;
    }

    /**
     * Split this Interval into smaller Intervals, each of the specified length.
     * Left over time is grouped into a smaller interval
     * @param {Duration|Object|number} duration - The length of each resulting interval.
     * @return {Array}
     */
    splitBy(duration) {
      const dur = Duration.fromDurationLike(duration);

      if (!this.isValid || !dur.isValid || dur.as("milliseconds") === 0) {
        return [];
      }

      let { s } = this,
        idx = 1,
        next;

      const results = [];
      while (s < this.e) {
        const added = this.start.plus(dur.mapUnits((x) => x * idx));
        next = +added > +this.e ? this.e : added;
        results.push(Interval.fromDateTimes(s, next));
        s = next;
        idx += 1;
      }

      return results;
    }

    /**
     * Split this Interval into the specified number of smaller intervals.
     * @param {number} numberOfParts - The number of Intervals to divide the Interval into.
     * @return {Array}
     */
    divideEqually(numberOfParts) {
      if (!this.isValid) return [];
      return this.splitBy(this.length() / numberOfParts).slice(0, numberOfParts);
    }

    /**
     * Return whether this Interval overlaps with the specified Interval
     * @param {Interval} other
     * @return {boolean}
     */
    overlaps(other) {
      return this.e > other.s && this.s < other.e;
    }

    /**
     * Return whether this Interval's end is adjacent to the specified Interval's start.
     * @param {Interval} other
     * @return {boolean}
     */
    abutsStart(other) {
      if (!this.isValid) return false;
      return +this.e === +other.s;
    }

    /**
     * Return whether this Interval's start is adjacent to the specified Interval's end.
     * @param {Interval} other
     * @return {boolean}
     */
    abutsEnd(other) {
      if (!this.isValid) return false;
      return +other.e === +this.s;
    }

    /**
     * Returns true if this Interval fully contains the specified Interval, specifically if the intersect (of this Interval and the other Interval) is equal to the other Interval; false otherwise.
     * @param {Interval} other
     * @return {boolean}
     */
    engulfs(other) {
      if (!this.isValid) return false;
      return this.s <= other.s && this.e >= other.e;
    }

    /**
     * Return whether this Interval has the same start and end as the specified Interval.
     * @param {Interval} other
     * @return {boolean}
     */
    equals(other) {
      if (!this.isValid || !other.isValid) {
        return false;
      }

      return this.s.equals(other.s) && this.e.equals(other.e);
    }

    /**
     * Return an Interval representing the intersection of this Interval and the specified Interval.
     * Specifically, the resulting Interval has the maximum start time and the minimum end time of the two Intervals.
     * Returns null if the intersection is empty, meaning, the intervals don't intersect.
     * @param {Interval} other
     * @return {Interval}
     */
    intersection(other) {
      if (!this.isValid) return this;
      const s = this.s > other.s ? this.s : other.s,
        e = this.e < other.e ? this.e : other.e;

      if (s >= e) {
        return null;
      } else {
        return Interval.fromDateTimes(s, e);
      }
    }

    /**
     * Return an Interval representing the union of this Interval and the specified Interval.
     * Specifically, the resulting Interval has the minimum start time and the maximum end time of the two Intervals.
     * @param {Interval} other
     * @return {Interval}
     */
    union(other) {
      if (!this.isValid) return this;
      const s = this.s < other.s ? this.s : other.s,
        e = this.e > other.e ? this.e : other.e;
      return Interval.fromDateTimes(s, e);
    }

    /**
     * Merge an array of Intervals into a equivalent minimal set of Intervals.
     * Combines overlapping and adjacent Intervals.
     * @param {Array} intervals
     * @return {Array}
     */
    static merge(intervals) {
      const [found, final] = intervals
        .sort((a, b) => a.s - b.s)
        .reduce(
          ([sofar, current], item) => {
            if (!current) {
              return [sofar, item];
            } else if (current.overlaps(item) || current.abutsStart(item)) {
              return [sofar, current.union(item)];
            } else {
              return [sofar.concat([current]), item];
            }
          },
          [[], null]
        );
      if (final) {
        found.push(final);
      }
      return found;
    }

    /**
     * Return an array of Intervals representing the spans of time that only appear in one of the specified Intervals.
     * @param {Array} intervals
     * @return {Array}
     */
    static xor(intervals) {
      let start = null,
        currentCount = 0;
      const results = [],
        ends = intervals.map((i) => [
          { time: i.s, type: "s" },
          { time: i.e, type: "e" },
        ]),
        flattened = Array.prototype.concat(...ends),
        arr = flattened.sort((a, b) => a.time - b.time);

      for (const i of arr) {
        currentCount += i.type === "s" ? 1 : -1;

        if (currentCount === 1) {
          start = i.time;
        } else {
          if (start && +start !== +i.time) {
            results.push(Interval.fromDateTimes(start, i.time));
          }

          start = null;
        }
      }

      return Interval.merge(results);
    }

    /**
     * Return an Interval representing the span of time in this Interval that doesn't overlap with any of the specified Intervals.
     * @param {...Interval} intervals
     * @return {Array}
     */
    difference(...intervals) {
      return Interval.xor([this].concat(intervals))
        .map((i) => this.intersection(i))
        .filter((i) => i && !i.isEmpty());
    }

    /**
     * Returns a string representation of this Interval appropriate for debugging.
     * @return {string}
     */
    toString() {
      if (!this.isValid) return INVALID$2;
      return `[${this.s.toISO()} – ${this.e.toISO()})`;
    }

    /**
     * Returns a string representation of this Interval appropriate for the REPL.
     * @return {string}
     */
    [Symbol.for("nodejs.util.inspect.custom")]() {
      if (this.isValid) {
        return `Interval { start: ${this.s.toISO()}, end: ${this.e.toISO()} }`;
      } else {
        return `Interval { Invalid, reason: ${this.invalidReason} }`;
      }
    }

    /**
     * Returns a localized string representing this Interval. Accepts the same options as the
     * Intl.DateTimeFormat constructor and any presets defined by Luxon, such as
     * {@link DateTime.DATE_FULL} or {@link DateTime.TIME_SIMPLE}. The exact behavior of this method
     * is browser-specific, but in general it will return an appropriate representation of the
     * Interval in the assigned locale. Defaults to the system's locale if no locale has been
     * specified.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
     * @param {Object} [formatOpts=DateTime.DATE_SHORT] - Either a DateTime preset or
     * Intl.DateTimeFormat constructor options.
     * @param {Object} opts - Options to override the configuration of the start DateTime.
     * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(); //=> 11/7/2022 – 11/8/2022
     * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(DateTime.DATE_FULL); //=> November 7 – 8, 2022
     * @example Interval.fromISO('2022-11-07T09:00Z/2022-11-08T09:00Z').toLocaleString(DateTime.DATE_FULL, { locale: 'fr-FR' }); //=> 7–8 novembre 2022
     * @example Interval.fromISO('2022-11-07T17:00Z/2022-11-07T19:00Z').toLocaleString(DateTime.TIME_SIMPLE); //=> 6:00 – 8:00 PM
     * @example Interval.fromISO('2022-11-07T17:00Z/2022-11-07T19:00Z').toLocaleString({ weekday: 'short', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' }); //=> Mon, Nov 07, 6:00 – 8:00 p
     * @return {string}
     */
    toLocaleString(formatOpts = DATE_SHORT, opts = {}) {
      return this.isValid
        ? Formatter.create(this.s.loc.clone(opts), formatOpts).formatInterval(this)
        : INVALID$2;
    }

    /**
     * Returns an ISO 8601-compliant string representation of this Interval.
     * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
     * @param {Object} opts - The same options as {@link DateTime#toISO}
     * @return {string}
     */
    toISO(opts) {
      if (!this.isValid) return INVALID$2;
      return `${this.s.toISO(opts)}/${this.e.toISO(opts)}`;
    }

    /**
     * Returns an ISO 8601-compliant string representation of date of this Interval.
     * The time components are ignored.
     * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
     * @return {string}
     */
    toISODate() {
      if (!this.isValid) return INVALID$2;
      return `${this.s.toISODate()}/${this.e.toISODate()}`;
    }

    /**
     * Returns an ISO 8601-compliant string representation of time of this Interval.
     * The date components are ignored.
     * @see https://en.wikipedia.org/wiki/ISO_8601#Time_intervals
     * @param {Object} opts - The same options as {@link DateTime#toISO}
     * @return {string}
     */
    toISOTime(opts) {
      if (!this.isValid) return INVALID$2;
      return `${this.s.toISOTime(opts)}/${this.e.toISOTime(opts)}`;
    }

    /**
     * Returns a string representation of this Interval formatted according to the specified format
     * string. **You may not want this.** See {@link Interval#toLocaleString} for a more flexible
     * formatting tool.
     * @param {string} dateFormat - The format string. This string formats the start and end time.
     * See {@link DateTime#toFormat} for details.
     * @param {Object} opts - Options.
     * @param {string} [opts.separator =  ' – '] - A separator to place between the start and end
     * representations.
     * @return {string}
     */
    toFormat(dateFormat, { separator = " – " } = {}) {
      if (!this.isValid) return INVALID$2;
      return `${this.s.toFormat(dateFormat)}${separator}${this.e.toFormat(dateFormat)}`;
    }

    /**
     * Return a Duration representing the time spanned by this interval.
     * @param {string|string[]} [unit=['milliseconds']] - the unit or units (such as 'hours' or 'days') to include in the duration.
     * @param {Object} opts - options that affect the creation of the Duration
     * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
     * @example Interval.fromDateTimes(dt1, dt2).toDuration().toObject() //=> { milliseconds: 88489257 }
     * @example Interval.fromDateTimes(dt1, dt2).toDuration('days').toObject() //=> { days: 1.0241812152777778 }
     * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes']).toObject() //=> { hours: 24, minutes: 34.82095 }
     * @example Interval.fromDateTimes(dt1, dt2).toDuration(['hours', 'minutes', 'seconds']).toObject() //=> { hours: 24, minutes: 34, seconds: 49.257 }
     * @example Interval.fromDateTimes(dt1, dt2).toDuration('seconds').toObject() //=> { seconds: 88489.257 }
     * @return {Duration}
     */
    toDuration(unit, opts) {
      if (!this.isValid) {
        return Duration.invalid(this.invalidReason);
      }
      return this.e.diff(this.s, unit, opts);
    }

    /**
     * Run mapFn on the interval start and end, returning a new Interval from the resulting DateTimes
     * @param {function} mapFn
     * @return {Interval}
     * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.toUTC())
     * @example Interval.fromDateTimes(dt1, dt2).mapEndpoints(endpoint => endpoint.plus({ hours: 2 }))
     */
    mapEndpoints(mapFn) {
      return Interval.fromDateTimes(mapFn(this.s), mapFn(this.e));
    }
  }

  /**
   * The Info class contains static methods for retrieving general time and date related data. For example, it has methods for finding out if a time zone has a DST, for listing the months in any supported locale, and for discovering which of Luxon features are available in the current environment.
   */
  class Info {
    /**
     * Return whether the specified zone contains a DST.
     * @param {string|Zone} [zone='local'] - Zone to check. Defaults to the environment's local zone.
     * @return {boolean}
     */
    static hasDST(zone = Settings.defaultZone) {
      const proto = DateTime.now().setZone(zone).set({ month: 12 });

      return !zone.isUniversal && proto.offset !== proto.set({ month: 6 }).offset;
    }

    /**
     * Return whether the specified zone is a valid IANA specifier.
     * @param {string} zone - Zone to check
     * @return {boolean}
     */
    static isValidIANAZone(zone) {
      return IANAZone.isValidZone(zone);
    }

    /**
     * Converts the input into a {@link Zone} instance.
     *
     * * If `input` is already a Zone instance, it is returned unchanged.
     * * If `input` is a string containing a valid time zone name, a Zone instance
     *   with that name is returned.
     * * If `input` is a string that doesn't refer to a known time zone, a Zone
     *   instance with {@link Zone#isValid} == false is returned.
     * * If `input is a number, a Zone instance with the specified fixed offset
     *   in minutes is returned.
     * * If `input` is `null` or `undefined`, the default zone is returned.
     * @param {string|Zone|number} [input] - the value to be converted
     * @return {Zone}
     */
    static normalizeZone(input) {
      return normalizeZone(input, Settings.defaultZone);
    }

    /**
     * Get the weekday on which the week starts according to the given locale.
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @returns {number} the start of the week, 1 for Monday through 7 for Sunday
     */
    static getStartOfWeek({ locale = null, locObj = null } = {}) {
      return (locObj || Locale.create(locale)).getStartOfWeek();
    }

    /**
     * Get the minimum number of days necessary in a week before it is considered part of the next year according
     * to the given locale.
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @returns {number}
     */
    static getMinimumDaysInFirstWeek({ locale = null, locObj = null } = {}) {
      return (locObj || Locale.create(locale)).getMinDaysInFirstWeek();
    }

    /**
     * Get the weekdays, which are considered the weekend according to the given locale
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @returns {number[]} an array of weekdays, 1 for Monday through 7 for Sunday
     */
    static getWeekendWeekdays({ locale = null, locObj = null } = {}) {
      // copy the array, because we cache it internally
      return (locObj || Locale.create(locale)).getWeekendDays().slice();
    }

    /**
     * Return an array of standalone month names.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
     * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.numberingSystem=null] - the numbering system
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @param {string} [opts.outputCalendar='gregory'] - the calendar
     * @example Info.months()[0] //=> 'January'
     * @example Info.months('short')[0] //=> 'Jan'
     * @example Info.months('numeric')[0] //=> '1'
     * @example Info.months('short', { locale: 'fr-CA' } )[0] //=> 'janv.'
     * @example Info.months('numeric', { locale: 'ar' })[0] //=> '١'
     * @example Info.months('long', { outputCalendar: 'islamic' })[0] //=> 'Rabiʻ I'
     * @return {Array}
     */
    static months(
      length = "long",
      { locale = null, numberingSystem = null, locObj = null, outputCalendar = "gregory" } = {}
    ) {
      return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length);
    }

    /**
     * Return an array of format month names.
     * Format months differ from standalone months in that they're meant to appear next to the day of the month. In some languages, that
     * changes the string.
     * See {@link Info#months}
     * @param {string} [length='long'] - the length of the month representation, such as "numeric", "2-digit", "narrow", "short", "long"
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.numberingSystem=null] - the numbering system
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @param {string} [opts.outputCalendar='gregory'] - the calendar
     * @return {Array}
     */
    static monthsFormat(
      length = "long",
      { locale = null, numberingSystem = null, locObj = null, outputCalendar = "gregory" } = {}
    ) {
      return (locObj || Locale.create(locale, numberingSystem, outputCalendar)).months(length, true);
    }

    /**
     * Return an array of standalone week names.
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
     * @param {string} [length='long'] - the length of the weekday representation, such as "narrow", "short", "long".
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @param {string} [opts.numberingSystem=null] - the numbering system
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @example Info.weekdays()[0] //=> 'Monday'
     * @example Info.weekdays('short')[0] //=> 'Mon'
     * @example Info.weekdays('short', { locale: 'fr-CA' })[0] //=> 'lun.'
     * @example Info.weekdays('short', { locale: 'ar' })[0] //=> 'الاثنين'
     * @return {Array}
     */
    static weekdays(length = "long", { locale = null, numberingSystem = null, locObj = null } = {}) {
      return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length);
    }

    /**
     * Return an array of format week names.
     * Format weekdays differ from standalone weekdays in that they're meant to appear next to more date information. In some languages, that
     * changes the string.
     * See {@link Info#weekdays}
     * @param {string} [length='long'] - the length of the month representation, such as "narrow", "short", "long".
     * @param {Object} opts - options
     * @param {string} [opts.locale=null] - the locale code
     * @param {string} [opts.numberingSystem=null] - the numbering system
     * @param {string} [opts.locObj=null] - an existing locale object to use
     * @return {Array}
     */
    static weekdaysFormat(
      length = "long",
      { locale = null, numberingSystem = null, locObj = null } = {}
    ) {
      return (locObj || Locale.create(locale, numberingSystem, null)).weekdays(length, true);
    }

    /**
     * Return an array of meridiems.
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @example Info.meridiems() //=> [ 'AM', 'PM' ]
     * @example Info.meridiems({ locale: 'my' }) //=> [ 'နံနက်', 'ညနေ' ]
     * @return {Array}
     */
    static meridiems({ locale = null } = {}) {
      return Locale.create(locale).meridiems();
    }

    /**
     * Return an array of eras, such as ['BC', 'AD']. The locale can be specified, but the calendar system is always Gregorian.
     * @param {string} [length='short'] - the length of the era representation, such as "short" or "long".
     * @param {Object} opts - options
     * @param {string} [opts.locale] - the locale code
     * @example Info.eras() //=> [ 'BC', 'AD' ]
     * @example Info.eras('long') //=> [ 'Before Christ', 'Anno Domini' ]
     * @example Info.eras('long', { locale: 'fr' }) //=> [ 'avant Jésus-Christ', 'après Jésus-Christ' ]
     * @return {Array}
     */
    static eras(length = "short", { locale = null } = {}) {
      return Locale.create(locale, null, "gregory").eras(length);
    }

    /**
     * Return the set of available features in this environment.
     * Some features of Luxon are not available in all environments. For example, on older browsers, relative time formatting support is not available. Use this function to figure out if that's the case.
     * Keys:
     * * `relative`: whether this environment supports relative time formatting
     * * `localeWeek`: whether this environment supports different weekdays for the start of the week based on the locale
     * @example Info.features() //=> { relative: false, localeWeek: true }
     * @return {Object}
     */
    static features() {
      return { relative: hasRelative(), localeWeek: hasLocaleWeekInfo() };
    }
  }

  function dayDiff(earlier, later) {
    const utcDayStart = (dt) => dt.toUTC(0, { keepLocalTime: true }).startOf("day").valueOf(),
      ms = utcDayStart(later) - utcDayStart(earlier);
    return Math.floor(Duration.fromMillis(ms).as("days"));
  }

  function highOrderDiffs(cursor, later, units) {
    const differs = [
      ["years", (a, b) => b.year - a.year],
      ["quarters", (a, b) => b.quarter - a.quarter + (b.year - a.year) * 4],
      ["months", (a, b) => b.month - a.month + (b.year - a.year) * 12],
      [
        "weeks",
        (a, b) => {
          const days = dayDiff(a, b);
          return (days - (days % 7)) / 7;
        },
      ],
      ["days", dayDiff],
    ];

    const results = {};
    const earlier = cursor;
    let lowestOrder, highWater;

    /* This loop tries to diff using larger units first.
       If we overshoot, we backtrack and try the next smaller unit.
       "cursor" starts out at the earlier timestamp and moves closer and closer to "later"
       as we use smaller and smaller units.
       highWater keeps track of where we would be if we added one more of the smallest unit,
       this is used later to potentially convert any difference smaller than the smallest higher order unit
       into a fraction of that smallest higher order unit
    */
    for (const [unit, differ] of differs) {
      if (units.indexOf(unit) >= 0) {
        lowestOrder = unit;

        results[unit] = differ(cursor, later);
        highWater = earlier.plus(results);

        if (highWater > later) {
          // we overshot the end point, backtrack cursor by 1
          results[unit]--;
          cursor = earlier.plus(results);

          // if we are still overshooting now, we need to backtrack again
          // this happens in certain situations when diffing times in different zones,
          // because this calculation ignores time zones
          if (cursor > later) {
            // keep the "overshot by 1" around as highWater
            highWater = cursor;
            // backtrack cursor by 1
            results[unit]--;
            cursor = earlier.plus(results);
          }
        } else {
          cursor = highWater;
        }
      }
    }

    return [cursor, results, highWater, lowestOrder];
  }

  function diff (earlier, later, units, opts) {
    let [cursor, results, highWater, lowestOrder] = highOrderDiffs(earlier, later, units);

    const remainingMillis = later - cursor;

    const lowerOrderUnits = units.filter(
      (u) => ["hours", "minutes", "seconds", "milliseconds"].indexOf(u) >= 0
    );

    if (lowerOrderUnits.length === 0) {
      if (highWater < later) {
        highWater = cursor.plus({ [lowestOrder]: 1 });
      }

      if (highWater !== cursor) {
        results[lowestOrder] = (results[lowestOrder] || 0) + remainingMillis / (highWater - cursor);
      }
    }

    const duration = Duration.fromObject(results, opts);

    if (lowerOrderUnits.length > 0) {
      return Duration.fromMillis(remainingMillis, opts)
        .shiftTo(...lowerOrderUnits)
        .plus(duration);
    } else {
      return duration;
    }
  }

  const MISSING_FTP = "missing Intl.DateTimeFormat.formatToParts support";

  function intUnit(regex, post = (i) => i) {
    return { regex, deser: ([s]) => post(parseDigits(s)) };
  }

  const NBSP = String.fromCharCode(160);
  const spaceOrNBSP = `[ ${NBSP}]`;
  const spaceOrNBSPRegExp = new RegExp(spaceOrNBSP, "g");

  function fixListRegex(s) {
    // make dots optional and also make them literal
    // make space and non breakable space characters interchangeable
    return s.replace(/\./g, "\\.?").replace(spaceOrNBSPRegExp, spaceOrNBSP);
  }

  function stripInsensitivities(s) {
    return s
      .replace(/\./g, "") // ignore dots that were made optional
      .replace(spaceOrNBSPRegExp, " ") // interchange space and nbsp
      .toLowerCase();
  }

  function oneOf(strings, startIndex) {
    if (strings === null) {
      return null;
    } else {
      return {
        regex: RegExp(strings.map(fixListRegex).join("|")),
        deser: ([s]) =>
          strings.findIndex((i) => stripInsensitivities(s) === stripInsensitivities(i)) + startIndex,
      };
    }
  }

  function offset(regex, groups) {
    return { regex, deser: ([, h, m]) => signedOffset(h, m), groups };
  }

  function simple(regex) {
    return { regex, deser: ([s]) => s };
  }

  function escapeToken(value) {
    return value.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g, "\\$&");
  }

  /**
   * @param token
   * @param {Locale} loc
   */
  function unitForToken(token, loc) {
    const one = digitRegex(loc),
      two = digitRegex(loc, "{2}"),
      three = digitRegex(loc, "{3}"),
      four = digitRegex(loc, "{4}"),
      six = digitRegex(loc, "{6}"),
      oneOrTwo = digitRegex(loc, "{1,2}"),
      oneToThree = digitRegex(loc, "{1,3}"),
      oneToSix = digitRegex(loc, "{1,6}"),
      oneToNine = digitRegex(loc, "{1,9}"),
      twoToFour = digitRegex(loc, "{2,4}"),
      fourToSix = digitRegex(loc, "{4,6}"),
      literal = (t) => ({ regex: RegExp(escapeToken(t.val)), deser: ([s]) => s, literal: true }),
      unitate = (t) => {
        if (token.literal) {
          return literal(t);
        }
        switch (t.val) {
          // era
          case "G":
            return oneOf(loc.eras("short"), 0);
          case "GG":
            return oneOf(loc.eras("long"), 0);
          // years
          case "y":
            return intUnit(oneToSix);
          case "yy":
            return intUnit(twoToFour, untruncateYear);
          case "yyyy":
            return intUnit(four);
          case "yyyyy":
            return intUnit(fourToSix);
          case "yyyyyy":
            return intUnit(six);
          // months
          case "M":
            return intUnit(oneOrTwo);
          case "MM":
            return intUnit(two);
          case "MMM":
            return oneOf(loc.months("short", true), 1);
          case "MMMM":
            return oneOf(loc.months("long", true), 1);
          case "L":
            return intUnit(oneOrTwo);
          case "LL":
            return intUnit(two);
          case "LLL":
            return oneOf(loc.months("short", false), 1);
          case "LLLL":
            return oneOf(loc.months("long", false), 1);
          // dates
          case "d":
            return intUnit(oneOrTwo);
          case "dd":
            return intUnit(two);
          // ordinals
          case "o":
            return intUnit(oneToThree);
          case "ooo":
            return intUnit(three);
          // time
          case "HH":
            return intUnit(two);
          case "H":
            return intUnit(oneOrTwo);
          case "hh":
            return intUnit(two);
          case "h":
            return intUnit(oneOrTwo);
          case "mm":
            return intUnit(two);
          case "m":
            return intUnit(oneOrTwo);
          case "q":
            return intUnit(oneOrTwo);
          case "qq":
            return intUnit(two);
          case "s":
            return intUnit(oneOrTwo);
          case "ss":
            return intUnit(two);
          case "S":
            return intUnit(oneToThree);
          case "SSS":
            return intUnit(three);
          case "u":
            return simple(oneToNine);
          case "uu":
            return simple(oneOrTwo);
          case "uuu":
            return intUnit(one);
          // meridiem
          case "a":
            return oneOf(loc.meridiems(), 0);
          // weekYear (k)
          case "kkkk":
            return intUnit(four);
          case "kk":
            return intUnit(twoToFour, untruncateYear);
          // weekNumber (W)
          case "W":
            return intUnit(oneOrTwo);
          case "WW":
            return intUnit(two);
          // weekdays
          case "E":
          case "c":
            return intUnit(one);
          case "EEE":
            return oneOf(loc.weekdays("short", false), 1);
          case "EEEE":
            return oneOf(loc.weekdays("long", false), 1);
          case "ccc":
            return oneOf(loc.weekdays("short", true), 1);
          case "cccc":
            return oneOf(loc.weekdays("long", true), 1);
          // offset/zone
          case "Z":
          case "ZZ":
            return offset(new RegExp(`([+-]${oneOrTwo.source})(?::(${two.source}))?`), 2);
          case "ZZZ":
            return offset(new RegExp(`([+-]${oneOrTwo.source})(${two.source})?`), 2);
          // we don't support ZZZZ (PST) or ZZZZZ (Pacific Standard Time) in parsing
          // because we don't have any way to figure out what they are
          case "z":
            return simple(/[a-z_+-/]{1,256}?/i);
          // this special-case "token" represents a place where a macro-token expanded into a white-space literal
          // in this case we accept any non-newline white-space
          case " ":
            return simple(/[^\S\n\r]/);
          default:
            return literal(t);
        }
      };

    const unit = unitate(token) || {
      invalidReason: MISSING_FTP,
    };

    unit.token = token;

    return unit;
  }

  const partTypeStyleToTokenVal = {
    year: {
      "2-digit": "yy",
      numeric: "yyyyy",
    },
    month: {
      numeric: "M",
      "2-digit": "MM",
      short: "MMM",
      long: "MMMM",
    },
    day: {
      numeric: "d",
      "2-digit": "dd",
    },
    weekday: {
      short: "EEE",
      long: "EEEE",
    },
    dayperiod: "a",
    dayPeriod: "a",
    hour12: {
      numeric: "h",
      "2-digit": "hh",
    },
    hour24: {
      numeric: "H",
      "2-digit": "HH",
    },
    minute: {
      numeric: "m",
      "2-digit": "mm",
    },
    second: {
      numeric: "s",
      "2-digit": "ss",
    },
    timeZoneName: {
      long: "ZZZZZ",
      short: "ZZZ",
    },
  };

  function tokenForPart(part, formatOpts, resolvedOpts) {
    const { type, value } = part;

    if (type === "literal") {
      const isSpace = /^\s+$/.test(value);
      return {
        literal: !isSpace,
        val: isSpace ? " " : value,
      };
    }

    const style = formatOpts[type];

    // The user might have explicitly specified hour12 or hourCycle
    // if so, respect their decision
    // if not, refer back to the resolvedOpts, which are based on the locale
    let actualType = type;
    if (type === "hour") {
      if (formatOpts.hour12 != null) {
        actualType = formatOpts.hour12 ? "hour12" : "hour24";
      } else if (formatOpts.hourCycle != null) {
        if (formatOpts.hourCycle === "h11" || formatOpts.hourCycle === "h12") {
          actualType = "hour12";
        } else {
          actualType = "hour24";
        }
      } else {
        // tokens only differentiate between 24 hours or not,
        // so we do not need to check hourCycle here, which is less supported anyways
        actualType = resolvedOpts.hour12 ? "hour12" : "hour24";
      }
    }
    let val = partTypeStyleToTokenVal[actualType];
    if (typeof val === "object") {
      val = val[style];
    }

    if (val) {
      return {
        literal: false,
        val,
      };
    }

    return undefined;
  }

  function buildRegex(units) {
    const re = units.map((u) => u.regex).reduce((f, r) => `${f}(${r.source})`, "");
    return [`^${re}$`, units];
  }

  function match(input, regex, handlers) {
    const matches = input.match(regex);

    if (matches) {
      const all = {};
      let matchIndex = 1;
      for (const i in handlers) {
        if (hasOwnProperty(handlers, i)) {
          const h = handlers[i],
            groups = h.groups ? h.groups + 1 : 1;
          if (!h.literal && h.token) {
            all[h.token.val[0]] = h.deser(matches.slice(matchIndex, matchIndex + groups));
          }
          matchIndex += groups;
        }
      }
      return [matches, all];
    } else {
      return [matches, {}];
    }
  }

  function dateTimeFromMatches(matches) {
    const toField = (token) => {
      switch (token) {
        case "S":
          return "millisecond";
        case "s":
          return "second";
        case "m":
          return "minute";
        case "h":
        case "H":
          return "hour";
        case "d":
          return "day";
        case "o":
          return "ordinal";
        case "L":
        case "M":
          return "month";
        case "y":
          return "year";
        case "E":
        case "c":
          return "weekday";
        case "W":
          return "weekNumber";
        case "k":
          return "weekYear";
        case "q":
          return "quarter";
        default:
          return null;
      }
    };

    let zone = null;
    let specificOffset;
    if (!isUndefined(matches.z)) {
      zone = IANAZone.create(matches.z);
    }

    if (!isUndefined(matches.Z)) {
      if (!zone) {
        zone = new FixedOffsetZone(matches.Z);
      }
      specificOffset = matches.Z;
    }

    if (!isUndefined(matches.q)) {
      matches.M = (matches.q - 1) * 3 + 1;
    }

    if (!isUndefined(matches.h)) {
      if (matches.h < 12 && matches.a === 1) {
        matches.h += 12;
      } else if (matches.h === 12 && matches.a === 0) {
        matches.h = 0;
      }
    }

    if (matches.G === 0 && matches.y) {
      matches.y = -matches.y;
    }

    if (!isUndefined(matches.u)) {
      matches.S = parseMillis(matches.u);
    }

    const vals = Object.keys(matches).reduce((r, k) => {
      const f = toField(k);
      if (f) {
        r[f] = matches[k];
      }

      return r;
    }, {});

    return [vals, zone, specificOffset];
  }

  let dummyDateTimeCache = null;

  function getDummyDateTime() {
    if (!dummyDateTimeCache) {
      dummyDateTimeCache = DateTime.fromMillis(1555555555555);
    }

    return dummyDateTimeCache;
  }

  function maybeExpandMacroToken(token, locale) {
    if (token.literal) {
      return token;
    }

    const formatOpts = Formatter.macroTokenToFormatOpts(token.val);
    const tokens = formatOptsToTokens(formatOpts, locale);

    if (tokens == null || tokens.includes(undefined)) {
      return token;
    }

    return tokens;
  }

  function expandMacroTokens(tokens, locale) {
    return Array.prototype.concat(...tokens.map((t) => maybeExpandMacroToken(t, locale)));
  }

  /**
   * @private
   */

  class TokenParser {
    constructor(locale, format) {
      this.locale = locale;
      this.format = format;
      this.tokens = expandMacroTokens(Formatter.parseFormat(format), locale);
      this.units = this.tokens.map((t) => unitForToken(t, locale));
      this.disqualifyingUnit = this.units.find((t) => t.invalidReason);

      if (!this.disqualifyingUnit) {
        const [regexString, handlers] = buildRegex(this.units);
        this.regex = RegExp(regexString, "i");
        this.handlers = handlers;
      }
    }

    explainFromTokens(input) {
      if (!this.isValid) {
        return { input, tokens: this.tokens, invalidReason: this.invalidReason };
      } else {
        const [rawMatches, matches] = match(input, this.regex, this.handlers),
          [result, zone, specificOffset] = matches
            ? dateTimeFromMatches(matches)
            : [null, null, undefined];
        if (hasOwnProperty(matches, "a") && hasOwnProperty(matches, "H")) {
          throw new ConflictingSpecificationError(
            "Can't include meridiem when specifying 24-hour format"
          );
        }
        return {
          input,
          tokens: this.tokens,
          regex: this.regex,
          rawMatches,
          matches,
          result,
          zone,
          specificOffset,
        };
      }
    }

    get isValid() {
      return !this.disqualifyingUnit;
    }

    get invalidReason() {
      return this.disqualifyingUnit ? this.disqualifyingUnit.invalidReason : null;
    }
  }

  function explainFromTokens(locale, input, format) {
    const parser = new TokenParser(locale, format);
    return parser.explainFromTokens(input);
  }

  function parseFromTokens(locale, input, format) {
    const { result, zone, specificOffset, invalidReason } = explainFromTokens(locale, input, format);
    return [result, zone, specificOffset, invalidReason];
  }

  function formatOptsToTokens(formatOpts, locale) {
    if (!formatOpts) {
      return null;
    }

    const formatter = Formatter.create(locale, formatOpts);
    const df = formatter.dtFormatter(getDummyDateTime());
    const parts = df.formatToParts();
    const resolvedOpts = df.resolvedOptions();
    return parts.map((p) => tokenForPart(p, formatOpts, resolvedOpts));
  }

  const INVALID$1 = "Invalid DateTime";
  const MAX_DATE = 8.64e15;

  function unsupportedZone(zone) {
    return new Invalid("unsupported zone", `the zone "${zone.name}" is not supported`);
  }

  // we cache week data on the DT object and this intermediates the cache
  /**
   * @param {DateTime} dt
   */
  function possiblyCachedWeekData(dt) {
    if (dt.weekData === null) {
      dt.weekData = gregorianToWeek(dt.c);
    }
    return dt.weekData;
  }

  /**
   * @param {DateTime} dt
   */
  function possiblyCachedLocalWeekData(dt) {
    if (dt.localWeekData === null) {
      dt.localWeekData = gregorianToWeek(
        dt.c,
        dt.loc.getMinDaysInFirstWeek(),
        dt.loc.getStartOfWeek()
      );
    }
    return dt.localWeekData;
  }

  // clone really means, "make a new object with these modifications". all "setters" really use this
  // to create a new object while only changing some of the properties
  function clone$2(inst, alts) {
    const current = {
      ts: inst.ts,
      zone: inst.zone,
      c: inst.c,
      o: inst.o,
      loc: inst.loc,
      invalid: inst.invalid,
    };
    return new DateTime({ ...current, ...alts, old: current });
  }

  // find the right offset a given local time. The o input is our guess, which determines which
  // offset we'll pick in ambiguous cases (e.g. there are two 3 AMs b/c Fallback DST)
  function fixOffset(localTS, o, tz) {
    // Our UTC time is just a guess because our offset is just a guess
    let utcGuess = localTS - o * 60 * 1000;

    // Test whether the zone matches the offset for this ts
    const o2 = tz.offset(utcGuess);

    // If so, offset didn't change and we're done
    if (o === o2) {
      return [utcGuess, o];
    }

    // If not, change the ts by the difference in the offset
    utcGuess -= (o2 - o) * 60 * 1000;

    // If that gives us the local time we want, we're done
    const o3 = tz.offset(utcGuess);
    if (o2 === o3) {
      return [utcGuess, o2];
    }

    // If it's different, we're in a hole time. The offset has changed, but the we don't adjust the time
    return [localTS - Math.min(o2, o3) * 60 * 1000, Math.max(o2, o3)];
  }

  // convert an epoch timestamp into a calendar object with the given offset
  function tsToObj(ts, offset) {
    ts += offset * 60 * 1000;

    const d = new Date(ts);

    return {
      year: d.getUTCFullYear(),
      month: d.getUTCMonth() + 1,
      day: d.getUTCDate(),
      hour: d.getUTCHours(),
      minute: d.getUTCMinutes(),
      second: d.getUTCSeconds(),
      millisecond: d.getUTCMilliseconds(),
    };
  }

  // convert a calendar object to a epoch timestamp
  function objToTS(obj, offset, zone) {
    return fixOffset(objToLocalTS(obj), offset, zone);
  }

  // create a new DT instance by adding a duration, adjusting for DSTs
  function adjustTime(inst, dur) {
    const oPre = inst.o,
      year = inst.c.year + Math.trunc(dur.years),
      month = inst.c.month + Math.trunc(dur.months) + Math.trunc(dur.quarters) * 3,
      c = {
        ...inst.c,
        year,
        month,
        day:
          Math.min(inst.c.day, daysInMonth(year, month)) +
          Math.trunc(dur.days) +
          Math.trunc(dur.weeks) * 7,
      },
      millisToAdd = Duration.fromObject({
        years: dur.years - Math.trunc(dur.years),
        quarters: dur.quarters - Math.trunc(dur.quarters),
        months: dur.months - Math.trunc(dur.months),
        weeks: dur.weeks - Math.trunc(dur.weeks),
        days: dur.days - Math.trunc(dur.days),
        hours: dur.hours,
        minutes: dur.minutes,
        seconds: dur.seconds,
        milliseconds: dur.milliseconds,
      }).as("milliseconds"),
      localTS = objToLocalTS(c);

    let [ts, o] = fixOffset(localTS, oPre, inst.zone);

    if (millisToAdd !== 0) {
      ts += millisToAdd;
      // that could have changed the offset by going over a DST, but we want to keep the ts the same
      o = inst.zone.offset(ts);
    }

    return { ts, o };
  }

  // helper useful in turning the results of parsing into real dates
  // by handling the zone options
  function parseDataToDateTime(parsed, parsedZone, opts, format, text, specificOffset) {
    const { setZone, zone } = opts;
    if ((parsed && Object.keys(parsed).length !== 0) || parsedZone) {
      const interpretationZone = parsedZone || zone,
        inst = DateTime.fromObject(parsed, {
          ...opts,
          zone: interpretationZone,
          specificOffset,
        });
      return setZone ? inst : inst.setZone(zone);
    } else {
      return DateTime.invalid(
        new Invalid("unparsable", `the input "${text}" can't be parsed as ${format}`)
      );
    }
  }

  // if you want to output a technical format (e.g. RFC 2822), this helper
  // helps handle the details
  function toTechFormat(dt, format, allowZ = true) {
    return dt.isValid
      ? Formatter.create(Locale.create("en-US"), {
          allowZ,
          forceSimple: true,
        }).formatDateTimeFromString(dt, format)
      : null;
  }

  function toISODate(o, extended) {
    const longFormat = o.c.year > 9999 || o.c.year < 0;
    let c = "";
    if (longFormat && o.c.year >= 0) c += "+";
    c += padStart(o.c.year, longFormat ? 6 : 4);

    if (extended) {
      c += "-";
      c += padStart(o.c.month);
      c += "-";
      c += padStart(o.c.day);
    } else {
      c += padStart(o.c.month);
      c += padStart(o.c.day);
    }
    return c;
  }

  function toISOTime(
    o,
    extended,
    suppressSeconds,
    suppressMilliseconds,
    includeOffset,
    extendedZone
  ) {
    let c = padStart(o.c.hour);
    if (extended) {
      c += ":";
      c += padStart(o.c.minute);
      if (o.c.millisecond !== 0 || o.c.second !== 0 || !suppressSeconds) {
        c += ":";
      }
    } else {
      c += padStart(o.c.minute);
    }

    if (o.c.millisecond !== 0 || o.c.second !== 0 || !suppressSeconds) {
      c += padStart(o.c.second);

      if (o.c.millisecond !== 0 || !suppressMilliseconds) {
        c += ".";
        c += padStart(o.c.millisecond, 3);
      }
    }

    if (includeOffset) {
      if (o.isOffsetFixed && o.offset === 0 && !extendedZone) {
        c += "Z";
      } else if (o.o < 0) {
        c += "-";
        c += padStart(Math.trunc(-o.o / 60));
        c += ":";
        c += padStart(Math.trunc(-o.o % 60));
      } else {
        c += "+";
        c += padStart(Math.trunc(o.o / 60));
        c += ":";
        c += padStart(Math.trunc(o.o % 60));
      }
    }

    if (extendedZone) {
      c += "[" + o.zone.ianaName + "]";
    }
    return c;
  }

  // defaults for unspecified units in the supported calendars
  const defaultUnitValues = {
      month: 1,
      day: 1,
      hour: 0,
      minute: 0,
      second: 0,
      millisecond: 0,
    },
    defaultWeekUnitValues = {
      weekNumber: 1,
      weekday: 1,
      hour: 0,
      minute: 0,
      second: 0,
      millisecond: 0,
    },
    defaultOrdinalUnitValues = {
      ordinal: 1,
      hour: 0,
      minute: 0,
      second: 0,
      millisecond: 0,
    };

  // Units in the supported calendars, sorted by bigness
  const orderedUnits = ["year", "month", "day", "hour", "minute", "second", "millisecond"],
    orderedWeekUnits = [
      "weekYear",
      "weekNumber",
      "weekday",
      "hour",
      "minute",
      "second",
      "millisecond",
    ],
    orderedOrdinalUnits = ["year", "ordinal", "hour", "minute", "second", "millisecond"];

  // standardize case and plurality in units
  function normalizeUnit(unit) {
    const normalized = {
      year: "year",
      years: "year",
      month: "month",
      months: "month",
      day: "day",
      days: "day",
      hour: "hour",
      hours: "hour",
      minute: "minute",
      minutes: "minute",
      quarter: "quarter",
      quarters: "quarter",
      second: "second",
      seconds: "second",
      millisecond: "millisecond",
      milliseconds: "millisecond",
      weekday: "weekday",
      weekdays: "weekday",
      weeknumber: "weekNumber",
      weeksnumber: "weekNumber",
      weeknumbers: "weekNumber",
      weekyear: "weekYear",
      weekyears: "weekYear",
      ordinal: "ordinal",
    }[unit.toLowerCase()];

    if (!normalized) throw new InvalidUnitError(unit);

    return normalized;
  }

  function normalizeUnitWithLocalWeeks(unit) {
    switch (unit.toLowerCase()) {
      case "localweekday":
      case "localweekdays":
        return "localWeekday";
      case "localweeknumber":
      case "localweeknumbers":
        return "localWeekNumber";
      case "localweekyear":
      case "localweekyears":
        return "localWeekYear";
      default:
        return normalizeUnit(unit);
    }
  }

  // cache offsets for zones based on the current timestamp when this function is
  // first called. When we are handling a datetime from components like (year,
  // month, day, hour) in a time zone, we need a guess about what the timezone
  // offset is so that we can convert into a UTC timestamp. One way is to find the
  // offset of now in the zone. The actual date may have a different offset (for
  // example, if we handle a date in June while we're in December in a zone that
  // observes DST), but we can check and adjust that.
  //
  // When handling many dates, calculating the offset for now every time is
  // expensive. It's just a guess, so we can cache the offset to use even if we
  // are right on a time change boundary (we'll just correct in the other
  // direction). Using a timestamp from first read is a slight optimization for
  // handling dates close to the current date, since those dates will usually be
  // in the same offset (we could set the timestamp statically, instead). We use a
  // single timestamp for all zones to make things a bit more predictable.
  //
  // This is safe for quickDT (used by local() and utc()) because we don't fill in
  // higher-order units from tsNow (as we do in fromObject, this requires that
  // offset is calculated from tsNow).
  function guessOffsetForZone(zone) {
    if (!zoneOffsetGuessCache[zone]) {
      if (zoneOffsetTs === undefined) {
        zoneOffsetTs = Settings.now();
      }

      zoneOffsetGuessCache[zone] = zone.offset(zoneOffsetTs);
    }
    return zoneOffsetGuessCache[zone];
  }

  // this is a dumbed down version of fromObject() that runs about 60% faster
  // but doesn't do any validation, makes a bunch of assumptions about what units
  // are present, and so on.
  function quickDT(obj, opts) {
    const zone = normalizeZone(opts.zone, Settings.defaultZone);
    if (!zone.isValid) {
      return DateTime.invalid(unsupportedZone(zone));
    }

    const loc = Locale.fromObject(opts);

    let ts, o;

    // assume we have the higher-order units
    if (!isUndefined(obj.year)) {
      for (const u of orderedUnits) {
        if (isUndefined(obj[u])) {
          obj[u] = defaultUnitValues[u];
        }
      }

      const invalid = hasInvalidGregorianData(obj) || hasInvalidTimeData(obj);
      if (invalid) {
        return DateTime.invalid(invalid);
      }

      const offsetProvis = guessOffsetForZone(zone);
      [ts, o] = objToTS(obj, offsetProvis, zone);
    } else {
      ts = Settings.now();
    }

    return new DateTime({ ts, zone, loc, o });
  }

  function diffRelative(start, end, opts) {
    const round = isUndefined(opts.round) ? true : opts.round,
      format = (c, unit) => {
        c = roundTo(c, round || opts.calendary ? 0 : 2, true);
        const formatter = end.loc.clone(opts).relFormatter(opts);
        return formatter.format(c, unit);
      },
      differ = (unit) => {
        if (opts.calendary) {
          if (!end.hasSame(start, unit)) {
            return end.startOf(unit).diff(start.startOf(unit), unit).get(unit);
          } else return 0;
        } else {
          return end.diff(start, unit).get(unit);
        }
      };

    if (opts.unit) {
      return format(differ(opts.unit), opts.unit);
    }

    for (const unit of opts.units) {
      const count = differ(unit);
      if (Math.abs(count) >= 1) {
        return format(count, unit);
      }
    }
    return format(start > end ? -0 : 0, opts.units[opts.units.length - 1]);
  }

  function lastOpts(argList) {
    let opts = {},
      args;
    if (argList.length > 0 && typeof argList[argList.length - 1] === "object") {
      opts = argList[argList.length - 1];
      args = Array.from(argList).slice(0, argList.length - 1);
    } else {
      args = Array.from(argList);
    }
    return [opts, args];
  }

  /**
   * Timestamp to use for cached zone offset guesses (exposed for test)
   */
  let zoneOffsetTs;
  /**
   * Cache for zone offset guesses (exposed for test).
   *
   * This optimizes quickDT via guessOffsetForZone to avoid repeated calls of
   * zone.offset().
   */
  let zoneOffsetGuessCache = {};

  /**
   * A DateTime is an immutable data structure representing a specific date and time and accompanying methods. It contains class and instance methods for creating, parsing, interrogating, transforming, and formatting them.
   *
   * A DateTime comprises of:
   * * A timestamp. Each DateTime instance refers to a specific millisecond of the Unix epoch.
   * * A time zone. Each instance is considered in the context of a specific zone (by default the local system's zone).
   * * Configuration properties that effect how output strings are formatted, such as `locale`, `numberingSystem`, and `outputCalendar`.
   *
   * Here is a brief overview of the most commonly used functionality it provides:
   *
   * * **Creation**: To create a DateTime from its components, use one of its factory class methods: {@link DateTime.local}, {@link DateTime.utc}, and (most flexibly) {@link DateTime.fromObject}. To create one from a standard string format, use {@link DateTime.fromISO}, {@link DateTime.fromHTTP}, and {@link DateTime.fromRFC2822}. To create one from a custom string format, use {@link DateTime.fromFormat}. To create one from a native JS date, use {@link DateTime.fromJSDate}.
   * * **Gregorian calendar and time**: To examine the Gregorian properties of a DateTime individually (i.e as opposed to collectively through {@link DateTime#toObject}), use the {@link DateTime#year}, {@link DateTime#month},
   * {@link DateTime#day}, {@link DateTime#hour}, {@link DateTime#minute}, {@link DateTime#second}, {@link DateTime#millisecond} accessors.
   * * **Week calendar**: For ISO week calendar attributes, see the {@link DateTime#weekYear}, {@link DateTime#weekNumber}, and {@link DateTime#weekday} accessors.
   * * **Configuration** See the {@link DateTime#locale} and {@link DateTime#numberingSystem} accessors.
   * * **Transformation**: To transform the DateTime into other DateTimes, use {@link DateTime#set}, {@link DateTime#reconfigure}, {@link DateTime#setZone}, {@link DateTime#setLocale}, {@link DateTime.plus}, {@link DateTime#minus}, {@link DateTime#endOf}, {@link DateTime#startOf}, {@link DateTime#toUTC}, and {@link DateTime#toLocal}.
   * * **Output**: To convert the DateTime to other representations, use the {@link DateTime#toRelative}, {@link DateTime#toRelativeCalendar}, {@link DateTime#toJSON}, {@link DateTime#toISO}, {@link DateTime#toHTTP}, {@link DateTime#toObject}, {@link DateTime#toRFC2822}, {@link DateTime#toString}, {@link DateTime#toLocaleString}, {@link DateTime#toFormat}, {@link DateTime#toMillis} and {@link DateTime#toJSDate}.
   *
   * There's plenty others documented below. In addition, for more information on subtler topics like internationalization, time zones, alternative calendars, validity, and so on, see the external documentation.
   */
  class DateTime {
    /**
     * @access private
     */
    constructor(config) {
      const zone = config.zone || Settings.defaultZone;

      let invalid =
        config.invalid ||
        (Number.isNaN(config.ts) ? new Invalid("invalid input") : null) ||
        (!zone.isValid ? unsupportedZone(zone) : null);
      /**
       * @access private
       */
      this.ts = isUndefined(config.ts) ? Settings.now() : config.ts;

      let c = null,
        o = null;
      if (!invalid) {
        const unchanged = config.old && config.old.ts === this.ts && config.old.zone.equals(zone);

        if (unchanged) {
          [c, o] = [config.old.c, config.old.o];
        } else {
          // If an offset has been passed and we have not been called from
          // clone(), we can trust it and avoid the offset calculation.
          const ot = isNumber$1(config.o) && !config.old ? config.o : zone.offset(this.ts);
          c = tsToObj(this.ts, ot);
          invalid = Number.isNaN(c.year) ? new Invalid("invalid input") : null;
          c = invalid ? null : c;
          o = invalid ? null : ot;
        }
      }

      /**
       * @access private
       */
      this._zone = zone;
      /**
       * @access private
       */
      this.loc = config.loc || Locale.create();
      /**
       * @access private
       */
      this.invalid = invalid;
      /**
       * @access private
       */
      this.weekData = null;
      /**
       * @access private
       */
      this.localWeekData = null;
      /**
       * @access private
       */
      this.c = c;
      /**
       * @access private
       */
      this.o = o;
      /**
       * @access private
       */
      this.isLuxonDateTime = true;
    }

    // CONSTRUCT

    /**
     * Create a DateTime for the current instant, in the system's time zone.
     *
     * Use Settings to override these default values if needed.
     * @example DateTime.now().toISO() //~> now in the ISO format
     * @return {DateTime}
     */
    static now() {
      return new DateTime({});
    }

    /**
     * Create a local DateTime
     * @param {number} [year] - The calendar year. If omitted (as in, call `local()` with no arguments), the current time will be used
     * @param {number} [month=1] - The month, 1-indexed
     * @param {number} [day=1] - The day of the month, 1-indexed
     * @param {number} [hour=0] - The hour of the day, in 24-hour time
     * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
     * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
     * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
     * @example DateTime.local()                                  //~> now
     * @example DateTime.local({ zone: "America/New_York" })      //~> now, in US east coast time
     * @example DateTime.local(2017)                              //~> 2017-01-01T00:00:00
     * @example DateTime.local(2017, 3)                           //~> 2017-03-01T00:00:00
     * @example DateTime.local(2017, 3, 12, { locale: "fr" })     //~> 2017-03-12T00:00:00, with a French locale
     * @example DateTime.local(2017, 3, 12, 5)                    //~> 2017-03-12T05:00:00
     * @example DateTime.local(2017, 3, 12, 5, { zone: "utc" })   //~> 2017-03-12T05:00:00, in UTC
     * @example DateTime.local(2017, 3, 12, 5, 45)                //~> 2017-03-12T05:45:00
     * @example DateTime.local(2017, 3, 12, 5, 45, 10)            //~> 2017-03-12T05:45:10
     * @example DateTime.local(2017, 3, 12, 5, 45, 10, 765)       //~> 2017-03-12T05:45:10.765
     * @return {DateTime}
     */
    static local() {
      const [opts, args] = lastOpts(arguments),
        [year, month, day, hour, minute, second, millisecond] = args;
      return quickDT({ year, month, day, hour, minute, second, millisecond }, opts);
    }

    /**
     * Create a DateTime in UTC
     * @param {number} [year] - The calendar year. If omitted (as in, call `utc()` with no arguments), the current time will be used
     * @param {number} [month=1] - The month, 1-indexed
     * @param {number} [day=1] - The day of the month
     * @param {number} [hour=0] - The hour of the day, in 24-hour time
     * @param {number} [minute=0] - The minute of the hour, meaning a number between 0 and 59
     * @param {number} [second=0] - The second of the minute, meaning a number between 0 and 59
     * @param {number} [millisecond=0] - The millisecond of the second, meaning a number between 0 and 999
     * @param {Object} options - configuration options for the DateTime
     * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
     * @param {string} [options.outputCalendar] - the output calendar to set on the resulting DateTime instance
     * @param {string} [options.numberingSystem] - the numbering system to set on the resulting DateTime instance
     * @param {string} [options.weekSettings] - the week settings to set on the resulting DateTime instance
     * @example DateTime.utc()                                              //~> now
     * @example DateTime.utc(2017)                                          //~> 2017-01-01T00:00:00Z
     * @example DateTime.utc(2017, 3)                                       //~> 2017-03-01T00:00:00Z
     * @example DateTime.utc(2017, 3, 12)                                   //~> 2017-03-12T00:00:00Z
     * @example DateTime.utc(2017, 3, 12, 5)                                //~> 2017-03-12T05:00:00Z
     * @example DateTime.utc(2017, 3, 12, 5, 45)                            //~> 2017-03-12T05:45:00Z
     * @example DateTime.utc(2017, 3, 12, 5, 45, { locale: "fr" })          //~> 2017-03-12T05:45:00Z with a French locale
     * @example DateTime.utc(2017, 3, 12, 5, 45, 10)                        //~> 2017-03-12T05:45:10Z
     * @example DateTime.utc(2017, 3, 12, 5, 45, 10, 765, { locale: "fr" }) //~> 2017-03-12T05:45:10.765Z with a French locale
     * @return {DateTime}
     */
    static utc() {
      const [opts, args] = lastOpts(arguments),
        [year, month, day, hour, minute, second, millisecond] = args;

      opts.zone = FixedOffsetZone.utcInstance;
      return quickDT({ year, month, day, hour, minute, second, millisecond }, opts);
    }

    /**
     * Create a DateTime from a JavaScript Date object. Uses the default zone.
     * @param {Date} date - a JavaScript Date object
     * @param {Object} options - configuration options for the DateTime
     * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
     * @return {DateTime}
     */
    static fromJSDate(date, options = {}) {
      const ts = isDate(date) ? date.valueOf() : NaN;
      if (Number.isNaN(ts)) {
        return DateTime.invalid("invalid input");
      }

      const zoneToUse = normalizeZone(options.zone, Settings.defaultZone);
      if (!zoneToUse.isValid) {
        return DateTime.invalid(unsupportedZone(zoneToUse));
      }

      return new DateTime({
        ts: ts,
        zone: zoneToUse,
        loc: Locale.fromObject(options),
      });
    }

    /**
     * Create a DateTime from a number of milliseconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
     * @param {number} milliseconds - a number of milliseconds since 1970 UTC
     * @param {Object} options - configuration options for the DateTime
     * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
     * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
     * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
     * @param {string} options.weekSettings - the week settings to set on the resulting DateTime instance
     * @return {DateTime}
     */
    static fromMillis(milliseconds, options = {}) {
      if (!isNumber$1(milliseconds)) {
        throw new InvalidArgumentError(
          `fromMillis requires a numerical input, but received a ${typeof milliseconds} with value ${milliseconds}`
        );
      } else if (milliseconds < -MAX_DATE || milliseconds > MAX_DATE) {
        // this isn't perfect because we can still end up out of range because of additional shifting, but it's a start
        return DateTime.invalid("Timestamp out of range");
      } else {
        return new DateTime({
          ts: milliseconds,
          zone: normalizeZone(options.zone, Settings.defaultZone),
          loc: Locale.fromObject(options),
        });
      }
    }

    /**
     * Create a DateTime from a number of seconds since the epoch (meaning since 1 January 1970 00:00:00 UTC). Uses the default zone.
     * @param {number} seconds - a number of seconds since 1970 UTC
     * @param {Object} options - configuration options for the DateTime
     * @param {string|Zone} [options.zone='local'] - the zone to place the DateTime into
     * @param {string} [options.locale] - a locale to set on the resulting DateTime instance
     * @param {string} options.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @param {string} options.numberingSystem - the numbering system to set on the resulting DateTime instance
     * @param {string} options.weekSettings - the week settings to set on the resulting DateTime instance
     * @return {DateTime}
     */
    static fromSeconds(seconds, options = {}) {
      if (!isNumber$1(seconds)) {
        throw new InvalidArgumentError("fromSeconds requires a numerical input");
      } else {
        return new DateTime({
          ts: seconds * 1000,
          zone: normalizeZone(options.zone, Settings.defaultZone),
          loc: Locale.fromObject(options),
        });
      }
    }

    /**
     * Create a DateTime from a JavaScript object with keys like 'year' and 'hour' with reasonable defaults.
     * @param {Object} obj - the object to create the DateTime from
     * @param {number} obj.year - a year, such as 1987
     * @param {number} obj.month - a month, 1-12
     * @param {number} obj.day - a day of the month, 1-31, depending on the month
     * @param {number} obj.ordinal - day of the year, 1-365 or 366
     * @param {number} obj.weekYear - an ISO week year
     * @param {number} obj.weekNumber - an ISO week number, between 1 and 52 or 53, depending on the year
     * @param {number} obj.weekday - an ISO weekday, 1-7, where 1 is Monday and 7 is Sunday
     * @param {number} obj.localWeekYear - a week year, according to the locale
     * @param {number} obj.localWeekNumber - a week number, between 1 and 52 or 53, depending on the year, according to the locale
     * @param {number} obj.localWeekday - a weekday, 1-7, where 1 is the first and 7 is the last day of the week, according to the locale
     * @param {number} obj.hour - hour of the day, 0-23
     * @param {number} obj.minute - minute of the hour, 0-59
     * @param {number} obj.second - second of the minute, 0-59
     * @param {number} obj.millisecond - millisecond of the second, 0-999
     * @param {Object} opts - options for creating this DateTime
     * @param {string|Zone} [opts.zone='local'] - interpret the numbers in the context of a particular zone. Can take any value taken as the first argument to setZone()
     * @param {string} [opts.locale='system\'s locale'] - a locale to set on the resulting DateTime instance
     * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
     * @param {string} opts.weekSettings - the week settings to set on the resulting DateTime instance
     * @example DateTime.fromObject({ year: 1982, month: 5, day: 25}).toISODate() //=> '1982-05-25'
     * @example DateTime.fromObject({ year: 1982 }).toISODate() //=> '1982-01-01'
     * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }) //~> today at 10:26:06
     * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'utc' }),
     * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'local' })
     * @example DateTime.fromObject({ hour: 10, minute: 26, second: 6 }, { zone: 'America/New_York' })
     * @example DateTime.fromObject({ weekYear: 2016, weekNumber: 2, weekday: 3 }).toISODate() //=> '2016-01-13'
     * @example DateTime.fromObject({ localWeekYear: 2022, localWeekNumber: 1, localWeekday: 1 }, { locale: "en-US" }).toISODate() //=> '2021-12-26'
     * @return {DateTime}
     */
    static fromObject(obj, opts = {}) {
      obj = obj || {};
      const zoneToUse = normalizeZone(opts.zone, Settings.defaultZone);
      if (!zoneToUse.isValid) {
        return DateTime.invalid(unsupportedZone(zoneToUse));
      }

      const loc = Locale.fromObject(opts);
      const normalized = normalizeObject(obj, normalizeUnitWithLocalWeeks);
      const { minDaysInFirstWeek, startOfWeek } = usesLocalWeekValues(normalized, loc);

      const tsNow = Settings.now(),
        offsetProvis = !isUndefined(opts.specificOffset)
          ? opts.specificOffset
          : zoneToUse.offset(tsNow),
        containsOrdinal = !isUndefined(normalized.ordinal),
        containsGregorYear = !isUndefined(normalized.year),
        containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
        containsGregor = containsGregorYear || containsGregorMD,
        definiteWeekDef = normalized.weekYear || normalized.weekNumber;

      // cases:
      // just a weekday -> this week's instance of that weekday, no worries
      // (gregorian data or ordinal) + (weekYear or weekNumber) -> error
      // (gregorian month or day) + ordinal -> error
      // otherwise just use weeks or ordinals or gregorian, depending on what's specified

      if ((containsGregor || containsOrdinal) && definiteWeekDef) {
        throw new ConflictingSpecificationError(
          "Can't mix weekYear/weekNumber units with year/month/day or ordinals"
        );
      }

      if (containsGregorMD && containsOrdinal) {
        throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
      }

      const useWeekData = definiteWeekDef || (normalized.weekday && !containsGregor);

      // configure ourselves to deal with gregorian dates or week stuff
      let units,
        defaultValues,
        objNow = tsToObj(tsNow, offsetProvis);
      if (useWeekData) {
        units = orderedWeekUnits;
        defaultValues = defaultWeekUnitValues;
        objNow = gregorianToWeek(objNow, minDaysInFirstWeek, startOfWeek);
      } else if (containsOrdinal) {
        units = orderedOrdinalUnits;
        defaultValues = defaultOrdinalUnitValues;
        objNow = gregorianToOrdinal(objNow);
      } else {
        units = orderedUnits;
        defaultValues = defaultUnitValues;
      }

      // set default values for missing stuff
      let foundFirst = false;
      for (const u of units) {
        const v = normalized[u];
        if (!isUndefined(v)) {
          foundFirst = true;
        } else if (foundFirst) {
          normalized[u] = defaultValues[u];
        } else {
          normalized[u] = objNow[u];
        }
      }

      // make sure the values we have are in range
      const higherOrderInvalid = useWeekData
          ? hasInvalidWeekData(normalized, minDaysInFirstWeek, startOfWeek)
          : containsOrdinal
          ? hasInvalidOrdinalData(normalized)
          : hasInvalidGregorianData(normalized),
        invalid = higherOrderInvalid || hasInvalidTimeData(normalized);

      if (invalid) {
        return DateTime.invalid(invalid);
      }

      // compute the actual time
      const gregorian = useWeekData
          ? weekToGregorian(normalized, minDaysInFirstWeek, startOfWeek)
          : containsOrdinal
          ? ordinalToGregorian(normalized)
          : normalized,
        [tsFinal, offsetFinal] = objToTS(gregorian, offsetProvis, zoneToUse),
        inst = new DateTime({
          ts: tsFinal,
          zone: zoneToUse,
          o: offsetFinal,
          loc,
        });

      // gregorian data + weekday serves only to validate
      if (normalized.weekday && containsGregor && obj.weekday !== inst.weekday) {
        return DateTime.invalid(
          "mismatched weekday",
          `you can't specify both a weekday of ${normalized.weekday} and a date of ${inst.toISO()}`
        );
      }

      if (!inst.isValid) {
        return DateTime.invalid(inst.invalid);
      }

      return inst;
    }

    /**
     * Create a DateTime from an ISO 8601 string
     * @param {string} text - the ISO string
     * @param {Object} opts - options to affect the creation
     * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the time to this zone
     * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
     * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
     * @param {string} [opts.outputCalendar] - the output calendar to set on the resulting DateTime instance
     * @param {string} [opts.numberingSystem] - the numbering system to set on the resulting DateTime instance
     * @param {string} [opts.weekSettings] - the week settings to set on the resulting DateTime instance
     * @example DateTime.fromISO('2016-05-25T09:08:34.123')
     * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00')
     * @example DateTime.fromISO('2016-05-25T09:08:34.123+06:00', {setZone: true})
     * @example DateTime.fromISO('2016-05-25T09:08:34.123', {zone: 'utc'})
     * @example DateTime.fromISO('2016-W05-4')
     * @return {DateTime}
     */
    static fromISO(text, opts = {}) {
      const [vals, parsedZone] = parseISODate(text);
      return parseDataToDateTime(vals, parsedZone, opts, "ISO 8601", text);
    }

    /**
     * Create a DateTime from an RFC 2822 string
     * @param {string} text - the RFC 2822 string
     * @param {Object} opts - options to affect the creation
     * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since the offset is always specified in the string itself, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
     * @param {boolean} [opts.setZone=false] - override the zone with a fixed-offset zone specified in the string itself, if it specifies one
     * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
     * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
     * @param {string} opts.weekSettings - the week settings to set on the resulting DateTime instance
     * @example DateTime.fromRFC2822('25 Nov 2016 13:23:12 GMT')
     * @example DateTime.fromRFC2822('Fri, 25 Nov 2016 13:23:12 +0600')
     * @example DateTime.fromRFC2822('25 Nov 2016 13:23 Z')
     * @return {DateTime}
     */
    static fromRFC2822(text, opts = {}) {
      const [vals, parsedZone] = parseRFC2822Date(text);
      return parseDataToDateTime(vals, parsedZone, opts, "RFC 2822", text);
    }

    /**
     * Create a DateTime from an HTTP header date
     * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
     * @param {string} text - the HTTP header date
     * @param {Object} opts - options to affect the creation
     * @param {string|Zone} [opts.zone='local'] - convert the time to this zone. Since HTTP dates are always in UTC, this has no effect on the interpretation of string, merely the zone the resulting DateTime is expressed in.
     * @param {boolean} [opts.setZone=false] - override the zone with the fixed-offset zone specified in the string. For HTTP dates, this is always UTC, so this option is equivalent to setting the `zone` option to 'utc', but this option is included for consistency with similar methods.
     * @param {string} [opts.locale='system's locale'] - a locale to set on the resulting DateTime instance
     * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @param {string} opts.numberingSystem - the numbering system to set on the resulting DateTime instance
     * @param {string} opts.weekSettings - the week settings to set on the resulting DateTime instance
     * @example DateTime.fromHTTP('Sun, 06 Nov 1994 08:49:37 GMT')
     * @example DateTime.fromHTTP('Sunday, 06-Nov-94 08:49:37 GMT')
     * @example DateTime.fromHTTP('Sun Nov  6 08:49:37 1994')
     * @return {DateTime}
     */
    static fromHTTP(text, opts = {}) {
      const [vals, parsedZone] = parseHTTPDate(text);
      return parseDataToDateTime(vals, parsedZone, opts, "HTTP", opts);
    }

    /**
     * Create a DateTime from an input string and format string.
     * Defaults to en-US if no locale has been specified, regardless of the system's locale. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/parsing?id=table-of-tokens).
     * @param {string} text - the string to parse
     * @param {string} fmt - the format the string is expected to be in (see the link below for the formats)
     * @param {Object} opts - options to affect the creation
     * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
     * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
     * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
     * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
     * @param {string} opts.weekSettings - the week settings to set on the resulting DateTime instance
     * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @return {DateTime}
     */
    static fromFormat(text, fmt, opts = {}) {
      if (isUndefined(text) || isUndefined(fmt)) {
        throw new InvalidArgumentError("fromFormat requires an input string and a format");
      }

      const { locale = null, numberingSystem = null } = opts,
        localeToUse = Locale.fromOpts({
          locale,
          numberingSystem,
          defaultToEN: true,
        }),
        [vals, parsedZone, specificOffset, invalid] = parseFromTokens(localeToUse, text, fmt);
      if (invalid) {
        return DateTime.invalid(invalid);
      } else {
        return parseDataToDateTime(vals, parsedZone, opts, `format ${fmt}`, text, specificOffset);
      }
    }

    /**
     * @deprecated use fromFormat instead
     */
    static fromString(text, fmt, opts = {}) {
      return DateTime.fromFormat(text, fmt, opts);
    }

    /**
     * Create a DateTime from a SQL date, time, or datetime
     * Defaults to en-US if no locale has been specified, regardless of the system's locale
     * @param {string} text - the string to parse
     * @param {Object} opts - options to affect the creation
     * @param {string|Zone} [opts.zone='local'] - use this zone if no offset is specified in the input string itself. Will also convert the DateTime to this zone
     * @param {boolean} [opts.setZone=false] - override the zone with a zone specified in the string itself, if it specifies one
     * @param {string} [opts.locale='en-US'] - a locale string to use when parsing. Will also set the DateTime to this locale
     * @param {string} opts.numberingSystem - the numbering system to use when parsing. Will also set the resulting DateTime to this numbering system
     * @param {string} opts.weekSettings - the week settings to set on the resulting DateTime instance
     * @param {string} opts.outputCalendar - the output calendar to set on the resulting DateTime instance
     * @example DateTime.fromSQL('2017-05-15')
     * @example DateTime.fromSQL('2017-05-15 09:12:34')
     * @example DateTime.fromSQL('2017-05-15 09:12:34.342')
     * @example DateTime.fromSQL('2017-05-15 09:12:34.342+06:00')
     * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles')
     * @example DateTime.fromSQL('2017-05-15 09:12:34.342 America/Los_Angeles', { setZone: true })
     * @example DateTime.fromSQL('2017-05-15 09:12:34.342', { zone: 'America/Los_Angeles' })
     * @example DateTime.fromSQL('09:12:34.342')
     * @return {DateTime}
     */
    static fromSQL(text, opts = {}) {
      const [vals, parsedZone] = parseSQL(text);
      return parseDataToDateTime(vals, parsedZone, opts, "SQL", text);
    }

    /**
     * Create an invalid DateTime.
     * @param {string} reason - simple string of why this DateTime is invalid. Should not contain parameters or anything else data-dependent.
     * @param {string} [explanation=null] - longer explanation, may include parameters and other useful debugging information
     * @return {DateTime}
     */
    static invalid(reason, explanation = null) {
      if (!reason) {
        throw new InvalidArgumentError("need to specify a reason the DateTime is invalid");
      }

      const invalid = reason instanceof Invalid ? reason : new Invalid(reason, explanation);

      if (Settings.throwOnInvalid) {
        throw new InvalidDateTimeError(invalid);
      } else {
        return new DateTime({ invalid });
      }
    }

    /**
     * Check if an object is an instance of DateTime. Works across context boundaries
     * @param {object} o
     * @return {boolean}
     */
    static isDateTime(o) {
      return (o && o.isLuxonDateTime) || false;
    }

    /**
     * Produce the format string for a set of options
     * @param formatOpts
     * @param localeOpts
     * @returns {string}
     */
    static parseFormatForOpts(formatOpts, localeOpts = {}) {
      const tokenList = formatOptsToTokens(formatOpts, Locale.fromObject(localeOpts));
      return !tokenList ? null : tokenList.map((t) => (t ? t.val : null)).join("");
    }

    /**
     * Produce the the fully expanded format token for the locale
     * Does NOT quote characters, so quoted tokens will not round trip correctly
     * @param fmt
     * @param localeOpts
     * @returns {string}
     */
    static expandFormat(fmt, localeOpts = {}) {
      const expanded = expandMacroTokens(Formatter.parseFormat(fmt), Locale.fromObject(localeOpts));
      return expanded.map((t) => t.val).join("");
    }

    static resetCache() {
      zoneOffsetTs = undefined;
      zoneOffsetGuessCache = {};
    }

    // INFO

    /**
     * Get the value of unit.
     * @param {string} unit - a unit such as 'minute' or 'day'
     * @example DateTime.local(2017, 7, 4).get('month'); //=> 7
     * @example DateTime.local(2017, 7, 4).get('day'); //=> 4
     * @return {number}
     */
    get(unit) {
      return this[unit];
    }

    /**
     * Returns whether the DateTime is valid. Invalid DateTimes occur when:
     * * The DateTime was created from invalid calendar information, such as the 13th month or February 30
     * * The DateTime was created by an operation on another invalid date
     * @type {boolean}
     */
    get isValid() {
      return this.invalid === null;
    }

    /**
     * Returns an error code if this DateTime is invalid, or null if the DateTime is valid
     * @type {string}
     */
    get invalidReason() {
      return this.invalid ? this.invalid.reason : null;
    }

    /**
     * Returns an explanation of why this DateTime became invalid, or null if the DateTime is valid
     * @type {string}
     */
    get invalidExplanation() {
      return this.invalid ? this.invalid.explanation : null;
    }

    /**
     * Get the locale of a DateTime, such 'en-GB'. The locale is used when formatting the DateTime
     *
     * @type {string}
     */
    get locale() {
      return this.isValid ? this.loc.locale : null;
    }

    /**
     * Get the numbering system of a DateTime, such 'beng'. The numbering system is used when formatting the DateTime
     *
     * @type {string}
     */
    get numberingSystem() {
      return this.isValid ? this.loc.numberingSystem : null;
    }

    /**
     * Get the output calendar of a DateTime, such 'islamic'. The output calendar is used when formatting the DateTime
     *
     * @type {string}
     */
    get outputCalendar() {
      return this.isValid ? this.loc.outputCalendar : null;
    }

    /**
     * Get the time zone associated with this DateTime.
     * @type {Zone}
     */
    get zone() {
      return this._zone;
    }

    /**
     * Get the name of the time zone.
     * @type {string}
     */
    get zoneName() {
      return this.isValid ? this.zone.name : null;
    }

    /**
     * Get the year
     * @example DateTime.local(2017, 5, 25).year //=> 2017
     * @type {number}
     */
    get year() {
      return this.isValid ? this.c.year : NaN;
    }

    /**
     * Get the quarter
     * @example DateTime.local(2017, 5, 25).quarter //=> 2
     * @type {number}
     */
    get quarter() {
      return this.isValid ? Math.ceil(this.c.month / 3) : NaN;
    }

    /**
     * Get the month (1-12).
     * @example DateTime.local(2017, 5, 25).month //=> 5
     * @type {number}
     */
    get month() {
      return this.isValid ? this.c.month : NaN;
    }

    /**
     * Get the day of the month (1-30ish).
     * @example DateTime.local(2017, 5, 25).day //=> 25
     * @type {number}
     */
    get day() {
      return this.isValid ? this.c.day : NaN;
    }

    /**
     * Get the hour of the day (0-23).
     * @example DateTime.local(2017, 5, 25, 9).hour //=> 9
     * @type {number}
     */
    get hour() {
      return this.isValid ? this.c.hour : NaN;
    }

    /**
     * Get the minute of the hour (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30).minute //=> 30
     * @type {number}
     */
    get minute() {
      return this.isValid ? this.c.minute : NaN;
    }

    /**
     * Get the second of the minute (0-59).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52).second //=> 52
     * @type {number}
     */
    get second() {
      return this.isValid ? this.c.second : NaN;
    }

    /**
     * Get the millisecond of the second (0-999).
     * @example DateTime.local(2017, 5, 25, 9, 30, 52, 654).millisecond //=> 654
     * @type {number}
     */
    get millisecond() {
      return this.isValid ? this.c.millisecond : NaN;
    }

    /**
     * Get the week year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 12, 31).weekYear //=> 2015
     * @type {number}
     */
    get weekYear() {
      return this.isValid ? possiblyCachedWeekData(this).weekYear : NaN;
    }

    /**
     * Get the week number of the week year (1-52ish).
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2017, 5, 25).weekNumber //=> 21
     * @type {number}
     */
    get weekNumber() {
      return this.isValid ? possiblyCachedWeekData(this).weekNumber : NaN;
    }

    /**
     * Get the day of the week.
     * 1 is Monday and 7 is Sunday
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2014, 11, 31).weekday //=> 4
     * @type {number}
     */
    get weekday() {
      return this.isValid ? possiblyCachedWeekData(this).weekday : NaN;
    }

    /**
     * Returns true if this date is on a weekend according to the locale, false otherwise
     * @returns {boolean}
     */
    get isWeekend() {
      return this.isValid && this.loc.getWeekendDays().includes(this.weekday);
    }

    /**
     * Get the day of the week according to the locale.
     * 1 is the first day of the week and 7 is the last day of the week.
     * If the locale assigns Sunday as the first day of the week, then a date which is a Sunday will return 1,
     * @returns {number}
     */
    get localWeekday() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekday : NaN;
    }

    /**
     * Get the week number of the week year according to the locale. Different locales assign week numbers differently,
     * because the week can start on different days of the week (see localWeekday) and because a different number of days
     * is required for a week to count as the first week of a year.
     * @returns {number}
     */
    get localWeekNumber() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekNumber : NaN;
    }

    /**
     * Get the week year according to the locale. Different locales assign week numbers (and therefor week years)
     * differently, see localWeekNumber.
     * @returns {number}
     */
    get localWeekYear() {
      return this.isValid ? possiblyCachedLocalWeekData(this).weekYear : NaN;
    }

    /**
     * Get the ordinal (meaning the day of the year)
     * @example DateTime.local(2017, 5, 25).ordinal //=> 145
     * @type {number|DateTime}
     */
    get ordinal() {
      return this.isValid ? gregorianToOrdinal(this.c).ordinal : NaN;
    }

    /**
     * Get the human readable short month name, such as 'Oct'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthShort //=> Oct
     * @type {string}
     */
    get monthShort() {
      return this.isValid ? Info.months("short", { locObj: this.loc })[this.month - 1] : null;
    }

    /**
     * Get the human readable long month name, such as 'October'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).monthLong //=> October
     * @type {string}
     */
    get monthLong() {
      return this.isValid ? Info.months("long", { locObj: this.loc })[this.month - 1] : null;
    }

    /**
     * Get the human readable short weekday, such as 'Mon'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayShort //=> Mon
     * @type {string}
     */
    get weekdayShort() {
      return this.isValid ? Info.weekdays("short", { locObj: this.loc })[this.weekday - 1] : null;
    }

    /**
     * Get the human readable long weekday, such as 'Monday'.
     * Defaults to the system's locale if no locale has been specified
     * @example DateTime.local(2017, 10, 30).weekdayLong //=> Monday
     * @type {string}
     */
    get weekdayLong() {
      return this.isValid ? Info.weekdays("long", { locObj: this.loc })[this.weekday - 1] : null;
    }

    /**
     * Get the UTC offset of this DateTime in minutes
     * @example DateTime.now().offset //=> -240
     * @example DateTime.utc().offset //=> 0
     * @type {number}
     */
    get offset() {
      return this.isValid ? +this.o : NaN;
    }

    /**
     * Get the short human name for the zone's current offset, for example "EST" or "EDT".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */
    get offsetNameShort() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "short",
          locale: this.locale,
        });
      } else {
        return null;
      }
    }

    /**
     * Get the long human name for the zone's current offset, for example "Eastern Standard Time" or "Eastern Daylight Time".
     * Defaults to the system's locale if no locale has been specified
     * @type {string}
     */
    get offsetNameLong() {
      if (this.isValid) {
        return this.zone.offsetName(this.ts, {
          format: "long",
          locale: this.locale,
        });
      } else {
        return null;
      }
    }

    /**
     * Get whether this zone's offset ever changes, as in a DST.
     * @type {boolean}
     */
    get isOffsetFixed() {
      return this.isValid ? this.zone.isUniversal : null;
    }

    /**
     * Get whether the DateTime is in a DST.
     * @type {boolean}
     */
    get isInDST() {
      if (this.isOffsetFixed) {
        return false;
      } else {
        return (
          this.offset > this.set({ month: 1, day: 1 }).offset ||
          this.offset > this.set({ month: 5 }).offset
        );
      }
    }

    /**
     * Get those DateTimes which have the same local time as this DateTime, but a different offset from UTC
     * in this DateTime's zone. During DST changes local time can be ambiguous, for example
     * `2023-10-29T02:30:00` in `Europe/Berlin` can have offset `+01:00` or `+02:00`.
     * This method will return both possible DateTimes if this DateTime's local time is ambiguous.
     * @returns {DateTime[]}
     */
    getPossibleOffsets() {
      if (!this.isValid || this.isOffsetFixed) {
        return [this];
      }
      const dayMs = 86400000;
      const minuteMs = 60000;
      const localTS = objToLocalTS(this.c);
      const oEarlier = this.zone.offset(localTS - dayMs);
      const oLater = this.zone.offset(localTS + dayMs);

      const o1 = this.zone.offset(localTS - oEarlier * minuteMs);
      const o2 = this.zone.offset(localTS - oLater * minuteMs);
      if (o1 === o2) {
        return [this];
      }
      const ts1 = localTS - o1 * minuteMs;
      const ts2 = localTS - o2 * minuteMs;
      const c1 = tsToObj(ts1, o1);
      const c2 = tsToObj(ts2, o2);
      if (
        c1.hour === c2.hour &&
        c1.minute === c2.minute &&
        c1.second === c2.second &&
        c1.millisecond === c2.millisecond
      ) {
        return [clone$2(this, { ts: ts1 }), clone$2(this, { ts: ts2 })];
      }
      return [this];
    }

    /**
     * Returns true if this DateTime is in a leap year, false otherwise
     * @example DateTime.local(2016).isInLeapYear //=> true
     * @example DateTime.local(2013).isInLeapYear //=> false
     * @type {boolean}
     */
    get isInLeapYear() {
      return isLeapYear(this.year);
    }

    /**
     * Returns the number of days in this DateTime's month
     * @example DateTime.local(2016, 2).daysInMonth //=> 29
     * @example DateTime.local(2016, 3).daysInMonth //=> 31
     * @type {number}
     */
    get daysInMonth() {
      return daysInMonth(this.year, this.month);
    }

    /**
     * Returns the number of days in this DateTime's year
     * @example DateTime.local(2016).daysInYear //=> 366
     * @example DateTime.local(2013).daysInYear //=> 365
     * @type {number}
     */
    get daysInYear() {
      return this.isValid ? daysInYear(this.year) : NaN;
    }

    /**
     * Returns the number of weeks in this DateTime's year
     * @see https://en.wikipedia.org/wiki/ISO_week_date
     * @example DateTime.local(2004).weeksInWeekYear //=> 53
     * @example DateTime.local(2013).weeksInWeekYear //=> 52
     * @type {number}
     */
    get weeksInWeekYear() {
      return this.isValid ? weeksInWeekYear(this.weekYear) : NaN;
    }

    /**
     * Returns the number of weeks in this DateTime's local week year
     * @example DateTime.local(2020, 6, {locale: 'en-US'}).weeksInLocalWeekYear //=> 52
     * @example DateTime.local(2020, 6, {locale: 'de-DE'}).weeksInLocalWeekYear //=> 53
     * @type {number}
     */
    get weeksInLocalWeekYear() {
      return this.isValid
        ? weeksInWeekYear(
            this.localWeekYear,
            this.loc.getMinDaysInFirstWeek(),
            this.loc.getStartOfWeek()
          )
        : NaN;
    }

    /**
     * Returns the resolved Intl options for this DateTime.
     * This is useful in understanding the behavior of formatting methods
     * @param {Object} opts - the same options as toLocaleString
     * @return {Object}
     */
    resolvedLocaleOptions(opts = {}) {
      const { locale, numberingSystem, calendar } = Formatter.create(
        this.loc.clone(opts),
        opts
      ).resolvedOptions(this);
      return { locale, numberingSystem, outputCalendar: calendar };
    }

    // TRANSFORM

    /**
     * "Set" the DateTime's zone to UTC. Returns a newly-constructed DateTime.
     *
     * Equivalent to {@link DateTime#setZone}('utc')
     * @param {number} [offset=0] - optionally, an offset from UTC in minutes
     * @param {Object} [opts={}] - options to pass to `setZone()`
     * @return {DateTime}
     */
    toUTC(offset = 0, opts = {}) {
      return this.setZone(FixedOffsetZone.instance(offset), opts);
    }

    /**
     * "Set" the DateTime's zone to the host's local zone. Returns a newly-constructed DateTime.
     *
     * Equivalent to `setZone('local')`
     * @return {DateTime}
     */
    toLocal() {
      return this.setZone(Settings.defaultZone);
    }

    /**
     * "Set" the DateTime's zone to specified zone. Returns a newly-constructed DateTime.
     *
     * By default, the setter keeps the underlying time the same (as in, the same timestamp), but the new instance will report different local times and consider DSTs when making computations, as with {@link DateTime#plus}. You may wish to use {@link DateTime#toLocal} and {@link DateTime#toUTC} which provide simple convenience wrappers for commonly used zones.
     * @param {string|Zone} [zone='local'] - a zone identifier. As a string, that can be any IANA zone supported by the host environment, or a fixed-offset name of the form 'UTC+3', or the strings 'local' or 'utc'. You may also supply an instance of a {@link DateTime#Zone} class.
     * @param {Object} opts - options
     * @param {boolean} [opts.keepLocalTime=false] - If true, adjust the underlying time so that the local time stays the same, but in the target zone. You should rarely need this.
     * @return {DateTime}
     */
    setZone(zone, { keepLocalTime = false, keepCalendarTime = false } = {}) {
      zone = normalizeZone(zone, Settings.defaultZone);
      if (zone.equals(this.zone)) {
        return this;
      } else if (!zone.isValid) {
        return DateTime.invalid(unsupportedZone(zone));
      } else {
        let newTS = this.ts;
        if (keepLocalTime || keepCalendarTime) {
          const offsetGuess = zone.offset(this.ts);
          const asObj = this.toObject();
          [newTS] = objToTS(asObj, offsetGuess, zone);
        }
        return clone$2(this, { ts: newTS, zone });
      }
    }

    /**
     * "Set" the locale, numberingSystem, or outputCalendar. Returns a newly-constructed DateTime.
     * @param {Object} properties - the properties to set
     * @example DateTime.local(2017, 5, 25).reconfigure({ locale: 'en-GB' })
     * @return {DateTime}
     */
    reconfigure({ locale, numberingSystem, outputCalendar } = {}) {
      const loc = this.loc.clone({ locale, numberingSystem, outputCalendar });
      return clone$2(this, { loc });
    }

    /**
     * "Set" the locale. Returns a newly-constructed DateTime.
     * Just a convenient alias for reconfigure({ locale })
     * @example DateTime.local(2017, 5, 25).setLocale('en-GB')
     * @return {DateTime}
     */
    setLocale(locale) {
      return this.reconfigure({ locale });
    }

    /**
     * "Set" the values of specified units. Returns a newly-constructed DateTime.
     * You can only set units with this method; for "setting" metadata, see {@link DateTime#reconfigure} and {@link DateTime#setZone}.
     *
     * This method also supports setting locale-based week units, i.e. `localWeekday`, `localWeekNumber` and `localWeekYear`.
     * They cannot be mixed with ISO-week units like `weekday`.
     * @param {Object} values - a mapping of units to numbers
     * @example dt.set({ year: 2017 })
     * @example dt.set({ hour: 8, minute: 30 })
     * @example dt.set({ weekday: 5 })
     * @example dt.set({ year: 2005, ordinal: 234 })
     * @return {DateTime}
     */
    set(values) {
      if (!this.isValid) return this;

      const normalized = normalizeObject(values, normalizeUnitWithLocalWeeks);
      const { minDaysInFirstWeek, startOfWeek } = usesLocalWeekValues(normalized, this.loc);

      const settingWeekStuff =
          !isUndefined(normalized.weekYear) ||
          !isUndefined(normalized.weekNumber) ||
          !isUndefined(normalized.weekday),
        containsOrdinal = !isUndefined(normalized.ordinal),
        containsGregorYear = !isUndefined(normalized.year),
        containsGregorMD = !isUndefined(normalized.month) || !isUndefined(normalized.day),
        containsGregor = containsGregorYear || containsGregorMD,
        definiteWeekDef = normalized.weekYear || normalized.weekNumber;

      if ((containsGregor || containsOrdinal) && definiteWeekDef) {
        throw new ConflictingSpecificationError(
          "Can't mix weekYear/weekNumber units with year/month/day or ordinals"
        );
      }

      if (containsGregorMD && containsOrdinal) {
        throw new ConflictingSpecificationError("Can't mix ordinal dates with month/day");
      }

      let mixed;
      if (settingWeekStuff) {
        mixed = weekToGregorian(
          { ...gregorianToWeek(this.c, minDaysInFirstWeek, startOfWeek), ...normalized },
          minDaysInFirstWeek,
          startOfWeek
        );
      } else if (!isUndefined(normalized.ordinal)) {
        mixed = ordinalToGregorian({ ...gregorianToOrdinal(this.c), ...normalized });
      } else {
        mixed = { ...this.toObject(), ...normalized };

        // if we didn't set the day but we ended up on an overflow date,
        // use the last day of the right month
        if (isUndefined(normalized.day)) {
          mixed.day = Math.min(daysInMonth(mixed.year, mixed.month), mixed.day);
        }
      }

      const [ts, o] = objToTS(mixed, this.o, this.zone);
      return clone$2(this, { ts, o });
    }

    /**
     * Add a period of time to this DateTime and return the resulting DateTime
     *
     * Adding hours, minutes, seconds, or milliseconds increases the timestamp by the right number of milliseconds. Adding days, months, or years shifts the calendar, accounting for DSTs and leap years along the way. Thus, `dt.plus({ hours: 24 })` may result in a different time than `dt.plus({ days: 1 })` if there's a DST shift in between.
     * @param {Duration|Object|number} duration - The amount to add. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
     * @example DateTime.now().plus(123) //~> in 123 milliseconds
     * @example DateTime.now().plus({ minutes: 15 }) //~> in 15 minutes
     * @example DateTime.now().plus({ days: 1 }) //~> this time tomorrow
     * @example DateTime.now().plus({ days: -1 }) //~> this time yesterday
     * @example DateTime.now().plus({ hours: 3, minutes: 13 }) //~> in 3 hr, 13 min
     * @example DateTime.now().plus(Duration.fromObject({ hours: 3, minutes: 13 })) //~> in 3 hr, 13 min
     * @return {DateTime}
     */
    plus(duration) {
      if (!this.isValid) return this;
      const dur = Duration.fromDurationLike(duration);
      return clone$2(this, adjustTime(this, dur));
    }

    /**
     * Subtract a period of time to this DateTime and return the resulting DateTime
     * See {@link DateTime#plus}
     * @param {Duration|Object|number} duration - The amount to subtract. Either a Luxon Duration, a number of milliseconds, the object argument to Duration.fromObject()
     @return {DateTime}
     */
    minus(duration) {
      if (!this.isValid) return this;
      const dur = Duration.fromDurationLike(duration).negate();
      return clone$2(this, adjustTime(this, dur));
    }

    /**
     * "Set" this DateTime to the beginning of a unit of time.
     * @param {string} unit - The unit to go to the beginning of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
     * @param {Object} opts - options
     * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week
     * @example DateTime.local(2014, 3, 3).startOf('month').toISODate(); //=> '2014-03-01'
     * @example DateTime.local(2014, 3, 3).startOf('year').toISODate(); //=> '2014-01-01'
     * @example DateTime.local(2014, 3, 3).startOf('week').toISODate(); //=> '2014-03-03', weeks always start on Mondays
     * @example DateTime.local(2014, 3, 3, 5, 30).startOf('day').toISOTime(); //=> '00:00.000-05:00'
     * @example DateTime.local(2014, 3, 3, 5, 30).startOf('hour').toISOTime(); //=> '05:00:00.000-05:00'
     * @return {DateTime}
     */
    startOf(unit, { useLocaleWeeks = false } = {}) {
      if (!this.isValid) return this;

      const o = {},
        normalizedUnit = Duration.normalizeUnit(unit);
      switch (normalizedUnit) {
        case "years":
          o.month = 1;
        // falls through
        case "quarters":
        case "months":
          o.day = 1;
        // falls through
        case "weeks":
        case "days":
          o.hour = 0;
        // falls through
        case "hours":
          o.minute = 0;
        // falls through
        case "minutes":
          o.second = 0;
        // falls through
        case "seconds":
          o.millisecond = 0;
          break;
        // no default, invalid units throw in normalizeUnit()
      }

      if (normalizedUnit === "weeks") {
        if (useLocaleWeeks) {
          const startOfWeek = this.loc.getStartOfWeek();
          const { weekday } = this;
          if (weekday < startOfWeek) {
            o.weekNumber = this.weekNumber - 1;
          }
          o.weekday = startOfWeek;
        } else {
          o.weekday = 1;
        }
      }

      if (normalizedUnit === "quarters") {
        const q = Math.ceil(this.month / 3);
        o.month = (q - 1) * 3 + 1;
      }

      return this.set(o);
    }

    /**
     * "Set" this DateTime to the end (meaning the last millisecond) of a unit of time
     * @param {string} unit - The unit to go to the end of. Can be 'year', 'quarter', 'month', 'week', 'day', 'hour', 'minute', 'second', or 'millisecond'.
     * @param {Object} opts - options
     * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week
     * @example DateTime.local(2014, 3, 3).endOf('month').toISO(); //=> '2014-03-31T23:59:59.999-05:00'
     * @example DateTime.local(2014, 3, 3).endOf('year').toISO(); //=> '2014-12-31T23:59:59.999-05:00'
     * @example DateTime.local(2014, 3, 3).endOf('week').toISO(); // => '2014-03-09T23:59:59.999-05:00', weeks start on Mondays
     * @example DateTime.local(2014, 3, 3, 5, 30).endOf('day').toISO(); //=> '2014-03-03T23:59:59.999-05:00'
     * @example DateTime.local(2014, 3, 3, 5, 30).endOf('hour').toISO(); //=> '2014-03-03T05:59:59.999-05:00'
     * @return {DateTime}
     */
    endOf(unit, opts) {
      return this.isValid
        ? this.plus({ [unit]: 1 })
            .startOf(unit, opts)
            .minus(1)
        : this;
    }

    // OUTPUT

    /**
     * Returns a string representation of this DateTime formatted according to the specified format string.
     * **You may not want this.** See {@link DateTime#toLocaleString} for a more flexible formatting tool. For a table of tokens and their interpretations, see [here](https://moment.github.io/luxon/#/formatting?id=table-of-tokens).
     * Defaults to en-US if no locale has been specified, regardless of the system's locale.
     * @param {string} fmt - the format string
     * @param {Object} opts - opts to override the configuration options on this DateTime
     * @example DateTime.now().toFormat('yyyy LLL dd') //=> '2017 Apr 22'
     * @example DateTime.now().setLocale('fr').toFormat('yyyy LLL dd') //=> '2017 avr. 22'
     * @example DateTime.now().toFormat('yyyy LLL dd', { locale: "fr" }) //=> '2017 avr. 22'
     * @example DateTime.now().toFormat("HH 'hours and' mm 'minutes'") //=> '20 hours and 55 minutes'
     * @return {string}
     */
    toFormat(fmt, opts = {}) {
      return this.isValid
        ? Formatter.create(this.loc.redefaultToEN(opts)).formatDateTimeFromString(this, fmt)
        : INVALID$1;
    }

    /**
     * Returns a localized string representing this date. Accepts the same options as the Intl.DateTimeFormat constructor and any presets defined by Luxon, such as `DateTime.DATE_FULL` or `DateTime.TIME_SIMPLE`.
     * The exact behavior of this method is browser-specific, but in general it will return an appropriate representation
     * of the DateTime in the assigned locale.
     * Defaults to the system's locale if no locale has been specified
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat
     * @param formatOpts {Object} - Intl.DateTimeFormat constructor options and configuration options
     * @param {Object} opts - opts to override the configuration options on this DateTime
     * @example DateTime.now().toLocaleString(); //=> 4/20/2017
     * @example DateTime.now().setLocale('en-gb').toLocaleString(); //=> '20/04/2017'
     * @example DateTime.now().toLocaleString(DateTime.DATE_FULL); //=> 'April 20, 2017'
     * @example DateTime.now().toLocaleString(DateTime.DATE_FULL, { locale: 'fr' }); //=> '28 août 2022'
     * @example DateTime.now().toLocaleString(DateTime.TIME_SIMPLE); //=> '11:32 AM'
     * @example DateTime.now().toLocaleString(DateTime.DATETIME_SHORT); //=> '4/20/2017, 11:32 AM'
     * @example DateTime.now().toLocaleString({ weekday: 'long', month: 'long', day: '2-digit' }); //=> 'Thursday, April 20'
     * @example DateTime.now().toLocaleString({ weekday: 'short', month: 'short', day: '2-digit', hour: '2-digit', minute: '2-digit' }); //=> 'Thu, Apr 20, 11:27 AM'
     * @example DateTime.now().toLocaleString({ hour: '2-digit', minute: '2-digit', hourCycle: 'h23' }); //=> '11:32'
     * @return {string}
     */
    toLocaleString(formatOpts = DATE_SHORT, opts = {}) {
      return this.isValid
        ? Formatter.create(this.loc.clone(opts), formatOpts).formatDateTime(this)
        : INVALID$1;
    }

    /**
     * Returns an array of format "parts", meaning individual tokens along with metadata. This is allows callers to post-process individual sections of the formatted output.
     * Defaults to the system's locale if no locale has been specified
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat/formatToParts
     * @param opts {Object} - Intl.DateTimeFormat constructor options, same as `toLocaleString`.
     * @example DateTime.now().toLocaleParts(); //=> [
     *                                   //=>   { type: 'day', value: '25' },
     *                                   //=>   { type: 'literal', value: '/' },
     *                                   //=>   { type: 'month', value: '05' },
     *                                   //=>   { type: 'literal', value: '/' },
     *                                   //=>   { type: 'year', value: '1982' }
     *                                   //=> ]
     */
    toLocaleParts(opts = {}) {
      return this.isValid
        ? Formatter.create(this.loc.clone(opts), opts).formatDateTimeParts(this)
        : [];
    }

    /**
     * Returns an ISO 8601-compliant string representation of this DateTime
     * @param {Object} opts - options
     * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
     * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
     * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
     * @param {boolean} [opts.extendedZone=false] - add the time zone format extension
     * @param {string} [opts.format='extended'] - choose between the basic and extended format
     * @example DateTime.utc(1983, 5, 25).toISO() //=> '1982-05-25T00:00:00.000Z'
     * @example DateTime.now().toISO() //=> '2017-04-22T20:47:05.335-04:00'
     * @example DateTime.now().toISO({ includeOffset: false }) //=> '2017-04-22T20:47:05.335'
     * @example DateTime.now().toISO({ format: 'basic' }) //=> '20170422T204705.335-0400'
     * @return {string}
     */
    toISO({
      format = "extended",
      suppressSeconds = false,
      suppressMilliseconds = false,
      includeOffset = true,
      extendedZone = false,
    } = {}) {
      if (!this.isValid) {
        return null;
      }

      const ext = format === "extended";

      let c = toISODate(this, ext);
      c += "T";
      c += toISOTime(this, ext, suppressSeconds, suppressMilliseconds, includeOffset, extendedZone);
      return c;
    }

    /**
     * Returns an ISO 8601-compliant string representation of this DateTime's date component
     * @param {Object} opts - options
     * @param {string} [opts.format='extended'] - choose between the basic and extended format
     * @example DateTime.utc(1982, 5, 25).toISODate() //=> '1982-05-25'
     * @example DateTime.utc(1982, 5, 25).toISODate({ format: 'basic' }) //=> '19820525'
     * @return {string}
     */
    toISODate({ format = "extended" } = {}) {
      if (!this.isValid) {
        return null;
      }

      return toISODate(this, format === "extended");
    }

    /**
     * Returns an ISO 8601-compliant string representation of this DateTime's week date
     * @example DateTime.utc(1982, 5, 25).toISOWeekDate() //=> '1982-W21-2'
     * @return {string}
     */
    toISOWeekDate() {
      return toTechFormat(this, "kkkk-'W'WW-c");
    }

    /**
     * Returns an ISO 8601-compliant string representation of this DateTime's time component
     * @param {Object} opts - options
     * @param {boolean} [opts.suppressMilliseconds=false] - exclude milliseconds from the format if they're 0
     * @param {boolean} [opts.suppressSeconds=false] - exclude seconds from the format if they're 0
     * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
     * @param {boolean} [opts.extendedZone=true] - add the time zone format extension
     * @param {boolean} [opts.includePrefix=false] - include the `T` prefix
     * @param {string} [opts.format='extended'] - choose between the basic and extended format
     * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime() //=> '07:34:19.361Z'
     * @example DateTime.utc().set({ hour: 7, minute: 34, seconds: 0, milliseconds: 0 }).toISOTime({ suppressSeconds: true }) //=> '07:34Z'
     * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ format: 'basic' }) //=> '073419.361Z'
     * @example DateTime.utc().set({ hour: 7, minute: 34 }).toISOTime({ includePrefix: true }) //=> 'T07:34:19.361Z'
     * @return {string}
     */
    toISOTime({
      suppressMilliseconds = false,
      suppressSeconds = false,
      includeOffset = true,
      includePrefix = false,
      extendedZone = false,
      format = "extended",
    } = {}) {
      if (!this.isValid) {
        return null;
      }

      let c = includePrefix ? "T" : "";
      return (
        c +
        toISOTime(
          this,
          format === "extended",
          suppressSeconds,
          suppressMilliseconds,
          includeOffset,
          extendedZone
        )
      );
    }

    /**
     * Returns an RFC 2822-compatible string representation of this DateTime
     * @example DateTime.utc(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 +0000'
     * @example DateTime.local(2014, 7, 13).toRFC2822() //=> 'Sun, 13 Jul 2014 00:00:00 -0400'
     * @return {string}
     */
    toRFC2822() {
      return toTechFormat(this, "EEE, dd LLL yyyy HH:mm:ss ZZZ", false);
    }

    /**
     * Returns a string representation of this DateTime appropriate for use in HTTP headers. The output is always expressed in GMT.
     * Specifically, the string conforms to RFC 1123.
     * @see https://www.w3.org/Protocols/rfc2616/rfc2616-sec3.html#sec3.3.1
     * @example DateTime.utc(2014, 7, 13).toHTTP() //=> 'Sun, 13 Jul 2014 00:00:00 GMT'
     * @example DateTime.utc(2014, 7, 13, 19).toHTTP() //=> 'Sun, 13 Jul 2014 19:00:00 GMT'
     * @return {string}
     */
    toHTTP() {
      return toTechFormat(this.toUTC(), "EEE, dd LLL yyyy HH:mm:ss 'GMT'");
    }

    /**
     * Returns a string representation of this DateTime appropriate for use in SQL Date
     * @example DateTime.utc(2014, 7, 13).toSQLDate() //=> '2014-07-13'
     * @return {string}
     */
    toSQLDate() {
      if (!this.isValid) {
        return null;
      }
      return toISODate(this, true);
    }

    /**
     * Returns a string representation of this DateTime appropriate for use in SQL Time
     * @param {Object} opts - options
     * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
     * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
     * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
     * @example DateTime.utc().toSQL() //=> '05:15:16.345'
     * @example DateTime.now().toSQL() //=> '05:15:16.345 -04:00'
     * @example DateTime.now().toSQL({ includeOffset: false }) //=> '05:15:16.345'
     * @example DateTime.now().toSQL({ includeZone: false }) //=> '05:15:16.345 America/New_York'
     * @return {string}
     */
    toSQLTime({ includeOffset = true, includeZone = false, includeOffsetSpace = true } = {}) {
      let fmt = "HH:mm:ss.SSS";

      if (includeZone || includeOffset) {
        if (includeOffsetSpace) {
          fmt += " ";
        }
        if (includeZone) {
          fmt += "z";
        } else if (includeOffset) {
          fmt += "ZZ";
        }
      }

      return toTechFormat(this, fmt, true);
    }

    /**
     * Returns a string representation of this DateTime appropriate for use in SQL DateTime
     * @param {Object} opts - options
     * @param {boolean} [opts.includeZone=false] - include the zone, such as 'America/New_York'. Overrides includeOffset.
     * @param {boolean} [opts.includeOffset=true] - include the offset, such as 'Z' or '-04:00'
     * @param {boolean} [opts.includeOffsetSpace=true] - include the space between the time and the offset, such as '05:15:16.345 -04:00'
     * @example DateTime.utc(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 Z'
     * @example DateTime.local(2014, 7, 13).toSQL() //=> '2014-07-13 00:00:00.000 -04:00'
     * @example DateTime.local(2014, 7, 13).toSQL({ includeOffset: false }) //=> '2014-07-13 00:00:00.000'
     * @example DateTime.local(2014, 7, 13).toSQL({ includeZone: true }) //=> '2014-07-13 00:00:00.000 America/New_York'
     * @return {string}
     */
    toSQL(opts = {}) {
      if (!this.isValid) {
        return null;
      }

      return `${this.toSQLDate()} ${this.toSQLTime(opts)}`;
    }

    /**
     * Returns a string representation of this DateTime appropriate for debugging
     * @return {string}
     */
    toString() {
      return this.isValid ? this.toISO() : INVALID$1;
    }

    /**
     * Returns a string representation of this DateTime appropriate for the REPL.
     * @return {string}
     */
    [Symbol.for("nodejs.util.inspect.custom")]() {
      if (this.isValid) {
        return `DateTime { ts: ${this.toISO()}, zone: ${this.zone.name}, locale: ${this.locale} }`;
      } else {
        return `DateTime { Invalid, reason: ${this.invalidReason} }`;
      }
    }

    /**
     * Returns the epoch milliseconds of this DateTime. Alias of {@link DateTime#toMillis}
     * @return {number}
     */
    valueOf() {
      return this.toMillis();
    }

    /**
     * Returns the epoch milliseconds of this DateTime.
     * @return {number}
     */
    toMillis() {
      return this.isValid ? this.ts : NaN;
    }

    /**
     * Returns the epoch seconds of this DateTime.
     * @return {number}
     */
    toSeconds() {
      return this.isValid ? this.ts / 1000 : NaN;
    }

    /**
     * Returns the epoch seconds (as a whole number) of this DateTime.
     * @return {number}
     */
    toUnixInteger() {
      return this.isValid ? Math.floor(this.ts / 1000) : NaN;
    }

    /**
     * Returns an ISO 8601 representation of this DateTime appropriate for use in JSON.
     * @return {string}
     */
    toJSON() {
      return this.toISO();
    }

    /**
     * Returns a BSON serializable equivalent to this DateTime.
     * @return {Date}
     */
    toBSON() {
      return this.toJSDate();
    }

    /**
     * Returns a JavaScript object with this DateTime's year, month, day, and so on.
     * @param opts - options for generating the object
     * @param {boolean} [opts.includeConfig=false] - include configuration attributes in the output
     * @example DateTime.now().toObject() //=> { year: 2017, month: 4, day: 22, hour: 20, minute: 49, second: 42, millisecond: 268 }
     * @return {Object}
     */
    toObject(opts = {}) {
      if (!this.isValid) return {};

      const base = { ...this.c };

      if (opts.includeConfig) {
        base.outputCalendar = this.outputCalendar;
        base.numberingSystem = this.loc.numberingSystem;
        base.locale = this.loc.locale;
      }
      return base;
    }

    /**
     * Returns a JavaScript Date equivalent to this DateTime.
     * @return {Date}
     */
    toJSDate() {
      return new Date(this.isValid ? this.ts : NaN);
    }

    // COMPARE

    /**
     * Return the difference between two DateTimes as a Duration.
     * @param {DateTime} otherDateTime - the DateTime to compare this one to
     * @param {string|string[]} [unit=['milliseconds']] - the unit or array of units (such as 'hours' or 'days') to include in the duration.
     * @param {Object} opts - options that affect the creation of the Duration
     * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
     * @example
     * var i1 = DateTime.fromISO('1982-05-25T09:45'),
     *     i2 = DateTime.fromISO('1983-10-14T10:30');
     * i2.diff(i1).toObject() //=> { milliseconds: 43807500000 }
     * i2.diff(i1, 'hours').toObject() //=> { hours: 12168.75 }
     * i2.diff(i1, ['months', 'days']).toObject() //=> { months: 16, days: 19.03125 }
     * i2.diff(i1, ['months', 'days', 'hours']).toObject() //=> { months: 16, days: 19, hours: 0.75 }
     * @return {Duration}
     */
    diff(otherDateTime, unit = "milliseconds", opts = {}) {
      if (!this.isValid || !otherDateTime.isValid) {
        return Duration.invalid("created by diffing an invalid DateTime");
      }

      const durOpts = { locale: this.locale, numberingSystem: this.numberingSystem, ...opts };

      const units = maybeArray(unit).map(Duration.normalizeUnit),
        otherIsLater = otherDateTime.valueOf() > this.valueOf(),
        earlier = otherIsLater ? this : otherDateTime,
        later = otherIsLater ? otherDateTime : this,
        diffed = diff(earlier, later, units, durOpts);

      return otherIsLater ? diffed.negate() : diffed;
    }

    /**
     * Return the difference between this DateTime and right now.
     * See {@link DateTime#diff}
     * @param {string|string[]} [unit=['milliseconds']] - the unit or units units (such as 'hours' or 'days') to include in the duration
     * @param {Object} opts - options that affect the creation of the Duration
     * @param {string} [opts.conversionAccuracy='casual'] - the conversion system to use
     * @return {Duration}
     */
    diffNow(unit = "milliseconds", opts = {}) {
      return this.diff(DateTime.now(), unit, opts);
    }

    /**
     * Return an Interval spanning between this DateTime and another DateTime
     * @param {DateTime} otherDateTime - the other end point of the Interval
     * @return {Interval}
     */
    until(otherDateTime) {
      return this.isValid ? Interval.fromDateTimes(this, otherDateTime) : this;
    }

    /**
     * Return whether this DateTime is in the same unit of time as another DateTime.
     * Higher-order units must also be identical for this function to return `true`.
     * Note that time zones are **ignored** in this comparison, which compares the **local** calendar time. Use {@link DateTime#setZone} to convert one of the dates if needed.
     * @param {DateTime} otherDateTime - the other DateTime
     * @param {string} unit - the unit of time to check sameness on
     * @param {Object} opts - options
     * @param {boolean} [opts.useLocaleWeeks=false] - If true, use weeks based on the locale, i.e. use the locale-dependent start of the week; only the locale of this DateTime is used
     * @example DateTime.now().hasSame(otherDT, 'day'); //~> true if otherDT is in the same current calendar day
     * @return {boolean}
     */
    hasSame(otherDateTime, unit, opts) {
      if (!this.isValid) return false;

      const inputMs = otherDateTime.valueOf();
      const adjustedToZone = this.setZone(otherDateTime.zone, { keepLocalTime: true });
      return (
        adjustedToZone.startOf(unit, opts) <= inputMs && inputMs <= adjustedToZone.endOf(unit, opts)
      );
    }

    /**
     * Equality check
     * Two DateTimes are equal if and only if they represent the same millisecond, have the same zone and location, and are both valid.
     * To compare just the millisecond values, use `+dt1 === +dt2`.
     * @param {DateTime} other - the other DateTime
     * @return {boolean}
     */
    equals(other) {
      return (
        this.isValid &&
        other.isValid &&
        this.valueOf() === other.valueOf() &&
        this.zone.equals(other.zone) &&
        this.loc.equals(other.loc)
      );
    }

    /**
     * Returns a string representation of a this time relative to now, such as "in two days". Can only internationalize if your
     * platform supports Intl.RelativeTimeFormat. Rounds down by default.
     * @param {Object} options - options that affect the output
     * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
     * @param {string} [options.style="long"] - the style of units, must be "long", "short", or "narrow"
     * @param {string|string[]} options.unit - use a specific unit or array of units; if omitted, or an array, the method will pick the best unit. Use an array or one of "years", "quarters", "months", "weeks", "days", "hours", "minutes", or "seconds"
     * @param {boolean} [options.round=true] - whether to round the numbers in the output.
     * @param {number} [options.padding=0] - padding in milliseconds. This allows you to round up the result if it fits inside the threshold. Don't use in combination with {round: false} because the decimal output will include the padding.
     * @param {string} options.locale - override the locale of this DateTime
     * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
     * @example DateTime.now().plus({ days: 1 }).toRelative() //=> "in 1 day"
     * @example DateTime.now().setLocale("es").toRelative({ days: 1 }) //=> "dentro de 1 día"
     * @example DateTime.now().plus({ days: 1 }).toRelative({ locale: "fr" }) //=> "dans 23 heures"
     * @example DateTime.now().minus({ days: 2 }).toRelative() //=> "2 days ago"
     * @example DateTime.now().minus({ days: 2 }).toRelative({ unit: "hours" }) //=> "48 hours ago"
     * @example DateTime.now().minus({ hours: 36 }).toRelative({ round: false }) //=> "1.5 days ago"
     */
    toRelative(options = {}) {
      if (!this.isValid) return null;
      const base = options.base || DateTime.fromObject({}, { zone: this.zone }),
        padding = options.padding ? (this < base ? -options.padding : options.padding) : 0;
      let units = ["years", "months", "days", "hours", "minutes", "seconds"];
      let unit = options.unit;
      if (Array.isArray(options.unit)) {
        units = options.unit;
        unit = undefined;
      }
      return diffRelative(base, this.plus(padding), {
        ...options,
        numeric: "always",
        units,
        unit,
      });
    }

    /**
     * Returns a string representation of this date relative to today, such as "yesterday" or "next month".
     * Only internationalizes on platforms that supports Intl.RelativeTimeFormat.
     * @param {Object} options - options that affect the output
     * @param {DateTime} [options.base=DateTime.now()] - the DateTime to use as the basis to which this time is compared. Defaults to now.
     * @param {string} options.locale - override the locale of this DateTime
     * @param {string} options.unit - use a specific unit; if omitted, the method will pick the unit. Use one of "years", "quarters", "months", "weeks", or "days"
     * @param {string} options.numberingSystem - override the numberingSystem of this DateTime. The Intl system may choose not to honor this
     * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar() //=> "tomorrow"
     * @example DateTime.now().setLocale("es").plus({ days: 1 }).toRelative() //=> ""mañana"
     * @example DateTime.now().plus({ days: 1 }).toRelativeCalendar({ locale: "fr" }) //=> "demain"
     * @example DateTime.now().minus({ days: 2 }).toRelativeCalendar() //=> "2 days ago"
     */
    toRelativeCalendar(options = {}) {
      if (!this.isValid) return null;

      return diffRelative(options.base || DateTime.fromObject({}, { zone: this.zone }), this, {
        ...options,
        numeric: "auto",
        units: ["years", "months", "days"],
        calendary: true,
      });
    }

    /**
     * Return the min of several date times
     * @param {...DateTime} dateTimes - the DateTimes from which to choose the minimum
     * @return {DateTime} the min DateTime, or undefined if called with no argument
     */
    static min(...dateTimes) {
      if (!dateTimes.every(DateTime.isDateTime)) {
        throw new InvalidArgumentError("min requires all arguments be DateTimes");
      }
      return bestBy(dateTimes, (i) => i.valueOf(), Math.min);
    }

    /**
     * Return the max of several date times
     * @param {...DateTime} dateTimes - the DateTimes from which to choose the maximum
     * @return {DateTime} the max DateTime, or undefined if called with no argument
     */
    static max(...dateTimes) {
      if (!dateTimes.every(DateTime.isDateTime)) {
        throw new InvalidArgumentError("max requires all arguments be DateTimes");
      }
      return bestBy(dateTimes, (i) => i.valueOf(), Math.max);
    }

    // MISC

    /**
     * Explain how a string would be parsed by fromFormat()
     * @param {string} text - the string to parse
     * @param {string} fmt - the format the string is expected to be in (see description)
     * @param {Object} options - options taken by fromFormat()
     * @return {Object}
     */
    static fromFormatExplain(text, fmt, options = {}) {
      const { locale = null, numberingSystem = null } = options,
        localeToUse = Locale.fromOpts({
          locale,
          numberingSystem,
          defaultToEN: true,
        });
      return explainFromTokens(localeToUse, text, fmt);
    }

    /**
     * @deprecated use fromFormatExplain instead
     */
    static fromStringExplain(text, fmt, options = {}) {
      return DateTime.fromFormatExplain(text, fmt, options);
    }

    /**
     * Build a parser for `fmt` using the given locale. This parser can be passed
     * to {@link DateTime.fromFormatParser} to a parse a date in this format. This
     * can be used to optimize cases where many dates need to be parsed in a
     * specific format.
     *
     * @param {String} fmt - the format the string is expected to be in (see
     * description)
     * @param {Object} options - options used to set locale and numberingSystem
     * for parser
     * @returns {TokenParser} - opaque object to be used
     */
    static buildFormatParser(fmt, options = {}) {
      const { locale = null, numberingSystem = null } = options,
        localeToUse = Locale.fromOpts({
          locale,
          numberingSystem,
          defaultToEN: true,
        });
      return new TokenParser(localeToUse, fmt);
    }

    /**
     * Create a DateTime from an input string and format parser.
     *
     * The format parser must have been created with the same locale as this call.
     *
     * @param {String} text - the string to parse
     * @param {TokenParser} formatParser - parser from {@link DateTime.buildFormatParser}
     * @param {Object} opts - options taken by fromFormat()
     * @returns {DateTime}
     */
    static fromFormatParser(text, formatParser, opts = {}) {
      if (isUndefined(text) || isUndefined(formatParser)) {
        throw new InvalidArgumentError(
          "fromFormatParser requires an input string and a format parser"
        );
      }
      const { locale = null, numberingSystem = null } = opts,
        localeToUse = Locale.fromOpts({
          locale,
          numberingSystem,
          defaultToEN: true,
        });

      if (!localeToUse.equals(formatParser.locale)) {
        throw new InvalidArgumentError(
          `fromFormatParser called with a locale of ${localeToUse}, ` +
            `but the format parser was created for ${formatParser.locale}`
        );
      }

      const { result, zone, specificOffset, invalidReason } = formatParser.explainFromTokens(text);

      if (invalidReason) {
        return DateTime.invalid(invalidReason);
      } else {
        return parseDataToDateTime(
          result,
          zone,
          opts,
          `format ${formatParser.format}`,
          text,
          specificOffset
        );
      }
    }

    // FORMAT PRESETS

    /**
     * {@link DateTime#toLocaleString} format like 10/14/1983
     * @type {Object}
     */
    static get DATE_SHORT() {
      return DATE_SHORT;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983'
     * @type {Object}
     */
    static get DATE_MED() {
      return DATE_MED;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Fri, Oct 14, 1983'
     * @type {Object}
     */
    static get DATE_MED_WITH_WEEKDAY() {
      return DATE_MED_WITH_WEEKDAY;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983'
     * @type {Object}
     */
    static get DATE_FULL() {
      return DATE_FULL;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Tuesday, October 14, 1983'
     * @type {Object}
     */
    static get DATE_HUGE() {
      return DATE_HUGE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get TIME_SIMPLE() {
      return TIME_SIMPLE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get TIME_WITH_SECONDS() {
      return TIME_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get TIME_WITH_SHORT_OFFSET() {
      return TIME_WITH_SHORT_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get TIME_WITH_LONG_OFFSET() {
      return TIME_WITH_LONG_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30', always 24-hour.
     * @type {Object}
     */
    static get TIME_24_SIMPLE() {
      return TIME_24_SIMPLE;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23', always 24-hour.
     * @type {Object}
     */
    static get TIME_24_WITH_SECONDS() {
      return TIME_24_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 EDT', always 24-hour.
     * @type {Object}
     */
    static get TIME_24_WITH_SHORT_OFFSET() {
      return TIME_24_WITH_SHORT_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '09:30:23 Eastern Daylight Time', always 24-hour.
     * @type {Object}
     */
    static get TIME_24_WITH_LONG_OFFSET() {
      return TIME_24_WITH_LONG_OFFSET;
    }

    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_SHORT() {
      return DATETIME_SHORT;
    }

    /**
     * {@link DateTime#toLocaleString} format like '10/14/1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_SHORT_WITH_SECONDS() {
      return DATETIME_SHORT_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_MED() {
      return DATETIME_MED;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Oct 14, 1983, 9:30:33 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_MED_WITH_SECONDS() {
      return DATETIME_MED_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Fri, 14 Oct 1983, 9:30 AM'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_MED_WITH_WEEKDAY() {
      return DATETIME_MED_WITH_WEEKDAY;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_FULL() {
      return DATETIME_FULL;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'October 14, 1983, 9:30:33 AM EDT'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_FULL_WITH_SECONDS() {
      return DATETIME_FULL_WITH_SECONDS;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_HUGE() {
      return DATETIME_HUGE;
    }

    /**
     * {@link DateTime#toLocaleString} format like 'Friday, October 14, 1983, 9:30:33 AM Eastern Daylight Time'. Only 12-hour if the locale is.
     * @type {Object}
     */
    static get DATETIME_HUGE_WITH_SECONDS() {
      return DATETIME_HUGE_WITH_SECONDS;
    }
  }

  /**
   * @private
   */
  function friendlyDateTime(dateTimeish) {
    if (DateTime.isDateTime(dateTimeish)) {
      return dateTimeish;
    } else if (dateTimeish && dateTimeish.valueOf && isNumber$1(dateTimeish.valueOf())) {
      return DateTime.fromJSDate(dateTimeish);
    } else if (dateTimeish && typeof dateTimeish === "object") {
      return DateTime.fromObject(dateTimeish);
    } else {
      throw new InvalidArgumentError(
        `Unknown datetime argument: ${dateTimeish}, of type ${typeof dateTimeish}`
      );
    }
  }

  var HOOKS = [
      "onChange",
      "onClose",
      "onDayCreate",
      "onDestroy",
      "onKeyDown",
      "onMonthChange",
      "onOpen",
      "onParseConfig",
      "onReady",
      "onValueUpdate",
      "onYearChange",
      "onPreCalendarPosition",
  ];
  var defaults$1 = {
      _disable: [],
      allowInput: false,
      allowInvalidPreload: false,
      altFormat: "F j, Y",
      altInput: false,
      altInputClass: "form-control input",
      animate: typeof window === "object" &&
          window.navigator.userAgent.indexOf("MSIE") === -1,
      ariaDateFormat: "F j, Y",
      autoFillDefaultTime: true,
      clickOpens: true,
      closeOnSelect: true,
      conjunction: ", ",
      dateFormat: "Y-m-d",
      defaultHour: 12,
      defaultMinute: 0,
      defaultSeconds: 0,
      disable: [],
      disableMobile: false,
      enableSeconds: false,
      enableTime: false,
      errorHandler: function (err) {
          return typeof console !== "undefined" && console.warn(err);
      },
      getWeek: function (givenDate) {
          var date = new Date(givenDate.getTime());
          date.setHours(0, 0, 0, 0);
          date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));
          var week1 = new Date(date.getFullYear(), 0, 4);
          return (1 +
              Math.round(((date.getTime() - week1.getTime()) / 86400000 -
                  3 +
                  ((week1.getDay() + 6) % 7)) /
                  7));
      },
      hourIncrement: 1,
      ignoredFocusElements: [],
      inline: false,
      locale: "default",
      minuteIncrement: 5,
      mode: "single",
      monthSelectorType: "dropdown",
      nextArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>",
      noCalendar: false,
      now: new Date(),
      onChange: [],
      onClose: [],
      onDayCreate: [],
      onDestroy: [],
      onKeyDown: [],
      onMonthChange: [],
      onOpen: [],
      onParseConfig: [],
      onReady: [],
      onValueUpdate: [],
      onYearChange: [],
      onPreCalendarPosition: [],
      plugins: [],
      position: "auto",
      positionElement: undefined,
      prevArrow: "<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>",
      shorthandCurrentMonth: false,
      showMonths: 1,
      static: false,
      time_24hr: false,
      weekNumbers: false,
      wrap: false,
  };

  var english = {
      weekdays: {
          shorthand: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
          longhand: [
              "Sunday",
              "Monday",
              "Tuesday",
              "Wednesday",
              "Thursday",
              "Friday",
              "Saturday",
          ],
      },
      months: {
          shorthand: [
              "Jan",
              "Feb",
              "Mar",
              "Apr",
              "May",
              "Jun",
              "Jul",
              "Aug",
              "Sep",
              "Oct",
              "Nov",
              "Dec",
          ],
          longhand: [
              "January",
              "February",
              "March",
              "April",
              "May",
              "June",
              "July",
              "August",
              "September",
              "October",
              "November",
              "December",
          ],
      },
      daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
      firstDayOfWeek: 0,
      ordinal: function (nth) {
          var s = nth % 100;
          if (s > 3 && s < 21)
              return "th";
          switch (s % 10) {
              case 1:
                  return "st";
              case 2:
                  return "nd";
              case 3:
                  return "rd";
              default:
                  return "th";
          }
      },
      rangeSeparator: " to ",
      weekAbbreviation: "Wk",
      scrollTitle: "Scroll to increment",
      toggleTitle: "Click to toggle",
      amPM: ["AM", "PM"],
      yearAriaLabel: "Year",
      monthAriaLabel: "Month",
      hourAriaLabel: "Hour",
      minuteAriaLabel: "Minute",
      time_24hr: false,
  };

  var pad = function (number, length) {
      if (length === void 0) { length = 2; }
      return ("000" + number).slice(length * -1);
  };
  var int = function (bool) { return (bool === true ? 1 : 0); };
  function debounce(fn, wait) {
      var t;
      return function () {
          var _this = this;
          var args = arguments;
          clearTimeout(t);
          t = setTimeout(function () { return fn.apply(_this, args); }, wait);
      };
  }
  var arrayify = function (obj) {
      return obj instanceof Array ? obj : [obj];
  };

  function toggleClass(elem, className, bool) {
      if (bool === true)
          return elem.classList.add(className);
      elem.classList.remove(className);
  }
  function createElement(tag, className, content) {
      var e = window.document.createElement(tag);
      className = className || "";
      content = content || "";
      e.className = className;
      if (content !== undefined)
          e.textContent = content;
      return e;
  }
  function clearNode(node) {
      while (node.firstChild)
          node.removeChild(node.firstChild);
  }
  function findParent(node, condition) {
      if (condition(node))
          return node;
      else if (node.parentNode)
          return findParent(node.parentNode, condition);
      return undefined;
  }
  function createNumberInput(inputClassName, opts) {
      var wrapper = createElement("div", "numInputWrapper"), numInput = createElement("input", "numInput " + inputClassName), arrowUp = createElement("span", "arrowUp"), arrowDown = createElement("span", "arrowDown");
      if (navigator.userAgent.indexOf("MSIE 9.0") === -1) {
          numInput.type = "number";
      }
      else {
          numInput.type = "text";
          numInput.pattern = "\\d*";
      }
      if (opts !== undefined)
          for (var key in opts)
              numInput.setAttribute(key, opts[key]);
      wrapper.appendChild(numInput);
      wrapper.appendChild(arrowUp);
      wrapper.appendChild(arrowDown);
      return wrapper;
  }
  function getEventTarget(event) {
      try {
          if (typeof event.composedPath === "function") {
              var path = event.composedPath();
              return path[0];
          }
          return event.target;
      }
      catch (error) {
          return event.target;
      }
  }

  var doNothing = function () { return undefined; };
  var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? "shorthand" : "longhand"][monthNumber]; };
  var revFormat = {
      D: doNothing,
      F: function (dateObj, monthName, locale) {
          dateObj.setMonth(locale.months.longhand.indexOf(monthName));
      },
      G: function (dateObj, hour) {
          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));
      },
      H: function (dateObj, hour) {
          dateObj.setHours(parseFloat(hour));
      },
      J: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
      },
      K: function (dateObj, amPM, locale) {
          dateObj.setHours((dateObj.getHours() % 12) +
              12 * int(new RegExp(locale.amPM[1], "i").test(amPM)));
      },
      M: function (dateObj, shortMonth, locale) {
          dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));
      },
      S: function (dateObj, seconds) {
          dateObj.setSeconds(parseFloat(seconds));
      },
      U: function (_, unixSeconds) { return new Date(parseFloat(unixSeconds) * 1000); },
      W: function (dateObj, weekNum, locale) {
          var weekNumber = parseInt(weekNum);
          var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);
          date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);
          return date;
      },
      Y: function (dateObj, year) {
          dateObj.setFullYear(parseFloat(year));
      },
      Z: function (_, ISODate) { return new Date(ISODate); },
      d: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
      },
      h: function (dateObj, hour) {
          dateObj.setHours((dateObj.getHours() >= 12 ? 12 : 0) + parseFloat(hour));
      },
      i: function (dateObj, minutes) {
          dateObj.setMinutes(parseFloat(minutes));
      },
      j: function (dateObj, day) {
          dateObj.setDate(parseFloat(day));
      },
      l: doNothing,
      m: function (dateObj, month) {
          dateObj.setMonth(parseFloat(month) - 1);
      },
      n: function (dateObj, month) {
          dateObj.setMonth(parseFloat(month) - 1);
      },
      s: function (dateObj, seconds) {
          dateObj.setSeconds(parseFloat(seconds));
      },
      u: function (_, unixMillSeconds) {
          return new Date(parseFloat(unixMillSeconds));
      },
      w: doNothing,
      y: function (dateObj, year) {
          dateObj.setFullYear(2000 + parseFloat(year));
      },
  };
  var tokenRegex = {
      D: "",
      F: "",
      G: "(\\d\\d|\\d)",
      H: "(\\d\\d|\\d)",
      J: "(\\d\\d|\\d)\\w+",
      K: "",
      M: "",
      S: "(\\d\\d|\\d)",
      U: "(.+)",
      W: "(\\d\\d|\\d)",
      Y: "(\\d{4})",
      Z: "(.+)",
      d: "(\\d\\d|\\d)",
      h: "(\\d\\d|\\d)",
      i: "(\\d\\d|\\d)",
      j: "(\\d\\d|\\d)",
      l: "",
      m: "(\\d\\d|\\d)",
      n: "(\\d\\d|\\d)",
      s: "(\\d\\d|\\d)",
      u: "(.+)",
      w: "(\\d\\d|\\d)",
      y: "(\\d{2})",
  };
  var formats = {
      Z: function (date) { return date.toISOString(); },
      D: function (date, locale, options) {
          return locale.weekdays.shorthand[formats.w(date, locale, options)];
      },
      F: function (date, locale, options) {
          return monthToStr(formats.n(date, locale, options) - 1, false, locale);
      },
      G: function (date, locale, options) {
          return pad(formats.h(date, locale, options));
      },
      H: function (date) { return pad(date.getHours()); },
      J: function (date, locale) {
          return locale.ordinal !== undefined
              ? date.getDate() + locale.ordinal(date.getDate())
              : date.getDate();
      },
      K: function (date, locale) { return locale.amPM[int(date.getHours() > 11)]; },
      M: function (date, locale) {
          return monthToStr(date.getMonth(), true, locale);
      },
      S: function (date) { return pad(date.getSeconds()); },
      U: function (date) { return date.getTime() / 1000; },
      W: function (date, _, options) {
          return options.getWeek(date);
      },
      Y: function (date) { return pad(date.getFullYear(), 4); },
      d: function (date) { return pad(date.getDate()); },
      h: function (date) { return (date.getHours() % 12 ? date.getHours() % 12 : 12); },
      i: function (date) { return pad(date.getMinutes()); },
      j: function (date) { return date.getDate(); },
      l: function (date, locale) {
          return locale.weekdays.longhand[date.getDay()];
      },
      m: function (date) { return pad(date.getMonth() + 1); },
      n: function (date) { return date.getMonth() + 1; },
      s: function (date) { return date.getSeconds(); },
      u: function (date) { return date.getTime(); },
      w: function (date) { return date.getDay(); },
      y: function (date) { return String(date.getFullYear()).substring(2); },
  };

  var createDateFormatter = function (_a) {
      var _b = _a.config, config = _b === void 0 ? defaults$1 : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c, _d = _a.isMobile, isMobile = _d === void 0 ? false : _d;
      return function (dateObj, frmt, overrideLocale) {
          var locale = overrideLocale || l10n;
          if (config.formatDate !== undefined && !isMobile) {
              return config.formatDate(dateObj, frmt, locale);
          }
          return frmt
              .split("")
              .map(function (c, i, arr) {
              return formats[c] && arr[i - 1] !== "\\"
                  ? formats[c](dateObj, locale, config)
                  : c !== "\\"
                      ? c
                      : "";
          })
              .join("");
      };
  };
  var createDateParser = function (_a) {
      var _b = _a.config, config = _b === void 0 ? defaults$1 : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;
      return function (date, givenFormat, timeless, customLocale) {
          if (date !== 0 && !date)
              return undefined;
          var locale = customLocale || l10n;
          var parsedDate;
          var dateOrig = date;
          if (date instanceof Date)
              parsedDate = new Date(date.getTime());
          else if (typeof date !== "string" &&
              date.toFixed !== undefined)
              parsedDate = new Date(date);
          else if (typeof date === "string") {
              var format = givenFormat || (config || defaults$1).dateFormat;
              var datestr = String(date).trim();
              if (datestr === "today") {
                  parsedDate = new Date();
                  timeless = true;
              }
              else if (config && config.parseDate) {
                  parsedDate = config.parseDate(date, format);
              }
              else if (/Z$/.test(datestr) ||
                  /GMT$/.test(datestr)) {
                  parsedDate = new Date(date);
              }
              else {
                  var matched = void 0, ops = [];
                  for (var i = 0, matchIndex = 0, regexStr = ""; i < format.length; i++) {
                      var token = format[i];
                      var isBackSlash = token === "\\";
                      var escaped = format[i - 1] === "\\" || isBackSlash;
                      if (tokenRegex[token] && !escaped) {
                          regexStr += tokenRegex[token];
                          var match = new RegExp(regexStr).exec(date);
                          if (match && (matched = true)) {
                              ops[token !== "Y" ? "push" : "unshift"]({
                                  fn: revFormat[token],
                                  val: match[++matchIndex],
                              });
                          }
                      }
                      else if (!isBackSlash)
                          regexStr += ".";
                  }
                  parsedDate =
                      !config || !config.noCalendar
                          ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)
                          : new Date(new Date().setHours(0, 0, 0, 0));
                  ops.forEach(function (_a) {
                      var fn = _a.fn, val = _a.val;
                      return (parsedDate = fn(parsedDate, val, locale) || parsedDate);
                  });
                  parsedDate = matched ? parsedDate : undefined;
              }
          }
          if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {
              config.errorHandler(new Error("Invalid date provided: " + dateOrig));
              return undefined;
          }
          if (timeless === true)
              parsedDate.setHours(0, 0, 0, 0);
          return parsedDate;
      };
  };
  function compareDates(date1, date2, timeless) {
      if (timeless === void 0) { timeless = true; }
      if (timeless !== false) {
          return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -
              new Date(date2.getTime()).setHours(0, 0, 0, 0));
      }
      return date1.getTime() - date2.getTime();
  }
  var isBetween = function (ts, ts1, ts2) {
      return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);
  };
  var calculateSecondsSinceMidnight = function (hours, minutes, seconds) {
      return hours * 3600 + minutes * 60 + seconds;
  };
  var parseSeconds = function (secondsSinceMidnight) {
      var hours = Math.floor(secondsSinceMidnight / 3600), minutes = (secondsSinceMidnight - hours * 3600) / 60;
      return [hours, minutes, secondsSinceMidnight - hours * 3600 - minutes * 60];
  };
  var duration$1 = {
      DAY: 86400000,
  };
  function getDefaultHours(config) {
      var hours = config.defaultHour;
      var minutes = config.defaultMinute;
      var seconds = config.defaultSeconds;
      if (config.minDate !== undefined) {
          var minHour = config.minDate.getHours();
          var minMinutes = config.minDate.getMinutes();
          var minSeconds = config.minDate.getSeconds();
          if (hours < minHour) {
              hours = minHour;
          }
          if (hours === minHour && minutes < minMinutes) {
              minutes = minMinutes;
          }
          if (hours === minHour && minutes === minMinutes && seconds < minSeconds)
              seconds = config.minDate.getSeconds();
      }
      if (config.maxDate !== undefined) {
          var maxHr = config.maxDate.getHours();
          var maxMinutes = config.maxDate.getMinutes();
          hours = Math.min(hours, maxHr);
          if (hours === maxHr)
              minutes = Math.min(maxMinutes, minutes);
          if (hours === maxHr && minutes === maxMinutes)
              seconds = config.maxDate.getSeconds();
      }
      return { hours: hours, minutes: minutes, seconds: seconds };
  }

  if (typeof Object.assign !== "function") {
      Object.assign = function (target) {
          var args = [];
          for (var _i = 1; _i < arguments.length; _i++) {
              args[_i - 1] = arguments[_i];
          }
          if (!target) {
              throw TypeError("Cannot convert undefined or null to object");
          }
          var _loop_1 = function (source) {
              if (source) {
                  Object.keys(source).forEach(function (key) { return (target[key] = source[key]); });
              }
          };
          for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
              var source = args_1[_a];
              _loop_1(source);
          }
          return target;
      };
  }

  var __assign = (undefined && undefined.__assign) || function () {
      __assign = Object.assign || function(t) {
          for (var s, i = 1, n = arguments.length; i < n; i++) {
              s = arguments[i];
              for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                  t[p] = s[p];
          }
          return t;
      };
      return __assign.apply(this, arguments);
  };
  var __spreadArrays = (undefined && undefined.__spreadArrays) || function () {
      for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
      for (var r = Array(s), k = 0, i = 0; i < il; i++)
          for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
              r[k] = a[j];
      return r;
  };
  var DEBOUNCED_CHANGE_MS = 300;
  function FlatpickrInstance(element, instanceConfig) {
      var self = {
          config: __assign(__assign({}, defaults$1), flatpickr.defaultConfig),
          l10n: english,
      };
      self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });
      self._handlers = [];
      self.pluginElements = [];
      self.loadedPlugins = [];
      self._bind = bind;
      self._setHoursFromDate = setHoursFromDate;
      self._positionCalendar = positionCalendar;
      self.changeMonth = changeMonth;
      self.changeYear = changeYear;
      self.clear = clear;
      self.close = close;
      self.onMouseOver = onMouseOver;
      self._createElement = createElement;
      self.createDay = createDay;
      self.destroy = destroy;
      self.isEnabled = isEnabled;
      self.jumpToDate = jumpToDate;
      self.updateValue = updateValue;
      self.open = open;
      self.redraw = redraw;
      self.set = set;
      self.setDate = setDate;
      self.toggle = toggle;
      function setupHelperFunctions() {
          self.utils = {
              getDaysInMonth: function (month, yr) {
                  if (month === void 0) { month = self.currentMonth; }
                  if (yr === void 0) { yr = self.currentYear; }
                  if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))
                      return 29;
                  return self.l10n.daysInMonth[month];
              },
          };
      }
      function init() {
          self.element = self.input = element;
          self.isOpen = false;
          parseConfig();
          setupLocale();
          setupInputs();
          setupDates();
          setupHelperFunctions();
          if (!self.isMobile)
              build();
          bindEvents();
          if (self.selectedDates.length || self.config.noCalendar) {
              if (self.config.enableTime) {
                  setHoursFromDate(self.config.noCalendar ? self.latestSelectedDateObj : undefined);
              }
              updateValue(false);
          }
          setCalendarWidth();
          var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
          if (!self.isMobile && isSafari) {
              positionCalendar();
          }
          triggerEvent("onReady");
      }
      function getClosestActiveElement() {
          var _a;
          return (((_a = self.calendarContainer) === null || _a === void 0 ? void 0 : _a.getRootNode())
              .activeElement || document.activeElement);
      }
      function bindToInstance(fn) {
          return fn.bind(self);
      }
      function setCalendarWidth() {
          var config = self.config;
          if (config.weekNumbers === false && config.showMonths === 1) {
              return;
          }
          else if (config.noCalendar !== true) {
              window.requestAnimationFrame(function () {
                  if (self.calendarContainer !== undefined) {
                      self.calendarContainer.style.visibility = "hidden";
                      self.calendarContainer.style.display = "block";
                  }
                  if (self.daysContainer !== undefined) {
                      var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;
                      self.daysContainer.style.width = daysWidth + "px";
                      self.calendarContainer.style.width =
                          daysWidth +
                              (self.weekWrapper !== undefined
                                  ? self.weekWrapper.offsetWidth
                                  : 0) +
                              "px";
                      self.calendarContainer.style.removeProperty("visibility");
                      self.calendarContainer.style.removeProperty("display");
                  }
              });
          }
      }
      function updateTime(e) {
          if (self.selectedDates.length === 0) {
              var defaultDate = self.config.minDate === undefined ||
                  compareDates(new Date(), self.config.minDate) >= 0
                  ? new Date()
                  : new Date(self.config.minDate.getTime());
              var defaults = getDefaultHours(self.config);
              defaultDate.setHours(defaults.hours, defaults.minutes, defaults.seconds, defaultDate.getMilliseconds());
              self.selectedDates = [defaultDate];
              self.latestSelectedDateObj = defaultDate;
          }
          if (e !== undefined && e.type !== "blur") {
              timeWrapper(e);
          }
          var prevValue = self._input.value;
          setHoursFromInputs();
          updateValue();
          if (self._input.value !== prevValue) {
              self._debouncedChange();
          }
      }
      function ampm2military(hour, amPM) {
          return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);
      }
      function military2ampm(hour) {
          switch (hour % 24) {
              case 0:
              case 12:
                  return 12;
              default:
                  return hour % 12;
          }
      }
      function setHoursFromInputs() {
          if (self.hourElement === undefined || self.minuteElement === undefined)
              return;
          var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined
              ? (parseInt(self.secondElement.value, 10) || 0) % 60
              : 0;
          if (self.amPM !== undefined) {
              hours = ampm2military(hours, self.amPM.textContent);
          }
          var limitMinHours = self.config.minTime !== undefined ||
              (self.config.minDate &&
                  self.minDateHasTime &&
                  self.latestSelectedDateObj &&
                  compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===
                      0);
          var limitMaxHours = self.config.maxTime !== undefined ||
              (self.config.maxDate &&
                  self.maxDateHasTime &&
                  self.latestSelectedDateObj &&
                  compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===
                      0);
          if (self.config.maxTime !== undefined &&
              self.config.minTime !== undefined &&
              self.config.minTime > self.config.maxTime) {
              var minBound = calculateSecondsSinceMidnight(self.config.minTime.getHours(), self.config.minTime.getMinutes(), self.config.minTime.getSeconds());
              var maxBound = calculateSecondsSinceMidnight(self.config.maxTime.getHours(), self.config.maxTime.getMinutes(), self.config.maxTime.getSeconds());
              var currentTime = calculateSecondsSinceMidnight(hours, minutes, seconds);
              if (currentTime > maxBound && currentTime < minBound) {
                  var result = parseSeconds(minBound);
                  hours = result[0];
                  minutes = result[1];
                  seconds = result[2];
              }
          }
          else {
              if (limitMaxHours) {
                  var maxTime = self.config.maxTime !== undefined
                      ? self.config.maxTime
                      : self.config.maxDate;
                  hours = Math.min(hours, maxTime.getHours());
                  if (hours === maxTime.getHours())
                      minutes = Math.min(minutes, maxTime.getMinutes());
                  if (minutes === maxTime.getMinutes())
                      seconds = Math.min(seconds, maxTime.getSeconds());
              }
              if (limitMinHours) {
                  var minTime = self.config.minTime !== undefined
                      ? self.config.minTime
                      : self.config.minDate;
                  hours = Math.max(hours, minTime.getHours());
                  if (hours === minTime.getHours() && minutes < minTime.getMinutes())
                      minutes = minTime.getMinutes();
                  if (minutes === minTime.getMinutes())
                      seconds = Math.max(seconds, minTime.getSeconds());
              }
          }
          setHours(hours, minutes, seconds);
      }
      function setHoursFromDate(dateObj) {
          var date = dateObj || self.latestSelectedDateObj;
          if (date && date instanceof Date) {
              setHours(date.getHours(), date.getMinutes(), date.getSeconds());
          }
      }
      function setHours(hours, minutes, seconds) {
          if (self.latestSelectedDateObj !== undefined) {
              self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);
          }
          if (!self.hourElement || !self.minuteElement || self.isMobile)
              return;
          self.hourElement.value = pad(!self.config.time_24hr
              ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)
              : hours);
          self.minuteElement.value = pad(minutes);
          if (self.amPM !== undefined)
              self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];
          if (self.secondElement !== undefined)
              self.secondElement.value = pad(seconds);
      }
      function onYearInput(event) {
          var eventTarget = getEventTarget(event);
          var year = parseInt(eventTarget.value) + (event.delta || 0);
          if (year / 1000 > 1 ||
              (event.key === "Enter" && !/[^\d]/.test(year.toString()))) {
              changeYear(year);
          }
      }
      function bind(element, event, handler, options) {
          if (event instanceof Array)
              return event.forEach(function (ev) { return bind(element, ev, handler, options); });
          if (element instanceof Array)
              return element.forEach(function (el) { return bind(el, event, handler, options); });
          element.addEventListener(event, handler, options);
          self._handlers.push({
              remove: function () { return element.removeEventListener(event, handler, options); },
          });
      }
      function triggerChange() {
          triggerEvent("onChange");
      }
      function bindEvents() {
          if (self.config.wrap) {
              ["open", "close", "toggle", "clear"].forEach(function (evt) {
                  Array.prototype.forEach.call(self.element.querySelectorAll("[data-" + evt + "]"), function (el) {
                      return bind(el, "click", self[evt]);
                  });
              });
          }
          if (self.isMobile) {
              setupMobile();
              return;
          }
          var debouncedResize = debounce(onResize, 50);
          self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);
          if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))
              bind(self.daysContainer, "mouseover", function (e) {
                  if (self.config.mode === "range")
                      onMouseOver(getEventTarget(e));
              });
          bind(self._input, "keydown", onKeyDown);
          if (self.calendarContainer !== undefined) {
              bind(self.calendarContainer, "keydown", onKeyDown);
          }
          if (!self.config.inline && !self.config.static)
              bind(window, "resize", debouncedResize);
          if (window.ontouchstart !== undefined)
              bind(window.document, "touchstart", documentClick);
          else
              bind(window.document, "mousedown", documentClick);
          bind(window.document, "focus", documentClick, { capture: true });
          if (self.config.clickOpens === true) {
              bind(self._input, "focus", self.open);
              bind(self._input, "click", self.open);
          }
          if (self.daysContainer !== undefined) {
              bind(self.monthNav, "click", onMonthNavClick);
              bind(self.monthNav, ["keyup", "increment"], onYearInput);
              bind(self.daysContainer, "click", selectDate);
          }
          if (self.timeContainer !== undefined &&
              self.minuteElement !== undefined &&
              self.hourElement !== undefined) {
              var selText = function (e) {
                  return getEventTarget(e).select();
              };
              bind(self.timeContainer, ["increment"], updateTime);
              bind(self.timeContainer, "blur", updateTime, { capture: true });
              bind(self.timeContainer, "click", timeIncrement);
              bind([self.hourElement, self.minuteElement], ["focus", "click"], selText);
              if (self.secondElement !== undefined)
                  bind(self.secondElement, "focus", function () { return self.secondElement && self.secondElement.select(); });
              if (self.amPM !== undefined) {
                  bind(self.amPM, "click", function (e) {
                      updateTime(e);
                  });
              }
          }
          if (self.config.allowInput) {
              bind(self._input, "blur", onBlur);
          }
      }
      function jumpToDate(jumpDate, triggerChange) {
          var jumpTo = jumpDate !== undefined
              ? self.parseDate(jumpDate)
              : self.latestSelectedDateObj ||
                  (self.config.minDate && self.config.minDate > self.now
                      ? self.config.minDate
                      : self.config.maxDate && self.config.maxDate < self.now
                          ? self.config.maxDate
                          : self.now);
          var oldYear = self.currentYear;
          var oldMonth = self.currentMonth;
          try {
              if (jumpTo !== undefined) {
                  self.currentYear = jumpTo.getFullYear();
                  self.currentMonth = jumpTo.getMonth();
              }
          }
          catch (e) {
              e.message = "Invalid date supplied: " + jumpTo;
              self.config.errorHandler(e);
          }
          if (triggerChange && self.currentYear !== oldYear) {
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
          if (triggerChange &&
              (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {
              triggerEvent("onMonthChange");
          }
          self.redraw();
      }
      function timeIncrement(e) {
          var eventTarget = getEventTarget(e);
          if (~eventTarget.className.indexOf("arrow"))
              incrementNumInput(e, eventTarget.classList.contains("arrowUp") ? 1 : -1);
      }
      function incrementNumInput(e, delta, inputElem) {
          var target = e && getEventTarget(e);
          var input = inputElem ||
              (target && target.parentNode && target.parentNode.firstChild);
          var event = createEvent("increment");
          event.delta = delta;
          input && input.dispatchEvent(event);
      }
      function build() {
          var fragment = window.document.createDocumentFragment();
          self.calendarContainer = createElement("div", "flatpickr-calendar");
          self.calendarContainer.tabIndex = -1;
          if (!self.config.noCalendar) {
              fragment.appendChild(buildMonthNav());
              self.innerContainer = createElement("div", "flatpickr-innerContainer");
              if (self.config.weekNumbers) {
                  var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;
                  self.innerContainer.appendChild(weekWrapper);
                  self.weekNumbers = weekNumbers;
                  self.weekWrapper = weekWrapper;
              }
              self.rContainer = createElement("div", "flatpickr-rContainer");
              self.rContainer.appendChild(buildWeekdays());
              if (!self.daysContainer) {
                  self.daysContainer = createElement("div", "flatpickr-days");
                  self.daysContainer.tabIndex = -1;
              }
              buildDays();
              self.rContainer.appendChild(self.daysContainer);
              self.innerContainer.appendChild(self.rContainer);
              fragment.appendChild(self.innerContainer);
          }
          if (self.config.enableTime) {
              fragment.appendChild(buildTime());
          }
          toggleClass(self.calendarContainer, "rangeMode", self.config.mode === "range");
          toggleClass(self.calendarContainer, "animate", self.config.animate === true);
          toggleClass(self.calendarContainer, "multiMonth", self.config.showMonths > 1);
          self.calendarContainer.appendChild(fragment);
          var customAppend = self.config.appendTo !== undefined &&
              self.config.appendTo.nodeType !== undefined;
          if (self.config.inline || self.config.static) {
              self.calendarContainer.classList.add(self.config.inline ? "inline" : "static");
              if (self.config.inline) {
                  if (!customAppend && self.element.parentNode)
                      self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);
                  else if (self.config.appendTo !== undefined)
                      self.config.appendTo.appendChild(self.calendarContainer);
              }
              if (self.config.static) {
                  var wrapper = createElement("div", "flatpickr-wrapper");
                  if (self.element.parentNode)
                      self.element.parentNode.insertBefore(wrapper, self.element);
                  wrapper.appendChild(self.element);
                  if (self.altInput)
                      wrapper.appendChild(self.altInput);
                  wrapper.appendChild(self.calendarContainer);
              }
          }
          if (!self.config.static && !self.config.inline)
              (self.config.appendTo !== undefined
                  ? self.config.appendTo
                  : window.document.body).appendChild(self.calendarContainer);
      }
      function createDay(className, date, _dayNumber, i) {
          var dateIsEnabled = isEnabled(date, true), dayElement = createElement("span", className, date.getDate().toString());
          dayElement.dateObj = date;
          dayElement.$i = i;
          dayElement.setAttribute("aria-label", self.formatDate(date, self.config.ariaDateFormat));
          if (className.indexOf("hidden") === -1 &&
              compareDates(date, self.now) === 0) {
              self.todayDateElem = dayElement;
              dayElement.classList.add("today");
              dayElement.setAttribute("aria-current", "date");
          }
          if (dateIsEnabled) {
              dayElement.tabIndex = -1;
              if (isDateSelected(date)) {
                  dayElement.classList.add("selected");
                  self.selectedDateElem = dayElement;
                  if (self.config.mode === "range") {
                      toggleClass(dayElement, "startRange", self.selectedDates[0] &&
                          compareDates(date, self.selectedDates[0], true) === 0);
                      toggleClass(dayElement, "endRange", self.selectedDates[1] &&
                          compareDates(date, self.selectedDates[1], true) === 0);
                      if (className === "nextMonthDay")
                          dayElement.classList.add("inRange");
                  }
              }
          }
          else {
              dayElement.classList.add("flatpickr-disabled");
          }
          if (self.config.mode === "range") {
              if (isDateInRange(date) && !isDateSelected(date))
                  dayElement.classList.add("inRange");
          }
          if (self.weekNumbers &&
              self.config.showMonths === 1 &&
              className !== "prevMonthDay" &&
              i % 7 === 6) {
              self.weekNumbers.insertAdjacentHTML("beforeend", "<span class='flatpickr-day'>" + self.config.getWeek(date) + "</span>");
          }
          triggerEvent("onDayCreate", dayElement);
          return dayElement;
      }
      function focusOnDayElem(targetNode) {
          targetNode.focus();
          if (self.config.mode === "range")
              onMouseOver(targetNode);
      }
      function getFirstAvailableDay(delta) {
          var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;
          var endMonth = delta > 0 ? self.config.showMonths : -1;
          for (var m = startMonth; m != endMonth; m += delta) {
              var month = self.daysContainer.children[m];
              var startIndex = delta > 0 ? 0 : month.children.length - 1;
              var endIndex = delta > 0 ? month.children.length : -1;
              for (var i = startIndex; i != endIndex; i += delta) {
                  var c = month.children[i];
                  if (c.className.indexOf("hidden") === -1 && isEnabled(c.dateObj))
                      return c;
              }
          }
          return undefined;
      }
      function getNextAvailableDay(current, delta) {
          var givenMonth = current.className.indexOf("Month") === -1
              ? current.dateObj.getMonth()
              : self.currentMonth;
          var endMonth = delta > 0 ? self.config.showMonths : -1;
          var loopDelta = delta > 0 ? 1 : -1;
          for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {
              var month = self.daysContainer.children[m];
              var startIndex = givenMonth - self.currentMonth === m
                  ? current.$i + delta
                  : delta < 0
                      ? month.children.length - 1
                      : 0;
              var numMonthDays = month.children.length;
              for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {
                  var c = month.children[i];
                  if (c.className.indexOf("hidden") === -1 &&
                      isEnabled(c.dateObj) &&
                      Math.abs(current.$i - i) >= Math.abs(delta))
                      return focusOnDayElem(c);
              }
          }
          self.changeMonth(loopDelta);
          focusOnDay(getFirstAvailableDay(loopDelta), 0);
          return undefined;
      }
      function focusOnDay(current, offset) {
          var activeElement = getClosestActiveElement();
          var dayFocused = isInView(activeElement || document.body);
          var startElem = current !== undefined
              ? current
              : dayFocused
                  ? activeElement
                  : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)
                      ? self.selectedDateElem
                      : self.todayDateElem !== undefined && isInView(self.todayDateElem)
                          ? self.todayDateElem
                          : getFirstAvailableDay(offset > 0 ? 1 : -1);
          if (startElem === undefined) {
              self._input.focus();
          }
          else if (!dayFocused) {
              focusOnDayElem(startElem);
          }
          else {
              getNextAvailableDay(startElem, offset);
          }
      }
      function buildMonthDays(year, month) {
          var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;
          var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12, year);
          var daysInMonth = self.utils.getDaysInMonth(month, year), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? "prevMonthDay hidden" : "prevMonthDay", nextMonthDayClass = isMultiMonth ? "nextMonthDay hidden" : "nextMonthDay";
          var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;
          for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {
              days.appendChild(createDay("flatpickr-day " + prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));
          }
          for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {
              days.appendChild(createDay("flatpickr-day", new Date(year, month, dayNumber), dayNumber, dayIndex));
          }
          for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&
              (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {
              days.appendChild(createDay("flatpickr-day " + nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));
          }
          var dayContainer = createElement("div", "dayContainer");
          dayContainer.appendChild(days);
          return dayContainer;
      }
      function buildDays() {
          if (self.daysContainer === undefined) {
              return;
          }
          clearNode(self.daysContainer);
          if (self.weekNumbers)
              clearNode(self.weekNumbers);
          var frag = document.createDocumentFragment();
          for (var i = 0; i < self.config.showMonths; i++) {
              var d = new Date(self.currentYear, self.currentMonth, 1);
              d.setMonth(self.currentMonth + i);
              frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));
          }
          self.daysContainer.appendChild(frag);
          self.days = self.daysContainer.firstChild;
          if (self.config.mode === "range" && self.selectedDates.length === 1) {
              onMouseOver();
          }
      }
      function buildMonthSwitch() {
          if (self.config.showMonths > 1 ||
              self.config.monthSelectorType !== "dropdown")
              return;
          var shouldBuildMonth = function (month) {
              if (self.config.minDate !== undefined &&
                  self.currentYear === self.config.minDate.getFullYear() &&
                  month < self.config.minDate.getMonth()) {
                  return false;
              }
              return !(self.config.maxDate !== undefined &&
                  self.currentYear === self.config.maxDate.getFullYear() &&
                  month > self.config.maxDate.getMonth());
          };
          self.monthsDropdownContainer.tabIndex = -1;
          self.monthsDropdownContainer.innerHTML = "";
          for (var i = 0; i < 12; i++) {
              if (!shouldBuildMonth(i))
                  continue;
              var month = createElement("option", "flatpickr-monthDropdown-month");
              month.value = new Date(self.currentYear, i).getMonth().toString();
              month.textContent = monthToStr(i, self.config.shorthandCurrentMonth, self.l10n);
              month.tabIndex = -1;
              if (self.currentMonth === i) {
                  month.selected = true;
              }
              self.monthsDropdownContainer.appendChild(month);
          }
      }
      function buildMonth() {
          var container = createElement("div", "flatpickr-month");
          var monthNavFragment = window.document.createDocumentFragment();
          var monthElement;
          if (self.config.showMonths > 1 ||
              self.config.monthSelectorType === "static") {
              monthElement = createElement("span", "cur-month");
          }
          else {
              self.monthsDropdownContainer = createElement("select", "flatpickr-monthDropdown-months");
              self.monthsDropdownContainer.setAttribute("aria-label", self.l10n.monthAriaLabel);
              bind(self.monthsDropdownContainer, "change", function (e) {
                  var target = getEventTarget(e);
                  var selectedMonth = parseInt(target.value, 10);
                  self.changeMonth(selectedMonth - self.currentMonth);
                  triggerEvent("onMonthChange");
              });
              buildMonthSwitch();
              monthElement = self.monthsDropdownContainer;
          }
          var yearInput = createNumberInput("cur-year", { tabindex: "-1" });
          var yearElement = yearInput.getElementsByTagName("input")[0];
          yearElement.setAttribute("aria-label", self.l10n.yearAriaLabel);
          if (self.config.minDate) {
              yearElement.setAttribute("min", self.config.minDate.getFullYear().toString());
          }
          if (self.config.maxDate) {
              yearElement.setAttribute("max", self.config.maxDate.getFullYear().toString());
              yearElement.disabled =
                  !!self.config.minDate &&
                      self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();
          }
          var currentMonth = createElement("div", "flatpickr-current-month");
          currentMonth.appendChild(monthElement);
          currentMonth.appendChild(yearInput);
          monthNavFragment.appendChild(currentMonth);
          container.appendChild(monthNavFragment);
          return {
              container: container,
              yearElement: yearElement,
              monthElement: monthElement,
          };
      }
      function buildMonths() {
          clearNode(self.monthNav);
          self.monthNav.appendChild(self.prevMonthNav);
          if (self.config.showMonths) {
              self.yearElements = [];
              self.monthElements = [];
          }
          for (var m = self.config.showMonths; m--;) {
              var month = buildMonth();
              self.yearElements.push(month.yearElement);
              self.monthElements.push(month.monthElement);
              self.monthNav.appendChild(month.container);
          }
          self.monthNav.appendChild(self.nextMonthNav);
      }
      function buildMonthNav() {
          self.monthNav = createElement("div", "flatpickr-months");
          self.yearElements = [];
          self.monthElements = [];
          self.prevMonthNav = createElement("span", "flatpickr-prev-month");
          self.prevMonthNav.innerHTML = self.config.prevArrow;
          self.nextMonthNav = createElement("span", "flatpickr-next-month");
          self.nextMonthNav.innerHTML = self.config.nextArrow;
          buildMonths();
          Object.defineProperty(self, "_hidePrevMonthArrow", {
              get: function () { return self.__hidePrevMonthArrow; },
              set: function (bool) {
                  if (self.__hidePrevMonthArrow !== bool) {
                      toggleClass(self.prevMonthNav, "flatpickr-disabled", bool);
                      self.__hidePrevMonthArrow = bool;
                  }
              },
          });
          Object.defineProperty(self, "_hideNextMonthArrow", {
              get: function () { return self.__hideNextMonthArrow; },
              set: function (bool) {
                  if (self.__hideNextMonthArrow !== bool) {
                      toggleClass(self.nextMonthNav, "flatpickr-disabled", bool);
                      self.__hideNextMonthArrow = bool;
                  }
              },
          });
          self.currentYearElement = self.yearElements[0];
          updateNavigationCurrentMonth();
          return self.monthNav;
      }
      function buildTime() {
          self.calendarContainer.classList.add("hasTime");
          if (self.config.noCalendar)
              self.calendarContainer.classList.add("noCalendar");
          var defaults = getDefaultHours(self.config);
          self.timeContainer = createElement("div", "flatpickr-time");
          self.timeContainer.tabIndex = -1;
          var separator = createElement("span", "flatpickr-time-separator", ":");
          var hourInput = createNumberInput("flatpickr-hour", {
              "aria-label": self.l10n.hourAriaLabel,
          });
          self.hourElement = hourInput.getElementsByTagName("input")[0];
          var minuteInput = createNumberInput("flatpickr-minute", {
              "aria-label": self.l10n.minuteAriaLabel,
          });
          self.minuteElement = minuteInput.getElementsByTagName("input")[0];
          self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;
          self.hourElement.value = pad(self.latestSelectedDateObj
              ? self.latestSelectedDateObj.getHours()
              : self.config.time_24hr
                  ? defaults.hours
                  : military2ampm(defaults.hours));
          self.minuteElement.value = pad(self.latestSelectedDateObj
              ? self.latestSelectedDateObj.getMinutes()
              : defaults.minutes);
          self.hourElement.setAttribute("step", self.config.hourIncrement.toString());
          self.minuteElement.setAttribute("step", self.config.minuteIncrement.toString());
          self.hourElement.setAttribute("min", self.config.time_24hr ? "0" : "1");
          self.hourElement.setAttribute("max", self.config.time_24hr ? "23" : "12");
          self.hourElement.setAttribute("maxlength", "2");
          self.minuteElement.setAttribute("min", "0");
          self.minuteElement.setAttribute("max", "59");
          self.minuteElement.setAttribute("maxlength", "2");
          self.timeContainer.appendChild(hourInput);
          self.timeContainer.appendChild(separator);
          self.timeContainer.appendChild(minuteInput);
          if (self.config.time_24hr)
              self.timeContainer.classList.add("time24hr");
          if (self.config.enableSeconds) {
              self.timeContainer.classList.add("hasSeconds");
              var secondInput = createNumberInput("flatpickr-second");
              self.secondElement = secondInput.getElementsByTagName("input")[0];
              self.secondElement.value = pad(self.latestSelectedDateObj
                  ? self.latestSelectedDateObj.getSeconds()
                  : defaults.seconds);
              self.secondElement.setAttribute("step", self.minuteElement.getAttribute("step"));
              self.secondElement.setAttribute("min", "0");
              self.secondElement.setAttribute("max", "59");
              self.secondElement.setAttribute("maxlength", "2");
              self.timeContainer.appendChild(createElement("span", "flatpickr-time-separator", ":"));
              self.timeContainer.appendChild(secondInput);
          }
          if (!self.config.time_24hr) {
              self.amPM = createElement("span", "flatpickr-am-pm", self.l10n.amPM[int((self.latestSelectedDateObj
                  ? self.hourElement.value
                  : self.config.defaultHour) > 11)]);
              self.amPM.title = self.l10n.toggleTitle;
              self.amPM.tabIndex = -1;
              self.timeContainer.appendChild(self.amPM);
          }
          return self.timeContainer;
      }
      function buildWeekdays() {
          if (!self.weekdayContainer)
              self.weekdayContainer = createElement("div", "flatpickr-weekdays");
          else
              clearNode(self.weekdayContainer);
          for (var i = self.config.showMonths; i--;) {
              var container = createElement("div", "flatpickr-weekdaycontainer");
              self.weekdayContainer.appendChild(container);
          }
          updateWeekdays();
          return self.weekdayContainer;
      }
      function updateWeekdays() {
          if (!self.weekdayContainer) {
              return;
          }
          var firstDayOfWeek = self.l10n.firstDayOfWeek;
          var weekdays = __spreadArrays(self.l10n.weekdays.shorthand);
          if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {
              weekdays = __spreadArrays(weekdays.splice(firstDayOfWeek, weekdays.length), weekdays.splice(0, firstDayOfWeek));
          }
          for (var i = self.config.showMonths; i--;) {
              self.weekdayContainer.children[i].innerHTML = "\n      <span class='flatpickr-weekday'>\n        " + weekdays.join("</span><span class='flatpickr-weekday'>") + "\n      </span>\n      ";
          }
      }
      function buildWeeks() {
          self.calendarContainer.classList.add("hasWeeks");
          var weekWrapper = createElement("div", "flatpickr-weekwrapper");
          weekWrapper.appendChild(createElement("span", "flatpickr-weekday", self.l10n.weekAbbreviation));
          var weekNumbers = createElement("div", "flatpickr-weeks");
          weekWrapper.appendChild(weekNumbers);
          return {
              weekWrapper: weekWrapper,
              weekNumbers: weekNumbers,
          };
      }
      function changeMonth(value, isOffset) {
          if (isOffset === void 0) { isOffset = true; }
          var delta = isOffset ? value : value - self.currentMonth;
          if ((delta < 0 && self._hidePrevMonthArrow === true) ||
              (delta > 0 && self._hideNextMonthArrow === true))
              return;
          self.currentMonth += delta;
          if (self.currentMonth < 0 || self.currentMonth > 11) {
              self.currentYear += self.currentMonth > 11 ? 1 : -1;
              self.currentMonth = (self.currentMonth + 12) % 12;
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
          buildDays();
          triggerEvent("onMonthChange");
          updateNavigationCurrentMonth();
      }
      function clear(triggerChangeEvent, toInitial) {
          if (triggerChangeEvent === void 0) { triggerChangeEvent = true; }
          if (toInitial === void 0) { toInitial = true; }
          self.input.value = "";
          if (self.altInput !== undefined)
              self.altInput.value = "";
          if (self.mobileInput !== undefined)
              self.mobileInput.value = "";
          self.selectedDates = [];
          self.latestSelectedDateObj = undefined;
          if (toInitial === true) {
              self.currentYear = self._initialDate.getFullYear();
              self.currentMonth = self._initialDate.getMonth();
          }
          if (self.config.enableTime === true) {
              var _a = getDefaultHours(self.config), hours = _a.hours, minutes = _a.minutes, seconds = _a.seconds;
              setHours(hours, minutes, seconds);
          }
          self.redraw();
          if (triggerChangeEvent)
              triggerEvent("onChange");
      }
      function close() {
          self.isOpen = false;
          if (!self.isMobile) {
              if (self.calendarContainer !== undefined) {
                  self.calendarContainer.classList.remove("open");
              }
              if (self._input !== undefined) {
                  self._input.classList.remove("active");
              }
          }
          triggerEvent("onClose");
      }
      function destroy() {
          if (self.config !== undefined)
              triggerEvent("onDestroy");
          for (var i = self._handlers.length; i--;) {
              self._handlers[i].remove();
          }
          self._handlers = [];
          if (self.mobileInput) {
              if (self.mobileInput.parentNode)
                  self.mobileInput.parentNode.removeChild(self.mobileInput);
              self.mobileInput = undefined;
          }
          else if (self.calendarContainer && self.calendarContainer.parentNode) {
              if (self.config.static && self.calendarContainer.parentNode) {
                  var wrapper = self.calendarContainer.parentNode;
                  wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);
                  if (wrapper.parentNode) {
                      while (wrapper.firstChild)
                          wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);
                      wrapper.parentNode.removeChild(wrapper);
                  }
              }
              else
                  self.calendarContainer.parentNode.removeChild(self.calendarContainer);
          }
          if (self.altInput) {
              self.input.type = "text";
              if (self.altInput.parentNode)
                  self.altInput.parentNode.removeChild(self.altInput);
              delete self.altInput;
          }
          if (self.input) {
              self.input.type = self.input._type;
              self.input.classList.remove("flatpickr-input");
              self.input.removeAttribute("readonly");
          }
          [
              "_showTimeInput",
              "latestSelectedDateObj",
              "_hideNextMonthArrow",
              "_hidePrevMonthArrow",
              "__hideNextMonthArrow",
              "__hidePrevMonthArrow",
              "isMobile",
              "isOpen",
              "selectedDateElem",
              "minDateHasTime",
              "maxDateHasTime",
              "days",
              "daysContainer",
              "_input",
              "_positionElement",
              "innerContainer",
              "rContainer",
              "monthNav",
              "todayDateElem",
              "calendarContainer",
              "weekdayContainer",
              "prevMonthNav",
              "nextMonthNav",
              "monthsDropdownContainer",
              "currentMonthElement",
              "currentYearElement",
              "navigationCurrentMonth",
              "selectedDateElem",
              "config",
          ].forEach(function (k) {
              try {
                  delete self[k];
              }
              catch (_) { }
          });
      }
      function isCalendarElem(elem) {
          return self.calendarContainer.contains(elem);
      }
      function documentClick(e) {
          if (self.isOpen && !self.config.inline) {
              var eventTarget_1 = getEventTarget(e);
              var isCalendarElement = isCalendarElem(eventTarget_1);
              var isInput = eventTarget_1 === self.input ||
                  eventTarget_1 === self.altInput ||
                  self.element.contains(eventTarget_1) ||
                  (e.path &&
                      e.path.indexOf &&
                      (~e.path.indexOf(self.input) ||
                          ~e.path.indexOf(self.altInput)));
              var lostFocus = !isInput &&
                  !isCalendarElement &&
                  !isCalendarElem(e.relatedTarget);
              var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {
                  return elem.contains(eventTarget_1);
              });
              if (lostFocus && isIgnored) {
                  if (self.config.allowInput) {
                      self.setDate(self._input.value, false, self.config.altInput
                          ? self.config.altFormat
                          : self.config.dateFormat);
                  }
                  if (self.timeContainer !== undefined &&
                      self.minuteElement !== undefined &&
                      self.hourElement !== undefined &&
                      self.input.value !== "" &&
                      self.input.value !== undefined) {
                      updateTime();
                  }
                  self.close();
                  if (self.config &&
                      self.config.mode === "range" &&
                      self.selectedDates.length === 1)
                      self.clear(false);
              }
          }
      }
      function changeYear(newYear) {
          if (!newYear ||
              (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||
              (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))
              return;
          var newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;
          self.currentYear = newYearNum || self.currentYear;
          if (self.config.maxDate &&
              self.currentYear === self.config.maxDate.getFullYear()) {
              self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);
          }
          else if (self.config.minDate &&
              self.currentYear === self.config.minDate.getFullYear()) {
              self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);
          }
          if (isNewYear) {
              self.redraw();
              triggerEvent("onYearChange");
              buildMonthSwitch();
          }
      }
      function isEnabled(date, timeless) {
          var _a;
          if (timeless === void 0) { timeless = true; }
          var dateToCheck = self.parseDate(date, undefined, timeless);
          if ((self.config.minDate &&
              dateToCheck &&
              compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||
              (self.config.maxDate &&
                  dateToCheck &&
                  compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))
              return false;
          if (!self.config.enable && self.config.disable.length === 0)
              return true;
          if (dateToCheck === undefined)
              return false;
          var bool = !!self.config.enable, array = (_a = self.config.enable) !== null && _a !== void 0 ? _a : self.config.disable;
          for (var i = 0, d = void 0; i < array.length; i++) {
              d = array[i];
              if (typeof d === "function" &&
                  d(dateToCheck))
                  return bool;
              else if (d instanceof Date &&
                  dateToCheck !== undefined &&
                  d.getTime() === dateToCheck.getTime())
                  return bool;
              else if (typeof d === "string") {
                  var parsed = self.parseDate(d, undefined, true);
                  return parsed && parsed.getTime() === dateToCheck.getTime()
                      ? bool
                      : !bool;
              }
              else if (typeof d === "object" &&
                  dateToCheck !== undefined &&
                  d.from &&
                  d.to &&
                  dateToCheck.getTime() >= d.from.getTime() &&
                  dateToCheck.getTime() <= d.to.getTime())
                  return bool;
          }
          return !bool;
      }
      function isInView(elem) {
          if (self.daysContainer !== undefined)
              return (elem.className.indexOf("hidden") === -1 &&
                  elem.className.indexOf("flatpickr-disabled") === -1 &&
                  self.daysContainer.contains(elem));
          return false;
      }
      function onBlur(e) {
          var isInput = e.target === self._input;
          var valueChanged = self._input.value.trimEnd() !== getDateStr();
          if (isInput &&
              valueChanged &&
              !(e.relatedTarget && isCalendarElem(e.relatedTarget))) {
              self.setDate(self._input.value, true, e.target === self.altInput
                  ? self.config.altFormat
                  : self.config.dateFormat);
          }
      }
      function onKeyDown(e) {
          var eventTarget = getEventTarget(e);
          var isInput = self.config.wrap
              ? element.contains(eventTarget)
              : eventTarget === self._input;
          var allowInput = self.config.allowInput;
          var allowKeydown = self.isOpen && (!allowInput || !isInput);
          var allowInlineKeydown = self.config.inline && isInput && !allowInput;
          if (e.keyCode === 13 && isInput) {
              if (allowInput) {
                  self.setDate(self._input.value, true, eventTarget === self.altInput
                      ? self.config.altFormat
                      : self.config.dateFormat);
                  self.close();
                  return eventTarget.blur();
              }
              else {
                  self.open();
              }
          }
          else if (isCalendarElem(eventTarget) ||
              allowKeydown ||
              allowInlineKeydown) {
              var isTimeObj = !!self.timeContainer &&
                  self.timeContainer.contains(eventTarget);
              switch (e.keyCode) {
                  case 13:
                      if (isTimeObj) {
                          e.preventDefault();
                          updateTime();
                          focusAndClose();
                      }
                      else
                          selectDate(e);
                      break;
                  case 27:
                      e.preventDefault();
                      focusAndClose();
                      break;
                  case 8:
                  case 46:
                      if (isInput && !self.config.allowInput) {
                          e.preventDefault();
                          self.clear();
                      }
                      break;
                  case 37:
                  case 39:
                      if (!isTimeObj && !isInput) {
                          e.preventDefault();
                          var activeElement = getClosestActiveElement();
                          if (self.daysContainer !== undefined &&
                              (allowInput === false ||
                                  (activeElement && isInView(activeElement)))) {
                              var delta_1 = e.keyCode === 39 ? 1 : -1;
                              if (!e.ctrlKey)
                                  focusOnDay(undefined, delta_1);
                              else {
                                  e.stopPropagation();
                                  changeMonth(delta_1);
                                  focusOnDay(getFirstAvailableDay(1), 0);
                              }
                          }
                      }
                      else if (self.hourElement)
                          self.hourElement.focus();
                      break;
                  case 38:
                  case 40:
                      e.preventDefault();
                      var delta = e.keyCode === 40 ? 1 : -1;
                      if ((self.daysContainer &&
                          eventTarget.$i !== undefined) ||
                          eventTarget === self.input ||
                          eventTarget === self.altInput) {
                          if (e.ctrlKey) {
                              e.stopPropagation();
                              changeYear(self.currentYear - delta);
                              focusOnDay(getFirstAvailableDay(1), 0);
                          }
                          else if (!isTimeObj)
                              focusOnDay(undefined, delta * 7);
                      }
                      else if (eventTarget === self.currentYearElement) {
                          changeYear(self.currentYear - delta);
                      }
                      else if (self.config.enableTime) {
                          if (!isTimeObj && self.hourElement)
                              self.hourElement.focus();
                          updateTime(e);
                          self._debouncedChange();
                      }
                      break;
                  case 9:
                      if (isTimeObj) {
                          var elems = [
                              self.hourElement,
                              self.minuteElement,
                              self.secondElement,
                              self.amPM,
                          ]
                              .concat(self.pluginElements)
                              .filter(function (x) { return x; });
                          var i = elems.indexOf(eventTarget);
                          if (i !== -1) {
                              var target = elems[i + (e.shiftKey ? -1 : 1)];
                              e.preventDefault();
                              (target || self._input).focus();
                          }
                      }
                      else if (!self.config.noCalendar &&
                          self.daysContainer &&
                          self.daysContainer.contains(eventTarget) &&
                          e.shiftKey) {
                          e.preventDefault();
                          self._input.focus();
                      }
                      break;
              }
          }
          if (self.amPM !== undefined && eventTarget === self.amPM) {
              switch (e.key) {
                  case self.l10n.amPM[0].charAt(0):
                  case self.l10n.amPM[0].charAt(0).toLowerCase():
                      self.amPM.textContent = self.l10n.amPM[0];
                      setHoursFromInputs();
                      updateValue();
                      break;
                  case self.l10n.amPM[1].charAt(0):
                  case self.l10n.amPM[1].charAt(0).toLowerCase():
                      self.amPM.textContent = self.l10n.amPM[1];
                      setHoursFromInputs();
                      updateValue();
                      break;
              }
          }
          if (isInput || isCalendarElem(eventTarget)) {
              triggerEvent("onKeyDown", e);
          }
      }
      function onMouseOver(elem, cellClass) {
          if (cellClass === void 0) { cellClass = "flatpickr-day"; }
          if (self.selectedDates.length !== 1 ||
              (elem &&
                  (!elem.classList.contains(cellClass) ||
                      elem.classList.contains("flatpickr-disabled"))))
              return;
          var hoverDate = elem
              ? elem.dateObj.getTime()
              : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());
          var containsDisabled = false;
          var minRange = 0, maxRange = 0;
          for (var t = rangeStartDate; t < rangeEndDate; t += duration$1.DAY) {
              if (!isEnabled(new Date(t), true)) {
                  containsDisabled =
                      containsDisabled || (t > rangeStartDate && t < rangeEndDate);
                  if (t < initialDate && (!minRange || t > minRange))
                      minRange = t;
                  else if (t > initialDate && (!maxRange || t < maxRange))
                      maxRange = t;
              }
          }
          var hoverableCells = Array.from(self.rContainer.querySelectorAll("*:nth-child(-n+" + self.config.showMonths + ") > ." + cellClass));
          hoverableCells.forEach(function (dayElem) {
              var date = dayElem.dateObj;
              var timestamp = date.getTime();
              var outOfRange = (minRange > 0 && timestamp < minRange) ||
                  (maxRange > 0 && timestamp > maxRange);
              if (outOfRange) {
                  dayElem.classList.add("notAllowed");
                  ["inRange", "startRange", "endRange"].forEach(function (c) {
                      dayElem.classList.remove(c);
                  });
                  return;
              }
              else if (containsDisabled && !outOfRange)
                  return;
              ["startRange", "inRange", "endRange", "notAllowed"].forEach(function (c) {
                  dayElem.classList.remove(c);
              });
              if (elem !== undefined) {
                  elem.classList.add(hoverDate <= self.selectedDates[0].getTime()
                      ? "startRange"
                      : "endRange");
                  if (initialDate < hoverDate && timestamp === initialDate)
                      dayElem.classList.add("startRange");
                  else if (initialDate > hoverDate && timestamp === initialDate)
                      dayElem.classList.add("endRange");
                  if (timestamp >= minRange &&
                      (maxRange === 0 || timestamp <= maxRange) &&
                      isBetween(timestamp, initialDate, hoverDate))
                      dayElem.classList.add("inRange");
              }
          });
      }
      function onResize() {
          if (self.isOpen && !self.config.static && !self.config.inline)
              positionCalendar();
      }
      function open(e, positionElement) {
          if (positionElement === void 0) { positionElement = self._positionElement; }
          if (self.isMobile === true) {
              if (e) {
                  e.preventDefault();
                  var eventTarget = getEventTarget(e);
                  if (eventTarget) {
                      eventTarget.blur();
                  }
              }
              if (self.mobileInput !== undefined) {
                  self.mobileInput.focus();
                  self.mobileInput.click();
              }
              triggerEvent("onOpen");
              return;
          }
          else if (self._input.disabled || self.config.inline) {
              return;
          }
          var wasOpen = self.isOpen;
          self.isOpen = true;
          if (!wasOpen) {
              self.calendarContainer.classList.add("open");
              self._input.classList.add("active");
              triggerEvent("onOpen");
              positionCalendar(positionElement);
          }
          if (self.config.enableTime === true && self.config.noCalendar === true) {
              if (self.config.allowInput === false &&
                  (e === undefined ||
                      !self.timeContainer.contains(e.relatedTarget))) {
                  setTimeout(function () { return self.hourElement.select(); }, 50);
              }
          }
      }
      function minMaxDateSetter(type) {
          return function (date) {
              var dateObj = (self.config["_" + type + "Date"] = self.parseDate(date, self.config.dateFormat));
              var inverseDateObj = self.config["_" + (type === "min" ? "max" : "min") + "Date"];
              if (dateObj !== undefined) {
                  self[type === "min" ? "minDateHasTime" : "maxDateHasTime"] =
                      dateObj.getHours() > 0 ||
                          dateObj.getMinutes() > 0 ||
                          dateObj.getSeconds() > 0;
              }
              if (self.selectedDates) {
                  self.selectedDates = self.selectedDates.filter(function (d) { return isEnabled(d); });
                  if (!self.selectedDates.length && type === "min")
                      setHoursFromDate(dateObj);
                  updateValue();
              }
              if (self.daysContainer) {
                  redraw();
                  if (dateObj !== undefined)
                      self.currentYearElement[type] = dateObj.getFullYear().toString();
                  else
                      self.currentYearElement.removeAttribute(type);
                  self.currentYearElement.disabled =
                      !!inverseDateObj &&
                          dateObj !== undefined &&
                          inverseDateObj.getFullYear() === dateObj.getFullYear();
              }
          };
      }
      function parseConfig() {
          var boolOpts = [
              "wrap",
              "weekNumbers",
              "allowInput",
              "allowInvalidPreload",
              "clickOpens",
              "time_24hr",
              "enableTime",
              "noCalendar",
              "altInput",
              "shorthandCurrentMonth",
              "inline",
              "static",
              "enableSeconds",
              "disableMobile",
          ];
          var userConfig = __assign(__assign({}, JSON.parse(JSON.stringify(element.dataset || {}))), instanceConfig);
          var formats = {};
          self.config.parseDate = userConfig.parseDate;
          self.config.formatDate = userConfig.formatDate;
          Object.defineProperty(self.config, "enable", {
              get: function () { return self.config._enable; },
              set: function (dates) {
                  self.config._enable = parseDateRules(dates);
              },
          });
          Object.defineProperty(self.config, "disable", {
              get: function () { return self.config._disable; },
              set: function (dates) {
                  self.config._disable = parseDateRules(dates);
              },
          });
          var timeMode = userConfig.mode === "time";
          if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {
              var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults$1.dateFormat;
              formats.dateFormat =
                  userConfig.noCalendar || timeMode
                      ? "H:i" + (userConfig.enableSeconds ? ":S" : "")
                      : defaultDateFormat + " H:i" + (userConfig.enableSeconds ? ":S" : "");
          }
          if (userConfig.altInput &&
              (userConfig.enableTime || timeMode) &&
              !userConfig.altFormat) {
              var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults$1.altFormat;
              formats.altFormat =
                  userConfig.noCalendar || timeMode
                      ? "h:i" + (userConfig.enableSeconds ? ":S K" : " K")
                      : defaultAltFormat + (" h:i" + (userConfig.enableSeconds ? ":S" : "") + " K");
          }
          Object.defineProperty(self.config, "minDate", {
              get: function () { return self.config._minDate; },
              set: minMaxDateSetter("min"),
          });
          Object.defineProperty(self.config, "maxDate", {
              get: function () { return self.config._maxDate; },
              set: minMaxDateSetter("max"),
          });
          var minMaxTimeSetter = function (type) { return function (val) {
              self.config[type === "min" ? "_minTime" : "_maxTime"] = self.parseDate(val, "H:i:S");
          }; };
          Object.defineProperty(self.config, "minTime", {
              get: function () { return self.config._minTime; },
              set: minMaxTimeSetter("min"),
          });
          Object.defineProperty(self.config, "maxTime", {
              get: function () { return self.config._maxTime; },
              set: minMaxTimeSetter("max"),
          });
          if (userConfig.mode === "time") {
              self.config.noCalendar = true;
              self.config.enableTime = true;
          }
          Object.assign(self.config, formats, userConfig);
          for (var i = 0; i < boolOpts.length; i++)
              self.config[boolOpts[i]] =
                  self.config[boolOpts[i]] === true ||
                      self.config[boolOpts[i]] === "true";
          HOOKS.filter(function (hook) { return self.config[hook] !== undefined; }).forEach(function (hook) {
              self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);
          });
          self.isMobile =
              !self.config.disableMobile &&
                  !self.config.inline &&
                  self.config.mode === "single" &&
                  !self.config.disable.length &&
                  !self.config.enable &&
                  !self.config.weekNumbers &&
                  /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
          for (var i = 0; i < self.config.plugins.length; i++) {
              var pluginConf = self.config.plugins[i](self) || {};
              for (var key in pluginConf) {
                  if (HOOKS.indexOf(key) > -1) {
                      self.config[key] = arrayify(pluginConf[key])
                          .map(bindToInstance)
                          .concat(self.config[key]);
                  }
                  else if (typeof userConfig[key] === "undefined")
                      self.config[key] = pluginConf[key];
              }
          }
          if (!userConfig.altInputClass) {
              self.config.altInputClass =
                  getInputElem().className + " " + self.config.altInputClass;
          }
          triggerEvent("onParseConfig");
      }
      function getInputElem() {
          return self.config.wrap
              ? element.querySelector("[data-input]")
              : element;
      }
      function setupLocale() {
          if (typeof self.config.locale !== "object" &&
              typeof flatpickr.l10ns[self.config.locale] === "undefined")
              self.config.errorHandler(new Error("flatpickr: invalid locale " + self.config.locale));
          self.l10n = __assign(__assign({}, flatpickr.l10ns.default), (typeof self.config.locale === "object"
              ? self.config.locale
              : self.config.locale !== "default"
                  ? flatpickr.l10ns[self.config.locale]
                  : undefined));
          tokenRegex.D = "(" + self.l10n.weekdays.shorthand.join("|") + ")";
          tokenRegex.l = "(" + self.l10n.weekdays.longhand.join("|") + ")";
          tokenRegex.M = "(" + self.l10n.months.shorthand.join("|") + ")";
          tokenRegex.F = "(" + self.l10n.months.longhand.join("|") + ")";
          tokenRegex.K = "(" + self.l10n.amPM[0] + "|" + self.l10n.amPM[1] + "|" + self.l10n.amPM[0].toLowerCase() + "|" + self.l10n.amPM[1].toLowerCase() + ")";
          var userConfig = __assign(__assign({}, instanceConfig), JSON.parse(JSON.stringify(element.dataset || {})));
          if (userConfig.time_24hr === undefined &&
              flatpickr.defaultConfig.time_24hr === undefined) {
              self.config.time_24hr = self.l10n.time_24hr;
          }
          self.formatDate = createDateFormatter(self);
          self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });
      }
      function positionCalendar(customPositionElement) {
          if (typeof self.config.position === "function") {
              return void self.config.position(self, customPositionElement);
          }
          if (self.calendarContainer === undefined)
              return;
          triggerEvent("onPreCalendarPosition");
          var positionElement = customPositionElement || self._positionElement;
          var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, (function (acc, child) { return acc + child.offsetHeight; }), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(" "), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === "above" ||
              (configPosVertical !== "below" &&
                  distanceFromBottom < calendarHeight &&
                  inputBounds.top > calendarHeight);
          var top = window.pageYOffset +
              inputBounds.top +
              (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);
          toggleClass(self.calendarContainer, "arrowTop", !showOnTop);
          toggleClass(self.calendarContainer, "arrowBottom", showOnTop);
          if (self.config.inline)
              return;
          var left = window.pageXOffset + inputBounds.left;
          var isCenter = false;
          var isRight = false;
          if (configPosHorizontal === "center") {
              left -= (calendarWidth - inputBounds.width) / 2;
              isCenter = true;
          }
          else if (configPosHorizontal === "right") {
              left -= calendarWidth - inputBounds.width;
              isRight = true;
          }
          toggleClass(self.calendarContainer, "arrowLeft", !isCenter && !isRight);
          toggleClass(self.calendarContainer, "arrowCenter", isCenter);
          toggleClass(self.calendarContainer, "arrowRight", isRight);
          var right = window.document.body.offsetWidth -
              (window.pageXOffset + inputBounds.right);
          var rightMost = left + calendarWidth > window.document.body.offsetWidth;
          var centerMost = right + calendarWidth > window.document.body.offsetWidth;
          toggleClass(self.calendarContainer, "rightMost", rightMost);
          if (self.config.static)
              return;
          self.calendarContainer.style.top = top + "px";
          if (!rightMost) {
              self.calendarContainer.style.left = left + "px";
              self.calendarContainer.style.right = "auto";
          }
          else if (!centerMost) {
              self.calendarContainer.style.left = "auto";
              self.calendarContainer.style.right = right + "px";
          }
          else {
              var doc = getDocumentStyleSheet();
              if (doc === undefined)
                  return;
              var bodyWidth = window.document.body.offsetWidth;
              var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);
              var centerBefore = ".flatpickr-calendar.centerMost:before";
              var centerAfter = ".flatpickr-calendar.centerMost:after";
              var centerIndex = doc.cssRules.length;
              var centerStyle = "{left:" + inputBounds.left + "px;right:auto;}";
              toggleClass(self.calendarContainer, "rightMost", false);
              toggleClass(self.calendarContainer, "centerMost", true);
              doc.insertRule(centerBefore + "," + centerAfter + centerStyle, centerIndex);
              self.calendarContainer.style.left = centerLeft + "px";
              self.calendarContainer.style.right = "auto";
          }
      }
      function getDocumentStyleSheet() {
          var editableSheet = null;
          for (var i = 0; i < document.styleSheets.length; i++) {
              var sheet = document.styleSheets[i];
              if (!sheet.cssRules)
                  continue;
              try {
                  sheet.cssRules;
              }
              catch (err) {
                  continue;
              }
              editableSheet = sheet;
              break;
          }
          return editableSheet != null ? editableSheet : createStyleSheet();
      }
      function createStyleSheet() {
          var style = document.createElement("style");
          document.head.appendChild(style);
          return style.sheet;
      }
      function redraw() {
          if (self.config.noCalendar || self.isMobile)
              return;
          buildMonthSwitch();
          updateNavigationCurrentMonth();
          buildDays();
      }
      function focusAndClose() {
          self._input.focus();
          if (window.navigator.userAgent.indexOf("MSIE") !== -1 ||
              navigator.msMaxTouchPoints !== undefined) {
              setTimeout(self.close, 0);
          }
          else {
              self.close();
          }
      }
      function selectDate(e) {
          e.preventDefault();
          e.stopPropagation();
          var isSelectable = function (day) {
              return day.classList &&
                  day.classList.contains("flatpickr-day") &&
                  !day.classList.contains("flatpickr-disabled") &&
                  !day.classList.contains("notAllowed");
          };
          var t = findParent(getEventTarget(e), isSelectable);
          if (t === undefined)
              return;
          var target = t;
          var selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));
          var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||
              selectedDate.getMonth() >
                  self.currentMonth + self.config.showMonths - 1) &&
              self.config.mode !== "range";
          self.selectedDateElem = target;
          if (self.config.mode === "single")
              self.selectedDates = [selectedDate];
          else if (self.config.mode === "multiple") {
              var selectedIndex = isDateSelected(selectedDate);
              if (selectedIndex)
                  self.selectedDates.splice(parseInt(selectedIndex), 1);
              else
                  self.selectedDates.push(selectedDate);
          }
          else if (self.config.mode === "range") {
              if (self.selectedDates.length === 2) {
                  self.clear(false, false);
              }
              self.latestSelectedDateObj = selectedDate;
              self.selectedDates.push(selectedDate);
              if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)
                  self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });
          }
          setHoursFromInputs();
          if (shouldChangeMonth) {
              var isNewYear = self.currentYear !== selectedDate.getFullYear();
              self.currentYear = selectedDate.getFullYear();
              self.currentMonth = selectedDate.getMonth();
              if (isNewYear) {
                  triggerEvent("onYearChange");
                  buildMonthSwitch();
              }
              triggerEvent("onMonthChange");
          }
          updateNavigationCurrentMonth();
          buildDays();
          updateValue();
          if (!shouldChangeMonth &&
              self.config.mode !== "range" &&
              self.config.showMonths === 1)
              focusOnDayElem(target);
          else if (self.selectedDateElem !== undefined &&
              self.hourElement === undefined) {
              self.selectedDateElem && self.selectedDateElem.focus();
          }
          if (self.hourElement !== undefined)
              self.hourElement !== undefined && self.hourElement.focus();
          if (self.config.closeOnSelect) {
              var single = self.config.mode === "single" && !self.config.enableTime;
              var range = self.config.mode === "range" &&
                  self.selectedDates.length === 2 &&
                  !self.config.enableTime;
              if (single || range) {
                  focusAndClose();
              }
          }
          triggerChange();
      }
      var CALLBACKS = {
          locale: [setupLocale, updateWeekdays],
          showMonths: [buildMonths, setCalendarWidth, buildWeekdays],
          minDate: [jumpToDate],
          maxDate: [jumpToDate],
          positionElement: [updatePositionElement],
          clickOpens: [
              function () {
                  if (self.config.clickOpens === true) {
                      bind(self._input, "focus", self.open);
                      bind(self._input, "click", self.open);
                  }
                  else {
                      self._input.removeEventListener("focus", self.open);
                      self._input.removeEventListener("click", self.open);
                  }
              },
          ],
      };
      function set(option, value) {
          if (option !== null && typeof option === "object") {
              Object.assign(self.config, option);
              for (var key in option) {
                  if (CALLBACKS[key] !== undefined)
                      CALLBACKS[key].forEach(function (x) { return x(); });
              }
          }
          else {
              self.config[option] = value;
              if (CALLBACKS[option] !== undefined)
                  CALLBACKS[option].forEach(function (x) { return x(); });
              else if (HOOKS.indexOf(option) > -1)
                  self.config[option] = arrayify(value);
          }
          self.redraw();
          updateValue(true);
      }
      function setSelectedDate(inputDate, format) {
          var dates = [];
          if (inputDate instanceof Array)
              dates = inputDate.map(function (d) { return self.parseDate(d, format); });
          else if (inputDate instanceof Date || typeof inputDate === "number")
              dates = [self.parseDate(inputDate, format)];
          else if (typeof inputDate === "string") {
              switch (self.config.mode) {
                  case "single":
                  case "time":
                      dates = [self.parseDate(inputDate, format)];
                      break;
                  case "multiple":
                      dates = inputDate
                          .split(self.config.conjunction)
                          .map(function (date) { return self.parseDate(date, format); });
                      break;
                  case "range":
                      dates = inputDate
                          .split(self.l10n.rangeSeparator)
                          .map(function (date) { return self.parseDate(date, format); });
                      break;
              }
          }
          else
              self.config.errorHandler(new Error("Invalid date supplied: " + JSON.stringify(inputDate)));
          self.selectedDates = (self.config.allowInvalidPreload
              ? dates
              : dates.filter(function (d) { return d instanceof Date && isEnabled(d, false); }));
          if (self.config.mode === "range")
              self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });
      }
      function setDate(date, triggerChange, format) {
          if (triggerChange === void 0) { triggerChange = false; }
          if (format === void 0) { format = self.config.dateFormat; }
          if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))
              return self.clear(triggerChange);
          setSelectedDate(date, format);
          self.latestSelectedDateObj =
              self.selectedDates[self.selectedDates.length - 1];
          self.redraw();
          jumpToDate(undefined, triggerChange);
          setHoursFromDate();
          if (self.selectedDates.length === 0) {
              self.clear(false);
          }
          updateValue(triggerChange);
          if (triggerChange)
              triggerEvent("onChange");
      }
      function parseDateRules(arr) {
          return arr
              .slice()
              .map(function (rule) {
              if (typeof rule === "string" ||
                  typeof rule === "number" ||
                  rule instanceof Date) {
                  return self.parseDate(rule, undefined, true);
              }
              else if (rule &&
                  typeof rule === "object" &&
                  rule.from &&
                  rule.to)
                  return {
                      from: self.parseDate(rule.from, undefined),
                      to: self.parseDate(rule.to, undefined),
                  };
              return rule;
          })
              .filter(function (x) { return x; });
      }
      function setupDates() {
          self.selectedDates = [];
          self.now = self.parseDate(self.config.now) || new Date();
          var preloadedDate = self.config.defaultDate ||
              ((self.input.nodeName === "INPUT" ||
                  self.input.nodeName === "TEXTAREA") &&
                  self.input.placeholder &&
                  self.input.value === self.input.placeholder
                  ? null
                  : self.input.value);
          if (preloadedDate)
              setSelectedDate(preloadedDate, self.config.dateFormat);
          self._initialDate =
              self.selectedDates.length > 0
                  ? self.selectedDates[0]
                  : self.config.minDate &&
                      self.config.minDate.getTime() > self.now.getTime()
                      ? self.config.minDate
                      : self.config.maxDate &&
                          self.config.maxDate.getTime() < self.now.getTime()
                          ? self.config.maxDate
                          : self.now;
          self.currentYear = self._initialDate.getFullYear();
          self.currentMonth = self._initialDate.getMonth();
          if (self.selectedDates.length > 0)
              self.latestSelectedDateObj = self.selectedDates[0];
          if (self.config.minTime !== undefined)
              self.config.minTime = self.parseDate(self.config.minTime, "H:i");
          if (self.config.maxTime !== undefined)
              self.config.maxTime = self.parseDate(self.config.maxTime, "H:i");
          self.minDateHasTime =
              !!self.config.minDate &&
                  (self.config.minDate.getHours() > 0 ||
                      self.config.minDate.getMinutes() > 0 ||
                      self.config.minDate.getSeconds() > 0);
          self.maxDateHasTime =
              !!self.config.maxDate &&
                  (self.config.maxDate.getHours() > 0 ||
                      self.config.maxDate.getMinutes() > 0 ||
                      self.config.maxDate.getSeconds() > 0);
      }
      function setupInputs() {
          self.input = getInputElem();
          if (!self.input) {
              self.config.errorHandler(new Error("Invalid input element specified"));
              return;
          }
          self.input._type = self.input.type;
          self.input.type = "text";
          self.input.classList.add("flatpickr-input");
          self._input = self.input;
          if (self.config.altInput) {
              self.altInput = createElement(self.input.nodeName, self.config.altInputClass);
              self._input = self.altInput;
              self.altInput.placeholder = self.input.placeholder;
              self.altInput.disabled = self.input.disabled;
              self.altInput.required = self.input.required;
              self.altInput.tabIndex = self.input.tabIndex;
              self.altInput.type = "text";
              self.input.setAttribute("type", "hidden");
              if (!self.config.static && self.input.parentNode)
                  self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);
          }
          if (!self.config.allowInput)
              self._input.setAttribute("readonly", "readonly");
          updatePositionElement();
      }
      function updatePositionElement() {
          self._positionElement = self.config.positionElement || self._input;
      }
      function setupMobile() {
          var inputType = self.config.enableTime
              ? self.config.noCalendar
                  ? "time"
                  : "datetime-local"
              : "date";
          self.mobileInput = createElement("input", self.input.className + " flatpickr-mobile");
          self.mobileInput.tabIndex = 1;
          self.mobileInput.type = inputType;
          self.mobileInput.disabled = self.input.disabled;
          self.mobileInput.required = self.input.required;
          self.mobileInput.placeholder = self.input.placeholder;
          self.mobileFormatStr =
              inputType === "datetime-local"
                  ? "Y-m-d\\TH:i:S"
                  : inputType === "date"
                      ? "Y-m-d"
                      : "H:i:S";
          if (self.selectedDates.length > 0) {
              self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);
          }
          if (self.config.minDate)
              self.mobileInput.min = self.formatDate(self.config.minDate, "Y-m-d");
          if (self.config.maxDate)
              self.mobileInput.max = self.formatDate(self.config.maxDate, "Y-m-d");
          if (self.input.getAttribute("step"))
              self.mobileInput.step = String(self.input.getAttribute("step"));
          self.input.type = "hidden";
          if (self.altInput !== undefined)
              self.altInput.type = "hidden";
          try {
              if (self.input.parentNode)
                  self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);
          }
          catch (_a) { }
          bind(self.mobileInput, "change", function (e) {
              self.setDate(getEventTarget(e).value, false, self.mobileFormatStr);
              triggerEvent("onChange");
              triggerEvent("onClose");
          });
      }
      function toggle(e) {
          if (self.isOpen === true)
              return self.close();
          self.open(e);
      }
      function triggerEvent(event, data) {
          if (self.config === undefined)
              return;
          var hooks = self.config[event];
          if (hooks !== undefined && hooks.length > 0) {
              for (var i = 0; hooks[i] && i < hooks.length; i++)
                  hooks[i](self.selectedDates, self.input.value, self, data);
          }
          if (event === "onChange") {
              self.input.dispatchEvent(createEvent("change"));
              self.input.dispatchEvent(createEvent("input"));
          }
      }
      function createEvent(name) {
          var e = document.createEvent("Event");
          e.initEvent(name, true, true);
          return e;
      }
      function isDateSelected(date) {
          for (var i = 0; i < self.selectedDates.length; i++) {
              var selectedDate = self.selectedDates[i];
              if (selectedDate instanceof Date &&
                  compareDates(selectedDate, date) === 0)
                  return "" + i;
          }
          return false;
      }
      function isDateInRange(date) {
          if (self.config.mode !== "range" || self.selectedDates.length < 2)
              return false;
          return (compareDates(date, self.selectedDates[0]) >= 0 &&
              compareDates(date, self.selectedDates[1]) <= 0);
      }
      function updateNavigationCurrentMonth() {
          if (self.config.noCalendar || self.isMobile || !self.monthNav)
              return;
          self.yearElements.forEach(function (yearElement, i) {
              var d = new Date(self.currentYear, self.currentMonth, 1);
              d.setMonth(self.currentMonth + i);
              if (self.config.showMonths > 1 ||
                  self.config.monthSelectorType === "static") {
                  self.monthElements[i].textContent =
                      monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + " ";
              }
              else {
                  self.monthsDropdownContainer.value = d.getMonth().toString();
              }
              yearElement.value = d.getFullYear().toString();
          });
          self._hidePrevMonthArrow =
              self.config.minDate !== undefined &&
                  (self.currentYear === self.config.minDate.getFullYear()
                      ? self.currentMonth <= self.config.minDate.getMonth()
                      : self.currentYear < self.config.minDate.getFullYear());
          self._hideNextMonthArrow =
              self.config.maxDate !== undefined &&
                  (self.currentYear === self.config.maxDate.getFullYear()
                      ? self.currentMonth + 1 > self.config.maxDate.getMonth()
                      : self.currentYear > self.config.maxDate.getFullYear());
      }
      function getDateStr(specificFormat) {
          var format = specificFormat ||
              (self.config.altInput ? self.config.altFormat : self.config.dateFormat);
          return self.selectedDates
              .map(function (dObj) { return self.formatDate(dObj, format); })
              .filter(function (d, i, arr) {
              return self.config.mode !== "range" ||
                  self.config.enableTime ||
                  arr.indexOf(d) === i;
          })
              .join(self.config.mode !== "range"
              ? self.config.conjunction
              : self.l10n.rangeSeparator);
      }
      function updateValue(triggerChange) {
          if (triggerChange === void 0) { triggerChange = true; }
          if (self.mobileInput !== undefined && self.mobileFormatStr) {
              self.mobileInput.value =
                  self.latestSelectedDateObj !== undefined
                      ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)
                      : "";
          }
          self.input.value = getDateStr(self.config.dateFormat);
          if (self.altInput !== undefined) {
              self.altInput.value = getDateStr(self.config.altFormat);
          }
          if (triggerChange !== false)
              triggerEvent("onValueUpdate");
      }
      function onMonthNavClick(e) {
          var eventTarget = getEventTarget(e);
          var isPrevMonth = self.prevMonthNav.contains(eventTarget);
          var isNextMonth = self.nextMonthNav.contains(eventTarget);
          if (isPrevMonth || isNextMonth) {
              changeMonth(isPrevMonth ? -1 : 1);
          }
          else if (self.yearElements.indexOf(eventTarget) >= 0) {
              eventTarget.select();
          }
          else if (eventTarget.classList.contains("arrowUp")) {
              self.changeYear(self.currentYear + 1);
          }
          else if (eventTarget.classList.contains("arrowDown")) {
              self.changeYear(self.currentYear - 1);
          }
      }
      function timeWrapper(e) {
          e.preventDefault();
          var isKeyDown = e.type === "keydown", eventTarget = getEventTarget(e), input = eventTarget;
          if (self.amPM !== undefined && eventTarget === self.amPM) {
              self.amPM.textContent =
                  self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
          }
          var min = parseFloat(input.getAttribute("min")), max = parseFloat(input.getAttribute("max")), step = parseFloat(input.getAttribute("step")), curValue = parseInt(input.value, 10), delta = e.delta ||
              (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);
          var newValue = curValue + step * delta;
          if (typeof input.value !== "undefined" && input.value.length === 2) {
              var isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;
              if (newValue < min) {
                  newValue =
                      max +
                          newValue +
                          int(!isHourElem) +
                          (int(isHourElem) && int(!self.amPM));
                  if (isMinuteElem)
                      incrementNumInput(undefined, -1, self.hourElement);
              }
              else if (newValue > max) {
                  newValue =
                      input === self.hourElement ? newValue - max - int(!self.amPM) : min;
                  if (isMinuteElem)
                      incrementNumInput(undefined, 1, self.hourElement);
              }
              if (self.amPM &&
                  isHourElem &&
                  (step === 1
                      ? newValue + curValue === 23
                      : Math.abs(newValue - curValue) > step)) {
                  self.amPM.textContent =
                      self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];
              }
              input.value = pad(newValue);
          }
      }
      init();
      return self;
  }
  function _flatpickr(nodeList, config) {
      var nodes = Array.prototype.slice
          .call(nodeList)
          .filter(function (x) { return x instanceof HTMLElement; });
      var instances = [];
      for (var i = 0; i < nodes.length; i++) {
          var node = nodes[i];
          try {
              if (node.getAttribute("data-fp-omit") !== null)
                  continue;
              if (node._flatpickr !== undefined) {
                  node._flatpickr.destroy();
                  node._flatpickr = undefined;
              }
              node._flatpickr = FlatpickrInstance(node, config || {});
              instances.push(node._flatpickr);
          }
          catch (e) {
              console.error(e);
          }
      }
      return instances.length === 1 ? instances[0] : instances;
  }
  if (typeof HTMLElement !== "undefined" &&
      typeof HTMLCollection !== "undefined" &&
      typeof NodeList !== "undefined") {
      HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {
          return _flatpickr(this, config);
      };
      HTMLElement.prototype.flatpickr = function (config) {
          return _flatpickr([this], config);
      };
  }
  var flatpickr = function (selector, config) {
      if (typeof selector === "string") {
          return _flatpickr(window.document.querySelectorAll(selector), config);
      }
      else if (selector instanceof Node) {
          return _flatpickr([selector], config);
      }
      else {
          return _flatpickr(selector, config);
      }
  };
  flatpickr.defaultConfig = {};
  flatpickr.l10ns = {
      en: __assign({}, english),
      default: __assign({}, english),
  };
  flatpickr.localize = function (l10n) {
      flatpickr.l10ns.default = __assign(__assign({}, flatpickr.l10ns.default), l10n);
  };
  flatpickr.setDefaults = function (config) {
      flatpickr.defaultConfig = __assign(__assign({}, flatpickr.defaultConfig), config);
  };
  flatpickr.parseDate = createDateParser({});
  flatpickr.formatDate = createDateFormatter({});
  flatpickr.compareDates = compareDates;
  if (typeof jQuery !== "undefined" && typeof jQuery.fn !== "undefined") {
      jQuery.fn.flatpickr = function (config) {
          return _flatpickr(this, config);
      };
  }
  Date.prototype.fp_incr = function (days) {
      return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === "string" ? parseInt(days, 10) : days));
  };
  if (typeof window !== "undefined") {
      window.flatpickr = flatpickr;
  }

  function g(n,t){for(var e in t)n[e]=t[e];return n}function C$1(n,t){for(var e in n)if("__source"!==e&&!(e in t))return !0;for(var r in t)if("__source"!==r&&n[r]!==t[r])return !0;return !1}function w(n){this.props=n;}(w.prototype=new b$1).isPureReactComponent=!0,w.prototype.shouldComponentUpdate=function(n,t){return C$1(this.props,n)||C$1(this.state,t)};var R=l$2.__b;l$2.__b=function(n){n.type&&n.type.__f&&n.ref&&(n.props.ref=n.ref,n.ref=null),R&&R(n);};var N="undefined"!=typeof Symbol&&Symbol.for&&Symbol.for("react.forward_ref")||3911;function k(n){function t(t){var e=g({},t);return delete e.ref,n(e,t.ref||null)}return t.$$typeof=N,t.render=t,t.prototype.isReactComponent=t.__f=!0,t.displayName="ForwardRef("+(n.displayName||n.name)+")",t}var T$1=l$2.__e;l$2.__e=function(n,t,e,r){if(n.then)for(var u,o=t;o=o.__;)if((u=o.__c)&&u.__c)return null==t.__e&&(t.__e=e.__e,t.__k=e.__k),u.__c(n,t);T$1(n,t,e,r);};var I=l$2.unmount;function L$1(n,t,e){return n&&(n.__c&&n.__c.__H&&(n.__c.__H.__.forEach(function(n){"function"==typeof n.__c&&n.__c();}),n.__c.__H=null),null!=(n=g({},n)).__c&&(n.__c.__P===e&&(n.__c.__P=t),n.__c=null),n.__k=n.__k&&n.__k.map(function(n){return L$1(n,t,e)})),n}function U(n,t,e){return n&&(n.__v=null,n.__k=n.__k&&n.__k.map(function(n){return U(n,t,e)}),n.__c&&n.__c.__P===t&&(n.__e&&e.insertBefore(n.__e,n.__d),n.__c.__e=!0,n.__c.__P=e)),n}function D(){this.__u=0,this.t=null,this.__b=null;}function F(n){var t=n.__.__c;return t&&t.__a&&t.__a(n)}function V(){this.u=null,this.o=null;}l$2.unmount=function(n){var t=n.__c;t&&t.__R&&t.__R(),t&&!0===n.__h&&(n.type=null),I&&I(n);},(D.prototype=new b$1).__c=function(n,t){var e=t.__c,r=this;null==r.t&&(r.t=[]),r.t.push(e);var u=F(r.__v),o=!1,i=function(){o||(o=!0,e.__R=null,u?u(l):l());};e.__R=i;var l=function(){if(!--r.__u){if(r.state.__a){var n=r.state.__a;r.__v.__k[0]=U(n,n.__c.__P,n.__c.__O);}var t;for(r.setState({__a:r.__b=null});t=r.t.pop();)t.forceUpdate();}},c=!0===t.__h;r.__u++||c||r.setState({__a:r.__b=r.__v.__k[0]}),n.then(i,i);},D.prototype.componentWillUnmount=function(){this.t=[];},D.prototype.render=function(n,e){if(this.__b){if(this.__v.__k){var r=document.createElement("div"),o=this.__v.__k[0].__c;this.__v.__k[0]=L$1(this.__b,r,o.__O=o.__P);}this.__b=null;}var i=e.__a&&y$1(k$2,null,n.fallback);return i&&(i.__h=null),[y$1(k$2,null,e.__a?null:n.children),i]};var W=function(n,t,e){if(++e[1]===e[0]&&n.o.delete(t),n.props.revealOrder&&("t"!==n.props.revealOrder[0]||!n.o.size))for(e=n.u;e;){for(;e.length>3;)e.pop()();if(e[1]<e[0])break;n.u=e=e[2];}};function P$1(n){return this.getChildContext=function(){return n.context},n.children}function j(n){var e=this,r=n.i;e.componentWillUnmount=function(){D$1(null,e.l),e.l=null,e.i=null;},e.i&&e.i!==r&&e.componentWillUnmount(),n.__v?(e.l||(e.i=r,e.l={nodeType:1,parentNode:r,childNodes:[],appendChild:function(n){this.childNodes.push(n),e.i.appendChild(n);},insertBefore:function(n,t){this.childNodes.push(n),e.i.appendChild(n);},removeChild:function(n){this.childNodes.splice(this.childNodes.indexOf(n)>>>1,1),e.i.removeChild(n);}}),D$1(y$1(P$1,{context:e.context},n.__v),e.l)):e.l&&e.componentWillUnmount();}function z$1(n,e){var r=y$1(j,{__v:n,i:e});return r.containerInfo=e,r}(V.prototype=new b$1).__a=function(n){var t=this,e=F(t.__v),r=t.o.get(n);return r[0]++,function(u){var o=function(){t.props.revealOrder?(r.push(u),W(t,n,r)):u();};e?e(o):o();}},V.prototype.render=function(n){this.u=null,this.o=new Map;var t=S(n.children);n.revealOrder&&"b"===n.revealOrder[0]&&t.reverse();for(var e=t.length;e--;)this.o.set(t[e],this.u=[1,0,this.u]);return n.children},V.prototype.componentDidUpdate=V.prototype.componentDidMount=function(){var n=this;this.o.forEach(function(t,e){W(n,e,t);});};var B="undefined"!=typeof Symbol&&Symbol.for&&Symbol.for("react.element")||60103,H=/^(?:accent|alignment|arabic|baseline|cap|clip(?!PathU)|color|dominant|fill|flood|font|glyph(?!R)|horiz|image(!S)|letter|lighting|marker(?!H|W|U)|overline|paint|pointer|shape|stop|strikethrough|stroke|text(?!L)|transform|underline|unicode|units|v|vector|vert|word|writing|x(?!C))[A-Z]/,Z=/^on(Ani|Tra|Tou|BeforeInp|Compo)/,Y$1=/[A-Z0-9]/g,$="undefined"!=typeof document,q=function(n){return ("undefined"!=typeof Symbol&&"symbol"==typeof Symbol()?/fil|che|rad/:/fil|che|ra/).test(n)};b$1.prototype.isReactComponent={},["componentWillMount","componentWillReceiveProps","componentWillUpdate"].forEach(function(t){Object.defineProperty(b$1.prototype,t,{configurable:!0,get:function(){return this["UNSAFE_"+t]},set:function(n){Object.defineProperty(this,t,{configurable:!0,writable:!0,value:n});}});});var K=l$2.event;function Q(){}function X(){return this.cancelBubble}function nn(){return this.defaultPrevented}l$2.event=function(n){return K&&(n=K(n)),n.persist=Q,n.isPropagationStopped=X,n.isDefaultPrevented=nn,n.nativeEvent=n};var en={enumerable:!1,configurable:!0,get:function(){return this.class}},rn=l$2.vnode;l$2.vnode=function(n){"string"==typeof n.type&&function(n){var t=n.props,e=n.type,u={};for(var o in t){var i=t[o];if(!("value"===o&&"defaultValue"in t&&null==i||$&&"children"===o&&"noscript"===e||"class"===o||"className"===o)){var l=o.toLowerCase();"defaultValue"===o&&"value"in t&&null==t.value?o="value":"download"===o&&!0===i?i="":"ondoubleclick"===l?o="ondblclick":"onchange"!==l||"input"!==e&&"textarea"!==e||q(t.type)?"onfocus"===l?o="onfocusin":"onblur"===l?o="onfocusout":Z.test(o)?o=l:-1===e.indexOf("-")&&H.test(o)?o=o.replace(Y$1,"-$&").toLowerCase():null===i&&(i=void 0):l=o="oninput","oninput"===l&&u[o=l]&&(o="oninputCapture"),u[o]=i;}}"select"==e&&u.multiple&&Array.isArray(u.value)&&(u.value=S(t.children).forEach(function(n){n.props.selected=-1!=u.value.indexOf(n.props.value);})),"select"==e&&null!=u.defaultValue&&(u.value=S(t.children).forEach(function(n){n.props.selected=u.multiple?-1!=u.defaultValue.indexOf(n.props.value):u.defaultValue==n.props.value;})),t.class&&!t.className?(u.class=t.class,Object.defineProperty(u,"className",en)):(t.className&&!t.class||t.class&&t.className)&&(u.class=u.className=t.className),n.props=u;}(n),n.$$typeof=B,rn&&rn(n);};var un=l$2.__r;l$2.__r=function(n){un&&un(n),n.__c;};var on=l$2.diffed;l$2.diffed=function(n){on&&on(n);var t=n.props,e=n.__e;null!=e&&"textarea"===n.type&&"value"in t&&t.value!==e.value&&(e.value=null==t.value?"":t.value);};

  /*! @license DOMPurify 3.1.6 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.1.6/LICENSE */

  const {
    entries,
    setPrototypeOf,
    isFrozen,
    getPrototypeOf,
    getOwnPropertyDescriptor
  } = Object;
  let {
    freeze,
    seal,
    create
  } = Object; // eslint-disable-line import/no-mutable-exports
  let {
    apply,
    construct
  } = typeof Reflect !== 'undefined' && Reflect;
  if (!freeze) {
    freeze = function freeze(x) {
      return x;
    };
  }
  if (!seal) {
    seal = function seal(x) {
      return x;
    };
  }
  if (!apply) {
    apply = function apply(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }
  if (!construct) {
    construct = function construct(Func, args) {
      return new Func(...args);
    };
  }
  const arrayForEach = unapply(Array.prototype.forEach);
  const arrayPop = unapply(Array.prototype.pop);
  const arrayPush = unapply(Array.prototype.push);
  const stringToLowerCase = unapply(String.prototype.toLowerCase);
  const stringToString = unapply(String.prototype.toString);
  const stringMatch = unapply(String.prototype.match);
  const stringReplace = unapply(String.prototype.replace);
  const stringIndexOf = unapply(String.prototype.indexOf);
  const stringTrim = unapply(String.prototype.trim);
  const objectHasOwnProperty = unapply(Object.prototype.hasOwnProperty);
  const regExpTest = unapply(RegExp.prototype.test);
  const typeErrorCreate = unconstruct(TypeError);

  /**
   * Creates a new function that calls the given function with a specified thisArg and arguments.
   *
   * @param {Function} func - The function to be wrapped and called.
   * @returns {Function} A new function that calls the given function with a specified thisArg and arguments.
   */
  function unapply(func) {
    return function (thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return apply(func, thisArg, args);
    };
  }

  /**
   * Creates a new function that constructs an instance of the given constructor function with the provided arguments.
   *
   * @param {Function} func - The constructor function to be wrapped and called.
   * @returns {Function} A new function that constructs an instance of the given constructor function with the provided arguments.
   */
  function unconstruct(func) {
    return function () {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return construct(func, args);
    };
  }

  /**
   * Add properties to a lookup table
   *
   * @param {Object} set - The set to which elements will be added.
   * @param {Array} array - The array containing elements to be added to the set.
   * @param {Function} transformCaseFunc - An optional function to transform the case of each element before adding to the set.
   * @returns {Object} The modified set with added elements.
   */
  function addToSet(set, array) {
    let transformCaseFunc = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : stringToLowerCase;
    if (setPrototypeOf) {
      // Make 'in' and truthy checks like Boolean(set.constructor)
      // independent of any properties defined on Object.prototype.
      // Prevent prototype setters from intercepting set as a this value.
      setPrototypeOf(set, null);
    }
    let l = array.length;
    while (l--) {
      let element = array[l];
      if (typeof element === 'string') {
        const lcElement = transformCaseFunc(element);
        if (lcElement !== element) {
          // Config presets (e.g. tags.js, attrs.js) are immutable.
          if (!isFrozen(array)) {
            array[l] = lcElement;
          }
          element = lcElement;
        }
      }
      set[element] = true;
    }
    return set;
  }

  /**
   * Clean up an array to harden against CSPP
   *
   * @param {Array} array - The array to be cleaned.
   * @returns {Array} The cleaned version of the array
   */
  function cleanArray(array) {
    for (let index = 0; index < array.length; index++) {
      const isPropertyExist = objectHasOwnProperty(array, index);
      if (!isPropertyExist) {
        array[index] = null;
      }
    }
    return array;
  }

  /**
   * Shallow clone an object
   *
   * @param {Object} object - The object to be cloned.
   * @returns {Object} A new object that copies the original.
   */
  function clone$1(object) {
    const newObject = create(null);
    for (const [property, value] of entries(object)) {
      const isPropertyExist = objectHasOwnProperty(object, property);
      if (isPropertyExist) {
        if (Array.isArray(value)) {
          newObject[property] = cleanArray(value);
        } else if (value && typeof value === 'object' && value.constructor === Object) {
          newObject[property] = clone$1(value);
        } else {
          newObject[property] = value;
        }
      }
    }
    return newObject;
  }

  /**
   * This method automatically checks if the prop is function or getter and behaves accordingly.
   *
   * @param {Object} object - The object to look up the getter function in its prototype chain.
   * @param {String} prop - The property name for which to find the getter function.
   * @returns {Function} The getter function found in the prototype chain or a fallback function.
   */
  function lookupGetter(object, prop) {
    while (object !== null) {
      const desc = getOwnPropertyDescriptor(object, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }
        if (typeof desc.value === 'function') {
          return unapply(desc.value);
        }
      }
      object = getPrototypeOf(object);
    }
    function fallbackValue() {
      return null;
    }
    return fallbackValue;
  }

  const html$1 = freeze(['a', 'abbr', 'acronym', 'address', 'area', 'article', 'aside', 'audio', 'b', 'bdi', 'bdo', 'big', 'blink', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'center', 'cite', 'code', 'col', 'colgroup', 'content', 'data', 'datalist', 'dd', 'decorator', 'del', 'details', 'dfn', 'dialog', 'dir', 'div', 'dl', 'dt', 'element', 'em', 'fieldset', 'figcaption', 'figure', 'font', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'img', 'input', 'ins', 'kbd', 'label', 'legend', 'li', 'main', 'map', 'mark', 'marquee', 'menu', 'menuitem', 'meter', 'nav', 'nobr', 'ol', 'optgroup', 'option', 'output', 'p', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'section', 'select', 'shadow', 'small', 'source', 'spacer', 'span', 'strike', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'template', 'textarea', 'tfoot', 'th', 'thead', 'time', 'tr', 'track', 'tt', 'u', 'ul', 'var', 'video', 'wbr']);

  // SVG
  const svg$1 = freeze(['svg', 'a', 'altglyph', 'altglyphdef', 'altglyphitem', 'animatecolor', 'animatemotion', 'animatetransform', 'circle', 'clippath', 'defs', 'desc', 'ellipse', 'filter', 'font', 'g', 'glyph', 'glyphref', 'hkern', 'image', 'line', 'lineargradient', 'marker', 'mask', 'metadata', 'mpath', 'path', 'pattern', 'polygon', 'polyline', 'radialgradient', 'rect', 'stop', 'style', 'switch', 'symbol', 'text', 'textpath', 'title', 'tref', 'tspan', 'view', 'vkern']);
  const svgFilters = freeze(['feBlend', 'feColorMatrix', 'feComponentTransfer', 'feComposite', 'feConvolveMatrix', 'feDiffuseLighting', 'feDisplacementMap', 'feDistantLight', 'feDropShadow', 'feFlood', 'feFuncA', 'feFuncB', 'feFuncG', 'feFuncR', 'feGaussianBlur', 'feImage', 'feMerge', 'feMergeNode', 'feMorphology', 'feOffset', 'fePointLight', 'feSpecularLighting', 'feSpotLight', 'feTile', 'feTurbulence']);

  // List of SVG elements that are disallowed by default.
  // We still need to know them so that we can do namespace
  // checks properly in case one wants to add them to
  // allow-list.
  const svgDisallowed = freeze(['animate', 'color-profile', 'cursor', 'discard', 'font-face', 'font-face-format', 'font-face-name', 'font-face-src', 'font-face-uri', 'foreignobject', 'hatch', 'hatchpath', 'mesh', 'meshgradient', 'meshpatch', 'meshrow', 'missing-glyph', 'script', 'set', 'solidcolor', 'unknown', 'use']);
  const mathMl$1 = freeze(['math', 'menclose', 'merror', 'mfenced', 'mfrac', 'mglyph', 'mi', 'mlabeledtr', 'mmultiscripts', 'mn', 'mo', 'mover', 'mpadded', 'mphantom', 'mroot', 'mrow', 'ms', 'mspace', 'msqrt', 'mstyle', 'msub', 'msup', 'msubsup', 'mtable', 'mtd', 'mtext', 'mtr', 'munder', 'munderover', 'mprescripts']);

  // Similarly to SVG, we want to know all MathML elements,
  // even those that we disallow by default.
  const mathMlDisallowed = freeze(['maction', 'maligngroup', 'malignmark', 'mlongdiv', 'mscarries', 'mscarry', 'msgroup', 'mstack', 'msline', 'msrow', 'semantics', 'annotation', 'annotation-xml', 'mprescripts', 'none']);
  const text = freeze(['#text']);

  const html$2 = freeze(['accept', 'action', 'align', 'alt', 'autocapitalize', 'autocomplete', 'autopictureinpicture', 'autoplay', 'background', 'bgcolor', 'border', 'capture', 'cellpadding', 'cellspacing', 'checked', 'cite', 'class', 'clear', 'color', 'cols', 'colspan', 'controls', 'controlslist', 'coords', 'crossorigin', 'datetime', 'decoding', 'default', 'dir', 'disabled', 'disablepictureinpicture', 'disableremoteplayback', 'download', 'draggable', 'enctype', 'enterkeyhint', 'face', 'for', 'headers', 'height', 'hidden', 'high', 'href', 'hreflang', 'id', 'inputmode', 'integrity', 'ismap', 'kind', 'label', 'lang', 'list', 'loading', 'loop', 'low', 'max', 'maxlength', 'media', 'method', 'min', 'minlength', 'multiple', 'muted', 'name', 'nonce', 'noshade', 'novalidate', 'nowrap', 'open', 'optimum', 'pattern', 'placeholder', 'playsinline', 'popover', 'popovertarget', 'popovertargetaction', 'poster', 'preload', 'pubdate', 'radiogroup', 'readonly', 'rel', 'required', 'rev', 'reversed', 'role', 'rows', 'rowspan', 'spellcheck', 'scope', 'selected', 'shape', 'size', 'sizes', 'span', 'srclang', 'start', 'src', 'srcset', 'step', 'style', 'summary', 'tabindex', 'title', 'translate', 'type', 'usemap', 'valign', 'value', 'width', 'wrap', 'xmlns', 'slot']);
  const svg$2 = freeze(['accent-height', 'accumulate', 'additive', 'alignment-baseline', 'ascent', 'attributename', 'attributetype', 'azimuth', 'basefrequency', 'baseline-shift', 'begin', 'bias', 'by', 'class', 'clip', 'clippathunits', 'clip-path', 'clip-rule', 'color', 'color-interpolation', 'color-interpolation-filters', 'color-profile', 'color-rendering', 'cx', 'cy', 'd', 'dx', 'dy', 'diffuseconstant', 'direction', 'display', 'divisor', 'dur', 'edgemode', 'elevation', 'end', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'filterunits', 'flood-color', 'flood-opacity', 'font-family', 'font-size', 'font-size-adjust', 'font-stretch', 'font-style', 'font-variant', 'font-weight', 'fx', 'fy', 'g1', 'g2', 'glyph-name', 'glyphref', 'gradientunits', 'gradienttransform', 'height', 'href', 'id', 'image-rendering', 'in', 'in2', 'k', 'k1', 'k2', 'k3', 'k4', 'kerning', 'keypoints', 'keysplines', 'keytimes', 'lang', 'lengthadjust', 'letter-spacing', 'kernelmatrix', 'kernelunitlength', 'lighting-color', 'local', 'marker-end', 'marker-mid', 'marker-start', 'markerheight', 'markerunits', 'markerwidth', 'maskcontentunits', 'maskunits', 'max', 'mask', 'media', 'method', 'mode', 'min', 'name', 'numoctaves', 'offset', 'operator', 'opacity', 'order', 'orient', 'orientation', 'origin', 'overflow', 'paint-order', 'path', 'pathlength', 'patterncontentunits', 'patterntransform', 'patternunits', 'points', 'preservealpha', 'preserveaspectratio', 'primitiveunits', 'r', 'rx', 'ry', 'radius', 'refx', 'refy', 'repeatcount', 'repeatdur', 'restart', 'result', 'rotate', 'scale', 'seed', 'shape-rendering', 'specularconstant', 'specularexponent', 'spreadmethod', 'startoffset', 'stddeviation', 'stitchtiles', 'stop-color', 'stop-opacity', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke', 'stroke-width', 'style', 'surfacescale', 'systemlanguage', 'tabindex', 'targetx', 'targety', 'transform', 'transform-origin', 'text-anchor', 'text-decoration', 'text-rendering', 'textlength', 'type', 'u1', 'u2', 'unicode', 'values', 'viewbox', 'visibility', 'version', 'vert-adv-y', 'vert-origin-x', 'vert-origin-y', 'width', 'word-spacing', 'wrap', 'writing-mode', 'xchannelselector', 'ychannelselector', 'x', 'x1', 'x2', 'xmlns', 'y', 'y1', 'y2', 'z', 'zoomandpan']);
  const mathMl = freeze(['accent', 'accentunder', 'align', 'bevelled', 'close', 'columnsalign', 'columnlines', 'columnspan', 'denomalign', 'depth', 'dir', 'display', 'displaystyle', 'encoding', 'fence', 'frame', 'height', 'href', 'id', 'largeop', 'length', 'linethickness', 'lspace', 'lquote', 'mathbackground', 'mathcolor', 'mathsize', 'mathvariant', 'maxsize', 'minsize', 'movablelimits', 'notation', 'numalign', 'open', 'rowalign', 'rowlines', 'rowspacing', 'rowspan', 'rspace', 'rquote', 'scriptlevel', 'scriptminsize', 'scriptsizemultiplier', 'selection', 'separator', 'separators', 'stretchy', 'subscriptshift', 'supscriptshift', 'symmetric', 'voffset', 'width', 'xmlns']);
  const xml = freeze(['xlink:href', 'xml:id', 'xlink:title', 'xml:space', 'xmlns:xlink']);

  // eslint-disable-next-line unicorn/better-regex
  const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm); // Specify template detection regex for SAFE_FOR_TEMPLATES mode
  const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  const TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
  const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/); // eslint-disable-line no-useless-escape
  const ARIA_ATTR = seal(/^aria-[\-\w]+$/); // eslint-disable-line no-useless-escape
  const IS_ALLOWED_URI = seal(/^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i // eslint-disable-line no-useless-escape
  );
  const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  const ATTR_WHITESPACE = seal(/[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g // eslint-disable-line no-control-regex
  );
  const DOCTYPE_NAME = seal(/^html$/i);
  const CUSTOM_ELEMENT = seal(/^[a-z][.\w]*(-[.\w]+)+$/i);

  var EXPRESSIONS = /*#__PURE__*/Object.freeze({
    __proto__: null,
    MUSTACHE_EXPR: MUSTACHE_EXPR,
    ERB_EXPR: ERB_EXPR,
    TMPLIT_EXPR: TMPLIT_EXPR,
    DATA_ATTR: DATA_ATTR,
    ARIA_ATTR: ARIA_ATTR,
    IS_ALLOWED_URI: IS_ALLOWED_URI,
    IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA,
    ATTR_WHITESPACE: ATTR_WHITESPACE,
    DOCTYPE_NAME: DOCTYPE_NAME,
    CUSTOM_ELEMENT: CUSTOM_ELEMENT
  });

  // https://developer.mozilla.org/en-US/docs/Web/API/Node/nodeType
  const NODE_TYPE = {
    element: 1,
    attribute: 2,
    text: 3,
    cdataSection: 4,
    entityReference: 5,
    // Deprecated
    entityNode: 6,
    // Deprecated
    progressingInstruction: 7,
    comment: 8,
    document: 9,
    documentType: 10,
    documentFragment: 11,
    notation: 12 // Deprecated
  };
  const getGlobal = function getGlobal() {
    return typeof window === 'undefined' ? null : window;
  };

  /**
   * Creates a no-op policy for internal use only.
   * Don't export this function outside this module!
   * @param {TrustedTypePolicyFactory} trustedTypes The policy factory.
   * @param {HTMLScriptElement} purifyHostElement The Script element used to load DOMPurify (to determine policy name suffix).
   * @return {TrustedTypePolicy} The policy created (or null, if Trusted Types
   * are not supported or creating the policy failed).
   */
  const _createTrustedTypesPolicy = function _createTrustedTypesPolicy(trustedTypes, purifyHostElement) {
    if (typeof trustedTypes !== 'object' || typeof trustedTypes.createPolicy !== 'function') {
      return null;
    }

    // Allow the callers to control the unique policy name
    // by adding a data-tt-policy-suffix to the script element with the DOMPurify.
    // Policy creation with duplicate names throws in Trusted Types.
    let suffix = null;
    const ATTR_NAME = 'data-tt-policy-suffix';
    if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
      suffix = purifyHostElement.getAttribute(ATTR_NAME);
    }
    const policyName = 'dompurify' + (suffix ? '#' + suffix : '');
    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML(html) {
          return html;
        },
        createScriptURL(scriptUrl) {
          return scriptUrl;
        }
      });
    } catch (_) {
      // Policy creation failed (most likely another DOMPurify script has
      // already run). Skip creating the policy, as this will only cause errors
      // if TT are enforced.
      console.warn('TrustedTypes policy ' + policyName + ' could not be created.');
      return null;
    }
  };
  function createDOMPurify() {
    let window = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : getGlobal();
    const DOMPurify = root => createDOMPurify(root);

    /**
     * Version label, exposed for easier checks
     * if DOMPurify is up to date or not
     */
    DOMPurify.version = '3.1.6';

    /**
     * Array of elements that DOMPurify removed during sanitation.
     * Empty if nothing was removed.
     */
    DOMPurify.removed = [];
    if (!window || !window.document || window.document.nodeType !== NODE_TYPE.document) {
      // Not running in a browser, provide a factory function
      // so that you can pass your own Window
      DOMPurify.isSupported = false;
      return DOMPurify;
    }
    let {
      document
    } = window;
    const originalDocument = document;
    const currentScript = originalDocument.currentScript;
    const {
      DocumentFragment,
      HTMLTemplateElement,
      Node,
      Element,
      NodeFilter,
      NamedNodeMap = window.NamedNodeMap || window.MozNamedAttrMap,
      HTMLFormElement,
      DOMParser,
      trustedTypes
    } = window;
    const ElementPrototype = Element.prototype;
    const cloneNode = lookupGetter(ElementPrototype, 'cloneNode');
    const remove = lookupGetter(ElementPrototype, 'remove');
    const getNextSibling = lookupGetter(ElementPrototype, 'nextSibling');
    const getChildNodes = lookupGetter(ElementPrototype, 'childNodes');
    const getParentNode = lookupGetter(ElementPrototype, 'parentNode');

    // As per issue #47, the web-components registry is inherited by a
    // new document created via createHTMLDocument. As per the spec
    // (http://w3c.github.io/webcomponents/spec/custom/#creating-and-passing-registries)
    // a new empty registry is used when creating a template contents owner
    // document, so we use that as our parent document to ensure nothing
    // is inherited.
    if (typeof HTMLTemplateElement === 'function') {
      const template = document.createElement('template');
      if (template.content && template.content.ownerDocument) {
        document = template.content.ownerDocument;
      }
    }
    let trustedTypesPolicy;
    let emptyHTML = '';
    const {
      implementation,
      createNodeIterator,
      createDocumentFragment,
      getElementsByTagName
    } = document;
    const {
      importNode
    } = originalDocument;
    let hooks = {};

    /**
     * Expose whether this browser supports running the full DOMPurify.
     */
    DOMPurify.isSupported = typeof entries === 'function' && typeof getParentNode === 'function' && implementation && implementation.createHTMLDocument !== undefined;
    const {
      MUSTACHE_EXPR,
      ERB_EXPR,
      TMPLIT_EXPR,
      DATA_ATTR,
      ARIA_ATTR,
      IS_SCRIPT_OR_DATA,
      ATTR_WHITESPACE,
      CUSTOM_ELEMENT
    } = EXPRESSIONS;
    let {
      IS_ALLOWED_URI: IS_ALLOWED_URI$1
    } = EXPRESSIONS;

    /**
     * We consider the elements and attributes below to be safe. Ideally
     * don't add any new ones but feel free to remove unwanted ones.
     */

    /* allowed element names */
    let ALLOWED_TAGS = null;
    const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text]);

    /* Allowed attribute names */
    let ALLOWED_ATTR = null;
    const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html$2, ...svg$2, ...mathMl, ...xml]);

    /*
     * Configure how DOMPUrify should handle custom elements and their attributes as well as customized built-in elements.
     * @property {RegExp|Function|null} tagNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any custom elements)
     * @property {RegExp|Function|null} attributeNameCheck one of [null, regexPattern, predicate]. Default: `null` (disallow any attributes not on the allow list)
     * @property {boolean} allowCustomizedBuiltInElements allow custom elements derived from built-ins if they pass CUSTOM_ELEMENT_HANDLING.tagNameCheck. Default: `false`.
     */
    let CUSTOM_ELEMENT_HANDLING = Object.seal(create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));

    /* Explicitly forbidden tags (overrides ALLOWED_TAGS/ADD_TAGS) */
    let FORBID_TAGS = null;

    /* Explicitly forbidden attributes (overrides ALLOWED_ATTR/ADD_ATTR) */
    let FORBID_ATTR = null;

    /* Decide if ARIA attributes are okay */
    let ALLOW_ARIA_ATTR = true;

    /* Decide if custom data attributes are okay */
    let ALLOW_DATA_ATTR = true;

    /* Decide if unknown protocols are okay */
    let ALLOW_UNKNOWN_PROTOCOLS = false;

    /* Decide if self-closing tags in attributes are allowed.
     * Usually removed due to a mXSS issue in jQuery 3.0 */
    let ALLOW_SELF_CLOSE_IN_ATTR = true;

    /* Output should be safe for common template engines.
     * This means, DOMPurify removes data attributes, mustaches and ERB
     */
    let SAFE_FOR_TEMPLATES = false;

    /* Output should be safe even for XML used within HTML and alike.
     * This means, DOMPurify removes comments when containing risky content.
     */
    let SAFE_FOR_XML = true;

    /* Decide if document with <html>... should be returned */
    let WHOLE_DOCUMENT = false;

    /* Track whether config is already set on this instance of DOMPurify. */
    let SET_CONFIG = false;

    /* Decide if all elements (e.g. style, script) must be children of
     * document.body. By default, browsers might move them to document.head */
    let FORCE_BODY = false;

    /* Decide if a DOM `HTMLBodyElement` should be returned, instead of a html
     * string (or a TrustedHTML object if Trusted Types are supported).
     * If `WHOLE_DOCUMENT` is enabled a `HTMLHtmlElement` will be returned instead
     */
    let RETURN_DOM = false;

    /* Decide if a DOM `DocumentFragment` should be returned, instead of a html
     * string  (or a TrustedHTML object if Trusted Types are supported) */
    let RETURN_DOM_FRAGMENT = false;

    /* Try to return a Trusted Type object instead of a string, return a string in
     * case Trusted Types are not supported  */
    let RETURN_TRUSTED_TYPE = false;

    /* Output should be free from DOM clobbering attacks?
     * This sanitizes markups named with colliding, clobberable built-in DOM APIs.
     */
    let SANITIZE_DOM = true;

    /* Achieve full DOM Clobbering protection by isolating the namespace of named
     * properties and JS variables, mitigating attacks that abuse the HTML/DOM spec rules.
     *
     * HTML/DOM spec rules that enable DOM Clobbering:
     *   - Named Access on Window (§7.3.3)
     *   - DOM Tree Accessors (§3.1.5)
     *   - Form Element Parent-Child Relations (§4.10.3)
     *   - Iframe srcdoc / Nested WindowProxies (§4.8.5)
     *   - HTMLCollection (§4.2.10.2)
     *
     * Namespace isolation is implemented by prefixing `id` and `name` attributes
     * with a constant string, i.e., `user-content-`
     */
    let SANITIZE_NAMED_PROPS = false;
    const SANITIZE_NAMED_PROPS_PREFIX = 'user-content-';

    /* Keep element content when removing element? */
    let KEEP_CONTENT = true;

    /* If a `Node` is passed to sanitize(), then performs sanitization in-place instead
     * of importing it into a new Document and returning a sanitized copy */
    let IN_PLACE = false;

    /* Allow usage of profiles like html, svg and mathMl */
    let USE_PROFILES = {};

    /* Tags to ignore content of when KEEP_CONTENT is true */
    let FORBID_CONTENTS = null;
    const DEFAULT_FORBID_CONTENTS = addToSet({}, ['annotation-xml', 'audio', 'colgroup', 'desc', 'foreignobject', 'head', 'iframe', 'math', 'mi', 'mn', 'mo', 'ms', 'mtext', 'noembed', 'noframes', 'noscript', 'plaintext', 'script', 'style', 'svg', 'template', 'thead', 'title', 'video', 'xmp']);

    /* Tags that are safe for data: URIs */
    let DATA_URI_TAGS = null;
    const DEFAULT_DATA_URI_TAGS = addToSet({}, ['audio', 'video', 'img', 'source', 'image', 'track']);

    /* Attributes safe for values like "javascript:" */
    let URI_SAFE_ATTRIBUTES = null;
    const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ['alt', 'class', 'for', 'id', 'label', 'name', 'pattern', 'placeholder', 'role', 'summary', 'title', 'value', 'style', 'xmlns']);
    const MATHML_NAMESPACE = 'http://www.w3.org/1998/Math/MathML';
    const SVG_NAMESPACE = 'http://www.w3.org/2000/svg';
    const HTML_NAMESPACE = 'http://www.w3.org/1999/xhtml';
    /* Document namespace */
    let NAMESPACE = HTML_NAMESPACE;
    let IS_EMPTY_INPUT = false;

    /* Allowed XHTML+XML namespaces */
    let ALLOWED_NAMESPACES = null;
    const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);

    /* Parsing of strict XHTML documents */
    let PARSER_MEDIA_TYPE = null;
    const SUPPORTED_PARSER_MEDIA_TYPES = ['application/xhtml+xml', 'text/html'];
    const DEFAULT_PARSER_MEDIA_TYPE = 'text/html';
    let transformCaseFunc = null;

    /* Keep a reference to config to pass to hooks */
    let CONFIG = null;

    /* Ideally, do not touch anything below this line */
    /* ______________________________________________ */

    const formElement = document.createElement('form');
    const isRegexOrFunction = function isRegexOrFunction(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };

    /**
     * _parseConfig
     *
     * @param  {Object} cfg optional config literal
     */
    // eslint-disable-next-line complexity
    const _parseConfig = function _parseConfig() {
      let cfg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (CONFIG && CONFIG === cfg) {
        return;
      }

      /* Shield configuration object from tampering */
      if (!cfg || typeof cfg !== 'object') {
        cfg = {};
      }

      /* Shield configuration object from prototype pollution */
      cfg = clone$1(cfg);
      PARSER_MEDIA_TYPE =
      // eslint-disable-next-line unicorn/prefer-includes
      SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? DEFAULT_PARSER_MEDIA_TYPE : cfg.PARSER_MEDIA_TYPE;

      // HTML tags and attributes are not case-sensitive, converting to lowercase. Keeping XHTML as is.
      transformCaseFunc = PARSER_MEDIA_TYPE === 'application/xhtml+xml' ? stringToString : stringToLowerCase;

      /* Set configuration parameters */
      ALLOWED_TAGS = objectHasOwnProperty(cfg, 'ALLOWED_TAGS') ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = objectHasOwnProperty(cfg, 'ALLOWED_ATTR') ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      ALLOWED_NAMESPACES = objectHasOwnProperty(cfg, 'ALLOWED_NAMESPACES') ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
      URI_SAFE_ATTRIBUTES = objectHasOwnProperty(cfg, 'ADD_URI_SAFE_ATTR') ? addToSet(clone$1(DEFAULT_URI_SAFE_ATTRIBUTES),
      // eslint-disable-line indent
      cfg.ADD_URI_SAFE_ATTR,
      // eslint-disable-line indent
      transformCaseFunc // eslint-disable-line indent
      ) // eslint-disable-line indent
      : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = objectHasOwnProperty(cfg, 'ADD_DATA_URI_TAGS') ? addToSet(clone$1(DEFAULT_DATA_URI_TAGS),
      // eslint-disable-line indent
      cfg.ADD_DATA_URI_TAGS,
      // eslint-disable-line indent
      transformCaseFunc // eslint-disable-line indent
      ) // eslint-disable-line indent
      : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = objectHasOwnProperty(cfg, 'FORBID_CONTENTS') ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = objectHasOwnProperty(cfg, 'FORBID_TAGS') ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = objectHasOwnProperty(cfg, 'FORBID_ATTR') ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = objectHasOwnProperty(cfg, 'USE_PROFILES') ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false; // Default true
      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false; // Default true
      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false; // Default false
      ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false; // Default true
      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false; // Default false
      SAFE_FOR_XML = cfg.SAFE_FOR_XML !== false; // Default true
      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false; // Default false
      RETURN_DOM = cfg.RETURN_DOM || false; // Default false
      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false; // Default false
      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false; // Default false
      FORCE_BODY = cfg.FORCE_BODY || false; // Default false
      SANITIZE_DOM = cfg.SANITIZE_DOM !== false; // Default true
      SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false; // Default false
      KEEP_CONTENT = cfg.KEEP_CONTENT !== false; // Default true
      IN_PLACE = cfg.IN_PLACE || false; // Default false
      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
      CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === 'boolean') {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }
      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }
      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }

      /* Parse profile info */
      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, text);
        ALLOWED_ATTR = [];
        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html$2);
        }
        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg$2);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg$2);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }

      /* Merge configuration parameters */
      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone$1(ALLOWED_TAGS);
        }
        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }
      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone$1(ALLOWED_ATTR);
        }
        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }
      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }
      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone$1(FORBID_CONTENTS);
        }
        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }

      /* Add #text in case KEEP_CONTENT is set to true */
      if (KEEP_CONTENT) {
        ALLOWED_TAGS['#text'] = true;
      }

      /* Add html, head and body to ALLOWED_TAGS in case WHOLE_DOCUMENT is true */
      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ['html', 'head', 'body']);
      }

      /* Add tbody to ALLOWED_TAGS in case tables are permitted, see #286, #365 */
      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ['tbody']);
        delete FORBID_TAGS.tbody;
      }
      if (cfg.TRUSTED_TYPES_POLICY) {
        if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== 'function') {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
        }
        if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== 'function') {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
        }

        // Overwrite existing TrustedTypes policy.
        trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;

        // Sign local variables required by `sanitize`.
        emptyHTML = trustedTypesPolicy.createHTML('');
      } else {
        // Uninitialized policy, attempt to initialize the internal dompurify policy.
        if (trustedTypesPolicy === undefined) {
          trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
        }

        // If creating the internal policy succeeded sign internal variables.
        if (trustedTypesPolicy !== null && typeof emptyHTML === 'string') {
          emptyHTML = trustedTypesPolicy.createHTML('');
        }
      }

      // Prevent further manipulation of configuration.
      // Not available in IE8, Safari 5, etc.
      if (freeze) {
        freeze(cfg);
      }
      CONFIG = cfg;
    };
    const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ['mi', 'mo', 'mn', 'ms', 'mtext']);
    const HTML_INTEGRATION_POINTS = addToSet({}, ['foreignobject', 'annotation-xml']);

    // Certain elements are allowed in both SVG and HTML
    // namespace. We need to specify them explicitly
    // so that they don't get erroneously deleted from
    // HTML namespace.
    const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ['title', 'style', 'font', 'a', 'script']);

    /* Keep track of all possible SVG and MathML tags
     * so that we can perform the namespace checks
     * correctly. */
    const ALL_SVG_TAGS = addToSet({}, [...svg$1, ...svgFilters, ...svgDisallowed]);
    const ALL_MATHML_TAGS = addToSet({}, [...mathMl$1, ...mathMlDisallowed]);

    /**
     * @param  {Element} element a DOM element whose namespace is being checked
     * @returns {boolean} Return false if the element has a
     *  namespace that a spec-compliant parser would never
     *  return. Return true otherwise.
     */
    const _checkValidNamespace = function _checkValidNamespace(element) {
      let parent = getParentNode(element);

      // In JSDOM, if we're inside shadow DOM, then parentNode
      // can be null. We just simulate parent in this case.
      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: NAMESPACE,
          tagName: 'template'
        };
      }
      const tagName = stringToLowerCase(element.tagName);
      const parentTagName = stringToLowerCase(parent.tagName);
      if (!ALLOWED_NAMESPACES[element.namespaceURI]) {
        return false;
      }
      if (element.namespaceURI === SVG_NAMESPACE) {
        // The only way to switch from HTML namespace to SVG
        // is via <svg>. If it happens via any other tag, then
        // it should be killed.
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === 'svg';
        }

        // The only way to switch from MathML to SVG is via`
        // svg if parent is either <annotation-xml> or MathML
        // text integration points.
        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === 'svg' && (parentTagName === 'annotation-xml' || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        }

        // We only allow elements that are defined in SVG
        // spec. All others are disallowed in SVG namespace.
        return Boolean(ALL_SVG_TAGS[tagName]);
      }
      if (element.namespaceURI === MATHML_NAMESPACE) {
        // The only way to switch from HTML namespace to MathML
        // is via <math>. If it happens via any other tag, then
        // it should be killed.
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === 'math';
        }

        // The only way to switch from SVG to MathML is via
        // <math> and HTML integration points
        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === 'math' && HTML_INTEGRATION_POINTS[parentTagName];
        }

        // We only allow elements that are defined in MathML
        // spec. All others are disallowed in MathML namespace.
        return Boolean(ALL_MATHML_TAGS[tagName]);
      }
      if (element.namespaceURI === HTML_NAMESPACE) {
        // The only way to switch from SVG to HTML is via
        // HTML integration points, and from MathML to HTML
        // is via MathML text integration points
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }

        // We disallow tags that are specific for MathML
        // or SVG and should never appear in HTML namespace
        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      }

      // For XHTML and XML documents that support custom namespaces
      if (PARSER_MEDIA_TYPE === 'application/xhtml+xml' && ALLOWED_NAMESPACES[element.namespaceURI]) {
        return true;
      }

      // The code should never reach this place (this means
      // that the element somehow got namespace that is not
      // HTML, SVG, MathML or allowed via ALLOWED_NAMESPACES).
      // Return false just in case.
      return false;
    };

    /**
     * _forceRemove
     *
     * @param  {Node} node a DOM node
     */
    const _forceRemove = function _forceRemove(node) {
      arrayPush(DOMPurify.removed, {
        element: node
      });
      try {
        // eslint-disable-next-line unicorn/prefer-dom-node-remove
        getParentNode(node).removeChild(node);
      } catch (_) {
        remove(node);
      }
    };

    /**
     * _removeAttribute
     *
     * @param  {String} name an Attribute name
     * @param  {Node} node a DOM node
     */
    const _removeAttribute = function _removeAttribute(name, node) {
      try {
        arrayPush(DOMPurify.removed, {
          attribute: node.getAttributeNode(name),
          from: node
        });
      } catch (_) {
        arrayPush(DOMPurify.removed, {
          attribute: null,
          from: node
        });
      }
      node.removeAttribute(name);

      // We void attribute values for unremovable "is"" attributes
      if (name === 'is' && !ALLOWED_ATTR[name]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node);
          } catch (_) {}
        } else {
          try {
            node.setAttribute(name, '');
          } catch (_) {}
        }
      }
    };

    /**
     * _initDocument
     *
     * @param  {String} dirty a string of dirty markup
     * @return {Document} a DOM, filled with the dirty markup
     */
    const _initDocument = function _initDocument(dirty) {
      /* Create a HTML document */
      let doc = null;
      let leadingWhitespace = null;
      if (FORCE_BODY) {
        dirty = '<remove></remove>' + dirty;
      } else {
        /* If FORCE_BODY isn't used, leading whitespace needs to be preserved manually */
        const matches = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches && matches[0];
      }
      if (PARSER_MEDIA_TYPE === 'application/xhtml+xml' && NAMESPACE === HTML_NAMESPACE) {
        // Root of XHTML doc must contain xmlns declaration (see https://www.w3.org/TR/xhtml1/normative.html#strict)
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + '</body></html>';
      }
      const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      /*
       * Use the DOMParser API by default, fallback later if needs be
       * DOMParser not work for svg when has multiple root element.
       */
      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_) {}
      }

      /* Use createHTMLDocument in case DOMParser is not available */
      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, 'template', null);
        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
        } catch (_) {
          // Syntax error if dirtyPayload is invalid xml
        }
      }
      const body = doc.body || doc.documentElement;
      if (dirty && leadingWhitespace) {
        body.insertBefore(document.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }

      /* Work on whole document or just its body */
      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? 'html' : 'body')[0];
      }
      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };

    /**
     * Creates a NodeIterator object that you can use to traverse filtered lists of nodes or elements in a document.
     *
     * @param  {Node} root The root element or node to start traversing on.
     * @return {NodeIterator} The created NodeIterator
     */
    const _createNodeIterator = function _createNodeIterator(root) {
      return createNodeIterator.call(root.ownerDocument || root, root,
      // eslint-disable-next-line no-bitwise
      NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT | NodeFilter.SHOW_PROCESSING_INSTRUCTION | NodeFilter.SHOW_CDATA_SECTION, null);
    };

    /**
     * _isClobbered
     *
     * @param  {Node} elm element to check for clobbering attacks
     * @return {Boolean} true if clobbered, false if safe
     */
    const _isClobbered = function _isClobbered(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== 'string' || typeof elm.textContent !== 'string' || typeof elm.removeChild !== 'function' || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== 'function' || typeof elm.setAttribute !== 'function' || typeof elm.namespaceURI !== 'string' || typeof elm.insertBefore !== 'function' || typeof elm.hasChildNodes !== 'function');
    };

    /**
     * Checks whether the given object is a DOM node.
     *
     * @param  {Node} object object to check whether it's a DOM node
     * @return {Boolean} true is object is a DOM node
     */
    const _isNode = function _isNode(object) {
      return typeof Node === 'function' && object instanceof Node;
    };

    /**
     * _executeHook
     * Execute user configurable hooks
     *
     * @param  {String} entryPoint  Name of the hook's entry point
     * @param  {Node} currentNode node to work on with the hook
     * @param  {Object} data additional hook parameters
     */
    const _executeHook = function _executeHook(entryPoint, currentNode, data) {
      if (!hooks[entryPoint]) {
        return;
      }
      arrayForEach(hooks[entryPoint], hook => {
        hook.call(DOMPurify, currentNode, data, CONFIG);
      });
    };

    /**
     * _sanitizeElements
     *
     * @protect nodeName
     * @protect textContent
     * @protect removeChild
     *
     * @param   {Node} currentNode to check for permission to exist
     * @return  {Boolean} true if node was killed, false if left alive
     */
    const _sanitizeElements = function _sanitizeElements(currentNode) {
      let content = null;

      /* Execute a hook if present */
      _executeHook('beforeSanitizeElements', currentNode, null);

      /* Check if element is clobbered or can clobber */
      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }

      /* Now let's check the element's type and name */
      const tagName = transformCaseFunc(currentNode.nodeName);

      /* Execute a hook if present */
      _executeHook('uponSanitizeElement', currentNode, {
        tagName,
        allowedTags: ALLOWED_TAGS
      });

      /* Detect mXSS attempts abusing namespace confusion */
      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);
        return true;
      }

      /* Remove any occurrence of processing instructions */
      if (currentNode.nodeType === NODE_TYPE.progressingInstruction) {
        _forceRemove(currentNode);
        return true;
      }

      /* Remove any kind of possibly harmful comments */
      if (SAFE_FOR_XML && currentNode.nodeType === NODE_TYPE.comment && regExpTest(/<[/\w]/g, currentNode.data)) {
        _forceRemove(currentNode);
        return true;
      }

      /* Remove element if anything forbids its presence */
      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        /* Check if we have a custom element to handle */
        if (!FORBID_TAGS[tagName] && _isBasicCustomElement(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName)) {
            return false;
          }
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName)) {
            return false;
          }
        }

        /* Keep content except for bad-listed elements */
        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          const parentNode = getParentNode(currentNode) || currentNode.parentNode;
          const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
          if (childNodes && parentNode) {
            const childCount = childNodes.length;
            for (let i = childCount - 1; i >= 0; --i) {
              const childClone = cloneNode(childNodes[i], true);
              childClone.__removalCount = (currentNode.__removalCount || 0) + 1;
              parentNode.insertBefore(childClone, getNextSibling(currentNode));
            }
          }
        }
        _forceRemove(currentNode);
        return true;
      }

      /* Check whether element has a valid namespace */
      if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }

      /* Make sure that older browsers don't get fallback-tag mXSS */
      if ((tagName === 'noscript' || tagName === 'noembed' || tagName === 'noframes') && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }

      /* Sanitize element content to be template-safe */
      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === NODE_TYPE.text) {
        /* Get the element's text content */
        content = currentNode.textContent;
        arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
          content = stringReplace(content, expr, ' ');
        });
        if (currentNode.textContent !== content) {
          arrayPush(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content;
        }
      }

      /* Execute a hook if present */
      _executeHook('afterSanitizeElements', currentNode, null);
      return false;
    };

    /**
     * _isValidAttribute
     *
     * @param  {string} lcTag Lowercase tag name of containing element.
     * @param  {string} lcName Lowercase attribute name.
     * @param  {string} value Attribute value.
     * @return {Boolean} Returns true if `value` is valid, otherwise false.
     */
    // eslint-disable-next-line complexity
    const _isValidAttribute = function _isValidAttribute(lcTag, lcName, value) {
      /* Make sure attribute cannot clobber */
      if (SANITIZE_DOM && (lcName === 'id' || lcName === 'name') && (value in document || value in formElement)) {
        return false;
      }

      /* Allow valid data-* attributes: At least one character after "-"
          (https://html.spec.whatwg.org/multipage/dom.html#embedding-custom-non-visible-data-with-the-data-*-attributes)
          XML-compatible (https://html.spec.whatwg.org/multipage/infrastructure.html#xml-compatible and http://www.w3.org/TR/xml/#d0e804)
          We don't need to check the value; it's always URI safe. */
      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR, lcName)) ; else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR, lcName)) ; else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if (
        // First condition does a very basic check if a) it's basically a valid custom element tagname AND
        // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
        _isBasicCustomElement(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) ||
        // Alternative, second condition checks if it's an `is`-attribute, AND
        // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
        lcName === 'is' && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value))) ; else {
          return false;
        }
        /* Check value is safe. First, is attr inert? If so, is safe */
      } else if (URI_SAFE_ATTRIBUTES[lcName]) ; else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value, ATTR_WHITESPACE, ''))) ; else if ((lcName === 'src' || lcName === 'xlink:href' || lcName === 'href') && lcTag !== 'script' && stringIndexOf(value, 'data:') === 0 && DATA_URI_TAGS[lcTag]) ; else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA, stringReplace(value, ATTR_WHITESPACE, ''))) ; else if (value) {
        return false;
      } else ;
      return true;
    };

    /**
     * _isBasicCustomElement
     * checks if at least one dash is included in tagName, and it's not the first char
     * for more sophisticated checking see https://github.com/sindresorhus/validate-element-name
     *
     * @param {string} tagName name of the tag of the node to sanitize
     * @returns {boolean} Returns true if the tag name meets the basic criteria for a custom element, otherwise false.
     */
    const _isBasicCustomElement = function _isBasicCustomElement(tagName) {
      return tagName !== 'annotation-xml' && stringMatch(tagName, CUSTOM_ELEMENT);
    };

    /**
     * _sanitizeAttributes
     *
     * @protect attributes
     * @protect nodeName
     * @protect removeAttribute
     * @protect setAttribute
     *
     * @param  {Node} currentNode to sanitize
     */
    const _sanitizeAttributes = function _sanitizeAttributes(currentNode) {
      /* Execute a hook if present */
      _executeHook('beforeSanitizeAttributes', currentNode, null);
      const {
        attributes
      } = currentNode;

      /* Check if we have attributes; if not we might have a text node */
      if (!attributes) {
        return;
      }
      const hookEvent = {
        attrName: '',
        attrValue: '',
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      let l = attributes.length;

      /* Go backwards over all attributes; safely remove bad ones */
      while (l--) {
        const attr = attributes[l];
        const {
          name,
          namespaceURI,
          value: attrValue
        } = attr;
        const lcName = transformCaseFunc(name);
        let value = name === 'value' ? attrValue : stringTrim(attrValue);

        /* Execute a hook if present */
        hookEvent.attrName = lcName;
        hookEvent.attrValue = value;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = undefined; // Allows developers to see this is a property they can set
        _executeHook('uponSanitizeAttribute', currentNode, hookEvent);
        value = hookEvent.attrValue;

        /* Work around a security issue with comments inside attributes */
        if (SAFE_FOR_XML && regExpTest(/((--!?|])>)|<\/(style|title)/i, value)) {
          _removeAttribute(name, currentNode);
          continue;
        }

        /* Did the hooks approve of the attribute? */
        if (hookEvent.forceKeepAttr) {
          continue;
        }

        /* Remove attribute */
        _removeAttribute(name, currentNode);

        /* Did the hooks approve of the attribute? */
        if (!hookEvent.keepAttr) {
          continue;
        }

        /* Work around a security issue in jQuery 3.0 */
        if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value)) {
          _removeAttribute(name, currentNode);
          continue;
        }

        /* Sanitize attribute content to be template-safe */
        if (SAFE_FOR_TEMPLATES) {
          arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
            value = stringReplace(value, expr, ' ');
          });
        }

        /* Is `value` valid for this attribute? */
        const lcTag = transformCaseFunc(currentNode.nodeName);
        if (!_isValidAttribute(lcTag, lcName, value)) {
          continue;
        }

        /* Full DOM Clobbering protection via namespace isolation,
         * Prefix id and name attributes with `user-content-`
         */
        if (SANITIZE_NAMED_PROPS && (lcName === 'id' || lcName === 'name')) {
          // Remove the attribute with this value
          _removeAttribute(name, currentNode);

          // Prefix the value and later re-create the attribute with the sanitized value
          value = SANITIZE_NAMED_PROPS_PREFIX + value;
        }

        /* Handle attributes that require Trusted Types */
        if (trustedTypesPolicy && typeof trustedTypes === 'object' && typeof trustedTypes.getAttributeType === 'function') {
          if (namespaceURI) ; else {
            switch (trustedTypes.getAttributeType(lcTag, lcName)) {
              case 'TrustedHTML':
                {
                  value = trustedTypesPolicy.createHTML(value);
                  break;
                }
              case 'TrustedScriptURL':
                {
                  value = trustedTypesPolicy.createScriptURL(value);
                  break;
                }
            }
          }
        }

        /* Handle invalid data-* attribute set by try-catching it */
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name, value);
          } else {
            /* Fallback to setAttribute() for browser-unrecognized namespaces e.g. "x-schema". */
            currentNode.setAttribute(name, value);
          }
          if (_isClobbered(currentNode)) {
            _forceRemove(currentNode);
          } else {
            arrayPop(DOMPurify.removed);
          }
        } catch (_) {}
      }

      /* Execute a hook if present */
      _executeHook('afterSanitizeAttributes', currentNode, null);
    };

    /**
     * _sanitizeShadowDOM
     *
     * @param  {DocumentFragment} fragment to iterate over recursively
     */
    const _sanitizeShadowDOM = function _sanitizeShadowDOM(fragment) {
      let shadowNode = null;
      const shadowIterator = _createNodeIterator(fragment);

      /* Execute a hook if present */
      _executeHook('beforeSanitizeShadowDOM', fragment, null);
      while (shadowNode = shadowIterator.nextNode()) {
        /* Execute a hook if present */
        _executeHook('uponSanitizeShadowNode', shadowNode, null);

        /* Sanitize tags and elements */
        if (_sanitizeElements(shadowNode)) {
          continue;
        }

        /* Deep shadow DOM detected */
        if (shadowNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(shadowNode.content);
        }

        /* Check attributes, sanitize if necessary */
        _sanitizeAttributes(shadowNode);
      }

      /* Execute a hook if present */
      _executeHook('afterSanitizeShadowDOM', fragment, null);
    };

    /**
     * Sanitize
     * Public method providing core sanitation functionality
     *
     * @param {String|Node} dirty string or DOM node
     * @param {Object} cfg object
     */
    // eslint-disable-next-line complexity
    DOMPurify.sanitize = function (dirty) {
      let cfg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      let body = null;
      let importedNode = null;
      let currentNode = null;
      let returnNode = null;
      /* Make sure we have a string to sanitize.
        DO NOT return early, as this will return the wrong type if
        the user has requested a DOM object rather than a string */
      IS_EMPTY_INPUT = !dirty;
      if (IS_EMPTY_INPUT) {
        dirty = '<!-->';
      }

      /* Stringify, in case dirty is an object */
      if (typeof dirty !== 'string' && !_isNode(dirty)) {
        if (typeof dirty.toString === 'function') {
          dirty = dirty.toString();
          if (typeof dirty !== 'string') {
            throw typeErrorCreate('dirty is not a string, aborting');
          }
        } else {
          throw typeErrorCreate('toString is not a function');
        }
      }

      /* Return dirty HTML if DOMPurify cannot run */
      if (!DOMPurify.isSupported) {
        return dirty;
      }

      /* Assign config vars */
      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }

      /* Clean up removed elements */
      DOMPurify.removed = [];

      /* Check if dirty is correctly typed for IN_PLACE */
      if (typeof dirty === 'string') {
        IN_PLACE = false;
      }
      if (IN_PLACE) {
        /* Do some early pre-sanitization to avoid unsafe root nodes */
        if (dirty.nodeName) {
          const tagName = transformCaseFunc(dirty.nodeName);
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate('root node is forbidden and cannot be sanitized in-place');
          }
        }
      } else if (dirty instanceof Node) {
        /* If dirty is a DOM element, append to an empty document to avoid
           elements being stripped by the parser */
        body = _initDocument('<!---->');
        importedNode = body.ownerDocument.importNode(dirty, true);
        if (importedNode.nodeType === NODE_TYPE.element && importedNode.nodeName === 'BODY') {
          /* Node is already a body, use as is */
          body = importedNode;
        } else if (importedNode.nodeName === 'HTML') {
          body = importedNode;
        } else {
          // eslint-disable-next-line unicorn/prefer-dom-node-append
          body.appendChild(importedNode);
        }
      } else {
        /* Exit directly if we have nothing to do */
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT &&
        // eslint-disable-next-line unicorn/prefer-includes
        dirty.indexOf('<') === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }

        /* Initialize the document to work on */
        body = _initDocument(dirty);

        /* Check we have a DOM node from the data */
        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : '';
        }
      }

      /* Remove first element node (ours) if FORCE_BODY is set */
      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }

      /* Get node iterator */
      const nodeIterator = _createNodeIterator(IN_PLACE ? dirty : body);

      /* Now start iterating over the created document */
      while (currentNode = nodeIterator.nextNode()) {
        /* Sanitize tags and elements */
        if (_sanitizeElements(currentNode)) {
          continue;
        }

        /* Shadow DOM detected, sanitize it */
        if (currentNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(currentNode.content);
        }

        /* Check attributes, sanitize if necessary */
        _sanitizeAttributes(currentNode);
      }

      /* If we sanitized `dirty` in-place, return it. */
      if (IN_PLACE) {
        return dirty;
      }

      /* Return sanitized string or DOM */
      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);
          while (body.firstChild) {
            // eslint-disable-next-line unicorn/prefer-dom-node-append
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }
        if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
          /*
            AdoptNode() is not used because internal state is not reset
            (e.g. the past names map of a HTMLFormElement), this is safe
            in theory but we would rather not risk another attack vector.
            The state that is cloned by importNode() is explicitly defined
            by the specs.
          */
          returnNode = importNode.call(originalDocument, returnNode, true);
        }
        return returnNode;
      }
      let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;

      /* Serialize doctype if allowed */
      if (WHOLE_DOCUMENT && ALLOWED_TAGS['!doctype'] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = '<!DOCTYPE ' + body.ownerDocument.doctype.name + '>\n' + serializedHTML;
      }

      /* Sanitize final string template-safe */
      if (SAFE_FOR_TEMPLATES) {
        arrayForEach([MUSTACHE_EXPR, ERB_EXPR, TMPLIT_EXPR], expr => {
          serializedHTML = stringReplace(serializedHTML, expr, ' ');
        });
      }
      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };

    /**
     * Public method to set the configuration once
     * setConfig
     *
     * @param {Object} cfg configuration object
     */
    DOMPurify.setConfig = function () {
      let cfg = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      _parseConfig(cfg);
      SET_CONFIG = true;
    };

    /**
     * Public method to remove the configuration
     * clearConfig
     *
     */
    DOMPurify.clearConfig = function () {
      CONFIG = null;
      SET_CONFIG = false;
    };

    /**
     * Public method to check if an attribute value is valid.
     * Uses last set config, if any. Otherwise, uses config defaults.
     * isValidAttribute
     *
     * @param  {String} tag Tag name of containing element.
     * @param  {String} attr Attribute name.
     * @param  {String} value Attribute value.
     * @return {Boolean} Returns true if `value` is valid. Otherwise, returns false.
     */
    DOMPurify.isValidAttribute = function (tag, attr, value) {
      /* Initialize shared config vars if necessary. */
      if (!CONFIG) {
        _parseConfig({});
      }
      const lcTag = transformCaseFunc(tag);
      const lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value);
    };

    /**
     * AddHook
     * Public method to add DOMPurify hooks
     *
     * @param {String} entryPoint entry point for the hook to add
     * @param {Function} hookFunction function to execute
     */
    DOMPurify.addHook = function (entryPoint, hookFunction) {
      if (typeof hookFunction !== 'function') {
        return;
      }
      hooks[entryPoint] = hooks[entryPoint] || [];
      arrayPush(hooks[entryPoint], hookFunction);
    };

    /**
     * RemoveHook
     * Public method to remove a DOMPurify hook at a given entryPoint
     * (pops it from the stack of hooks if more are present)
     *
     * @param {String} entryPoint entry point for the hook to remove
     * @return {Function} removed(popped) hook
     */
    DOMPurify.removeHook = function (entryPoint) {
      if (hooks[entryPoint]) {
        return arrayPop(hooks[entryPoint]);
      }
    };

    /**
     * RemoveHooks
     * Public method to remove all DOMPurify hooks at a given entryPoint
     *
     * @param  {String} entryPoint entry point for the hooks to remove
     */
    DOMPurify.removeHooks = function (entryPoint) {
      if (hooks[entryPoint]) {
        hooks[entryPoint] = [];
      }
    };

    /**
     * RemoveAllHooks
     * Public method to remove all DOMPurify hooks
     */
    DOMPurify.removeAllHooks = function () {
      hooks = {};
    };
    return DOMPurify;
  }
  var purify = createDOMPurify();

  var lodash$1 = {exports: {}};

  /**
   * @license
   * Lodash <https://lodash.com/>
   * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
   * Released under MIT license <https://lodash.com/license>
   * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
   * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
   */
  var lodash = lodash$1.exports;

  var hasRequiredLodash;

  function requireLodash () {
  	if (hasRequiredLodash) return lodash$1.exports;
  	hasRequiredLodash = 1;
  	(function (module, exports) {
  (function() {

  		  /** Used as a safe reference for `undefined` in pre-ES5 environments. */
  		  var undefined$1;

  		  /** Used as the semantic version number. */
  		  var VERSION = '4.17.21';

  		  /** Used as the size to enable large array optimizations. */
  		  var LARGE_ARRAY_SIZE = 200;

  		  /** Error message constants. */
  		  var CORE_ERROR_TEXT = 'Unsupported core-js use. Try https://npms.io/search?q=ponyfill.',
  		      FUNC_ERROR_TEXT = 'Expected a function',
  		      INVALID_TEMPL_VAR_ERROR_TEXT = 'Invalid `variable` option passed into `_.template`';

  		  /** Used to stand-in for `undefined` hash values. */
  		  var HASH_UNDEFINED = '__lodash_hash_undefined__';

  		  /** Used as the maximum memoize cache size. */
  		  var MAX_MEMOIZE_SIZE = 500;

  		  /** Used as the internal argument placeholder. */
  		  var PLACEHOLDER = '__lodash_placeholder__';

  		  /** Used to compose bitmasks for cloning. */
  		  var CLONE_DEEP_FLAG = 1,
  		      CLONE_FLAT_FLAG = 2,
  		      CLONE_SYMBOLS_FLAG = 4;

  		  /** Used to compose bitmasks for value comparisons. */
  		  var COMPARE_PARTIAL_FLAG = 1,
  		      COMPARE_UNORDERED_FLAG = 2;

  		  /** Used to compose bitmasks for function metadata. */
  		  var WRAP_BIND_FLAG = 1,
  		      WRAP_BIND_KEY_FLAG = 2,
  		      WRAP_CURRY_BOUND_FLAG = 4,
  		      WRAP_CURRY_FLAG = 8,
  		      WRAP_CURRY_RIGHT_FLAG = 16,
  		      WRAP_PARTIAL_FLAG = 32,
  		      WRAP_PARTIAL_RIGHT_FLAG = 64,
  		      WRAP_ARY_FLAG = 128,
  		      WRAP_REARG_FLAG = 256,
  		      WRAP_FLIP_FLAG = 512;

  		  /** Used as default options for `_.truncate`. */
  		  var DEFAULT_TRUNC_LENGTH = 30,
  		      DEFAULT_TRUNC_OMISSION = '...';

  		  /** Used to detect hot functions by number of calls within a span of milliseconds. */
  		  var HOT_COUNT = 800,
  		      HOT_SPAN = 16;

  		  /** Used to indicate the type of lazy iteratees. */
  		  var LAZY_FILTER_FLAG = 1,
  		      LAZY_MAP_FLAG = 2,
  		      LAZY_WHILE_FLAG = 3;

  		  /** Used as references for various `Number` constants. */
  		  var INFINITY = 1 / 0,
  		      MAX_SAFE_INTEGER = 9007199254740991,
  		      MAX_INTEGER = 1.7976931348623157e+308,
  		      NAN = 0 / 0;

  		  /** Used as references for the maximum length and index of an array. */
  		  var MAX_ARRAY_LENGTH = 4294967295,
  		      MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
  		      HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;

  		  /** Used to associate wrap methods with their bit flags. */
  		  var wrapFlags = [
  		    ['ary', WRAP_ARY_FLAG],
  		    ['bind', WRAP_BIND_FLAG],
  		    ['bindKey', WRAP_BIND_KEY_FLAG],
  		    ['curry', WRAP_CURRY_FLAG],
  		    ['curryRight', WRAP_CURRY_RIGHT_FLAG],
  		    ['flip', WRAP_FLIP_FLAG],
  		    ['partial', WRAP_PARTIAL_FLAG],
  		    ['partialRight', WRAP_PARTIAL_RIGHT_FLAG],
  		    ['rearg', WRAP_REARG_FLAG]
  		  ];

  		  /** `Object#toString` result references. */
  		  var argsTag = '[object Arguments]',
  		      arrayTag = '[object Array]',
  		      asyncTag = '[object AsyncFunction]',
  		      boolTag = '[object Boolean]',
  		      dateTag = '[object Date]',
  		      domExcTag = '[object DOMException]',
  		      errorTag = '[object Error]',
  		      funcTag = '[object Function]',
  		      genTag = '[object GeneratorFunction]',
  		      mapTag = '[object Map]',
  		      numberTag = '[object Number]',
  		      nullTag = '[object Null]',
  		      objectTag = '[object Object]',
  		      promiseTag = '[object Promise]',
  		      proxyTag = '[object Proxy]',
  		      regexpTag = '[object RegExp]',
  		      setTag = '[object Set]',
  		      stringTag = '[object String]',
  		      symbolTag = '[object Symbol]',
  		      undefinedTag = '[object Undefined]',
  		      weakMapTag = '[object WeakMap]',
  		      weakSetTag = '[object WeakSet]';

  		  var arrayBufferTag = '[object ArrayBuffer]',
  		      dataViewTag = '[object DataView]',
  		      float32Tag = '[object Float32Array]',
  		      float64Tag = '[object Float64Array]',
  		      int8Tag = '[object Int8Array]',
  		      int16Tag = '[object Int16Array]',
  		      int32Tag = '[object Int32Array]',
  		      uint8Tag = '[object Uint8Array]',
  		      uint8ClampedTag = '[object Uint8ClampedArray]',
  		      uint16Tag = '[object Uint16Array]',
  		      uint32Tag = '[object Uint32Array]';

  		  /** Used to match empty string literals in compiled template source. */
  		  var reEmptyStringLeading = /\b__p \+= '';/g,
  		      reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
  		      reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;

  		  /** Used to match HTML entities and HTML characters. */
  		  var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
  		      reUnescapedHtml = /[&<>"']/g,
  		      reHasEscapedHtml = RegExp(reEscapedHtml.source),
  		      reHasUnescapedHtml = RegExp(reUnescapedHtml.source);

  		  /** Used to match template delimiters. */
  		  var reEscape = /<%-([\s\S]+?)%>/g,
  		      reEvaluate = /<%([\s\S]+?)%>/g,
  		      reInterpolate = /<%=([\s\S]+?)%>/g;

  		  /** Used to match property names within property paths. */
  		  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
  		      reIsPlainProp = /^\w*$/,
  		      rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;

  		  /**
  		   * Used to match `RegExp`
  		   * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
  		   */
  		  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g,
  		      reHasRegExpChar = RegExp(reRegExpChar.source);

  		  /** Used to match leading whitespace. */
  		  var reTrimStart = /^\s+/;

  		  /** Used to match a single whitespace character. */
  		  var reWhitespace = /\s/;

  		  /** Used to match wrap detail comments. */
  		  var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
  		      reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
  		      reSplitDetails = /,? & /;

  		  /** Used to match words composed of alphanumeric characters. */
  		  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

  		  /**
  		   * Used to validate the `validate` option in `_.template` variable.
  		   *
  		   * Forbids characters which could potentially change the meaning of the function argument definition:
  		   * - "()," (modification of function parameters)
  		   * - "=" (default value)
  		   * - "[]{}" (destructuring of function parameters)
  		   * - "/" (beginning of a comment)
  		   * - whitespace
  		   */
  		  var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;

  		  /** Used to match backslashes in property paths. */
  		  var reEscapeChar = /\\(\\)?/g;

  		  /**
  		   * Used to match
  		   * [ES template delimiters](http://ecma-international.org/ecma-262/7.0/#sec-template-literal-lexical-components).
  		   */
  		  var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;

  		  /** Used to match `RegExp` flags from their coerced string values. */
  		  var reFlags = /\w*$/;

  		  /** Used to detect bad signed hexadecimal string values. */
  		  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;

  		  /** Used to detect binary string values. */
  		  var reIsBinary = /^0b[01]+$/i;

  		  /** Used to detect host constructors (Safari). */
  		  var reIsHostCtor = /^\[object .+?Constructor\]$/;

  		  /** Used to detect octal string values. */
  		  var reIsOctal = /^0o[0-7]+$/i;

  		  /** Used to detect unsigned integer values. */
  		  var reIsUint = /^(?:0|[1-9]\d*)$/;

  		  /** Used to match Latin Unicode letters (excluding mathematical operators). */
  		  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

  		  /** Used to ensure capturing order of template delimiters. */
  		  var reNoMatch = /($^)/;

  		  /** Used to match unescaped characters in compiled string literals. */
  		  var reUnescapedString = /['\n\r\u2028\u2029\\]/g;

  		  /** Used to compose unicode character classes. */
  		  var rsAstralRange = '\\ud800-\\udfff',
  		      rsComboMarksRange = '\\u0300-\\u036f',
  		      reComboHalfMarksRange = '\\ufe20-\\ufe2f',
  		      rsComboSymbolsRange = '\\u20d0-\\u20ff',
  		      rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
  		      rsDingbatRange = '\\u2700-\\u27bf',
  		      rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
  		      rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
  		      rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
  		      rsPunctuationRange = '\\u2000-\\u206f',
  		      rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
  		      rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
  		      rsVarRange = '\\ufe0e\\ufe0f',
  		      rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

  		  /** Used to compose unicode capture groups. */
  		  var rsApos = "['\u2019]",
  		      rsAstral = '[' + rsAstralRange + ']',
  		      rsBreak = '[' + rsBreakRange + ']',
  		      rsCombo = '[' + rsComboRange + ']',
  		      rsDigits = '\\d+',
  		      rsDingbat = '[' + rsDingbatRange + ']',
  		      rsLower = '[' + rsLowerRange + ']',
  		      rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
  		      rsFitz = '\\ud83c[\\udffb-\\udfff]',
  		      rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
  		      rsNonAstral = '[^' + rsAstralRange + ']',
  		      rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
  		      rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
  		      rsUpper = '[' + rsUpperRange + ']',
  		      rsZWJ = '\\u200d';

  		  /** Used to compose unicode regexes. */
  		  var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
  		      rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
  		      rsOptContrLower = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
  		      rsOptContrUpper = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
  		      reOptMod = rsModifier + '?',
  		      rsOptVar = '[' + rsVarRange + ']?',
  		      rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
  		      rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
  		      rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
  		      rsSeq = rsOptVar + reOptMod + rsOptJoin,
  		      rsEmoji = '(?:' + [rsDingbat, rsRegional, rsSurrPair].join('|') + ')' + rsSeq,
  		      rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

  		  /** Used to match apostrophes. */
  		  var reApos = RegExp(rsApos, 'g');

  		  /**
  		   * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
  		   * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
  		   */
  		  var reComboMark = RegExp(rsCombo, 'g');

  		  /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
  		  var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

  		  /** Used to match complex or compound words. */
  		  var reUnicodeWord = RegExp([
  		    rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
  		    rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
  		    rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
  		    rsUpper + '+' + rsOptContrUpper,
  		    rsOrdUpper,
  		    rsOrdLower,
  		    rsDigits,
  		    rsEmoji
  		  ].join('|'), 'g');

  		  /** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
  		  var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

  		  /** Used to detect strings that need a more robust regexp to match words. */
  		  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

  		  /** Used to assign default `context` object properties. */
  		  var contextProps = [
  		    'Array', 'Buffer', 'DataView', 'Date', 'Error', 'Float32Array', 'Float64Array',
  		    'Function', 'Int8Array', 'Int16Array', 'Int32Array', 'Map', 'Math', 'Object',
  		    'Promise', 'RegExp', 'Set', 'String', 'Symbol', 'TypeError', 'Uint8Array',
  		    'Uint8ClampedArray', 'Uint16Array', 'Uint32Array', 'WeakMap',
  		    '_', 'clearTimeout', 'isFinite', 'parseInt', 'setTimeout'
  		  ];

  		  /** Used to make template sourceURLs easier to identify. */
  		  var templateCounter = -1;

  		  /** Used to identify `toStringTag` values of typed arrays. */
  		  var typedArrayTags = {};
  		  typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
  		  typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
  		  typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
  		  typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
  		  typedArrayTags[uint32Tag] = true;
  		  typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
  		  typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
  		  typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
  		  typedArrayTags[errorTag] = typedArrayTags[funcTag] =
  		  typedArrayTags[mapTag] = typedArrayTags[numberTag] =
  		  typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
  		  typedArrayTags[setTag] = typedArrayTags[stringTag] =
  		  typedArrayTags[weakMapTag] = false;

  		  /** Used to identify `toStringTag` values supported by `_.clone`. */
  		  var cloneableTags = {};
  		  cloneableTags[argsTag] = cloneableTags[arrayTag] =
  		  cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
  		  cloneableTags[boolTag] = cloneableTags[dateTag] =
  		  cloneableTags[float32Tag] = cloneableTags[float64Tag] =
  		  cloneableTags[int8Tag] = cloneableTags[int16Tag] =
  		  cloneableTags[int32Tag] = cloneableTags[mapTag] =
  		  cloneableTags[numberTag] = cloneableTags[objectTag] =
  		  cloneableTags[regexpTag] = cloneableTags[setTag] =
  		  cloneableTags[stringTag] = cloneableTags[symbolTag] =
  		  cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
  		  cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  		  cloneableTags[errorTag] = cloneableTags[funcTag] =
  		  cloneableTags[weakMapTag] = false;

  		  /** Used to map Latin Unicode letters to basic Latin letters. */
  		  var deburredLetters = {
  		    // Latin-1 Supplement block.
  		    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
  		    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
  		    '\xc7': 'C',  '\xe7': 'c',
  		    '\xd0': 'D',  '\xf0': 'd',
  		    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
  		    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
  		    '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
  		    '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
  		    '\xd1': 'N',  '\xf1': 'n',
  		    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
  		    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
  		    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
  		    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
  		    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
  		    '\xc6': 'Ae', '\xe6': 'ae',
  		    '\xde': 'Th', '\xfe': 'th',
  		    '\xdf': 'ss',
  		    // Latin Extended-A block.
  		    '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
  		    '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
  		    '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
  		    '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
  		    '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
  		    '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
  		    '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
  		    '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
  		    '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
  		    '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
  		    '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
  		    '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
  		    '\u0134': 'J',  '\u0135': 'j',
  		    '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
  		    '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
  		    '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
  		    '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
  		    '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
  		    '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
  		    '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
  		    '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
  		    '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
  		    '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
  		    '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
  		    '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
  		    '\u0163': 't',  '\u0165': 't', '\u0167': 't',
  		    '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
  		    '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
  		    '\u0174': 'W',  '\u0175': 'w',
  		    '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
  		    '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
  		    '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
  		    '\u0132': 'IJ', '\u0133': 'ij',
  		    '\u0152': 'Oe', '\u0153': 'oe',
  		    '\u0149': "'n", '\u017f': 's'
  		  };

  		  /** Used to map characters to HTML entities. */
  		  var htmlEscapes = {
  		    '&': '&amp;',
  		    '<': '&lt;',
  		    '>': '&gt;',
  		    '"': '&quot;',
  		    "'": '&#39;'
  		  };

  		  /** Used to map HTML entities to characters. */
  		  var htmlUnescapes = {
  		    '&amp;': '&',
  		    '&lt;': '<',
  		    '&gt;': '>',
  		    '&quot;': '"',
  		    '&#39;': "'"
  		  };

  		  /** Used to escape characters for inclusion in compiled string literals. */
  		  var stringEscapes = {
  		    '\\': '\\',
  		    "'": "'",
  		    '\n': 'n',
  		    '\r': 'r',
  		    '\u2028': 'u2028',
  		    '\u2029': 'u2029'
  		  };

  		  /** Built-in method references without a dependency on `root`. */
  		  var freeParseFloat = parseFloat,
  		      freeParseInt = parseInt;

  		  /** Detect free variable `global` from Node.js. */
  		  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

  		  /** Detect free variable `self`. */
  		  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  		  /** Used as a reference to the global object. */
  		  var root = freeGlobal || freeSelf || Function('return this')();

  		  /** Detect free variable `exports`. */
  		  var freeExports = exports && !exports.nodeType && exports;

  		  /** Detect free variable `module`. */
  		  var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

  		  /** Detect the popular CommonJS extension `module.exports`. */
  		  var moduleExports = freeModule && freeModule.exports === freeExports;

  		  /** Detect free variable `process` from Node.js. */
  		  var freeProcess = moduleExports && freeGlobal.process;

  		  /** Used to access faster Node.js helpers. */
  		  var nodeUtil = (function() {
  		    try {
  		      // Use `util.types` for Node.js 10+.
  		      var types = freeModule && freeModule.require && freeModule.require('util').types;

  		      if (types) {
  		        return types;
  		      }

  		      // Legacy `process.binding('util')` for Node.js < 10.
  		      return freeProcess && freeProcess.binding && freeProcess.binding('util');
  		    } catch (e) {}
  		  }());

  		  /* Node.js helper references. */
  		  var nodeIsArrayBuffer = nodeUtil && nodeUtil.isArrayBuffer,
  		      nodeIsDate = nodeUtil && nodeUtil.isDate,
  		      nodeIsMap = nodeUtil && nodeUtil.isMap,
  		      nodeIsRegExp = nodeUtil && nodeUtil.isRegExp,
  		      nodeIsSet = nodeUtil && nodeUtil.isSet,
  		      nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

  		  /*--------------------------------------------------------------------------*/

  		  /**
  		   * A faster alternative to `Function#apply`, this function invokes `func`
  		   * with the `this` binding of `thisArg` and the arguments of `args`.
  		   *
  		   * @private
  		   * @param {Function} func The function to invoke.
  		   * @param {*} thisArg The `this` binding of `func`.
  		   * @param {Array} args The arguments to invoke `func` with.
  		   * @returns {*} Returns the result of `func`.
  		   */
  		  function apply(func, thisArg, args) {
  		    switch (args.length) {
  		      case 0: return func.call(thisArg);
  		      case 1: return func.call(thisArg, args[0]);
  		      case 2: return func.call(thisArg, args[0], args[1]);
  		      case 3: return func.call(thisArg, args[0], args[1], args[2]);
  		    }
  		    return func.apply(thisArg, args);
  		  }

  		  /**
  		   * A specialized version of `baseAggregator` for arrays.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} setter The function to set `accumulator` values.
  		   * @param {Function} iteratee The iteratee to transform keys.
  		   * @param {Object} accumulator The initial aggregated object.
  		   * @returns {Function} Returns `accumulator`.
  		   */
  		  function arrayAggregator(array, setter, iteratee, accumulator) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    while (++index < length) {
  		      var value = array[index];
  		      setter(accumulator, value, iteratee(value), array);
  		    }
  		    return accumulator;
  		  }

  		  /**
  		   * A specialized version of `_.forEach` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {Array} Returns `array`.
  		   */
  		  function arrayEach(array, iteratee) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    while (++index < length) {
  		      if (iteratee(array[index], index, array) === false) {
  		        break;
  		      }
  		    }
  		    return array;
  		  }

  		  /**
  		   * A specialized version of `_.forEachRight` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {Array} Returns `array`.
  		   */
  		  function arrayEachRight(array, iteratee) {
  		    var length = array == null ? 0 : array.length;

  		    while (length--) {
  		      if (iteratee(array[length], length, array) === false) {
  		        break;
  		      }
  		    }
  		    return array;
  		  }

  		  /**
  		   * A specialized version of `_.every` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} predicate The function invoked per iteration.
  		   * @returns {boolean} Returns `true` if all elements pass the predicate check,
  		   *  else `false`.
  		   */
  		  function arrayEvery(array, predicate) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    while (++index < length) {
  		      if (!predicate(array[index], index, array)) {
  		        return false;
  		      }
  		    }
  		    return true;
  		  }

  		  /**
  		   * A specialized version of `_.filter` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} predicate The function invoked per iteration.
  		   * @returns {Array} Returns the new filtered array.
  		   */
  		  function arrayFilter(array, predicate) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length,
  		        resIndex = 0,
  		        result = [];

  		    while (++index < length) {
  		      var value = array[index];
  		      if (predicate(value, index, array)) {
  		        result[resIndex++] = value;
  		      }
  		    }
  		    return result;
  		  }

  		  /**
  		   * A specialized version of `_.includes` for arrays without support for
  		   * specifying an index to search from.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to inspect.
  		   * @param {*} target The value to search for.
  		   * @returns {boolean} Returns `true` if `target` is found, else `false`.
  		   */
  		  function arrayIncludes(array, value) {
  		    var length = array == null ? 0 : array.length;
  		    return !!length && baseIndexOf(array, value, 0) > -1;
  		  }

  		  /**
  		   * This function is like `arrayIncludes` except that it accepts a comparator.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to inspect.
  		   * @param {*} target The value to search for.
  		   * @param {Function} comparator The comparator invoked per element.
  		   * @returns {boolean} Returns `true` if `target` is found, else `false`.
  		   */
  		  function arrayIncludesWith(array, value, comparator) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    while (++index < length) {
  		      if (comparator(value, array[index])) {
  		        return true;
  		      }
  		    }
  		    return false;
  		  }

  		  /**
  		   * A specialized version of `_.map` for arrays without support for iteratee
  		   * shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {Array} Returns the new mapped array.
  		   */
  		  function arrayMap(array, iteratee) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length,
  		        result = Array(length);

  		    while (++index < length) {
  		      result[index] = iteratee(array[index], index, array);
  		    }
  		    return result;
  		  }

  		  /**
  		   * Appends the elements of `values` to `array`.
  		   *
  		   * @private
  		   * @param {Array} array The array to modify.
  		   * @param {Array} values The values to append.
  		   * @returns {Array} Returns `array`.
  		   */
  		  function arrayPush(array, values) {
  		    var index = -1,
  		        length = values.length,
  		        offset = array.length;

  		    while (++index < length) {
  		      array[offset + index] = values[index];
  		    }
  		    return array;
  		  }

  		  /**
  		   * A specialized version of `_.reduce` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @param {*} [accumulator] The initial value.
  		   * @param {boolean} [initAccum] Specify using the first element of `array` as
  		   *  the initial value.
  		   * @returns {*} Returns the accumulated value.
  		   */
  		  function arrayReduce(array, iteratee, accumulator, initAccum) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    if (initAccum && length) {
  		      accumulator = array[++index];
  		    }
  		    while (++index < length) {
  		      accumulator = iteratee(accumulator, array[index], index, array);
  		    }
  		    return accumulator;
  		  }

  		  /**
  		   * A specialized version of `_.reduceRight` for arrays without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @param {*} [accumulator] The initial value.
  		   * @param {boolean} [initAccum] Specify using the last element of `array` as
  		   *  the initial value.
  		   * @returns {*} Returns the accumulated value.
  		   */
  		  function arrayReduceRight(array, iteratee, accumulator, initAccum) {
  		    var length = array == null ? 0 : array.length;
  		    if (initAccum && length) {
  		      accumulator = array[--length];
  		    }
  		    while (length--) {
  		      accumulator = iteratee(accumulator, array[length], length, array);
  		    }
  		    return accumulator;
  		  }

  		  /**
  		   * A specialized version of `_.some` for arrays without support for iteratee
  		   * shorthands.
  		   *
  		   * @private
  		   * @param {Array} [array] The array to iterate over.
  		   * @param {Function} predicate The function invoked per iteration.
  		   * @returns {boolean} Returns `true` if any element passes the predicate check,
  		   *  else `false`.
  		   */
  		  function arraySome(array, predicate) {
  		    var index = -1,
  		        length = array == null ? 0 : array.length;

  		    while (++index < length) {
  		      if (predicate(array[index], index, array)) {
  		        return true;
  		      }
  		    }
  		    return false;
  		  }

  		  /**
  		   * Gets the size of an ASCII `string`.
  		   *
  		   * @private
  		   * @param {string} string The string inspect.
  		   * @returns {number} Returns the string size.
  		   */
  		  var asciiSize = baseProperty('length');

  		  /**
  		   * Converts an ASCII `string` to an array.
  		   *
  		   * @private
  		   * @param {string} string The string to convert.
  		   * @returns {Array} Returns the converted array.
  		   */
  		  function asciiToArray(string) {
  		    return string.split('');
  		  }

  		  /**
  		   * Splits an ASCII `string` into an array of its words.
  		   *
  		   * @private
  		   * @param {string} The string to inspect.
  		   * @returns {Array} Returns the words of `string`.
  		   */
  		  function asciiWords(string) {
  		    return string.match(reAsciiWord) || [];
  		  }

  		  /**
  		   * The base implementation of methods like `_.findKey` and `_.findLastKey`,
  		   * without support for iteratee shorthands, which iterates over `collection`
  		   * using `eachFunc`.
  		   *
  		   * @private
  		   * @param {Array|Object} collection The collection to inspect.
  		   * @param {Function} predicate The function invoked per iteration.
  		   * @param {Function} eachFunc The function to iterate over `collection`.
  		   * @returns {*} Returns the found element or its key, else `undefined`.
  		   */
  		  function baseFindKey(collection, predicate, eachFunc) {
  		    var result;
  		    eachFunc(collection, function(value, key, collection) {
  		      if (predicate(value, key, collection)) {
  		        result = key;
  		        return false;
  		      }
  		    });
  		    return result;
  		  }

  		  /**
  		   * The base implementation of `_.findIndex` and `_.findLastIndex` without
  		   * support for iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {Function} predicate The function invoked per iteration.
  		   * @param {number} fromIndex The index to search from.
  		   * @param {boolean} [fromRight] Specify iterating from right to left.
  		   * @returns {number} Returns the index of the matched value, else `-1`.
  		   */
  		  function baseFindIndex(array, predicate, fromIndex, fromRight) {
  		    var length = array.length,
  		        index = fromIndex + (fromRight ? 1 : -1);

  		    while ((fromRight ? index-- : ++index < length)) {
  		      if (predicate(array[index], index, array)) {
  		        return index;
  		      }
  		    }
  		    return -1;
  		  }

  		  /**
  		   * The base implementation of `_.indexOf` without `fromIndex` bounds checks.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {*} value The value to search for.
  		   * @param {number} fromIndex The index to search from.
  		   * @returns {number} Returns the index of the matched value, else `-1`.
  		   */
  		  function baseIndexOf(array, value, fromIndex) {
  		    return value === value
  		      ? strictIndexOf(array, value, fromIndex)
  		      : baseFindIndex(array, baseIsNaN, fromIndex);
  		  }

  		  /**
  		   * This function is like `baseIndexOf` except that it accepts a comparator.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {*} value The value to search for.
  		   * @param {number} fromIndex The index to search from.
  		   * @param {Function} comparator The comparator invoked per element.
  		   * @returns {number} Returns the index of the matched value, else `-1`.
  		   */
  		  function baseIndexOfWith(array, value, fromIndex, comparator) {
  		    var index = fromIndex - 1,
  		        length = array.length;

  		    while (++index < length) {
  		      if (comparator(array[index], value)) {
  		        return index;
  		      }
  		    }
  		    return -1;
  		  }

  		  /**
  		   * The base implementation of `_.isNaN` without support for number objects.
  		   *
  		   * @private
  		   * @param {*} value The value to check.
  		   * @returns {boolean} Returns `true` if `value` is `NaN`, else `false`.
  		   */
  		  function baseIsNaN(value) {
  		    return value !== value;
  		  }

  		  /**
  		   * The base implementation of `_.mean` and `_.meanBy` without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} array The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {number} Returns the mean.
  		   */
  		  function baseMean(array, iteratee) {
  		    var length = array == null ? 0 : array.length;
  		    return length ? (baseSum(array, iteratee) / length) : NAN;
  		  }

  		  /**
  		   * The base implementation of `_.property` without support for deep paths.
  		   *
  		   * @private
  		   * @param {string} key The key of the property to get.
  		   * @returns {Function} Returns the new accessor function.
  		   */
  		  function baseProperty(key) {
  		    return function(object) {
  		      return object == null ? undefined$1 : object[key];
  		    };
  		  }

  		  /**
  		   * The base implementation of `_.propertyOf` without support for deep paths.
  		   *
  		   * @private
  		   * @param {Object} object The object to query.
  		   * @returns {Function} Returns the new accessor function.
  		   */
  		  function basePropertyOf(object) {
  		    return function(key) {
  		      return object == null ? undefined$1 : object[key];
  		    };
  		  }

  		  /**
  		   * The base implementation of `_.reduce` and `_.reduceRight`, without support
  		   * for iteratee shorthands, which iterates over `collection` using `eachFunc`.
  		   *
  		   * @private
  		   * @param {Array|Object} collection The collection to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @param {*} accumulator The initial value.
  		   * @param {boolean} initAccum Specify using the first or last element of
  		   *  `collection` as the initial value.
  		   * @param {Function} eachFunc The function to iterate over `collection`.
  		   * @returns {*} Returns the accumulated value.
  		   */
  		  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
  		    eachFunc(collection, function(value, index, collection) {
  		      accumulator = initAccum
  		        ? (initAccum = false, value)
  		        : iteratee(accumulator, value, index, collection);
  		    });
  		    return accumulator;
  		  }

  		  /**
  		   * The base implementation of `_.sortBy` which uses `comparer` to define the
  		   * sort order of `array` and replaces criteria objects with their corresponding
  		   * values.
  		   *
  		   * @private
  		   * @param {Array} array The array to sort.
  		   * @param {Function} comparer The function to define sort order.
  		   * @returns {Array} Returns `array`.
  		   */
  		  function baseSortBy(array, comparer) {
  		    var length = array.length;

  		    array.sort(comparer);
  		    while (length--) {
  		      array[length] = array[length].value;
  		    }
  		    return array;
  		  }

  		  /**
  		   * The base implementation of `_.sum` and `_.sumBy` without support for
  		   * iteratee shorthands.
  		   *
  		   * @private
  		   * @param {Array} array The array to iterate over.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {number} Returns the sum.
  		   */
  		  function baseSum(array, iteratee) {
  		    var result,
  		        index = -1,
  		        length = array.length;

  		    while (++index < length) {
  		      var current = iteratee(array[index]);
  		      if (current !== undefined$1) {
  		        result = result === undefined$1 ? current : (result + current);
  		      }
  		    }
  		    return result;
  		  }

  		  /**
  		   * The base implementation of `_.times` without support for iteratee shorthands
  		   * or max array length checks.
  		   *
  		   * @private
  		   * @param {number} n The number of times to invoke `iteratee`.
  		   * @param {Function} iteratee The function invoked per iteration.
  		   * @returns {Array} Returns the array of results.
  		   */
  		  function baseTimes(n, iteratee) {
  		    var index = -1,
  		        result = Array(n);

  		    while (++index < n) {
  		      result[index] = iteratee(index);
  		    }
  		    return result;
  		  }

  		  /**
  		   * The base implementation of `_.toPairs` and `_.toPairsIn` which creates an array
  		   * of key-value pairs for `object` corresponding to the property names of `props`.
  		   *
  		   * @private
  		   * @param {Object} object The object to query.
  		   * @param {Array} props The property names to get values for.
  		   * @returns {Object} Returns the key-value pairs.
  		   */
  		  function baseToPairs(object, props) {
  		    return arrayMap(props, function(key) {
  		      return [key, object[key]];
  		    });
  		  }

  		  /**
  		   * The base implementation of `_.trim`.
  		   *
  		   * @private
  		   * @param {string} string The string to trim.
  		   * @returns {string} Returns the trimmed string.
  		   */
  		  function baseTrim(string) {
  		    return string
  		      ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, '')
  		      : string;
  		  }

  		  /**
  		   * The base implementation of `_.unary` without support for storing metadata.
  		   *
  		   * @private
  		   * @param {Function} func The function to cap arguments for.
  		   * @returns {Function} Returns the new capped function.
  		   */
  		  function baseUnary(func) {
  		    return function(value) {
  		      return func(value);
  		    };
  		  }

  		  /**
  		   * The base implementation of `_.values` and `_.valuesIn` which creates an
  		   * array of `object` property values corresponding to the property names
  		   * of `props`.
  		   *
  		   * @private
  		   * @param {Object} object The object to query.
  		   * @param {Array} props The property names to get values for.
  		   * @returns {Object} Returns the array of property values.
  		   */
  		  function baseValues(object, props) {
  		    return arrayMap(props, function(key) {
  		      return object[key];
  		    });
  		  }

  		  /**
  		   * Checks if a `cache` value for `key` exists.
  		   *
  		   * @private
  		   * @param {Object} cache The cache to query.
  		   * @param {string} key The key of the entry to check.
  		   * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  		   */
  		  function cacheHas(cache, key) {
  		    return cache.has(key);
  		  }

  		  /**
  		   * Used by `_.trim` and `_.trimStart` to get the index of the first string symbol
  		   * that is not found in the character symbols.
  		   *
  		   * @private
  		   * @param {Array} strSymbols The string symbols to inspect.
  		   * @param {Array} chrSymbols The character symbols to find.
  		   * @returns {number} Returns the index of the first unmatched string symbol.
  		   */
  		  function charsStartIndex(strSymbols, chrSymbols) {
  		    var index = -1,
  		        length = strSymbols.length;

  		    while (++index < length && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
  		    return index;
  		  }

  		  /**
  		   * Used by `_.trim` and `_.trimEnd` to get the index of the last string symbol
  		   * that is not found in the character symbols.
  		   *
  		   * @private
  		   * @param {Array} strSymbols The string symbols to inspect.
  		   * @param {Array} chrSymbols The character symbols to find.
  		   * @returns {number} Returns the index of the last unmatched string symbol.
  		   */
  		  function charsEndIndex(strSymbols, chrSymbols) {
  		    var index = strSymbols.length;

  		    while (index-- && baseIndexOf(chrSymbols, strSymbols[index], 0) > -1) {}
  		    return index;
  		  }

  		  /**
  		   * Gets the number of `placeholder` occurrences in `array`.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {*} placeholder The placeholder to search for.
  		   * @returns {number} Returns the placeholder count.
  		   */
  		  function countHolders(array, placeholder) {
  		    var length = array.length,
  		        result = 0;

  		    while (length--) {
  		      if (array[length] === placeholder) {
  		        ++result;
  		      }
  		    }
  		    return result;
  		  }

  		  /**
  		   * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
  		   * letters to basic Latin letters.
  		   *
  		   * @private
  		   * @param {string} letter The matched letter to deburr.
  		   * @returns {string} Returns the deburred letter.
  		   */
  		  var deburrLetter = basePropertyOf(deburredLetters);

  		  /**
  		   * Used by `_.escape` to convert characters to HTML entities.
  		   *
  		   * @private
  		   * @param {string} chr The matched character to escape.
  		   * @returns {string} Returns the escaped character.
  		   */
  		  var escapeHtmlChar = basePropertyOf(htmlEscapes);

  		  /**
  		   * Used by `_.template` to escape characters for inclusion in compiled string literals.
  		   *
  		   * @private
  		   * @param {string} chr The matched character to escape.
  		   * @returns {string} Returns the escaped character.
  		   */
  		  function escapeStringChar(chr) {
  		    return '\\' + stringEscapes[chr];
  		  }

  		  /**
  		   * Gets the value at `key` of `object`.
  		   *
  		   * @private
  		   * @param {Object} [object] The object to query.
  		   * @param {string} key The key of the property to get.
  		   * @returns {*} Returns the property value.
  		   */
  		  function getValue(object, key) {
  		    return object == null ? undefined$1 : object[key];
  		  }

  		  /**
  		   * Checks if `string` contains Unicode symbols.
  		   *
  		   * @private
  		   * @param {string} string The string to inspect.
  		   * @returns {boolean} Returns `true` if a symbol is found, else `false`.
  		   */
  		  function hasUnicode(string) {
  		    return reHasUnicode.test(string);
  		  }

  		  /**
  		   * Checks if `string` contains a word composed of Unicode symbols.
  		   *
  		   * @private
  		   * @param {string} string The string to inspect.
  		   * @returns {boolean} Returns `true` if a word is found, else `false`.
  		   */
  		  function hasUnicodeWord(string) {
  		    return reHasUnicodeWord.test(string);
  		  }

  		  /**
  		   * Converts `iterator` to an array.
  		   *
  		   * @private
  		   * @param {Object} iterator The iterator to convert.
  		   * @returns {Array} Returns the converted array.
  		   */
  		  function iteratorToArray(iterator) {
  		    var data,
  		        result = [];

  		    while (!(data = iterator.next()).done) {
  		      result.push(data.value);
  		    }
  		    return result;
  		  }

  		  /**
  		   * Converts `map` to its key-value pairs.
  		   *
  		   * @private
  		   * @param {Object} map The map to convert.
  		   * @returns {Array} Returns the key-value pairs.
  		   */
  		  function mapToArray(map) {
  		    var index = -1,
  		        result = Array(map.size);

  		    map.forEach(function(value, key) {
  		      result[++index] = [key, value];
  		    });
  		    return result;
  		  }

  		  /**
  		   * Creates a unary function that invokes `func` with its argument transformed.
  		   *
  		   * @private
  		   * @param {Function} func The function to wrap.
  		   * @param {Function} transform The argument transform.
  		   * @returns {Function} Returns the new function.
  		   */
  		  function overArg(func, transform) {
  		    return function(arg) {
  		      return func(transform(arg));
  		    };
  		  }

  		  /**
  		   * Replaces all `placeholder` elements in `array` with an internal placeholder
  		   * and returns an array of their indexes.
  		   *
  		   * @private
  		   * @param {Array} array The array to modify.
  		   * @param {*} placeholder The placeholder to replace.
  		   * @returns {Array} Returns the new array of placeholder indexes.
  		   */
  		  function replaceHolders(array, placeholder) {
  		    var index = -1,
  		        length = array.length,
  		        resIndex = 0,
  		        result = [];

  		    while (++index < length) {
  		      var value = array[index];
  		      if (value === placeholder || value === PLACEHOLDER) {
  		        array[index] = PLACEHOLDER;
  		        result[resIndex++] = index;
  		      }
  		    }
  		    return result;
  		  }

  		  /**
  		   * Converts `set` to an array of its values.
  		   *
  		   * @private
  		   * @param {Object} set The set to convert.
  		   * @returns {Array} Returns the values.
  		   */
  		  function setToArray(set) {
  		    var index = -1,
  		        result = Array(set.size);

  		    set.forEach(function(value) {
  		      result[++index] = value;
  		    });
  		    return result;
  		  }

  		  /**
  		   * Converts `set` to its value-value pairs.
  		   *
  		   * @private
  		   * @param {Object} set The set to convert.
  		   * @returns {Array} Returns the value-value pairs.
  		   */
  		  function setToPairs(set) {
  		    var index = -1,
  		        result = Array(set.size);

  		    set.forEach(function(value) {
  		      result[++index] = [value, value];
  		    });
  		    return result;
  		  }

  		  /**
  		   * A specialized version of `_.indexOf` which performs strict equality
  		   * comparisons of values, i.e. `===`.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {*} value The value to search for.
  		   * @param {number} fromIndex The index to search from.
  		   * @returns {number} Returns the index of the matched value, else `-1`.
  		   */
  		  function strictIndexOf(array, value, fromIndex) {
  		    var index = fromIndex - 1,
  		        length = array.length;

  		    while (++index < length) {
  		      if (array[index] === value) {
  		        return index;
  		      }
  		    }
  		    return -1;
  		  }

  		  /**
  		   * A specialized version of `_.lastIndexOf` which performs strict equality
  		   * comparisons of values, i.e. `===`.
  		   *
  		   * @private
  		   * @param {Array} array The array to inspect.
  		   * @param {*} value The value to search for.
  		   * @param {number} fromIndex The index to search from.
  		   * @returns {number} Returns the index of the matched value, else `-1`.
  		   */
  		  function strictLastIndexOf(array, value, fromIndex) {
  		    var index = fromIndex + 1;
  		    while (index--) {
  		      if (array[index] === value) {
  		        return index;
  		      }
  		    }
  		    return index;
  		  }

  		  /**
  		   * Gets the number of symbols in `string`.
  		   *
  		   * @private
  		   * @param {string} string The string to inspect.
  		   * @returns {number} Returns the string size.
  		   */
  		  function stringSize(string) {
  		    return hasUnicode(string)
  		      ? unicodeSize(string)
  		      : asciiSize(string);
  		  }

  		  /**
  		   * Converts `string` to an array.
  		   *
  		   * @private
  		   * @param {string} string The string to convert.
  		   * @returns {Array} Returns the converted array.
  		   */
  		  function stringToArray(string) {
  		    return hasUnicode(string)
  		      ? unicodeToArray(string)
  		      : asciiToArray(string);
  		  }

  		  /**
  		   * Used by `_.trim` and `_.trimEnd` to get the index of the last non-whitespace
  		   * character of `string`.
  		   *
  		   * @private
  		   * @param {string} string The string to inspect.
  		   * @returns {number} Returns the index of the last non-whitespace character.
  		   */
  		  function trimmedEndIndex(string) {
  		    var index = string.length;

  		    while (index-- && reWhitespace.test(string.charAt(index))) {}
  		    return index;
  		  }

  		  /**
  		   * Used by `_.unescape` to convert HTML entities to characters.
  		   *
  		   * @private
  		   * @param {string} chr The matched character to unescape.
  		   * @returns {string} Returns the unescaped character.
  		   */
  		  var unescapeHtmlChar = basePropertyOf(htmlUnescapes);

  		  /**
  		   * Gets the size of a Unicode `string`.
  		   *
  		   * @private
  		   * @param {string} string The string inspect.
  		   * @returns {number} Returns the string size.
  		   */
  		  function unicodeSize(string) {
  		    var result = reUnicode.lastIndex = 0;
  		    while (reUnicode.test(string)) {
  		      ++result;
  		    }
  		    return result;
  		  }

  		  /**
  		   * Converts a Unicode `string` to an array.
  		   *
  		   * @private
  		   * @param {string} string The string to convert.
  		   * @returns {Array} Returns the converted array.
  		   */
  		  function unicodeToArray(string) {
  		    return string.match(reUnicode) || [];
  		  }

  		  /**
  		   * Splits a Unicode `string` into an array of its words.
  		   *
  		   * @private
  		   * @param {string} The string to inspect.
  		   * @returns {Array} Returns the words of `string`.
  		   */
  		  function unicodeWords(string) {
  		    return string.match(reUnicodeWord) || [];
  		  }

  		  /*--------------------------------------------------------------------------*/

  		  /**
  		   * Create a new pristine `lodash` function using the `context` object.
  		   *
  		   * @static
  		   * @memberOf _
  		   * @since 1.1.0
  		   * @category Util
  		   * @param {Object} [context=root] The context object.
  		   * @returns {Function} Returns a new `lodash` function.
  		   * @example
  		   *
  		   * _.mixin({ 'foo': _.constant('foo') });
  		   *
  		   * var lodash = _.runInContext();
  		   * lodash.mixin({ 'bar': lodash.constant('bar') });
  		   *
  		   * _.isFunction(_.foo);
  		   * // => true
  		   * _.isFunction(_.bar);
  		   * // => false
  		   *
  		   * lodash.isFunction(lodash.foo);
  		   * // => false
  		   * lodash.isFunction(lodash.bar);
  		   * // => true
  		   *
  		   * // Create a suped-up `defer` in Node.js.
  		   * var defer = _.runInContext({ 'setTimeout': setImmediate }).defer;
  		   */
  		  var runInContext = (function runInContext(context) {
  		    context = context == null ? root : _.defaults(root.Object(), context, _.pick(root, contextProps));

  		    /** Built-in constructor references. */
  		    var Array = context.Array,
  		        Date = context.Date,
  		        Error = context.Error,
  		        Function = context.Function,
  		        Math = context.Math,
  		        Object = context.Object,
  		        RegExp = context.RegExp,
  		        String = context.String,
  		        TypeError = context.TypeError;

  		    /** Used for built-in method references. */
  		    var arrayProto = Array.prototype,
  		        funcProto = Function.prototype,
  		        objectProto = Object.prototype;

  		    /** Used to detect overreaching core-js shims. */
  		    var coreJsData = context['__core-js_shared__'];

  		    /** Used to resolve the decompiled source of functions. */
  		    var funcToString = funcProto.toString;

  		    /** Used to check objects for own properties. */
  		    var hasOwnProperty = objectProto.hasOwnProperty;

  		    /** Used to generate unique IDs. */
  		    var idCounter = 0;

  		    /** Used to detect methods masquerading as native. */
  		    var maskSrcKey = (function() {
  		      var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
  		      return uid ? ('Symbol(src)_1.' + uid) : '';
  		    }());

  		    /**
  		     * Used to resolve the
  		     * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
  		     * of values.
  		     */
  		    var nativeObjectToString = objectProto.toString;

  		    /** Used to infer the `Object` constructor. */
  		    var objectCtorString = funcToString.call(Object);

  		    /** Used to restore the original `_` reference in `_.noConflict`. */
  		    var oldDash = root._;

  		    /** Used to detect if a method is native. */
  		    var reIsNative = RegExp('^' +
  		      funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
  		      .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
  		    );

  		    /** Built-in value references. */
  		    var Buffer = moduleExports ? context.Buffer : undefined$1,
  		        Symbol = context.Symbol,
  		        Uint8Array = context.Uint8Array,
  		        allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined$1,
  		        getPrototype = overArg(Object.getPrototypeOf, Object),
  		        objectCreate = Object.create,
  		        propertyIsEnumerable = objectProto.propertyIsEnumerable,
  		        splice = arrayProto.splice,
  		        spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined$1,
  		        symIterator = Symbol ? Symbol.iterator : undefined$1,
  		        symToStringTag = Symbol ? Symbol.toStringTag : undefined$1;

  		    var defineProperty = (function() {
  		      try {
  		        var func = getNative(Object, 'defineProperty');
  		        func({}, '', {});
  		        return func;
  		      } catch (e) {}
  		    }());

  		    /** Mocked built-ins. */
  		    var ctxClearTimeout = context.clearTimeout !== root.clearTimeout && context.clearTimeout,
  		        ctxNow = Date && Date.now !== root.Date.now && Date.now,
  		        ctxSetTimeout = context.setTimeout !== root.setTimeout && context.setTimeout;

  		    /* Built-in method references for those with the same name as other `lodash` methods. */
  		    var nativeCeil = Math.ceil,
  		        nativeFloor = Math.floor,
  		        nativeGetSymbols = Object.getOwnPropertySymbols,
  		        nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined$1,
  		        nativeIsFinite = context.isFinite,
  		        nativeJoin = arrayProto.join,
  		        nativeKeys = overArg(Object.keys, Object),
  		        nativeMax = Math.max,
  		        nativeMin = Math.min,
  		        nativeNow = Date.now,
  		        nativeParseInt = context.parseInt,
  		        nativeRandom = Math.random,
  		        nativeReverse = arrayProto.reverse;

  		    /* Built-in method references that are verified to be native. */
  		    var DataView = getNative(context, 'DataView'),
  		        Map = getNative(context, 'Map'),
  		        Promise = getNative(context, 'Promise'),
  		        Set = getNative(context, 'Set'),
  		        WeakMap = getNative(context, 'WeakMap'),
  		        nativeCreate = getNative(Object, 'create');

  		    /** Used to store function metadata. */
  		    var metaMap = WeakMap && new WeakMap;

  		    /** Used to lookup unminified function names. */
  		    var realNames = {};

  		    /** Used to detect maps, sets, and weakmaps. */
  		    var dataViewCtorString = toSource(DataView),
  		        mapCtorString = toSource(Map),
  		        promiseCtorString = toSource(Promise),
  		        setCtorString = toSource(Set),
  		        weakMapCtorString = toSource(WeakMap);

  		    /** Used to convert symbols to primitives and strings. */
  		    var symbolProto = Symbol ? Symbol.prototype : undefined$1,
  		        symbolValueOf = symbolProto ? symbolProto.valueOf : undefined$1,
  		        symbolToString = symbolProto ? symbolProto.toString : undefined$1;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a `lodash` object which wraps `value` to enable implicit method
  		     * chain sequences. Methods that operate on and return arrays, collections,
  		     * and functions can be chained together. Methods that retrieve a single value
  		     * or may return a primitive value will automatically end the chain sequence
  		     * and return the unwrapped value. Otherwise, the value must be unwrapped
  		     * with `_#value`.
  		     *
  		     * Explicit chain sequences, which must be unwrapped with `_#value`, may be
  		     * enabled using `_.chain`.
  		     *
  		     * The execution of chained methods is lazy, that is, it's deferred until
  		     * `_#value` is implicitly or explicitly called.
  		     *
  		     * Lazy evaluation allows several methods to support shortcut fusion.
  		     * Shortcut fusion is an optimization to merge iteratee calls; this avoids
  		     * the creation of intermediate arrays and can greatly reduce the number of
  		     * iteratee executions. Sections of a chain sequence qualify for shortcut
  		     * fusion if the section is applied to an array and iteratees accept only
  		     * one argument. The heuristic for whether a section qualifies for shortcut
  		     * fusion is subject to change.
  		     *
  		     * Chaining is supported in custom builds as long as the `_#value` method is
  		     * directly or indirectly included in the build.
  		     *
  		     * In addition to lodash methods, wrappers have `Array` and `String` methods.
  		     *
  		     * The wrapper `Array` methods are:
  		     * `concat`, `join`, `pop`, `push`, `shift`, `sort`, `splice`, and `unshift`
  		     *
  		     * The wrapper `String` methods are:
  		     * `replace` and `split`
  		     *
  		     * The wrapper methods that support shortcut fusion are:
  		     * `at`, `compact`, `drop`, `dropRight`, `dropWhile`, `filter`, `find`,
  		     * `findLast`, `head`, `initial`, `last`, `map`, `reject`, `reverse`, `slice`,
  		     * `tail`, `take`, `takeRight`, `takeRightWhile`, `takeWhile`, and `toArray`
  		     *
  		     * The chainable wrapper methods are:
  		     * `after`, `ary`, `assign`, `assignIn`, `assignInWith`, `assignWith`, `at`,
  		     * `before`, `bind`, `bindAll`, `bindKey`, `castArray`, `chain`, `chunk`,
  		     * `commit`, `compact`, `concat`, `conforms`, `constant`, `countBy`, `create`,
  		     * `curry`, `debounce`, `defaults`, `defaultsDeep`, `defer`, `delay`,
  		     * `difference`, `differenceBy`, `differenceWith`, `drop`, `dropRight`,
  		     * `dropRightWhile`, `dropWhile`, `extend`, `extendWith`, `fill`, `filter`,
  		     * `flatMap`, `flatMapDeep`, `flatMapDepth`, `flatten`, `flattenDeep`,
  		     * `flattenDepth`, `flip`, `flow`, `flowRight`, `fromPairs`, `functions`,
  		     * `functionsIn`, `groupBy`, `initial`, `intersection`, `intersectionBy`,
  		     * `intersectionWith`, `invert`, `invertBy`, `invokeMap`, `iteratee`, `keyBy`,
  		     * `keys`, `keysIn`, `map`, `mapKeys`, `mapValues`, `matches`, `matchesProperty`,
  		     * `memoize`, `merge`, `mergeWith`, `method`, `methodOf`, `mixin`, `negate`,
  		     * `nthArg`, `omit`, `omitBy`, `once`, `orderBy`, `over`, `overArgs`,
  		     * `overEvery`, `overSome`, `partial`, `partialRight`, `partition`, `pick`,
  		     * `pickBy`, `plant`, `property`, `propertyOf`, `pull`, `pullAll`, `pullAllBy`,
  		     * `pullAllWith`, `pullAt`, `push`, `range`, `rangeRight`, `rearg`, `reject`,
  		     * `remove`, `rest`, `reverse`, `sampleSize`, `set`, `setWith`, `shuffle`,
  		     * `slice`, `sort`, `sortBy`, `splice`, `spread`, `tail`, `take`, `takeRight`,
  		     * `takeRightWhile`, `takeWhile`, `tap`, `throttle`, `thru`, `toArray`,
  		     * `toPairs`, `toPairsIn`, `toPath`, `toPlainObject`, `transform`, `unary`,
  		     * `union`, `unionBy`, `unionWith`, `uniq`, `uniqBy`, `uniqWith`, `unset`,
  		     * `unshift`, `unzip`, `unzipWith`, `update`, `updateWith`, `values`,
  		     * `valuesIn`, `without`, `wrap`, `xor`, `xorBy`, `xorWith`, `zip`,
  		     * `zipObject`, `zipObjectDeep`, and `zipWith`
  		     *
  		     * The wrapper methods that are **not** chainable by default are:
  		     * `add`, `attempt`, `camelCase`, `capitalize`, `ceil`, `clamp`, `clone`,
  		     * `cloneDeep`, `cloneDeepWith`, `cloneWith`, `conformsTo`, `deburr`,
  		     * `defaultTo`, `divide`, `each`, `eachRight`, `endsWith`, `eq`, `escape`,
  		     * `escapeRegExp`, `every`, `find`, `findIndex`, `findKey`, `findLast`,
  		     * `findLastIndex`, `findLastKey`, `first`, `floor`, `forEach`, `forEachRight`,
  		     * `forIn`, `forInRight`, `forOwn`, `forOwnRight`, `get`, `gt`, `gte`, `has`,
  		     * `hasIn`, `head`, `identity`, `includes`, `indexOf`, `inRange`, `invoke`,
  		     * `isArguments`, `isArray`, `isArrayBuffer`, `isArrayLike`, `isArrayLikeObject`,
  		     * `isBoolean`, `isBuffer`, `isDate`, `isElement`, `isEmpty`, `isEqual`,
  		     * `isEqualWith`, `isError`, `isFinite`, `isFunction`, `isInteger`, `isLength`,
  		     * `isMap`, `isMatch`, `isMatchWith`, `isNaN`, `isNative`, `isNil`, `isNull`,
  		     * `isNumber`, `isObject`, `isObjectLike`, `isPlainObject`, `isRegExp`,
  		     * `isSafeInteger`, `isSet`, `isString`, `isUndefined`, `isTypedArray`,
  		     * `isWeakMap`, `isWeakSet`, `join`, `kebabCase`, `last`, `lastIndexOf`,
  		     * `lowerCase`, `lowerFirst`, `lt`, `lte`, `max`, `maxBy`, `mean`, `meanBy`,
  		     * `min`, `minBy`, `multiply`, `noConflict`, `noop`, `now`, `nth`, `pad`,
  		     * `padEnd`, `padStart`, `parseInt`, `pop`, `random`, `reduce`, `reduceRight`,
  		     * `repeat`, `result`, `round`, `runInContext`, `sample`, `shift`, `size`,
  		     * `snakeCase`, `some`, `sortedIndex`, `sortedIndexBy`, `sortedLastIndex`,
  		     * `sortedLastIndexBy`, `startCase`, `startsWith`, `stubArray`, `stubFalse`,
  		     * `stubObject`, `stubString`, `stubTrue`, `subtract`, `sum`, `sumBy`,
  		     * `template`, `times`, `toFinite`, `toInteger`, `toJSON`, `toLength`,
  		     * `toLower`, `toNumber`, `toSafeInteger`, `toString`, `toUpper`, `trim`,
  		     * `trimEnd`, `trimStart`, `truncate`, `unescape`, `uniqueId`, `upperCase`,
  		     * `upperFirst`, `value`, and `words`
  		     *
  		     * @name _
  		     * @constructor
  		     * @category Seq
  		     * @param {*} value The value to wrap in a `lodash` instance.
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * function square(n) {
  		     *   return n * n;
  		     * }
  		     *
  		     * var wrapped = _([1, 2, 3]);
  		     *
  		     * // Returns an unwrapped value.
  		     * wrapped.reduce(_.add);
  		     * // => 6
  		     *
  		     * // Returns a wrapped value.
  		     * var squares = wrapped.map(square);
  		     *
  		     * _.isArray(squares);
  		     * // => false
  		     *
  		     * _.isArray(squares.value());
  		     * // => true
  		     */
  		    function lodash(value) {
  		      if (isObjectLike(value) && !isArray(value) && !(value instanceof LazyWrapper)) {
  		        if (value instanceof LodashWrapper) {
  		          return value;
  		        }
  		        if (hasOwnProperty.call(value, '__wrapped__')) {
  		          return wrapperClone(value);
  		        }
  		      }
  		      return new LodashWrapper(value);
  		    }

  		    /**
  		     * The base implementation of `_.create` without support for assigning
  		     * properties to the created object.
  		     *
  		     * @private
  		     * @param {Object} proto The object to inherit from.
  		     * @returns {Object} Returns the new object.
  		     */
  		    var baseCreate = (function() {
  		      function object() {}
  		      return function(proto) {
  		        if (!isObject(proto)) {
  		          return {};
  		        }
  		        if (objectCreate) {
  		          return objectCreate(proto);
  		        }
  		        object.prototype = proto;
  		        var result = new object;
  		        object.prototype = undefined$1;
  		        return result;
  		      };
  		    }());

  		    /**
  		     * The function whose prototype chain sequence wrappers inherit from.
  		     *
  		     * @private
  		     */
  		    function baseLodash() {
  		      // No operation performed.
  		    }

  		    /**
  		     * The base constructor for creating `lodash` wrapper objects.
  		     *
  		     * @private
  		     * @param {*} value The value to wrap.
  		     * @param {boolean} [chainAll] Enable explicit method chain sequences.
  		     */
  		    function LodashWrapper(value, chainAll) {
  		      this.__wrapped__ = value;
  		      this.__actions__ = [];
  		      this.__chain__ = !!chainAll;
  		      this.__index__ = 0;
  		      this.__values__ = undefined$1;
  		    }

  		    /**
  		     * By default, the template delimiters used by lodash are like those in
  		     * embedded Ruby (ERB) as well as ES2015 template strings. Change the
  		     * following template settings to use alternative delimiters.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @type {Object}
  		     */
  		    lodash.templateSettings = {

  		      /**
  		       * Used to detect `data` property values to be HTML-escaped.
  		       *
  		       * @memberOf _.templateSettings
  		       * @type {RegExp}
  		       */
  		      'escape': reEscape,

  		      /**
  		       * Used to detect code to be evaluated.
  		       *
  		       * @memberOf _.templateSettings
  		       * @type {RegExp}
  		       */
  		      'evaluate': reEvaluate,

  		      /**
  		       * Used to detect `data` property values to inject.
  		       *
  		       * @memberOf _.templateSettings
  		       * @type {RegExp}
  		       */
  		      'interpolate': reInterpolate,

  		      /**
  		       * Used to reference the data object in the template text.
  		       *
  		       * @memberOf _.templateSettings
  		       * @type {string}
  		       */
  		      'variable': '',

  		      /**
  		       * Used to import variables into the compiled template.
  		       *
  		       * @memberOf _.templateSettings
  		       * @type {Object}
  		       */
  		      'imports': {

  		        /**
  		         * A reference to the `lodash` function.
  		         *
  		         * @memberOf _.templateSettings.imports
  		         * @type {Function}
  		         */
  		        '_': lodash
  		      }
  		    };

  		    // Ensure wrappers are instances of `baseLodash`.
  		    lodash.prototype = baseLodash.prototype;
  		    lodash.prototype.constructor = lodash;

  		    LodashWrapper.prototype = baseCreate(baseLodash.prototype);
  		    LodashWrapper.prototype.constructor = LodashWrapper;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a lazy wrapper object which wraps `value` to enable lazy evaluation.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {*} value The value to wrap.
  		     */
  		    function LazyWrapper(value) {
  		      this.__wrapped__ = value;
  		      this.__actions__ = [];
  		      this.__dir__ = 1;
  		      this.__filtered__ = false;
  		      this.__iteratees__ = [];
  		      this.__takeCount__ = MAX_ARRAY_LENGTH;
  		      this.__views__ = [];
  		    }

  		    /**
  		     * Creates a clone of the lazy wrapper object.
  		     *
  		     * @private
  		     * @name clone
  		     * @memberOf LazyWrapper
  		     * @returns {Object} Returns the cloned `LazyWrapper` object.
  		     */
  		    function lazyClone() {
  		      var result = new LazyWrapper(this.__wrapped__);
  		      result.__actions__ = copyArray(this.__actions__);
  		      result.__dir__ = this.__dir__;
  		      result.__filtered__ = this.__filtered__;
  		      result.__iteratees__ = copyArray(this.__iteratees__);
  		      result.__takeCount__ = this.__takeCount__;
  		      result.__views__ = copyArray(this.__views__);
  		      return result;
  		    }

  		    /**
  		     * Reverses the direction of lazy iteration.
  		     *
  		     * @private
  		     * @name reverse
  		     * @memberOf LazyWrapper
  		     * @returns {Object} Returns the new reversed `LazyWrapper` object.
  		     */
  		    function lazyReverse() {
  		      if (this.__filtered__) {
  		        var result = new LazyWrapper(this);
  		        result.__dir__ = -1;
  		        result.__filtered__ = true;
  		      } else {
  		        result = this.clone();
  		        result.__dir__ *= -1;
  		      }
  		      return result;
  		    }

  		    /**
  		     * Extracts the unwrapped value from its lazy wrapper.
  		     *
  		     * @private
  		     * @name value
  		     * @memberOf LazyWrapper
  		     * @returns {*} Returns the unwrapped value.
  		     */
  		    function lazyValue() {
  		      var array = this.__wrapped__.value(),
  		          dir = this.__dir__,
  		          isArr = isArray(array),
  		          isRight = dir < 0,
  		          arrLength = isArr ? array.length : 0,
  		          view = getView(0, arrLength, this.__views__),
  		          start = view.start,
  		          end = view.end,
  		          length = end - start,
  		          index = isRight ? end : (start - 1),
  		          iteratees = this.__iteratees__,
  		          iterLength = iteratees.length,
  		          resIndex = 0,
  		          takeCount = nativeMin(length, this.__takeCount__);

  		      if (!isArr || (!isRight && arrLength == length && takeCount == length)) {
  		        return baseWrapperValue(array, this.__actions__);
  		      }
  		      var result = [];

  		      outer:
  		      while (length-- && resIndex < takeCount) {
  		        index += dir;

  		        var iterIndex = -1,
  		            value = array[index];

  		        while (++iterIndex < iterLength) {
  		          var data = iteratees[iterIndex],
  		              iteratee = data.iteratee,
  		              type = data.type,
  		              computed = iteratee(value);

  		          if (type == LAZY_MAP_FLAG) {
  		            value = computed;
  		          } else if (!computed) {
  		            if (type == LAZY_FILTER_FLAG) {
  		              continue outer;
  		            } else {
  		              break outer;
  		            }
  		          }
  		        }
  		        result[resIndex++] = value;
  		      }
  		      return result;
  		    }

  		    // Ensure `LazyWrapper` is an instance of `baseLodash`.
  		    LazyWrapper.prototype = baseCreate(baseLodash.prototype);
  		    LazyWrapper.prototype.constructor = LazyWrapper;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a hash object.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {Array} [entries] The key-value pairs to cache.
  		     */
  		    function Hash(entries) {
  		      var index = -1,
  		          length = entries == null ? 0 : entries.length;

  		      this.clear();
  		      while (++index < length) {
  		        var entry = entries[index];
  		        this.set(entry[0], entry[1]);
  		      }
  		    }

  		    /**
  		     * Removes all key-value entries from the hash.
  		     *
  		     * @private
  		     * @name clear
  		     * @memberOf Hash
  		     */
  		    function hashClear() {
  		      this.__data__ = nativeCreate ? nativeCreate(null) : {};
  		      this.size = 0;
  		    }

  		    /**
  		     * Removes `key` and its value from the hash.
  		     *
  		     * @private
  		     * @name delete
  		     * @memberOf Hash
  		     * @param {Object} hash The hash to modify.
  		     * @param {string} key The key of the value to remove.
  		     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  		     */
  		    function hashDelete(key) {
  		      var result = this.has(key) && delete this.__data__[key];
  		      this.size -= result ? 1 : 0;
  		      return result;
  		    }

  		    /**
  		     * Gets the hash value for `key`.
  		     *
  		     * @private
  		     * @name get
  		     * @memberOf Hash
  		     * @param {string} key The key of the value to get.
  		     * @returns {*} Returns the entry value.
  		     */
  		    function hashGet(key) {
  		      var data = this.__data__;
  		      if (nativeCreate) {
  		        var result = data[key];
  		        return result === HASH_UNDEFINED ? undefined$1 : result;
  		      }
  		      return hasOwnProperty.call(data, key) ? data[key] : undefined$1;
  		    }

  		    /**
  		     * Checks if a hash value for `key` exists.
  		     *
  		     * @private
  		     * @name has
  		     * @memberOf Hash
  		     * @param {string} key The key of the entry to check.
  		     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  		     */
  		    function hashHas(key) {
  		      var data = this.__data__;
  		      return nativeCreate ? (data[key] !== undefined$1) : hasOwnProperty.call(data, key);
  		    }

  		    /**
  		     * Sets the hash `key` to `value`.
  		     *
  		     * @private
  		     * @name set
  		     * @memberOf Hash
  		     * @param {string} key The key of the value to set.
  		     * @param {*} value The value to set.
  		     * @returns {Object} Returns the hash instance.
  		     */
  		    function hashSet(key, value) {
  		      var data = this.__data__;
  		      this.size += this.has(key) ? 0 : 1;
  		      data[key] = (nativeCreate && value === undefined$1) ? HASH_UNDEFINED : value;
  		      return this;
  		    }

  		    // Add methods to `Hash`.
  		    Hash.prototype.clear = hashClear;
  		    Hash.prototype['delete'] = hashDelete;
  		    Hash.prototype.get = hashGet;
  		    Hash.prototype.has = hashHas;
  		    Hash.prototype.set = hashSet;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates an list cache object.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {Array} [entries] The key-value pairs to cache.
  		     */
  		    function ListCache(entries) {
  		      var index = -1,
  		          length = entries == null ? 0 : entries.length;

  		      this.clear();
  		      while (++index < length) {
  		        var entry = entries[index];
  		        this.set(entry[0], entry[1]);
  		      }
  		    }

  		    /**
  		     * Removes all key-value entries from the list cache.
  		     *
  		     * @private
  		     * @name clear
  		     * @memberOf ListCache
  		     */
  		    function listCacheClear() {
  		      this.__data__ = [];
  		      this.size = 0;
  		    }

  		    /**
  		     * Removes `key` and its value from the list cache.
  		     *
  		     * @private
  		     * @name delete
  		     * @memberOf ListCache
  		     * @param {string} key The key of the value to remove.
  		     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  		     */
  		    function listCacheDelete(key) {
  		      var data = this.__data__,
  		          index = assocIndexOf(data, key);

  		      if (index < 0) {
  		        return false;
  		      }
  		      var lastIndex = data.length - 1;
  		      if (index == lastIndex) {
  		        data.pop();
  		      } else {
  		        splice.call(data, index, 1);
  		      }
  		      --this.size;
  		      return true;
  		    }

  		    /**
  		     * Gets the list cache value for `key`.
  		     *
  		     * @private
  		     * @name get
  		     * @memberOf ListCache
  		     * @param {string} key The key of the value to get.
  		     * @returns {*} Returns the entry value.
  		     */
  		    function listCacheGet(key) {
  		      var data = this.__data__,
  		          index = assocIndexOf(data, key);

  		      return index < 0 ? undefined$1 : data[index][1];
  		    }

  		    /**
  		     * Checks if a list cache value for `key` exists.
  		     *
  		     * @private
  		     * @name has
  		     * @memberOf ListCache
  		     * @param {string} key The key of the entry to check.
  		     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  		     */
  		    function listCacheHas(key) {
  		      return assocIndexOf(this.__data__, key) > -1;
  		    }

  		    /**
  		     * Sets the list cache `key` to `value`.
  		     *
  		     * @private
  		     * @name set
  		     * @memberOf ListCache
  		     * @param {string} key The key of the value to set.
  		     * @param {*} value The value to set.
  		     * @returns {Object} Returns the list cache instance.
  		     */
  		    function listCacheSet(key, value) {
  		      var data = this.__data__,
  		          index = assocIndexOf(data, key);

  		      if (index < 0) {
  		        ++this.size;
  		        data.push([key, value]);
  		      } else {
  		        data[index][1] = value;
  		      }
  		      return this;
  		    }

  		    // Add methods to `ListCache`.
  		    ListCache.prototype.clear = listCacheClear;
  		    ListCache.prototype['delete'] = listCacheDelete;
  		    ListCache.prototype.get = listCacheGet;
  		    ListCache.prototype.has = listCacheHas;
  		    ListCache.prototype.set = listCacheSet;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a map cache object to store key-value pairs.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {Array} [entries] The key-value pairs to cache.
  		     */
  		    function MapCache(entries) {
  		      var index = -1,
  		          length = entries == null ? 0 : entries.length;

  		      this.clear();
  		      while (++index < length) {
  		        var entry = entries[index];
  		        this.set(entry[0], entry[1]);
  		      }
  		    }

  		    /**
  		     * Removes all key-value entries from the map.
  		     *
  		     * @private
  		     * @name clear
  		     * @memberOf MapCache
  		     */
  		    function mapCacheClear() {
  		      this.size = 0;
  		      this.__data__ = {
  		        'hash': new Hash,
  		        'map': new (Map || ListCache),
  		        'string': new Hash
  		      };
  		    }

  		    /**
  		     * Removes `key` and its value from the map.
  		     *
  		     * @private
  		     * @name delete
  		     * @memberOf MapCache
  		     * @param {string} key The key of the value to remove.
  		     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  		     */
  		    function mapCacheDelete(key) {
  		      var result = getMapData(this, key)['delete'](key);
  		      this.size -= result ? 1 : 0;
  		      return result;
  		    }

  		    /**
  		     * Gets the map value for `key`.
  		     *
  		     * @private
  		     * @name get
  		     * @memberOf MapCache
  		     * @param {string} key The key of the value to get.
  		     * @returns {*} Returns the entry value.
  		     */
  		    function mapCacheGet(key) {
  		      return getMapData(this, key).get(key);
  		    }

  		    /**
  		     * Checks if a map value for `key` exists.
  		     *
  		     * @private
  		     * @name has
  		     * @memberOf MapCache
  		     * @param {string} key The key of the entry to check.
  		     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  		     */
  		    function mapCacheHas(key) {
  		      return getMapData(this, key).has(key);
  		    }

  		    /**
  		     * Sets the map `key` to `value`.
  		     *
  		     * @private
  		     * @name set
  		     * @memberOf MapCache
  		     * @param {string} key The key of the value to set.
  		     * @param {*} value The value to set.
  		     * @returns {Object} Returns the map cache instance.
  		     */
  		    function mapCacheSet(key, value) {
  		      var data = getMapData(this, key),
  		          size = data.size;

  		      data.set(key, value);
  		      this.size += data.size == size ? 0 : 1;
  		      return this;
  		    }

  		    // Add methods to `MapCache`.
  		    MapCache.prototype.clear = mapCacheClear;
  		    MapCache.prototype['delete'] = mapCacheDelete;
  		    MapCache.prototype.get = mapCacheGet;
  		    MapCache.prototype.has = mapCacheHas;
  		    MapCache.prototype.set = mapCacheSet;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     *
  		     * Creates an array cache object to store unique values.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {Array} [values] The values to cache.
  		     */
  		    function SetCache(values) {
  		      var index = -1,
  		          length = values == null ? 0 : values.length;

  		      this.__data__ = new MapCache;
  		      while (++index < length) {
  		        this.add(values[index]);
  		      }
  		    }

  		    /**
  		     * Adds `value` to the array cache.
  		     *
  		     * @private
  		     * @name add
  		     * @memberOf SetCache
  		     * @alias push
  		     * @param {*} value The value to cache.
  		     * @returns {Object} Returns the cache instance.
  		     */
  		    function setCacheAdd(value) {
  		      this.__data__.set(value, HASH_UNDEFINED);
  		      return this;
  		    }

  		    /**
  		     * Checks if `value` is in the array cache.
  		     *
  		     * @private
  		     * @name has
  		     * @memberOf SetCache
  		     * @param {*} value The value to search for.
  		     * @returns {number} Returns `true` if `value` is found, else `false`.
  		     */
  		    function setCacheHas(value) {
  		      return this.__data__.has(value);
  		    }

  		    // Add methods to `SetCache`.
  		    SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  		    SetCache.prototype.has = setCacheHas;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a stack cache object to store key-value pairs.
  		     *
  		     * @private
  		     * @constructor
  		     * @param {Array} [entries] The key-value pairs to cache.
  		     */
  		    function Stack(entries) {
  		      var data = this.__data__ = new ListCache(entries);
  		      this.size = data.size;
  		    }

  		    /**
  		     * Removes all key-value entries from the stack.
  		     *
  		     * @private
  		     * @name clear
  		     * @memberOf Stack
  		     */
  		    function stackClear() {
  		      this.__data__ = new ListCache;
  		      this.size = 0;
  		    }

  		    /**
  		     * Removes `key` and its value from the stack.
  		     *
  		     * @private
  		     * @name delete
  		     * @memberOf Stack
  		     * @param {string} key The key of the value to remove.
  		     * @returns {boolean} Returns `true` if the entry was removed, else `false`.
  		     */
  		    function stackDelete(key) {
  		      var data = this.__data__,
  		          result = data['delete'](key);

  		      this.size = data.size;
  		      return result;
  		    }

  		    /**
  		     * Gets the stack value for `key`.
  		     *
  		     * @private
  		     * @name get
  		     * @memberOf Stack
  		     * @param {string} key The key of the value to get.
  		     * @returns {*} Returns the entry value.
  		     */
  		    function stackGet(key) {
  		      return this.__data__.get(key);
  		    }

  		    /**
  		     * Checks if a stack value for `key` exists.
  		     *
  		     * @private
  		     * @name has
  		     * @memberOf Stack
  		     * @param {string} key The key of the entry to check.
  		     * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
  		     */
  		    function stackHas(key) {
  		      return this.__data__.has(key);
  		    }

  		    /**
  		     * Sets the stack `key` to `value`.
  		     *
  		     * @private
  		     * @name set
  		     * @memberOf Stack
  		     * @param {string} key The key of the value to set.
  		     * @param {*} value The value to set.
  		     * @returns {Object} Returns the stack cache instance.
  		     */
  		    function stackSet(key, value) {
  		      var data = this.__data__;
  		      if (data instanceof ListCache) {
  		        var pairs = data.__data__;
  		        if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
  		          pairs.push([key, value]);
  		          this.size = ++data.size;
  		          return this;
  		        }
  		        data = this.__data__ = new MapCache(pairs);
  		      }
  		      data.set(key, value);
  		      this.size = data.size;
  		      return this;
  		    }

  		    // Add methods to `Stack`.
  		    Stack.prototype.clear = stackClear;
  		    Stack.prototype['delete'] = stackDelete;
  		    Stack.prototype.get = stackGet;
  		    Stack.prototype.has = stackHas;
  		    Stack.prototype.set = stackSet;

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates an array of the enumerable property names of the array-like `value`.
  		     *
  		     * @private
  		     * @param {*} value The value to query.
  		     * @param {boolean} inherited Specify returning inherited property names.
  		     * @returns {Array} Returns the array of property names.
  		     */
  		    function arrayLikeKeys(value, inherited) {
  		      var isArr = isArray(value),
  		          isArg = !isArr && isArguments(value),
  		          isBuff = !isArr && !isArg && isBuffer(value),
  		          isType = !isArr && !isArg && !isBuff && isTypedArray(value),
  		          skipIndexes = isArr || isArg || isBuff || isType,
  		          result = skipIndexes ? baseTimes(value.length, String) : [],
  		          length = result.length;

  		      for (var key in value) {
  		        if ((inherited || hasOwnProperty.call(value, key)) &&
  		            !(skipIndexes && (
  		               // Safari 9 has enumerable `arguments.length` in strict mode.
  		               key == 'length' ||
  		               // Node.js 0.10 has enumerable non-index properties on buffers.
  		               (isBuff && (key == 'offset' || key == 'parent')) ||
  		               // PhantomJS 2 has enumerable non-index properties on typed arrays.
  		               (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
  		               // Skip index properties.
  		               isIndex(key, length)
  		            ))) {
  		          result.push(key);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * A specialized version of `_.sample` for arrays.
  		     *
  		     * @private
  		     * @param {Array} array The array to sample.
  		     * @returns {*} Returns the random element.
  		     */
  		    function arraySample(array) {
  		      var length = array.length;
  		      return length ? array[baseRandom(0, length - 1)] : undefined$1;
  		    }

  		    /**
  		     * A specialized version of `_.sampleSize` for arrays.
  		     *
  		     * @private
  		     * @param {Array} array The array to sample.
  		     * @param {number} n The number of elements to sample.
  		     * @returns {Array} Returns the random elements.
  		     */
  		    function arraySampleSize(array, n) {
  		      return shuffleSelf(copyArray(array), baseClamp(n, 0, array.length));
  		    }

  		    /**
  		     * A specialized version of `_.shuffle` for arrays.
  		     *
  		     * @private
  		     * @param {Array} array The array to shuffle.
  		     * @returns {Array} Returns the new shuffled array.
  		     */
  		    function arrayShuffle(array) {
  		      return shuffleSelf(copyArray(array));
  		    }

  		    /**
  		     * This function is like `assignValue` except that it doesn't assign
  		     * `undefined` values.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {string} key The key of the property to assign.
  		     * @param {*} value The value to assign.
  		     */
  		    function assignMergeValue(object, key, value) {
  		      if ((value !== undefined$1 && !eq(object[key], value)) ||
  		          (value === undefined$1 && !(key in object))) {
  		        baseAssignValue(object, key, value);
  		      }
  		    }

  		    /**
  		     * Assigns `value` to `key` of `object` if the existing value is not equivalent
  		     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {string} key The key of the property to assign.
  		     * @param {*} value The value to assign.
  		     */
  		    function assignValue(object, key, value) {
  		      var objValue = object[key];
  		      if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
  		          (value === undefined$1 && !(key in object))) {
  		        baseAssignValue(object, key, value);
  		      }
  		    }

  		    /**
  		     * Gets the index at which the `key` is found in `array` of key-value pairs.
  		     *
  		     * @private
  		     * @param {Array} array The array to inspect.
  		     * @param {*} key The key to search for.
  		     * @returns {number} Returns the index of the matched value, else `-1`.
  		     */
  		    function assocIndexOf(array, key) {
  		      var length = array.length;
  		      while (length--) {
  		        if (eq(array[length][0], key)) {
  		          return length;
  		        }
  		      }
  		      return -1;
  		    }

  		    /**
  		     * Aggregates elements of `collection` on `accumulator` with keys transformed
  		     * by `iteratee` and values set by `setter`.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} setter The function to set `accumulator` values.
  		     * @param {Function} iteratee The iteratee to transform keys.
  		     * @param {Object} accumulator The initial aggregated object.
  		     * @returns {Function} Returns `accumulator`.
  		     */
  		    function baseAggregator(collection, setter, iteratee, accumulator) {
  		      baseEach(collection, function(value, key, collection) {
  		        setter(accumulator, value, iteratee(value), collection);
  		      });
  		      return accumulator;
  		    }

  		    /**
  		     * The base implementation of `_.assign` without support for multiple sources
  		     * or `customizer` functions.
  		     *
  		     * @private
  		     * @param {Object} object The destination object.
  		     * @param {Object} source The source object.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseAssign(object, source) {
  		      return object && copyObject(source, keys(source), object);
  		    }

  		    /**
  		     * The base implementation of `_.assignIn` without support for multiple sources
  		     * or `customizer` functions.
  		     *
  		     * @private
  		     * @param {Object} object The destination object.
  		     * @param {Object} source The source object.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseAssignIn(object, source) {
  		      return object && copyObject(source, keysIn(source), object);
  		    }

  		    /**
  		     * The base implementation of `assignValue` and `assignMergeValue` without
  		     * value checks.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {string} key The key of the property to assign.
  		     * @param {*} value The value to assign.
  		     */
  		    function baseAssignValue(object, key, value) {
  		      if (key == '__proto__' && defineProperty) {
  		        defineProperty(object, key, {
  		          'configurable': true,
  		          'enumerable': true,
  		          'value': value,
  		          'writable': true
  		        });
  		      } else {
  		        object[key] = value;
  		      }
  		    }

  		    /**
  		     * The base implementation of `_.at` without support for individual paths.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {string[]} paths The property paths to pick.
  		     * @returns {Array} Returns the picked elements.
  		     */
  		    function baseAt(object, paths) {
  		      var index = -1,
  		          length = paths.length,
  		          result = Array(length),
  		          skip = object == null;

  		      while (++index < length) {
  		        result[index] = skip ? undefined$1 : get(object, paths[index]);
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.clamp` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {number} number The number to clamp.
  		     * @param {number} [lower] The lower bound.
  		     * @param {number} upper The upper bound.
  		     * @returns {number} Returns the clamped number.
  		     */
  		    function baseClamp(number, lower, upper) {
  		      if (number === number) {
  		        if (upper !== undefined$1) {
  		          number = number <= upper ? number : upper;
  		        }
  		        if (lower !== undefined$1) {
  		          number = number >= lower ? number : lower;
  		        }
  		      }
  		      return number;
  		    }

  		    /**
  		     * The base implementation of `_.clone` and `_.cloneDeep` which tracks
  		     * traversed objects.
  		     *
  		     * @private
  		     * @param {*} value The value to clone.
  		     * @param {boolean} bitmask The bitmask flags.
  		     *  1 - Deep clone
  		     *  2 - Flatten inherited properties
  		     *  4 - Clone symbols
  		     * @param {Function} [customizer] The function to customize cloning.
  		     * @param {string} [key] The key of `value`.
  		     * @param {Object} [object] The parent object of `value`.
  		     * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
  		     * @returns {*} Returns the cloned value.
  		     */
  		    function baseClone(value, bitmask, customizer, key, object, stack) {
  		      var result,
  		          isDeep = bitmask & CLONE_DEEP_FLAG,
  		          isFlat = bitmask & CLONE_FLAT_FLAG,
  		          isFull = bitmask & CLONE_SYMBOLS_FLAG;

  		      if (customizer) {
  		        result = object ? customizer(value, key, object, stack) : customizer(value);
  		      }
  		      if (result !== undefined$1) {
  		        return result;
  		      }
  		      if (!isObject(value)) {
  		        return value;
  		      }
  		      var isArr = isArray(value);
  		      if (isArr) {
  		        result = initCloneArray(value);
  		        if (!isDeep) {
  		          return copyArray(value, result);
  		        }
  		      } else {
  		        var tag = getTag(value),
  		            isFunc = tag == funcTag || tag == genTag;

  		        if (isBuffer(value)) {
  		          return cloneBuffer(value, isDeep);
  		        }
  		        if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
  		          result = (isFlat || isFunc) ? {} : initCloneObject(value);
  		          if (!isDeep) {
  		            return isFlat
  		              ? copySymbolsIn(value, baseAssignIn(result, value))
  		              : copySymbols(value, baseAssign(result, value));
  		          }
  		        } else {
  		          if (!cloneableTags[tag]) {
  		            return object ? value : {};
  		          }
  		          result = initCloneByTag(value, tag, isDeep);
  		        }
  		      }
  		      // Check for circular references and return its corresponding clone.
  		      stack || (stack = new Stack);
  		      var stacked = stack.get(value);
  		      if (stacked) {
  		        return stacked;
  		      }
  		      stack.set(value, result);

  		      if (isSet(value)) {
  		        value.forEach(function(subValue) {
  		          result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
  		        });
  		      } else if (isMap(value)) {
  		        value.forEach(function(subValue, key) {
  		          result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));
  		        });
  		      }

  		      var keysFunc = isFull
  		        ? (isFlat ? getAllKeysIn : getAllKeys)
  		        : (isFlat ? keysIn : keys);

  		      var props = isArr ? undefined$1 : keysFunc(value);
  		      arrayEach(props || value, function(subValue, key) {
  		        if (props) {
  		          key = subValue;
  		          subValue = value[key];
  		        }
  		        // Recursively populate clone (susceptible to call stack limits).
  		        assignValue(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));
  		      });
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.conforms` which doesn't clone `source`.
  		     *
  		     * @private
  		     * @param {Object} source The object of property predicates to conform to.
  		     * @returns {Function} Returns the new spec function.
  		     */
  		    function baseConforms(source) {
  		      var props = keys(source);
  		      return function(object) {
  		        return baseConformsTo(object, source, props);
  		      };
  		    }

  		    /**
  		     * The base implementation of `_.conformsTo` which accepts `props` to check.
  		     *
  		     * @private
  		     * @param {Object} object The object to inspect.
  		     * @param {Object} source The object of property predicates to conform to.
  		     * @returns {boolean} Returns `true` if `object` conforms, else `false`.
  		     */
  		    function baseConformsTo(object, source, props) {
  		      var length = props.length;
  		      if (object == null) {
  		        return !length;
  		      }
  		      object = Object(object);
  		      while (length--) {
  		        var key = props[length],
  		            predicate = source[key],
  		            value = object[key];

  		        if ((value === undefined$1 && !(key in object)) || !predicate(value)) {
  		          return false;
  		        }
  		      }
  		      return true;
  		    }

  		    /**
  		     * The base implementation of `_.delay` and `_.defer` which accepts `args`
  		     * to provide to `func`.
  		     *
  		     * @private
  		     * @param {Function} func The function to delay.
  		     * @param {number} wait The number of milliseconds to delay invocation.
  		     * @param {Array} args The arguments to provide to `func`.
  		     * @returns {number|Object} Returns the timer id or timeout object.
  		     */
  		    function baseDelay(func, wait, args) {
  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      return setTimeout(function() { func.apply(undefined$1, args); }, wait);
  		    }

  		    /**
  		     * The base implementation of methods like `_.difference` without support
  		     * for excluding multiple arrays or iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array} array The array to inspect.
  		     * @param {Array} values The values to exclude.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of filtered values.
  		     */
  		    function baseDifference(array, values, iteratee, comparator) {
  		      var index = -1,
  		          includes = arrayIncludes,
  		          isCommon = true,
  		          length = array.length,
  		          result = [],
  		          valuesLength = values.length;

  		      if (!length) {
  		        return result;
  		      }
  		      if (iteratee) {
  		        values = arrayMap(values, baseUnary(iteratee));
  		      }
  		      if (comparator) {
  		        includes = arrayIncludesWith;
  		        isCommon = false;
  		      }
  		      else if (values.length >= LARGE_ARRAY_SIZE) {
  		        includes = cacheHas;
  		        isCommon = false;
  		        values = new SetCache(values);
  		      }
  		      outer:
  		      while (++index < length) {
  		        var value = array[index],
  		            computed = iteratee == null ? value : iteratee(value);

  		        value = (comparator || value !== 0) ? value : 0;
  		        if (isCommon && computed === computed) {
  		          var valuesIndex = valuesLength;
  		          while (valuesIndex--) {
  		            if (values[valuesIndex] === computed) {
  		              continue outer;
  		            }
  		          }
  		          result.push(value);
  		        }
  		        else if (!includes(values, computed, comparator)) {
  		          result.push(value);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.forEach` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @returns {Array|Object} Returns `collection`.
  		     */
  		    var baseEach = createBaseEach(baseForOwn);

  		    /**
  		     * The base implementation of `_.forEachRight` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @returns {Array|Object} Returns `collection`.
  		     */
  		    var baseEachRight = createBaseEach(baseForOwnRight, true);

  		    /**
  		     * The base implementation of `_.every` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} predicate The function invoked per iteration.
  		     * @returns {boolean} Returns `true` if all elements pass the predicate check,
  		     *  else `false`
  		     */
  		    function baseEvery(collection, predicate) {
  		      var result = true;
  		      baseEach(collection, function(value, index, collection) {
  		        result = !!predicate(value, index, collection);
  		        return result;
  		      });
  		      return result;
  		    }

  		    /**
  		     * The base implementation of methods like `_.max` and `_.min` which accepts a
  		     * `comparator` to determine the extremum value.
  		     *
  		     * @private
  		     * @param {Array} array The array to iterate over.
  		     * @param {Function} iteratee The iteratee invoked per iteration.
  		     * @param {Function} comparator The comparator used to compare values.
  		     * @returns {*} Returns the extremum value.
  		     */
  		    function baseExtremum(array, iteratee, comparator) {
  		      var index = -1,
  		          length = array.length;

  		      while (++index < length) {
  		        var value = array[index],
  		            current = iteratee(value);

  		        if (current != null && (computed === undefined$1
  		              ? (current === current && !isSymbol(current))
  		              : comparator(current, computed)
  		            )) {
  		          var computed = current,
  		              result = value;
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.fill` without an iteratee call guard.
  		     *
  		     * @private
  		     * @param {Array} array The array to fill.
  		     * @param {*} value The value to fill `array` with.
  		     * @param {number} [start=0] The start position.
  		     * @param {number} [end=array.length] The end position.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function baseFill(array, value, start, end) {
  		      var length = array.length;

  		      start = toInteger(start);
  		      if (start < 0) {
  		        start = -start > length ? 0 : (length + start);
  		      }
  		      end = (end === undefined$1 || end > length) ? length : toInteger(end);
  		      if (end < 0) {
  		        end += length;
  		      }
  		      end = start > end ? 0 : toLength(end);
  		      while (start < end) {
  		        array[start++] = value;
  		      }
  		      return array;
  		    }

  		    /**
  		     * The base implementation of `_.filter` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} predicate The function invoked per iteration.
  		     * @returns {Array} Returns the new filtered array.
  		     */
  		    function baseFilter(collection, predicate) {
  		      var result = [];
  		      baseEach(collection, function(value, index, collection) {
  		        if (predicate(value, index, collection)) {
  		          result.push(value);
  		        }
  		      });
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.flatten` with support for restricting flattening.
  		     *
  		     * @private
  		     * @param {Array} array The array to flatten.
  		     * @param {number} depth The maximum recursion depth.
  		     * @param {boolean} [predicate=isFlattenable] The function invoked per iteration.
  		     * @param {boolean} [isStrict] Restrict to values that pass `predicate` checks.
  		     * @param {Array} [result=[]] The initial result value.
  		     * @returns {Array} Returns the new flattened array.
  		     */
  		    function baseFlatten(array, depth, predicate, isStrict, result) {
  		      var index = -1,
  		          length = array.length;

  		      predicate || (predicate = isFlattenable);
  		      result || (result = []);

  		      while (++index < length) {
  		        var value = array[index];
  		        if (depth > 0 && predicate(value)) {
  		          if (depth > 1) {
  		            // Recursively flatten arrays (susceptible to call stack limits).
  		            baseFlatten(value, depth - 1, predicate, isStrict, result);
  		          } else {
  		            arrayPush(result, value);
  		          }
  		        } else if (!isStrict) {
  		          result[result.length] = value;
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `baseForOwn` which iterates over `object`
  		     * properties returned by `keysFunc` and invokes `iteratee` for each property.
  		     * Iteratee functions may exit iteration early by explicitly returning `false`.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @param {Function} keysFunc The function to get the keys of `object`.
  		     * @returns {Object} Returns `object`.
  		     */
  		    var baseFor = createBaseFor();

  		    /**
  		     * This function is like `baseFor` except that it iterates over properties
  		     * in the opposite order.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @param {Function} keysFunc The function to get the keys of `object`.
  		     * @returns {Object} Returns `object`.
  		     */
  		    var baseForRight = createBaseFor(true);

  		    /**
  		     * The base implementation of `_.forOwn` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseForOwn(object, iteratee) {
  		      return object && baseFor(object, iteratee, keys);
  		    }

  		    /**
  		     * The base implementation of `_.forOwnRight` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseForOwnRight(object, iteratee) {
  		      return object && baseForRight(object, iteratee, keys);
  		    }

  		    /**
  		     * The base implementation of `_.functions` which creates an array of
  		     * `object` function property names filtered from `props`.
  		     *
  		     * @private
  		     * @param {Object} object The object to inspect.
  		     * @param {Array} props The property names to filter.
  		     * @returns {Array} Returns the function names.
  		     */
  		    function baseFunctions(object, props) {
  		      return arrayFilter(props, function(key) {
  		        return isFunction(object[key]);
  		      });
  		    }

  		    /**
  		     * The base implementation of `_.get` without support for default values.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {Array|string} path The path of the property to get.
  		     * @returns {*} Returns the resolved value.
  		     */
  		    function baseGet(object, path) {
  		      path = castPath(path, object);

  		      var index = 0,
  		          length = path.length;

  		      while (object != null && index < length) {
  		        object = object[toKey(path[index++])];
  		      }
  		      return (index && index == length) ? object : undefined$1;
  		    }

  		    /**
  		     * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
  		     * `keysFunc` and `symbolsFunc` to get the enumerable property names and
  		     * symbols of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {Function} keysFunc The function to get the keys of `object`.
  		     * @param {Function} symbolsFunc The function to get the symbols of `object`.
  		     * @returns {Array} Returns the array of property names and symbols.
  		     */
  		    function baseGetAllKeys(object, keysFunc, symbolsFunc) {
  		      var result = keysFunc(object);
  		      return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
  		    }

  		    /**
  		     * The base implementation of `getTag` without fallbacks for buggy environments.
  		     *
  		     * @private
  		     * @param {*} value The value to query.
  		     * @returns {string} Returns the `toStringTag`.
  		     */
  		    function baseGetTag(value) {
  		      if (value == null) {
  		        return value === undefined$1 ? undefinedTag : nullTag;
  		      }
  		      return (symToStringTag && symToStringTag in Object(value))
  		        ? getRawTag(value)
  		        : objectToString(value);
  		    }

  		    /**
  		     * The base implementation of `_.gt` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {*} value The value to compare.
  		     * @param {*} other The other value to compare.
  		     * @returns {boolean} Returns `true` if `value` is greater than `other`,
  		     *  else `false`.
  		     */
  		    function baseGt(value, other) {
  		      return value > other;
  		    }

  		    /**
  		     * The base implementation of `_.has` without support for deep paths.
  		     *
  		     * @private
  		     * @param {Object} [object] The object to query.
  		     * @param {Array|string} key The key to check.
  		     * @returns {boolean} Returns `true` if `key` exists, else `false`.
  		     */
  		    function baseHas(object, key) {
  		      return object != null && hasOwnProperty.call(object, key);
  		    }

  		    /**
  		     * The base implementation of `_.hasIn` without support for deep paths.
  		     *
  		     * @private
  		     * @param {Object} [object] The object to query.
  		     * @param {Array|string} key The key to check.
  		     * @returns {boolean} Returns `true` if `key` exists, else `false`.
  		     */
  		    function baseHasIn(object, key) {
  		      return object != null && key in Object(object);
  		    }

  		    /**
  		     * The base implementation of `_.inRange` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {number} number The number to check.
  		     * @param {number} start The start of the range.
  		     * @param {number} end The end of the range.
  		     * @returns {boolean} Returns `true` if `number` is in the range, else `false`.
  		     */
  		    function baseInRange(number, start, end) {
  		      return number >= nativeMin(start, end) && number < nativeMax(start, end);
  		    }

  		    /**
  		     * The base implementation of methods like `_.intersection`, without support
  		     * for iteratee shorthands, that accepts an array of arrays to inspect.
  		     *
  		     * @private
  		     * @param {Array} arrays The arrays to inspect.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of shared values.
  		     */
  		    function baseIntersection(arrays, iteratee, comparator) {
  		      var includes = comparator ? arrayIncludesWith : arrayIncludes,
  		          length = arrays[0].length,
  		          othLength = arrays.length,
  		          othIndex = othLength,
  		          caches = Array(othLength),
  		          maxLength = Infinity,
  		          result = [];

  		      while (othIndex--) {
  		        var array = arrays[othIndex];
  		        if (othIndex && iteratee) {
  		          array = arrayMap(array, baseUnary(iteratee));
  		        }
  		        maxLength = nativeMin(array.length, maxLength);
  		        caches[othIndex] = !comparator && (iteratee || (length >= 120 && array.length >= 120))
  		          ? new SetCache(othIndex && array)
  		          : undefined$1;
  		      }
  		      array = arrays[0];

  		      var index = -1,
  		          seen = caches[0];

  		      outer:
  		      while (++index < length && result.length < maxLength) {
  		        var value = array[index],
  		            computed = iteratee ? iteratee(value) : value;

  		        value = (comparator || value !== 0) ? value : 0;
  		        if (!(seen
  		              ? cacheHas(seen, computed)
  		              : includes(result, computed, comparator)
  		            )) {
  		          othIndex = othLength;
  		          while (--othIndex) {
  		            var cache = caches[othIndex];
  		            if (!(cache
  		                  ? cacheHas(cache, computed)
  		                  : includes(arrays[othIndex], computed, comparator))
  		                ) {
  		              continue outer;
  		            }
  		          }
  		          if (seen) {
  		            seen.push(computed);
  		          }
  		          result.push(value);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.invert` and `_.invertBy` which inverts
  		     * `object` with values transformed by `iteratee` and set by `setter`.
  		     *
  		     * @private
  		     * @param {Object} object The object to iterate over.
  		     * @param {Function} setter The function to set `accumulator` values.
  		     * @param {Function} iteratee The iteratee to transform values.
  		     * @param {Object} accumulator The initial inverted object.
  		     * @returns {Function} Returns `accumulator`.
  		     */
  		    function baseInverter(object, setter, iteratee, accumulator) {
  		      baseForOwn(object, function(value, key, object) {
  		        setter(accumulator, iteratee(value), key, object);
  		      });
  		      return accumulator;
  		    }

  		    /**
  		     * The base implementation of `_.invoke` without support for individual
  		     * method arguments.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {Array|string} path The path of the method to invoke.
  		     * @param {Array} args The arguments to invoke the method with.
  		     * @returns {*} Returns the result of the invoked method.
  		     */
  		    function baseInvoke(object, path, args) {
  		      path = castPath(path, object);
  		      object = parent(object, path);
  		      var func = object == null ? object : object[toKey(last(path))];
  		      return func == null ? undefined$1 : apply(func, object, args);
  		    }

  		    /**
  		     * The base implementation of `_.isArguments`.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is an `arguments` object,
  		     */
  		    function baseIsArguments(value) {
  		      return isObjectLike(value) && baseGetTag(value) == argsTag;
  		    }

  		    /**
  		     * The base implementation of `_.isArrayBuffer` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is an array buffer, else `false`.
  		     */
  		    function baseIsArrayBuffer(value) {
  		      return isObjectLike(value) && baseGetTag(value) == arrayBufferTag;
  		    }

  		    /**
  		     * The base implementation of `_.isDate` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a date object, else `false`.
  		     */
  		    function baseIsDate(value) {
  		      return isObjectLike(value) && baseGetTag(value) == dateTag;
  		    }

  		    /**
  		     * The base implementation of `_.isEqual` which supports partial comparisons
  		     * and tracks traversed objects.
  		     *
  		     * @private
  		     * @param {*} value The value to compare.
  		     * @param {*} other The other value to compare.
  		     * @param {boolean} bitmask The bitmask flags.
  		     *  1 - Unordered comparison
  		     *  2 - Partial comparison
  		     * @param {Function} [customizer] The function to customize comparisons.
  		     * @param {Object} [stack] Tracks traversed `value` and `other` objects.
  		     * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
  		     */
  		    function baseIsEqual(value, other, bitmask, customizer, stack) {
  		      if (value === other) {
  		        return true;
  		      }
  		      if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {
  		        return value !== value && other !== other;
  		      }
  		      return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
  		    }

  		    /**
  		     * A specialized version of `baseIsEqual` for arrays and objects which performs
  		     * deep comparisons and tracks traversed objects enabling objects with circular
  		     * references to be compared.
  		     *
  		     * @private
  		     * @param {Object} object The object to compare.
  		     * @param {Object} other The other object to compare.
  		     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  		     * @param {Function} customizer The function to customize comparisons.
  		     * @param {Function} equalFunc The function to determine equivalents of values.
  		     * @param {Object} [stack] Tracks traversed `object` and `other` objects.
  		     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  		     */
  		    function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
  		      var objIsArr = isArray(object),
  		          othIsArr = isArray(other),
  		          objTag = objIsArr ? arrayTag : getTag(object),
  		          othTag = othIsArr ? arrayTag : getTag(other);

  		      objTag = objTag == argsTag ? objectTag : objTag;
  		      othTag = othTag == argsTag ? objectTag : othTag;

  		      var objIsObj = objTag == objectTag,
  		          othIsObj = othTag == objectTag,
  		          isSameTag = objTag == othTag;

  		      if (isSameTag && isBuffer(object)) {
  		        if (!isBuffer(other)) {
  		          return false;
  		        }
  		        objIsArr = true;
  		        objIsObj = false;
  		      }
  		      if (isSameTag && !objIsObj) {
  		        stack || (stack = new Stack);
  		        return (objIsArr || isTypedArray(object))
  		          ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
  		          : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
  		      }
  		      if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
  		        var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),
  		            othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');

  		        if (objIsWrapped || othIsWrapped) {
  		          var objUnwrapped = objIsWrapped ? object.value() : object,
  		              othUnwrapped = othIsWrapped ? other.value() : other;

  		          stack || (stack = new Stack);
  		          return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
  		        }
  		      }
  		      if (!isSameTag) {
  		        return false;
  		      }
  		      stack || (stack = new Stack);
  		      return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
  		    }

  		    /**
  		     * The base implementation of `_.isMap` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a map, else `false`.
  		     */
  		    function baseIsMap(value) {
  		      return isObjectLike(value) && getTag(value) == mapTag;
  		    }

  		    /**
  		     * The base implementation of `_.isMatch` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Object} object The object to inspect.
  		     * @param {Object} source The object of property values to match.
  		     * @param {Array} matchData The property names, values, and compare flags to match.
  		     * @param {Function} [customizer] The function to customize comparisons.
  		     * @returns {boolean} Returns `true` if `object` is a match, else `false`.
  		     */
  		    function baseIsMatch(object, source, matchData, customizer) {
  		      var index = matchData.length,
  		          length = index,
  		          noCustomizer = !customizer;

  		      if (object == null) {
  		        return !length;
  		      }
  		      object = Object(object);
  		      while (index--) {
  		        var data = matchData[index];
  		        if ((noCustomizer && data[2])
  		              ? data[1] !== object[data[0]]
  		              : !(data[0] in object)
  		            ) {
  		          return false;
  		        }
  		      }
  		      while (++index < length) {
  		        data = matchData[index];
  		        var key = data[0],
  		            objValue = object[key],
  		            srcValue = data[1];

  		        if (noCustomizer && data[2]) {
  		          if (objValue === undefined$1 && !(key in object)) {
  		            return false;
  		          }
  		        } else {
  		          var stack = new Stack;
  		          if (customizer) {
  		            var result = customizer(objValue, srcValue, key, object, source, stack);
  		          }
  		          if (!(result === undefined$1
  		                ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG, customizer, stack)
  		                : result
  		              )) {
  		            return false;
  		          }
  		        }
  		      }
  		      return true;
  		    }

  		    /**
  		     * The base implementation of `_.isNative` without bad shim checks.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a native function,
  		     *  else `false`.
  		     */
  		    function baseIsNative(value) {
  		      if (!isObject(value) || isMasked(value)) {
  		        return false;
  		      }
  		      var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
  		      return pattern.test(toSource(value));
  		    }

  		    /**
  		     * The base implementation of `_.isRegExp` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a regexp, else `false`.
  		     */
  		    function baseIsRegExp(value) {
  		      return isObjectLike(value) && baseGetTag(value) == regexpTag;
  		    }

  		    /**
  		     * The base implementation of `_.isSet` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a set, else `false`.
  		     */
  		    function baseIsSet(value) {
  		      return isObjectLike(value) && getTag(value) == setTag;
  		    }

  		    /**
  		     * The base implementation of `_.isTypedArray` without Node.js optimizations.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
  		     */
  		    function baseIsTypedArray(value) {
  		      return isObjectLike(value) &&
  		        isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
  		    }

  		    /**
  		     * The base implementation of `_.iteratee`.
  		     *
  		     * @private
  		     * @param {*} [value=_.identity] The value to convert to an iteratee.
  		     * @returns {Function} Returns the iteratee.
  		     */
  		    function baseIteratee(value) {
  		      // Don't store the `typeof` result in a variable to avoid a JIT bug in Safari 9.
  		      // See https://bugs.webkit.org/show_bug.cgi?id=156034 for more details.
  		      if (typeof value == 'function') {
  		        return value;
  		      }
  		      if (value == null) {
  		        return identity;
  		      }
  		      if (typeof value == 'object') {
  		        return isArray(value)
  		          ? baseMatchesProperty(value[0], value[1])
  		          : baseMatches(value);
  		      }
  		      return property(value);
  		    }

  		    /**
  		     * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of property names.
  		     */
  		    function baseKeys(object) {
  		      if (!isPrototype(object)) {
  		        return nativeKeys(object);
  		      }
  		      var result = [];
  		      for (var key in Object(object)) {
  		        if (hasOwnProperty.call(object, key) && key != 'constructor') {
  		          result.push(key);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of property names.
  		     */
  		    function baseKeysIn(object) {
  		      if (!isObject(object)) {
  		        return nativeKeysIn(object);
  		      }
  		      var isProto = isPrototype(object),
  		          result = [];

  		      for (var key in object) {
  		        if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
  		          result.push(key);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.lt` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {*} value The value to compare.
  		     * @param {*} other The other value to compare.
  		     * @returns {boolean} Returns `true` if `value` is less than `other`,
  		     *  else `false`.
  		     */
  		    function baseLt(value, other) {
  		      return value < other;
  		    }

  		    /**
  		     * The base implementation of `_.map` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} iteratee The function invoked per iteration.
  		     * @returns {Array} Returns the new mapped array.
  		     */
  		    function baseMap(collection, iteratee) {
  		      var index = -1,
  		          result = isArrayLike(collection) ? Array(collection.length) : [];

  		      baseEach(collection, function(value, key, collection) {
  		        result[++index] = iteratee(value, key, collection);
  		      });
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.matches` which doesn't clone `source`.
  		     *
  		     * @private
  		     * @param {Object} source The object of property values to match.
  		     * @returns {Function} Returns the new spec function.
  		     */
  		    function baseMatches(source) {
  		      var matchData = getMatchData(source);
  		      if (matchData.length == 1 && matchData[0][2]) {
  		        return matchesStrictComparable(matchData[0][0], matchData[0][1]);
  		      }
  		      return function(object) {
  		        return object === source || baseIsMatch(object, source, matchData);
  		      };
  		    }

  		    /**
  		     * The base implementation of `_.matchesProperty` which doesn't clone `srcValue`.
  		     *
  		     * @private
  		     * @param {string} path The path of the property to get.
  		     * @param {*} srcValue The value to match.
  		     * @returns {Function} Returns the new spec function.
  		     */
  		    function baseMatchesProperty(path, srcValue) {
  		      if (isKey(path) && isStrictComparable(srcValue)) {
  		        return matchesStrictComparable(toKey(path), srcValue);
  		      }
  		      return function(object) {
  		        var objValue = get(object, path);
  		        return (objValue === undefined$1 && objValue === srcValue)
  		          ? hasIn(object, path)
  		          : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
  		      };
  		    }

  		    /**
  		     * The base implementation of `_.merge` without support for multiple sources.
  		     *
  		     * @private
  		     * @param {Object} object The destination object.
  		     * @param {Object} source The source object.
  		     * @param {number} srcIndex The index of `source`.
  		     * @param {Function} [customizer] The function to customize merged values.
  		     * @param {Object} [stack] Tracks traversed source values and their merged
  		     *  counterparts.
  		     */
  		    function baseMerge(object, source, srcIndex, customizer, stack) {
  		      if (object === source) {
  		        return;
  		      }
  		      baseFor(source, function(srcValue, key) {
  		        stack || (stack = new Stack);
  		        if (isObject(srcValue)) {
  		          baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
  		        }
  		        else {
  		          var newValue = customizer
  		            ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
  		            : undefined$1;

  		          if (newValue === undefined$1) {
  		            newValue = srcValue;
  		          }
  		          assignMergeValue(object, key, newValue);
  		        }
  		      }, keysIn);
  		    }

  		    /**
  		     * A specialized version of `baseMerge` for arrays and objects which performs
  		     * deep merges and tracks traversed objects enabling objects with circular
  		     * references to be merged.
  		     *
  		     * @private
  		     * @param {Object} object The destination object.
  		     * @param {Object} source The source object.
  		     * @param {string} key The key of the value to merge.
  		     * @param {number} srcIndex The index of `source`.
  		     * @param {Function} mergeFunc The function to merge values.
  		     * @param {Function} [customizer] The function to customize assigned values.
  		     * @param {Object} [stack] Tracks traversed source values and their merged
  		     *  counterparts.
  		     */
  		    function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
  		      var objValue = safeGet(object, key),
  		          srcValue = safeGet(source, key),
  		          stacked = stack.get(srcValue);

  		      if (stacked) {
  		        assignMergeValue(object, key, stacked);
  		        return;
  		      }
  		      var newValue = customizer
  		        ? customizer(objValue, srcValue, (key + ''), object, source, stack)
  		        : undefined$1;

  		      var isCommon = newValue === undefined$1;

  		      if (isCommon) {
  		        var isArr = isArray(srcValue),
  		            isBuff = !isArr && isBuffer(srcValue),
  		            isTyped = !isArr && !isBuff && isTypedArray(srcValue);

  		        newValue = srcValue;
  		        if (isArr || isBuff || isTyped) {
  		          if (isArray(objValue)) {
  		            newValue = objValue;
  		          }
  		          else if (isArrayLikeObject(objValue)) {
  		            newValue = copyArray(objValue);
  		          }
  		          else if (isBuff) {
  		            isCommon = false;
  		            newValue = cloneBuffer(srcValue, true);
  		          }
  		          else if (isTyped) {
  		            isCommon = false;
  		            newValue = cloneTypedArray(srcValue, true);
  		          }
  		          else {
  		            newValue = [];
  		          }
  		        }
  		        else if (isPlainObject(srcValue) || isArguments(srcValue)) {
  		          newValue = objValue;
  		          if (isArguments(objValue)) {
  		            newValue = toPlainObject(objValue);
  		          }
  		          else if (!isObject(objValue) || isFunction(objValue)) {
  		            newValue = initCloneObject(srcValue);
  		          }
  		        }
  		        else {
  		          isCommon = false;
  		        }
  		      }
  		      if (isCommon) {
  		        // Recursively merge objects and arrays (susceptible to call stack limits).
  		        stack.set(srcValue, newValue);
  		        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
  		        stack['delete'](srcValue);
  		      }
  		      assignMergeValue(object, key, newValue);
  		    }

  		    /**
  		     * The base implementation of `_.nth` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {Array} array The array to query.
  		     * @param {number} n The index of the element to return.
  		     * @returns {*} Returns the nth element of `array`.
  		     */
  		    function baseNth(array, n) {
  		      var length = array.length;
  		      if (!length) {
  		        return;
  		      }
  		      n += n < 0 ? length : 0;
  		      return isIndex(n, length) ? array[n] : undefined$1;
  		    }

  		    /**
  		     * The base implementation of `_.orderBy` without param guards.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function[]|Object[]|string[]} iteratees The iteratees to sort by.
  		     * @param {string[]} orders The sort orders of `iteratees`.
  		     * @returns {Array} Returns the new sorted array.
  		     */
  		    function baseOrderBy(collection, iteratees, orders) {
  		      if (iteratees.length) {
  		        iteratees = arrayMap(iteratees, function(iteratee) {
  		          if (isArray(iteratee)) {
  		            return function(value) {
  		              return baseGet(value, iteratee.length === 1 ? iteratee[0] : iteratee);
  		            }
  		          }
  		          return iteratee;
  		        });
  		      } else {
  		        iteratees = [identity];
  		      }

  		      var index = -1;
  		      iteratees = arrayMap(iteratees, baseUnary(getIteratee()));

  		      var result = baseMap(collection, function(value, key, collection) {
  		        var criteria = arrayMap(iteratees, function(iteratee) {
  		          return iteratee(value);
  		        });
  		        return { 'criteria': criteria, 'index': ++index, 'value': value };
  		      });

  		      return baseSortBy(result, function(object, other) {
  		        return compareMultiple(object, other, orders);
  		      });
  		    }

  		    /**
  		     * The base implementation of `_.pick` without support for individual
  		     * property identifiers.
  		     *
  		     * @private
  		     * @param {Object} object The source object.
  		     * @param {string[]} paths The property paths to pick.
  		     * @returns {Object} Returns the new object.
  		     */
  		    function basePick(object, paths) {
  		      return basePickBy(object, paths, function(value, path) {
  		        return hasIn(object, path);
  		      });
  		    }

  		    /**
  		     * The base implementation of  `_.pickBy` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Object} object The source object.
  		     * @param {string[]} paths The property paths to pick.
  		     * @param {Function} predicate The function invoked per property.
  		     * @returns {Object} Returns the new object.
  		     */
  		    function basePickBy(object, paths, predicate) {
  		      var index = -1,
  		          length = paths.length,
  		          result = {};

  		      while (++index < length) {
  		        var path = paths[index],
  		            value = baseGet(object, path);

  		        if (predicate(value, path)) {
  		          baseSet(result, castPath(path, object), value);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * A specialized version of `baseProperty` which supports deep paths.
  		     *
  		     * @private
  		     * @param {Array|string} path The path of the property to get.
  		     * @returns {Function} Returns the new accessor function.
  		     */
  		    function basePropertyDeep(path) {
  		      return function(object) {
  		        return baseGet(object, path);
  		      };
  		    }

  		    /**
  		     * The base implementation of `_.pullAllBy` without support for iteratee
  		     * shorthands.
  		     *
  		     * @private
  		     * @param {Array} array The array to modify.
  		     * @param {Array} values The values to remove.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function basePullAll(array, values, iteratee, comparator) {
  		      var indexOf = comparator ? baseIndexOfWith : baseIndexOf,
  		          index = -1,
  		          length = values.length,
  		          seen = array;

  		      if (array === values) {
  		        values = copyArray(values);
  		      }
  		      if (iteratee) {
  		        seen = arrayMap(array, baseUnary(iteratee));
  		      }
  		      while (++index < length) {
  		        var fromIndex = 0,
  		            value = values[index],
  		            computed = iteratee ? iteratee(value) : value;

  		        while ((fromIndex = indexOf(seen, computed, fromIndex, comparator)) > -1) {
  		          if (seen !== array) {
  		            splice.call(seen, fromIndex, 1);
  		          }
  		          splice.call(array, fromIndex, 1);
  		        }
  		      }
  		      return array;
  		    }

  		    /**
  		     * The base implementation of `_.pullAt` without support for individual
  		     * indexes or capturing the removed elements.
  		     *
  		     * @private
  		     * @param {Array} array The array to modify.
  		     * @param {number[]} indexes The indexes of elements to remove.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function basePullAt(array, indexes) {
  		      var length = array ? indexes.length : 0,
  		          lastIndex = length - 1;

  		      while (length--) {
  		        var index = indexes[length];
  		        if (length == lastIndex || index !== previous) {
  		          var previous = index;
  		          if (isIndex(index)) {
  		            splice.call(array, index, 1);
  		          } else {
  		            baseUnset(array, index);
  		          }
  		        }
  		      }
  		      return array;
  		    }

  		    /**
  		     * The base implementation of `_.random` without support for returning
  		     * floating-point numbers.
  		     *
  		     * @private
  		     * @param {number} lower The lower bound.
  		     * @param {number} upper The upper bound.
  		     * @returns {number} Returns the random number.
  		     */
  		    function baseRandom(lower, upper) {
  		      return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
  		    }

  		    /**
  		     * The base implementation of `_.range` and `_.rangeRight` which doesn't
  		     * coerce arguments.
  		     *
  		     * @private
  		     * @param {number} start The start of the range.
  		     * @param {number} end The end of the range.
  		     * @param {number} step The value to increment or decrement by.
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Array} Returns the range of numbers.
  		     */
  		    function baseRange(start, end, step, fromRight) {
  		      var index = -1,
  		          length = nativeMax(nativeCeil((end - start) / (step || 1)), 0),
  		          result = Array(length);

  		      while (length--) {
  		        result[fromRight ? length : ++index] = start;
  		        start += step;
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.repeat` which doesn't coerce arguments.
  		     *
  		     * @private
  		     * @param {string} string The string to repeat.
  		     * @param {number} n The number of times to repeat the string.
  		     * @returns {string} Returns the repeated string.
  		     */
  		    function baseRepeat(string, n) {
  		      var result = '';
  		      if (!string || n < 1 || n > MAX_SAFE_INTEGER) {
  		        return result;
  		      }
  		      // Leverage the exponentiation by squaring algorithm for a faster repeat.
  		      // See https://en.wikipedia.org/wiki/Exponentiation_by_squaring for more details.
  		      do {
  		        if (n % 2) {
  		          result += string;
  		        }
  		        n = nativeFloor(n / 2);
  		        if (n) {
  		          string += string;
  		        }
  		      } while (n);

  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.rest` which doesn't validate or coerce arguments.
  		     *
  		     * @private
  		     * @param {Function} func The function to apply a rest parameter to.
  		     * @param {number} [start=func.length-1] The start position of the rest parameter.
  		     * @returns {Function} Returns the new function.
  		     */
  		    function baseRest(func, start) {
  		      return setToString(overRest(func, start, identity), func + '');
  		    }

  		    /**
  		     * The base implementation of `_.sample`.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to sample.
  		     * @returns {*} Returns the random element.
  		     */
  		    function baseSample(collection) {
  		      return arraySample(values(collection));
  		    }

  		    /**
  		     * The base implementation of `_.sampleSize` without param guards.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to sample.
  		     * @param {number} n The number of elements to sample.
  		     * @returns {Array} Returns the random elements.
  		     */
  		    function baseSampleSize(collection, n) {
  		      var array = values(collection);
  		      return shuffleSelf(array, baseClamp(n, 0, array.length));
  		    }

  		    /**
  		     * The base implementation of `_.set`.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {Array|string} path The path of the property to set.
  		     * @param {*} value The value to set.
  		     * @param {Function} [customizer] The function to customize path creation.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseSet(object, path, value, customizer) {
  		      if (!isObject(object)) {
  		        return object;
  		      }
  		      path = castPath(path, object);

  		      var index = -1,
  		          length = path.length,
  		          lastIndex = length - 1,
  		          nested = object;

  		      while (nested != null && ++index < length) {
  		        var key = toKey(path[index]),
  		            newValue = value;

  		        if (key === '__proto__' || key === 'constructor' || key === 'prototype') {
  		          return object;
  		        }

  		        if (index != lastIndex) {
  		          var objValue = nested[key];
  		          newValue = customizer ? customizer(objValue, key, nested) : undefined$1;
  		          if (newValue === undefined$1) {
  		            newValue = isObject(objValue)
  		              ? objValue
  		              : (isIndex(path[index + 1]) ? [] : {});
  		          }
  		        }
  		        assignValue(nested, key, newValue);
  		        nested = nested[key];
  		      }
  		      return object;
  		    }

  		    /**
  		     * The base implementation of `setData` without support for hot loop shorting.
  		     *
  		     * @private
  		     * @param {Function} func The function to associate metadata with.
  		     * @param {*} data The metadata.
  		     * @returns {Function} Returns `func`.
  		     */
  		    var baseSetData = !metaMap ? identity : function(func, data) {
  		      metaMap.set(func, data);
  		      return func;
  		    };

  		    /**
  		     * The base implementation of `setToString` without support for hot loop shorting.
  		     *
  		     * @private
  		     * @param {Function} func The function to modify.
  		     * @param {Function} string The `toString` result.
  		     * @returns {Function} Returns `func`.
  		     */
  		    var baseSetToString = !defineProperty ? identity : function(func, string) {
  		      return defineProperty(func, 'toString', {
  		        'configurable': true,
  		        'enumerable': false,
  		        'value': constant(string),
  		        'writable': true
  		      });
  		    };

  		    /**
  		     * The base implementation of `_.shuffle`.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to shuffle.
  		     * @returns {Array} Returns the new shuffled array.
  		     */
  		    function baseShuffle(collection) {
  		      return shuffleSelf(values(collection));
  		    }

  		    /**
  		     * The base implementation of `_.slice` without an iteratee call guard.
  		     *
  		     * @private
  		     * @param {Array} array The array to slice.
  		     * @param {number} [start=0] The start position.
  		     * @param {number} [end=array.length] The end position.
  		     * @returns {Array} Returns the slice of `array`.
  		     */
  		    function baseSlice(array, start, end) {
  		      var index = -1,
  		          length = array.length;

  		      if (start < 0) {
  		        start = -start > length ? 0 : (length + start);
  		      }
  		      end = end > length ? length : end;
  		      if (end < 0) {
  		        end += length;
  		      }
  		      length = start > end ? 0 : ((end - start) >>> 0);
  		      start >>>= 0;

  		      var result = Array(length);
  		      while (++index < length) {
  		        result[index] = array[index + start];
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.some` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} predicate The function invoked per iteration.
  		     * @returns {boolean} Returns `true` if any element passes the predicate check,
  		     *  else `false`.
  		     */
  		    function baseSome(collection, predicate) {
  		      var result;

  		      baseEach(collection, function(value, index, collection) {
  		        result = predicate(value, index, collection);
  		        return !result;
  		      });
  		      return !!result;
  		    }

  		    /**
  		     * The base implementation of `_.sortedIndex` and `_.sortedLastIndex` which
  		     * performs a binary search of `array` to determine the index at which `value`
  		     * should be inserted into `array` in order to maintain its sort order.
  		     *
  		     * @private
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @param {boolean} [retHighest] Specify returning the highest qualified index.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     */
  		    function baseSortedIndex(array, value, retHighest) {
  		      var low = 0,
  		          high = array == null ? low : array.length;

  		      if (typeof value == 'number' && value === value && high <= HALF_MAX_ARRAY_LENGTH) {
  		        while (low < high) {
  		          var mid = (low + high) >>> 1,
  		              computed = array[mid];

  		          if (computed !== null && !isSymbol(computed) &&
  		              (retHighest ? (computed <= value) : (computed < value))) {
  		            low = mid + 1;
  		          } else {
  		            high = mid;
  		          }
  		        }
  		        return high;
  		      }
  		      return baseSortedIndexBy(array, value, identity, retHighest);
  		    }

  		    /**
  		     * The base implementation of `_.sortedIndexBy` and `_.sortedLastIndexBy`
  		     * which invokes `iteratee` for `value` and each element of `array` to compute
  		     * their sort ranking. The iteratee is invoked with one argument; (value).
  		     *
  		     * @private
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @param {Function} iteratee The iteratee invoked per element.
  		     * @param {boolean} [retHighest] Specify returning the highest qualified index.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     */
  		    function baseSortedIndexBy(array, value, iteratee, retHighest) {
  		      var low = 0,
  		          high = array == null ? 0 : array.length;
  		      if (high === 0) {
  		        return 0;
  		      }

  		      value = iteratee(value);
  		      var valIsNaN = value !== value,
  		          valIsNull = value === null,
  		          valIsSymbol = isSymbol(value),
  		          valIsUndefined = value === undefined$1;

  		      while (low < high) {
  		        var mid = nativeFloor((low + high) / 2),
  		            computed = iteratee(array[mid]),
  		            othIsDefined = computed !== undefined$1,
  		            othIsNull = computed === null,
  		            othIsReflexive = computed === computed,
  		            othIsSymbol = isSymbol(computed);

  		        if (valIsNaN) {
  		          var setLow = retHighest || othIsReflexive;
  		        } else if (valIsUndefined) {
  		          setLow = othIsReflexive && (retHighest || othIsDefined);
  		        } else if (valIsNull) {
  		          setLow = othIsReflexive && othIsDefined && (retHighest || !othIsNull);
  		        } else if (valIsSymbol) {
  		          setLow = othIsReflexive && othIsDefined && !othIsNull && (retHighest || !othIsSymbol);
  		        } else if (othIsNull || othIsSymbol) {
  		          setLow = false;
  		        } else {
  		          setLow = retHighest ? (computed <= value) : (computed < value);
  		        }
  		        if (setLow) {
  		          low = mid + 1;
  		        } else {
  		          high = mid;
  		        }
  		      }
  		      return nativeMin(high, MAX_ARRAY_INDEX);
  		    }

  		    /**
  		     * The base implementation of `_.sortedUniq` and `_.sortedUniqBy` without
  		     * support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @returns {Array} Returns the new duplicate free array.
  		     */
  		    function baseSortedUniq(array, iteratee) {
  		      var index = -1,
  		          length = array.length,
  		          resIndex = 0,
  		          result = [];

  		      while (++index < length) {
  		        var value = array[index],
  		            computed = iteratee ? iteratee(value) : value;

  		        if (!index || !eq(computed, seen)) {
  		          var seen = computed;
  		          result[resIndex++] = value === 0 ? 0 : value;
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.toNumber` which doesn't ensure correct
  		     * conversions of binary, hexadecimal, or octal string values.
  		     *
  		     * @private
  		     * @param {*} value The value to process.
  		     * @returns {number} Returns the number.
  		     */
  		    function baseToNumber(value) {
  		      if (typeof value == 'number') {
  		        return value;
  		      }
  		      if (isSymbol(value)) {
  		        return NAN;
  		      }
  		      return +value;
  		    }

  		    /**
  		     * The base implementation of `_.toString` which doesn't convert nullish
  		     * values to empty strings.
  		     *
  		     * @private
  		     * @param {*} value The value to process.
  		     * @returns {string} Returns the string.
  		     */
  		    function baseToString(value) {
  		      // Exit early for strings to avoid a performance hit in some environments.
  		      if (typeof value == 'string') {
  		        return value;
  		      }
  		      if (isArray(value)) {
  		        // Recursively convert values (susceptible to call stack limits).
  		        return arrayMap(value, baseToString) + '';
  		      }
  		      if (isSymbol(value)) {
  		        return symbolToString ? symbolToString.call(value) : '';
  		      }
  		      var result = (value + '');
  		      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
  		    }

  		    /**
  		     * The base implementation of `_.uniqBy` without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new duplicate free array.
  		     */
  		    function baseUniq(array, iteratee, comparator) {
  		      var index = -1,
  		          includes = arrayIncludes,
  		          length = array.length,
  		          isCommon = true,
  		          result = [],
  		          seen = result;

  		      if (comparator) {
  		        isCommon = false;
  		        includes = arrayIncludesWith;
  		      }
  		      else if (length >= LARGE_ARRAY_SIZE) {
  		        var set = iteratee ? null : createSet(array);
  		        if (set) {
  		          return setToArray(set);
  		        }
  		        isCommon = false;
  		        includes = cacheHas;
  		        seen = new SetCache;
  		      }
  		      else {
  		        seen = iteratee ? [] : result;
  		      }
  		      outer:
  		      while (++index < length) {
  		        var value = array[index],
  		            computed = iteratee ? iteratee(value) : value;

  		        value = (comparator || value !== 0) ? value : 0;
  		        if (isCommon && computed === computed) {
  		          var seenIndex = seen.length;
  		          while (seenIndex--) {
  		            if (seen[seenIndex] === computed) {
  		              continue outer;
  		            }
  		          }
  		          if (iteratee) {
  		            seen.push(computed);
  		          }
  		          result.push(value);
  		        }
  		        else if (!includes(seen, computed, comparator)) {
  		          if (seen !== result) {
  		            seen.push(computed);
  		          }
  		          result.push(value);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * The base implementation of `_.unset`.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {Array|string} path The property path to unset.
  		     * @returns {boolean} Returns `true` if the property is deleted, else `false`.
  		     */
  		    function baseUnset(object, path) {
  		      path = castPath(path, object);
  		      object = parent(object, path);
  		      return object == null || delete object[toKey(last(path))];
  		    }

  		    /**
  		     * The base implementation of `_.update`.
  		     *
  		     * @private
  		     * @param {Object} object The object to modify.
  		     * @param {Array|string} path The path of the property to update.
  		     * @param {Function} updater The function to produce the updated value.
  		     * @param {Function} [customizer] The function to customize path creation.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function baseUpdate(object, path, updater, customizer) {
  		      return baseSet(object, path, updater(baseGet(object, path)), customizer);
  		    }

  		    /**
  		     * The base implementation of methods like `_.dropWhile` and `_.takeWhile`
  		     * without support for iteratee shorthands.
  		     *
  		     * @private
  		     * @param {Array} array The array to query.
  		     * @param {Function} predicate The function invoked per iteration.
  		     * @param {boolean} [isDrop] Specify dropping elements instead of taking them.
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Array} Returns the slice of `array`.
  		     */
  		    function baseWhile(array, predicate, isDrop, fromRight) {
  		      var length = array.length,
  		          index = fromRight ? length : -1;

  		      while ((fromRight ? index-- : ++index < length) &&
  		        predicate(array[index], index, array)) {}

  		      return isDrop
  		        ? baseSlice(array, (fromRight ? 0 : index), (fromRight ? index + 1 : length))
  		        : baseSlice(array, (fromRight ? index + 1 : 0), (fromRight ? length : index));
  		    }

  		    /**
  		     * The base implementation of `wrapperValue` which returns the result of
  		     * performing a sequence of actions on the unwrapped `value`, where each
  		     * successive action is supplied the return value of the previous.
  		     *
  		     * @private
  		     * @param {*} value The unwrapped value.
  		     * @param {Array} actions Actions to perform to resolve the unwrapped value.
  		     * @returns {*} Returns the resolved value.
  		     */
  		    function baseWrapperValue(value, actions) {
  		      var result = value;
  		      if (result instanceof LazyWrapper) {
  		        result = result.value();
  		      }
  		      return arrayReduce(actions, function(result, action) {
  		        return action.func.apply(action.thisArg, arrayPush([result], action.args));
  		      }, result);
  		    }

  		    /**
  		     * The base implementation of methods like `_.xor`, without support for
  		     * iteratee shorthands, that accepts an array of arrays to inspect.
  		     *
  		     * @private
  		     * @param {Array} arrays The arrays to inspect.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of values.
  		     */
  		    function baseXor(arrays, iteratee, comparator) {
  		      var length = arrays.length;
  		      if (length < 2) {
  		        return length ? baseUniq(arrays[0]) : [];
  		      }
  		      var index = -1,
  		          result = Array(length);

  		      while (++index < length) {
  		        var array = arrays[index],
  		            othIndex = -1;

  		        while (++othIndex < length) {
  		          if (othIndex != index) {
  		            result[index] = baseDifference(result[index] || array, arrays[othIndex], iteratee, comparator);
  		          }
  		        }
  		      }
  		      return baseUniq(baseFlatten(result, 1), iteratee, comparator);
  		    }

  		    /**
  		     * This base implementation of `_.zipObject` which assigns values using `assignFunc`.
  		     *
  		     * @private
  		     * @param {Array} props The property identifiers.
  		     * @param {Array} values The property values.
  		     * @param {Function} assignFunc The function to assign values.
  		     * @returns {Object} Returns the new object.
  		     */
  		    function baseZipObject(props, values, assignFunc) {
  		      var index = -1,
  		          length = props.length,
  		          valsLength = values.length,
  		          result = {};

  		      while (++index < length) {
  		        var value = index < valsLength ? values[index] : undefined$1;
  		        assignFunc(result, props[index], value);
  		      }
  		      return result;
  		    }

  		    /**
  		     * Casts `value` to an empty array if it's not an array like object.
  		     *
  		     * @private
  		     * @param {*} value The value to inspect.
  		     * @returns {Array|Object} Returns the cast array-like object.
  		     */
  		    function castArrayLikeObject(value) {
  		      return isArrayLikeObject(value) ? value : [];
  		    }

  		    /**
  		     * Casts `value` to `identity` if it's not a function.
  		     *
  		     * @private
  		     * @param {*} value The value to inspect.
  		     * @returns {Function} Returns cast function.
  		     */
  		    function castFunction(value) {
  		      return typeof value == 'function' ? value : identity;
  		    }

  		    /**
  		     * Casts `value` to a path array if it's not one.
  		     *
  		     * @private
  		     * @param {*} value The value to inspect.
  		     * @param {Object} [object] The object to query keys on.
  		     * @returns {Array} Returns the cast property path array.
  		     */
  		    function castPath(value, object) {
  		      if (isArray(value)) {
  		        return value;
  		      }
  		      return isKey(value, object) ? [value] : stringToPath(toString(value));
  		    }

  		    /**
  		     * A `baseRest` alias which can be replaced with `identity` by module
  		     * replacement plugins.
  		     *
  		     * @private
  		     * @type {Function}
  		     * @param {Function} func The function to apply a rest parameter to.
  		     * @returns {Function} Returns the new function.
  		     */
  		    var castRest = baseRest;

  		    /**
  		     * Casts `array` to a slice if it's needed.
  		     *
  		     * @private
  		     * @param {Array} array The array to inspect.
  		     * @param {number} start The start position.
  		     * @param {number} [end=array.length] The end position.
  		     * @returns {Array} Returns the cast slice.
  		     */
  		    function castSlice(array, start, end) {
  		      var length = array.length;
  		      end = end === undefined$1 ? length : end;
  		      return (!start && end >= length) ? array : baseSlice(array, start, end);
  		    }

  		    /**
  		     * A simple wrapper around the global [`clearTimeout`](https://mdn.io/clearTimeout).
  		     *
  		     * @private
  		     * @param {number|Object} id The timer id or timeout object of the timer to clear.
  		     */
  		    var clearTimeout = ctxClearTimeout || function(id) {
  		      return root.clearTimeout(id);
  		    };

  		    /**
  		     * Creates a clone of  `buffer`.
  		     *
  		     * @private
  		     * @param {Buffer} buffer The buffer to clone.
  		     * @param {boolean} [isDeep] Specify a deep clone.
  		     * @returns {Buffer} Returns the cloned buffer.
  		     */
  		    function cloneBuffer(buffer, isDeep) {
  		      if (isDeep) {
  		        return buffer.slice();
  		      }
  		      var length = buffer.length,
  		          result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);

  		      buffer.copy(result);
  		      return result;
  		    }

  		    /**
  		     * Creates a clone of `arrayBuffer`.
  		     *
  		     * @private
  		     * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
  		     * @returns {ArrayBuffer} Returns the cloned array buffer.
  		     */
  		    function cloneArrayBuffer(arrayBuffer) {
  		      var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
  		      new Uint8Array(result).set(new Uint8Array(arrayBuffer));
  		      return result;
  		    }

  		    /**
  		     * Creates a clone of `dataView`.
  		     *
  		     * @private
  		     * @param {Object} dataView The data view to clone.
  		     * @param {boolean} [isDeep] Specify a deep clone.
  		     * @returns {Object} Returns the cloned data view.
  		     */
  		    function cloneDataView(dataView, isDeep) {
  		      var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
  		      return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  		    }

  		    /**
  		     * Creates a clone of `regexp`.
  		     *
  		     * @private
  		     * @param {Object} regexp The regexp to clone.
  		     * @returns {Object} Returns the cloned regexp.
  		     */
  		    function cloneRegExp(regexp) {
  		      var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
  		      result.lastIndex = regexp.lastIndex;
  		      return result;
  		    }

  		    /**
  		     * Creates a clone of the `symbol` object.
  		     *
  		     * @private
  		     * @param {Object} symbol The symbol object to clone.
  		     * @returns {Object} Returns the cloned symbol object.
  		     */
  		    function cloneSymbol(symbol) {
  		      return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
  		    }

  		    /**
  		     * Creates a clone of `typedArray`.
  		     *
  		     * @private
  		     * @param {Object} typedArray The typed array to clone.
  		     * @param {boolean} [isDeep] Specify a deep clone.
  		     * @returns {Object} Returns the cloned typed array.
  		     */
  		    function cloneTypedArray(typedArray, isDeep) {
  		      var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
  		      return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  		    }

  		    /**
  		     * Compares values to sort them in ascending order.
  		     *
  		     * @private
  		     * @param {*} value The value to compare.
  		     * @param {*} other The other value to compare.
  		     * @returns {number} Returns the sort order indicator for `value`.
  		     */
  		    function compareAscending(value, other) {
  		      if (value !== other) {
  		        var valIsDefined = value !== undefined$1,
  		            valIsNull = value === null,
  		            valIsReflexive = value === value,
  		            valIsSymbol = isSymbol(value);

  		        var othIsDefined = other !== undefined$1,
  		            othIsNull = other === null,
  		            othIsReflexive = other === other,
  		            othIsSymbol = isSymbol(other);

  		        if ((!othIsNull && !othIsSymbol && !valIsSymbol && value > other) ||
  		            (valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol) ||
  		            (valIsNull && othIsDefined && othIsReflexive) ||
  		            (!valIsDefined && othIsReflexive) ||
  		            !valIsReflexive) {
  		          return 1;
  		        }
  		        if ((!valIsNull && !valIsSymbol && !othIsSymbol && value < other) ||
  		            (othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol) ||
  		            (othIsNull && valIsDefined && valIsReflexive) ||
  		            (!othIsDefined && valIsReflexive) ||
  		            !othIsReflexive) {
  		          return -1;
  		        }
  		      }
  		      return 0;
  		    }

  		    /**
  		     * Used by `_.orderBy` to compare multiple properties of a value to another
  		     * and stable sort them.
  		     *
  		     * If `orders` is unspecified, all values are sorted in ascending order. Otherwise,
  		     * specify an order of "desc" for descending or "asc" for ascending sort order
  		     * of corresponding values.
  		     *
  		     * @private
  		     * @param {Object} object The object to compare.
  		     * @param {Object} other The other object to compare.
  		     * @param {boolean[]|string[]} orders The order to sort by for each property.
  		     * @returns {number} Returns the sort order indicator for `object`.
  		     */
  		    function compareMultiple(object, other, orders) {
  		      var index = -1,
  		          objCriteria = object.criteria,
  		          othCriteria = other.criteria,
  		          length = objCriteria.length,
  		          ordersLength = orders.length;

  		      while (++index < length) {
  		        var result = compareAscending(objCriteria[index], othCriteria[index]);
  		        if (result) {
  		          if (index >= ordersLength) {
  		            return result;
  		          }
  		          var order = orders[index];
  		          return result * (order == 'desc' ? -1 : 1);
  		        }
  		      }
  		      // Fixes an `Array#sort` bug in the JS engine embedded in Adobe applications
  		      // that causes it, under certain circumstances, to provide the same value for
  		      // `object` and `other`. See https://github.com/jashkenas/underscore/pull/1247
  		      // for more details.
  		      //
  		      // This also ensures a stable sort in V8 and other engines.
  		      // See https://bugs.chromium.org/p/v8/issues/detail?id=90 for more details.
  		      return object.index - other.index;
  		    }

  		    /**
  		     * Creates an array that is the composition of partially applied arguments,
  		     * placeholders, and provided arguments into a single array of arguments.
  		     *
  		     * @private
  		     * @param {Array} args The provided arguments.
  		     * @param {Array} partials The arguments to prepend to those provided.
  		     * @param {Array} holders The `partials` placeholder indexes.
  		     * @params {boolean} [isCurried] Specify composing for a curried function.
  		     * @returns {Array} Returns the new array of composed arguments.
  		     */
  		    function composeArgs(args, partials, holders, isCurried) {
  		      var argsIndex = -1,
  		          argsLength = args.length,
  		          holdersLength = holders.length,
  		          leftIndex = -1,
  		          leftLength = partials.length,
  		          rangeLength = nativeMax(argsLength - holdersLength, 0),
  		          result = Array(leftLength + rangeLength),
  		          isUncurried = !isCurried;

  		      while (++leftIndex < leftLength) {
  		        result[leftIndex] = partials[leftIndex];
  		      }
  		      while (++argsIndex < holdersLength) {
  		        if (isUncurried || argsIndex < argsLength) {
  		          result[holders[argsIndex]] = args[argsIndex];
  		        }
  		      }
  		      while (rangeLength--) {
  		        result[leftIndex++] = args[argsIndex++];
  		      }
  		      return result;
  		    }

  		    /**
  		     * This function is like `composeArgs` except that the arguments composition
  		     * is tailored for `_.partialRight`.
  		     *
  		     * @private
  		     * @param {Array} args The provided arguments.
  		     * @param {Array} partials The arguments to append to those provided.
  		     * @param {Array} holders The `partials` placeholder indexes.
  		     * @params {boolean} [isCurried] Specify composing for a curried function.
  		     * @returns {Array} Returns the new array of composed arguments.
  		     */
  		    function composeArgsRight(args, partials, holders, isCurried) {
  		      var argsIndex = -1,
  		          argsLength = args.length,
  		          holdersIndex = -1,
  		          holdersLength = holders.length,
  		          rightIndex = -1,
  		          rightLength = partials.length,
  		          rangeLength = nativeMax(argsLength - holdersLength, 0),
  		          result = Array(rangeLength + rightLength),
  		          isUncurried = !isCurried;

  		      while (++argsIndex < rangeLength) {
  		        result[argsIndex] = args[argsIndex];
  		      }
  		      var offset = argsIndex;
  		      while (++rightIndex < rightLength) {
  		        result[offset + rightIndex] = partials[rightIndex];
  		      }
  		      while (++holdersIndex < holdersLength) {
  		        if (isUncurried || argsIndex < argsLength) {
  		          result[offset + holders[holdersIndex]] = args[argsIndex++];
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * Copies the values of `source` to `array`.
  		     *
  		     * @private
  		     * @param {Array} source The array to copy values from.
  		     * @param {Array} [array=[]] The array to copy values to.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function copyArray(source, array) {
  		      var index = -1,
  		          length = source.length;

  		      array || (array = Array(length));
  		      while (++index < length) {
  		        array[index] = source[index];
  		      }
  		      return array;
  		    }

  		    /**
  		     * Copies properties of `source` to `object`.
  		     *
  		     * @private
  		     * @param {Object} source The object to copy properties from.
  		     * @param {Array} props The property identifiers to copy.
  		     * @param {Object} [object={}] The object to copy properties to.
  		     * @param {Function} [customizer] The function to customize copied values.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function copyObject(source, props, object, customizer) {
  		      var isNew = !object;
  		      object || (object = {});

  		      var index = -1,
  		          length = props.length;

  		      while (++index < length) {
  		        var key = props[index];

  		        var newValue = customizer
  		          ? customizer(object[key], source[key], key, object, source)
  		          : undefined$1;

  		        if (newValue === undefined$1) {
  		          newValue = source[key];
  		        }
  		        if (isNew) {
  		          baseAssignValue(object, key, newValue);
  		        } else {
  		          assignValue(object, key, newValue);
  		        }
  		      }
  		      return object;
  		    }

  		    /**
  		     * Copies own symbols of `source` to `object`.
  		     *
  		     * @private
  		     * @param {Object} source The object to copy symbols from.
  		     * @param {Object} [object={}] The object to copy symbols to.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function copySymbols(source, object) {
  		      return copyObject(source, getSymbols(source), object);
  		    }

  		    /**
  		     * Copies own and inherited symbols of `source` to `object`.
  		     *
  		     * @private
  		     * @param {Object} source The object to copy symbols from.
  		     * @param {Object} [object={}] The object to copy symbols to.
  		     * @returns {Object} Returns `object`.
  		     */
  		    function copySymbolsIn(source, object) {
  		      return copyObject(source, getSymbolsIn(source), object);
  		    }

  		    /**
  		     * Creates a function like `_.groupBy`.
  		     *
  		     * @private
  		     * @param {Function} setter The function to set accumulator values.
  		     * @param {Function} [initializer] The accumulator object initializer.
  		     * @returns {Function} Returns the new aggregator function.
  		     */
  		    function createAggregator(setter, initializer) {
  		      return function(collection, iteratee) {
  		        var func = isArray(collection) ? arrayAggregator : baseAggregator,
  		            accumulator = initializer ? initializer() : {};

  		        return func(collection, setter, getIteratee(iteratee, 2), accumulator);
  		      };
  		    }

  		    /**
  		     * Creates a function like `_.assign`.
  		     *
  		     * @private
  		     * @param {Function} assigner The function to assign values.
  		     * @returns {Function} Returns the new assigner function.
  		     */
  		    function createAssigner(assigner) {
  		      return baseRest(function(object, sources) {
  		        var index = -1,
  		            length = sources.length,
  		            customizer = length > 1 ? sources[length - 1] : undefined$1,
  		            guard = length > 2 ? sources[2] : undefined$1;

  		        customizer = (assigner.length > 3 && typeof customizer == 'function')
  		          ? (length--, customizer)
  		          : undefined$1;

  		        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
  		          customizer = length < 3 ? undefined$1 : customizer;
  		          length = 1;
  		        }
  		        object = Object(object);
  		        while (++index < length) {
  		          var source = sources[index];
  		          if (source) {
  		            assigner(object, source, index, customizer);
  		          }
  		        }
  		        return object;
  		      });
  		    }

  		    /**
  		     * Creates a `baseEach` or `baseEachRight` function.
  		     *
  		     * @private
  		     * @param {Function} eachFunc The function to iterate over a collection.
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Function} Returns the new base function.
  		     */
  		    function createBaseEach(eachFunc, fromRight) {
  		      return function(collection, iteratee) {
  		        if (collection == null) {
  		          return collection;
  		        }
  		        if (!isArrayLike(collection)) {
  		          return eachFunc(collection, iteratee);
  		        }
  		        var length = collection.length,
  		            index = fromRight ? length : -1,
  		            iterable = Object(collection);

  		        while ((fromRight ? index-- : ++index < length)) {
  		          if (iteratee(iterable[index], index, iterable) === false) {
  		            break;
  		          }
  		        }
  		        return collection;
  		      };
  		    }

  		    /**
  		     * Creates a base function for methods like `_.forIn` and `_.forOwn`.
  		     *
  		     * @private
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Function} Returns the new base function.
  		     */
  		    function createBaseFor(fromRight) {
  		      return function(object, iteratee, keysFunc) {
  		        var index = -1,
  		            iterable = Object(object),
  		            props = keysFunc(object),
  		            length = props.length;

  		        while (length--) {
  		          var key = props[fromRight ? length : ++index];
  		          if (iteratee(iterable[key], key, iterable) === false) {
  		            break;
  		          }
  		        }
  		        return object;
  		      };
  		    }

  		    /**
  		     * Creates a function that wraps `func` to invoke it with the optional `this`
  		     * binding of `thisArg`.
  		     *
  		     * @private
  		     * @param {Function} func The function to wrap.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @param {*} [thisArg] The `this` binding of `func`.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createBind(func, bitmask, thisArg) {
  		      var isBind = bitmask & WRAP_BIND_FLAG,
  		          Ctor = createCtor(func);

  		      function wrapper() {
  		        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
  		        return fn.apply(isBind ? thisArg : this, arguments);
  		      }
  		      return wrapper;
  		    }

  		    /**
  		     * Creates a function like `_.lowerFirst`.
  		     *
  		     * @private
  		     * @param {string} methodName The name of the `String` case method to use.
  		     * @returns {Function} Returns the new case function.
  		     */
  		    function createCaseFirst(methodName) {
  		      return function(string) {
  		        string = toString(string);

  		        var strSymbols = hasUnicode(string)
  		          ? stringToArray(string)
  		          : undefined$1;

  		        var chr = strSymbols
  		          ? strSymbols[0]
  		          : string.charAt(0);

  		        var trailing = strSymbols
  		          ? castSlice(strSymbols, 1).join('')
  		          : string.slice(1);

  		        return chr[methodName]() + trailing;
  		      };
  		    }

  		    /**
  		     * Creates a function like `_.camelCase`.
  		     *
  		     * @private
  		     * @param {Function} callback The function to combine each word.
  		     * @returns {Function} Returns the new compounder function.
  		     */
  		    function createCompounder(callback) {
  		      return function(string) {
  		        return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
  		      };
  		    }

  		    /**
  		     * Creates a function that produces an instance of `Ctor` regardless of
  		     * whether it was invoked as part of a `new` expression or by `call` or `apply`.
  		     *
  		     * @private
  		     * @param {Function} Ctor The constructor to wrap.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createCtor(Ctor) {
  		      return function() {
  		        // Use a `switch` statement to work with class constructors. See
  		        // http://ecma-international.org/ecma-262/7.0/#sec-ecmascript-function-objects-call-thisargument-argumentslist
  		        // for more details.
  		        var args = arguments;
  		        switch (args.length) {
  		          case 0: return new Ctor;
  		          case 1: return new Ctor(args[0]);
  		          case 2: return new Ctor(args[0], args[1]);
  		          case 3: return new Ctor(args[0], args[1], args[2]);
  		          case 4: return new Ctor(args[0], args[1], args[2], args[3]);
  		          case 5: return new Ctor(args[0], args[1], args[2], args[3], args[4]);
  		          case 6: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5]);
  		          case 7: return new Ctor(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
  		        }
  		        var thisBinding = baseCreate(Ctor.prototype),
  		            result = Ctor.apply(thisBinding, args);

  		        // Mimic the constructor's `return` behavior.
  		        // See https://es5.github.io/#x13.2.2 for more details.
  		        return isObject(result) ? result : thisBinding;
  		      };
  		    }

  		    /**
  		     * Creates a function that wraps `func` to enable currying.
  		     *
  		     * @private
  		     * @param {Function} func The function to wrap.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @param {number} arity The arity of `func`.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createCurry(func, bitmask, arity) {
  		      var Ctor = createCtor(func);

  		      function wrapper() {
  		        var length = arguments.length,
  		            args = Array(length),
  		            index = length,
  		            placeholder = getHolder(wrapper);

  		        while (index--) {
  		          args[index] = arguments[index];
  		        }
  		        var holders = (length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder)
  		          ? []
  		          : replaceHolders(args, placeholder);

  		        length -= holders.length;
  		        if (length < arity) {
  		          return createRecurry(
  		            func, bitmask, createHybrid, wrapper.placeholder, undefined$1,
  		            args, holders, undefined$1, undefined$1, arity - length);
  		        }
  		        var fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;
  		        return apply(fn, this, args);
  		      }
  		      return wrapper;
  		    }

  		    /**
  		     * Creates a `_.find` or `_.findLast` function.
  		     *
  		     * @private
  		     * @param {Function} findIndexFunc The function to find the collection index.
  		     * @returns {Function} Returns the new find function.
  		     */
  		    function createFind(findIndexFunc) {
  		      return function(collection, predicate, fromIndex) {
  		        var iterable = Object(collection);
  		        if (!isArrayLike(collection)) {
  		          var iteratee = getIteratee(predicate, 3);
  		          collection = keys(collection);
  		          predicate = function(key) { return iteratee(iterable[key], key, iterable); };
  		        }
  		        var index = findIndexFunc(collection, predicate, fromIndex);
  		        return index > -1 ? iterable[iteratee ? collection[index] : index] : undefined$1;
  		      };
  		    }

  		    /**
  		     * Creates a `_.flow` or `_.flowRight` function.
  		     *
  		     * @private
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Function} Returns the new flow function.
  		     */
  		    function createFlow(fromRight) {
  		      return flatRest(function(funcs) {
  		        var length = funcs.length,
  		            index = length,
  		            prereq = LodashWrapper.prototype.thru;

  		        if (fromRight) {
  		          funcs.reverse();
  		        }
  		        while (index--) {
  		          var func = funcs[index];
  		          if (typeof func != 'function') {
  		            throw new TypeError(FUNC_ERROR_TEXT);
  		          }
  		          if (prereq && !wrapper && getFuncName(func) == 'wrapper') {
  		            var wrapper = new LodashWrapper([], true);
  		          }
  		        }
  		        index = wrapper ? index : length;
  		        while (++index < length) {
  		          func = funcs[index];

  		          var funcName = getFuncName(func),
  		              data = funcName == 'wrapper' ? getData(func) : undefined$1;

  		          if (data && isLaziable(data[0]) &&
  		                data[1] == (WRAP_ARY_FLAG | WRAP_CURRY_FLAG | WRAP_PARTIAL_FLAG | WRAP_REARG_FLAG) &&
  		                !data[4].length && data[9] == 1
  		              ) {
  		            wrapper = wrapper[getFuncName(data[0])].apply(wrapper, data[3]);
  		          } else {
  		            wrapper = (func.length == 1 && isLaziable(func))
  		              ? wrapper[funcName]()
  		              : wrapper.thru(func);
  		          }
  		        }
  		        return function() {
  		          var args = arguments,
  		              value = args[0];

  		          if (wrapper && args.length == 1 && isArray(value)) {
  		            return wrapper.plant(value).value();
  		          }
  		          var index = 0,
  		              result = length ? funcs[index].apply(this, args) : value;

  		          while (++index < length) {
  		            result = funcs[index].call(this, result);
  		          }
  		          return result;
  		        };
  		      });
  		    }

  		    /**
  		     * Creates a function that wraps `func` to invoke it with optional `this`
  		     * binding of `thisArg`, partial application, and currying.
  		     *
  		     * @private
  		     * @param {Function|string} func The function or method name to wrap.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @param {*} [thisArg] The `this` binding of `func`.
  		     * @param {Array} [partials] The arguments to prepend to those provided to
  		     *  the new function.
  		     * @param {Array} [holders] The `partials` placeholder indexes.
  		     * @param {Array} [partialsRight] The arguments to append to those provided
  		     *  to the new function.
  		     * @param {Array} [holdersRight] The `partialsRight` placeholder indexes.
  		     * @param {Array} [argPos] The argument positions of the new function.
  		     * @param {number} [ary] The arity cap of `func`.
  		     * @param {number} [arity] The arity of `func`.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createHybrid(func, bitmask, thisArg, partials, holders, partialsRight, holdersRight, argPos, ary, arity) {
  		      var isAry = bitmask & WRAP_ARY_FLAG,
  		          isBind = bitmask & WRAP_BIND_FLAG,
  		          isBindKey = bitmask & WRAP_BIND_KEY_FLAG,
  		          isCurried = bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG),
  		          isFlip = bitmask & WRAP_FLIP_FLAG,
  		          Ctor = isBindKey ? undefined$1 : createCtor(func);

  		      function wrapper() {
  		        var length = arguments.length,
  		            args = Array(length),
  		            index = length;

  		        while (index--) {
  		          args[index] = arguments[index];
  		        }
  		        if (isCurried) {
  		          var placeholder = getHolder(wrapper),
  		              holdersCount = countHolders(args, placeholder);
  		        }
  		        if (partials) {
  		          args = composeArgs(args, partials, holders, isCurried);
  		        }
  		        if (partialsRight) {
  		          args = composeArgsRight(args, partialsRight, holdersRight, isCurried);
  		        }
  		        length -= holdersCount;
  		        if (isCurried && length < arity) {
  		          var newHolders = replaceHolders(args, placeholder);
  		          return createRecurry(
  		            func, bitmask, createHybrid, wrapper.placeholder, thisArg,
  		            args, newHolders, argPos, ary, arity - length
  		          );
  		        }
  		        var thisBinding = isBind ? thisArg : this,
  		            fn = isBindKey ? thisBinding[func] : func;

  		        length = args.length;
  		        if (argPos) {
  		          args = reorder(args, argPos);
  		        } else if (isFlip && length > 1) {
  		          args.reverse();
  		        }
  		        if (isAry && ary < length) {
  		          args.length = ary;
  		        }
  		        if (this && this !== root && this instanceof wrapper) {
  		          fn = Ctor || createCtor(fn);
  		        }
  		        return fn.apply(thisBinding, args);
  		      }
  		      return wrapper;
  		    }

  		    /**
  		     * Creates a function like `_.invertBy`.
  		     *
  		     * @private
  		     * @param {Function} setter The function to set accumulator values.
  		     * @param {Function} toIteratee The function to resolve iteratees.
  		     * @returns {Function} Returns the new inverter function.
  		     */
  		    function createInverter(setter, toIteratee) {
  		      return function(object, iteratee) {
  		        return baseInverter(object, setter, toIteratee(iteratee), {});
  		      };
  		    }

  		    /**
  		     * Creates a function that performs a mathematical operation on two values.
  		     *
  		     * @private
  		     * @param {Function} operator The function to perform the operation.
  		     * @param {number} [defaultValue] The value used for `undefined` arguments.
  		     * @returns {Function} Returns the new mathematical operation function.
  		     */
  		    function createMathOperation(operator, defaultValue) {
  		      return function(value, other) {
  		        var result;
  		        if (value === undefined$1 && other === undefined$1) {
  		          return defaultValue;
  		        }
  		        if (value !== undefined$1) {
  		          result = value;
  		        }
  		        if (other !== undefined$1) {
  		          if (result === undefined$1) {
  		            return other;
  		          }
  		          if (typeof value == 'string' || typeof other == 'string') {
  		            value = baseToString(value);
  		            other = baseToString(other);
  		          } else {
  		            value = baseToNumber(value);
  		            other = baseToNumber(other);
  		          }
  		          result = operator(value, other);
  		        }
  		        return result;
  		      };
  		    }

  		    /**
  		     * Creates a function like `_.over`.
  		     *
  		     * @private
  		     * @param {Function} arrayFunc The function to iterate over iteratees.
  		     * @returns {Function} Returns the new over function.
  		     */
  		    function createOver(arrayFunc) {
  		      return flatRest(function(iteratees) {
  		        iteratees = arrayMap(iteratees, baseUnary(getIteratee()));
  		        return baseRest(function(args) {
  		          var thisArg = this;
  		          return arrayFunc(iteratees, function(iteratee) {
  		            return apply(iteratee, thisArg, args);
  		          });
  		        });
  		      });
  		    }

  		    /**
  		     * Creates the padding for `string` based on `length`. The `chars` string
  		     * is truncated if the number of characters exceeds `length`.
  		     *
  		     * @private
  		     * @param {number} length The padding length.
  		     * @param {string} [chars=' '] The string used as padding.
  		     * @returns {string} Returns the padding for `string`.
  		     */
  		    function createPadding(length, chars) {
  		      chars = chars === undefined$1 ? ' ' : baseToString(chars);

  		      var charsLength = chars.length;
  		      if (charsLength < 2) {
  		        return charsLength ? baseRepeat(chars, length) : chars;
  		      }
  		      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
  		      return hasUnicode(chars)
  		        ? castSlice(stringToArray(result), 0, length).join('')
  		        : result.slice(0, length);
  		    }

  		    /**
  		     * Creates a function that wraps `func` to invoke it with the `this` binding
  		     * of `thisArg` and `partials` prepended to the arguments it receives.
  		     *
  		     * @private
  		     * @param {Function} func The function to wrap.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @param {*} thisArg The `this` binding of `func`.
  		     * @param {Array} partials The arguments to prepend to those provided to
  		     *  the new function.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createPartial(func, bitmask, thisArg, partials) {
  		      var isBind = bitmask & WRAP_BIND_FLAG,
  		          Ctor = createCtor(func);

  		      function wrapper() {
  		        var argsIndex = -1,
  		            argsLength = arguments.length,
  		            leftIndex = -1,
  		            leftLength = partials.length,
  		            args = Array(leftLength + argsLength),
  		            fn = (this && this !== root && this instanceof wrapper) ? Ctor : func;

  		        while (++leftIndex < leftLength) {
  		          args[leftIndex] = partials[leftIndex];
  		        }
  		        while (argsLength--) {
  		          args[leftIndex++] = arguments[++argsIndex];
  		        }
  		        return apply(fn, isBind ? thisArg : this, args);
  		      }
  		      return wrapper;
  		    }

  		    /**
  		     * Creates a `_.range` or `_.rangeRight` function.
  		     *
  		     * @private
  		     * @param {boolean} [fromRight] Specify iterating from right to left.
  		     * @returns {Function} Returns the new range function.
  		     */
  		    function createRange(fromRight) {
  		      return function(start, end, step) {
  		        if (step && typeof step != 'number' && isIterateeCall(start, end, step)) {
  		          end = step = undefined$1;
  		        }
  		        // Ensure the sign of `-0` is preserved.
  		        start = toFinite(start);
  		        if (end === undefined$1) {
  		          end = start;
  		          start = 0;
  		        } else {
  		          end = toFinite(end);
  		        }
  		        step = step === undefined$1 ? (start < end ? 1 : -1) : toFinite(step);
  		        return baseRange(start, end, step, fromRight);
  		      };
  		    }

  		    /**
  		     * Creates a function that performs a relational operation on two values.
  		     *
  		     * @private
  		     * @param {Function} operator The function to perform the operation.
  		     * @returns {Function} Returns the new relational operation function.
  		     */
  		    function createRelationalOperation(operator) {
  		      return function(value, other) {
  		        if (!(typeof value == 'string' && typeof other == 'string')) {
  		          value = toNumber(value);
  		          other = toNumber(other);
  		        }
  		        return operator(value, other);
  		      };
  		    }

  		    /**
  		     * Creates a function that wraps `func` to continue currying.
  		     *
  		     * @private
  		     * @param {Function} func The function to wrap.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @param {Function} wrapFunc The function to create the `func` wrapper.
  		     * @param {*} placeholder The placeholder value.
  		     * @param {*} [thisArg] The `this` binding of `func`.
  		     * @param {Array} [partials] The arguments to prepend to those provided to
  		     *  the new function.
  		     * @param {Array} [holders] The `partials` placeholder indexes.
  		     * @param {Array} [argPos] The argument positions of the new function.
  		     * @param {number} [ary] The arity cap of `func`.
  		     * @param {number} [arity] The arity of `func`.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createRecurry(func, bitmask, wrapFunc, placeholder, thisArg, partials, holders, argPos, ary, arity) {
  		      var isCurry = bitmask & WRAP_CURRY_FLAG,
  		          newHolders = isCurry ? holders : undefined$1,
  		          newHoldersRight = isCurry ? undefined$1 : holders,
  		          newPartials = isCurry ? partials : undefined$1,
  		          newPartialsRight = isCurry ? undefined$1 : partials;

  		      bitmask |= (isCurry ? WRAP_PARTIAL_FLAG : WRAP_PARTIAL_RIGHT_FLAG);
  		      bitmask &= ~(isCurry ? WRAP_PARTIAL_RIGHT_FLAG : WRAP_PARTIAL_FLAG);

  		      if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
  		        bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
  		      }
  		      var newData = [
  		        func, bitmask, thisArg, newPartials, newHolders, newPartialsRight,
  		        newHoldersRight, argPos, ary, arity
  		      ];

  		      var result = wrapFunc.apply(undefined$1, newData);
  		      if (isLaziable(func)) {
  		        setData(result, newData);
  		      }
  		      result.placeholder = placeholder;
  		      return setWrapToString(result, func, bitmask);
  		    }

  		    /**
  		     * Creates a function like `_.round`.
  		     *
  		     * @private
  		     * @param {string} methodName The name of the `Math` method to use when rounding.
  		     * @returns {Function} Returns the new round function.
  		     */
  		    function createRound(methodName) {
  		      var func = Math[methodName];
  		      return function(number, precision) {
  		        number = toNumber(number);
  		        precision = precision == null ? 0 : nativeMin(toInteger(precision), 292);
  		        if (precision && nativeIsFinite(number)) {
  		          // Shift with exponential notation to avoid floating-point issues.
  		          // See [MDN](https://mdn.io/round#Examples) for more details.
  		          var pair = (toString(number) + 'e').split('e'),
  		              value = func(pair[0] + 'e' + (+pair[1] + precision));

  		          pair = (toString(value) + 'e').split('e');
  		          return +(pair[0] + 'e' + (+pair[1] - precision));
  		        }
  		        return func(number);
  		      };
  		    }

  		    /**
  		     * Creates a set object of `values`.
  		     *
  		     * @private
  		     * @param {Array} values The values to add to the set.
  		     * @returns {Object} Returns the new set.
  		     */
  		    var createSet = !(Set && (1 / setToArray(new Set([,-0]))[1]) == INFINITY) ? noop : function(values) {
  		      return new Set(values);
  		    };

  		    /**
  		     * Creates a `_.toPairs` or `_.toPairsIn` function.
  		     *
  		     * @private
  		     * @param {Function} keysFunc The function to get the keys of a given object.
  		     * @returns {Function} Returns the new pairs function.
  		     */
  		    function createToPairs(keysFunc) {
  		      return function(object) {
  		        var tag = getTag(object);
  		        if (tag == mapTag) {
  		          return mapToArray(object);
  		        }
  		        if (tag == setTag) {
  		          return setToPairs(object);
  		        }
  		        return baseToPairs(object, keysFunc(object));
  		      };
  		    }

  		    /**
  		     * Creates a function that either curries or invokes `func` with optional
  		     * `this` binding and partially applied arguments.
  		     *
  		     * @private
  		     * @param {Function|string} func The function or method name to wrap.
  		     * @param {number} bitmask The bitmask flags.
  		     *    1 - `_.bind`
  		     *    2 - `_.bindKey`
  		     *    4 - `_.curry` or `_.curryRight` of a bound function
  		     *    8 - `_.curry`
  		     *   16 - `_.curryRight`
  		     *   32 - `_.partial`
  		     *   64 - `_.partialRight`
  		     *  128 - `_.rearg`
  		     *  256 - `_.ary`
  		     *  512 - `_.flip`
  		     * @param {*} [thisArg] The `this` binding of `func`.
  		     * @param {Array} [partials] The arguments to be partially applied.
  		     * @param {Array} [holders] The `partials` placeholder indexes.
  		     * @param {Array} [argPos] The argument positions of the new function.
  		     * @param {number} [ary] The arity cap of `func`.
  		     * @param {number} [arity] The arity of `func`.
  		     * @returns {Function} Returns the new wrapped function.
  		     */
  		    function createWrap(func, bitmask, thisArg, partials, holders, argPos, ary, arity) {
  		      var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
  		      if (!isBindKey && typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      var length = partials ? partials.length : 0;
  		      if (!length) {
  		        bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
  		        partials = holders = undefined$1;
  		      }
  		      ary = ary === undefined$1 ? ary : nativeMax(toInteger(ary), 0);
  		      arity = arity === undefined$1 ? arity : toInteger(arity);
  		      length -= holders ? holders.length : 0;

  		      if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
  		        var partialsRight = partials,
  		            holdersRight = holders;

  		        partials = holders = undefined$1;
  		      }
  		      var data = isBindKey ? undefined$1 : getData(func);

  		      var newData = [
  		        func, bitmask, thisArg, partials, holders, partialsRight, holdersRight,
  		        argPos, ary, arity
  		      ];

  		      if (data) {
  		        mergeData(newData, data);
  		      }
  		      func = newData[0];
  		      bitmask = newData[1];
  		      thisArg = newData[2];
  		      partials = newData[3];
  		      holders = newData[4];
  		      arity = newData[9] = newData[9] === undefined$1
  		        ? (isBindKey ? 0 : func.length)
  		        : nativeMax(newData[9] - length, 0);

  		      if (!arity && bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)) {
  		        bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
  		      }
  		      if (!bitmask || bitmask == WRAP_BIND_FLAG) {
  		        var result = createBind(func, bitmask, thisArg);
  		      } else if (bitmask == WRAP_CURRY_FLAG || bitmask == WRAP_CURRY_RIGHT_FLAG) {
  		        result = createCurry(func, bitmask, arity);
  		      } else if ((bitmask == WRAP_PARTIAL_FLAG || bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) && !holders.length) {
  		        result = createPartial(func, bitmask, thisArg, partials);
  		      } else {
  		        result = createHybrid.apply(undefined$1, newData);
  		      }
  		      var setter = data ? baseSetData : setData;
  		      return setWrapToString(setter(result, newData), func, bitmask);
  		    }

  		    /**
  		     * Used by `_.defaults` to customize its `_.assignIn` use to assign properties
  		     * of source objects to the destination object for all destination properties
  		     * that resolve to `undefined`.
  		     *
  		     * @private
  		     * @param {*} objValue The destination value.
  		     * @param {*} srcValue The source value.
  		     * @param {string} key The key of the property to assign.
  		     * @param {Object} object The parent object of `objValue`.
  		     * @returns {*} Returns the value to assign.
  		     */
  		    function customDefaultsAssignIn(objValue, srcValue, key, object) {
  		      if (objValue === undefined$1 ||
  		          (eq(objValue, objectProto[key]) && !hasOwnProperty.call(object, key))) {
  		        return srcValue;
  		      }
  		      return objValue;
  		    }

  		    /**
  		     * Used by `_.defaultsDeep` to customize its `_.merge` use to merge source
  		     * objects into destination objects that are passed thru.
  		     *
  		     * @private
  		     * @param {*} objValue The destination value.
  		     * @param {*} srcValue The source value.
  		     * @param {string} key The key of the property to merge.
  		     * @param {Object} object The parent object of `objValue`.
  		     * @param {Object} source The parent object of `srcValue`.
  		     * @param {Object} [stack] Tracks traversed source values and their merged
  		     *  counterparts.
  		     * @returns {*} Returns the value to assign.
  		     */
  		    function customDefaultsMerge(objValue, srcValue, key, object, source, stack) {
  		      if (isObject(objValue) && isObject(srcValue)) {
  		        // Recursively merge objects and arrays (susceptible to call stack limits).
  		        stack.set(srcValue, objValue);
  		        baseMerge(objValue, srcValue, undefined$1, customDefaultsMerge, stack);
  		        stack['delete'](srcValue);
  		      }
  		      return objValue;
  		    }

  		    /**
  		     * Used by `_.omit` to customize its `_.cloneDeep` use to only clone plain
  		     * objects.
  		     *
  		     * @private
  		     * @param {*} value The value to inspect.
  		     * @param {string} key The key of the property to inspect.
  		     * @returns {*} Returns the uncloned value or `undefined` to defer cloning to `_.cloneDeep`.
  		     */
  		    function customOmitClone(value) {
  		      return isPlainObject(value) ? undefined$1 : value;
  		    }

  		    /**
  		     * A specialized version of `baseIsEqualDeep` for arrays with support for
  		     * partial deep comparisons.
  		     *
  		     * @private
  		     * @param {Array} array The array to compare.
  		     * @param {Array} other The other array to compare.
  		     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  		     * @param {Function} customizer The function to customize comparisons.
  		     * @param {Function} equalFunc The function to determine equivalents of values.
  		     * @param {Object} stack Tracks traversed `array` and `other` objects.
  		     * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.
  		     */
  		    function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
  		      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
  		          arrLength = array.length,
  		          othLength = other.length;

  		      if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
  		        return false;
  		      }
  		      // Check that cyclic values are equal.
  		      var arrStacked = stack.get(array);
  		      var othStacked = stack.get(other);
  		      if (arrStacked && othStacked) {
  		        return arrStacked == other && othStacked == array;
  		      }
  		      var index = -1,
  		          result = true,
  		          seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined$1;

  		      stack.set(array, other);
  		      stack.set(other, array);

  		      // Ignore non-index properties.
  		      while (++index < arrLength) {
  		        var arrValue = array[index],
  		            othValue = other[index];

  		        if (customizer) {
  		          var compared = isPartial
  		            ? customizer(othValue, arrValue, index, other, array, stack)
  		            : customizer(arrValue, othValue, index, array, other, stack);
  		        }
  		        if (compared !== undefined$1) {
  		          if (compared) {
  		            continue;
  		          }
  		          result = false;
  		          break;
  		        }
  		        // Recursively compare arrays (susceptible to call stack limits).
  		        if (seen) {
  		          if (!arraySome(other, function(othValue, othIndex) {
  		                if (!cacheHas(seen, othIndex) &&
  		                    (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
  		                  return seen.push(othIndex);
  		                }
  		              })) {
  		            result = false;
  		            break;
  		          }
  		        } else if (!(
  		              arrValue === othValue ||
  		                equalFunc(arrValue, othValue, bitmask, customizer, stack)
  		            )) {
  		          result = false;
  		          break;
  		        }
  		      }
  		      stack['delete'](array);
  		      stack['delete'](other);
  		      return result;
  		    }

  		    /**
  		     * A specialized version of `baseIsEqualDeep` for comparing objects of
  		     * the same `toStringTag`.
  		     *
  		     * **Note:** This function only supports comparing values with tags of
  		     * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
  		     *
  		     * @private
  		     * @param {Object} object The object to compare.
  		     * @param {Object} other The other object to compare.
  		     * @param {string} tag The `toStringTag` of the objects to compare.
  		     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  		     * @param {Function} customizer The function to customize comparisons.
  		     * @param {Function} equalFunc The function to determine equivalents of values.
  		     * @param {Object} stack Tracks traversed `object` and `other` objects.
  		     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  		     */
  		    function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
  		      switch (tag) {
  		        case dataViewTag:
  		          if ((object.byteLength != other.byteLength) ||
  		              (object.byteOffset != other.byteOffset)) {
  		            return false;
  		          }
  		          object = object.buffer;
  		          other = other.buffer;

  		        case arrayBufferTag:
  		          if ((object.byteLength != other.byteLength) ||
  		              !equalFunc(new Uint8Array(object), new Uint8Array(other))) {
  		            return false;
  		          }
  		          return true;

  		        case boolTag:
  		        case dateTag:
  		        case numberTag:
  		          // Coerce booleans to `1` or `0` and dates to milliseconds.
  		          // Invalid dates are coerced to `NaN`.
  		          return eq(+object, +other);

  		        case errorTag:
  		          return object.name == other.name && object.message == other.message;

  		        case regexpTag:
  		        case stringTag:
  		          // Coerce regexes to strings and treat strings, primitives and objects,
  		          // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring
  		          // for more details.
  		          return object == (other + '');

  		        case mapTag:
  		          var convert = mapToArray;

  		        case setTag:
  		          var isPartial = bitmask & COMPARE_PARTIAL_FLAG;
  		          convert || (convert = setToArray);

  		          if (object.size != other.size && !isPartial) {
  		            return false;
  		          }
  		          // Assume cyclic values are equal.
  		          var stacked = stack.get(object);
  		          if (stacked) {
  		            return stacked == other;
  		          }
  		          bitmask |= COMPARE_UNORDERED_FLAG;

  		          // Recursively compare objects (susceptible to call stack limits).
  		          stack.set(object, other);
  		          var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
  		          stack['delete'](object);
  		          return result;

  		        case symbolTag:
  		          if (symbolValueOf) {
  		            return symbolValueOf.call(object) == symbolValueOf.call(other);
  		          }
  		      }
  		      return false;
  		    }

  		    /**
  		     * A specialized version of `baseIsEqualDeep` for objects with support for
  		     * partial deep comparisons.
  		     *
  		     * @private
  		     * @param {Object} object The object to compare.
  		     * @param {Object} other The other object to compare.
  		     * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.
  		     * @param {Function} customizer The function to customize comparisons.
  		     * @param {Function} equalFunc The function to determine equivalents of values.
  		     * @param {Object} stack Tracks traversed `object` and `other` objects.
  		     * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.
  		     */
  		    function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
  		      var isPartial = bitmask & COMPARE_PARTIAL_FLAG,
  		          objProps = getAllKeys(object),
  		          objLength = objProps.length,
  		          othProps = getAllKeys(other),
  		          othLength = othProps.length;

  		      if (objLength != othLength && !isPartial) {
  		        return false;
  		      }
  		      var index = objLength;
  		      while (index--) {
  		        var key = objProps[index];
  		        if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {
  		          return false;
  		        }
  		      }
  		      // Check that cyclic values are equal.
  		      var objStacked = stack.get(object);
  		      var othStacked = stack.get(other);
  		      if (objStacked && othStacked) {
  		        return objStacked == other && othStacked == object;
  		      }
  		      var result = true;
  		      stack.set(object, other);
  		      stack.set(other, object);

  		      var skipCtor = isPartial;
  		      while (++index < objLength) {
  		        key = objProps[index];
  		        var objValue = object[key],
  		            othValue = other[key];

  		        if (customizer) {
  		          var compared = isPartial
  		            ? customizer(othValue, objValue, key, other, object, stack)
  		            : customizer(objValue, othValue, key, object, other, stack);
  		        }
  		        // Recursively compare objects (susceptible to call stack limits).
  		        if (!(compared === undefined$1
  		              ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))
  		              : compared
  		            )) {
  		          result = false;
  		          break;
  		        }
  		        skipCtor || (skipCtor = key == 'constructor');
  		      }
  		      if (result && !skipCtor) {
  		        var objCtor = object.constructor,
  		            othCtor = other.constructor;

  		        // Non `Object` object instances with different constructors are not equal.
  		        if (objCtor != othCtor &&
  		            ('constructor' in object && 'constructor' in other) &&
  		            !(typeof objCtor == 'function' && objCtor instanceof objCtor &&
  		              typeof othCtor == 'function' && othCtor instanceof othCtor)) {
  		          result = false;
  		        }
  		      }
  		      stack['delete'](object);
  		      stack['delete'](other);
  		      return result;
  		    }

  		    /**
  		     * A specialized version of `baseRest` which flattens the rest array.
  		     *
  		     * @private
  		     * @param {Function} func The function to apply a rest parameter to.
  		     * @returns {Function} Returns the new function.
  		     */
  		    function flatRest(func) {
  		      return setToString(overRest(func, undefined$1, flatten), func + '');
  		    }

  		    /**
  		     * Creates an array of own enumerable property names and symbols of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of property names and symbols.
  		     */
  		    function getAllKeys(object) {
  		      return baseGetAllKeys(object, keys, getSymbols);
  		    }

  		    /**
  		     * Creates an array of own and inherited enumerable property names and
  		     * symbols of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of property names and symbols.
  		     */
  		    function getAllKeysIn(object) {
  		      return baseGetAllKeys(object, keysIn, getSymbolsIn);
  		    }

  		    /**
  		     * Gets metadata for `func`.
  		     *
  		     * @private
  		     * @param {Function} func The function to query.
  		     * @returns {*} Returns the metadata for `func`.
  		     */
  		    var getData = !metaMap ? noop : function(func) {
  		      return metaMap.get(func);
  		    };

  		    /**
  		     * Gets the name of `func`.
  		     *
  		     * @private
  		     * @param {Function} func The function to query.
  		     * @returns {string} Returns the function name.
  		     */
  		    function getFuncName(func) {
  		      var result = (func.name + ''),
  		          array = realNames[result],
  		          length = hasOwnProperty.call(realNames, result) ? array.length : 0;

  		      while (length--) {
  		        var data = array[length],
  		            otherFunc = data.func;
  		        if (otherFunc == null || otherFunc == func) {
  		          return data.name;
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * Gets the argument placeholder value for `func`.
  		     *
  		     * @private
  		     * @param {Function} func The function to inspect.
  		     * @returns {*} Returns the placeholder value.
  		     */
  		    function getHolder(func) {
  		      var object = hasOwnProperty.call(lodash, 'placeholder') ? lodash : func;
  		      return object.placeholder;
  		    }

  		    /**
  		     * Gets the appropriate "iteratee" function. If `_.iteratee` is customized,
  		     * this function returns the custom method, otherwise it returns `baseIteratee`.
  		     * If arguments are provided, the chosen function is invoked with them and
  		     * its result is returned.
  		     *
  		     * @private
  		     * @param {*} [value] The value to convert to an iteratee.
  		     * @param {number} [arity] The arity of the created iteratee.
  		     * @returns {Function} Returns the chosen function or its result.
  		     */
  		    function getIteratee() {
  		      var result = lodash.iteratee || iteratee;
  		      result = result === iteratee ? baseIteratee : result;
  		      return arguments.length ? result(arguments[0], arguments[1]) : result;
  		    }

  		    /**
  		     * Gets the data for `map`.
  		     *
  		     * @private
  		     * @param {Object} map The map to query.
  		     * @param {string} key The reference key.
  		     * @returns {*} Returns the map data.
  		     */
  		    function getMapData(map, key) {
  		      var data = map.__data__;
  		      return isKeyable(key)
  		        ? data[typeof key == 'string' ? 'string' : 'hash']
  		        : data.map;
  		    }

  		    /**
  		     * Gets the property names, values, and compare flags of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the match data of `object`.
  		     */
  		    function getMatchData(object) {
  		      var result = keys(object),
  		          length = result.length;

  		      while (length--) {
  		        var key = result[length],
  		            value = object[key];

  		        result[length] = [key, value, isStrictComparable(value)];
  		      }
  		      return result;
  		    }

  		    /**
  		     * Gets the native function at `key` of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {string} key The key of the method to get.
  		     * @returns {*} Returns the function if it's native, else `undefined`.
  		     */
  		    function getNative(object, key) {
  		      var value = getValue(object, key);
  		      return baseIsNative(value) ? value : undefined$1;
  		    }

  		    /**
  		     * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
  		     *
  		     * @private
  		     * @param {*} value The value to query.
  		     * @returns {string} Returns the raw `toStringTag`.
  		     */
  		    function getRawTag(value) {
  		      var isOwn = hasOwnProperty.call(value, symToStringTag),
  		          tag = value[symToStringTag];

  		      try {
  		        value[symToStringTag] = undefined$1;
  		        var unmasked = true;
  		      } catch (e) {}

  		      var result = nativeObjectToString.call(value);
  		      if (unmasked) {
  		        if (isOwn) {
  		          value[symToStringTag] = tag;
  		        } else {
  		          delete value[symToStringTag];
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * Creates an array of the own enumerable symbols of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of symbols.
  		     */
  		    var getSymbols = !nativeGetSymbols ? stubArray : function(object) {
  		      if (object == null) {
  		        return [];
  		      }
  		      object = Object(object);
  		      return arrayFilter(nativeGetSymbols(object), function(symbol) {
  		        return propertyIsEnumerable.call(object, symbol);
  		      });
  		    };

  		    /**
  		     * Creates an array of the own and inherited enumerable symbols of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of symbols.
  		     */
  		    var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
  		      var result = [];
  		      while (object) {
  		        arrayPush(result, getSymbols(object));
  		        object = getPrototype(object);
  		      }
  		      return result;
  		    };

  		    /**
  		     * Gets the `toStringTag` of `value`.
  		     *
  		     * @private
  		     * @param {*} value The value to query.
  		     * @returns {string} Returns the `toStringTag`.
  		     */
  		    var getTag = baseGetTag;

  		    // Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.
  		    if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
  		        (Map && getTag(new Map) != mapTag) ||
  		        (Promise && getTag(Promise.resolve()) != promiseTag) ||
  		        (Set && getTag(new Set) != setTag) ||
  		        (WeakMap && getTag(new WeakMap) != weakMapTag)) {
  		      getTag = function(value) {
  		        var result = baseGetTag(value),
  		            Ctor = result == objectTag ? value.constructor : undefined$1,
  		            ctorString = Ctor ? toSource(Ctor) : '';

  		        if (ctorString) {
  		          switch (ctorString) {
  		            case dataViewCtorString: return dataViewTag;
  		            case mapCtorString: return mapTag;
  		            case promiseCtorString: return promiseTag;
  		            case setCtorString: return setTag;
  		            case weakMapCtorString: return weakMapTag;
  		          }
  		        }
  		        return result;
  		      };
  		    }

  		    /**
  		     * Gets the view, applying any `transforms` to the `start` and `end` positions.
  		     *
  		     * @private
  		     * @param {number} start The start of the view.
  		     * @param {number} end The end of the view.
  		     * @param {Array} transforms The transformations to apply to the view.
  		     * @returns {Object} Returns an object containing the `start` and `end`
  		     *  positions of the view.
  		     */
  		    function getView(start, end, transforms) {
  		      var index = -1,
  		          length = transforms.length;

  		      while (++index < length) {
  		        var data = transforms[index],
  		            size = data.size;

  		        switch (data.type) {
  		          case 'drop':      start += size; break;
  		          case 'dropRight': end -= size; break;
  		          case 'take':      end = nativeMin(end, start + size); break;
  		          case 'takeRight': start = nativeMax(start, end - size); break;
  		        }
  		      }
  		      return { 'start': start, 'end': end };
  		    }

  		    /**
  		     * Extracts wrapper details from the `source` body comment.
  		     *
  		     * @private
  		     * @param {string} source The source to inspect.
  		     * @returns {Array} Returns the wrapper details.
  		     */
  		    function getWrapDetails(source) {
  		      var match = source.match(reWrapDetails);
  		      return match ? match[1].split(reSplitDetails) : [];
  		    }

  		    /**
  		     * Checks if `path` exists on `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {Array|string} path The path to check.
  		     * @param {Function} hasFunc The function to check properties.
  		     * @returns {boolean} Returns `true` if `path` exists, else `false`.
  		     */
  		    function hasPath(object, path, hasFunc) {
  		      path = castPath(path, object);

  		      var index = -1,
  		          length = path.length,
  		          result = false;

  		      while (++index < length) {
  		        var key = toKey(path[index]);
  		        if (!(result = object != null && hasFunc(object, key))) {
  		          break;
  		        }
  		        object = object[key];
  		      }
  		      if (result || ++index != length) {
  		        return result;
  		      }
  		      length = object == null ? 0 : object.length;
  		      return !!length && isLength(length) && isIndex(key, length) &&
  		        (isArray(object) || isArguments(object));
  		    }

  		    /**
  		     * Initializes an array clone.
  		     *
  		     * @private
  		     * @param {Array} array The array to clone.
  		     * @returns {Array} Returns the initialized clone.
  		     */
  		    function initCloneArray(array) {
  		      var length = array.length,
  		          result = new array.constructor(length);

  		      // Add properties assigned by `RegExp#exec`.
  		      if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
  		        result.index = array.index;
  		        result.input = array.input;
  		      }
  		      return result;
  		    }

  		    /**
  		     * Initializes an object clone.
  		     *
  		     * @private
  		     * @param {Object} object The object to clone.
  		     * @returns {Object} Returns the initialized clone.
  		     */
  		    function initCloneObject(object) {
  		      return (typeof object.constructor == 'function' && !isPrototype(object))
  		        ? baseCreate(getPrototype(object))
  		        : {};
  		    }

  		    /**
  		     * Initializes an object clone based on its `toStringTag`.
  		     *
  		     * **Note:** This function only supports cloning values with tags of
  		     * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.
  		     *
  		     * @private
  		     * @param {Object} object The object to clone.
  		     * @param {string} tag The `toStringTag` of the object to clone.
  		     * @param {boolean} [isDeep] Specify a deep clone.
  		     * @returns {Object} Returns the initialized clone.
  		     */
  		    function initCloneByTag(object, tag, isDeep) {
  		      var Ctor = object.constructor;
  		      switch (tag) {
  		        case arrayBufferTag:
  		          return cloneArrayBuffer(object);

  		        case boolTag:
  		        case dateTag:
  		          return new Ctor(+object);

  		        case dataViewTag:
  		          return cloneDataView(object, isDeep);

  		        case float32Tag: case float64Tag:
  		        case int8Tag: case int16Tag: case int32Tag:
  		        case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
  		          return cloneTypedArray(object, isDeep);

  		        case mapTag:
  		          return new Ctor;

  		        case numberTag:
  		        case stringTag:
  		          return new Ctor(object);

  		        case regexpTag:
  		          return cloneRegExp(object);

  		        case setTag:
  		          return new Ctor;

  		        case symbolTag:
  		          return cloneSymbol(object);
  		      }
  		    }

  		    /**
  		     * Inserts wrapper `details` in a comment at the top of the `source` body.
  		     *
  		     * @private
  		     * @param {string} source The source to modify.
  		     * @returns {Array} details The details to insert.
  		     * @returns {string} Returns the modified source.
  		     */
  		    function insertWrapDetails(source, details) {
  		      var length = details.length;
  		      if (!length) {
  		        return source;
  		      }
  		      var lastIndex = length - 1;
  		      details[lastIndex] = (length > 1 ? '& ' : '') + details[lastIndex];
  		      details = details.join(length > 2 ? ', ' : ' ');
  		      return source.replace(reWrapComment, '{\n/* [wrapped with ' + details + '] */\n');
  		    }

  		    /**
  		     * Checks if `value` is a flattenable `arguments` object or array.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
  		     */
  		    function isFlattenable(value) {
  		      return isArray(value) || isArguments(value) ||
  		        !!(spreadableSymbol && value && value[spreadableSymbol]);
  		    }

  		    /**
  		     * Checks if `value` is a valid array-like index.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
  		     * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
  		     */
  		    function isIndex(value, length) {
  		      var type = typeof value;
  		      length = length == null ? MAX_SAFE_INTEGER : length;

  		      return !!length &&
  		        (type == 'number' ||
  		          (type != 'symbol' && reIsUint.test(value))) &&
  		            (value > -1 && value % 1 == 0 && value < length);
  		    }

  		    /**
  		     * Checks if the given arguments are from an iteratee call.
  		     *
  		     * @private
  		     * @param {*} value The potential iteratee value argument.
  		     * @param {*} index The potential iteratee index or key argument.
  		     * @param {*} object The potential iteratee object argument.
  		     * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
  		     *  else `false`.
  		     */
  		    function isIterateeCall(value, index, object) {
  		      if (!isObject(object)) {
  		        return false;
  		      }
  		      var type = typeof index;
  		      if (type == 'number'
  		            ? (isArrayLike(object) && isIndex(index, object.length))
  		            : (type == 'string' && index in object)
  		          ) {
  		        return eq(object[index], value);
  		      }
  		      return false;
  		    }

  		    /**
  		     * Checks if `value` is a property name and not a property path.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @param {Object} [object] The object to query keys on.
  		     * @returns {boolean} Returns `true` if `value` is a property name, else `false`.
  		     */
  		    function isKey(value, object) {
  		      if (isArray(value)) {
  		        return false;
  		      }
  		      var type = typeof value;
  		      if (type == 'number' || type == 'symbol' || type == 'boolean' ||
  		          value == null || isSymbol(value)) {
  		        return true;
  		      }
  		      return reIsPlainProp.test(value) || !reIsDeepProp.test(value) ||
  		        (object != null && value in Object(object));
  		    }

  		    /**
  		     * Checks if `value` is suitable for use as unique object key.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
  		     */
  		    function isKeyable(value) {
  		      var type = typeof value;
  		      return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
  		        ? (value !== '__proto__')
  		        : (value === null);
  		    }

  		    /**
  		     * Checks if `func` has a lazy counterpart.
  		     *
  		     * @private
  		     * @param {Function} func The function to check.
  		     * @returns {boolean} Returns `true` if `func` has a lazy counterpart,
  		     *  else `false`.
  		     */
  		    function isLaziable(func) {
  		      var funcName = getFuncName(func),
  		          other = lodash[funcName];

  		      if (typeof other != 'function' || !(funcName in LazyWrapper.prototype)) {
  		        return false;
  		      }
  		      if (func === other) {
  		        return true;
  		      }
  		      var data = getData(other);
  		      return !!data && func === data[0];
  		    }

  		    /**
  		     * Checks if `func` has its source masked.
  		     *
  		     * @private
  		     * @param {Function} func The function to check.
  		     * @returns {boolean} Returns `true` if `func` is masked, else `false`.
  		     */
  		    function isMasked(func) {
  		      return !!maskSrcKey && (maskSrcKey in func);
  		    }

  		    /**
  		     * Checks if `func` is capable of being masked.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `func` is maskable, else `false`.
  		     */
  		    var isMaskable = coreJsData ? isFunction : stubFalse;

  		    /**
  		     * Checks if `value` is likely a prototype object.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
  		     */
  		    function isPrototype(value) {
  		      var Ctor = value && value.constructor,
  		          proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

  		      return value === proto;
  		    }

  		    /**
  		     * Checks if `value` is suitable for strict equality comparisons, i.e. `===`.
  		     *
  		     * @private
  		     * @param {*} value The value to check.
  		     * @returns {boolean} Returns `true` if `value` if suitable for strict
  		     *  equality comparisons, else `false`.
  		     */
  		    function isStrictComparable(value) {
  		      return value === value && !isObject(value);
  		    }

  		    /**
  		     * A specialized version of `matchesProperty` for source values suitable
  		     * for strict equality comparisons, i.e. `===`.
  		     *
  		     * @private
  		     * @param {string} key The key of the property to get.
  		     * @param {*} srcValue The value to match.
  		     * @returns {Function} Returns the new spec function.
  		     */
  		    function matchesStrictComparable(key, srcValue) {
  		      return function(object) {
  		        if (object == null) {
  		          return false;
  		        }
  		        return object[key] === srcValue &&
  		          (srcValue !== undefined$1 || (key in Object(object)));
  		      };
  		    }

  		    /**
  		     * A specialized version of `_.memoize` which clears the memoized function's
  		     * cache when it exceeds `MAX_MEMOIZE_SIZE`.
  		     *
  		     * @private
  		     * @param {Function} func The function to have its output memoized.
  		     * @returns {Function} Returns the new memoized function.
  		     */
  		    function memoizeCapped(func) {
  		      var result = memoize(func, function(key) {
  		        if (cache.size === MAX_MEMOIZE_SIZE) {
  		          cache.clear();
  		        }
  		        return key;
  		      });

  		      var cache = result.cache;
  		      return result;
  		    }

  		    /**
  		     * Merges the function metadata of `source` into `data`.
  		     *
  		     * Merging metadata reduces the number of wrappers used to invoke a function.
  		     * This is possible because methods like `_.bind`, `_.curry`, and `_.partial`
  		     * may be applied regardless of execution order. Methods like `_.ary` and
  		     * `_.rearg` modify function arguments, making the order in which they are
  		     * executed important, preventing the merging of metadata. However, we make
  		     * an exception for a safe combined case where curried functions have `_.ary`
  		     * and or `_.rearg` applied.
  		     *
  		     * @private
  		     * @param {Array} data The destination metadata.
  		     * @param {Array} source The source metadata.
  		     * @returns {Array} Returns `data`.
  		     */
  		    function mergeData(data, source) {
  		      var bitmask = data[1],
  		          srcBitmask = source[1],
  		          newBitmask = bitmask | srcBitmask,
  		          isCommon = newBitmask < (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);

  		      var isCombo =
  		        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_CURRY_FLAG)) ||
  		        ((srcBitmask == WRAP_ARY_FLAG) && (bitmask == WRAP_REARG_FLAG) && (data[7].length <= source[8])) ||
  		        ((srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG)) && (source[7].length <= source[8]) && (bitmask == WRAP_CURRY_FLAG));

  		      // Exit early if metadata can't be merged.
  		      if (!(isCommon || isCombo)) {
  		        return data;
  		      }
  		      // Use source `thisArg` if available.
  		      if (srcBitmask & WRAP_BIND_FLAG) {
  		        data[2] = source[2];
  		        // Set when currying a bound function.
  		        newBitmask |= bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
  		      }
  		      // Compose partial arguments.
  		      var value = source[3];
  		      if (value) {
  		        var partials = data[3];
  		        data[3] = partials ? composeArgs(partials, value, source[4]) : value;
  		        data[4] = partials ? replaceHolders(data[3], PLACEHOLDER) : source[4];
  		      }
  		      // Compose partial right arguments.
  		      value = source[5];
  		      if (value) {
  		        partials = data[5];
  		        data[5] = partials ? composeArgsRight(partials, value, source[6]) : value;
  		        data[6] = partials ? replaceHolders(data[5], PLACEHOLDER) : source[6];
  		      }
  		      // Use source `argPos` if available.
  		      value = source[7];
  		      if (value) {
  		        data[7] = value;
  		      }
  		      // Use source `ary` if it's smaller.
  		      if (srcBitmask & WRAP_ARY_FLAG) {
  		        data[8] = data[8] == null ? source[8] : nativeMin(data[8], source[8]);
  		      }
  		      // Use source `arity` if one is not provided.
  		      if (data[9] == null) {
  		        data[9] = source[9];
  		      }
  		      // Use source `func` and merge bitmasks.
  		      data[0] = source[0];
  		      data[1] = newBitmask;

  		      return data;
  		    }

  		    /**
  		     * This function is like
  		     * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
  		     * except that it includes inherited enumerable properties.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @returns {Array} Returns the array of property names.
  		     */
  		    function nativeKeysIn(object) {
  		      var result = [];
  		      if (object != null) {
  		        for (var key in Object(object)) {
  		          result.push(key);
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * Converts `value` to a string using `Object.prototype.toString`.
  		     *
  		     * @private
  		     * @param {*} value The value to convert.
  		     * @returns {string} Returns the converted string.
  		     */
  		    function objectToString(value) {
  		      return nativeObjectToString.call(value);
  		    }

  		    /**
  		     * A specialized version of `baseRest` which transforms the rest array.
  		     *
  		     * @private
  		     * @param {Function} func The function to apply a rest parameter to.
  		     * @param {number} [start=func.length-1] The start position of the rest parameter.
  		     * @param {Function} transform The rest array transform.
  		     * @returns {Function} Returns the new function.
  		     */
  		    function overRest(func, start, transform) {
  		      start = nativeMax(start === undefined$1 ? (func.length - 1) : start, 0);
  		      return function() {
  		        var args = arguments,
  		            index = -1,
  		            length = nativeMax(args.length - start, 0),
  		            array = Array(length);

  		        while (++index < length) {
  		          array[index] = args[start + index];
  		        }
  		        index = -1;
  		        var otherArgs = Array(start + 1);
  		        while (++index < start) {
  		          otherArgs[index] = args[index];
  		        }
  		        otherArgs[start] = transform(array);
  		        return apply(func, this, otherArgs);
  		      };
  		    }

  		    /**
  		     * Gets the parent value at `path` of `object`.
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {Array} path The path to get the parent value of.
  		     * @returns {*} Returns the parent value.
  		     */
  		    function parent(object, path) {
  		      return path.length < 2 ? object : baseGet(object, baseSlice(path, 0, -1));
  		    }

  		    /**
  		     * Reorder `array` according to the specified indexes where the element at
  		     * the first index is assigned as the first element, the element at
  		     * the second index is assigned as the second element, and so on.
  		     *
  		     * @private
  		     * @param {Array} array The array to reorder.
  		     * @param {Array} indexes The arranged array indexes.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function reorder(array, indexes) {
  		      var arrLength = array.length,
  		          length = nativeMin(indexes.length, arrLength),
  		          oldArray = copyArray(array);

  		      while (length--) {
  		        var index = indexes[length];
  		        array[length] = isIndex(index, arrLength) ? oldArray[index] : undefined$1;
  		      }
  		      return array;
  		    }

  		    /**
  		     * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
  		     *
  		     * @private
  		     * @param {Object} object The object to query.
  		     * @param {string} key The key of the property to get.
  		     * @returns {*} Returns the property value.
  		     */
  		    function safeGet(object, key) {
  		      if (key === 'constructor' && typeof object[key] === 'function') {
  		        return;
  		      }

  		      if (key == '__proto__') {
  		        return;
  		      }

  		      return object[key];
  		    }

  		    /**
  		     * Sets metadata for `func`.
  		     *
  		     * **Note:** If this function becomes hot, i.e. is invoked a lot in a short
  		     * period of time, it will trip its breaker and transition to an identity
  		     * function to avoid garbage collection pauses in V8. See
  		     * [V8 issue 2070](https://bugs.chromium.org/p/v8/issues/detail?id=2070)
  		     * for more details.
  		     *
  		     * @private
  		     * @param {Function} func The function to associate metadata with.
  		     * @param {*} data The metadata.
  		     * @returns {Function} Returns `func`.
  		     */
  		    var setData = shortOut(baseSetData);

  		    /**
  		     * A simple wrapper around the global [`setTimeout`](https://mdn.io/setTimeout).
  		     *
  		     * @private
  		     * @param {Function} func The function to delay.
  		     * @param {number} wait The number of milliseconds to delay invocation.
  		     * @returns {number|Object} Returns the timer id or timeout object.
  		     */
  		    var setTimeout = ctxSetTimeout || function(func, wait) {
  		      return root.setTimeout(func, wait);
  		    };

  		    /**
  		     * Sets the `toString` method of `func` to return `string`.
  		     *
  		     * @private
  		     * @param {Function} func The function to modify.
  		     * @param {Function} string The `toString` result.
  		     * @returns {Function} Returns `func`.
  		     */
  		    var setToString = shortOut(baseSetToString);

  		    /**
  		     * Sets the `toString` method of `wrapper` to mimic the source of `reference`
  		     * with wrapper details in a comment at the top of the source body.
  		     *
  		     * @private
  		     * @param {Function} wrapper The function to modify.
  		     * @param {Function} reference The reference function.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @returns {Function} Returns `wrapper`.
  		     */
  		    function setWrapToString(wrapper, reference, bitmask) {
  		      var source = (reference + '');
  		      return setToString(wrapper, insertWrapDetails(source, updateWrapDetails(getWrapDetails(source), bitmask)));
  		    }

  		    /**
  		     * Creates a function that'll short out and invoke `identity` instead
  		     * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
  		     * milliseconds.
  		     *
  		     * @private
  		     * @param {Function} func The function to restrict.
  		     * @returns {Function} Returns the new shortable function.
  		     */
  		    function shortOut(func) {
  		      var count = 0,
  		          lastCalled = 0;

  		      return function() {
  		        var stamp = nativeNow(),
  		            remaining = HOT_SPAN - (stamp - lastCalled);

  		        lastCalled = stamp;
  		        if (remaining > 0) {
  		          if (++count >= HOT_COUNT) {
  		            return arguments[0];
  		          }
  		        } else {
  		          count = 0;
  		        }
  		        return func.apply(undefined$1, arguments);
  		      };
  		    }

  		    /**
  		     * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
  		     *
  		     * @private
  		     * @param {Array} array The array to shuffle.
  		     * @param {number} [size=array.length] The size of `array`.
  		     * @returns {Array} Returns `array`.
  		     */
  		    function shuffleSelf(array, size) {
  		      var index = -1,
  		          length = array.length,
  		          lastIndex = length - 1;

  		      size = size === undefined$1 ? length : size;
  		      while (++index < size) {
  		        var rand = baseRandom(index, lastIndex),
  		            value = array[rand];

  		        array[rand] = array[index];
  		        array[index] = value;
  		      }
  		      array.length = size;
  		      return array;
  		    }

  		    /**
  		     * Converts `string` to a property path array.
  		     *
  		     * @private
  		     * @param {string} string The string to convert.
  		     * @returns {Array} Returns the property path array.
  		     */
  		    var stringToPath = memoizeCapped(function(string) {
  		      var result = [];
  		      if (string.charCodeAt(0) === 46 /* . */) {
  		        result.push('');
  		      }
  		      string.replace(rePropName, function(match, number, quote, subString) {
  		        result.push(quote ? subString.replace(reEscapeChar, '$1') : (number || match));
  		      });
  		      return result;
  		    });

  		    /**
  		     * Converts `value` to a string key if it's not a string or symbol.
  		     *
  		     * @private
  		     * @param {*} value The value to inspect.
  		     * @returns {string|symbol} Returns the key.
  		     */
  		    function toKey(value) {
  		      if (typeof value == 'string' || isSymbol(value)) {
  		        return value;
  		      }
  		      var result = (value + '');
  		      return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
  		    }

  		    /**
  		     * Converts `func` to its source code.
  		     *
  		     * @private
  		     * @param {Function} func The function to convert.
  		     * @returns {string} Returns the source code.
  		     */
  		    function toSource(func) {
  		      if (func != null) {
  		        try {
  		          return funcToString.call(func);
  		        } catch (e) {}
  		        try {
  		          return (func + '');
  		        } catch (e) {}
  		      }
  		      return '';
  		    }

  		    /**
  		     * Updates wrapper `details` based on `bitmask` flags.
  		     *
  		     * @private
  		     * @returns {Array} details The details to modify.
  		     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
  		     * @returns {Array} Returns `details`.
  		     */
  		    function updateWrapDetails(details, bitmask) {
  		      arrayEach(wrapFlags, function(pair) {
  		        var value = '_.' + pair[0];
  		        if ((bitmask & pair[1]) && !arrayIncludes(details, value)) {
  		          details.push(value);
  		        }
  		      });
  		      return details.sort();
  		    }

  		    /**
  		     * Creates a clone of `wrapper`.
  		     *
  		     * @private
  		     * @param {Object} wrapper The wrapper to clone.
  		     * @returns {Object} Returns the cloned wrapper.
  		     */
  		    function wrapperClone(wrapper) {
  		      if (wrapper instanceof LazyWrapper) {
  		        return wrapper.clone();
  		      }
  		      var result = new LodashWrapper(wrapper.__wrapped__, wrapper.__chain__);
  		      result.__actions__ = copyArray(wrapper.__actions__);
  		      result.__index__  = wrapper.__index__;
  		      result.__values__ = wrapper.__values__;
  		      return result;
  		    }

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates an array of elements split into groups the length of `size`.
  		     * If `array` can't be split evenly, the final chunk will be the remaining
  		     * elements.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to process.
  		     * @param {number} [size=1] The length of each chunk
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the new array of chunks.
  		     * @example
  		     *
  		     * _.chunk(['a', 'b', 'c', 'd'], 2);
  		     * // => [['a', 'b'], ['c', 'd']]
  		     *
  		     * _.chunk(['a', 'b', 'c', 'd'], 3);
  		     * // => [['a', 'b', 'c'], ['d']]
  		     */
  		    function chunk(array, size, guard) {
  		      if ((guard ? isIterateeCall(array, size, guard) : size === undefined$1)) {
  		        size = 1;
  		      } else {
  		        size = nativeMax(toInteger(size), 0);
  		      }
  		      var length = array == null ? 0 : array.length;
  		      if (!length || size < 1) {
  		        return [];
  		      }
  		      var index = 0,
  		          resIndex = 0,
  		          result = Array(nativeCeil(length / size));

  		      while (index < length) {
  		        result[resIndex++] = baseSlice(array, index, (index += size));
  		      }
  		      return result;
  		    }

  		    /**
  		     * Creates an array with all falsey values removed. The values `false`, `null`,
  		     * `0`, `""`, `undefined`, and `NaN` are falsey.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to compact.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @example
  		     *
  		     * _.compact([0, 1, false, 2, '', 3]);
  		     * // => [1, 2, 3]
  		     */
  		    function compact(array) {
  		      var index = -1,
  		          length = array == null ? 0 : array.length,
  		          resIndex = 0,
  		          result = [];

  		      while (++index < length) {
  		        var value = array[index];
  		        if (value) {
  		          result[resIndex++] = value;
  		        }
  		      }
  		      return result;
  		    }

  		    /**
  		     * Creates a new array concatenating `array` with any additional arrays
  		     * and/or values.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to concatenate.
  		     * @param {...*} [values] The values to concatenate.
  		     * @returns {Array} Returns the new concatenated array.
  		     * @example
  		     *
  		     * var array = [1];
  		     * var other = _.concat(array, 2, [3], [[4]]);
  		     *
  		     * console.log(other);
  		     * // => [1, 2, 3, [4]]
  		     *
  		     * console.log(array);
  		     * // => [1]
  		     */
  		    function concat() {
  		      var length = arguments.length;
  		      if (!length) {
  		        return [];
  		      }
  		      var args = Array(length - 1),
  		          array = arguments[0],
  		          index = length;

  		      while (index--) {
  		        args[index - 1] = arguments[index];
  		      }
  		      return arrayPush(isArray(array) ? copyArray(array) : [array], baseFlatten(args, 1));
  		    }

  		    /**
  		     * Creates an array of `array` values not included in the other given arrays
  		     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons. The order and references of result values are
  		     * determined by the first array.
  		     *
  		     * **Note:** Unlike `_.pullAll`, this method returns a new array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {...Array} [values] The values to exclude.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @see _.without, _.xor
  		     * @example
  		     *
  		     * _.difference([2, 1], [2, 3]);
  		     * // => [1]
  		     */
  		    var difference = baseRest(function(array, values) {
  		      return isArrayLikeObject(array)
  		        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true))
  		        : [];
  		    });

  		    /**
  		     * This method is like `_.difference` except that it accepts `iteratee` which
  		     * is invoked for each element of `array` and `values` to generate the criterion
  		     * by which they're compared. The order and references of result values are
  		     * determined by the first array. The iteratee is invoked with one argument:
  		     * (value).
  		     *
  		     * **Note:** Unlike `_.pullAllBy`, this method returns a new array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {...Array} [values] The values to exclude.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @example
  		     *
  		     * _.differenceBy([2.1, 1.2], [2.3, 3.4], Math.floor);
  		     * // => [1.2]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.differenceBy([{ 'x': 2 }, { 'x': 1 }], [{ 'x': 1 }], 'x');
  		     * // => [{ 'x': 2 }]
  		     */
  		    var differenceBy = baseRest(function(array, values) {
  		      var iteratee = last(values);
  		      if (isArrayLikeObject(iteratee)) {
  		        iteratee = undefined$1;
  		      }
  		      return isArrayLikeObject(array)
  		        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), getIteratee(iteratee, 2))
  		        : [];
  		    });

  		    /**
  		     * This method is like `_.difference` except that it accepts `comparator`
  		     * which is invoked to compare elements of `array` to `values`. The order and
  		     * references of result values are determined by the first array. The comparator
  		     * is invoked with two arguments: (arrVal, othVal).
  		     *
  		     * **Note:** Unlike `_.pullAllWith`, this method returns a new array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {...Array} [values] The values to exclude.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
  		     *
  		     * _.differenceWith(objects, [{ 'x': 1, 'y': 2 }], _.isEqual);
  		     * // => [{ 'x': 2, 'y': 1 }]
  		     */
  		    var differenceWith = baseRest(function(array, values) {
  		      var comparator = last(values);
  		      if (isArrayLikeObject(comparator)) {
  		        comparator = undefined$1;
  		      }
  		      return isArrayLikeObject(array)
  		        ? baseDifference(array, baseFlatten(values, 1, isArrayLikeObject, true), undefined$1, comparator)
  		        : [];
  		    });

  		    /**
  		     * Creates a slice of `array` with `n` elements dropped from the beginning.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.5.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {number} [n=1] The number of elements to drop.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.drop([1, 2, 3]);
  		     * // => [2, 3]
  		     *
  		     * _.drop([1, 2, 3], 2);
  		     * // => [3]
  		     *
  		     * _.drop([1, 2, 3], 5);
  		     * // => []
  		     *
  		     * _.drop([1, 2, 3], 0);
  		     * // => [1, 2, 3]
  		     */
  		    function drop(array, n, guard) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      n = (guard || n === undefined$1) ? 1 : toInteger(n);
  		      return baseSlice(array, n < 0 ? 0 : n, length);
  		    }

  		    /**
  		     * Creates a slice of `array` with `n` elements dropped from the end.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {number} [n=1] The number of elements to drop.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.dropRight([1, 2, 3]);
  		     * // => [1, 2]
  		     *
  		     * _.dropRight([1, 2, 3], 2);
  		     * // => [1]
  		     *
  		     * _.dropRight([1, 2, 3], 5);
  		     * // => []
  		     *
  		     * _.dropRight([1, 2, 3], 0);
  		     * // => [1, 2, 3]
  		     */
  		    function dropRight(array, n, guard) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      n = (guard || n === undefined$1) ? 1 : toInteger(n);
  		      n = length - n;
  		      return baseSlice(array, 0, n < 0 ? 0 : n);
  		    }

  		    /**
  		     * Creates a slice of `array` excluding elements dropped from the end.
  		     * Elements are dropped until `predicate` returns falsey. The predicate is
  		     * invoked with three arguments: (value, index, array).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': true },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': false }
  		     * ];
  		     *
  		     * _.dropRightWhile(users, function(o) { return !o.active; });
  		     * // => objects for ['barney']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.dropRightWhile(users, { 'user': 'pebbles', 'active': false });
  		     * // => objects for ['barney', 'fred']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.dropRightWhile(users, ['active', false]);
  		     * // => objects for ['barney']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.dropRightWhile(users, 'active');
  		     * // => objects for ['barney', 'fred', 'pebbles']
  		     */
  		    function dropRightWhile(array, predicate) {
  		      return (array && array.length)
  		        ? baseWhile(array, getIteratee(predicate, 3), true, true)
  		        : [];
  		    }

  		    /**
  		     * Creates a slice of `array` excluding elements dropped from the beginning.
  		     * Elements are dropped until `predicate` returns falsey. The predicate is
  		     * invoked with three arguments: (value, index, array).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': false },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': true }
  		     * ];
  		     *
  		     * _.dropWhile(users, function(o) { return !o.active; });
  		     * // => objects for ['pebbles']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.dropWhile(users, { 'user': 'barney', 'active': false });
  		     * // => objects for ['fred', 'pebbles']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.dropWhile(users, ['active', false]);
  		     * // => objects for ['pebbles']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.dropWhile(users, 'active');
  		     * // => objects for ['barney', 'fred', 'pebbles']
  		     */
  		    function dropWhile(array, predicate) {
  		      return (array && array.length)
  		        ? baseWhile(array, getIteratee(predicate, 3), true)
  		        : [];
  		    }

  		    /**
  		     * Fills elements of `array` with `value` from `start` up to, but not
  		     * including, `end`.
  		     *
  		     * **Note:** This method mutates `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.2.0
  		     * @category Array
  		     * @param {Array} array The array to fill.
  		     * @param {*} value The value to fill `array` with.
  		     * @param {number} [start=0] The start position.
  		     * @param {number} [end=array.length] The end position.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = [1, 2, 3];
  		     *
  		     * _.fill(array, 'a');
  		     * console.log(array);
  		     * // => ['a', 'a', 'a']
  		     *
  		     * _.fill(Array(3), 2);
  		     * // => [2, 2, 2]
  		     *
  		     * _.fill([4, 6, 8, 10], '*', 1, 3);
  		     * // => [4, '*', '*', 10]
  		     */
  		    function fill(array, value, start, end) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      if (start && typeof start != 'number' && isIterateeCall(array, value, start)) {
  		        start = 0;
  		        end = length;
  		      }
  		      return baseFill(array, value, start, end);
  		    }

  		    /**
  		     * This method is like `_.find` except that it returns the index of the first
  		     * element `predicate` returns truthy for instead of the element itself.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 1.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param {number} [fromIndex=0] The index to search from.
  		     * @returns {number} Returns the index of the found element, else `-1`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': false },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': true }
  		     * ];
  		     *
  		     * _.findIndex(users, function(o) { return o.user == 'barney'; });
  		     * // => 0
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.findIndex(users, { 'user': 'fred', 'active': false });
  		     * // => 1
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.findIndex(users, ['active', false]);
  		     * // => 0
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.findIndex(users, 'active');
  		     * // => 2
  		     */
  		    function findIndex(array, predicate, fromIndex) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return -1;
  		      }
  		      var index = fromIndex == null ? 0 : toInteger(fromIndex);
  		      if (index < 0) {
  		        index = nativeMax(length + index, 0);
  		      }
  		      return baseFindIndex(array, getIteratee(predicate, 3), index);
  		    }

  		    /**
  		     * This method is like `_.findIndex` except that it iterates over elements
  		     * of `collection` from right to left.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param {number} [fromIndex=array.length-1] The index to search from.
  		     * @returns {number} Returns the index of the found element, else `-1`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': true },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': false }
  		     * ];
  		     *
  		     * _.findLastIndex(users, function(o) { return o.user == 'pebbles'; });
  		     * // => 2
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.findLastIndex(users, { 'user': 'barney', 'active': true });
  		     * // => 0
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.findLastIndex(users, ['active', false]);
  		     * // => 2
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.findLastIndex(users, 'active');
  		     * // => 0
  		     */
  		    function findLastIndex(array, predicate, fromIndex) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return -1;
  		      }
  		      var index = length - 1;
  		      if (fromIndex !== undefined$1) {
  		        index = toInteger(fromIndex);
  		        index = fromIndex < 0
  		          ? nativeMax(length + index, 0)
  		          : nativeMin(index, length - 1);
  		      }
  		      return baseFindIndex(array, getIteratee(predicate, 3), index, true);
  		    }

  		    /**
  		     * Flattens `array` a single level deep.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to flatten.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * _.flatten([1, [2, [3, [4]], 5]]);
  		     * // => [1, 2, [3, [4]], 5]
  		     */
  		    function flatten(array) {
  		      var length = array == null ? 0 : array.length;
  		      return length ? baseFlatten(array, 1) : [];
  		    }

  		    /**
  		     * Recursively flattens `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to flatten.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * _.flattenDeep([1, [2, [3, [4]], 5]]);
  		     * // => [1, 2, 3, 4, 5]
  		     */
  		    function flattenDeep(array) {
  		      var length = array == null ? 0 : array.length;
  		      return length ? baseFlatten(array, INFINITY) : [];
  		    }

  		    /**
  		     * Recursively flatten `array` up to `depth` times.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.4.0
  		     * @category Array
  		     * @param {Array} array The array to flatten.
  		     * @param {number} [depth=1] The maximum recursion depth.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * var array = [1, [2, [3, [4]], 5]];
  		     *
  		     * _.flattenDepth(array, 1);
  		     * // => [1, 2, [3, [4]], 5]
  		     *
  		     * _.flattenDepth(array, 2);
  		     * // => [1, 2, 3, [4], 5]
  		     */
  		    function flattenDepth(array, depth) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      depth = depth === undefined$1 ? 1 : toInteger(depth);
  		      return baseFlatten(array, depth);
  		    }

  		    /**
  		     * The inverse of `_.toPairs`; this method returns an object composed
  		     * from key-value `pairs`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} pairs The key-value pairs.
  		     * @returns {Object} Returns the new object.
  		     * @example
  		     *
  		     * _.fromPairs([['a', 1], ['b', 2]]);
  		     * // => { 'a': 1, 'b': 2 }
  		     */
  		    function fromPairs(pairs) {
  		      var index = -1,
  		          length = pairs == null ? 0 : pairs.length,
  		          result = {};

  		      while (++index < length) {
  		        var pair = pairs[index];
  		        result[pair[0]] = pair[1];
  		      }
  		      return result;
  		    }

  		    /**
  		     * Gets the first element of `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @alias first
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @returns {*} Returns the first element of `array`.
  		     * @example
  		     *
  		     * _.head([1, 2, 3]);
  		     * // => 1
  		     *
  		     * _.head([]);
  		     * // => undefined
  		     */
  		    function head(array) {
  		      return (array && array.length) ? array[0] : undefined$1;
  		    }

  		    /**
  		     * Gets the index at which the first occurrence of `value` is found in `array`
  		     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons. If `fromIndex` is negative, it's used as the
  		     * offset from the end of `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {*} value The value to search for.
  		     * @param {number} [fromIndex=0] The index to search from.
  		     * @returns {number} Returns the index of the matched value, else `-1`.
  		     * @example
  		     *
  		     * _.indexOf([1, 2, 1, 2], 2);
  		     * // => 1
  		     *
  		     * // Search from the `fromIndex`.
  		     * _.indexOf([1, 2, 1, 2], 2, 2);
  		     * // => 3
  		     */
  		    function indexOf(array, value, fromIndex) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return -1;
  		      }
  		      var index = fromIndex == null ? 0 : toInteger(fromIndex);
  		      if (index < 0) {
  		        index = nativeMax(length + index, 0);
  		      }
  		      return baseIndexOf(array, value, index);
  		    }

  		    /**
  		     * Gets all but the last element of `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.initial([1, 2, 3]);
  		     * // => [1, 2]
  		     */
  		    function initial(array) {
  		      var length = array == null ? 0 : array.length;
  		      return length ? baseSlice(array, 0, -1) : [];
  		    }

  		    /**
  		     * Creates an array of unique values that are included in all given arrays
  		     * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons. The order and references of result values are
  		     * determined by the first array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @returns {Array} Returns the new array of intersecting values.
  		     * @example
  		     *
  		     * _.intersection([2, 1], [2, 3]);
  		     * // => [2]
  		     */
  		    var intersection = baseRest(function(arrays) {
  		      var mapped = arrayMap(arrays, castArrayLikeObject);
  		      return (mapped.length && mapped[0] === arrays[0])
  		        ? baseIntersection(mapped)
  		        : [];
  		    });

  		    /**
  		     * This method is like `_.intersection` except that it accepts `iteratee`
  		     * which is invoked for each element of each `arrays` to generate the criterion
  		     * by which they're compared. The order and references of result values are
  		     * determined by the first array. The iteratee is invoked with one argument:
  		     * (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns the new array of intersecting values.
  		     * @example
  		     *
  		     * _.intersectionBy([2.1, 1.2], [2.3, 3.4], Math.floor);
  		     * // => [2.1]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.intersectionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
  		     * // => [{ 'x': 1 }]
  		     */
  		    var intersectionBy = baseRest(function(arrays) {
  		      var iteratee = last(arrays),
  		          mapped = arrayMap(arrays, castArrayLikeObject);

  		      if (iteratee === last(mapped)) {
  		        iteratee = undefined$1;
  		      } else {
  		        mapped.pop();
  		      }
  		      return (mapped.length && mapped[0] === arrays[0])
  		        ? baseIntersection(mapped, getIteratee(iteratee, 2))
  		        : [];
  		    });

  		    /**
  		     * This method is like `_.intersection` except that it accepts `comparator`
  		     * which is invoked to compare elements of `arrays`. The order and references
  		     * of result values are determined by the first array. The comparator is
  		     * invoked with two arguments: (arrVal, othVal).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of intersecting values.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
  		     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
  		     *
  		     * _.intersectionWith(objects, others, _.isEqual);
  		     * // => [{ 'x': 1, 'y': 2 }]
  		     */
  		    var intersectionWith = baseRest(function(arrays) {
  		      var comparator = last(arrays),
  		          mapped = arrayMap(arrays, castArrayLikeObject);

  		      comparator = typeof comparator == 'function' ? comparator : undefined$1;
  		      if (comparator) {
  		        mapped.pop();
  		      }
  		      return (mapped.length && mapped[0] === arrays[0])
  		        ? baseIntersection(mapped, undefined$1, comparator)
  		        : [];
  		    });

  		    /**
  		     * Converts all elements in `array` into a string separated by `separator`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to convert.
  		     * @param {string} [separator=','] The element separator.
  		     * @returns {string} Returns the joined string.
  		     * @example
  		     *
  		     * _.join(['a', 'b', 'c'], '~');
  		     * // => 'a~b~c'
  		     */
  		    function join(array, separator) {
  		      return array == null ? '' : nativeJoin.call(array, separator);
  		    }

  		    /**
  		     * Gets the last element of `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @returns {*} Returns the last element of `array`.
  		     * @example
  		     *
  		     * _.last([1, 2, 3]);
  		     * // => 3
  		     */
  		    function last(array) {
  		      var length = array == null ? 0 : array.length;
  		      return length ? array[length - 1] : undefined$1;
  		    }

  		    /**
  		     * This method is like `_.indexOf` except that it iterates over elements of
  		     * `array` from right to left.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {*} value The value to search for.
  		     * @param {number} [fromIndex=array.length-1] The index to search from.
  		     * @returns {number} Returns the index of the matched value, else `-1`.
  		     * @example
  		     *
  		     * _.lastIndexOf([1, 2, 1, 2], 2);
  		     * // => 3
  		     *
  		     * // Search from the `fromIndex`.
  		     * _.lastIndexOf([1, 2, 1, 2], 2, 2);
  		     * // => 1
  		     */
  		    function lastIndexOf(array, value, fromIndex) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return -1;
  		      }
  		      var index = length;
  		      if (fromIndex !== undefined$1) {
  		        index = toInteger(fromIndex);
  		        index = index < 0 ? nativeMax(length + index, 0) : nativeMin(index, length - 1);
  		      }
  		      return value === value
  		        ? strictLastIndexOf(array, value, index)
  		        : baseFindIndex(array, baseIsNaN, index, true);
  		    }

  		    /**
  		     * Gets the element at index `n` of `array`. If `n` is negative, the nth
  		     * element from the end is returned.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.11.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {number} [n=0] The index of the element to return.
  		     * @returns {*} Returns the nth element of `array`.
  		     * @example
  		     *
  		     * var array = ['a', 'b', 'c', 'd'];
  		     *
  		     * _.nth(array, 1);
  		     * // => 'b'
  		     *
  		     * _.nth(array, -2);
  		     * // => 'c';
  		     */
  		    function nth(array, n) {
  		      return (array && array.length) ? baseNth(array, toInteger(n)) : undefined$1;
  		    }

  		    /**
  		     * Removes all given values from `array` using
  		     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons.
  		     *
  		     * **Note:** Unlike `_.without`, this method mutates `array`. Use `_.remove`
  		     * to remove elements from an array by predicate.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {...*} [values] The values to remove.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
  		     *
  		     * _.pull(array, 'a', 'c');
  		     * console.log(array);
  		     * // => ['b', 'b']
  		     */
  		    var pull = baseRest(pullAll);

  		    /**
  		     * This method is like `_.pull` except that it accepts an array of values to remove.
  		     *
  		     * **Note:** Unlike `_.difference`, this method mutates `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {Array} values The values to remove.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = ['a', 'b', 'c', 'a', 'b', 'c'];
  		     *
  		     * _.pullAll(array, ['a', 'c']);
  		     * console.log(array);
  		     * // => ['b', 'b']
  		     */
  		    function pullAll(array, values) {
  		      return (array && array.length && values && values.length)
  		        ? basePullAll(array, values)
  		        : array;
  		    }

  		    /**
  		     * This method is like `_.pullAll` except that it accepts `iteratee` which is
  		     * invoked for each element of `array` and `values` to generate the criterion
  		     * by which they're compared. The iteratee is invoked with one argument: (value).
  		     *
  		     * **Note:** Unlike `_.differenceBy`, this method mutates `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {Array} values The values to remove.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = [{ 'x': 1 }, { 'x': 2 }, { 'x': 3 }, { 'x': 1 }];
  		     *
  		     * _.pullAllBy(array, [{ 'x': 1 }, { 'x': 3 }], 'x');
  		     * console.log(array);
  		     * // => [{ 'x': 2 }]
  		     */
  		    function pullAllBy(array, values, iteratee) {
  		      return (array && array.length && values && values.length)
  		        ? basePullAll(array, values, getIteratee(iteratee, 2))
  		        : array;
  		    }

  		    /**
  		     * This method is like `_.pullAll` except that it accepts `comparator` which
  		     * is invoked to compare elements of `array` to `values`. The comparator is
  		     * invoked with two arguments: (arrVal, othVal).
  		     *
  		     * **Note:** Unlike `_.differenceWith`, this method mutates `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.6.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {Array} values The values to remove.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = [{ 'x': 1, 'y': 2 }, { 'x': 3, 'y': 4 }, { 'x': 5, 'y': 6 }];
  		     *
  		     * _.pullAllWith(array, [{ 'x': 3, 'y': 4 }], _.isEqual);
  		     * console.log(array);
  		     * // => [{ 'x': 1, 'y': 2 }, { 'x': 5, 'y': 6 }]
  		     */
  		    function pullAllWith(array, values, comparator) {
  		      return (array && array.length && values && values.length)
  		        ? basePullAll(array, values, undefined$1, comparator)
  		        : array;
  		    }

  		    /**
  		     * Removes elements from `array` corresponding to `indexes` and returns an
  		     * array of removed elements.
  		     *
  		     * **Note:** Unlike `_.at`, this method mutates `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {...(number|number[])} [indexes] The indexes of elements to remove.
  		     * @returns {Array} Returns the new array of removed elements.
  		     * @example
  		     *
  		     * var array = ['a', 'b', 'c', 'd'];
  		     * var pulled = _.pullAt(array, [1, 3]);
  		     *
  		     * console.log(array);
  		     * // => ['a', 'c']
  		     *
  		     * console.log(pulled);
  		     * // => ['b', 'd']
  		     */
  		    var pullAt = flatRest(function(array, indexes) {
  		      var length = array == null ? 0 : array.length,
  		          result = baseAt(array, indexes);

  		      basePullAt(array, arrayMap(indexes, function(index) {
  		        return isIndex(index, length) ? +index : index;
  		      }).sort(compareAscending));

  		      return result;
  		    });

  		    /**
  		     * Removes all elements from `array` that `predicate` returns truthy for
  		     * and returns an array of the removed elements. The predicate is invoked
  		     * with three arguments: (value, index, array).
  		     *
  		     * **Note:** Unlike `_.filter`, this method mutates `array`. Use `_.pull`
  		     * to pull elements from an array by value.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new array of removed elements.
  		     * @example
  		     *
  		     * var array = [1, 2, 3, 4];
  		     * var evens = _.remove(array, function(n) {
  		     *   return n % 2 == 0;
  		     * });
  		     *
  		     * console.log(array);
  		     * // => [1, 3]
  		     *
  		     * console.log(evens);
  		     * // => [2, 4]
  		     */
  		    function remove(array, predicate) {
  		      var result = [];
  		      if (!(array && array.length)) {
  		        return result;
  		      }
  		      var index = -1,
  		          indexes = [],
  		          length = array.length;

  		      predicate = getIteratee(predicate, 3);
  		      while (++index < length) {
  		        var value = array[index];
  		        if (predicate(value, index, array)) {
  		          result.push(value);
  		          indexes.push(index);
  		        }
  		      }
  		      basePullAt(array, indexes);
  		      return result;
  		    }

  		    /**
  		     * Reverses `array` so that the first element becomes the last, the second
  		     * element becomes the second to last, and so on.
  		     *
  		     * **Note:** This method mutates `array` and is based on
  		     * [`Array#reverse`](https://mdn.io/Array/reverse).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to modify.
  		     * @returns {Array} Returns `array`.
  		     * @example
  		     *
  		     * var array = [1, 2, 3];
  		     *
  		     * _.reverse(array);
  		     * // => [3, 2, 1]
  		     *
  		     * console.log(array);
  		     * // => [3, 2, 1]
  		     */
  		    function reverse(array) {
  		      return array == null ? array : nativeReverse.call(array);
  		    }

  		    /**
  		     * Creates a slice of `array` from `start` up to, but not including, `end`.
  		     *
  		     * **Note:** This method is used instead of
  		     * [`Array#slice`](https://mdn.io/Array/slice) to ensure dense arrays are
  		     * returned.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to slice.
  		     * @param {number} [start=0] The start position.
  		     * @param {number} [end=array.length] The end position.
  		     * @returns {Array} Returns the slice of `array`.
  		     */
  		    function slice(array, start, end) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      if (end && typeof end != 'number' && isIterateeCall(array, start, end)) {
  		        start = 0;
  		        end = length;
  		      }
  		      else {
  		        start = start == null ? 0 : toInteger(start);
  		        end = end === undefined$1 ? length : toInteger(end);
  		      }
  		      return baseSlice(array, start, end);
  		    }

  		    /**
  		     * Uses a binary search to determine the lowest index at which `value`
  		     * should be inserted into `array` in order to maintain its sort order.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     * @example
  		     *
  		     * _.sortedIndex([30, 50], 40);
  		     * // => 1
  		     */
  		    function sortedIndex(array, value) {
  		      return baseSortedIndex(array, value);
  		    }

  		    /**
  		     * This method is like `_.sortedIndex` except that it accepts `iteratee`
  		     * which is invoked for `value` and each element of `array` to compute their
  		     * sort ranking. The iteratee is invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 4 }, { 'x': 5 }];
  		     *
  		     * _.sortedIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
  		     * // => 0
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.sortedIndexBy(objects, { 'x': 4 }, 'x');
  		     * // => 0
  		     */
  		    function sortedIndexBy(array, value, iteratee) {
  		      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2));
  		    }

  		    /**
  		     * This method is like `_.indexOf` except that it performs a binary
  		     * search on a sorted `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {*} value The value to search for.
  		     * @returns {number} Returns the index of the matched value, else `-1`.
  		     * @example
  		     *
  		     * _.sortedIndexOf([4, 5, 5, 5, 6], 5);
  		     * // => 1
  		     */
  		    function sortedIndexOf(array, value) {
  		      var length = array == null ? 0 : array.length;
  		      if (length) {
  		        var index = baseSortedIndex(array, value);
  		        if (index < length && eq(array[index], value)) {
  		          return index;
  		        }
  		      }
  		      return -1;
  		    }

  		    /**
  		     * This method is like `_.sortedIndex` except that it returns the highest
  		     * index at which `value` should be inserted into `array` in order to
  		     * maintain its sort order.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     * @example
  		     *
  		     * _.sortedLastIndex([4, 5, 5, 5, 6], 5);
  		     * // => 4
  		     */
  		    function sortedLastIndex(array, value) {
  		      return baseSortedIndex(array, value, true);
  		    }

  		    /**
  		     * This method is like `_.sortedLastIndex` except that it accepts `iteratee`
  		     * which is invoked for `value` and each element of `array` to compute their
  		     * sort ranking. The iteratee is invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The sorted array to inspect.
  		     * @param {*} value The value to evaluate.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {number} Returns the index at which `value` should be inserted
  		     *  into `array`.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 4 }, { 'x': 5 }];
  		     *
  		     * _.sortedLastIndexBy(objects, { 'x': 4 }, function(o) { return o.x; });
  		     * // => 1
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.sortedLastIndexBy(objects, { 'x': 4 }, 'x');
  		     * // => 1
  		     */
  		    function sortedLastIndexBy(array, value, iteratee) {
  		      return baseSortedIndexBy(array, value, getIteratee(iteratee, 2), true);
  		    }

  		    /**
  		     * This method is like `_.lastIndexOf` except that it performs a binary
  		     * search on a sorted `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {*} value The value to search for.
  		     * @returns {number} Returns the index of the matched value, else `-1`.
  		     * @example
  		     *
  		     * _.sortedLastIndexOf([4, 5, 5, 5, 6], 5);
  		     * // => 3
  		     */
  		    function sortedLastIndexOf(array, value) {
  		      var length = array == null ? 0 : array.length;
  		      if (length) {
  		        var index = baseSortedIndex(array, value, true) - 1;
  		        if (eq(array[index], value)) {
  		          return index;
  		        }
  		      }
  		      return -1;
  		    }

  		    /**
  		     * This method is like `_.uniq` except that it's designed and optimized
  		     * for sorted arrays.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @returns {Array} Returns the new duplicate free array.
  		     * @example
  		     *
  		     * _.sortedUniq([1, 1, 2]);
  		     * // => [1, 2]
  		     */
  		    function sortedUniq(array) {
  		      return (array && array.length)
  		        ? baseSortedUniq(array)
  		        : [];
  		    }

  		    /**
  		     * This method is like `_.uniqBy` except that it's designed and optimized
  		     * for sorted arrays.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [iteratee] The iteratee invoked per element.
  		     * @returns {Array} Returns the new duplicate free array.
  		     * @example
  		     *
  		     * _.sortedUniqBy([1.1, 1.2, 2.3, 2.4], Math.floor);
  		     * // => [1.1, 2.3]
  		     */
  		    function sortedUniqBy(array, iteratee) {
  		      return (array && array.length)
  		        ? baseSortedUniq(array, getIteratee(iteratee, 2))
  		        : [];
  		    }

  		    /**
  		     * Gets all but the first element of `array`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.tail([1, 2, 3]);
  		     * // => [2, 3]
  		     */
  		    function tail(array) {
  		      var length = array == null ? 0 : array.length;
  		      return length ? baseSlice(array, 1, length) : [];
  		    }

  		    /**
  		     * Creates a slice of `array` with `n` elements taken from the beginning.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {number} [n=1] The number of elements to take.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.take([1, 2, 3]);
  		     * // => [1]
  		     *
  		     * _.take([1, 2, 3], 2);
  		     * // => [1, 2]
  		     *
  		     * _.take([1, 2, 3], 5);
  		     * // => [1, 2, 3]
  		     *
  		     * _.take([1, 2, 3], 0);
  		     * // => []
  		     */
  		    function take(array, n, guard) {
  		      if (!(array && array.length)) {
  		        return [];
  		      }
  		      n = (guard || n === undefined$1) ? 1 : toInteger(n);
  		      return baseSlice(array, 0, n < 0 ? 0 : n);
  		    }

  		    /**
  		     * Creates a slice of `array` with `n` elements taken from the end.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {number} [n=1] The number of elements to take.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * _.takeRight([1, 2, 3]);
  		     * // => [3]
  		     *
  		     * _.takeRight([1, 2, 3], 2);
  		     * // => [2, 3]
  		     *
  		     * _.takeRight([1, 2, 3], 5);
  		     * // => [1, 2, 3]
  		     *
  		     * _.takeRight([1, 2, 3], 0);
  		     * // => []
  		     */
  		    function takeRight(array, n, guard) {
  		      var length = array == null ? 0 : array.length;
  		      if (!length) {
  		        return [];
  		      }
  		      n = (guard || n === undefined$1) ? 1 : toInteger(n);
  		      n = length - n;
  		      return baseSlice(array, n < 0 ? 0 : n, length);
  		    }

  		    /**
  		     * Creates a slice of `array` with elements taken from the end. Elements are
  		     * taken until `predicate` returns falsey. The predicate is invoked with
  		     * three arguments: (value, index, array).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': true },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': false }
  		     * ];
  		     *
  		     * _.takeRightWhile(users, function(o) { return !o.active; });
  		     * // => objects for ['fred', 'pebbles']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.takeRightWhile(users, { 'user': 'pebbles', 'active': false });
  		     * // => objects for ['pebbles']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.takeRightWhile(users, ['active', false]);
  		     * // => objects for ['fred', 'pebbles']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.takeRightWhile(users, 'active');
  		     * // => []
  		     */
  		    function takeRightWhile(array, predicate) {
  		      return (array && array.length)
  		        ? baseWhile(array, getIteratee(predicate, 3), false, true)
  		        : [];
  		    }

  		    /**
  		     * Creates a slice of `array` with elements taken from the beginning. Elements
  		     * are taken until `predicate` returns falsey. The predicate is invoked with
  		     * three arguments: (value, index, array).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Array
  		     * @param {Array} array The array to query.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the slice of `array`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'active': false },
  		     *   { 'user': 'fred',    'active': false },
  		     *   { 'user': 'pebbles', 'active': true }
  		     * ];
  		     *
  		     * _.takeWhile(users, function(o) { return !o.active; });
  		     * // => objects for ['barney', 'fred']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.takeWhile(users, { 'user': 'barney', 'active': false });
  		     * // => objects for ['barney']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.takeWhile(users, ['active', false]);
  		     * // => objects for ['barney', 'fred']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.takeWhile(users, 'active');
  		     * // => []
  		     */
  		    function takeWhile(array, predicate) {
  		      return (array && array.length)
  		        ? baseWhile(array, getIteratee(predicate, 3))
  		        : [];
  		    }

  		    /**
  		     * Creates an array of unique values, in order, from all given arrays using
  		     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @returns {Array} Returns the new array of combined values.
  		     * @example
  		     *
  		     * _.union([2], [1, 2]);
  		     * // => [2, 1]
  		     */
  		    var union = baseRest(function(arrays) {
  		      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  		    });

  		    /**
  		     * This method is like `_.union` except that it accepts `iteratee` which is
  		     * invoked for each element of each `arrays` to generate the criterion by
  		     * which uniqueness is computed. Result values are chosen from the first
  		     * array in which the value occurs. The iteratee is invoked with one argument:
  		     * (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns the new array of combined values.
  		     * @example
  		     *
  		     * _.unionBy([2.1], [1.2, 2.3], Math.floor);
  		     * // => [2.1, 1.2]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.unionBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
  		     * // => [{ 'x': 1 }, { 'x': 2 }]
  		     */
  		    var unionBy = baseRest(function(arrays) {
  		      var iteratee = last(arrays);
  		      if (isArrayLikeObject(iteratee)) {
  		        iteratee = undefined$1;
  		      }
  		      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), getIteratee(iteratee, 2));
  		    });

  		    /**
  		     * This method is like `_.union` except that it accepts `comparator` which
  		     * is invoked to compare elements of `arrays`. Result values are chosen from
  		     * the first array in which the value occurs. The comparator is invoked
  		     * with two arguments: (arrVal, othVal).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of combined values.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
  		     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
  		     *
  		     * _.unionWith(objects, others, _.isEqual);
  		     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
  		     */
  		    var unionWith = baseRest(function(arrays) {
  		      var comparator = last(arrays);
  		      comparator = typeof comparator == 'function' ? comparator : undefined$1;
  		      return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true), undefined$1, comparator);
  		    });

  		    /**
  		     * Creates a duplicate-free version of an array, using
  		     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons, in which only the first occurrence of each element
  		     * is kept. The order of result values is determined by the order they occur
  		     * in the array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @returns {Array} Returns the new duplicate free array.
  		     * @example
  		     *
  		     * _.uniq([2, 1, 2]);
  		     * // => [2, 1]
  		     */
  		    function uniq(array) {
  		      return (array && array.length) ? baseUniq(array) : [];
  		    }

  		    /**
  		     * This method is like `_.uniq` except that it accepts `iteratee` which is
  		     * invoked for each element in `array` to generate the criterion by which
  		     * uniqueness is computed. The order of result values is determined by the
  		     * order they occur in the array. The iteratee is invoked with one argument:
  		     * (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns the new duplicate free array.
  		     * @example
  		     *
  		     * _.uniqBy([2.1, 1.2, 2.3], Math.floor);
  		     * // => [2.1, 1.2]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.uniqBy([{ 'x': 1 }, { 'x': 2 }, { 'x': 1 }], 'x');
  		     * // => [{ 'x': 1 }, { 'x': 2 }]
  		     */
  		    function uniqBy(array, iteratee) {
  		      return (array && array.length) ? baseUniq(array, getIteratee(iteratee, 2)) : [];
  		    }

  		    /**
  		     * This method is like `_.uniq` except that it accepts `comparator` which
  		     * is invoked to compare elements of `array`. The order of result values is
  		     * determined by the order they occur in the array.The comparator is invoked
  		     * with two arguments: (arrVal, othVal).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new duplicate free array.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }, { 'x': 1, 'y': 2 }];
  		     *
  		     * _.uniqWith(objects, _.isEqual);
  		     * // => [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }]
  		     */
  		    function uniqWith(array, comparator) {
  		      comparator = typeof comparator == 'function' ? comparator : undefined$1;
  		      return (array && array.length) ? baseUniq(array, undefined$1, comparator) : [];
  		    }

  		    /**
  		     * This method is like `_.zip` except that it accepts an array of grouped
  		     * elements and creates an array regrouping the elements to their pre-zip
  		     * configuration.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 1.2.0
  		     * @category Array
  		     * @param {Array} array The array of grouped elements to process.
  		     * @returns {Array} Returns the new array of regrouped elements.
  		     * @example
  		     *
  		     * var zipped = _.zip(['a', 'b'], [1, 2], [true, false]);
  		     * // => [['a', 1, true], ['b', 2, false]]
  		     *
  		     * _.unzip(zipped);
  		     * // => [['a', 'b'], [1, 2], [true, false]]
  		     */
  		    function unzip(array) {
  		      if (!(array && array.length)) {
  		        return [];
  		      }
  		      var length = 0;
  		      array = arrayFilter(array, function(group) {
  		        if (isArrayLikeObject(group)) {
  		          length = nativeMax(group.length, length);
  		          return true;
  		        }
  		      });
  		      return baseTimes(length, function(index) {
  		        return arrayMap(array, baseProperty(index));
  		      });
  		    }

  		    /**
  		     * This method is like `_.unzip` except that it accepts `iteratee` to specify
  		     * how regrouped values should be combined. The iteratee is invoked with the
  		     * elements of each group: (...group).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.8.0
  		     * @category Array
  		     * @param {Array} array The array of grouped elements to process.
  		     * @param {Function} [iteratee=_.identity] The function to combine
  		     *  regrouped values.
  		     * @returns {Array} Returns the new array of regrouped elements.
  		     * @example
  		     *
  		     * var zipped = _.zip([1, 2], [10, 20], [100, 200]);
  		     * // => [[1, 10, 100], [2, 20, 200]]
  		     *
  		     * _.unzipWith(zipped, _.add);
  		     * // => [3, 30, 300]
  		     */
  		    function unzipWith(array, iteratee) {
  		      if (!(array && array.length)) {
  		        return [];
  		      }
  		      var result = unzip(array);
  		      if (iteratee == null) {
  		        return result;
  		      }
  		      return arrayMap(result, function(group) {
  		        return apply(iteratee, undefined$1, group);
  		      });
  		    }

  		    /**
  		     * Creates an array excluding all given values using
  		     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * for equality comparisons.
  		     *
  		     * **Note:** Unlike `_.pull`, this method returns a new array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {Array} array The array to inspect.
  		     * @param {...*} [values] The values to exclude.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @see _.difference, _.xor
  		     * @example
  		     *
  		     * _.without([2, 1, 2, 3], 1, 2);
  		     * // => [3]
  		     */
  		    var without = baseRest(function(array, values) {
  		      return isArrayLikeObject(array)
  		        ? baseDifference(array, values)
  		        : [];
  		    });

  		    /**
  		     * Creates an array of unique values that is the
  		     * [symmetric difference](https://en.wikipedia.org/wiki/Symmetric_difference)
  		     * of the given arrays. The order of result values is determined by the order
  		     * they occur in the arrays.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.4.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @see _.difference, _.without
  		     * @example
  		     *
  		     * _.xor([2, 1], [2, 3]);
  		     * // => [1, 3]
  		     */
  		    var xor = baseRest(function(arrays) {
  		      return baseXor(arrayFilter(arrays, isArrayLikeObject));
  		    });

  		    /**
  		     * This method is like `_.xor` except that it accepts `iteratee` which is
  		     * invoked for each element of each `arrays` to generate the criterion by
  		     * which by which they're compared. The order of result values is determined
  		     * by the order they occur in the arrays. The iteratee is invoked with one
  		     * argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [iteratee=_.identity] The iteratee invoked per element.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @example
  		     *
  		     * _.xorBy([2.1, 1.2], [2.3, 3.4], Math.floor);
  		     * // => [1.2, 3.4]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.xorBy([{ 'x': 1 }], [{ 'x': 2 }, { 'x': 1 }], 'x');
  		     * // => [{ 'x': 2 }]
  		     */
  		    var xorBy = baseRest(function(arrays) {
  		      var iteratee = last(arrays);
  		      if (isArrayLikeObject(iteratee)) {
  		        iteratee = undefined$1;
  		      }
  		      return baseXor(arrayFilter(arrays, isArrayLikeObject), getIteratee(iteratee, 2));
  		    });

  		    /**
  		     * This method is like `_.xor` except that it accepts `comparator` which is
  		     * invoked to compare elements of `arrays`. The order of result values is
  		     * determined by the order they occur in the arrays. The comparator is invoked
  		     * with two arguments: (arrVal, othVal).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to inspect.
  		     * @param {Function} [comparator] The comparator invoked per element.
  		     * @returns {Array} Returns the new array of filtered values.
  		     * @example
  		     *
  		     * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
  		     * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
  		     *
  		     * _.xorWith(objects, others, _.isEqual);
  		     * // => [{ 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
  		     */
  		    var xorWith = baseRest(function(arrays) {
  		      var comparator = last(arrays);
  		      comparator = typeof comparator == 'function' ? comparator : undefined$1;
  		      return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined$1, comparator);
  		    });

  		    /**
  		     * Creates an array of grouped elements, the first of which contains the
  		     * first elements of the given arrays, the second of which contains the
  		     * second elements of the given arrays, and so on.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to process.
  		     * @returns {Array} Returns the new array of grouped elements.
  		     * @example
  		     *
  		     * _.zip(['a', 'b'], [1, 2], [true, false]);
  		     * // => [['a', 1, true], ['b', 2, false]]
  		     */
  		    var zip = baseRest(unzip);

  		    /**
  		     * This method is like `_.fromPairs` except that it accepts two arrays,
  		     * one of property identifiers and one of corresponding values.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.4.0
  		     * @category Array
  		     * @param {Array} [props=[]] The property identifiers.
  		     * @param {Array} [values=[]] The property values.
  		     * @returns {Object} Returns the new object.
  		     * @example
  		     *
  		     * _.zipObject(['a', 'b'], [1, 2]);
  		     * // => { 'a': 1, 'b': 2 }
  		     */
  		    function zipObject(props, values) {
  		      return baseZipObject(props || [], values || [], assignValue);
  		    }

  		    /**
  		     * This method is like `_.zipObject` except that it supports property paths.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.1.0
  		     * @category Array
  		     * @param {Array} [props=[]] The property identifiers.
  		     * @param {Array} [values=[]] The property values.
  		     * @returns {Object} Returns the new object.
  		     * @example
  		     *
  		     * _.zipObjectDeep(['a.b[0].c', 'a.b[1].d'], [1, 2]);
  		     * // => { 'a': { 'b': [{ 'c': 1 }, { 'd': 2 }] } }
  		     */
  		    function zipObjectDeep(props, values) {
  		      return baseZipObject(props || [], values || [], baseSet);
  		    }

  		    /**
  		     * This method is like `_.zip` except that it accepts `iteratee` to specify
  		     * how grouped values should be combined. The iteratee is invoked with the
  		     * elements of each group: (...group).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.8.0
  		     * @category Array
  		     * @param {...Array} [arrays] The arrays to process.
  		     * @param {Function} [iteratee=_.identity] The function to combine
  		     *  grouped values.
  		     * @returns {Array} Returns the new array of grouped elements.
  		     * @example
  		     *
  		     * _.zipWith([1, 2], [10, 20], [100, 200], function(a, b, c) {
  		     *   return a + b + c;
  		     * });
  		     * // => [111, 222]
  		     */
  		    var zipWith = baseRest(function(arrays) {
  		      var length = arrays.length,
  		          iteratee = length > 1 ? arrays[length - 1] : undefined$1;

  		      iteratee = typeof iteratee == 'function' ? (arrays.pop(), iteratee) : undefined$1;
  		      return unzipWith(arrays, iteratee);
  		    });

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates a `lodash` wrapper instance that wraps `value` with explicit method
  		     * chain sequences enabled. The result of such sequences must be unwrapped
  		     * with `_#value`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 1.3.0
  		     * @category Seq
  		     * @param {*} value The value to wrap.
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'age': 36 },
  		     *   { 'user': 'fred',    'age': 40 },
  		     *   { 'user': 'pebbles', 'age': 1 }
  		     * ];
  		     *
  		     * var youngest = _
  		     *   .chain(users)
  		     *   .sortBy('age')
  		     *   .map(function(o) {
  		     *     return o.user + ' is ' + o.age;
  		     *   })
  		     *   .head()
  		     *   .value();
  		     * // => 'pebbles is 1'
  		     */
  		    function chain(value) {
  		      var result = lodash(value);
  		      result.__chain__ = true;
  		      return result;
  		    }

  		    /**
  		     * This method invokes `interceptor` and returns `value`. The interceptor
  		     * is invoked with one argument; (value). The purpose of this method is to
  		     * "tap into" a method chain sequence in order to modify intermediate results.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Seq
  		     * @param {*} value The value to provide to `interceptor`.
  		     * @param {Function} interceptor The function to invoke.
  		     * @returns {*} Returns `value`.
  		     * @example
  		     *
  		     * _([1, 2, 3])
  		     *  .tap(function(array) {
  		     *    // Mutate input array.
  		     *    array.pop();
  		     *  })
  		     *  .reverse()
  		     *  .value();
  		     * // => [2, 1]
  		     */
  		    function tap(value, interceptor) {
  		      interceptor(value);
  		      return value;
  		    }

  		    /**
  		     * This method is like `_.tap` except that it returns the result of `interceptor`.
  		     * The purpose of this method is to "pass thru" values replacing intermediate
  		     * results in a method chain sequence.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Seq
  		     * @param {*} value The value to provide to `interceptor`.
  		     * @param {Function} interceptor The function to invoke.
  		     * @returns {*} Returns the result of `interceptor`.
  		     * @example
  		     *
  		     * _('  abc  ')
  		     *  .chain()
  		     *  .trim()
  		     *  .thru(function(value) {
  		     *    return [value];
  		     *  })
  		     *  .value();
  		     * // => ['abc']
  		     */
  		    function thru(value, interceptor) {
  		      return interceptor(value);
  		    }

  		    /**
  		     * This method is the wrapper version of `_.at`.
  		     *
  		     * @name at
  		     * @memberOf _
  		     * @since 1.0.0
  		     * @category Seq
  		     * @param {...(string|string[])} [paths] The property paths to pick.
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * var object = { 'a': [{ 'b': { 'c': 3 } }, 4] };
  		     *
  		     * _(object).at(['a[0].b.c', 'a[1]']).value();
  		     * // => [3, 4]
  		     */
  		    var wrapperAt = flatRest(function(paths) {
  		      var length = paths.length,
  		          start = length ? paths[0] : 0,
  		          value = this.__wrapped__,
  		          interceptor = function(object) { return baseAt(object, paths); };

  		      if (length > 1 || this.__actions__.length ||
  		          !(value instanceof LazyWrapper) || !isIndex(start)) {
  		        return this.thru(interceptor);
  		      }
  		      value = value.slice(start, +start + (length ? 1 : 0));
  		      value.__actions__.push({
  		        'func': thru,
  		        'args': [interceptor],
  		        'thisArg': undefined$1
  		      });
  		      return new LodashWrapper(value, this.__chain__).thru(function(array) {
  		        if (length && !array.length) {
  		          array.push(undefined$1);
  		        }
  		        return array;
  		      });
  		    });

  		    /**
  		     * Creates a `lodash` wrapper instance with explicit method chain sequences enabled.
  		     *
  		     * @name chain
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Seq
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney', 'age': 36 },
  		     *   { 'user': 'fred',   'age': 40 }
  		     * ];
  		     *
  		     * // A sequence without explicit chaining.
  		     * _(users).head();
  		     * // => { 'user': 'barney', 'age': 36 }
  		     *
  		     * // A sequence with explicit chaining.
  		     * _(users)
  		     *   .chain()
  		     *   .head()
  		     *   .pick('user')
  		     *   .value();
  		     * // => { 'user': 'barney' }
  		     */
  		    function wrapperChain() {
  		      return chain(this);
  		    }

  		    /**
  		     * Executes the chain sequence and returns the wrapped result.
  		     *
  		     * @name commit
  		     * @memberOf _
  		     * @since 3.2.0
  		     * @category Seq
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * var array = [1, 2];
  		     * var wrapped = _(array).push(3);
  		     *
  		     * console.log(array);
  		     * // => [1, 2]
  		     *
  		     * wrapped = wrapped.commit();
  		     * console.log(array);
  		     * // => [1, 2, 3]
  		     *
  		     * wrapped.last();
  		     * // => 3
  		     *
  		     * console.log(array);
  		     * // => [1, 2, 3]
  		     */
  		    function wrapperCommit() {
  		      return new LodashWrapper(this.value(), this.__chain__);
  		    }

  		    /**
  		     * Gets the next value on a wrapped object following the
  		     * [iterator protocol](https://mdn.io/iteration_protocols#iterator).
  		     *
  		     * @name next
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Seq
  		     * @returns {Object} Returns the next iterator value.
  		     * @example
  		     *
  		     * var wrapped = _([1, 2]);
  		     *
  		     * wrapped.next();
  		     * // => { 'done': false, 'value': 1 }
  		     *
  		     * wrapped.next();
  		     * // => { 'done': false, 'value': 2 }
  		     *
  		     * wrapped.next();
  		     * // => { 'done': true, 'value': undefined }
  		     */
  		    function wrapperNext() {
  		      if (this.__values__ === undefined$1) {
  		        this.__values__ = toArray(this.value());
  		      }
  		      var done = this.__index__ >= this.__values__.length,
  		          value = done ? undefined$1 : this.__values__[this.__index__++];

  		      return { 'done': done, 'value': value };
  		    }

  		    /**
  		     * Enables the wrapper to be iterable.
  		     *
  		     * @name Symbol.iterator
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Seq
  		     * @returns {Object} Returns the wrapper object.
  		     * @example
  		     *
  		     * var wrapped = _([1, 2]);
  		     *
  		     * wrapped[Symbol.iterator]() === wrapped;
  		     * // => true
  		     *
  		     * Array.from(wrapped);
  		     * // => [1, 2]
  		     */
  		    function wrapperToIterator() {
  		      return this;
  		    }

  		    /**
  		     * Creates a clone of the chain sequence planting `value` as the wrapped value.
  		     *
  		     * @name plant
  		     * @memberOf _
  		     * @since 3.2.0
  		     * @category Seq
  		     * @param {*} value The value to plant.
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * function square(n) {
  		     *   return n * n;
  		     * }
  		     *
  		     * var wrapped = _([1, 2]).map(square);
  		     * var other = wrapped.plant([3, 4]);
  		     *
  		     * other.value();
  		     * // => [9, 16]
  		     *
  		     * wrapped.value();
  		     * // => [1, 4]
  		     */
  		    function wrapperPlant(value) {
  		      var result,
  		          parent = this;

  		      while (parent instanceof baseLodash) {
  		        var clone = wrapperClone(parent);
  		        clone.__index__ = 0;
  		        clone.__values__ = undefined$1;
  		        if (result) {
  		          previous.__wrapped__ = clone;
  		        } else {
  		          result = clone;
  		        }
  		        var previous = clone;
  		        parent = parent.__wrapped__;
  		      }
  		      previous.__wrapped__ = value;
  		      return result;
  		    }

  		    /**
  		     * This method is the wrapper version of `_.reverse`.
  		     *
  		     * **Note:** This method mutates the wrapped array.
  		     *
  		     * @name reverse
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Seq
  		     * @returns {Object} Returns the new `lodash` wrapper instance.
  		     * @example
  		     *
  		     * var array = [1, 2, 3];
  		     *
  		     * _(array).reverse().value()
  		     * // => [3, 2, 1]
  		     *
  		     * console.log(array);
  		     * // => [3, 2, 1]
  		     */
  		    function wrapperReverse() {
  		      var value = this.__wrapped__;
  		      if (value instanceof LazyWrapper) {
  		        var wrapped = value;
  		        if (this.__actions__.length) {
  		          wrapped = new LazyWrapper(this);
  		        }
  		        wrapped = wrapped.reverse();
  		        wrapped.__actions__.push({
  		          'func': thru,
  		          'args': [reverse],
  		          'thisArg': undefined$1
  		        });
  		        return new LodashWrapper(wrapped, this.__chain__);
  		      }
  		      return this.thru(reverse);
  		    }

  		    /**
  		     * Executes the chain sequence to resolve the unwrapped value.
  		     *
  		     * @name value
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @alias toJSON, valueOf
  		     * @category Seq
  		     * @returns {*} Returns the resolved unwrapped value.
  		     * @example
  		     *
  		     * _([1, 2, 3]).value();
  		     * // => [1, 2, 3]
  		     */
  		    function wrapperValue() {
  		      return baseWrapperValue(this.__wrapped__, this.__actions__);
  		    }

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Creates an object composed of keys generated from the results of running
  		     * each element of `collection` thru `iteratee`. The corresponding value of
  		     * each key is the number of times the key was returned by `iteratee`. The
  		     * iteratee is invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.5.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
  		     * @returns {Object} Returns the composed aggregate object.
  		     * @example
  		     *
  		     * _.countBy([6.1, 4.2, 6.3], Math.floor);
  		     * // => { '4': 1, '6': 2 }
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.countBy(['one', 'two', 'three'], 'length');
  		     * // => { '3': 2, '5': 1 }
  		     */
  		    var countBy = createAggregator(function(result, value, key) {
  		      if (hasOwnProperty.call(result, key)) {
  		        ++result[key];
  		      } else {
  		        baseAssignValue(result, key, 1);
  		      }
  		    });

  		    /**
  		     * Checks if `predicate` returns truthy for **all** elements of `collection`.
  		     * Iteration is stopped once `predicate` returns falsey. The predicate is
  		     * invoked with three arguments: (value, index|key, collection).
  		     *
  		     * **Note:** This method returns `true` for
  		     * [empty collections](https://en.wikipedia.org/wiki/Empty_set) because
  		     * [everything is true](https://en.wikipedia.org/wiki/Vacuous_truth) of
  		     * elements of empty collections.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {boolean} Returns `true` if all elements pass the predicate check,
  		     *  else `false`.
  		     * @example
  		     *
  		     * _.every([true, 1, null, 'yes'], Boolean);
  		     * // => false
  		     *
  		     * var users = [
  		     *   { 'user': 'barney', 'age': 36, 'active': false },
  		     *   { 'user': 'fred',   'age': 40, 'active': false }
  		     * ];
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.every(users, { 'user': 'barney', 'active': false });
  		     * // => false
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.every(users, ['active', false]);
  		     * // => true
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.every(users, 'active');
  		     * // => false
  		     */
  		    function every(collection, predicate, guard) {
  		      var func = isArray(collection) ? arrayEvery : baseEvery;
  		      if (guard && isIterateeCall(collection, predicate, guard)) {
  		        predicate = undefined$1;
  		      }
  		      return func(collection, getIteratee(predicate, 3));
  		    }

  		    /**
  		     * Iterates over elements of `collection`, returning an array of all elements
  		     * `predicate` returns truthy for. The predicate is invoked with three
  		     * arguments: (value, index|key, collection).
  		     *
  		     * **Note:** Unlike `_.remove`, this method returns a new array.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new filtered array.
  		     * @see _.reject
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney', 'age': 36, 'active': true },
  		     *   { 'user': 'fred',   'age': 40, 'active': false }
  		     * ];
  		     *
  		     * _.filter(users, function(o) { return !o.active; });
  		     * // => objects for ['fred']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.filter(users, { 'age': 36, 'active': true });
  		     * // => objects for ['barney']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.filter(users, ['active', false]);
  		     * // => objects for ['fred']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.filter(users, 'active');
  		     * // => objects for ['barney']
  		     *
  		     * // Combining several predicates using `_.overEvery` or `_.overSome`.
  		     * _.filter(users, _.overSome([{ 'age': 36 }, ['age', 40]]));
  		     * // => objects for ['fred', 'barney']
  		     */
  		    function filter(collection, predicate) {
  		      var func = isArray(collection) ? arrayFilter : baseFilter;
  		      return func(collection, getIteratee(predicate, 3));
  		    }

  		    /**
  		     * Iterates over elements of `collection`, returning the first element
  		     * `predicate` returns truthy for. The predicate is invoked with three
  		     * arguments: (value, index|key, collection).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to inspect.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param {number} [fromIndex=0] The index to search from.
  		     * @returns {*} Returns the matched element, else `undefined`.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'age': 36, 'active': true },
  		     *   { 'user': 'fred',    'age': 40, 'active': false },
  		     *   { 'user': 'pebbles', 'age': 1,  'active': true }
  		     * ];
  		     *
  		     * _.find(users, function(o) { return o.age < 40; });
  		     * // => object for 'barney'
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.find(users, { 'age': 1, 'active': true });
  		     * // => object for 'pebbles'
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.find(users, ['active', false]);
  		     * // => object for 'fred'
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.find(users, 'active');
  		     * // => object for 'barney'
  		     */
  		    var find = createFind(findIndex);

  		    /**
  		     * This method is like `_.find` except that it iterates over elements of
  		     * `collection` from right to left.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to inspect.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param {number} [fromIndex=collection.length-1] The index to search from.
  		     * @returns {*} Returns the matched element, else `undefined`.
  		     * @example
  		     *
  		     * _.findLast([1, 2, 3, 4], function(n) {
  		     *   return n % 2 == 1;
  		     * });
  		     * // => 3
  		     */
  		    var findLast = createFind(findLastIndex);

  		    /**
  		     * Creates a flattened array of values by running each element in `collection`
  		     * thru `iteratee` and flattening the mapped results. The iteratee is invoked
  		     * with three arguments: (value, index|key, collection).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * function duplicate(n) {
  		     *   return [n, n];
  		     * }
  		     *
  		     * _.flatMap([1, 2], duplicate);
  		     * // => [1, 1, 2, 2]
  		     */
  		    function flatMap(collection, iteratee) {
  		      return baseFlatten(map(collection, iteratee), 1);
  		    }

  		    /**
  		     * This method is like `_.flatMap` except that it recursively flattens the
  		     * mapped results.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.7.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * function duplicate(n) {
  		     *   return [[[n, n]]];
  		     * }
  		     *
  		     * _.flatMapDeep([1, 2], duplicate);
  		     * // => [1, 1, 2, 2]
  		     */
  		    function flatMapDeep(collection, iteratee) {
  		      return baseFlatten(map(collection, iteratee), INFINITY);
  		    }

  		    /**
  		     * This method is like `_.flatMap` except that it recursively flattens the
  		     * mapped results up to `depth` times.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.7.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @param {number} [depth=1] The maximum recursion depth.
  		     * @returns {Array} Returns the new flattened array.
  		     * @example
  		     *
  		     * function duplicate(n) {
  		     *   return [[[n, n]]];
  		     * }
  		     *
  		     * _.flatMapDepth([1, 2], duplicate, 2);
  		     * // => [[1, 1], [2, 2]]
  		     */
  		    function flatMapDepth(collection, iteratee, depth) {
  		      depth = depth === undefined$1 ? 1 : toInteger(depth);
  		      return baseFlatten(map(collection, iteratee), depth);
  		    }

  		    /**
  		     * Iterates over elements of `collection` and invokes `iteratee` for each element.
  		     * The iteratee is invoked with three arguments: (value, index|key, collection).
  		     * Iteratee functions may exit iteration early by explicitly returning `false`.
  		     *
  		     * **Note:** As with other "Collections" methods, objects with a "length"
  		     * property are iterated like arrays. To avoid this behavior use `_.forIn`
  		     * or `_.forOwn` for object iteration.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @alias each
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @returns {Array|Object} Returns `collection`.
  		     * @see _.forEachRight
  		     * @example
  		     *
  		     * _.forEach([1, 2], function(value) {
  		     *   console.log(value);
  		     * });
  		     * // => Logs `1` then `2`.
  		     *
  		     * _.forEach({ 'a': 1, 'b': 2 }, function(value, key) {
  		     *   console.log(key);
  		     * });
  		     * // => Logs 'a' then 'b' (iteration order is not guaranteed).
  		     */
  		    function forEach(collection, iteratee) {
  		      var func = isArray(collection) ? arrayEach : baseEach;
  		      return func(collection, getIteratee(iteratee, 3));
  		    }

  		    /**
  		     * This method is like `_.forEach` except that it iterates over elements of
  		     * `collection` from right to left.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @alias eachRight
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @returns {Array|Object} Returns `collection`.
  		     * @see _.forEach
  		     * @example
  		     *
  		     * _.forEachRight([1, 2], function(value) {
  		     *   console.log(value);
  		     * });
  		     * // => Logs `2` then `1`.
  		     */
  		    function forEachRight(collection, iteratee) {
  		      var func = isArray(collection) ? arrayEachRight : baseEachRight;
  		      return func(collection, getIteratee(iteratee, 3));
  		    }

  		    /**
  		     * Creates an object composed of keys generated from the results of running
  		     * each element of `collection` thru `iteratee`. The order of grouped values
  		     * is determined by the order they occur in `collection`. The corresponding
  		     * value of each key is an array of elements responsible for generating the
  		     * key. The iteratee is invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
  		     * @returns {Object} Returns the composed aggregate object.
  		     * @example
  		     *
  		     * _.groupBy([6.1, 4.2, 6.3], Math.floor);
  		     * // => { '4': [4.2], '6': [6.1, 6.3] }
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.groupBy(['one', 'two', 'three'], 'length');
  		     * // => { '3': ['one', 'two'], '5': ['three'] }
  		     */
  		    var groupBy = createAggregator(function(result, value, key) {
  		      if (hasOwnProperty.call(result, key)) {
  		        result[key].push(value);
  		      } else {
  		        baseAssignValue(result, key, [value]);
  		      }
  		    });

  		    /**
  		     * Checks if `value` is in `collection`. If `collection` is a string, it's
  		     * checked for a substring of `value`, otherwise
  		     * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
  		     * is used for equality comparisons. If `fromIndex` is negative, it's used as
  		     * the offset from the end of `collection`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object|string} collection The collection to inspect.
  		     * @param {*} value The value to search for.
  		     * @param {number} [fromIndex=0] The index to search from.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
  		     * @returns {boolean} Returns `true` if `value` is found, else `false`.
  		     * @example
  		     *
  		     * _.includes([1, 2, 3], 1);
  		     * // => true
  		     *
  		     * _.includes([1, 2, 3], 1, 2);
  		     * // => false
  		     *
  		     * _.includes({ 'a': 1, 'b': 2 }, 1);
  		     * // => true
  		     *
  		     * _.includes('abcd', 'bc');
  		     * // => true
  		     */
  		    function includes(collection, value, fromIndex, guard) {
  		      collection = isArrayLike(collection) ? collection : values(collection);
  		      fromIndex = (fromIndex && !guard) ? toInteger(fromIndex) : 0;

  		      var length = collection.length;
  		      if (fromIndex < 0) {
  		        fromIndex = nativeMax(length + fromIndex, 0);
  		      }
  		      return isString(collection)
  		        ? (fromIndex <= length && collection.indexOf(value, fromIndex) > -1)
  		        : (!!length && baseIndexOf(collection, value, fromIndex) > -1);
  		    }

  		    /**
  		     * Invokes the method at `path` of each element in `collection`, returning
  		     * an array of the results of each invoked method. Any additional arguments
  		     * are provided to each invoked method. If `path` is a function, it's invoked
  		     * for, and `this` bound to, each element in `collection`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Array|Function|string} path The path of the method to invoke or
  		     *  the function invoked per iteration.
  		     * @param {...*} [args] The arguments to invoke each method with.
  		     * @returns {Array} Returns the array of results.
  		     * @example
  		     *
  		     * _.invokeMap([[5, 1, 7], [3, 2, 1]], 'sort');
  		     * // => [[1, 5, 7], [1, 2, 3]]
  		     *
  		     * _.invokeMap([123, 456], String.prototype.split, '');
  		     * // => [['1', '2', '3'], ['4', '5', '6']]
  		     */
  		    var invokeMap = baseRest(function(collection, path, args) {
  		      var index = -1,
  		          isFunc = typeof path == 'function',
  		          result = isArrayLike(collection) ? Array(collection.length) : [];

  		      baseEach(collection, function(value) {
  		        result[++index] = isFunc ? apply(path, value, args) : baseInvoke(value, path, args);
  		      });
  		      return result;
  		    });

  		    /**
  		     * Creates an object composed of keys generated from the results of running
  		     * each element of `collection` thru `iteratee`. The corresponding value of
  		     * each key is the last element responsible for generating the key. The
  		     * iteratee is invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The iteratee to transform keys.
  		     * @returns {Object} Returns the composed aggregate object.
  		     * @example
  		     *
  		     * var array = [
  		     *   { 'dir': 'left', 'code': 97 },
  		     *   { 'dir': 'right', 'code': 100 }
  		     * ];
  		     *
  		     * _.keyBy(array, function(o) {
  		     *   return String.fromCharCode(o.code);
  		     * });
  		     * // => { 'a': { 'dir': 'left', 'code': 97 }, 'd': { 'dir': 'right', 'code': 100 } }
  		     *
  		     * _.keyBy(array, 'dir');
  		     * // => { 'left': { 'dir': 'left', 'code': 97 }, 'right': { 'dir': 'right', 'code': 100 } }
  		     */
  		    var keyBy = createAggregator(function(result, value, key) {
  		      baseAssignValue(result, key, value);
  		    });

  		    /**
  		     * Creates an array of values by running each element in `collection` thru
  		     * `iteratee`. The iteratee is invoked with three arguments:
  		     * (value, index|key, collection).
  		     *
  		     * Many lodash methods are guarded to work as iteratees for methods like
  		     * `_.every`, `_.filter`, `_.map`, `_.mapValues`, `_.reject`, and `_.some`.
  		     *
  		     * The guarded methods are:
  		     * `ary`, `chunk`, `curry`, `curryRight`, `drop`, `dropRight`, `every`,
  		     * `fill`, `invert`, `parseInt`, `random`, `range`, `rangeRight`, `repeat`,
  		     * `sampleSize`, `slice`, `some`, `sortBy`, `split`, `take`, `takeRight`,
  		     * `template`, `trim`, `trimEnd`, `trimStart`, and `words`
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new mapped array.
  		     * @example
  		     *
  		     * function square(n) {
  		     *   return n * n;
  		     * }
  		     *
  		     * _.map([4, 8], square);
  		     * // => [16, 64]
  		     *
  		     * _.map({ 'a': 4, 'b': 8 }, square);
  		     * // => [16, 64] (iteration order is not guaranteed)
  		     *
  		     * var users = [
  		     *   { 'user': 'barney' },
  		     *   { 'user': 'fred' }
  		     * ];
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.map(users, 'user');
  		     * // => ['barney', 'fred']
  		     */
  		    function map(collection, iteratee) {
  		      var func = isArray(collection) ? arrayMap : baseMap;
  		      return func(collection, getIteratee(iteratee, 3));
  		    }

  		    /**
  		     * This method is like `_.sortBy` except that it allows specifying the sort
  		     * orders of the iteratees to sort by. If `orders` is unspecified, all values
  		     * are sorted in ascending order. Otherwise, specify an order of "desc" for
  		     * descending or "asc" for ascending sort order of corresponding values.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Array[]|Function[]|Object[]|string[]} [iteratees=[_.identity]]
  		     *  The iteratees to sort by.
  		     * @param {string[]} [orders] The sort orders of `iteratees`.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.reduce`.
  		     * @returns {Array} Returns the new sorted array.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'fred',   'age': 48 },
  		     *   { 'user': 'barney', 'age': 34 },
  		     *   { 'user': 'fred',   'age': 40 },
  		     *   { 'user': 'barney', 'age': 36 }
  		     * ];
  		     *
  		     * // Sort by `user` in ascending order and by `age` in descending order.
  		     * _.orderBy(users, ['user', 'age'], ['asc', 'desc']);
  		     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 40]]
  		     */
  		    function orderBy(collection, iteratees, orders, guard) {
  		      if (collection == null) {
  		        return [];
  		      }
  		      if (!isArray(iteratees)) {
  		        iteratees = iteratees == null ? [] : [iteratees];
  		      }
  		      orders = guard ? undefined$1 : orders;
  		      if (!isArray(orders)) {
  		        orders = orders == null ? [] : [orders];
  		      }
  		      return baseOrderBy(collection, iteratees, orders);
  		    }

  		    /**
  		     * Creates an array of elements split into two groups, the first of which
  		     * contains elements `predicate` returns truthy for, the second of which
  		     * contains elements `predicate` returns falsey for. The predicate is
  		     * invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the array of grouped elements.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney',  'age': 36, 'active': false },
  		     *   { 'user': 'fred',    'age': 40, 'active': true },
  		     *   { 'user': 'pebbles', 'age': 1,  'active': false }
  		     * ];
  		     *
  		     * _.partition(users, function(o) { return o.active; });
  		     * // => objects for [['fred'], ['barney', 'pebbles']]
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.partition(users, { 'age': 1, 'active': false });
  		     * // => objects for [['pebbles'], ['barney', 'fred']]
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.partition(users, ['active', false]);
  		     * // => objects for [['barney', 'pebbles'], ['fred']]
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.partition(users, 'active');
  		     * // => objects for [['fred'], ['barney', 'pebbles']]
  		     */
  		    var partition = createAggregator(function(result, value, key) {
  		      result[key ? 0 : 1].push(value);
  		    }, function() { return [[], []]; });

  		    /**
  		     * Reduces `collection` to a value which is the accumulated result of running
  		     * each element in `collection` thru `iteratee`, where each successive
  		     * invocation is supplied the return value of the previous. If `accumulator`
  		     * is not given, the first element of `collection` is used as the initial
  		     * value. The iteratee is invoked with four arguments:
  		     * (accumulator, value, index|key, collection).
  		     *
  		     * Many lodash methods are guarded to work as iteratees for methods like
  		     * `_.reduce`, `_.reduceRight`, and `_.transform`.
  		     *
  		     * The guarded methods are:
  		     * `assign`, `defaults`, `defaultsDeep`, `includes`, `merge`, `orderBy`,
  		     * and `sortBy`
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @param {*} [accumulator] The initial value.
  		     * @returns {*} Returns the accumulated value.
  		     * @see _.reduceRight
  		     * @example
  		     *
  		     * _.reduce([1, 2], function(sum, n) {
  		     *   return sum + n;
  		     * }, 0);
  		     * // => 3
  		     *
  		     * _.reduce({ 'a': 1, 'b': 2, 'c': 1 }, function(result, value, key) {
  		     *   (result[value] || (result[value] = [])).push(key);
  		     *   return result;
  		     * }, {});
  		     * // => { '1': ['a', 'c'], '2': ['b'] } (iteration order is not guaranteed)
  		     */
  		    function reduce(collection, iteratee, accumulator) {
  		      var func = isArray(collection) ? arrayReduce : baseReduce,
  		          initAccum = arguments.length < 3;

  		      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEach);
  		    }

  		    /**
  		     * This method is like `_.reduce` except that it iterates over elements of
  		     * `collection` from right to left.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [iteratee=_.identity] The function invoked per iteration.
  		     * @param {*} [accumulator] The initial value.
  		     * @returns {*} Returns the accumulated value.
  		     * @see _.reduce
  		     * @example
  		     *
  		     * var array = [[0, 1], [2, 3], [4, 5]];
  		     *
  		     * _.reduceRight(array, function(flattened, other) {
  		     *   return flattened.concat(other);
  		     * }, []);
  		     * // => [4, 5, 2, 3, 0, 1]
  		     */
  		    function reduceRight(collection, iteratee, accumulator) {
  		      var func = isArray(collection) ? arrayReduceRight : baseReduce,
  		          initAccum = arguments.length < 3;

  		      return func(collection, getIteratee(iteratee, 4), accumulator, initAccum, baseEachRight);
  		    }

  		    /**
  		     * The opposite of `_.filter`; this method returns the elements of `collection`
  		     * that `predicate` does **not** return truthy for.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @returns {Array} Returns the new filtered array.
  		     * @see _.filter
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'barney', 'age': 36, 'active': false },
  		     *   { 'user': 'fred',   'age': 40, 'active': true }
  		     * ];
  		     *
  		     * _.reject(users, function(o) { return !o.active; });
  		     * // => objects for ['fred']
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.reject(users, { 'age': 40, 'active': true });
  		     * // => objects for ['barney']
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.reject(users, ['active', false]);
  		     * // => objects for ['fred']
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.reject(users, 'active');
  		     * // => objects for ['barney']
  		     */
  		    function reject(collection, predicate) {
  		      var func = isArray(collection) ? arrayFilter : baseFilter;
  		      return func(collection, negate(getIteratee(predicate, 3)));
  		    }

  		    /**
  		     * Gets a random element from `collection`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to sample.
  		     * @returns {*} Returns the random element.
  		     * @example
  		     *
  		     * _.sample([1, 2, 3, 4]);
  		     * // => 2
  		     */
  		    function sample(collection) {
  		      var func = isArray(collection) ? arraySample : baseSample;
  		      return func(collection);
  		    }

  		    /**
  		     * Gets `n` random elements at unique keys from `collection` up to the
  		     * size of `collection`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to sample.
  		     * @param {number} [n=1] The number of elements to sample.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Array} Returns the random elements.
  		     * @example
  		     *
  		     * _.sampleSize([1, 2, 3], 2);
  		     * // => [3, 1]
  		     *
  		     * _.sampleSize([1, 2, 3], 4);
  		     * // => [2, 3, 1]
  		     */
  		    function sampleSize(collection, n, guard) {
  		      if ((guard ? isIterateeCall(collection, n, guard) : n === undefined$1)) {
  		        n = 1;
  		      } else {
  		        n = toInteger(n);
  		      }
  		      var func = isArray(collection) ? arraySampleSize : baseSampleSize;
  		      return func(collection, n);
  		    }

  		    /**
  		     * Creates an array of shuffled values, using a version of the
  		     * [Fisher-Yates shuffle](https://en.wikipedia.org/wiki/Fisher-Yates_shuffle).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to shuffle.
  		     * @returns {Array} Returns the new shuffled array.
  		     * @example
  		     *
  		     * _.shuffle([1, 2, 3, 4]);
  		     * // => [4, 1, 3, 2]
  		     */
  		    function shuffle(collection) {
  		      var func = isArray(collection) ? arrayShuffle : baseShuffle;
  		      return func(collection);
  		    }

  		    /**
  		     * Gets the size of `collection` by returning its length for array-like
  		     * values or the number of own enumerable string keyed properties for objects.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object|string} collection The collection to inspect.
  		     * @returns {number} Returns the collection size.
  		     * @example
  		     *
  		     * _.size([1, 2, 3]);
  		     * // => 3
  		     *
  		     * _.size({ 'a': 1, 'b': 2 });
  		     * // => 2
  		     *
  		     * _.size('pebbles');
  		     * // => 7
  		     */
  		    function size(collection) {
  		      if (collection == null) {
  		        return 0;
  		      }
  		      if (isArrayLike(collection)) {
  		        return isString(collection) ? stringSize(collection) : collection.length;
  		      }
  		      var tag = getTag(collection);
  		      if (tag == mapTag || tag == setTag) {
  		        return collection.size;
  		      }
  		      return baseKeys(collection).length;
  		    }

  		    /**
  		     * Checks if `predicate` returns truthy for **any** element of `collection`.
  		     * Iteration is stopped once `predicate` returns truthy. The predicate is
  		     * invoked with three arguments: (value, index|key, collection).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {Function} [predicate=_.identity] The function invoked per iteration.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {boolean} Returns `true` if any element passes the predicate check,
  		     *  else `false`.
  		     * @example
  		     *
  		     * _.some([null, 0, 'yes', false], Boolean);
  		     * // => true
  		     *
  		     * var users = [
  		     *   { 'user': 'barney', 'active': true },
  		     *   { 'user': 'fred',   'active': false }
  		     * ];
  		     *
  		     * // The `_.matches` iteratee shorthand.
  		     * _.some(users, { 'user': 'barney', 'active': false });
  		     * // => false
  		     *
  		     * // The `_.matchesProperty` iteratee shorthand.
  		     * _.some(users, ['active', false]);
  		     * // => true
  		     *
  		     * // The `_.property` iteratee shorthand.
  		     * _.some(users, 'active');
  		     * // => true
  		     */
  		    function some(collection, predicate, guard) {
  		      var func = isArray(collection) ? arraySome : baseSome;
  		      if (guard && isIterateeCall(collection, predicate, guard)) {
  		        predicate = undefined$1;
  		      }
  		      return func(collection, getIteratee(predicate, 3));
  		    }

  		    /**
  		     * Creates an array of elements, sorted in ascending order by the results of
  		     * running each element in a collection thru each iteratee. This method
  		     * performs a stable sort, that is, it preserves the original sort order of
  		     * equal elements. The iteratees are invoked with one argument: (value).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Collection
  		     * @param {Array|Object} collection The collection to iterate over.
  		     * @param {...(Function|Function[])} [iteratees=[_.identity]]
  		     *  The iteratees to sort by.
  		     * @returns {Array} Returns the new sorted array.
  		     * @example
  		     *
  		     * var users = [
  		     *   { 'user': 'fred',   'age': 48 },
  		     *   { 'user': 'barney', 'age': 36 },
  		     *   { 'user': 'fred',   'age': 30 },
  		     *   { 'user': 'barney', 'age': 34 }
  		     * ];
  		     *
  		     * _.sortBy(users, [function(o) { return o.user; }]);
  		     * // => objects for [['barney', 36], ['barney', 34], ['fred', 48], ['fred', 30]]
  		     *
  		     * _.sortBy(users, ['user', 'age']);
  		     * // => objects for [['barney', 34], ['barney', 36], ['fred', 30], ['fred', 48]]
  		     */
  		    var sortBy = baseRest(function(collection, iteratees) {
  		      if (collection == null) {
  		        return [];
  		      }
  		      var length = iteratees.length;
  		      if (length > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
  		        iteratees = [];
  		      } else if (length > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
  		        iteratees = [iteratees[0]];
  		      }
  		      return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
  		    });

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Gets the timestamp of the number of milliseconds that have elapsed since
  		     * the Unix epoch (1 January 1970 00:00:00 UTC).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.4.0
  		     * @category Date
  		     * @returns {number} Returns the timestamp.
  		     * @example
  		     *
  		     * _.defer(function(stamp) {
  		     *   console.log(_.now() - stamp);
  		     * }, _.now());
  		     * // => Logs the number of milliseconds it took for the deferred invocation.
  		     */
  		    var now = ctxNow || function() {
  		      return root.Date.now();
  		    };

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * The opposite of `_.before`; this method creates a function that invokes
  		     * `func` once it's called `n` or more times.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {number} n The number of calls before `func` is invoked.
  		     * @param {Function} func The function to restrict.
  		     * @returns {Function} Returns the new restricted function.
  		     * @example
  		     *
  		     * var saves = ['profile', 'settings'];
  		     *
  		     * var done = _.after(saves.length, function() {
  		     *   console.log('done saving!');
  		     * });
  		     *
  		     * _.forEach(saves, function(type) {
  		     *   asyncSave({ 'type': type, 'complete': done });
  		     * });
  		     * // => Logs 'done saving!' after the two async saves have completed.
  		     */
  		    function after(n, func) {
  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      n = toInteger(n);
  		      return function() {
  		        if (--n < 1) {
  		          return func.apply(this, arguments);
  		        }
  		      };
  		    }

  		    /**
  		     * Creates a function that invokes `func`, with up to `n` arguments,
  		     * ignoring any additional arguments.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Function
  		     * @param {Function} func The function to cap arguments for.
  		     * @param {number} [n=func.length] The arity cap.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Function} Returns the new capped function.
  		     * @example
  		     *
  		     * _.map(['6', '8', '10'], _.ary(parseInt, 1));
  		     * // => [6, 8, 10]
  		     */
  		    function ary(func, n, guard) {
  		      n = guard ? undefined$1 : n;
  		      n = (func && n == null) ? func.length : n;
  		      return createWrap(func, WRAP_ARY_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, n);
  		    }

  		    /**
  		     * Creates a function that invokes `func`, with the `this` binding and arguments
  		     * of the created function, while it's called less than `n` times. Subsequent
  		     * calls to the created function return the result of the last `func` invocation.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Function
  		     * @param {number} n The number of calls at which `func` is no longer invoked.
  		     * @param {Function} func The function to restrict.
  		     * @returns {Function} Returns the new restricted function.
  		     * @example
  		     *
  		     * jQuery(element).on('click', _.before(5, addContactToList));
  		     * // => Allows adding up to 4 contacts to the list.
  		     */
  		    function before(n, func) {
  		      var result;
  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      n = toInteger(n);
  		      return function() {
  		        if (--n > 0) {
  		          result = func.apply(this, arguments);
  		        }
  		        if (n <= 1) {
  		          func = undefined$1;
  		        }
  		        return result;
  		      };
  		    }

  		    /**
  		     * Creates a function that invokes `func` with the `this` binding of `thisArg`
  		     * and `partials` prepended to the arguments it receives.
  		     *
  		     * The `_.bind.placeholder` value, which defaults to `_` in monolithic builds,
  		     * may be used as a placeholder for partially applied arguments.
  		     *
  		     * **Note:** Unlike native `Function#bind`, this method doesn't set the "length"
  		     * property of bound functions.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to bind.
  		     * @param {*} thisArg The `this` binding of `func`.
  		     * @param {...*} [partials] The arguments to be partially applied.
  		     * @returns {Function} Returns the new bound function.
  		     * @example
  		     *
  		     * function greet(greeting, punctuation) {
  		     *   return greeting + ' ' + this.user + punctuation;
  		     * }
  		     *
  		     * var object = { 'user': 'fred' };
  		     *
  		     * var bound = _.bind(greet, object, 'hi');
  		     * bound('!');
  		     * // => 'hi fred!'
  		     *
  		     * // Bound with placeholders.
  		     * var bound = _.bind(greet, object, _, '!');
  		     * bound('hi');
  		     * // => 'hi fred!'
  		     */
  		    var bind = baseRest(function(func, thisArg, partials) {
  		      var bitmask = WRAP_BIND_FLAG;
  		      if (partials.length) {
  		        var holders = replaceHolders(partials, getHolder(bind));
  		        bitmask |= WRAP_PARTIAL_FLAG;
  		      }
  		      return createWrap(func, bitmask, thisArg, partials, holders);
  		    });

  		    /**
  		     * Creates a function that invokes the method at `object[key]` with `partials`
  		     * prepended to the arguments it receives.
  		     *
  		     * This method differs from `_.bind` by allowing bound functions to reference
  		     * methods that may be redefined or don't yet exist. See
  		     * [Peter Michaux's article](http://peter.michaux.ca/articles/lazy-function-definition-pattern)
  		     * for more details.
  		     *
  		     * The `_.bindKey.placeholder` value, which defaults to `_` in monolithic
  		     * builds, may be used as a placeholder for partially applied arguments.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.10.0
  		     * @category Function
  		     * @param {Object} object The object to invoke the method on.
  		     * @param {string} key The key of the method.
  		     * @param {...*} [partials] The arguments to be partially applied.
  		     * @returns {Function} Returns the new bound function.
  		     * @example
  		     *
  		     * var object = {
  		     *   'user': 'fred',
  		     *   'greet': function(greeting, punctuation) {
  		     *     return greeting + ' ' + this.user + punctuation;
  		     *   }
  		     * };
  		     *
  		     * var bound = _.bindKey(object, 'greet', 'hi');
  		     * bound('!');
  		     * // => 'hi fred!'
  		     *
  		     * object.greet = function(greeting, punctuation) {
  		     *   return greeting + 'ya ' + this.user + punctuation;
  		     * };
  		     *
  		     * bound('!');
  		     * // => 'hiya fred!'
  		     *
  		     * // Bound with placeholders.
  		     * var bound = _.bindKey(object, 'greet', _, '!');
  		     * bound('hi');
  		     * // => 'hiya fred!'
  		     */
  		    var bindKey = baseRest(function(object, key, partials) {
  		      var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
  		      if (partials.length) {
  		        var holders = replaceHolders(partials, getHolder(bindKey));
  		        bitmask |= WRAP_PARTIAL_FLAG;
  		      }
  		      return createWrap(key, bitmask, object, partials, holders);
  		    });

  		    /**
  		     * Creates a function that accepts arguments of `func` and either invokes
  		     * `func` returning its result, if at least `arity` number of arguments have
  		     * been provided, or returns a function that accepts the remaining `func`
  		     * arguments, and so on. The arity of `func` may be specified if `func.length`
  		     * is not sufficient.
  		     *
  		     * The `_.curry.placeholder` value, which defaults to `_` in monolithic builds,
  		     * may be used as a placeholder for provided arguments.
  		     *
  		     * **Note:** This method doesn't set the "length" property of curried functions.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 2.0.0
  		     * @category Function
  		     * @param {Function} func The function to curry.
  		     * @param {number} [arity=func.length] The arity of `func`.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Function} Returns the new curried function.
  		     * @example
  		     *
  		     * var abc = function(a, b, c) {
  		     *   return [a, b, c];
  		     * };
  		     *
  		     * var curried = _.curry(abc);
  		     *
  		     * curried(1)(2)(3);
  		     * // => [1, 2, 3]
  		     *
  		     * curried(1, 2)(3);
  		     * // => [1, 2, 3]
  		     *
  		     * curried(1, 2, 3);
  		     * // => [1, 2, 3]
  		     *
  		     * // Curried with placeholders.
  		     * curried(1)(_, 3)(2);
  		     * // => [1, 2, 3]
  		     */
  		    function curry(func, arity, guard) {
  		      arity = guard ? undefined$1 : arity;
  		      var result = createWrap(func, WRAP_CURRY_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, undefined$1, arity);
  		      result.placeholder = curry.placeholder;
  		      return result;
  		    }

  		    /**
  		     * This method is like `_.curry` except that arguments are applied to `func`
  		     * in the manner of `_.partialRight` instead of `_.partial`.
  		     *
  		     * The `_.curryRight.placeholder` value, which defaults to `_` in monolithic
  		     * builds, may be used as a placeholder for provided arguments.
  		     *
  		     * **Note:** This method doesn't set the "length" property of curried functions.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Function
  		     * @param {Function} func The function to curry.
  		     * @param {number} [arity=func.length] The arity of `func`.
  		     * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
  		     * @returns {Function} Returns the new curried function.
  		     * @example
  		     *
  		     * var abc = function(a, b, c) {
  		     *   return [a, b, c];
  		     * };
  		     *
  		     * var curried = _.curryRight(abc);
  		     *
  		     * curried(3)(2)(1);
  		     * // => [1, 2, 3]
  		     *
  		     * curried(2, 3)(1);
  		     * // => [1, 2, 3]
  		     *
  		     * curried(1, 2, 3);
  		     * // => [1, 2, 3]
  		     *
  		     * // Curried with placeholders.
  		     * curried(3)(1, _)(2);
  		     * // => [1, 2, 3]
  		     */
  		    function curryRight(func, arity, guard) {
  		      arity = guard ? undefined$1 : arity;
  		      var result = createWrap(func, WRAP_CURRY_RIGHT_FLAG, undefined$1, undefined$1, undefined$1, undefined$1, undefined$1, arity);
  		      result.placeholder = curryRight.placeholder;
  		      return result;
  		    }

  		    /**
  		     * Creates a debounced function that delays invoking `func` until after `wait`
  		     * milliseconds have elapsed since the last time the debounced function was
  		     * invoked. The debounced function comes with a `cancel` method to cancel
  		     * delayed `func` invocations and a `flush` method to immediately invoke them.
  		     * Provide `options` to indicate whether `func` should be invoked on the
  		     * leading and/or trailing edge of the `wait` timeout. The `func` is invoked
  		     * with the last arguments provided to the debounced function. Subsequent
  		     * calls to the debounced function return the result of the last `func`
  		     * invocation.
  		     *
  		     * **Note:** If `leading` and `trailing` options are `true`, `func` is
  		     * invoked on the trailing edge of the timeout only if the debounced function
  		     * is invoked more than once during the `wait` timeout.
  		     *
  		     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
  		     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
  		     *
  		     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
  		     * for details over the differences between `_.debounce` and `_.throttle`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to debounce.
  		     * @param {number} [wait=0] The number of milliseconds to delay.
  		     * @param {Object} [options={}] The options object.
  		     * @param {boolean} [options.leading=false]
  		     *  Specify invoking on the leading edge of the timeout.
  		     * @param {number} [options.maxWait]
  		     *  The maximum time `func` is allowed to be delayed before it's invoked.
  		     * @param {boolean} [options.trailing=true]
  		     *  Specify invoking on the trailing edge of the timeout.
  		     * @returns {Function} Returns the new debounced function.
  		     * @example
  		     *
  		     * // Avoid costly calculations while the window size is in flux.
  		     * jQuery(window).on('resize', _.debounce(calculateLayout, 150));
  		     *
  		     * // Invoke `sendMail` when clicked, debouncing subsequent calls.
  		     * jQuery(element).on('click', _.debounce(sendMail, 300, {
  		     *   'leading': true,
  		     *   'trailing': false
  		     * }));
  		     *
  		     * // Ensure `batchLog` is invoked once after 1 second of debounced calls.
  		     * var debounced = _.debounce(batchLog, 250, { 'maxWait': 1000 });
  		     * var source = new EventSource('/stream');
  		     * jQuery(source).on('message', debounced);
  		     *
  		     * // Cancel the trailing debounced invocation.
  		     * jQuery(window).on('popstate', debounced.cancel);
  		     */
  		    function debounce(func, wait, options) {
  		      var lastArgs,
  		          lastThis,
  		          maxWait,
  		          result,
  		          timerId,
  		          lastCallTime,
  		          lastInvokeTime = 0,
  		          leading = false,
  		          maxing = false,
  		          trailing = true;

  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      wait = toNumber(wait) || 0;
  		      if (isObject(options)) {
  		        leading = !!options.leading;
  		        maxing = 'maxWait' in options;
  		        maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
  		        trailing = 'trailing' in options ? !!options.trailing : trailing;
  		      }

  		      function invokeFunc(time) {
  		        var args = lastArgs,
  		            thisArg = lastThis;

  		        lastArgs = lastThis = undefined$1;
  		        lastInvokeTime = time;
  		        result = func.apply(thisArg, args);
  		        return result;
  		      }

  		      function leadingEdge(time) {
  		        // Reset any `maxWait` timer.
  		        lastInvokeTime = time;
  		        // Start the timer for the trailing edge.
  		        timerId = setTimeout(timerExpired, wait);
  		        // Invoke the leading edge.
  		        return leading ? invokeFunc(time) : result;
  		      }

  		      function remainingWait(time) {
  		        var timeSinceLastCall = time - lastCallTime,
  		            timeSinceLastInvoke = time - lastInvokeTime,
  		            timeWaiting = wait - timeSinceLastCall;

  		        return maxing
  		          ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
  		          : timeWaiting;
  		      }

  		      function shouldInvoke(time) {
  		        var timeSinceLastCall = time - lastCallTime,
  		            timeSinceLastInvoke = time - lastInvokeTime;

  		        // Either this is the first call, activity has stopped and we're at the
  		        // trailing edge, the system time has gone backwards and we're treating
  		        // it as the trailing edge, or we've hit the `maxWait` limit.
  		        return (lastCallTime === undefined$1 || (timeSinceLastCall >= wait) ||
  		          (timeSinceLastCall < 0) || (maxing && timeSinceLastInvoke >= maxWait));
  		      }

  		      function timerExpired() {
  		        var time = now();
  		        if (shouldInvoke(time)) {
  		          return trailingEdge(time);
  		        }
  		        // Restart the timer.
  		        timerId = setTimeout(timerExpired, remainingWait(time));
  		      }

  		      function trailingEdge(time) {
  		        timerId = undefined$1;

  		        // Only invoke if we have `lastArgs` which means `func` has been
  		        // debounced at least once.
  		        if (trailing && lastArgs) {
  		          return invokeFunc(time);
  		        }
  		        lastArgs = lastThis = undefined$1;
  		        return result;
  		      }

  		      function cancel() {
  		        if (timerId !== undefined$1) {
  		          clearTimeout(timerId);
  		        }
  		        lastInvokeTime = 0;
  		        lastArgs = lastCallTime = lastThis = timerId = undefined$1;
  		      }

  		      function flush() {
  		        return timerId === undefined$1 ? result : trailingEdge(now());
  		      }

  		      function debounced() {
  		        var time = now(),
  		            isInvoking = shouldInvoke(time);

  		        lastArgs = arguments;
  		        lastThis = this;
  		        lastCallTime = time;

  		        if (isInvoking) {
  		          if (timerId === undefined$1) {
  		            return leadingEdge(lastCallTime);
  		          }
  		          if (maxing) {
  		            // Handle invocations in a tight loop.
  		            clearTimeout(timerId);
  		            timerId = setTimeout(timerExpired, wait);
  		            return invokeFunc(lastCallTime);
  		          }
  		        }
  		        if (timerId === undefined$1) {
  		          timerId = setTimeout(timerExpired, wait);
  		        }
  		        return result;
  		      }
  		      debounced.cancel = cancel;
  		      debounced.flush = flush;
  		      return debounced;
  		    }

  		    /**
  		     * Defers invoking the `func` until the current call stack has cleared. Any
  		     * additional arguments are provided to `func` when it's invoked.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to defer.
  		     * @param {...*} [args] The arguments to invoke `func` with.
  		     * @returns {number} Returns the timer id.
  		     * @example
  		     *
  		     * _.defer(function(text) {
  		     *   console.log(text);
  		     * }, 'deferred');
  		     * // => Logs 'deferred' after one millisecond.
  		     */
  		    var defer = baseRest(function(func, args) {
  		      return baseDelay(func, 1, args);
  		    });

  		    /**
  		     * Invokes `func` after `wait` milliseconds. Any additional arguments are
  		     * provided to `func` when it's invoked.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to delay.
  		     * @param {number} wait The number of milliseconds to delay invocation.
  		     * @param {...*} [args] The arguments to invoke `func` with.
  		     * @returns {number} Returns the timer id.
  		     * @example
  		     *
  		     * _.delay(function(text) {
  		     *   console.log(text);
  		     * }, 1000, 'later');
  		     * // => Logs 'later' after one second.
  		     */
  		    var delay = baseRest(function(func, wait, args) {
  		      return baseDelay(func, toNumber(wait) || 0, args);
  		    });

  		    /**
  		     * Creates a function that invokes `func` with arguments reversed.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Function
  		     * @param {Function} func The function to flip arguments for.
  		     * @returns {Function} Returns the new flipped function.
  		     * @example
  		     *
  		     * var flipped = _.flip(function() {
  		     *   return _.toArray(arguments);
  		     * });
  		     *
  		     * flipped('a', 'b', 'c', 'd');
  		     * // => ['d', 'c', 'b', 'a']
  		     */
  		    function flip(func) {
  		      return createWrap(func, WRAP_FLIP_FLAG);
  		    }

  		    /**
  		     * Creates a function that memoizes the result of `func`. If `resolver` is
  		     * provided, it determines the cache key for storing the result based on the
  		     * arguments provided to the memoized function. By default, the first argument
  		     * provided to the memoized function is used as the map cache key. The `func`
  		     * is invoked with the `this` binding of the memoized function.
  		     *
  		     * **Note:** The cache is exposed as the `cache` property on the memoized
  		     * function. Its creation may be customized by replacing the `_.memoize.Cache`
  		     * constructor with one whose instances implement the
  		     * [`Map`](http://ecma-international.org/ecma-262/7.0/#sec-properties-of-the-map-prototype-object)
  		     * method interface of `clear`, `delete`, `get`, `has`, and `set`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to have its output memoized.
  		     * @param {Function} [resolver] The function to resolve the cache key.
  		     * @returns {Function} Returns the new memoized function.
  		     * @example
  		     *
  		     * var object = { 'a': 1, 'b': 2 };
  		     * var other = { 'c': 3, 'd': 4 };
  		     *
  		     * var values = _.memoize(_.values);
  		     * values(object);
  		     * // => [1, 2]
  		     *
  		     * values(other);
  		     * // => [3, 4]
  		     *
  		     * object.a = 2;
  		     * values(object);
  		     * // => [1, 2]
  		     *
  		     * // Modify the result cache.
  		     * values.cache.set(object, ['a', 'b']);
  		     * values(object);
  		     * // => ['a', 'b']
  		     *
  		     * // Replace `_.memoize.Cache`.
  		     * _.memoize.Cache = WeakMap;
  		     */
  		    function memoize(func, resolver) {
  		      if (typeof func != 'function' || (resolver != null && typeof resolver != 'function')) {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      var memoized = function() {
  		        var args = arguments,
  		            key = resolver ? resolver.apply(this, args) : args[0],
  		            cache = memoized.cache;

  		        if (cache.has(key)) {
  		          return cache.get(key);
  		        }
  		        var result = func.apply(this, args);
  		        memoized.cache = cache.set(key, result) || cache;
  		        return result;
  		      };
  		      memoized.cache = new (memoize.Cache || MapCache);
  		      return memoized;
  		    }

  		    // Expose `MapCache`.
  		    memoize.Cache = MapCache;

  		    /**
  		     * Creates a function that negates the result of the predicate `func`. The
  		     * `func` predicate is invoked with the `this` binding and arguments of the
  		     * created function.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Function
  		     * @param {Function} predicate The predicate to negate.
  		     * @returns {Function} Returns the new negated function.
  		     * @example
  		     *
  		     * function isEven(n) {
  		     *   return n % 2 == 0;
  		     * }
  		     *
  		     * _.filter([1, 2, 3, 4, 5, 6], _.negate(isEven));
  		     * // => [1, 3, 5]
  		     */
  		    function negate(predicate) {
  		      if (typeof predicate != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      return function() {
  		        var args = arguments;
  		        switch (args.length) {
  		          case 0: return !predicate.call(this);
  		          case 1: return !predicate.call(this, args[0]);
  		          case 2: return !predicate.call(this, args[0], args[1]);
  		          case 3: return !predicate.call(this, args[0], args[1], args[2]);
  		        }
  		        return !predicate.apply(this, args);
  		      };
  		    }

  		    /**
  		     * Creates a function that is restricted to invoking `func` once. Repeat calls
  		     * to the function return the value of the first invocation. The `func` is
  		     * invoked with the `this` binding and arguments of the created function.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to restrict.
  		     * @returns {Function} Returns the new restricted function.
  		     * @example
  		     *
  		     * var initialize = _.once(createApplication);
  		     * initialize();
  		     * initialize();
  		     * // => `createApplication` is invoked once
  		     */
  		    function once(func) {
  		      return before(2, func);
  		    }

  		    /**
  		     * Creates a function that invokes `func` with its arguments transformed.
  		     *
  		     * @static
  		     * @since 4.0.0
  		     * @memberOf _
  		     * @category Function
  		     * @param {Function} func The function to wrap.
  		     * @param {...(Function|Function[])} [transforms=[_.identity]]
  		     *  The argument transforms.
  		     * @returns {Function} Returns the new function.
  		     * @example
  		     *
  		     * function doubled(n) {
  		     *   return n * 2;
  		     * }
  		     *
  		     * function square(n) {
  		     *   return n * n;
  		     * }
  		     *
  		     * var func = _.overArgs(function(x, y) {
  		     *   return [x, y];
  		     * }, [square, doubled]);
  		     *
  		     * func(9, 3);
  		     * // => [81, 6]
  		     *
  		     * func(10, 5);
  		     * // => [100, 10]
  		     */
  		    var overArgs = castRest(function(func, transforms) {
  		      transforms = (transforms.length == 1 && isArray(transforms[0]))
  		        ? arrayMap(transforms[0], baseUnary(getIteratee()))
  		        : arrayMap(baseFlatten(transforms, 1), baseUnary(getIteratee()));

  		      var funcsLength = transforms.length;
  		      return baseRest(function(args) {
  		        var index = -1,
  		            length = nativeMin(args.length, funcsLength);

  		        while (++index < length) {
  		          args[index] = transforms[index].call(this, args[index]);
  		        }
  		        return apply(func, this, args);
  		      });
  		    });

  		    /**
  		     * Creates a function that invokes `func` with `partials` prepended to the
  		     * arguments it receives. This method is like `_.bind` except it does **not**
  		     * alter the `this` binding.
  		     *
  		     * The `_.partial.placeholder` value, which defaults to `_` in monolithic
  		     * builds, may be used as a placeholder for partially applied arguments.
  		     *
  		     * **Note:** This method doesn't set the "length" property of partially
  		     * applied functions.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.2.0
  		     * @category Function
  		     * @param {Function} func The function to partially apply arguments to.
  		     * @param {...*} [partials] The arguments to be partially applied.
  		     * @returns {Function} Returns the new partially applied function.
  		     * @example
  		     *
  		     * function greet(greeting, name) {
  		     *   return greeting + ' ' + name;
  		     * }
  		     *
  		     * var sayHelloTo = _.partial(greet, 'hello');
  		     * sayHelloTo('fred');
  		     * // => 'hello fred'
  		     *
  		     * // Partially applied with placeholders.
  		     * var greetFred = _.partial(greet, _, 'fred');
  		     * greetFred('hi');
  		     * // => 'hi fred'
  		     */
  		    var partial = baseRest(function(func, partials) {
  		      var holders = replaceHolders(partials, getHolder(partial));
  		      return createWrap(func, WRAP_PARTIAL_FLAG, undefined$1, partials, holders);
  		    });

  		    /**
  		     * This method is like `_.partial` except that partially applied arguments
  		     * are appended to the arguments it receives.
  		     *
  		     * The `_.partialRight.placeholder` value, which defaults to `_` in monolithic
  		     * builds, may be used as a placeholder for partially applied arguments.
  		     *
  		     * **Note:** This method doesn't set the "length" property of partially
  		     * applied functions.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 1.0.0
  		     * @category Function
  		     * @param {Function} func The function to partially apply arguments to.
  		     * @param {...*} [partials] The arguments to be partially applied.
  		     * @returns {Function} Returns the new partially applied function.
  		     * @example
  		     *
  		     * function greet(greeting, name) {
  		     *   return greeting + ' ' + name;
  		     * }
  		     *
  		     * var greetFred = _.partialRight(greet, 'fred');
  		     * greetFred('hi');
  		     * // => 'hi fred'
  		     *
  		     * // Partially applied with placeholders.
  		     * var sayHelloTo = _.partialRight(greet, 'hello', _);
  		     * sayHelloTo('fred');
  		     * // => 'hello fred'
  		     */
  		    var partialRight = baseRest(function(func, partials) {
  		      var holders = replaceHolders(partials, getHolder(partialRight));
  		      return createWrap(func, WRAP_PARTIAL_RIGHT_FLAG, undefined$1, partials, holders);
  		    });

  		    /**
  		     * Creates a function that invokes `func` with arguments arranged according
  		     * to the specified `indexes` where the argument value at the first index is
  		     * provided as the first argument, the argument value at the second index is
  		     * provided as the second argument, and so on.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.0.0
  		     * @category Function
  		     * @param {Function} func The function to rearrange arguments for.
  		     * @param {...(number|number[])} indexes The arranged argument indexes.
  		     * @returns {Function} Returns the new function.
  		     * @example
  		     *
  		     * var rearged = _.rearg(function(a, b, c) {
  		     *   return [a, b, c];
  		     * }, [2, 0, 1]);
  		     *
  		     * rearged('b', 'c', 'a')
  		     * // => ['a', 'b', 'c']
  		     */
  		    var rearg = flatRest(function(func, indexes) {
  		      return createWrap(func, WRAP_REARG_FLAG, undefined$1, undefined$1, undefined$1, indexes);
  		    });

  		    /**
  		     * Creates a function that invokes `func` with the `this` binding of the
  		     * created function and arguments from `start` and beyond provided as
  		     * an array.
  		     *
  		     * **Note:** This method is based on the
  		     * [rest parameter](https://mdn.io/rest_parameters).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Function
  		     * @param {Function} func The function to apply a rest parameter to.
  		     * @param {number} [start=func.length-1] The start position of the rest parameter.
  		     * @returns {Function} Returns the new function.
  		     * @example
  		     *
  		     * var say = _.rest(function(what, names) {
  		     *   return what + ' ' + _.initial(names).join(', ') +
  		     *     (_.size(names) > 1 ? ', & ' : '') + _.last(names);
  		     * });
  		     *
  		     * say('hello', 'fred', 'barney', 'pebbles');
  		     * // => 'hello fred, barney, & pebbles'
  		     */
  		    function rest(func, start) {
  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      start = start === undefined$1 ? start : toInteger(start);
  		      return baseRest(func, start);
  		    }

  		    /**
  		     * Creates a function that invokes `func` with the `this` binding of the
  		     * create function and an array of arguments much like
  		     * [`Function#apply`](http://www.ecma-international.org/ecma-262/7.0/#sec-function.prototype.apply).
  		     *
  		     * **Note:** This method is based on the
  		     * [spread operator](https://mdn.io/spread_operator).
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 3.2.0
  		     * @category Function
  		     * @param {Function} func The function to spread arguments over.
  		     * @param {number} [start=0] The start position of the spread.
  		     * @returns {Function} Returns the new function.
  		     * @example
  		     *
  		     * var say = _.spread(function(who, what) {
  		     *   return who + ' says ' + what;
  		     * });
  		     *
  		     * say(['fred', 'hello']);
  		     * // => 'fred says hello'
  		     *
  		     * var numbers = Promise.all([
  		     *   Promise.resolve(40),
  		     *   Promise.resolve(36)
  		     * ]);
  		     *
  		     * numbers.then(_.spread(function(x, y) {
  		     *   return x + y;
  		     * }));
  		     * // => a Promise of 76
  		     */
  		    function spread(func, start) {
  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      start = start == null ? 0 : nativeMax(toInteger(start), 0);
  		      return baseRest(function(args) {
  		        var array = args[start],
  		            otherArgs = castSlice(args, 0, start);

  		        if (array) {
  		          arrayPush(otherArgs, array);
  		        }
  		        return apply(func, this, otherArgs);
  		      });
  		    }

  		    /**
  		     * Creates a throttled function that only invokes `func` at most once per
  		     * every `wait` milliseconds. The throttled function comes with a `cancel`
  		     * method to cancel delayed `func` invocations and a `flush` method to
  		     * immediately invoke them. Provide `options` to indicate whether `func`
  		     * should be invoked on the leading and/or trailing edge of the `wait`
  		     * timeout. The `func` is invoked with the last arguments provided to the
  		     * throttled function. Subsequent calls to the throttled function return the
  		     * result of the last `func` invocation.
  		     *
  		     * **Note:** If `leading` and `trailing` options are `true`, `func` is
  		     * invoked on the trailing edge of the timeout only if the throttled function
  		     * is invoked more than once during the `wait` timeout.
  		     *
  		     * If `wait` is `0` and `leading` is `false`, `func` invocation is deferred
  		     * until to the next tick, similar to `setTimeout` with a timeout of `0`.
  		     *
  		     * See [David Corbacho's article](https://css-tricks.com/debouncing-throttling-explained-examples/)
  		     * for details over the differences between `_.throttle` and `_.debounce`.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {Function} func The function to throttle.
  		     * @param {number} [wait=0] The number of milliseconds to throttle invocations to.
  		     * @param {Object} [options={}] The options object.
  		     * @param {boolean} [options.leading=true]
  		     *  Specify invoking on the leading edge of the timeout.
  		     * @param {boolean} [options.trailing=true]
  		     *  Specify invoking on the trailing edge of the timeout.
  		     * @returns {Function} Returns the new throttled function.
  		     * @example
  		     *
  		     * // Avoid excessively updating the position while scrolling.
  		     * jQuery(window).on('scroll', _.throttle(updatePosition, 100));
  		     *
  		     * // Invoke `renewToken` when the click event is fired, but not more than once every 5 minutes.
  		     * var throttled = _.throttle(renewToken, 300000, { 'trailing': false });
  		     * jQuery(element).on('click', throttled);
  		     *
  		     * // Cancel the trailing throttled invocation.
  		     * jQuery(window).on('popstate', throttled.cancel);
  		     */
  		    function throttle(func, wait, options) {
  		      var leading = true,
  		          trailing = true;

  		      if (typeof func != 'function') {
  		        throw new TypeError(FUNC_ERROR_TEXT);
  		      }
  		      if (isObject(options)) {
  		        leading = 'leading' in options ? !!options.leading : leading;
  		        trailing = 'trailing' in options ? !!options.trailing : trailing;
  		      }
  		      return debounce(func, wait, {
  		        'leading': leading,
  		        'maxWait': wait,
  		        'trailing': trailing
  		      });
  		    }

  		    /**
  		     * Creates a function that accepts up to one argument, ignoring any
  		     * additional arguments.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.0.0
  		     * @category Function
  		     * @param {Function} func The function to cap arguments for.
  		     * @returns {Function} Returns the new capped function.
  		     * @example
  		     *
  		     * _.map(['6', '8', '10'], _.unary(parseInt));
  		     * // => [6, 8, 10]
  		     */
  		    function unary(func) {
  		      return ary(func, 1);
  		    }

  		    /**
  		     * Creates a function that provides `value` to `wrapper` as its first
  		     * argument. Any additional arguments provided to the function are appended
  		     * to those provided to the `wrapper`. The wrapper is invoked with the `this`
  		     * binding of the created function.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Function
  		     * @param {*} value The value to wrap.
  		     * @param {Function} [wrapper=identity] The wrapper function.
  		     * @returns {Function} Returns the new function.
  		     * @example
  		     *
  		     * var p = _.wrap(_.escape, function(func, text) {
  		     *   return '<p>' + func(text) + '</p>';
  		     * });
  		     *
  		     * p('fred, barney, & pebbles');
  		     * // => '<p>fred, barney, &amp; pebbles</p>'
  		     */
  		    function wrap(value, wrapper) {
  		      return partial(castFunction(wrapper), value);
  		    }

  		    /*------------------------------------------------------------------------*/

  		    /**
  		     * Casts `value` as an array if it's not one.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 4.4.0
  		     * @category Lang
  		     * @param {*} value The value to inspect.
  		     * @returns {Array} Returns the cast array.
  		     * @example
  		     *
  		     * _.castArray(1);
  		     * // => [1]
  		     *
  		     * _.castArray({ 'a': 1 });
  		     * // => [{ 'a': 1 }]
  		     *
  		     * _.castArray('abc');
  		     * // => ['abc']
  		     *
  		     * _.castArray(null);
  		     * // => [null]
  		     *
  		     * _.castArray(undefined);
  		     * // => [undefined]
  		     *
  		     * _.castArray();
  		     * // => []
  		     *
  		     * var array = [1, 2, 3];
  		     * console.log(_.castArray(array) === array);
  		     * // => true
  		     */
  		    function castArray() {
  		      if (!arguments.length) {
  		        return [];
  		      }
  		      var value = arguments[0];
  		      return isArray(value) ? value : [value];
  		    }

  		    /**
  		     * Creates a shallow clone of `value`.
  		     *
  		     * **Note:** This method is loosely based on the
  		     * [structured clone algorithm](https://mdn.io/Structured_clone_algorithm)
  		     * and supports cloning arrays, array buffers, booleans, date objects, maps,
  		     * numbers, `Object` objects, regexes, sets, strings, symbols, and typed
  		     * arrays. The own enumerable properties of `arguments` objects are cloned
  		     * as plain objects. An empty object is returned for uncloneable values such
  		     * as error objects, functions, DOM nodes, and WeakMaps.
  		     *
  		     * @static
  		     * @memberOf _
  		     * @since 0.1.0
  		     * @category Lang
  		     * @param {*} value The value to clone.
  		     * @returns {*} Returns the cloned value.
  		     * @see _.cloneDeep
  		     * @example
  		     *
  		     * var objects = [{ 'a': 1 }, { 'b': 2 }];
  		     *
  		     * var shallow = _.clone(objects);
  		     * console.log(shallo